//【登録場所】 全体、レス表示、選択テキスト
//【ラベル】 Google/DeepL翻訳ポップアップ
//【コマンド1】 ${SCRIPT:STc} goopL_translation.js //自動判定⇒日本語
//【コマンド2】 ${SCRIPT:STc} goopL_translation.js enja //英語⇒日本語
//【コマンド3】 ${SCRIPT:STc} goopL_translation.js jaen //日本語⇒英語
//【コマンド4】 ${SCRIPT:STc} goopL_translation.js chja //中国語(簡体字)⇒日本語
//【コマンド5】 ${SCRIPT:STc} goopL_translation.js chjab //中国語(繁体字)⇒日本語 (DeepL翻訳の場合は「中国語(簡体字)⇒日本語」となる)
//【コマンド6】 ${SCRIPT:STc} goopL_translation.js koja //韓国語⇒日本語
//【コマンド7】 ${SCRIPT:STc} goopL_translation.js frja //フランス語⇒日本語
//【コマンド8】 ${SCRIPT:STc} goopL_translation.js deja //ドイツ語⇒日本語
//【コマンド9】 ${SCRIPT:STc} goopL_translation.js itja //イタリア語⇒日本語
//【コマンド10】 ${SCRIPT:STc} goopL_translation.js esja //スペイン語⇒日本語
//【コマンド11】 ${SCRIPT:STc} goopL_translation.js ptja //ポルトガル語⇒日本語
//【コマンド12】 ${SCRIPT:STc} goopL_translation.js ruja //ロシア語⇒日本語
//【コマンド13】 ${SCRIPT:STc} goopL_translation.js arja //アラビア語⇒日本語
//【コマンド14】 ${SCRIPT:STc} goopL_translation.js menu //コマンド1～13のメニュー表示
//【コマンド15】 ${SCRIPT:STc} goopL_translation.js xx,xx //フリー形式、言語シンボルを半角カンマで区切る、前が元言語、後ろが翻訳対象言語

// google翻訳の場合は「${SCRIPT:STc} goopL_translation.js menu google」(末尾に半角空白+google)
// DeepL翻訳の場合は「${SCRIPT:STc} goopL_translation.js menu DeepL」(末尾に半角空白+DeepL)
// 末尾に何も付けない場合はgoogleとDeepLの両方で翻訳

//【スクリプト】
// ----- 次の行から -----
//設定
var DeepL_auth_key = 'ef3604c8-c176-4845-bd63-e701cc8653cb:fx';
var DeepL_formality = 'default';	/* default or more or less or prefer_more or prefer_less */

var translator = '';
var translate = '';
var clipboard_CR = '';
var post_url = '';
var china_menu2 = '';
var data = {};

function setParams(action){
	if(action == 'google'){
		translator = 'google';
		translate = 'https://translate.googleapis.com/translate_a/single?client=gtx';
		post_url = 'http://www.google.com/translate_t';
		china_menu2 = '(繁)';
		data = {
			'enja'  : ['&sl=en&tl=ja'],
			'jaen'  : ['&sl=ja&tl=en'],
			'chja'  : ['&sl=zh-CN&tl=ja'],
			'chjab' : ['&sl=zh-TW&tl=ja'],
			'koja'  : ['&sl=ko&tl=ja'],
			'frja'  : ['&sl=fr&tl=ja'],
			'deja'  : ['&sl=de&tl=ja'],
//			'itja'  : ['&sl=ita&tl=ja'],
			'itja'  : ['&sl=it&tl=ja'],
			'esja'  : ['&sl=es&tl=ja'],
			'ptja'  : ['&sl=pt&tl=ja'],
			'ruja'  : ['&sl=ru&tl=ja'],
			'arja'  : ['&sl=ar&tl=ja'],
			'autoen': ['&sl=auto&tl=en']
		};
	}
	if(action == 'DeepL'){
		translator = 'DeepL';
		translate  = 'https://api-free.deepl.com/v2/translate';
		post_url = 'https://api-free.deepl.com/v2/translate';
		china_menu2 = '(簡)';
		data = {
			'enja'  : ['&source_lang='+encodeURIComponent('EN')+'&target_lang='+encodeURIComponent('JA')],
			'jaen'  : ['&source_lang='+encodeURIComponent('JA')+'&target_lang='+encodeURIComponent('EN')],
			'chja'  : ['&source_lang='+encodeURIComponent('ZH')+'&target_lang='+encodeURIComponent('JA')],
			'chjab' : ['&source_lang='+encodeURIComponent('ZH')+'&target_lang='+encodeURIComponent('JA')],
			'koja'  : ['&source_lang='+encodeURIComponent('KO')+'&target_lang='+encodeURIComponent('JA')],
			'frja'  : ['&source_lang='+encodeURIComponent('FR')+'&target_lang='+encodeURIComponent('JA')],
			'deja'  : ['&source_lang='+encodeURIComponent('DE')+'&target_lang='+encodeURIComponent('JA')],
			'itja'  : ['&source_lang='+encodeURIComponent('IT')+'&target_lang='+encodeURIComponent('JA')],
			'esja'  : ['&source_lang='+encodeURIComponent('ES')+'&target_lang='+encodeURIComponent('JA')],
			'ptja'  : ['&source_lang='+encodeURIComponent('PT')+'&target_lang='+encodeURIComponent('JA')],
			'ruja'  : ['&source_lang='+encodeURIComponent('RU')+'&target_lang='+encodeURIComponent('JA')],
			'arja'  : ['&source_lang='+encodeURIComponent('AR')+'&target_lang='+encodeURIComponent('JA')],
			'autoen': ['&target_lang='+encodeURIComponent('EN')]
		};
	}
}

var copyText = true;//クリップボードにコピーする。
var closePopupMenu = true;//引数'menu'の場合、選択ポップアップを入力後閉じる。
var closeOnMouseExit = true;//カーソルのポップアップ外でポップアップを閉じます。
var doEditText = false;//テキストに対する元からある編集をする
var doEditOutput = true;//表示テキストに対して編集をする

var vcx = v2c.context,
    text = vcx.selText || vcx.res.message;
vcx.setDefaultCloseOnMouseExit( closeOnMouseExit );

var actions = new Array('google', 'DeepL');
if(vcx.args.length == 0){
}
else
if(vcx.args.length == 1){
	if(vcx.args[0] == 'google') actions = new Array('google'); 
	if(vcx.args[0] == 'DeepL') actions = new Array('DeepL'); 	
}
else
if(vcx.args.length == 2){
	if(vcx.args[1] == 'google') actions = new Array('google'); 
	if(vcx.args[1] == 'DeepL') actions = new Array('DeepL'); 	
}

//引数からURLに使う文字列を取得
var arg2data = ( function(){
	return function(arg) {
		if(translator == 'google'){
			if(arg.indexOf(',') == -1){
				return data[arg] || ['&sl=auto&tl=ja'];
			}else{
				var p = arg.split(',');
				return ['&sl='+p[0]+'&tl='+p[1]];
			};
		}
		if(translator == 'DeepL'){
			if(arg.indexOf(',') == -1){
				return data[arg] || ['&target_lang='+encodeURIComponent('JA')];
			}else{
				var p = arg.split(',');
				return ['&source_lang='+encodeURIComponent(p[0])+'&target_lang='+encodeURIComponent(p[1])];
			};
		}
	}
})();
//翻訳の選択ポップアップでフォーム送信時の動作
function formSubmitted( u,sm,sd ){
	var m = ( u + '' ).match( /^(.+)\?(.+?)=/ );
	var mt = '';
	for(var i=0; i<actions.length; i++){
		setParams(actions[i]);
		var d = arg2data( m[2] );
		mt = mt + (mt.length==0?'':'<hr>') + createPopupString(getTranslateURL(translator, d[0], text, true));
	}
	showPopup(mt);
	if( closePopupMenu ) vcx.closeOriginalPopup();//入力後閉じる。
}
//翻訳結果のポップアップ表示
function createPopupString( su ){
	var hr = v2c.createHttpRequest( su );
	hr.setRequestProperty('user-agent', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.87 Safari/537.36');
	var sr = hr.getContentsAsString();
	if ( !sr ) {
		v2c.alert( 'ページを取得できませんでした。: ' + hr.responseCode + ' '+ hr.responseMessage );
		return;
	}
	v2c.println(sr);
	var mt = new Array(2);
//	mt = sr.match( new RegExp( 'id=result_box[^>]+?>([^]+?)</div>', 'i' ) );
	mt[1] = '';
	var a = getTextArray(translator, sr);
	for(var i=0; i<a[0].length; i++){
		var str = ('' + a[0][i][0]).replace(/\n$/, '');
		v2c.println('i=' + i + ';' + str);
		// 出力整形
		if(doEditOutput){
			str = (''+str).replace(/(>>) (\d{1,4})/gi, '$1$2');
		}
		mt[1] += (str + (i!=a[0].length-1?'<br>':''));
	}
	if( !mt ){
		v2c.alert( '検索結果を取得できませんでした。' ); return;
	}
	return mt[1] + '<br><br>by ' + translator;
}
//翻訳する文字列の整形
function editText( text ){
	if(doEditText){
		text = text.replaceAll( '>>([[\\d]+[,-]?]+)\\n', '$1さん。' );//アンカー+改行⇒番号さん。
		text = text.replaceAll( '>>([[\\d]+[,-]?]+)', '$1' );//アンカー⇒番号
		text = text.replaceAll( '[\\s　]', ' ' );//改行削除
		text = text.replaceAll( '(?:[R|Q]T ?|)[@#]([\\w]+)[:]?', '$1' );//Twitter用、ハッシュタグ等削除
	}
	text = text.replaceAll( '[・／]', '　' ).replaceAll( '、', ',' ).replaceAll( '。', '.' );//全角句読点の平準化

	if(vcx.res != null && false){
		var links = vcx.res.links, link;
		for ( var i=0, l = links.length; i < l; i++ ){//リンクの削除
			link = ( links[i] + '' ).substring(1);
			if( ( text + '' ).charAt( ( text + '' ).lastIndexOf( link ) - 1 ) == 'h' ) {
				link = 'h' + link;
			}
			text = text.replace( link+'','' );
		}
	}
	text = text.trim();
	return text;
}
//実行形式の呼び出し
(function(){
	setParams(actions[0]);
	var arg = '' + vcx.args[0];
	text = editText( text );
	if ( arg == 'menu' ) {
		vcx.setPopupHTML( '<html lang="ja"><style type = "text/css">'
			+'<!--body{background-color:#cccccc; color:black; text-align:center;}.header{font-size:small;}--></style>'
			+'<body><form action="' + post_url + '"><table border="0" cellspacing="0" cellpadding="0">'
			+'<tr><th class = "header">' + translator +'翻訳</th></tr>'
			+'<tr><input type="submit" value="  英⇒日  " name="enja"></tr><tr><input type="submit" value="  日⇒英  " name="jaen"></tr>'
			+'<tr><input type="submit" value="中(簡)⇒日" name="chja"></tr><tr><input type="submit" value="中' + china_menu2 + '⇒日" name="chjab"></tr>'
			+'<tr><input type="submit" value="  韓⇒日  " name="koja"></tr><tr><input type="submit" value="  仏⇒日  " name="frja"></tr>'
			+'<tr><input type="submit" value="  独⇒日  " name="deja"></tr><tr><input type="submit" value="  伊⇒日  " name="itja"></tr>'
			+'<tr><input type="submit" value="  西⇒日  " name="esja"></tr><tr><input type="submit" value="  葡⇒日  " name="ptja"></tr>'
			+'<tr><input type="submit" value="  露⇒日  " name="ruja"></tr><tr><input type="submit" value="  亜⇒日  " name="arja"></tr>'
			+'</table></form></body></html>' );
		vcx.setTrapFormSubmission( true );
		vcx.setMaxPopupWidth( 97 );
	} else if ( arg != 'menu' && text && ( text.length() > 0 ) ) {
		text = encodeURIComponent( text );
		var mt = '';
		for(var i=0; i<actions.length; i++){
			setParams(actions[i]);
			var d = arg2data( arg );
			mt = mt + (mt.length==0?'':'<hr>') +  createPopupString(getTranslateURL(translator, d[0], text, false));
		}
		showPopup(mt);
	}
})();
function getTranslateURL(translator, d, text, encodeText){
	if(encodeText) text = encodeURIComponent(text);
	if(translator == 'google') return translate + d + '&hl=ja&dt=t&q=' + text;
	if(translator == 'DeepL')  return translate + '?auth_key=' + encodeURIComponent(DeepL_auth_key) + '&text=' + text + d +'&formality=' + encodeURIComponent(DeepL_formality);
	return '';
}
function getTextArray(translator, sr){
	if(translator == 'google') return eval('(' + (''+sr).replace(/[\n\r]/g, '') + ')');
	if(translator == 'DeepL'){
		var a = new Array(1);
		sr = (''+sr).replace(/\\"/g, '&#34;');
		if((''+sr).match(/"text":"([^"]*)"/)){
			a[0] = (''+RegExp.$1).replace(/&#34;/g, '"').split('\\n');
			for(var j=0; j<a[0].length; j++){
				a[0][j] = new Array(a[0][j]);
			}
		}
		return a;
	}
}
function showPopup(mt){
	ph = '<html><body style="margin:0 5px;">' + mt + '</body></html>';
	vcx.setPopupHTML( ph );
	v2c.context.setPopupFocusable(true);
	if( copyText ) v2c.context.setClipboardText( (''+mt).replace(/<br>/g, '\n').replace(/<hr>/g, '\n----------\n') + '\n');//クリップボードにコピーする。
}
// ----- 前の行まで -----
