//【登録場所】 全体、ツールバー＞ボタン登録領域
//【ラベル】 ハンター ログイン/ログアウト
//【内容】 ハンター ログイン/ログアウト
//【コマンド1】 ${SCRIPT:S} donguri.js login
//【コマンド2】 ${SCRIPT:S} donguri.js login メールアドレス パスワード
//【コマンド3】 ${SCRIPT:S} donguri.js logout
//【更新日】 2024/04/19
//【スクリプト】
// ----- 次の行から -----
var usr = '';		// UPLIFT メールアドレス
var pwd = '';		// UPLIFT パスワード

var vcx = v2c.context, thread = vcx.thread, res = vcx.res, args = vcx.args;
var gMessage = '', gCookie = '';

if(args.length >= 2){
	usr = args[1];
}

if(args.length >= 3){
	pwd = args[2];
}

if(args.length >= 1){
	if(args[0] == 'login'){
		if(!loginUPLIFT()){
			v2c.alert(gMessage);
		}else
		if(!loginHunter()){
			v2c.alert(gMessage);
		}else
		{
			v2c.alert('ハンターにログインしました');
		}
	}

	if(args[0] == 'logout'){
		logoutHunter();
		logoutUPLIFT();
		v2c.alert('ハンターからログアウトしました');
	}

	if(args[0] == 'loginUPLIFT'){
		if(!loginUPLIFT()){
			v2c.alert(gMessage);
		}else{
			v2c.alert('UPLIFTにログインしました');
		}
	}

	if(args[0] == 'loginHunter'){
		if(!loginHunter()){
			v2c.alert(gMessage);
		}else{
			v2c.alert('ハンターにログインしました');
		}
	}

	if(args[0] == 'logoutUPLIFT'){
		logoutUPLIFT();
		v2c.alert('UPLIFTからログアウトしました');
	}

	if(args[0] == 'logoutHunter'){
		logoutHunter();
		v2c.alert('ハンターからログアウトしました');
	}
}

function loginUPLIFT(){
	var ret = false;
	var url = 'https://uplift.5ch.net';

	var data = 'usr=' + encodeURIComponent(usr) + '&pwd=' + encodeURIComponent(pwd) + '&log=';
	var hr = v2c.createHttpRequest(url+'/log', data);
	var result = hr.getContentsAsString();
	v2c.println(hr.allResponseHeaders);
	gCookie = (''+hr.allResponseHeaders).replace(/^.+?(sid=[^;]+);.+$/, '$1');
	if(hr.responseCode == 302){
		hr = v2c.createHttpRequest(url+hr.getResponseHeader('location'));
		result = hr.getContentsAsString();
		if(result.indexOf('有効期限日') != -1){
			ret = true;
		}
	}else{
		gMessage = 'UPLIFT ログインエラー\ncode='+hr.responseCode;
	}

	return ret;
}

function loginHunter(){
	var ret = false;
	var url = 'https://donguri.5ch.net';

	var hr = v2c.createHttpRequest(url+'/login');
	hr.setRequestProperty('cookie', gCookie);
	var result = hr.getContentsAsString();
	v2c.println(hr.allResponseHeaders);
	gCookie += '; ' + (''+hr.allResponseHeaders).replace(/^.+?(acorn=[^;]+);.+$/, '$1');
	v2c.putProperty('donguriCannonCookie', gCookie);
	if(result.indexOf('あなたはハンターです') != -1){
		ret = true;
	}else{
		gMessage = 'ハンター ログインエラー\nもう一度ハンターからログアウトして下さい';
	}

	return ret;
}

function logoutHunter(){
	var url = 'https://donguri.5ch.net';

	var hr = v2c.createHttpRequest(url+'/logout');
	var result = hr.getContentsAsString();
	v2c.removeProperty('donguriCannonCookie');
}

function logoutUPLIFT(){
	var ret = false;
	var url = 'https://uplift.5ch.net';

	var data = 'log=';
	var hr = v2c.createHttpRequest(url+'/logout', data);
	var result = hr.getContentsAsString();
}
