const tb = document.getElementById('tb');

copyCookie();

async function copyCookie() {
	try {
		let GotCookie = '';
		if(window.navigator.userAgent.toLowerCase().indexOf('firefox') != -1){
			GotCookie = browser.cookies.get({url : 'https://open2ch.net/menu/', name : 'cf_clearance'});
		}else{
			GotCookie = chrome.cookies.get ({url : 'https://open2ch.net/menu/', name : 'cf_clearance'});
		}
		GotCookie.then(async (cookie) => {
			try {
				tb.value = cookie.value;
				tb.focus();
				tb.select();
				await writeClipboardText(cookie.value);
			} catch (error) {
				tb.value = error.message;
			}
		});
	} catch (error) {
		tb.value = error.message;
	}
}

async function writeClipboardText(text) {
	try {
		await setTimeout(() => navigator.clipboard.writeText(text), 1500);
	} catch (error) {
		tb.value = error.message;
	}
}
