//【登録場所】全体、コマンド
//【設置場所】 "V2C\script\TwitterColorEmojiPallet.js"
//【内容】Twitter カラー絵文字パレット
//【パーミッション】A
//【コマンド1】${SCRIPT:A} TwitterColorEmojiPallet.js
//【コマンド2】${SCRIPT:A} TwitterColorEmojiPallet.js defaultTab=xx　　　(xx=00～09：00～09の意味は変数defaultTabを参照、00の場合はコマンド1と同じ)
//【コマンド3】${SCRIPT:A} TwitterColorEmojiPallet.js ShowAt=x,y　　　　 (パレット表示するモニタ上のx座標、y座標、マルチディスプレイの場合はx座標はマイナスの場合も、0,0の場合はコマンド1と同じ)
//【コマンド3】${SCRIPT:A} TwitterColorEmojiPallet.js ShowAt=MousePoint　(パレット起動時にマウスポインタがある場所にパレットを表示)
//【備考】Twem❤ji Version 2.4対応 (但し最新分の文字がTwitter公式WEBサイトでは未対応かも)
//　　　　肌色の異なる複数の人物画像がある場合は「黒髪の明るい肌の色」の人物画像のみです
//　　　　添付のTwitterColorEmojiPalletフォルダが必要です
//　　　　TwitterColorEmojiPalletフォルダ内のrecentフォルダを削除すると最近使った項目が画像も含めて削除されます
//　　　　最近使った項目は画像を一枚ずつ表示しています、それ以外は複数の画像を一つにまとめた大きい画像を一枚だけ表示しています
//　　　　本家、MOD、V2CMOD-ZをJava8,9で使用している場合はRhinoスクリプトエンジンがないと最近使った項目の更新をできません(多分)
//　　　　爆サイへの投稿処理を参考にしました
//【更新日時】2017/12/14 初版
//【更新日時】2024/05/04
//【スクリプト】
// ----- 次の行から -----

var args = v2c.context.args;
var params = {};
for(var i=0; i<args.length; i++){
	var w = args[i].split('=');
	params[w[0]] = w[1];
}

// [設定 変更可能 CoCoから] ------------------------------------------------------
var Resizable    = false;	// パレットのサイズを変更可能にする場合にtrue (細かな制御をしてないので無駄な余白が表示される場合があります)
var recentCnt    = 50;		// 最近使った項目の個数 (数が多いとパレットの表示に時間がかかります、特にJava6だとビックリするくらい・・・)
var showRecent   = true;	// 最近使った項目タブを表示する

var dt = (''+params['defaultTab']).replace(/ /g, '').split(',');
if((''+dt) == 'undefined'){
	dt = 0;
}else{
	dt = parseInt(dt);
}
var defaultTab   = dt;		// パレット表示直後にデフォルトで表示するタブ
							// 00:最近使った項目,
							// 01:表情,           02:人,         03:ファッション, 04:動物と自然, 05:食べ物と飲み物,
							// 06:アクティビティ, 07:旅行と場所, 08:もの,         09:記号,       10:旗
var defaultSkin  = 1;		// 黒髪で明るい肌の色

var XonScreen  = 0;			// パレットを表示するスクリーンのX座標
var YonScreen  = 0;			// パレットを表示するスクリーンのY座標

var sa = (''+params['ShowAt']).replace(/ /g, '').split(',');
if((''+sa) != 'undefined'){
	if(sa == 'MousePoint'){
		var p = v2c.context.mousePos;	// スクリプト開始時のマウスポインタ位置を取得
		XonScreen  = p.x;
		YonScreen  = p.y;
	}else{
		var w = ''+sa
		XonScreen  = parseInt(w[0]);
		YonScreen  = parseInt(w[1]);
	}
}

var autoPack     = true;	// パレット表示を自動調整をしない場合はfalse (通常はtrue、Java6はfalseがいいかも)
var palletWidth  = 515;		// autoPackをfalseにした時に指定するパレットの幅
var palletHeight = 324;		// autoPackをfalseにした時に指定するパレットの高さ
var codeCovertToTwitterOnly = false;	//コード変換はTwitterでにみ行う場合true
// [設定 変更可能 CoCoまで] ------------------------------------------------------


// [設定 変更不可 CoCoから] ------------------------------------------------------
var createImageMap  = false;	// 全てのタブで画像を一枚ずつ表示する場合に true (時間がかかります)
var maxCol  = 18;				// 横に並べる個数 (横×縦で288となること)
var maxRow  = 19;				// 縦に並べる個数 (横×縦で288となること)
var imgSize = 24;				// 画像のサイズ (上下左右に1ドット分の余白をつけて画像を表示します)
var catPath     = v2c.saveDir + '/script/TwitterColorEmojiPallet/';
var pngImageDir = v2c.saveDir + '/script/TwitterColorEmojiPallet/recent/';
//var pngImageDir = v2c.saveDir + '/script/TwitterColorEmojiPallet/Twitter_FullSet24/';
// [設定 変更不可 CoCoまで] ------------------------------------------------------

// プロトタイプ CoCoから
function impl_invoke(func, param)
{
	// Nashorn特有のパーミッションエラーを回避するためのメソッドの呼び出しAPI
	// V2C-R 2.11.8とその派生版対応？
	// これが機能しない場合、最近使った項目の更新をできません
	if (v2c.invokeMethod) {
		v2c.invokeMethod({run:func}, 'run', param);
	} else {
		func(param);
	}
};

impl_mouseListener.prototype.invoke = impl_invoke;
function impl_mouseListener()
{
	var self = this;
	this.mouseClicked = function(e) {};
	this.mouseEntered = function(e) {};
	this.mouseExited  = function(e) {};
	this.mousePressed = function(e) {};
	this.mouseReleased= function(e) {
		self.invoke(function() {
			if (javax.swing.SwingUtilities.isRightMouseButton(e)) {
				var c = e.getSource();
				showPopup(c, e.getX(), e.getY());
				e.consume();
			}
		});
	};
}

function impl_showFrame() {
		this.frame.show();
}
// プロトタイプ CoCoまで

TwitterColorEmojiPallet.prototype.mouselistener = impl_mouseListener;
TwitterColorEmojiPallet.prototype.show = impl_showFrame;
TwitterColorEmojiPallet.prototype.invoke = impl_invoke;
function TwitterColorEmojiPallet()
{
	var self = this;
	var SwingGui = new JavaImporter(java.awt,
								java.awt.event,
								Packages.javax.swing,
								Packages.javax.swing.border,
								Packages.javax.swing.event
								);
	this.frame;
	var jTabbedPane;
	var jPanelFooter;

	var map = {
		 '0' : 0
		,'1' : 1
		,'2' : 2
		,'3' : 3
		,'4' : 4
		,'5' : 5
		,'6' : 6
		,'7' : 7
		,'8' : 8
		,'9' : 9
		,'a' : 10
		,'b' : 11
		,'c' : 12
		,'d' : 13
		,'e' : 14
		,'f' : 15
	}

	var skin = ['', '-1f3fb', '-1f3fc', '-1f3fd', '-1f3fe', '-1f3ff'];
	var skincombo

	impl_tabbedpanechangeListener.prototype.invoke = self.invoke;
	function impl_tabbedpanechangeListener()
	{
		var tcself = this;
		this.stateChanged = function(e) {
			tcself.invoke(function() {
				if(jTabbedPane.getSelectedIndex() == 0 && showRecent){
					jTabbedPane.setComponentAt(0, createImgPanel00('最近使った項目','cat00'));
					jTabbedPane.repaint();
				}
			});
		}
	}

	impl_clickableListener.prototype.invoke = self.invoke;
	function impl_clickableListener(u)
	{
		var clself = this;
		this.mouseClicked = function(e) {
			clself.invoke(function() {
				intoPreview(u);
			});
		};
		this.mouseEntered = function(e) {};
		this.mouseExited  = function(e) {};
		this.mousePressed = function(e) {};
		this.mouseReleased= function(e) {};
	}

	impl_clickableListener2.prototype.invoke = self.invoke;
	function impl_clickableListener2(u)
	{
		var clself = this;
		this.mouseClicked = function(e) {
			clself.invoke(function() {
				doClickableMap(e.getX(), e.getY());
			});
		};
		this.mouseEntered = function(e) {};
		this.mouseExited  = function(e) {};
		this.mousePressed = function(e) {};
		this.mouseReleased= function(e) {};
		
		function doClickableMap(x, y) {
			var idx = (Math.floor(y / (imgSize+2))) * maxCol + Math.floor(x / (imgSize+2));
			if(idx < u.length){
				intoPreview(u[idx]);
			}
		}
	}

	impl_btnclickableListener.prototype.invoke = self.invoke;
	function impl_btnclickableListener()
	{
		var clself = this;
		this.mouseClicked = function(e) {
			clself.invoke(function() {
				ref2bin();
			});
		};
		this.mouseEntered = function(e) {};
		this.mouseExited  = function(e) {};
		this.mousePressed = function(e) {};
		this.mouseReleased= function(e) {};

		function ref2bin()
		{
			var wp = v2c.context.thread.openWritePanel();
			if(!wp.thread.bbs.twitter && codeCovertToTwitterOnly){
				return true;
			}

			var text = ''+wp.message.text;

			var found = (''+text).match(/&#[0-9]+;?/g);
			if(found != null){
				for(var i=0; i<found.length; i++){
					var cp     = 0;
					var refnum = '';
					var hex    = '';
		
					if((''+found[i]).match(/&#([0-9]+)(;?)/)){
						cp = parseInt(RegExp.$1);
						refnum = '&#' + cp + RegExp.$2
					}
					if(cp <= 65535){
						hex = String.fromCharCode(cp);
					}else{
						cp -= 0x10000;
						var hi = ((cp >> 10) | 0xd800);
						var lo = (cp & 0x3ff | 0xdc00);
						hex = String.fromCharCode(hi) + String.fromCharCode(lo);
					}
					text = text.replace(refnum, hex);
				}
			}

			wp.message.text = text;
		}
	}

	impl_btnclickableListener2.prototype.invoke = self.invoke;
	function impl_btnclickableListener2()
	{
		var clself = this;
		this.mouseClicked = function(e) {
			clself.invoke(function() {
				recentClear();
			});
		};
		this.mouseEntered = function(e) {};
		this.mouseExited  = function(e) {};
		this.mousePressed = function(e) {};
		this.mouseReleased= function(e) {};

		function recentClear()
		{
			var file00 = new java.io.File(catPath + 'recent/cat00.txt');
			v2c.writeStringToFile(file00, '', 'UTF-8');
			jTabbedPane.setComponentAt(0, createImgPanel00('最近使った項目','cat00'));
			jTabbedPane.repaint();
		}
	}

/*
	impl_componentListener.prototype.invoke = self.invoke;
	function impl_componentListener()
	{
		var coself = this;
		this.componentResized = function(e) {
			coself.invoke(function() {
			});
		}
	}
*/
	with (SwingGui) {
		self.frame = new JFrame('Twitter カラー絵文字パレット');
		self.frame.defaultCloseOperation = WindowConstants.DISPOSE_ON_CLOSE;
//		self.frame.addComponentListener(new impl_componentListener());
		self.frame.setLayout(new BorderLayout());
		self.frame.setResizable(Resizable);
		self.frame.setLocationRelativeTo(null);
		self.frame.setAlwaysOnTop(true);
		self.frame.add(new createShowPanel());
		self.frame.setBounds(XonScreen, YonScreen, palletWidth, palletHeight);
		if(autoPack) self.frame.pack();
	}

	function createShowPanel()
	{
		with (SwingGui) {
			var jPanel = new JPanel();
			var gridBagLayout = new GridBagLayout();
			jPanel.setLayout(gridBagLayout);

			var gridbagconstraints = new GridBagConstraints();

			jTabbedPane = new JTabbedPane();
			jTabbedPane.setFocusable(false);
			if(showRecent) jTabbedPane.addTab('最近使った項目', createImgPanel00('最近使った項目',	 'cat00'));
			if(!createImageMap){
				jTabbedPane.addTab('顔文字と感情',   createImgPanelxx('顔文字と感情',	 'cat01'));
				jTabbedPane.addTab('人と身体①',	 createImgPanelxx('人と身体①',		 'cat02'));
				jTabbedPane.addTab('人と身体②',	 createImgPanelxx('人と身体②',		 'cat021'));
				jTabbedPane.addTab('人と身体③',	 createImgPanelxx('人と身体③',		 'cat022'));
				jTabbedPane.addTab('動物と自然',	 createImgPanelxx('動物と自然',		 'cat03'));
				jTabbedPane.addTab('食べ物と飲み物', createImgPanelxx('食べ物と飲み物',	 'cat04'));
				jTabbedPane.addTab('旅行と場所',	 createImgPanelxx('旅行と場所',		 'cat05'));
				jTabbedPane.addTab('アクティビティ', createImgPanelxx('アクティビティ',	 'cat06'));
				jTabbedPane.addTab('もの',			 createImgPanelxx('もの',			 'cat07'));
				jTabbedPane.addTab('記号',			 createImgPanelxx('記号',			 'cat08'));
				jTabbedPane.addTab('旗',			 createImgPanelxx('旗',				 'cat09'));
			}else{
				jTabbedPane.addTab('表情',			 createImgPanel00('表情',			 'cat01'));
				jTabbedPane.addTab('人',			 createImgPanel00('人',				 'cat02'));
				jTabbedPane.addTab('ファッション',	 createImgPanel00('ファッション',	 'cat03'));
				jTabbedPane.addTab('動物と自然',	 createImgPanel00('動物と自然',		 'cat04'));
				jTabbedPane.addTab('食べ物と飲み物', createImgPanel00('食べ物と飲み物',	 'cat05'));
				jTabbedPane.addTab('アクティビティ', createImgPanel00('アクティビティ',	 'cat06'));
				jTabbedPane.addTab('旅行と場所',	 createImgPanel00('旅行と場所',		 'cat07'));
				jTabbedPane.addTab('もの',			 createImgPanel00('もの',			 'cat08'));
				jTabbedPane.addTab('記号',			 createImgPanel00('記号',			 'cat09'));
				jTabbedPane.addTab('旗',			 createImgPanel00('旗',				 'cat10'));
			}
			var tabNo;
			if(showRecent){
				tabNo = defaultTab;
			}else{
				tabNo = (defaultTab==0?0:defaultTab-1);
			}
			jTabbedPane.setSelectedIndex(tabNo);

			gridbagconstraints.insets = new Insets(1, 1, 1, 1);
			gridbagconstraints.gridy = 0;
			gridbagconstraints.gridx = 0;
			gridbagconstraints.fill = 1;
			gridbagconstraints.weightx = 1.0;
			gridbagconstraints.weighty = 1.0;
			jTabbedPane.addChangeListener(new ChangeListener(new impl_tabbedpanechangeListener()))
			jPanel.add(jTabbedPane, gridbagconstraints);

			jPanelFooter = new JPanel();
			var btn = new JButton("コード変換" + (codeCovertToTwitterOnly?"(Twitterのみ)":""));
			btn.addMouseListener(new MouseListener(new impl_btnclickableListener()));
			gridbagconstraints.gridy = 0;
			gridbagconstraints.gridx = 0;
			jPanelFooter.add(btn, gridbagconstraints);

			if(showRecent){
				gridbagconstraints.gridx++;
				var btn2 = new JButton("最近使った項目をクリア");
				btn2.addMouseListener(new MouseListener(new impl_btnclickableListener2()));
				jPanelFooter.add(btn2, gridbagconstraints);
			}

			gridbagconstraints.gridx++;
			var combo = creaetComboBox(defaultSkin);
			jPanelFooter.add(combo, gridbagconstraints);

			gridbagconstraints.gridy = 1;
			gridbagconstraints.gridx = 0;
			jPanel.add(jPanelFooter, gridbagconstraints);
			return jPanel;
		}
	}

	function createImgPanel00(title, cat){
		with (SwingGui) {
			var jPanel = new JPanel(new GridBagLayout());

			var gridbagconstraints = new GridBagConstraints();
			gridbagconstraints.fill = 1;
			gridbagconstraints.weightx = 1.0;
			gridbagconstraints.weighty = 1.0;

			var jPanel0 = new JPanel(new GridBagLayout());
			jPanel0.setBorder(new TitledBorder(' ' + title+ ' '));
			jPanel0.setBackground(Color.WHITE);

			gridbagconstraints.insets = new Insets(1, 1, 1, 1);

			var lines = null;
			var file = new java.io.File(catPath + (cat=='cat00'?'recent/'+cat:cat) + '.txt');
			if(file.exists()){
				lines = v2c.readLinesFromFile(file, 'UTF-8');
			}
			var count = (cat=='cat00'?recentCnt:lines.length);

			var emoji = new Array(maxCol * maxRow);
			var row = 0;
			var col = 0;

			if(lines != null)
			{
				var exclude = 0;
				for(var i=0; i<lines.length; i++){
					if((''+lines[i]).charAt(0) != '!'){
						v2c.println(lines[i]);
						if((''+lines[i]).match(/.+\/([0-9a-f-]+).png/)){
							var fn = RegExp.$1;
							var pngImage = pngImageDir +fn + '.png';
							var icon;
//							if(createImageMap){
//								icon = new ImageIcon(new ImageIcon(pngImage));
//							}else{
								icon = new ImageIcon(new ImageIcon(pngImage).getImage().getScaledInstance(imgSize, imgSize, Image.SCALE_SMOOTH));
//							}
							emoji[i] = new JLabel(icon);
							emoji[i].addMouseListener(new MouseListener(new impl_clickableListener(lines[i])));
							gridbagconstraints.gridy = row;
							gridbagconstraints.gridx = col;
							jPanel0.add(emoji[i], gridbagconstraints);
							if(++col == maxCol){
								row++;
								col = 0;
							}
						}
					}else{
						exclude++;
					}
				}

				pngImage = catPath + 'space.png';
				icon = new ImageIcon(new ImageIcon(pngImage));
				for(var i=lines.length-exclude; i<emoji.length; i++){
					emoji[i] = new JLabel(icon);
					gridbagconstraints.gridy = row;
					gridbagconstraints.gridx = col;
					jPanel0.add(emoji[i], gridbagconstraints);
					if(++col == maxCol){
						row++;
						col = 0;
					}
				}
			}

			var jScrollPane = new JScrollPane();
			jScrollPane.setViewportView(jPanel0);

			gridbagconstraints.insets = new Insets(1, 1, 1, 1);
			gridbagconstraints.gridy = 0;
			gridbagconstraints.gridx = 0;
			jPanel.add(jScrollPane, gridbagconstraints);

			return jPanel;
		}
	}

	function createImgPanelxx(title, cat){
		with (SwingGui) {
			var jPanel = new JPanel(new GridBagLayout());

			var gridbagconstraints = new GridBagConstraints();
			gridbagconstraints.fill = 1;
			gridbagconstraints.weightx = 1.0;
			gridbagconstraints.weighty = 1.0;

			var jPanel0 = new JPanel(new GridBagLayout());
			jPanel0.setBorder(new TitledBorder(' ' + title+ ' '));
			jPanel0.setBackground(Color.WHITE);
			jPanel0.setLayout(new BoxLayout(jPanel0, BoxLayout.LINE_AXIS));

			gridbagconstraints.insets = new Insets(1, 1, 1, 1);

			var lines = null;
			var file = new java.io.File(catPath + cat + '.txt');
			if(file.exists()){
				lines = v2c.readLinesFromFile(file, 'UTF-8');
			}

			var emoji;
			var row = 0;
			var col = 0;

			if(lines != null)
			{
				var pngImage = catPath + cat + '.png';
				var icon = new ImageIcon(new ImageIcon(pngImage));
				emoji = new JLabel(icon);
				emoji.setAlignmentY(0.0);
				emoji.addMouseListener(new MouseListener(new impl_clickableListener2(lines)));
				gridbagconstraints.gridy = row;
				gridbagconstraints.gridx = col;
				jPanel0.add(emoji, gridbagconstraints);
			}

			var jScrollPane = new JScrollPane();
			jScrollPane.setViewportView(jPanel0);

			gridbagconstraints.insets = new Insets(1, 1, 1, 1);
			gridbagconstraints.gridy = 0;
			gridbagconstraints.gridx = 0;
			jPanel.add(jScrollPane, gridbagconstraints);

			return jPanel;
		}
	}

	function intoPreview(u)
	{
		if((''+u).match(/.+\/([0-9a-f-]+).png/)){
			var altskin = skin[skincombo.getSelectedIndex()];
			var key = (''+RegExp.$1).replace(/-1f3fb/g, altskin);

			if((''+key).indexOf('-fe0f') == -1){
				key = (''+key).replace(/(2[a3])(-20e3)/i,          '$1-fe0f$2');
				key = (''+key).replace(/(3[0-9])(-20e3)/i,         '$1-fe0f$2');
//				key = (''+key).replace(/(1f1e[6-9a-f])/i,          '$1-fe0f');
//				key = (''+key).replace(/(1f1f[0-9a-f])/i,          '$1-fe0f');
			}

			var arr = (''+key).split('-');
			var refStr = '';
			for(var i=0; i<arr.length; i++){
				var w = arr[i];
				var cp = map[w.charAt(0)];
				for(var j= 1; j<w.length;  j++){
					cp = cp * 16 + map[w.charAt(j)];
				}
				refStr += '&#' + cp + ';';
			}
//			v2c.println(refStr);
			var wp = v2c.context.thread.openWritePanel();
			var mae    = wp.message.text.substr(0, wp.message.caretPos);
			var ushiro = wp.message.text.substr(wp.message.caretPos);
			wp.message.text = mae + refStr + ushiro;

			u   = (''+u)  .replace(/(\/2[a3])-fe0f(-20e3\.png)/i,   '$1$2');
			u   = (''+u)  .replace(/(\/3[0-9])-fe0f(-20e3\.png)/i,  '$1$2');
			u   = (''+u)  .replace(/(\/1f1e[6-9a-f])-fe0f(\.png)/i, '$1$2');
			u   = (''+u)  .replace(/(\/1f1f[0-9a-f])-fe0f(\.png)/i, '$1$2');
			key = (''+key).replace(/(2[a3])-fe0f(-20e3)/i,          '$1$2');
			key = (''+key).replace(/(3[0-9])-fe0f(-20e3)/i,         '$1$2');
			key = (''+key).replace(/(1f1e[6-9a-f])-fe0f/i,          '$1');
			key = (''+key).replace(/(1f1f[0-9a-f])-fe0f/i,          '$1');

			var lines00 = null
			var file00 = new java.io.File(catPath + 'recent/cat00.txt');
			if(file00.exists()){
				lines00    = v2c.readLinesFromFile(file00, 'UTF-8');
			}
			var txt00 = (''+u).replace(/-1f3fb/g, altskin) + '\n';
			var lines = 0;
			if(lines00 != null){
				for(var i=0; i<lines00.length; i++){
					if(lines00[i] != u){
						txt00 = txt00 + lines00[i] + '\n';
					}
					if(++lines == recentCnt){
						break;
					}
				}
			}
			v2c.writeStringToFile(file00, txt00, 'UTF-8');

			var url = ('https://abs.twimg.com/emoji/v2/72x72/' + key + '.png');
			var hr = v2c.createHttpRequest(url);
			var ContentsAsBytes = hr.getContentsAsBytes();
			if(hr.responseCode == 200){
				var png =pngImageDir + key + '.png';
				v2c.writeBytesToFile(png, ContentsAsBytes);
			}
		}
	}

	function creaetComboBox(idx)
	{
		with (SwingGui) {
			var model = new DefaultComboBoxModel();
			model.addElement(new ImageIcon(catPath + 'comboImages/1f47c' + skin[0] + '.png'));
			model.addElement(new ImageIcon(catPath + 'comboImages/1f47c' + skin[1] + '.png'));
			model.addElement(new ImageIcon(catPath + 'comboImages/1f47c' + skin[2] + '.png'));
			model.addElement(new ImageIcon(catPath + 'comboImages/1f47c' + skin[3] + '.png'));
			model.addElement(new ImageIcon(catPath + 'comboImages/1f47c' + skin[4] + '.png'));
			model.addElement(new ImageIcon(catPath + 'comboImages/1f47c' + skin[5] + '.png'));
	
			skincombo = new JComboBox(model);
			skincombo.setSelectedIndex(idx);
			return skincombo;
		}
	}
}

(new TwitterColorEmojiPallet()).show();

//末尾に置く
(function() { 
	return {
		'TwitterColorEmojiPallet' : TwitterColorEmojiPallet
	};
})();
