package org.monazilla.v2c;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class V2CYosoHelperPanel extends JPanel implements ActionListener, WindowListener
{

	static String[] uaList0 = new String[] {
			  "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/**.*.****.*** Safari/537.36"
			, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.16; rv:**.*) Gecko/20100101 Firefox/**.*"
			, "Mozilla/5.0 (Macintosh; Intel Mac OS X 11_0_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/**.*.****.*** Safari/537.36"
//			, "Monazilla/1.00 JaneStyle/4.10 Windows/**.*.*****"
//			, "Monazilla/1.00 Live5ch/1.58 Windows/**.*.*****"
			, "Mozilla/5.0 (X11; Linux x86_64; rv:**.*) Gecko/20100101 Firefox/**.*"
			, "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/**.*.****.*** Safari/537.36"
			, "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:**.*) Gecko/20100101 Firefox/**.*"
	};
	static String boardKey = "";
	static URL serverKey = null;
	static boolean to4penabled = true;
	static String title = "余所UAHelper";
	
	static synchronized void showDialog(V2CPanel v2cpanel)
	{
		V2CYosoHelperPanel v2cYosoHelperPanel = vYosoHelperPanel;
		if (v2cYosoHelperPanel != null) {
			jcbSearchTarget.setSelectedIndex(0);

		}
		else {
			v2cYosoHelperPanel = new V2CYosoHelperPanel(v2cpanel);
			vYosoHelperPanel = v2cYosoHelperPanel;
		}
		v2cYosoHelperPanel.showDialog();
	}

	public V2CYosoHelperPanel(V2CPanel v2cpanel)
	{
		super(new GridBagLayout());
		Insets insets = new Insets(1, 5, 1, 5);
		Insets insets2 = new Insets(1, 10, 1, 5);
		setBorder(new EmptyBorder(10, 10, 10, 10));
		JDialog jdialog = new JDialog(V2CMain.v2cMain, title, false);
		jdialog.setResizable(false);
		jDialog = jdialog;
		jdialog.setDefaultCloseOperation(2);
		V2CSwingUtil.registerESCToDialog(jdialog);
		jdialog.addWindowListener(this);
		jdialog.setContentPane(this);
		GridBagConstraints gridbagconstraints = V2CSwingUtil.createGridBagConstraints();
		gridbagconstraints.insets = insets;
		add(new JLabel("UA："), gridbagconstraints);
		gridbagconstraints.gridx++;
		uaList0 = loadYosoHelperSeed();
		String[] uaList = adoptUA(uaList0);
		JComboBox jcombobox = new JComboBox(uaList);
		jcbSearchTarget = jcombobox;
		Font font1 = jcombobox.getFont();
		jcombobox.setFocusable(false);
		jcombobox.setSelectedIndex(0);
		jcombobox.addActionListener(this);
		jcombobox.setMaximumRowCount(uaList0.length);
		add(jcombobox, gridbagconstraints);
		gridbagconstraints.gridx++;
		jcbthreTate = createCheckBox("スレ立て", false, true, insets2, gridbagconstraints, gridbagconstraints.gridx);
		
		gridbagconstraints.insets = insets;
		gridbagconstraints.gridy++;
		gridbagconstraints.gridx = 0;
		add(new JLabel("4式+："), gridbagconstraints);
		gridbagconstraints.gridx++;
		jtfWords = V2CSwingUtil.createTextField(70);
		V2CThreadPanel v2cthreadpanel = V2CThreadPanel.getActivePanel();
		boardKey = v2cthreadpanel.getThreadItem().getBoardString();
		try {
			to4penabled = true;
			serverKey = new URL("https://" + v2cthreadpanel.getThreadItem().getURL().getHost().replace(".2ch.net", ".5ch.net") + "/test/bbs.cgi");
			if(serverKey != null && V2CCookieMonaTicketUA.exists(serverKey)){
				to4penabled = false;
			}
		} catch (MalformedURLException e) {
			// TODO 自動生成された catch ブロック
			serverKey = null;
			e.printStackTrace();
		}
		jtfWords.setText("H:" + boardKey + "#" + uaList[0]);
		jtfWords.addActionListener(this);
		jtfWords.addMouseListener(new V2CPopupListener("V2CYosoHelperPanel", jtfWords));
		add(jtfWords, gridbagconstraints);
		gridbagconstraints.insets = insets2;
		gridbagconstraints.gridx++;
		jbCopyToSetting3Plus = new JButton("4式+に反映");
		if (!V2CApp.isUNIX())
			jbCopyToSetting3Plus.setFocusable(false);
		jbCopyToSetting3Plus.addActionListener(this);
		jbCopyToSetting3Plus.setEnabled(to4penabled);
		add(jbCopyToSetting3Plus, gridbagconstraints);

//		gridbagconstraints.gridy++;
//		gridbagconstraints.gridx = 0;
		jcbREADJSeqOFF = createCheckBox("クッキーに「READJS=\"off\"」を追加する", false, true, insets, gridbagconstraints, 0);
		jcbREADJSeqOFF.setVisible(false);

//		gridbagconstraints.gridy++;
//		gridbagconstraints.gridx = 0;
		jcbUseNT11 = createCheckBox("「Windows NT 11.0」に偽装する", false, true, insets, gridbagconstraints, 0);
		jcbUseNT11.setVisible(false);

		gridbagconstraints.gridy++;
		gridbagconstraints.gridx = 0;
		jcbMonaTicket2Board = createCheckBox(boardKey + "板に個別UAを設定する", false, true, insets, gridbagconstraints, 0);

		gridbagconstraints.gridy++;
		gridbagconstraints.gridx = 1;
		JButton jbutton = new JButton("閉じる");
		jbClose = jbutton;
		jbutton.setFocusable(false);
		jbutton.addActionListener(this);
		gridbagconstraints.insets = new Insets(10, 10, 0, 10);
		gridbagconstraints.anchor = 10;
		add(jbutton, gridbagconstraints);
	}

	void showDialog()
	{
		JDialog jdialog = jDialog;
		if (jdialog.isVisible()) {
			jdialog.toFront();
		}
		else {
			jdialog.pack();
			jdialog.setVisible(true);
		}
		jtfWords.requestFocusInWindow();
	}

	public void actionPerformed(ActionEvent actionevent)
	{
		Object obj = actionevent.getSource();
		if (obj == jtfWords){
			V2CSwingUtil.showInformationMessage(jtfWords.getText());

		}else if (obj == jcbSearchTarget){
			jtfWords.setText("H:" + boardKey + "#" + jcbSearchTarget.getSelectedItem().toString());
			if(jcbUseNT11.isSelected()){
				String w = jtfWords.getText().replace("Windows NT 10.0", "Windows NT 11.0");
				jtfWords.setText(w);
			}
			jtfWords.setCaretPosition(0);
			jcbSearchTarget.setSelectedIndex(jcbSearchTarget.getSelectedIndex());

		}else if (obj == jbCopyToSetting3Plus){
				if(V2CSwingUtil.showOKCancelDialog("この定義を4式+に登録します", title)){
					updateType4AndPlus();
					V2CSwingUtil.showInformationMessage(jtfWords.getText(), "登録しました");
			}

		}else if (obj == jbClose){
			jDialog.dispose();
		}
	}

	public void windowOpened(WindowEvent windowevent)
	{
	}

	public void windowClosing(WindowEvent windowevent)
	{
	}

	public void windowClosed(WindowEvent windowevent)
	{
		synchronized (org.monazilla.v2c.V2CYosoHelperPanel.class) {
			vYosoHelperPanel = null;
		}
	}

	public void windowIconified(WindowEvent windowevent)
	{
	}

	public void windowDeiconified(WindowEvent windowevent)
	{
	}

	public void windowActivated(WindowEvent windowevent)
	{
	}

	public void windowDeactivated(WindowEvent windowevent)
	{
	}

	public String[] adoptUA(String[] uaList){
		Map <String, String> hmSecondaryUA_W = V2CHttpUtil.hmSecondaryUA.get("W");
//		String verStyle = "";
		String verFirefox = "";
		String varChrome = "";
		String varEdg = "";

		for(Map.Entry<String, String> entry : hmSecondaryUA_W.entrySet()) {
//			if((""+entry.getValue()).indexOf("JaneStyle/") != -1 || (""+entry.getValue()).indexOf("Live5ch/") != -1){
//				if(verStyle == ""){
//					Matcher m = V2CHttpUtil_SecondaryUAPlus.PatternStyle.matcher((""+entry.getValue()));
//					if(m.find()){
//						verStyle = m.group(1);
//					}
//				}
//			}
			if(!(""+entry.getKey()).startsWith("H:DUMMY")){
				continue;
			}
			if((""+entry.getValue()).indexOf("Firefox/") != -1){
				if(verFirefox == ""){
					Matcher m = V2CHttpUtil_SecondaryUAPlus.PatternFirefox.matcher((""+entry.getValue()));
					if(m.find()){
						verFirefox = m.group(1);
					}
				}
			}
			if((""+entry.getValue()).indexOf("Chrome/") != -1){
				if(varChrome == ""){
					Matcher m = V2CHttpUtil_SecondaryUAPlus.PatternChrome.matcher((""+entry.getValue()));
					if(m.find()){
						varChrome = m.group(1);
					}
				}
			}
			if((""+entry.getValue()).indexOf("Edg/") != -1){
				if(varEdg == ""){
					Matcher m = V2CHttpUtil_SecondaryUAPlus.PatternEdg.matcher((""+entry.getValue()));
					if(m.find()){
						varEdg = m.group(1);
					}
				}
			}
		}

		for(int i=0; i<uaList.length; i++){
			String ua = uaList[i];
//			if(ua.indexOf("JaneStyle/") != -1 || ua.indexOf("Live5ch/") != -1){
//				if(verStyle != ""){
//					ua = ua.replaceAll("Windows/[*.]+", "Windows/" + verStyle);
//				}
//			}
			if(ua.indexOf("Firefox/") != -1){
				if(verFirefox != ""){
					ua = ua.replaceAll("Firefox/[*.]+", "Firefox/" + verFirefox).replaceAll("rv:[*.]+", "rv:" + verFirefox);
				}
			}
			if(ua.indexOf("Chrome/") != -1){
				if(varChrome != ""){
					ua = ua.replaceAll("Chrome/[*.]+", "Chrome/" + varChrome);
				}
			}
			if(ua.indexOf("Edg/") != -1){
				if(varEdg != ""){
					ua = ua.replaceAll("Edg/[*.]+", "Edg/" + varEdg);
				}
			}
			uaList[i] = ua;
		}

		return uaList;
	}
	
	private JCheckBox createCheckBox(String s, boolean flag, boolean flag1, Insets insets, GridBagConstraints gridbagconstraints, int gridx)
	{
		gridbagconstraints.gridx = gridx;
		JCheckBox jcheckbox = new JCheckBox(s, flag);
		jcheckbox.setFocusable(false);
		gridbagconstraints.gridwidth = 2;
		gridbagconstraints.insets = insets;
		add(jcheckbox, gridbagconstraints);
		return jcheckbox;
	}


	public static void updateType4AndPlus(){
		Map <String, String> Type4PlusMap = new HashMap <String, String> ();
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File cache = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_SecondaryUAPlus.txt");

		if(cache.exists()){
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(cache));
		 
				String line;
				while ((line = br.readLine()) != null) {
					String[] w = line.split("#");
					Type4PlusMap.put(w[0], line);
				}
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}

		String jft = "W" + jtfWords.getText();
		String[] w = jft.split("#");
		Type4PlusMap.put(w[0], jft);				

		String text = "";
		for(String key : Type4PlusMap.keySet()){
			text += Type4PlusMap.get(key) + "\n";
		}

		V2CHttpUtil_SecondaryUA SecondaryUA = new V2CHttpUtil_SecondaryUA();
		SecondaryUA.load();
		SecondaryUA = null;
		V2CHttpUtil_SecondaryUAPlus SecondaryUAPlus = new V2CHttpUtil_SecondaryUAPlus();
		SecondaryUAPlus.save(text);
		SecondaryUAPlus.load();
		SecondaryUAPlus = null;

		if(jcbREADJSeqOFF.isSelected()){
			String[] a = jtfWords.getText().split("#");
			a[0] = a[0].replace("H:", "");
			if((","+V2CHttpUtil.Use_READJS_ToPost+",").indexOf((","+a[0]+",")) == -1){
				V2CHttpUtil.Use_READJS_ToPost += "," + a[0];
				V2CHttpUtil.Use_READJS_ToPost = V2CHttpUtil.Use_READJS_ToPost.replaceAll("^,", "");
				V2CHttpUtil.Use_READJS_ToPostArrayList = V2CHttpUtil.StringToArrayList("read.cgiモード、HYBRIDでレス書き込みクッキーに「READJS」を追加する板", V2CHttpUtil.Use_READJS_ToPost);
				V2CProperty apiProperty = V2CHttpUtil.apiProperty;
				apiProperty.put(V2CAPISettings3.Use_READJS_ToPost_Key, V2CHttpUtil.Use_READJS_ToPost);
				apiProperty.doSaveState();
			}
		}
	}
	
	static private String[] loadYosoHelperSeed(){
		String seed = "";
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File cache = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_YosoUAHelper_Seed.txt");

		if(cache.exists()){
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(cache));
		 
				String line;
				while ((line = br.readLine()) != null) {
					if(line.length() >= 12){
						seed += (seed.length()==0?"":"\n") + line;
					}
				}
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
					return seed.split("\n");
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return uaList0;		
	}

	public static String getMonaTicket2Board(){
		if(jcbMonaTicket2Board.isSelected()){
			return boardKey;
		}else{
			return null;
		}
	}

	static V2CYosoHelperPanel vYosoHelperPanel;
	static JDialog jDialog;
	static JComboBox jcbSearchTarget;
	static JTextField jtfWords;
	static JButton jbClose;
	static JButton jbCopyToSetting3Plus;
	static JCheckBox jcbthreTate;
	static JCheckBox jcbREADJSeqOFF;
	static JCheckBox jcbUseNT11;
	static JCheckBox jcbMonaTicket2Board;
}
