package org.monazilla.v2c;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class V2CWebpANIMReader
{
	DataInputStream dis = null;
	private final static byte[] Chunk_VP8X = "VP8X".getBytes();
	private final static byte[] Chunk_ALPH = "ALPH".getBytes();
	private final static byte[] Chunk_END = "END ".getBytes();
	private final static byte[] Header_RIFF = "RIFF".getBytes();
	private final static byte[] Header_WEBP = "WEBP".getBytes();
	private final static int len_WEBP_HEADER = 12;
	private final static int idx_VP8_In_ANMF = 16;

	private byte[] Chunk = new byte[4];
	private byte[] nextChunk = new byte[4];
	private int Chunk_length = 0;
	private int nextChunk_length = 0;
	private byte[] stream = null;
	private long filesize = 0;
	private long readsize = 0;
	private int nextHeaderLength = 0;
	
	private int itest = 0;
	
	public V2CWebpANIMReader(File file){
		filesize = file.length();
		dis = null;
		itest = 0;
		try {
			dis = new DataInputStream(
					new BufferedInputStream(
						new FileInputStream(file)));
			stream = new byte[20];
			readsize += stream.length;
			dis.readFully(stream, 0, stream.length);
			System.arraycopy(stream, 12, nextChunk, 0, 4);
			nextChunk_length = calcChunk_length(stream); 
		} catch (FileNotFoundException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
	}

	public void close(){
		if(dis != null){
			try {
				dis.close();
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
			dis = null;
		}
	}
	
	public int getNextEntry(){
		try {
			if((new String(Chunk)).equals("END ")){
				return -1;
			}

			System.arraycopy(nextChunk, 0, Chunk, 0, 4);
			Chunk_length = nextChunk_length;

			nextHeaderLength = (filesize-readsize-Chunk_length>8?8:0);
			stream = new byte[Chunk_length+nextHeaderLength];
			readsize += stream.length;
			dis.readFully(stream, 0, stream.length);

			if(filesize > readsize){
				System.arraycopy(stream, Chunk_length, nextChunk, 0, 4);
				nextChunk_length = calcChunk_length(stream); 
			}else{
				System.arraycopy(Chunk_END, 0, nextChunk, 0, 4);
				nextChunk_length = 0; 
			}

			if(!(new String(Chunk)).equals("ANMF")){
				return getNextEntry();
			}
			return (filesize-readsize>=0?stream.length:-1);
		} catch (EOFException e) {
			return -1;
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
		return -1;
	}

	public byte[] read(){
		// ALPHチャンク除去
		int stream_stIDX = idx_VP8_In_ANMF;
		if(    stream[stream_stIDX+0] == Chunk_ALPH[0]
			&& stream[stream_stIDX+1] == Chunk_ALPH[1]
			&& stream[stream_stIDX+2] == Chunk_ALPH[2]
			&& stream[stream_stIDX+3] == Chunk_ALPH[3]
		){
			byte[] len_ALPH = new byte[4];
			System.arraycopy(stream, stream_stIDX+4, len_ALPH, 0, 4);
			int acl = calcChunk_length(len_ALPH) + 8;
			if((acl % 2) != 0){
				acl++;
			}
			stream_stIDX += acl;
		}
		
		int filelength = Chunk_length-stream_stIDX+len_WEBP_HEADER;
		byte[] a = new byte[Chunk_length];
		byte[] b = new byte[filelength];
		
		System.arraycopy(Header_RIFF, 0, b, 0, Header_RIFF.length);
		byte[] lb = ByteBuffer.allocate(4).putInt(filelength-8).array();
		b[4] = lb[3];
		b[5] = lb[2];
		b[6] = lb[1];
		b[7] = lb[0];
		System.arraycopy(Header_WEBP, 0, b, 8, Header_WEBP.length);
		
		System.arraycopy(stream, stream_stIDX, b, len_WEBP_HEADER, stream.length-stream_stIDX-nextHeaderLength);
		
		return b;
	}

	private static int calcChunk_length(byte[] stream){
		int j = 0;
		int Chunk_length = 0;
		for(int i=stream.length-4; i<stream.length-1; i++){
			Chunk_length += (short) (stream[i] & 0xFF) * Math.pow(256, j++);
		}
		return Chunk_length;
	}
	
	public static int getDuration(File imagefile){
		int ret = 0;
		byte[] b = new byte[8192];
		byte[] c = "ANMF".getBytes();
		int readByte = 0;

		try {
			DataInputStream dataInStream = 
				new DataInputStream(
					new BufferedInputStream(
						new FileInputStream(imagefile)
						)
					);
			readByte = dataInStream.read(b);
			
			int p = 0;
			boolean match = false;
			for(int i=12; i<readByte-3; i++){
				p = i;
				match = true;
				for(int j=0; j<4; j++){
					if(c[j] != b[i+j]){
						match = false;
						break;
					}
				}
				if(match){
					break;
				}
			}

			if(match){
				p += (
					  4 /* ChunkHeader('ANMF') */ 
					+ 4 /* Chunk Length(except ChunkHeader) */
					+ 3 /* Frame X */
					+ 3 /* Frame Y */  
					+ 3 /* Frame Width Minus One */
					+ 3 /* Frame Width Height One */  
				);
				for(int i=0; i<3; i++){
					ret += (short) (b[p+i] & 0xFF) * Math.pow(256, i);
				}
			}
			dataInStream.close();
		} catch (FileNotFoundException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}

		return ret;
	}
	
	public static boolean isWebpANIM(File file){
		if(!file.getAbsolutePath().endsWith("webp")){
			return false;
		}
		DataInputStream wdis = null;
		byte[] b = new byte[17]; 
		try {
			wdis = new DataInputStream(
					new BufferedInputStream(
						new FileInputStream(file)));
			wdis.readFully(b, 0, b.length);
			wdis.close();
		} catch (FileNotFoundException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
		} catch (IOException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
		wdis = null;
		if(     b[12] == Chunk_VP8X[0]
			&&  b[13] == Chunk_VP8X[1]
			&&  b[14] == Chunk_VP8X[2]
			&&  b[15] == Chunk_VP8X[3]
			&& (b[16] & 0x02) == 0x02){
			return true;
		}else{
			return false;
		}
		
	}
}


