package org.monazilla.v2c;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.net.ssl.HttpsURLConnection;
import javax.swing.JOptionPane;

import org.monazilla.v2c.V2CHttpUtil.CAndC;
import org.monazilla.v2c.V2CHttpUtil.MyHostnameVerifier;

public class V2CUPLIFTandDonguri
{
	static boolean login2ch(String userId, String passwd,
			V2CProgressPanel v2cprogresspanel, boolean flag) {

		String p = (String) V2CScriptApp.getProperty("UPLIFT_ManualLogin");
		if(p != null || !V2CHttpUtil.Not_UPLIFT_AutoLogin){
		}else{
			Calendar c = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
			System.out.println(sdf.format(c.getTime()) + " V2CUPLIFTandDonguri.login2ch:UPLIFT ログインキャンセル");
			V2CLogger.logError(null, "UPLIFT Login is Canceled in V2CUPLIFTandDonguri.login2ch().");
			V2C2chBBS.maruLoginFailed(flag);
			return false;
		}

		StringBuffer stringbuffer = new StringBuffer();
		PrintWriter printwriter = null;
		URL url = null;
		String ua = (V2CHttpUtil.useAPI?V2CHttpUtil.UAName:V2CHttpUtil.UAPostCGI);

		Thread thread = Thread.currentThread();
		if (!V2CMain.isOnlineMode()) {
			V2CHttpUtil.logNotOnline(userId);
			return false;
		}

		HttpsURLConnection httpsurlconnection;

		// UPLIFT Login
		try {
			url = new URL("https://uplift.5ch.net/log");
			if (v2cprogresspanel != null) {
				v2cprogresspanel.setMessage("opening connection ...");
			}
			httpsurlconnection = (HttpsURLConnection) V2CProxySetting
					.openReadConnection(url);
			if (thread.isInterrupted()) {
				V2CHttpUtil.logInterrupt(url);
				V2C2chBBS.maruLoginFailed(flag);
				return false;
			}
			if (V2CApp.javaVersionLessThan(1, 5)) {
				httpsurlconnection
						.setHostnameVerifier(new MyHostnameVerifier());
			}
			httpsurlconnection.setRequestMethod("POST");
			httpsurlconnection.setDoOutput(true);
			httpsurlconnection.setUseCaches(false);
			httpsurlconnection.setAllowUserInteraction(false);
			httpsurlconnection.setRequestProperty("Host", url.getHost());
			httpsurlconnection.setRequestProperty("Accept", "*/*");
			httpsurlconnection.setRequestProperty("User-Agent", ua);
			httpsurlconnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			httpsurlconnection.setRequestProperty("Referer", "https://" + url.getHost() + "/login");
			V2CLogger.logHTTPHeaderFields(url, "UPLIFT Login Request:",
					httpsurlconnection.getRequestProperties());
			printwriter = new PrintWriter(httpsurlconnection.getOutputStream());
			if (thread.isInterrupted()) {
				V2CHttpUtil.logInterrupt(url);
				V2C2chBBS.maruLoginFailed(flag);
				return false;
			}
			int j;
			if (v2cprogresspanel != null) {
				v2cprogresspanel.setMessage("sending id&pw ...");
			}
			printwriter.print("usr=" + V2CJPConverter.urlEncode(userId, "MS932")
			+ "&pwd=" + V2CJPConverter.urlEncode(passwd, "MS932"));

			printwriter.close();
			if (thread.isInterrupted()) {
				V2CHttpUtil.logInterrupt(url);
				V2C2chBBS.maruLoginFailed(flag);
				return false;
			}
			if (v2cprogresspanel != null) {
				v2cprogresspanel.setMessage("receiving session ID ...");
			}
			Map map = httpsurlconnection.getHeaderFields();
			if (map.containsKey("Set-Cookie")) {
				List list = (List) map.get("Set-Cookie");
				for (int l = 0; l < list.size(); l++){
					V2CCookie.addCookie((String) list.get(l), url);
					if(((String) list.get(l)).indexOf("sid=Monazilla/") != -1){
						stringbuffer.append((String) list.get(l));
					}
				}
			}
			V2CHttpUtil.logHTTPResponse(httpsurlconnection, "UPLIFT Login Response: ");
		} catch (IOException ioexception) {
			V2CLogger.logError(url, V2CMiscUtil.getMessage(ioexception),
					ioexception);
			V2C2chBBS.maruLoginFailed(flag);
			return false;
		} finally {
			V2CProxySetting.resetReadProxy();
			V2CLocalFileHandler.closeWriter(printwriter);
		}
		String str = stringbuffer.toString();
		String a[] = str.split("sid=");
		for(int i=0; i<a.length; i++){
			if((((String) a[i])).startsWith("Monazilla/")){
				str = ((String) a[i]).split(";")[0];
				V2C2chBBS.setMaruSessionIDForWrite(str, flag);
				break;
			}
		}
		if (str == null || str == "") {
			V2C2chBBS.maruLoginFailed(flag);
			return false;
		}
		
		return true;
	}

	static void upliftLogin(){
		V2C2chBBS v2c2chbbs = V2CBBS.get2chBBS();
		boolean before = v2c2chbbs.isMaruLoggedIn();
		V2C2chBBS.maruLogin();
		boolean after = v2c2chbbs.isMaruLoggedIn();
		
		if(V2CHttpUtil.useUPLIFT && before && !after){
			V2CScriptApp.putProperty("ret_upliftLogout", "true");

			if(V2CScriptApp.getProperty("hunterLogin") != null){
					V2CB11ScriptUtil.performAction("hunterLogin");
				V2CB11ScriptUtil.putGlobalBoolean("hunterLogin", false);
					V2CB11ScriptUtil.performAction("toggleCMDButton#ハンター#hunterLogin#Foreground=#Background=");
				}
		}else{
			V2CScriptApp.removeProperty("ret_upliftLogout");
		}
	}

	static boolean loginHunter(V2CProgressPanel v2cprogresspanel){
		V2C2chBBS v2c2chbbs = V2CBBS.get2chBBS();
		if(!v2c2chbbs.isMaruLoggedIn()){
			upliftLogin();
			if(!v2c2chbbs.isMaruLoggedIn()){
				V2CB11ScriptUtil.putGlobalBoolean("hunterLogin", false);
				return false;
			}
		}

		String ua = (V2CHttpUtil.useAPI?V2CHttpUtil.UAName:V2CHttpUtil.UAPostCGI);

		String p = (String) V2CScriptApp.getProperty("keibiinLogin");
		if(p != null){
			logoutKeibiin(null);
		}

		if (v2cprogresspanel != null) {
			v2cprogresspanel.setMessage("login Donguri Hunter ...");
		}
		HashMap hashmap = new HashMap(); 
		hashmap.put("Host", "donguri.5ch.net");
		hashmap.put("Accept", "text/html,*/*;q=0.8");
		hashmap.put("Accept-Language", "ja,en-US;q=0.7,en;q=0.3");
		hashmap.put("Accept-Encoding", "gzip");
		hashmap.put("User-Agent", ua);
		hashmap.put("Referer", "https://donguri.5ch.net/");
		CAndC localCAndC2 = V2CHttpUtil.getRawHTTPFile("https://donguri.5ch.net/login" , 6, hashmap);
		String s3 = V2CJPConverter.createString(localCAndC2.getRawContents(), V2CHttpUtil.getCharsetFromString(localCAndC2.getContentType()));
		System.out.println(s3);
		if(s3.indexOf("ハンター") != -1){
			if (v2cprogresspanel != null) {
				V2CSwingUtil.showInformationMessage("あなたはハンターです");
			}
			V2CB11ScriptUtil.putGlobalBoolean("hunterLogin", true);
			V2CB11ScriptUtil.putGlobalBoolean("keibiinLogin", false);
			System.out.println("あなたはハンターです");
		}else{
			V2CSwingUtil.showWarningMessage("なんか変\nハンターログインできなかった\n" + (s3.length()<257?"エラーメッセージ:\n"+s3:"コンソールログを確認してください"));
			V2CApp.getUserProperty().put("2chBBS.X-Donguri-Stat", "なんか変");
			System.out.println("どんぐりエラー ここから\n" + s3 + "\nどんぐりエラー ここまで");
			return false;
		}
		return true;
	}

	static void logoutHunter(V2CProgressPanel v2cprogresspanel){
		String ua = (V2CHttpUtil.useAPI?V2CHttpUtil.UAName:V2CHttpUtil.UAPostCGI);

		if (v2cprogresspanel != null) {
			v2cprogresspanel.setMessage("logout Donguri Hunter ...");
		}
		HashMap hashmap = new HashMap(); 
		hashmap.put("Host", "donguri.5ch.net");
		hashmap.put("Accept", "text/html,*/*;q=0.8");
		hashmap.put("Accept-Language", "ja,en-US;q=0.7,en;q=0.3");
		hashmap.put("Accept-Encoding", "gzip");
		hashmap.put("User-Agent", ua);
		hashmap.put("Referer", "https://donguri.5ch.net/");
		CAndC localCAndC2 = V2CHttpUtil.getRawHTTPFile("https://donguri.5ch.net/logout" , 6, hashmap);
		String s3 = V2CJPConverter.createString(localCAndC2.getRawContents(), V2CHttpUtil.getCharsetFromString(localCAndC2.getContentType()));
	}

	static String removeSIDfromCookie(URL paramURL, String paramString2, String str2){
		if(str2 == null){
			return str2;
		}
		if (V2CHttpUtil.is2ch.matcher(paramURL.toString()).matches() && paramString2 != null){
			if(paramString2.indexOf("sid=") == -1){
				str2 = str2.replaceAll("sid=[^; ]+?[; $]", "").replaceAll("; ?sid=[^; ]+$", "").replaceAll("  ", " ").replaceAll(";;", ";");
			}
		}
		return str2;
	}

	static String removeSIDfromMessage(URL paramURL, String paramString2){
		if(paramString2 == null){
			return paramString2;
		}
		if (V2CHttpUtil.is2ch.matcher(paramURL.toString()).matches() && paramString2 != null){
			if(paramString2.indexOf("&sid=") != -1){
				paramString2 = paramString2.replaceAll("&sid=[^&]+&", "&").replaceAll("  ", " ");
			}
		}
		return paramString2;
	}

	static String removeBlankCookie(URL paramURL, String str2){
		if(str2 == null){
			return str2;
		}
		if (V2CHttpUtil.is2ch.matcher(paramURL.toString()).matches()){
			str2 = str2.replaceAll("[^ ][^=]+=[; $]", " ").replaceAll("  ", " ").replaceAll("^ ", "");
		}
		return str2;
	}

	static void DonguriCannonConfirmer(String key){
		String s = (String) V2CScriptApp.getProperty(key);
		String[] params = s.split("<>");
		String[] as = {"砲撃", "中止"};
		String[] result = {"砲撃"};
		int ret = JOptionPane.showOptionDialog(V2CMain.v2cMain,
					params[0],
					params[1],
					javax.swing.JOptionPane.DEFAULT_OPTION,
					javax.swing.JOptionPane.PLAIN_MESSAGE,
					null,
					as,
					result
				);
		V2CScriptApp.putProperty(key, ret);
	}

	static boolean loginKeibiin(V2CProgressPanel v2cprogresspanel, String data){
		String ua = (V2CHttpUtil.useAPI?V2CHttpUtil.UAName:V2CHttpUtil.UAPostCGI);

		String p = (String) V2CScriptApp.getProperty("hunterLogin");
		if(p != null){
			logoutHunter(null);
		}

		if (v2cprogresspanel != null) {
			v2cprogresspanel.setMessage("login Donguri KeibiinLogin ...");
		}
		HashMap hashmap = new HashMap(); 
		hashmap.put("Host", "donguri.5ch.net");
		hashmap.put("Accept", "text/html,*/*;q=0.8");
		hashmap.put("Accept-Language", "ja,en-US;q=0.7,en;q=0.3");
		hashmap.put("Accept-Encoding", "gzip");
		hashmap.put("User-Agent", ua);
		hashmap.put("Referer", "https://donguri.5ch.net/");
		CAndC localCAndC2 = V2CHttpUtil.postForm("https://donguri.5ch.net/login" , data, hashmap);

		if(localCAndC2.getResponseCode() != 302){
			String s3 = V2CJPConverter.createString(localCAndC2.getRawContents(), V2CHttpUtil.getCharsetFromString(localCAndC2.getContentType()));
			V2CSwingUtil.showErrorMessage(s3);
			return false;
		}

		localCAndC2 = V2CHttpUtil.getRawHTTPFile("https://donguri.5ch.net/");
		String s3 = V2CJPConverter.createString(localCAndC2.getRawContents(), V2CHttpUtil.getCharsetFromString(localCAndC2.getContentType()));
		System.out.println(s3);
		if(s3.indexOf("警備員") != -1){
			if (v2cprogresspanel != null) {
				V2CSwingUtil.showInformationMessage("あなたは警備員です");
			}
			V2CB11ScriptUtil.putGlobalBoolean("keibiinLogin", true);
			V2CB11ScriptUtil.putGlobalBoolean("hunterLogin", false);
			System.out.println("あなたは警備員です");
		}else{
			V2CSwingUtil.showWarningMessage("なんか変\nハンターログインできなかった\n" + (s3.length()<257?"エラーメッセージ:\n"+s3:"コンソールログを確認してください"));
			V2CApp.getUserProperty().put("2chBBS.X-Donguri-Stat", "なんか変");
			System.out.println("どんぐりエラー ここから\n" + s3 + "\nどんぐりエラー ここまで");
			return false;
		}
		return true;
	}

	static void logoutKeibiin(V2CProgressPanel v2cprogresspanel){
		String ua = (V2CHttpUtil.useAPI?V2CHttpUtil.UAName:V2CHttpUtil.UAPostCGI);

		if (v2cprogresspanel != null) {
			v2cprogresspanel.setMessage("logout Donguri Keibiin ...");
		}
		HashMap hashmap = new HashMap(); 
		hashmap.put("Host", "donguri.5ch.net");
		hashmap.put("Accept", "text/html,*/*;q=0.8");
		hashmap.put("Accept-Language", "ja,en-US;q=0.7,en;q=0.3");
		hashmap.put("Accept-Encoding", "gzip");
		hashmap.put("User-Agent", ua);
		hashmap.put("Referer", "https://donguri.5ch.net/");
		CAndC localCAndC2 = V2CHttpUtil.getRawHTTPFile("https://donguri.5ch.net/logout" , 6, hashmap);
		String s3 = V2CJPConverter.createString(localCAndC2.getRawContents(), V2CHttpUtil.getCharsetFromString(localCAndC2.getContentType()));
	}

	static String getDonguriID(){
		String ua = (V2CHttpUtil.useAPI?V2CHttpUtil.UAName:V2CHttpUtil.UAPostCGI);

		HashMap hashmap = new HashMap(); 
		hashmap.put("Host", "donguri.5ch.net");
		hashmap.put("Accept", "text/html,*/*;q=0.8");
		hashmap.put("Accept-Language", "ja,en-US;q=0.7,en;q=0.3");
		hashmap.put("Accept-Encoding", "gzip");
		hashmap.put("User-Agent", ua);
		hashmap.put("Referer", "https://donguri.5ch.net/");
		CAndC localCAndC2 = V2CHttpUtil.getRawHTTPFile("https://donguri.5ch.net/" , 6, hashmap);
		String s3 = V2CJPConverter.createString(localCAndC2.getRawContents(), V2CHttpUtil.getCharsetFromString(localCAndC2.getContentType()));

		String id = "";
		Pattern p = Pattern.compile("<(?:div|h\\d+).*?>((?:ハンター|警備員).*?\\[ID:.+?\\])<\\/(?:div|h\\d+)>");
		Matcher m = p.matcher(s3);
		while (m.find()) {
			id = m.group(1);
		}
		p = Pattern.compile("経験値: +レベル: +(\\d+)");
		m = p.matcher(s3);
		while (m.find()) {
			id += "[Lv." +  m.group(1) + ']';
		}
		return id!=""?id:"Not Login";
		
	}

	static void showDonguriID(){
		String id = (String) getDonguriID();
		V2CSwingUtil.showInformationMessage(id!=""?id:"Not Login", "どんぐりID");
		
	}
}
