package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class V2CToolBarButtonPanel extends Box
{
	private static class BoardButton extends V2CToolBarItemButton
	{

		void doAction(MouseEvent mouseevent)
		{
			vBoardItem.open(true, V2CMouseClickManager.checkButtonClickAction("G", mouseevent));
		}

		String getSaveString()
		{
			return "Board," + vBoardItem.getURLString() + getIconSaveString() + V2CMiscUtil.escapeComma(getText());
		}

		String getOriginalName()
		{
			return vBoardItem.getName();
		}

		void setIcon(boolean flag)
		{
			setIcon(flag ? V2CBoardItem.getIcon() : null);
		}

		void openItemOutside()
		{
			V2CMiscUtil.openLinkOutside(vBoardItem.getURLString());
		}

		Object getItem()
		{
			return vBoardItem;
		}

		String getPopupMenuName()
		{
			return "ToolBarBoardButton";
		}

		V2CToolBarItemButton copyButton()
		{
			return new BoardButton(vBoardItem, this);
		}

		V2CBoardItem vBoardItem;

		BoardButton(String as[]) throws IllegalArgumentException
		{
			vBoardItem = V2CBoardItem.getBoardItem(as[1]);
			if (vBoardItem == null)
				throw new IllegalArgumentException();
			if (as.length >= 3 && as[2].equals("i"))
				setIcon(V2CBoardItem.getIcon());
			if (as.length >= 4)
				setText(as[3]);
		}

		BoardButton(V2CBoardItem v2cboarditem, V2CToolBarItemButton v2ctoolbaritembutton)
		{
			vBoardItem = v2cboarditem;
			if (v2ctoolbaritembutton == null || v2ctoolbaritembutton.getIcon() != null)
				setIcon(V2CBoardItem.getIcon());
			setText(vBoardItem.getName());
		}
	}

	private static class BoardCategoryButton extends V2CToolBarItemButton
	{

		void doAction(MouseEvent mouseevent)
		{
			String s = V2CMouseClickManager.checkButtonClickAction("G", mouseevent);
			if (s == null)
				return;
			boolean flag = s.equals("ON");
			JPopupMenu jpopupmenu = vBoardCategoryItem.createBoardMenu(flag);
			if (jpopupmenu == null) {
				V2CBoardCategoryItem v2cboardcategoryitem = V2CBoardCategoryItem
						.getBoardCategoryItem(vBBS.getID(), sCategoryName);
				if (v2cboardcategoryitem == null || v2cboardcategoryitem == vBoardCategoryItem)
					return;
				vBoardCategoryItem = v2cboardcategoryitem;
				jpopupmenu = v2cboardcategoryitem.createBoardMenu(flag);
				if (jpopupmenu == null)
					return;
			}
			Dimension dimension = jpopupmenu.getPreferredSize();
			Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(mouseevent.getPoint());
			if (dimension.height > rectangle.height) {
				int i = jpopupmenu.getComponentCount();
				int j = i / 2;
				JMenu jmenu = new JMenu("\u5F8C\u534A");
				for (int k = i - 1; k >= j; k--) {
					Component component = jpopupmenu.getComponent(k);
					jpopupmenu.remove(k);
					jmenu.add(component, 0);
				}

				jpopupmenu.insert(jmenu, 0);
			}
			jpopupmenu.show(this, 0, getHeight());
		}

		String getSaveString()
		{
			return "Category," + vBoardCategoryItem.getBBS().getID() + ','
					+ V2CMiscUtil.escapeComma(vBoardCategoryItem.getName()) + getIconSaveString()
					+ V2CMiscUtil.escapeComma(getText());
		}

		String getOriginalName()
		{
			return vBoardCategoryItem.getName();
		}

		void setIcon(boolean flag)
		{
			setIcon(flag ? V2CBoardTree.getFolderIcon() : null);
		}

		Object getItem()
		{
			return vBoardCategoryItem;
		}

		String getPopupMenuName()
		{
			return "ToolBarItemButtonLS";
		}

		V2CToolBarItemButton copyButton()
		{
			return new BoardCategoryButton(vBoardCategoryItem, this);
		}

		final V2CBBS vBBS;
		final String sCategoryName;
		V2CBoardCategoryItem vBoardCategoryItem;
		String sAction;
		boolean bInverse;

		BoardCategoryButton(String as[]) throws IllegalArgumentException
		{
			if (as.length < 3)
				throw new IllegalArgumentException();
			vBoardCategoryItem = V2CBoardCategoryItem.getBoardCategoryItem(as[1], as[2]);
			if (vBoardCategoryItem == null)
				throw new IllegalArgumentException();
			vBBS = vBoardCategoryItem.getBBS();
			sCategoryName = vBoardCategoryItem.getName();
			if (as.length >= 4 && as[3].equals("i"))
				setIcon(V2CBoardTree.getFolderIcon());
			if (as.length >= 5)
				setText(as[4]);
		}

		BoardCategoryButton(V2CBoardCategoryItem v2cboardcategoryitem, V2CToolBarItemButton v2ctoolbaritembutton)
		{
			vBoardCategoryItem = v2cboardcategoryitem;
			if (v2ctoolbaritembutton == null || v2ctoolbaritembutton.getIcon() != null)
				setIcon(V2CBoardTree.getFolderIcon());
			vBBS = vBoardCategoryItem.getBBS();
			sCategoryName = vBoardCategoryItem.getName();
			setText(sCategoryName);
		}
	}

	public static class CMDButton extends V2CToolBarItemButton
	{

		void doAction(MouseEvent mouseevent)
		{
			String s = V2CMouseClickManager.checkButtonClickAction("G", mouseevent);
			vExtCommand.performAction(true, s.equals("ON"));
		}

		void startAutoTLBS()
		{
			vExtCommand.startAutoTLBS();
		}

		String getSaveString()
		{
			V2CPackedPropValue v2cpackedpropvalue = vExtCommand.getSaveValue();
			if (v2cpackedpropvalue == null)
				return null;
			if (getIcon() != null)
				v2cpackedpropvalue.setBoolean('i', true);
			return "CMD," + v2cpackedpropvalue.getSaveString();
		}

		String getOriginalName()
		{
			return vExtCommand.getLabel();
		}

		void setIcon(boolean flag)
		{
			setIcon(flag ? vExtCommand.getIcon() : null);
		}

		void showProperty()
		{
			V2CExtCommand v2cextcommand = vExtCommand;
			String s = v2cextcommand.getLabel();
			String s1 = v2cextcommand.getCommand();
			String s2 = v2cextcommand.getIconName();
			int i = v2cextcommand.getOpenAction();
			V2CCMDPropSP v2ccmdpropsp = new V2CCMDPropSP(v2cextcommand, this, true);
			if (!v2ccmdpropsp.showDialog())
				return;
			boolean flag = !V2CMiscUtil.isEqual(s, v2cextcommand.getLabel());
			boolean flag1 = !V2CMiscUtil.isEqual(s1, v2cextcommand.getCommand());
			boolean flag2 = !V2CMiscUtil.isEqual(s2, v2cextcommand.getIconName());
			int j = v2cextcommand.getOpenAction();
			if (flag || flag1 || flag2 || j != i)
				V2CThreadListByScript.cmdChanged(v2cextcommand, flag, flag1, flag2);
			if (i == 1 && j != 1)
				setForeground(null);
			setText(v2cextcommand.getLabel());
			setIcon(v2ccmdpropsp.getShowIcon());
			V2CToolBarButtonPanel.requestSave();
		}

		boolean isCMDEqual(V2CExtCommand v2cextcommand)
		{
			return v2cextcommand == vExtCommand;
		}

		String getPopupMenuName()
		{
			return "ToolBarCMDButton";
		}

		V2CToolBarItemButton copyButton()
		{
			return new CMDButton(vExtCommand, this);
		}

		V2CExtCommand vExtCommand;

		CMDButton(String s) throws IllegalArgumentException
		{
			V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue(s);
			V2CExtCommand v2cextcommand = V2CExtCommand.restoreItem(v2cpackedpropvalue);
			if (v2cextcommand == null)
				throw new IllegalArgumentException();
			v2cextcommand.setToolBarButton(true);
			vExtCommand = v2cextcommand;
			if (v2cpackedpropvalue.getBoolean('i'))
				setIcon(v2cextcommand.getIcon());
			setText(v2cextcommand.getLabel());
		}

		CMDButton(V2CCMDPropSP v2ccmdpropsp, V2CToolBarItemButton v2ctoolbaritembutton)
		{
			V2CExtCommand v2cextcommand = v2ccmdpropsp.getExtCommand();
			v2cextcommand.setToolBarButton(true);
			vExtCommand = v2cextcommand;
			if (v2ccmdpropsp.getShowIcon())
				setIcon(v2cextcommand.getIcon());
			setText(v2cextcommand.getLabel());
		}

		CMDButton(V2CExtCommand v2cextcommand, V2CToolBarItemButton v2ctoolbaritembutton)
		{
			V2CExtCommand v2cextcommand1 = new V2CExtCommand(v2cextcommand);
			v2cextcommand1.setToolBarButton(true);
			vExtCommand = v2cextcommand1;
			if (v2ctoolbaritembutton == null || v2ctoolbaritembutton.getIcon() != null)
				setIcon(v2cextcommand1.getIcon());
			setText(v2cextcommand1.getLabel());
		}

		void toggleCMDButton(Component component, boolean showIcon, String IconName)
		{
			V2CExtCommand v2cextcommand = vExtCommand;
			String s = v2cextcommand.getLabel();
			String s1 = v2cextcommand.getCommand();
			String s2 = v2cextcommand.getIconName();
			int i = v2cextcommand.getOpenAction();

			V2CCMDPropSP v2ccmdpropsp = new V2CCMDPropSP(v2cextcommand, (V2CToolBarItemButton) component, true);
			setShowIconSetSelected(v2ccmdpropsp, showIcon);
			if(IconName != null) setIconName(v2ccmdpropsp, IconName);

			v2cextcommand.set(getLabel(v2ccmdpropsp), null, getWorkingDirectory(v2ccmdpropsp), getCommand(v2ccmdpropsp), '\0', getIconName(v2ccmdpropsp), getOpenAction(v2ccmdpropsp));
			v2cextcommand.addCMDButton();
			boolean flag = !V2CMiscUtil.isEqual(s, v2cextcommand.getLabel());
			boolean flag1 = !V2CMiscUtil.isEqual(s1, v2cextcommand.getCommand());
			boolean flag2 = !V2CMiscUtil.isEqual(s2, v2cextcommand.getIconName());
			int j = v2cextcommand.getOpenAction();
			if (flag || flag1 || flag2 || j != i)
				V2CThreadListByScript.cmdChanged(v2cextcommand, flag, flag1, flag2);
			if (i == 1 && j != 1)
				setForeground(null);
			setText(v2cextcommand.getLabel());
			setIcon(v2ccmdpropsp.getShowIcon());
			V2CToolBarButtonPanel.requestSave();
		}
		private void setShowIconSetSelected(V2CCMDPropSP v2ccmdpropsp, boolean showIcon)
		{
			v2ccmdpropsp.jcbShowIcon.setSelected(showIcon);
		}
		private void setIconName(V2CCMDPropSP v2ccmdpropsp, String  IconName)
		{
			v2ccmdpropsp.jcbIcon.setSelectedItem(IconName);
		}
		private String getLabel(V2CCMDPropSP v2ccmdpropsp)
		{
			return V2CMiscUtil.replaceTab2SP(v2ccmdpropsp.jtfLabel.getText());
		}
		private String getWorkingDirectory(V2CCMDPropSP v2ccmdpropsp)
		{
			return v2ccmdpropsp.jtfWorkingDirectory.getText();
		}
		private String getCommand(V2CCMDPropSP v2ccmdpropsp)
		{
			return v2ccmdpropsp.jtfCommand.getText();
		}
		private String getIconName(V2CCMDPropSP v2ccmdpropsp)
		{
			int i = v2ccmdpropsp.jcbIcon.getSelectedIndex();
			return i <= 0 ? null : (String) v2ccmdpropsp.jcbIcon.getSelectedItem();
		}
	 	private int getOpenAction(V2CCMDPropSP v2ccmdpropsp)
		{
			return v2ccmdpropsp.jcbOpenAction.getSelectedIndex();
		}
	}

	static class ClassStateSaver extends V2CClassStateSaver
	{

		public void doSaveState()
		{
			V2CToolBarButtonPanel.saveButtons();
		}

		void requestSave(boolean flag)
		{
			super.requestSave(flag);
			V2CExtCommand.clearCMDButtons();
		}

		ClassStateSaver(int i)
		{
			super(i);
		}
	}

	private class DnDListener implements DropTargetListener
	{

		DataFlavor checkDataFlavor(DropTargetEvent droptargetevent)
		{
			DataFlavor dataflavor = V2CToolBarItemButtonTransferable.dfItemButtonFlavor;
			if (V2CDnDUtil.isDataFlavorSupported(droptargetevent, dataflavor))
				return dataflavor;
			Class aclass[] = { V2CThreadItem.class, V2CBoardItem.class, V2CRSSItem.class, V2CBoardCategoryItem.class, V2CFavoritePanel.class, V2CURLItem.class };
			for (int i = 0; i < aclass.length; i++) {
				DataFlavor dataflavor1 = V2CTransferable.getFlavor(aclass[i]);
				if (V2CDnDUtil.isDataFlavorSupported(droptargetevent, dataflavor1))
					return dataflavor1;
			}

			return null;
		}

		void checkDrag(DropTargetDragEvent droptargetdragevent)
		{
			if ((droptargetdragevent.getSourceActions() & 3) == 0) {
				droptargetdragevent.rejectDrag();
				return;
			}
			DataFlavor dataflavor = checkDataFlavor(droptargetdragevent);
			if (dataflavor == null) {
				droptargetdragevent.rejectDrag();
				return;
			}
			int i;
			if (dataflavor.equals(V2CToolBarItemButtonTransferable.dfItemButtonFlavor)) {
				i = droptargetdragevent.getDropAction();
			}
			else {
				Point point = droptargetdragevent.getLocation();
				Component component = SwingUtilities.getDeepestComponentAt(V2CToolBarButtonPanel.this, point.x, point.y);
				boolean flag = true;
				if ((component instanceof FavoriteButton) && V2CApp.javaVersionEqualOrGreaterThan(1, 5)) {
					Object obj;
					try {
						obj = V2CJ2SE5Util.getTransferable(droptargetdragevent).getTransferData(dataflavor);
					}
					catch (Exception exception) {
						droptargetdragevent.rejectDrag();
						return;
					}
					V2CFavoritePanel v2cfavoritepanel = ((FavoriteButton) component).vFavoritePanel;
					if (!v2cfavoritepanel.isAddable(obj)) {
						droptargetdragevent.rejectDrag();
						return;
					}
				}
				i = 1;
			}
			droptargetdragevent.acceptDrag(i);
		}

		public void dragEnter(DropTargetDragEvent droptargetdragevent)
		{
			checkDrag(droptargetdragevent);
		}

		public void dragOver(DropTargetDragEvent droptargetdragevent)
		{
			checkDrag(droptargetdragevent);
		}

		public void dropActionChanged(DropTargetDragEvent droptargetdragevent)
		{
			checkDrag(droptargetdragevent);
		}

		public void dragExit(DropTargetEvent droptargetevent)
		{
		}

		public void drop(DropTargetDropEvent droptargetdropevent)
		{
			if (!droptargetdropevent.isLocalTransfer()) {
				droptargetdropevent.rejectDrop();
				return;
			}
			int i = droptargetdropevent.getSourceActions();
			int j = droptargetdropevent.getDropAction();
			int k = i & j;
			if ((k & 3) == 0) {
				droptargetdropevent.rejectDrop();
				return;
			}
			DataFlavor dataflavor = checkDataFlavor(droptargetdropevent);
			if (dataflavor == null) {
				droptargetdropevent.rejectDrop();
				return;
			}
			boolean flag = dataflavor.equals(V2CToolBarItemButtonTransferable.dfItemButtonFlavor);
			if (!flag)
				k = 1;
			droptargetdropevent.acceptDrop(k);
			final boolean bc = k == 1;
			final Object ov;
			try {
				ov = droptargetdropevent.getTransferable().getTransferData(dataflavor);
			}
			catch (Exception exception) {
				droptargetdropevent.dropComplete(false);
				return;
			}
			final Point p = droptargetdropevent.getLocation();
			final Component cmp = SwingUtilities.getDeepestComponentAt(V2CToolBarButtonPanel.this, p.x, p.y);
			boolean flag1 = true;
			if (!flag && (cmp instanceof FavoriteButton)) {
				V2CFavoritePanel v2cfavoritepanel = ((FavoriteButton) cmp).vFavoritePanel;
				flag1 = v2cfavoritepanel.isAddable(ov);
				if (flag1)
					v2cfavoritepanel.insertItem(ov);
			}
			else {
				EventQueue.invokeLater(new Runnable() {

					public void run()
					{
						if (cmp instanceof V2CToolBarItemButton) {
							insertButton((V2CToolBarItemButton) cmp, ov, bc);
						}
						else {
							nXPos = p.x;
							insertButton(ov, false, bc);
						}
					}
				});
			}
			droptargetdropevent.dropComplete(flag1);
		}

		private DnDListener()
		{
			super();
		}

	}

	private static class FavoriteButton extends V2CToolBarItemButton
	{

		void doAction(MouseEvent mouseevent)
		{
			if (mouseevent.getButton() == 2) {
				vFavoritePanel.showFavoritePopupMenu(this);
				return;
			}
			else {
				vFavoritePanel.open(true, V2CMouseClickManager.checkButtonClickAction("G", mouseevent));
				return;
			}
		}

		String getSaveString()
		{
			return "Favorite," + V2CMiscUtil.escapeComma(vFavoritePanel.getFavoriteName()) + getIconSaveString()
					+ V2CMiscUtil.escapeComma(getText());
		}

		String getOriginalName()
		{
			return vFavoritePanel.getFavoriteName();
		}

		void setIcon(boolean flag)
		{
			setIcon(flag ? vFavoritePanel.getIcon() : null);
		}

		Object getItem()
		{
			return vFavoritePanel;
		}

		String getPopupMenuName()
		{
			return "ToolBarItemButtonLS";
		}

		V2CToolBarItemButton copyButton()
		{
			return new FavoriteButton(vFavoritePanel, this);
		}

		V2CFavoritePanel vFavoritePanel;

		FavoriteButton(String as[]) throws IllegalArgumentException
		{
			int i = as.length;
			vFavoritePanel = V2CFavoritePanel.getFavoritePanel(as[1]);
			if (vFavoritePanel == null)
				throw new IllegalArgumentException();
			if (as.length >= 3 && as[2].equals("i"))
				setIcon(vFavoritePanel.getIcon());
			if (as.length >= 4)
				setText(as[3]);
		}

		FavoriteButton(V2CFavoritePanel v2cfavoritepanel, V2CToolBarItemButton v2ctoolbaritembutton)
		{
			vFavoritePanel = v2cfavoritepanel;
			if (v2ctoolbaritembutton == null || v2ctoolbaritembutton.getIcon() != null)
				setIcon(v2cfavoritepanel.getIcon());
			setText(v2cfavoritepanel.getFavoriteName());
		}
	}

	private class PopupListener extends V2CPopupListener
	{

		void setupAction(MouseEvent mouseevent)
		{
			nXPos = mouseevent.getX();
		}

		PopupListener()
		{
			super("ToolBarButtonPanel");
		}
	}

	private static class RSSButton extends V2CToolBarItemButton
	{

		void doAction(MouseEvent mouseevent)
		{
			vRSSItem.open(true, V2CMouseClickManager.checkButtonClickAction("G", mouseevent));
		}

		String getSaveString()
		{
			return "RSS," + vRSSItem.getURLString() + getIconSaveString() + V2CMiscUtil.escapeComma(getText());
		}

		String getOriginalName()
		{
			return vRSSItem.getName();
		}

		void setIcon(boolean flag)
		{
			setIcon(flag ? V2CRSSItem.getIcon() : null);
		}

		V2CToolBarItemButton copyButton()
		{
			return new RSSButton(vRSSItem, this);
		}

		V2CRSSItem vRSSItem;

		RSSButton(String as[]) throws IllegalArgumentException
		{
			vRSSItem = V2CRSSItem.getRSSItem(as[1]);
			if (vRSSItem == null)
				throw new IllegalArgumentException();
			if (as.length >= 3 && as[2].equals("i"))
				setIcon(V2CRSSItem.getIcon());
			if (as.length >= 4)
				setText(as[3]);
		}

		RSSButton(V2CRSSItem v2crssitem, V2CToolBarItemButton v2ctoolbaritembutton)
		{
			vRSSItem = v2crssitem;
			if (v2ctoolbaritembutton == null || v2ctoolbaritembutton.getIcon() != null)
				setIcon(V2CRSSItem.getIcon());
			setText(vRSSItem.getName());
		}
	}

	private static class ThreadButton extends V2CToolBarItemButton
	{

		void doAction(MouseEvent mouseevent)
		{
			vThreadItem.open(true, V2CMouseClickManager.checkButtonClickAction("G", mouseevent));
		}

		String getSaveString()
		{
			return "Thread," + vThreadItem.getBoardURLString() + ',' + vThreadItem.getDatName() + getIconSaveString()
					+ V2CMiscUtil.escapeComma(getText());
		}

		String getOriginalName()
		{
			return vThreadItem.getTitle();
		}

		void setIcon(boolean flag)
		{
			setIcon(flag ? vThreadItem.getIconForFP() : null);
		}

		void checkIcon()
		{
			javax.swing.Icon icon = getIcon();
			if (icon == null)
				return;
			javax.swing.Icon icon1 = vThreadItem.getIconForFP();
			if (icon == icon1) {
				return;
			}
			else {
				setIcon(icon1);
				return;
			}
		}

		V2CToolBarItemButton copyButton()
		{
			return new ThreadButton(vThreadItem, this);
		}

		V2CThreadItem vThreadItem;

		ThreadButton(String as[]) throws IllegalArgumentException
		{
			int i = as.length;
			if (i < 3)
				throw new IllegalArgumentException();
			vThreadItem = V2CThreadItem.getThreadItem(as[1], as[2]);
			if (vThreadItem == null)
				throw new IllegalArgumentException();
			if (as.length >= 4 && as[3].equals("i"))
				setIcon(vThreadItem.getIconForFP());
			if (as.length >= 5)
				setText(as[4]);
		}

		ThreadButton(V2CThreadItem v2cthreaditem, V2CToolBarItemButton v2ctoolbaritembutton)
		{
			vThreadItem = v2cthreaditem;
			if (v2ctoolbaritembutton == null || v2ctoolbaritembutton.getIcon() != null)
				setIcon(vThreadItem.getIconForFP());
			String s = vThreadItem.getTitle();
			if (s.length() > 10)
				s = s.substring(0, 10);
			setText(s);
		}
	}

	private static class URLButton extends V2CToolBarItemButton
	{

		void doAction(MouseEvent mouseevent)
		{
			String s = V2CMouseClickManager.checkButtonClickAction("G", mouseevent);
			if (s != null)
				vURLItem.open(s.equals("ON"), true);
		}

		void startAutoWebSearch()
		{
			vURLItem.startAutoWebSearch();
		}

		String getSaveString()
		{
			V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue();
			vURLItem.setProperty(v2cpackedpropvalue);
			if (getIcon() != null)
				v2cpackedpropvalue.setBoolean('i', true);
			return "URL," + v2cpackedpropvalue.getSaveString();
		}

		String getOriginalName()
		{
			return vURLItem.getLabel();
		}

		void setIcon(boolean flag)
		{
			setIcon(flag ? vURLItem.getIcon() : null);
		}

		void showProperty()
		{
			String s = vURLItem.getURLString();
			int i = vURLItem.getOpenAction();
			V2CURLPropSP v2curlpropsp = new V2CURLPropSP(vURLItem, this, true);
			if (!v2curlpropsp.showDialog())
				return;
			URL url = v2curlpropsp.getURL();
			int j = v2curlpropsp.getOpenAction();
			if (i == 2 && (j != 2 || !s.equals(url.toString())))
				V2CWebSearchList.stopAutoChecking(new V2CWebSearchItem(vURLItem, true));
			vURLItem.set(v2curlpropsp);
			if (i == 2 && j != 2)
				setForeground(null);
			setText(vURLItem.getLabel());
			setIcon(v2curlpropsp.getShowIcon());
			V2CToolBarButtonPanel.requestSave();
		}

		boolean isURLEqual(String s)
		{
			return s.equals(vURLItem.getURLString());
		}

		String getPopupMenuName()
		{
			return "ToolBarURLButton";
		}

		V2CToolBarItemButton copyButton()
		{
			return new URLButton(vURLItem, this);
		}

		V2CURLItem vURLItem;

		URLButton(String s) throws IllegalArgumentException
		{
			V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue(s);
			V2CURLItem v2curlitem = V2CURLItem.restoreItem(v2cpackedpropvalue);
			if (v2curlitem == null)
				throw new IllegalArgumentException();
			vURLItem = v2curlitem;
			if (v2cpackedpropvalue.getBoolean('i'))
				setIcon(v2curlitem.getIcon());
			setText(v2curlitem.getLabel());
		}

		URLButton(V2CURLPropSP v2curlpropsp, V2CToolBarItemButton v2ctoolbaritembutton)
		{
			vURLItem = v2curlpropsp.getURLItem();
			if (v2curlpropsp.getShowIcon())
				setIcon(vURLItem.getIcon());
			setText(vURLItem.getLabel());
		}

		URLButton(V2CURLItem v2curlitem, V2CToolBarItemButton v2ctoolbaritembutton)
		{
			vURLItem = new V2CURLItem(v2curlitem);
			if (v2ctoolbaritembutton == null || v2ctoolbaritembutton.getIcon() != null)
				setIcon(v2curlitem.getIcon());
			setText(vURLItem.getLabel());
		}
	}

	static void requestSave()
	{
		classStateSaver.requestSave();
	}

	static V2CToolBarButtonPanel getButtonPanel(String s)
	{
		V2CToolBarButtonPanel v2ctoolbarbuttonpanel = (V2CToolBarButtonPanel) hmButtonPanels.get(s);
		if (v2ctoolbarbuttonpanel == null) {
			v2ctoolbarbuttonpanel = new V2CToolBarButtonPanel(s);
			hmButtonPanels.put(s, v2ctoolbarbuttonpanel);
		}
		return v2ctoolbarbuttonpanel;
	}

	static boolean checkItem(Object obj)
	{
		return (obj instanceof V2CBoardCategoryItem) || (obj instanceof V2CBoardItem) || (obj instanceof V2CThreadItem)
				|| (obj instanceof V2CFavoritePanel) || (obj instanceof V2CRSSItem) || (obj instanceof V2CURLItem)
				|| (obj instanceof V2CExtCommand);
	}

	static void restoreButtons()
	{
		BufferedReader bufferedreader = null;
		bufferedreader = V2CLocalFileHandler.getUserConfigReader("tbbutton.txt");
		if (bufferedreader == null)
			return;
		try {
			V2CToolBarButtonPanel v2ctoolbarbuttonpanel = null;
			do {
				String s;
				if ((s = bufferedreader.readLine()) == null)
					break;
				if (s.length() != 0 && s.charAt(0) != '#')
					if (s.startsWith("URL,")) {
						if (v2ctoolbarbuttonpanel != null)
							v2ctoolbarbuttonpanel.add(new URLButton(s.substring(4)));
					}
					else if (s.startsWith("CMD,")) {
						if (v2ctoolbarbuttonpanel != null)
							v2ctoolbarbuttonpanel.add(new CMDButton(s.substring(4)));
					}
					else {
						String as[] = V2CMiscUtil.split(s);
						int i = as.length;
						if (as[0].equals("ToolBar")) {
							if (i >= 2)
								v2ctoolbarbuttonpanel = getButtonPanel(as[1]);
						}
						else if (i >= 2 && v2ctoolbarbuttonpanel != null)
							v2ctoolbarbuttonpanel.addButton(as);
					}
			} while (true);
		}
		catch (IOException ioexception) {
			System.out.println(ioexception.getMessage());
		}
		finally {
			V2CLocalFileHandler.closeReader(bufferedreader);
		}
	}

	static void saveButtons()
	{
		String s = System.getProperty("line.separator");
		StringBuffer stringbuffer = new StringBuffer();
		Iterator iterator = hmButtonPanels.keySet().iterator();
		do {
			if (!iterator.hasNext())
				break;
			String s1 = (String) iterator.next();
			V2CToolBarButtonPanel v2ctoolbarbuttonpanel = (V2CToolBarButtonPanel) hmButtonPanels.get(s1);
			stringbuffer.append("ToolBar,");
			stringbuffer.append(s1);
			stringbuffer.append(s);
			synchronized (v2ctoolbarbuttonpanel) {
				int i = v2ctoolbarbuttonpanel.getComponentCount();
				for (int j = 0; j < i; j++) {
					V2CToolBarItemButton v2ctoolbaritembutton = (V2CToolBarItemButton) v2ctoolbarbuttonpanel.getComponent(j);
					stringbuffer.append(v2ctoolbaritembutton.getSaveString());
					stringbuffer.append(s);
				}

			}
			stringbuffer.append(s);
		} while (true);
		String s2 = stringbuffer.toString();
		V2CLocalFileHandler.saveUserConfig("tbbutton.txt", s2);
	}

	  static V2CURLItem getURLButton(String paramString)
	  {
	    V2CURLItem localObject1 = null;
	    Iterator localIterator = hmButtonPanels.values().iterator();
	    while (localIterator.hasNext())
	    {
	      V2CToolBarButtonPanel localV2CToolBarButtonPanel = (V2CToolBarButtonPanel)localIterator.next();
	      synchronized (localV2CToolBarButtonPanel)
	      {
	        int i = localV2CToolBarButtonPanel.getComponentCount();
	        for (int j = 0; j < i; j++)
	        {
	          Component localComponent = localV2CToolBarButtonPanel.getComponent(j);
	          if ((localComponent instanceof URLButton))
	          {
	            URLButton localURLButton = (URLButton)localComponent;
	            if (localURLButton.isURLEqual(paramString))
	            {
	              V2CURLItem localV2CURLItem = localURLButton.vURLItem;
	              if (localV2CURLItem.getOpenAction() == 2) {
	                return localV2CURLItem;
	              }
	              if (localObject1 == null) {
	                localObject1 = localV2CURLItem;
	              }
	            }
	          }
	        }
	      }
	    }
	    return localObject1;
	  }

	static void getTLBSCMDs(ArrayList arraylist)
	{
		String as[] = { "Display", "Table", "Main" };
		int i = as.length - 1;
		do {
			if (i < 0)
				break;
			V2CToolBarButtonPanel v2ctoolbarbuttonpanel = getButtonPanel(as[i]);
			synchronized (v2ctoolbarbuttonpanel) {
				int j = v2ctoolbarbuttonpanel.getComponentCount();
				for (int k = 0; k < j; k++) {
					Component component = v2ctoolbarbuttonpanel.getComponent(k);
					if (!(component instanceof CMDButton))
						continue;
					V2CExtCommand v2cextcommand = ((CMDButton) component).vExtCommand;
					if (v2cextcommand.getOpenAction() == 1)
						arraylist.add(v2cextcommand);
				}

			}
			i--;
		} while (true);
	}

	static void startAutoWebSearch(V2CToolBarItemButton v2ctoolbaritembutton)
	{
		if (v2ctoolbaritembutton instanceof URLButton)
			((URLButton) v2ctoolbaritembutton).startAutoWebSearch();
		else if (v2ctoolbaritembutton instanceof CMDButton)
			((CMDButton) v2ctoolbaritembutton).startAutoTLBS();
	}

	static void webSearchStateChanged(Object obj, boolean flag, boolean flag1)
	{
		String s = null;
		V2CExtCommand v2cextcommand = null;
		if (obj instanceof String)
			s = (String) obj;
		else if (obj instanceof V2CExtCommand)
			v2cextcommand = (V2CExtCommand) obj;
		else
			return;
		Iterator iterator = hmButtonPanels.values().iterator();
		do {
			if (!iterator.hasNext())
				break;
			V2CToolBarButtonPanel v2ctoolbarbuttonpanel = (V2CToolBarButtonPanel) iterator.next();
			synchronized (v2ctoolbarbuttonpanel) {
				int i = v2ctoolbarbuttonpanel.getComponentCount();
				for (int j = 0; j < i; j++) {
					Component component = v2ctoolbarbuttonpanel.getComponent(j);
					if (s == null ? v2cextcommand != null
							&& (!(component instanceof CMDButton) || !((CMDButton) component).isCMDEqual(v2cextcommand))
							: !(component instanceof URLButton) || !((URLButton) component).isURLEqual(s))
						continue;
					Color color;
					if (flag)
						color = Color.RED;
					else
						color = flag1 ? Color.BLUE : null;
					component.setForeground(color);
					component.repaint();
				}

			}
		} while (true);
	}

	static void notifyUpdateThread()
	{
		Iterator iterator = hmButtonPanels.values().iterator();
		do {
			if (!iterator.hasNext())
				break;
			V2CToolBarButtonPanel v2ctoolbarbuttonpanel = (V2CToolBarButtonPanel) iterator.next();
			synchronized (v2ctoolbarbuttonpanel) {
				int i = v2ctoolbarbuttonpanel.getComponentCount();
				for (int j = 0; j < i; j++) {
					V2CToolBarItemButton v2ctoolbaritembutton = (V2CToolBarItemButton) v2ctoolbarbuttonpanel.getComponent(j);
					if (v2ctoolbaritembutton instanceof ThreadButton)
						((ThreadButton) v2ctoolbaritembutton).checkIcon();
				}

			}
		} while (true);
	}

	static void deleteThreadButton(V2CThreadItem v2cthreaditem)
	{
		notifyUpdateThread(v2cthreaditem, true);
	}

	static void notifyUpdateThread(V2CThreadItem v2cthreaditem)
	{
		notifyUpdateThread(v2cthreaditem, false);
	}

	private static void notifyUpdateThread(V2CThreadItem v2cthreaditem, boolean flag)
	{
		Iterator iterator = hmButtonPanels.values().iterator();
		do {
			if (!iterator.hasNext())
				break;
			V2CToolBarButtonPanel v2ctoolbarbuttonpanel = (V2CToolBarButtonPanel) iterator.next();
			synchronized (v2ctoolbarbuttonpanel) {
				int i = v2ctoolbarbuttonpanel.getComponentCount();
				for (int j = 0; j < i; j++) {
					V2CToolBarItemButton v2ctoolbaritembutton = (V2CToolBarItemButton) v2ctoolbarbuttonpanel.getComponent(j);
					if (!(v2ctoolbaritembutton instanceof ThreadButton))
						continue;
					ThreadButton threadbutton = (ThreadButton) v2ctoolbaritembutton;
					if (threadbutton.vThreadItem != v2cthreaditem)
						continue;
					if (flag)
						v2ctoolbarbuttonpanel.deleteButton(threadbutton);
					else
						threadbutton.checkIcon();
				}

			}
		} while (true);
	}

	  static boolean isRegistered(V2CThreadItem paramV2CThreadItem)
	  {
	    Iterator localIterator = hmButtonPanels.values().iterator();
	    while (localIterator.hasNext())
	    {
	      V2CToolBarButtonPanel localV2CToolBarButtonPanel = (V2CToolBarButtonPanel)localIterator.next();
	      synchronized (localV2CToolBarButtonPanel)
	      {
	        int i = localV2CToolBarButtonPanel.getComponentCount();
	        for (int j = 0; j < i; j++)
	        {
	          V2CToolBarItemButton localV2CToolBarItemButton = (V2CToolBarItemButton)localV2CToolBarButtonPanel.getComponent(j);
	          if ((localV2CToolBarItemButton instanceof ThreadButton))
	          {
	            ThreadButton localThreadButton = (ThreadButton)localV2CToolBarItemButton;
	            if (localThreadButton.vThreadItem == paramV2CThreadItem) {
	              return true;
	            }
	          }
	        }
	      }
	    }
	    return false;
	  }

	public V2CToolBarButtonPanel(String s)
	{
		super(0);
		setName(s);
		setBorder(new EmptyBorder(0, nSeparatorWidth, 0, nSeparatorWidth));
		setAlignmentY(0.5F);
		addMouseListener(new PopupListener());
		DropTarget droptarget = new DropTarget(this, new DnDListener());
	}

	public Dimension getMinimumSize()
	{
		if (getComponentCount() > 0)
			return super.getMinimumSize();
		else
			return dMinimum;
	}

	public Dimension getPreferredSize()
	{
		if (getComponentCount() > 0)
			return super.getPreferredSize();
		else
			return dMinimum;
	}

	public Dimension getMaximumSize()
	{
		if (getComponentCount() > 0)
			return new Dimension(32767, super.getMaximumSize().width);
		else
			return dMaximum;
	}

	void addButton(String as[])
	{
		String s = as[0];
		try {
			if (s.equals("Board"))
				add(new BoardButton(as));
			else if (s.equals("Thread"))
				add(new ThreadButton(as));
			else if (s.equals("Favorite"))
				add(new FavoriteButton(as));
			else if (s.equals("RSS"))
				add(new RSSButton(as));
			else if (s.equals("Category"))
				add(new BoardCategoryButton(as));
		}
		catch (IllegalArgumentException illegalargumentexception) {
		}
	}

	void pasteButton()
	{
		insertButton(null, false, false);
	}

	void insertButton(Object obj, boolean flag)
	{
		insertButton(obj, flag, false);
	}

	synchronized void insertButton(Object obj, boolean flag, boolean flag1)
	{
		V2CToolBarItemButton v2ctoolbaritembutton = null;
		int i = getComponentCount();
		if (i > 0 && !flag && nXPos < getWidth() / 2)
			v2ctoolbaritembutton = (V2CToolBarItemButton) getComponent(0);
		insertButton(v2ctoolbaritembutton, obj, flag1);
	}

	void pasteButton(V2CToolBarItemButton v2ctoolbaritembutton)
	{
		insertButton(v2ctoolbaritembutton, null, false);
	}

	void insertButton(V2CToolBarItemButton v2ctoolbaritembutton, Object obj)
	{
		insertButton(v2ctoolbaritembutton, obj, false);
	}

	synchronized void insertButton(V2CToolBarItemButton v2ctoolbaritembutton, Object obj, boolean flag)
	{
		if (v2ctoolbaritembutton != null && !isAncestorOf(v2ctoolbaritembutton))
			return;
		if (obj == null)
			obj = V2CFavoritePanel.getCopiedObject();
		if (obj == null)
			return;
		Object obj1 = null;
		if (obj instanceof V2CToolBarItemButton) {
			V2CToolBarItemButton v2ctoolbaritembutton1 = (V2CToolBarItemButton) obj;
			if (flag) {
				obj1 = v2ctoolbaritembutton1.copyButton();
			}
			else {
				if (v2ctoolbaritembutton1 == v2ctoolbaritembutton)
					return;
				Container container = v2ctoolbaritembutton1.getParent();
				if (container != null) {
					container.remove(v2ctoolbaritembutton1);
					if (container instanceof JComponent)
						((JComponent) container).revalidate();
				}
				obj1 = v2ctoolbaritembutton1;
			}
		}
		else if (obj instanceof V2CBoardCategoryItem)
			obj1 = new BoardCategoryButton((V2CBoardCategoryItem) obj, v2ctoolbaritembutton);
		else if (obj instanceof V2CBoardItem)
			obj1 = new BoardButton((V2CBoardItem) obj, v2ctoolbaritembutton);
		else if (obj instanceof V2CThreadItem)
			obj1 = new ThreadButton((V2CThreadItem) obj, v2ctoolbaritembutton);
		else if (obj instanceof V2CFavoritePanel)
			obj1 = new FavoriteButton((V2CFavoritePanel) obj, v2ctoolbaritembutton);
		else if (obj instanceof V2CRSSItem)
			obj1 = new RSSButton((V2CRSSItem) obj, v2ctoolbaritembutton);
		else if (obj instanceof V2CURLItem)
			obj1 = new URLButton((V2CURLItem) obj, v2ctoolbaritembutton);
		else if (obj instanceof V2CURLPropSP)
			obj1 = new URLButton((V2CURLPropSP) obj, v2ctoolbaritembutton);
		else if (obj instanceof V2CExtCommand)
			obj1 = new CMDButton((V2CExtCommand) obj, v2ctoolbaritembutton);
		else if (obj instanceof V2CCMDPropSP)
			obj1 = new CMDButton((V2CCMDPropSP) obj, v2ctoolbaritembutton);
		else
			return;
		int i = getComponentCount();
		int j = -1;
		if (v2ctoolbaritembutton != null) {
			int k = 0;
			do {
				if (k >= i)
					break;
				if (getComponent(k) == v2ctoolbaritembutton) {
					j = k;
					break;
				}
				k++;
			} while (true);
		}
		if (j >= 0)
			add(((Component) (obj1)), j);
		else
			add(((Component) (obj1)));
		revalidate();
		classStateSaver.requestSave();
	}

	void newURLButton(V2CToolBarItemButton v2ctoolbaritembutton)
	{
		V2CURLPropSP v2curlpropsp = new V2CURLPropSP(true);
		if (!v2curlpropsp.showDialog()) {
			return;
		}
		else {
			insertButton(v2ctoolbaritembutton, v2curlpropsp);
			return;
		}
	}

	void newCMDButton(V2CToolBarItemButton v2ctoolbaritembutton)
	{
		V2CCMDPropSP v2ccmdpropsp = new V2CCMDPropSP(true);
		if (!v2ccmdpropsp.showDialog()) {
			return;
		}
		else {
			insertButton(v2ctoolbaritembutton, v2ccmdpropsp);
			return;
		}
	}

	synchronized void deleteButton(V2CToolBarItemButton v2ctoolbaritembutton)
	{
		if (v2ctoolbaritembutton == null || !isAncestorOf(v2ctoolbaritembutton)) {
			return;
		}
		else {
			remove(v2ctoolbaritembutton);
			revalidate();
			classStateSaver.requestSave();
			return;
		}
	}

	synchronized void moveButton(V2CToolBarItemButton v2ctoolbaritembutton, boolean flag)
	{
		if (v2ctoolbaritembutton == null || !isAncestorOf(v2ctoolbaritembutton))
			return;
		int i = getComponentCount();
		int j = -1;
		int k = 0;
		do {
			if (k >= i)
				break;
			if (getComponent(k) == v2ctoolbaritembutton) {
				j = k;
				break;
			}
			k++;
		} while (true);
		if (j == -1 || !flag && j == 0 || flag && j == i - 1) {
			return;
		}
		else {
			remove(j);
			add(v2ctoolbaritembutton, flag ? j + 1 : j - 1);
			revalidate();
			classStateSaver.requestSave();
			return;
		}
	}

	static final String sFileName = "tbbutton.txt";
	static final int nSeparatorWidth;
	static ClassStateSaver classStateSaver = new ClassStateSaver(60);
	static final HashMap hmButtonPanels = new HashMap();
	static final Dimension dMinimum;
	static final Dimension dMaximum = new Dimension(32767, 32767);
	int nXPos;
	JPanel jpLeft;
	JPanel jpRight;
	JPanel jpPopup;


	static {
		Dimension dimension = UIManager.getDimension("ToolBar.separatorSize");
		nSeparatorWidth = dimension == null ? 5 : Math.max(dimension.width, 5);
		dMinimum = new Dimension(nSeparatorWidth, 16);
	}
}
