package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class V2CTextPopup2 extends JPanel implements V2CPopupPanel, ComponentListener
{
	private class ClickListener extends MouseAdapter implements MouseMotionListener
	{

		public void mouseClicked(MouseEvent mouseevent)
		{
			if (!bCloseOnLinkClick && (jTextComponent instanceof V2CHTMLPane) && ((V2CHTMLPane) jTextComponent).isLinkEntered())
				return;
			if (V2CSwingUtil.isSimpleClick(mouseevent))
				closePopupWindow();
		}

		public void mouseDragged(MouseEvent mouseevent)
		{
			if (!bDragWindow)
				return;
			mouseevent.consume();
			Rectangle rectangle = rScreenBounds;
			if (rectangle == null) {
				rectangle = V2CSwingUtil.getScreenBoundsAt(new Point(nLastX, nLastY));
				rScreenBounds = rectangle;
			}
			Point point = V2CSwingUtil.getMouseLocationOnScreen(mouseevent);
			int i = point.x - nLastX;
			int j = point.y - nLastY;
			nLastX = point.x;
			nLastY = point.y;
			Rectangle rectangle1 = jwPopupWindow.getBounds();
			int k = rectangle1.x + i;
			int l = rectangle1.y + j;
			if (rectangle == null)
				return;
			if (k < rectangle.x + 1)
				k = rectangle.x + 1;
			else if (k + rectangle1.width > (rectangle.x + rectangle.width) - 1)
				k = (rectangle.x + rectangle.width) - rectangle1.width - 1;
			if (l < rectangle.y + 1)
				l = rectangle.y + 1;
			else if (l + rectangle1.height > (rectangle.y + rectangle.height) - 1)
				l = (rectangle.y + rectangle.height) - rectangle1.height - 1;
			if (k == rectangle1.x && l == rectangle1.y)
				return;
			jwPopupWindow.setLocation(k, l);
			if (!bCursorSet) {
				bCursorSet = true;
				jTextComponent.setCursor(Cursor.getPredefinedCursor(12));
			}
		}

		public void mousePressed(MouseEvent mouseevent)
		{
			rScreenBounds = null;
			boolean flag = V2CSwingUtil.isSimpleClick(mouseevent) && mouseevent.getPoint().x < 20;
			bDragWindow = flag;
			if (flag) {
				Point point = mouseevent.getPoint();
				SwingUtilities.convertPointToScreen(point, mouseevent.getComponent());
				nLastX = point.x;
				nLastY = point.y;
			}
		}

		public void mouseReleased(MouseEvent mouseevent)
		{
			if (!bDragWindow)
				return;
			if (bCursorSet) {
				bCursorSet = false;
				jTextComponent.setCursor(Cursor.getDefaultCursor());
			}
		}

		public void mouseExited(MouseEvent mouseevent)
		{
			if (!jTextComponent.isFocusable() && !V2CMain.hasFocusInApplication())
				closePopupWindow();
		}

		public void mouseMoved(MouseEvent mouseevent)
		{
		}

		Rectangle rScreenBounds;
		boolean bDragWindow;
		int nLastX;
		int nLastY;
		boolean bCursorSet;

		private ClickListener()
		{
			super();
		}

	}

	private static class IDAndWindow
	{

		JWindow getWindow()
		{
			return (JWindow) refWin.get();
		}

		boolean isWindowVisible()
		{
			JWindow jwindow = getWindow();
			return jwindow != null && jwindow.isVisible();
		}

		final String sID;
		final Reference refWin;

		IDAndWindow(String s, JWindow jwindow)
		{
			sID = s;
			refWin = new WeakReference(jwindow);
		}
	}

	private class MouseExitGlassPane extends V2CMouseExitGlassPane
	{

		void doExitAction(MouseEvent mouseevent)
		{
			closePopupWindow();
		}

		MouseExitGlassPane(JWindow jwindow)
		{
			super(jwindow);
		}
	}

	  static boolean containsID(String paramString)
	  {
	    if (paramString == null) {
	      return false;
	    }
	    ArrayList localArrayList = vPopupIDs;
	    synchronized (localArrayList)
	    {
	      for (int i = localArrayList.size() - 1; i >= 0; i--)
	      {
	        IDAndWindow localIDAndWindow = (IDAndWindow)localArrayList.get(i);
	        if (!localIDAndWindow.isWindowVisible()) {
	          localArrayList.remove(i);
	        } else if (paramString.equals(localIDAndWindow.sID)) {
	          return true;
	        }
	      }
	    }
	    return false;
	  }

	public V2CTextPopup2(String s, Point point, Component component)
	{
		this(s, new V2CPopupPos(point), component);
	}

	public V2CTextPopup2(String s, V2CPopupPos v2cpopuppos, Component component)
	{
		this(s, v2cpopuppos);
		nSBWidth = 0;
		Object obj = null;
		if (component != null) {
			Window window = SwingUtilities.getWindowAncestor(component);
			if (window != null) {
				Window window1 = window.getOwner();
				if (window1 instanceof JFrame)
					obj = (JFrame) window1;
			}
		}
		if (obj == null)
			obj = V2CMain.v2cMain;
		vOwnerFrame = ((JFrame) (obj));
	}

	public V2CTextPopup2(String s, Point point)
	{
		this(s, false, new V2CPopupPos(point), null, 0, false, false, null);
	}

	public V2CTextPopup2(String s, V2CPopupPos v2cpopuppos)
	{
		this(s, false, v2cpopuppos, null, 0, false, false, null);
	}

	public V2CTextPopup2(String s, boolean flag, Point point, V2CEvalScript v2cevalscript, int i, boolean flag1, boolean flag2,
			String s1)
	{
		this(s, flag, new V2CPopupPos(point), v2cevalscript, i, flag1, flag2, s1);
	}

	public V2CTextPopup2(String s, boolean flag, V2CPopupPos v2cpopuppos, V2CEvalScript v2cevalscript, int i, boolean flag1,
			boolean flag2, String s1)
	{
		super(new GridBagLayout());
		nSBWidth = 20;
		vPopupPos = v2cpopuppos;
		bCloseOnLinkClick = v2cevalscript == null || v2cevalscript.getCloseOnLinkClick();
		bCloseOnExit = flag1;
		nMaxPopupWidth = i;
		sPopupID = s1;
		Object obj;
		if (flag) {
			V2CHTMLPane v2chtmlpane = new V2CHTMLPane(s, v2cevalscript);
			obj = v2chtmlpane;
			v2chtmlpane.listenToHyperlinkEvent(true);
			v2chtmlpane.setBorder(BorderFactory.createEmptyBorder());
		}
		else {
			JTextArea jtextarea = new JTextArea(s);
			obj = jtextarea;
			jtextarea.addMouseListener(new V2CTCPopupListener(jtextarea));
			jtextarea.setMargin(new Insets(2, 4, 2, 4));
		}
		jTextComponent = ((JTextComponent) (obj));
		((JTextComponent) (obj)).setEditable(false);
		if (!flag2)
			((JTextComponent) (obj)).setFocusable(false);
		((JTextComponent) (obj)).setDragEnabled(true);
		((JTextComponent) (obj)).setFont(V2CSSFont.getDefaultFont().getAwtFont());
		((JTextComponent) (obj)).setBackground(V2CThreadPopup.cPopupBG);
		((JTextComponent) (obj)).setForeground(V2CThreadStyle.getDefaultForeground());
		ClickListener clicklistener = new ClickListener();
		((JTextComponent) (obj)).addMouseListener(clicklistener);
		((JTextComponent) (obj)).addMouseMotionListener(clicklistener);
		((JTextComponent) (obj)).addComponentListener(this);
		setBorder(BorderFactory.createLineBorder(Color.BLACK));
		JScrollPane jscrollpane = new JScrollPane(((Component) (obj)));
		jScrollPane = jscrollpane;
		jscrollpane.setBorder(BorderFactory.createEmptyBorder());
		jscrollpane.setHorizontalScrollBarPolicy(31);
		GridBagConstraints gridbagconstraints = V2CSwingUtil.createGridBagConstraints();
		gridbagconstraints.fill = 1;
		gridbagconstraints.weightx = gridbagconstraints.weighty = 1.0D;
		add(jscrollpane, gridbagconstraints);
	}

	void setTextFocusable(boolean flag)
	{
		jTextComponent.setFocusable(flag);
	}

	void setTextMargin(Insets insets)
	{
		jTextComponent.setMargin(insets);
	}

	public boolean isCloseOnExit()
	{
		return true;
	}

	  void showPopup()
	  {
	    final JWindow jw = new JWindow(this.vOwnerFrame != null ? this.vOwnerFrame : V2CMain.v2cMain);
	    this.jwPopupWindow = jw;
	    if (this.sPopupID != null)
	    {
	      synchronized (vPopupIDs)
	      {
	        vPopupIDs.add(new IDAndWindow(this.sPopupID, jw));
	      }
	      jw.addWindowListener(new WindowAdapter()
	      {
	        public void windowClosed(WindowEvent paramAnonymousWindowEvent)
	        {
	          ArrayList localArrayList = V2CTextPopup2.vPopupIDs;
	          synchronized (localArrayList)
	          {
	            for (int i = localArrayList.size() - 1; i >= 0; i--)
	            {
	              JWindow localJWindow = ((V2CTextPopup2.IDAndWindow)localArrayList.get(i)).getWindow();
	              if (localJWindow == jw)
	              {
	                localArrayList.remove(i);
	                return;
	              }
	              if (localJWindow == null) {
	                localArrayList.remove(i);
	              }
	            }
	          }
	        }
	      });
	    }
	    jw.setContentPane(this);
	    if (this.bCloseOnExit) {
	      new MouseExitGlassPane(jw).addToWindow();
	    }
	    this.nResizeCount = 1;
	    resizeWindow();
	    jw.setVisible(true);
	    jw.toFront();
	  }

	private void resizeWindow()
	{
		if (nResizeCount-- < 0)
			return;
		JWindow jwindow = jwPopupWindow;
		if (jwindow == null)
			return;
		V2CPopupPos v2cpopuppos = vPopupPos;
		Point point = null;
		if (v2cpopuppos != null)
			point = v2cpopuppos.vNormalPopupPoint;
		if (point == null)
			point = jwindow.getLocation();
		JTextComponent jtextcomponent = jTextComponent;
		Dimension dimension = jtextcomponent.getSize();
		Dimension dimension1 = dLastSize;
		if (dimension1 != null && dimension1.equals(dimension))
			return;
		JScrollPane jscrollpane = jScrollPane;
		Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(point);
		Dimension dimension2 = V2CThreadPopup.getMaxPopupSize();
		Insets insets = getInsets();
		Insets insets1 = jscrollpane.getInsets();
		int i = Math.min(dimension2.width, rectangle.width - 2);
		if (nMaxPopupWidth > 0 && i > nMaxPopupWidth)
			i = nMaxPopupWidth;
		int j = Math.min(dimension2.height, rectangle.height - 2);
		Dimension dimension3 = jtextcomponent.getPreferredSize();
		int k = dimension3.width + insets1.left + insets1.right + insets.left + insets.right + nSBWidth;
		if (k > i) {
			k = i;
			if (jtextcomponent instanceof JTextArea)
				((JTextArea) jtextcomponent).setLineWrap(true);
			dimension3.width = i;
			jscrollpane.setPreferredSize(new Dimension(k, j - insets1.top - insets1.bottom));
			jwindow.pack();
			dimension3 = jtextcomponent.getPreferredScrollableViewportSize();
		}
		int l = Math.min(dimension3.height + insets1.top + insets1.bottom + insets.top + insets.bottom, j);
		jscrollpane.setPreferredSize(new Dimension(k, l));
		int i1 = (int) point.getX();
		int j1 = (int) point.getY();
		boolean flag = false;
		if (i1 + k + 2 > rectangle.x + rectangle.width) {
			flag = true;
			i1 = (rectangle.x + rectangle.width) - k - 1;
			if (v2cpopuppos != null) {
				Point point1 = v2cpopuppos.vMousePoint;
				Rectangle rectangle1 = v2cpopuppos.vPopupRegion;
				if (point1 != null && rectangle1 != null && i1 <= point1.x) {
					j1 = point1.y + 3;
					if (j1 >= rectangle1.y + rectangle1.height)
						j1 = (rectangle1.y + rectangle1.height) - 1;
				}
			}
		}
		if (j1 + l + 2 > rectangle.y + rectangle.height) {
			flag = true;
			j1 = (rectangle.y + rectangle.height) - l - 1;
		}
		if (flag)
			jwindow.setLocation(i1, j1);
		jwindow.setLocation(i1, j1);
		jwindow.pack();
		bPacked = true;
		dLastSize = jtextcomponent.getSize();
	}

	public void closePopupWindow()
	{
		EventQueue.invokeLater(new Runnable() {

			public void run()
			{
				jwPopupWindow.dispose();
			}
		});
	}

	Point getWindowLocation()
	{
		return jwPopupWindow.getLocation();
	}

	public void setText(String s)
	{
		jTextComponent.setText(s);
		if (bPacked) {
			dLastSize = null;
			nResizeCount = 1;
			resizeWindow();
		}
	}

	String getText()
	{
		return jTextComponent.getText();
	}

	void copyText()
	{
		JTextComponent jtextcomponent = jTextComponent;
		if (jtextcomponent instanceof V2CHTMLPane) {
			((V2CHTMLPane) jtextcomponent).copyText();
		}
		else {
			String s = jtextcomponent.getSelectedText();
			if (s == null)
				s = jtextcomponent.getText();
			V2CMain.copyString(s);
		}
	}

	void setLink(V2CLink v2clink)
	{
		vLink = v2clink;
	}

	V2CLink getLink()
	{
		return vLink;
	}

	void setKeyObject(Object obj)
	{
		vKeyObject = obj;
	}

	boolean checkKeyObject(Object obj)
	{
		return obj != null && obj == vKeyObject;
	}

	boolean checkKeyObjectEq(Object obj)
	{
		return obj != null && obj.equals(vKeyObject);
	}

	public void componentResized(ComponentEvent componentevent)
	{
		resizeWindow();
	}

	public void componentMoved(ComponentEvent componentevent)
	{
	}

	public void componentShown(ComponentEvent componentevent)
	{
	}

	public void componentHidden(ComponentEvent componentevent)
	{
	}

	static final ArrayList vPopupIDs = new ArrayList();
	JFrame vOwnerFrame;
	final JTextComponent jTextComponent;
	JWindow jwPopupWindow;
	final JScrollPane jScrollPane;
	final V2CPopupPos vPopupPos;
	final boolean bCloseOnLinkClick;
	final boolean bCloseOnExit;
	boolean bPacked;
	V2CLink vLink;
	int nMaxPopupWidth;
	Dimension dLastSize;
	final String sPopupID;
	Object vKeyObject;
	int nSBWidth;
	int nResizeCount;

}
