package org.monazilla.v2c;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.HashMap;
import java.util.List;

import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tls.TlsClientProtocol;

/**
 * TLS socket factory powered by bouncyCastle
 * @author koji.hayakawa
 * https://qiita.com/a__i__r/items/b75a381bf46a863b1139
 * https://github.com/a--i--r/TLSSocketFactory
 *
 */
public class V2CTLSSocketFactory extends SSLSocketFactory {

	// default socket timeout (0:infinite)
	public static final int SOCKET_TIMEOUT = 0;

	// Add for B11 Start
	// Java5用の外部から取得するホスト名格納Map
	public static HashMap hmHostName = new HashMap();;
	// IPv4/IPv6代行用の外部から取得するホスト名格納Map
	public static HashMap hmHostNameIPv46 = new HashMap();;
	// Add for B11 END
	
	// add bouncycastle provider
	static {
		if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
			Security.addProvider(new BouncyCastleProvider());
		}
	}

	// random number generator
	private SecureRandom		   secureRandom;
	private boolean			   selfSignPass = false;
	private int					soTimeout = SOCKET_TIMEOUT;

	public V2CTLSSocketFactory() {
		secureRandom = new SecureRandom();
	}

	public V2CTLSSocketFactory(boolean selfSignPass) {
		this();
		this.selfSignPass = selfSignPass;
	}
	public V2CTLSSocketFactory(boolean selfSignPass, int soTimeout) {
		this(selfSignPass);
		this.setSoTimeout(soTimeout);
	}

	public boolean isSelfSignPass() {
		return selfSignPass;
	}
	public void setSelfSignPass(boolean selfSignPass) {
		this.selfSignPass = selfSignPass;
	}
	public int getSoTimeout() {
		return soTimeout;
	}
	public void setSoTimeout(int soTimeout) {
		this.soTimeout = soTimeout;
	}

	@Override
	public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
		// Add for B11 Start
		// Java5の場合はhost名でIPアドレスが渡されるので、外部から取得したホスト名に置き変える
		if (V2CApp.javaVersionEqualTo(1, 5)) {
			if(hmHostName.containsKey(host)){
				List HostList = (List) hmHostName.get(host);
				host = (String) HostList.get(0);
			}
		}
		else
		if(hmHostNameIPv46.containsKey(host)){
			List HostList = (List) hmHostNameIPv46.get(host);
			host = (String) HostList.get(0);
		}
		// Add for B11 END

		if (socket == null) {
			socket = new Socket();
		}
		socket.setSoTimeout(this.soTimeout);

		if (!socket.isConnected()) {
			socket.connect(new InetSocketAddress(host, port));
		}
		TlsClientProtocol tlsClientProtocol = new TlsClientProtocol(socket.getInputStream(),
				socket.getOutputStream());
		return _createSSLSocket(host, port, tlsClientProtocol);
	}

	private SSLSocket _createSSLSocket(String host, int port, TlsClientProtocol tlsClientProtocol) {

		return new V2CTLSSocket(host, port, tlsClientProtocol, selfSignPass);
	}

	@Override
	public String[] getDefaultCipherSuites() {
		return V2CTLSSocket.CIPHER_SUITES;
	}

	@Override
	public String[] getSupportedCipherSuites() {
		return V2CTLSSocket.CIPHER_SUITES;
	}

	@Override
	public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
		return createSocket(null, host, port, false);
	}

	@Override
	public Socket createSocket(InetAddress host, int port) throws IOException {
		return createSocket(null, host.getHostName(), port, false);
	}

	@Override
	public Socket createSocket(String host, int port, InetAddress localHost, int localPort)
			throws IOException, UnknownHostException {
		return null;
	}

	@Override
	public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
		return null;
	}

}
