package org.monazilla.v2c;

import java.security.Principal;
import java.security.cert.Certificate;

import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;

import org.bouncycastle.tls.CipherSuite;

/**
 * TLS socket factory powered by bouncyCastle
 * @author koji.hayakawa
 * https://qiita.com/a__i__r/items/b75a381bf46a863b1139
 * https://github.com/a--i--r/TLSSocketFactory
 *
 */
public class V2CTLSSession implements SSLSession {

	private Certificate[] peerCertArray;
	protected V2CTLSClient tlsClient;
	private long created;

	public V2CTLSSession(V2CTLSClient tlsClient) {
		super();
		created = System.currentTimeMillis();
		this.tlsClient = tlsClient;
	}

	public V2CTLSClient getTlsClient() {
		return tlsClient;
	}

	public void setTlsClient(V2CTLSClient tlsClient) {
		this.tlsClient = tlsClient;
	}

	/**
	 * peerCertArray を取得します
	 * @return peerCertArray
	 */
	public Certificate[] getPeerCertArray() {
		return peerCertArray;
	}

	/**
	 * peerCertArray を設定します
	 * @param peerCertArray
	 */
	public void setPeerCertArray(Certificate[] peerCertArray) {
		this.peerCertArray = peerCertArray;
	}

	public int getApplicationBufferSize() {
		return 0;
	}

	public String getCipherSuite() {

		switch (this.tlsClient.getSelectedCipherSuite()) {

		case CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256:
			return "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";

		case CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256:
			return "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256";

		case CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA:
			return "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";

		case CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256:
			return "TLS_RSA_WITH_AES_128_GCM_SHA256";

		case CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA256:
			return "TLS_RSA_WITH_AES_128_CBC_SHA256";

		case CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA:
			return "TLS_RSA_WITH_AES_128_CBC_SHA";

		case CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256:
			return "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";

		case CipherSuite.TLS_DHE_RSA_WITH_AES_128_CBC_SHA:
			return "TLS_DHE_RSA_WITH_AES_128_CBC_SHA";

		case CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256:
			return "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256";

		case CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256:
			return "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256";

		// TLS1.3
		case CipherSuite.TLS_AES_128_GCM_SHA256:
			return "TLS_AES_128_GCM_SHA256";

		case CipherSuite.TLS_AES_256_GCM_SHA384:
			return "TLS_AES_256_GCM_SHA384";

		case CipherSuite.TLS_CHACHA20_POLY1305_SHA256:
			return "TLS_CHACHA20_POLY1305_SHA256";

		case CipherSuite.TLS_AES_128_CCM_SHA256:
			return "TLS_AES_128_CCM_SHA256";

		case CipherSuite.TLS_AES_128_CCM_8_SHA256:
			return "TLS_AES_128_CCM_8_SHA256";

		default:
//			throw new UnsupportedOperationException();
			return "" + this.tlsClient.getSelectedCipherSuite();
		}
	}

	public long getCreationTime() {
		return created;
	}

	public byte[] getId() {
		return this.tlsClient.getSession().getSessionID();
	}

	public long getLastAccessedTime() {
		return System.currentTimeMillis();
	}

	public Certificate[] getLocalCertificates() {
		throw new UnsupportedOperationException();
	}

	public Principal getLocalPrincipal() {
		throw new UnsupportedOperationException();
	}

	public int getPacketBufferSize() {
		return 0;
	}

	public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
		return null;
	}

	public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
		return peerCertArray;
	}

	public String getPeerHost() {
		return this.tlsClient.getHost();
	}

	public int getPeerPort() {
		return this.tlsClient.getPort();
	}

	public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
		return null;
	}

	public String getProtocol() {
		switch (this.tlsClient.getProtocol().getFullVersion()) {
		case 0x0301:
			return "TLSv1";
		case 0x0302:
			return "TLSv1.1";
		case 0x0303:
			return "TLSv1.2";
		case 0x0304:
			return "TLSv1.3";
		default:
//			throw new IllegalStateException();
			return "" + this.tlsClient.getProtocol().getFullVersion();
		}
	}

	public SSLSessionContext getSessionContext() {
		throw new UnsupportedOperationException();
	}

	public Object getValue(String paramString) {
		throw new UnsupportedOperationException();
	}

	public String[] getValueNames() {
		throw new UnsupportedOperationException();
	}

	public void invalidate() {
		throw new UnsupportedOperationException();
	}

	public boolean isValid() {
		throw new UnsupportedOperationException();
	}

	public void putValue(String paramString, Object paramObject) {
		throw new UnsupportedOperationException();
	}

	public void removeValue(String paramString) {
		throw new UnsupportedOperationException();
	}

}
