package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;

import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import org.monazilla.v2c.mac.V2CMacApplicationHandler;

public class V2CSwingUtil
{
	private static class CloseButton extends JButton implements ActionListener
	{

		public void actionPerformed(ActionEvent actionevent)
		{
			Container container = SwingUtilities.getAncestorOfClass(JOptionPane.class, this);
			if (container != null)
				((JOptionPane) container).setValue(this);
			container = SwingUtilities.getAncestorOfClass(JDialog.class, this);
			if (container != null)
				((JDialog) container).dispose();
		}

		CloseButton(String s)
		{
			super(s);
			addActionListener(this);
		}
	}

	static class FocusOptionPane extends JOptionPane
	{

		public void selectInitialValue()
		{
			super.selectInitialValue();
			if (jcFocus != null) {
				jcFocus.requestFocus();
				jcFocus = null;
			}
		}

		JComponent jcFocus;

		public FocusOptionPane(Object obj, int i, int j, Icon icon, Object aobj[], Object obj1, JComponent jcomponent)
		{
			super(obj, i, j, icon, aobj, obj1);
			jcFocus = jcomponent;
		}
	}

	static class ImageFilter extends FileFilter
	{

		public boolean accept(File file)
		{
			if (file.isDirectory())
				return true;
			String s = file.getName();
			if (s == null || s.length() < 5)
				return false;
			return s.endsWith(".gif") || s.endsWith(".GIF") || s.endsWith(".jpg") || s.endsWith(".JPG") || s.endsWith(".png")
					|| s.endsWith(".PNG") || s.endsWith(".mp4") || s.endsWith(".MP4") || s.endsWith(".mov") || s.endsWith(".MOV");
		}

		public String getDescription()
		{
			return "Image Files (*.gif; *.jpg; *.png; *.mp4; *.mov)";
		}

		ImageFilter()
		{
		}
	}

	static class ImageFilterImageUpload extends FileFilter
	{

		public boolean accept(File file)
		{
			if (file.isDirectory())
				return true;
			String s = file.getName();
			if (s == null || s.length() < 5)
				return false;
			return s.endsWith(".gif") || s.endsWith(".GIF") || s.endsWith(".jpg") || s.endsWith(".JPG") || s.endsWith(".png")
					|| s.endsWith(".PNG") || s.endsWith(".bmp") || s.endsWith(".BMP");
		}

		public String getDescription()
		{
			return "Image Files (*.gif; *.jpg; *.png; *.bmp)";
		}

		ImageFilterImageUpload()
		{
		}
	}

	public V2CSwingUtil()
	{
	}

	static String getClipboardText()
	{
		String s = null;
		Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
		if (clipboard != null) {
			Transferable transferable = clipboard.getContents(null);
			if (transferable != null)
				try {
					Object obj = transferable.getTransferData(DataFlavor.stringFlavor);
					if (obj instanceof String)
						s = (String) obj;
				}
				catch (Exception exception) {
				}
		}
		return s;
	}

	static void setRenderingHint(Graphics2D graphics2d)
	{
		if (bAAText)
			graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
		else
			V2CMain.addFontDesktopHints(graphics2d);
	}

	static void restoreTreeStates(JTree jtree, String s)
	{
		String s1 = V2CMain.getUserProperty().get(s);
		if (s1 == null || s1.length() == 0)
			return;
		String as[] = s1.split(",");
		for (int i = 0; i < as.length; i++) {
			String s2 = as[i];
			if (s2 == null || s2.length() == 0)
				continue;
			if (s2.indexOf('+') >= 0)
				restoreViewPosition((V2CPanel) jtree, s2);
			else
				restoreExpandedFolder(jtree, s2);
		}

	}

	static void restoreViewPosition(V2CPanel v2cpanel, String s)
	{
		int i = s.indexOf('+');
		if (i <= 0)
			return;
		int j = -1;
		int k = -1;
		try {
			j = Integer.parseInt(s.substring(0, i));
			k = Integer.parseInt(s.substring(i + 1));
		}
		catch (NumberFormatException numberformatexception) {
		}
		if (j < 0 || k < 0)
			return;
		Point point = v2cpanel.getViewPosition();
		if (point != null)
			point.y = k;
	}

	static void restoreExpandedFolder(JTree jtree, String s)
	{
		if (s == null || s.length() == 0)
			return;
		DefaultMutableTreeNode defaultmutabletreenode = (DefaultMutableTreeNode) jtree.getModel().getRoot();
		if (defaultmutabletreenode == null)
			return;
		TreePath treepath = new TreePath(defaultmutabletreenode);
		int j = 0;
		do {
			int i = s.indexOf(':', j);
			if (i <= 0)
				if (j < s.length())
					i = s.length();
				else if (s.length() >= j) {
					return;
				}
				else {
					jtree.expandPath(treepath);
					return;
				}
			try {
				int k = Integer.parseInt(s.substring(j, i));
				defaultmutabletreenode = (DefaultMutableTreeNode) defaultmutabletreenode.getChildAt(k);
			}
			catch (NumberFormatException numberformatexception) {
				return;
			}
			catch (ArrayIndexOutOfBoundsException arrayindexoutofboundsexception) {
				return;
			}
			treepath = treepath.pathByAddingChild(defaultmutabletreenode);
			j = i + 1;
		} while (true);
	}

	static void saveTreeStates(JTree jtree, String s)
	{
		StringBuffer stringbuffer = new StringBuffer();
		getTreeStateString(jtree, stringbuffer);
		if (stringbuffer.length() > 0)
			stringbuffer.setLength(stringbuffer.length() - 1);
		V2CMain.getUserProperty().put(s, stringbuffer.toString());
	}

	static void getTreeStateString(JTree jtree, StringBuffer stringbuffer)
	{
		getTreeStateString(jtree, stringbuffer, null);
	}

	static void getTreeStateString(JTree jtree, StringBuffer stringbuffer, String s)
	{
		if (!(jtree instanceof V2CPanel))
			return;
		Object obj = jtree.getModel().getRoot();
		if (obj == null)
			return;
		Enumeration enumeration = jtree.getExpandedDescendants(new TreePath(obj));
		if (enumeration != null)
			do {
				if (!enumeration.hasMoreElements())
					break;
				TreePath treepath = (TreePath) enumeration.nextElement();
				DefaultMutableTreeNode defaultmutabletreenode = (DefaultMutableTreeNode) treepath.getLastPathComponent();
				javax.swing.tree.TreeNode atreenode[] = defaultmutabletreenode.getPath();
				if (atreenode != null && atreenode.length > 1) {
					if (s != null)
						stringbuffer.append(s);
					DefaultMutableTreeNode defaultmutabletreenode2 = (DefaultMutableTreeNode) atreenode[0];
					for (int k = 1; k < atreenode.length; k++) {
						DefaultMutableTreeNode defaultmutabletreenode1 = (DefaultMutableTreeNode) atreenode[k];
						stringbuffer.append(defaultmutabletreenode2.getIndex(defaultmutabletreenode1));
						stringbuffer.append(':');
						defaultmutabletreenode2 = defaultmutabletreenode1;
					}

					if (stringbuffer.charAt(stringbuffer.length() - 1) == ':')
						stringbuffer.setLength(stringbuffer.length() - 1);
					stringbuffer.append(',');
				}
			} while (true);
		int i = 0;
		int j = 0;
		Container container = SwingUtilities.getAncestorOfClass(javax.swing.JScrollPane.class, jtree);
		if (container != null) {
			Point point = ((JScrollPane) container).getViewport().getViewPosition();
			i = point.x;
			j = point.y;
		}
		else {
			Point point1 = ((V2CPanel) jtree).getViewPosition();
			i = point1.x;
			j = point1.y;
		}
		if (i == 0 && j == 0)
			return;
		if (s != null)
			stringbuffer.append(s);
		stringbuffer.append(i);
		stringbuffer.append('+');
		stringbuffer.append(j);
		stringbuffer.append(',');
	}

	static Timer startDragAutoScrollTimer(ActionListener actionlistener)
	{
		stopDragAutoScrollTimer(actionlistener, false);
		Timer timer = tDragScrollTimer;
		if (timer == null) {
			timer = new Timer(10, actionlistener);
			tDragScrollTimer = timer;
		}
		else {
			if (timer.isRunning())
				timer.stop();
			if (vDragScrollTimerOwner != null)
				timer.removeActionListener(vDragScrollTimerOwner);
			timer.addActionListener(actionlistener);
		}
		vDragScrollTimerOwner = actionlistener;
		timer.start();
		return timer;
	}

	static void stopDragAutoScrollTimer(ActionListener actionlistener, boolean flag)
	{
		Timer timer = tDragScrollTimer;
		if (timer != null) {
			if (timer.isRunning())
				timer.stop();
			if (flag && vDragScrollTimerOwner != null) {
				timer.removeActionListener(vDragScrollTimerOwner);
				vDragScrollTimerOwner = null;
			}
		}
	}

	static void printParentClasses(Component component)
	{
		if (component == null)
			return;
		System.out.println("0: " + component.getClass());
		int i = 1;
		for (Container container = component.getParent(); container != null; container = container.getParent())
			System.out.println(" " + i++ + ": " + container.getClass());

	}

	static JScrollPane getParentScrollPane(Component component)
	{
		Container container = component.getParent();
		if (container instanceof JViewport) {
			container = container.getParent();
			if (container instanceof JScrollPane)
				return (JScrollPane) container;
		}
		return null;
	}

	static boolean isEqual(Color color, Color color1)
	{
		return color == null ? color1 == null : color.equals(color1);
	}

	static Color parseColorString(String s)
	{
		if (s == null || s.length() == 0)
			return null;
		if (s.charAt(0) != '#')
			return parseColorName(s);
		int i = s.length();
		if (i < 7)
			return null;
		if (s.charAt(1) == '#')
			s = "#0" + s.substring(2, i - 1);
		return parseHexColorString(s, 1, false);
	}

	static Color parseHexColorString(String s)
	{
		return parseHexColorString(s, 0, s.length(), false);
	}

	static Color parseHexColorString(String s, int i, boolean flag)
	{
		return parseHexColorString(s, i, s.length(), flag);
	}

	static Color parseHexColorString(String s, int i, int j, boolean flag)
	{
		int k = j - i;
		boolean flag1;
		boolean flag2;
		if (k == 3) {
			flag1 = false;
			flag2 = false;
		}
		else if (k == 6) {
			flag1 = true;
			flag2 = false;
		}
		else if (k == 4) {
			flag1 = false;
			flag2 = true;
		}
		else if (k == 8) {
			flag1 = true;
			flag2 = true;
		}
		else {
			return null;
		}
		int l = V2CMiscUtil.parseHexInt(s, i, j, 0);
		if (!flag1) {
			int i1 = l & 0xf000;
			int j1 = l & 0xf00;
			int k1 = l & 0xf0;
			int l1 = l & 0xf;
			l = i1 << 16 | i1 << 12 | j1 << 12 | j1 << 8 | k1 << 8 | k1 << 4 | l1 << 4 | l1;
		}
		if (flag2 && flag)
			l = l << 24 | l >>> 8;
		return new Color(l, flag2);
	}

	static Color parseColorName(String s)
	{
		return parseColorName(s, true);
	}

	static Color parseColorName(String s, boolean flag)
	{
		synchronized (hmColorNames) {
			if (hmColorNames.size() == 0)
				fillColorNameHashMap();
		}
		Color color = (Color) hmColorNames.get(s.toLowerCase());
		if (!flag || color != null)
			return color;
		else
			return parseHexColorString(s, 0, false);
	}

	static void fillColorNameHashMap()
	{
		HashMap hashmap = hmColorNames;
		hashmap.put("transparent", new Color(0, true));
		java.io.BufferedInputStream bufferedinputstream = V2CLocalFileHandler
				.getJarFileInputStream("org/monazilla/v2c/conf/color.dat");
		if (bufferedinputstream == null)
			return;
		DataInputStream datainputstream = null;
		try {
			datainputstream = new DataInputStream(bufferedinputstream);
			do {
				int i = datainputstream.readInt();
				if (i < 0)
					break;
				String s = datainputstream.readUTF();
				hashmap.put(s, new Color(i));
			} while (true);
		}
		catch (IOException ioexception) {
			ioexception.printStackTrace();
		}
		finally {
			if (datainputstream != null)
				try {
					datainputstream.close();
				}
				catch (IOException ioexception1) {
				}
			else
				try {
					bufferedinputstream.close();
				}
				catch (IOException ioexception2) {
				}
		}
	}

	static String colorToString(Color color)
	{
		int i = ((color.getRed() << 8) + color.getGreen() << 8) + color.getBlue();
		int j = color.getAlpha();
		byte byte0 = 7;
		if (j != 255) {
			i |= j << 24;
			byte0 = 9;
		}
		String s = Integer.toHexString(i);
		return "#00000000".substring(0, byte0 - s.length()) + s;
	}

	static ImageIcon getItemIcon(String name, char ic_type)
	{
		String str = name + '_' + ic_type;
		synchronized (hmIcons) {
			ImageIcon localImageIcon1 = getItemIcon(str);
			if (localImageIcon1 != null) {
				return localImageIcon1;
			}
		}
		final ImageIcon iib = getItemIcon(name);
		final ImageIcon iim = getItemIcon("Overlay_" + ic_type);
		final ImageIcon icnew = new ImageIcon();
		if (SwingUtilities.isEventDispatchThread()) {
			overlayIcon(icnew, iib, iim);
		}
		else {
			try {
				EventQueue.invokeAndWait(new Runnable() {

					public void run()
					{
						V2CSwingUtil.overlayIcon(icnew, iib, iim);
					}
				});
			}
			catch (InvocationTargetException localInvocationTargetException) {
			}
			catch (InterruptedException localInterruptedException) {
			}
		}
		synchronized (hmIcons) {
			ImageIcon localImageIcon3 = getItemIcon(str);
			if (localImageIcon3 != null) {
				return localImageIcon3;
			}
			hmIcons.put(str, icnew);
		}
		return icnew;
	}

	static ImageIcon createFavoriteIcon(ImageIcon imageicon)
	{
		return createOverlayIcon(imageicon, "Overlay_F");
	}

	static ImageIcon createUpdatingIcon(ImageIcon imageicon)
	{
		return createOverlayIcon(imageicon, "Overlay_U");
	}

	private static ImageIcon createOverlayIcon(final ImageIcon ic0, String s)
	{
		final ImageIcon icf = getItemIcon(s);
		if (icf == null)
			return ic0;
		final ImageIcon icnew = new ImageIcon();
		if (SwingUtilities.isEventDispatchThread())
			overlayIcon(icnew, ic0, icf);
		else
			try {
				EventQueue.invokeAndWait(new Runnable() {

					public void run()
					{
						V2CSwingUtil.overlayIcon(icnew, ic0, icf);
					}
				});
			}
			catch (InvocationTargetException invocationtargetexception) {
			}
			catch (InterruptedException interruptedexception) {
			}
		return icnew;
	}

	private static void overlayIcon(ImageIcon imageicon, ImageIcon imageicon1, ImageIcon imageicon2)
	{
		Image image = imageicon1.getImage();
		Object obj;
		if (image instanceof BufferedImage) {
			BufferedImage bufferedimage = (BufferedImage) image;
			java.awt.image.WritableRaster writableraster = bufferedimage.copyData(null);
			obj = new BufferedImage(bufferedimage.getColorModel(), bufferedimage.copyData(null), true, null);
		}
		else {
			obj = V2CMain.v2cMain.createImage(imageicon1.getIconWidth(), imageicon1.getIconHeight());
		}
		boolean flag = false;
		if (obj != null) {
			Graphics g = ((Image) (obj)).getGraphics();
			if (g != null) {
				flag = true;
				g.drawImage(imageicon1.getImage(), 0, 0, null);
				try {
					int i = Math.min(imageicon1.getIconWidth(), imageicon2.getIconWidth());
					int j = Math.min(imageicon1.getIconHeight(), imageicon2.getIconHeight());
					if (i > 0 && j > 0)
						g.drawImage(imageicon2.getImage(), 0, 0, i, j, 0, 0, i, j, null);
				}
				catch (Exception exception) {
					exception.printStackTrace();
				}
				g.dispose();
			}
		}
		if (flag)
			imageicon.setImage(((Image) (obj)));
	}

	public static ImageIcon getSystemIcon(String s)
	{
		return getSystemIcon(s, true);
	}

	public static ImageIcon getItemIcon(String s)
	{
		return getSystemIcon(s, true);
	}

	private static ImageIcon getSystemIcon(String paramString, boolean paramBoolean)
	{
		if ((paramString == null) || (paramString.length() == 0)) {
			return null;
		}
		ImageIcon localImageIcon;
		synchronized (hmIcons) {
			localImageIcon = (ImageIcon) hmIcons.get(paramString);
			if (localImageIcon != null) {
				return localImageIcon;
			}
			localImageIcon = V2CLocalFileHandler.getSystemIcon(paramString, paramBoolean);
			if (localImageIcon == null) {
				return null;
			}
			hmIcons.put(paramString, localImageIcon);
		}
		return localImageIcon;
	}

	static ImageIcon getSystemImage(String s)
	{
		if (s == null || s.length() == 0)
			return null;
		else
			return V2CLocalFileHandler.getSystemImage(s);
	}

	static boolean needsConversion(BufferedImage bufferedimage)
	{
		return bufferedimage != null && V2CApp.javaVersionEqualOrGreaterThan(1, 5);
	}

	static BufferedImage convertToCompatibeImage(BufferedImage bufferedimage)
	{
		return convertToCompatibeImage(bufferedimage, null);
	}

	static BufferedImage convertToCompatibeImage(BufferedImage bufferedimage, final Color cb)
	{
		if (!needsConversion(bufferedimage))
			return bufferedimage;
		if (EventQueue.isDispatchThread())
			return doConvertToCompatibeImage(bufferedimage, cb);
		final BufferedImage bil[] = new BufferedImage[1];
		bil[0] = bufferedimage;
		try {
			EventQueue.invokeAndWait(new Runnable() {

				public void run()
				{
					bil[0] = V2CSwingUtil.doConvertToCompatibeImage(bil[0], cb);
				}
			});
		}
		catch (Exception exception) {
		}
		return bil[0];
	}

	private static BufferedImage doConvertToCompatibeImage(BufferedImage bufferedimage, Color color)
	{
		GraphicsConfiguration graphicsconfiguration = V2CMain.v2cMain.getGraphicsConfiguration();
		BufferedImage bufferedimage1 = graphicsconfiguration.createCompatibleImage(bufferedimage.getWidth(),
				bufferedimage.getHeight(), 3);
		Graphics2D graphics2d = bufferedimage1.createGraphics();
		if (color != null) {
			graphics2d.setColor(color);
			graphics2d.fillRect(0, 0, bufferedimage.getWidth(), bufferedimage.getHeight());
		}
		graphics2d.drawImage(bufferedimage, 0, 0, null);
		graphics2d.dispose();
		bufferedimage = bufferedimage1;
		return bufferedimage;
	}

	static BufferedImage clipImage(BufferedImage bufferedimage, int i, int j, int k, int l)
	{
		int i1 = k - i;
		int j1 = l - j;
		if (i1 <= 0 || j1 <= 0) {
			return null;
		}
		else {
			BufferedImage bufferedimage1 = V2CMain.v2cMain.getGraphicsConfiguration().createCompatibleImage(i1, j1, 3);
			Graphics2D graphics2d = bufferedimage1.createGraphics();
			graphics2d.drawImage(bufferedimage, 0, 0, i1, j1, i, j, k, l, null);
			graphics2d.dispose();
			return bufferedimage1;
		}
	}

	static char restrictMnemonic(char c)
	{
		if (c == ' ')
			return c;
		if (c == 0 || c < '0' || c > 'z')
			return '\0';
		if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z')
			return c;
		if (c >= 'a' && c <= 'z')
			return (char) (c - 32);
		else
			return '\0';
	}

	static void addPopupToTextFields(Container container)
	{
		int i = container.getComponentCount();
		for (int j = 0; j < i; j++) {
			Component component = container.getComponent(j);
			if (component instanceof JTextField) {
				V2CPopupListener v2cpopuplistener = new V2CPopupListener("TextComponent");
				v2cpopuplistener.setRequestFocus(true);
				((JTextField) component).addMouseListener(v2cpopuplistener);
				continue;
			}
			if (component instanceof Container)
				addPopupToTextFields((Container) component);
		}

	}

	static void replaceDeletePrevAction(ActionMap actionmap)
	{
		if (actionmap == null)
			return;
		Object aobj[] = actionmap.keys();
		if (aobj != null) {
			for (int i = 0; i < aobj.length; i++)
				if ("delete-previous".equals(aobj[i])) {
					javax.swing.Action action = actionmap.get("delete-previous");
					if (action != null && !(action instanceof V2CNoBeepDeletePrevAction))
						actionmap.put("delete-previous", new V2CNoBeepDeletePrevAction(action));
					return;
				}

		}
		replaceDeletePrevAction(actionmap.getParent());
	}

	static void disableQuaquaTextComponentPopup(JTextComponent jtextcomponent)
	{
		if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.isQuaquaInstalled())
			jtextcomponent.putClientProperty("Quaqua.TextComponent.showPopup", Boolean.FALSE);
	}

	static JFileChooser createFileChooser()
	{
		return createFileChooser(null);
	}

	static JFileChooser createFileChooser(File file)
	{
		if (!V2CApp.isWinType())
			return new JFileChooser(file);
		if (bCreateFileChooserTried)
			if (bUseWinWOFileChooser)
				return new V2CWinWOFileChooser(file);
			else
				return new JFileChooser(file);
		bCreateFileChooserTried = true;
		Object obj = null;
		try {
			obj = new JFileChooser(file);
		}
		catch (Exception exception) {
			exception.printStackTrace();
		}
		if (obj == null) {
			bUseWinWOFileChooser = true;
			obj = new V2CWinWOFileChooser(file);
		}
		return ((JFileChooser) (obj));
	}

	static JTextField createTextField()
	{
		return createTextField(0);
	}

	static JTextField createTextField(int i)
	{
		V2CNoBeepTextField v2cnobeeptextfield = new V2CNoBeepTextField();
		if (i > 0)
			v2cnobeeptextfield.setColumns(i);
		return v2cnobeeptextfield;
	}

	static float getFloat(JFormattedTextField jformattedtextfield)
	{
		return getFloat(jformattedtextfield, 0.0F);
	}

	static float getFloat(JFormattedTextField jformattedtextfield, float f)
	{
		if (jformattedtextfield == null)
			return f;
		if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.isQuaquaInstalled())
			try {
				jformattedtextfield.commitEdit();
			}
			catch (ParseException parseexception) {
			}
		return ((Number) jformattedtextfield.getValue()).floatValue();
	}

	static int getInt(JFormattedTextField jformattedtextfield)
	{
		return getInt(jformattedtextfield, -1);
	}

	static int getInt(JFormattedTextField jformattedtextfield, int i)
	{
		if (jformattedtextfield == null)
			return i;
		try {
			jformattedtextfield.commitEdit();
		}
		catch (ParseException parseexception) {
		}
		return ((Number) jformattedtextfield.getValue()).intValue();
	}

	static int getInt(JSpinner jspinner)
	{
		try {
			jspinner.commitEdit();
		}
		catch (ParseException parseexception) {
		}
		return ((Number) jspinner.getValue()).intValue();
	}

	static void armRequestFocus(JComponent jcomponent)
	{
		armRequestFocus(jcomponent, false);
	}

	static void armRequestFocus(final JComponent jc, final boolean bf)
	{
		if (jc.isShowing())
			SwingUtilities.invokeLater(new Runnable() {

				public void run()
				{
					if (bf) {
						if (V2CApp.isMacintosh()) {
							Window window = SwingUtilities.getWindowAncestor(jc);
							if (window != null)
								window.toFront();
						}
						jc.requestFocus();
					}
					else {
						jc.requestFocusInWindow();
					}
				}
			});
	}

	static void openThreadLater(final V2CThreadItem ti, final boolean bu, final boolean bnt, final V2CThreadOpenRequest tor)
	{
		SwingUtilities.invokeLater(new Runnable() {

			public void run()
			{
				ti.open(bu, bnt, tor);
			}
		});
	}

	static void clearGraphicsConfiguration()
	{
		refGraphicsConfigs = null;
	}

	private static GraphicsConfiguration[] createGraphicsConfigArray()
	{
		Reference reference = refGraphicsConfigs;
		if (reference != null) {
			GraphicsConfiguration agraphicsconfiguration[] = (GraphicsConfiguration[]) (GraphicsConfiguration[]) reference.get();
			if (agraphicsconfiguration != null)
				return agraphicsconfiguration;
		}
		ArrayList arraylist = new ArrayList();
		GraphicsEnvironment graphicsenvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
		GraphicsDevice agraphicsdevice[] = graphicsenvironment.getScreenDevices();
		for (int i = 0; i < agraphicsdevice.length; i++)
			arraylist.add(agraphicsdevice[i].getDefaultConfiguration());

		GraphicsConfiguration graphicsconfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()
				.getDefaultConfiguration();
		if (arraylist.size() > 0) {
			if (arraylist.get(0) != graphicsconfiguration && arraylist.contains(graphicsconfiguration)) {
				arraylist.remove(graphicsconfiguration);
				arraylist.add(0, graphicsconfiguration);
			}
		}
		else {
			arraylist.add(graphicsconfiguration);
		}
		GraphicsConfiguration agraphicsconfiguration1[] = new GraphicsConfiguration[arraylist.size()];
		for (int j = 0; j < arraylist.size(); j++)
			agraphicsconfiguration1[j] = (GraphicsConfiguration) arraylist.get(j);

		refGraphicsConfigs = new SoftReference(agraphicsconfiguration1);
		return agraphicsconfiguration1;
	}

	static GraphicsConfiguration getGraphicsConfigurationAt(Point point)
	{
		GraphicsConfiguration agraphicsconfiguration[] = createGraphicsConfigArray();
		if (agraphicsconfiguration.length > 1) {
			for (int i = 0; i < agraphicsconfiguration.length; i++) {
				GraphicsConfiguration graphicsconfiguration = agraphicsconfiguration[i];
				Rectangle rectangle = graphicsconfiguration.getBounds();
				if (rectangle.contains(point))
					return graphicsconfiguration;
			}

		}
		return agraphicsconfiguration[0];
	}

	static Rectangle getScreenBoundsAt(int i, int j)
	{
		return getScreenBoundsAt(new Point(i, j));
	}

	static Rectangle getScreenBoundsAt(Point point)
	{
		GraphicsConfiguration agraphicsconfiguration[] = createGraphicsConfigArray();
		GraphicsConfiguration graphicsconfiguration = getGraphicsConfigurationAt(point);
		Rectangle rectangle = graphicsconfiguration.getBounds();
		if (graphicsconfiguration == agraphicsconfiguration[0]) {
			Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsconfiguration);
			rectangle = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left
					- insets.right, rectangle.height - insets.top - insets.bottom);
		}
		return rectangle;
	}

	static boolean checkWindowPosition(Point point)
	{
		if (point == null)
			return true;
		Rectangle rectangle = new Rectangle(point.x, point.y, 1, 1);
		boolean flag = checkWindowPosition(rectangle);
		if (!flag) {
			point.x = rectangle.x;
			point.y = rectangle.y;
		}
		return flag;
	}

	static boolean checkWindowPosition(Rectangle rectangle)
	{
		if (rectangle == null)
			return true;
		if (rTotalBounds == null) {
			Rectangle rectangle1 = null;
			GraphicsConfiguration agraphicsconfiguration[] = createGraphicsConfigArray();
			for (int k = 0; k < agraphicsconfiguration.length; k++) {
				GraphicsConfiguration graphicsconfiguration = agraphicsconfiguration[k];
				Rectangle rectangle2 = graphicsconfiguration.getBounds();
				if (rectangle1 == null)
					rectangle1 = rectangle2;
				else
					SwingUtilities.computeUnion(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle1);
			}

			rTotalBounds = rectangle1;
		}
		int i = rTotalBounds.x;
		int j = rTotalBounds.y;
		int l = i + rTotalBounds.width;
		int i1 = j + rTotalBounds.height;
		boolean flag = true;
		if (rectangle.x + 100 < i) {
			flag = false;
			rectangle.x = i;
		}
		if (rectangle.y + 5 < j) {
			flag = false;
			rectangle.y = j;
		}
		if (rectangle.x + 100 > l) {
			flag = false;
			rectangle.x = l - 100;
		}
		if (rectangle.y + 100 > i1) {
			flag = false;
			rectangle.y = i1 - 100;
		}
		return flag;
	}

	static boolean isAlwaysOnTopSupported()
	{
		if (V2CApp.javaVersionEqualOrGreaterThan(1, 6))
			return V2CJSE6Util.isAlwaysOnTopSupported();
		else
			return V2CApp.javaVersionEqualOrGreaterThan(1, 5);
	}

	static void toFront(JFrame jframe)
	{
		int i = jframe.getExtendedState();
		if ((i & 1) != 0)
			jframe.setExtendedState(i & -2);
		jframe.toFront();
	}

	static JRootPane getRootPane(Window window)
	{
		if (window instanceof JFrame)
			return ((JFrame) window).getRootPane();
		if (window instanceof JWindow)
			return ((JWindow) window).getRootPane();
		if (window instanceof JDialog)
			return ((JDialog) window).getRootPane();
		else
			return null;
	}

	static Container getContentPane(Window window)
	{
		if (window instanceof JFrame)
			return ((JFrame) window).getContentPane();
		if (window instanceof JWindow)
			return ((JWindow) window).getContentPane();
		if (window instanceof JDialog)
			return ((JDialog) window).getContentPane();
		else
			return null;
	}

	static void setContentPane(Window window, Container container)
	{
		if (window instanceof JFrame)
			((JFrame) window).setContentPane(container);
		else if (window instanceof JWindow)
			((JWindow) window).setContentPane(container);
		else if (window instanceof JDialog)
			((JDialog) window).setContentPane(container);
	}

	static Component getGlassPane(Window window)
	{
		if (window instanceof JFrame)
			return ((JFrame) window).getGlassPane();
		if (window instanceof JWindow)
			return ((JWindow) window).getGlassPane();
		if (window instanceof JDialog)
			return ((JDialog) window).getGlassPane();
		else
			return null;
	}

	static void setGlassPane(Window window, Component component)
	{
		if (window instanceof JFrame)
			((JFrame) window).setGlassPane(component);
		else if (window instanceof JWindow)
			((JWindow) window).setGlassPane(component);
		else if (window instanceof JDialog)
			((JDialog) window).setGlassPane(component);
	}

	static void expandMenuOfName(JPopupMenu jpopupmenu, String s)
	{
		label0: for (int i = jpopupmenu.getComponentCount() - 1; i >= 0; i--) {
			Component component = jpopupmenu.getComponent(i);
			if (!(component instanceof JMenu))
				continue;
			JMenu jmenu = (JMenu) component;
			if (!jmenu.getText().equals(s))
				continue;
			jpopupmenu.remove(i);
			int j = jmenu.getItemCount() - 1;
			do {
				if (j < 0)
					break label0;
				javax.swing.JMenuItem jmenuitem = jmenu.getItem(j);
				if (jmenuitem != null) {
					jmenu.remove(j);
					jpopupmenu.insert(jmenuitem, i);
				}
				else {
					jpopupmenu.insert(new javax.swing.JPopupMenu.Separator(), i);
				}
				j--;
			} while (true);
		}

	}

	static String addMnemonic(String s, char c)
	{
		if (s == null)
			s = "";
		int i = s.length();
		boolean flag = i > 0 && s.charAt(i - 1) == '…';
		StringBuffer stringbuffer = new StringBuffer(i + 3);
		stringbuffer.append(s);
		if (flag)
			stringbuffer.setLength(i - 1);
		stringbuffer.append('(');
		stringbuffer.append(c);
		stringbuffer.append(')');
		if (flag)
			stringbuffer.append('…');
		return stringbuffer.toString();
	}

	static Point tweakMouseLocationOnScreen(Point point, Component component)
	{
		if (V2CApp.isUNIX() && point != null) {
			Point point1 = new Point(point.x, point.y);
			SwingUtilities.convertPointToScreen(point1, component);
			if (point1.x == point.x && point1.y == point.y) {
				Window window = SwingUtilities.getWindowAncestor(component);
				if (window != null) {
					Point point2 = window.getLocation();
					point.x += point2.x;
					point.y += point2.y;
				}
			}
		}
		return point;
	}

	static Point getMouseLocationOnScreen(MouseEvent mouseevent)
	{
		if (V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return V2CJ2SE5Util.getMouseLocation();
		if (V2CApp.isMacintosh())
			return V2CMacApplicationHandler.getMouseLocationOnScreen();
		if (mouseevent != null) {
			Point point = mouseevent.getPoint();
			SwingUtilities.convertPointToScreen(point, mouseevent.getComponent());
			return point;
		}
		else {
			return new Point(0, 0);
		}
	}

	static Point getMouseLocation(Component component)
	{
		Point point;
		if (V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			point = V2CJ2SE5Util.getMouseLocation();
		else if (V2CApp.isMacintosh())
			point = V2CMacApplicationHandler.getMouseLocationOnScreen();
		else
			return null;
		SwingUtilities.convertPointFromScreen(point, component);
		return point;
	}

	static boolean isSimpleMouseOver(MouseEvent mouseevent)
	{
		return !mouseevent.isShiftDown() && !mouseevent.isAltDown() && !mouseevent.isAltGraphDown()
				&& !mouseevent.isControlDown() && !mouseevent.isMetaDown();
	}

	static boolean isSimpleClick(MouseEvent mouseevent)
	{
		return isSimpleClick(mouseevent, 1);
	}

	static boolean isSimpleClick(MouseEvent mouseevent, int i)
	{
		if (mouseevent.getButton() != i)
			return false;
		int j = 0;
		int k = 8384;
		switch (i) {
			case 1: // '\001'
				k |= 0x1b00;
				break;

			case 2: // '\002'
				k |= 0x1500;
				break;

			case 3: // '\003'
				k |= 0xe00;
				break;
		}
		return (mouseevent.getModifiersEx() & (j | k)) == j;
	}

	static boolean isControlMetaDown(MouseEvent mouseevent)
	{
		return V2CApp.isMacintosh() ? mouseevent.isMetaDown() : mouseevent.isControlDown();
	}

	static void setTableRowHeight(JTable jtable)
	{
		jtable.setRowHeight(calcTableRowHeight(jtable.getFont()));
	}

	static int calcTableRowHeight(Font font)
	{
		int i;
		if (font != null)
			i = font.getSize();
		else
			i = UIManager.getFont("Table.font").getSize();
		int j = nAdditionalRowHeight + 4;
		if (i >= 12)
			return i + j;
		else
			return (int) ((double) i * (1.0D + (double) j / 12D));
	}

	static JScrollPane createScrollPaneForTable(JTable jtable, int i)
	{
		return createScrollPaneForTable(jtable, i, -1);
	}

	static JScrollPane createScrollPaneForTable(JTable jtable, int i, int j)
	{
		setTableRowHeight(jtable);
		int k;
		if (j >= 0)
			k = setTableColumnWidths(jtable, j);
		else
			k = ensureTableColumnWidths(jtable);
		if (k <= 0)
			k = 400;
		jtable.setPreferredScrollableViewportSize(new Dimension(k, i));
		return new JScrollPane(jtable);
	}

	static int setTableColumnWidths(JTable jtable, int i)
	{
		int j = jtable.getRowCount();
		if (j == 0)
			return 0;
		TableColumnModel tablecolumnmodel = jtable.getColumnModel();
		int k = 0;
		for (int l = tablecolumnmodel.getColumnCount() - 1; l >= 0; l--) {
			int i1 = 0;
			for (int j1 = Math.min(j, 10) - 1; j1 >= 0; j1--) {
				TableCellRenderer tablecellrenderer = jtable.getCellRenderer(j1, l);
				Object obj = jtable.getValueAt(j1, l);
				Component component = tablecellrenderer.getTableCellRendererComponent(jtable, obj, false, false, j1, l);
				Dimension dimension = component.getPreferredSize();
				if (dimension.width > i1)
					i1 = dimension.width;
			}

			TableColumn tablecolumn = tablecolumnmodel.getColumn(l);
			TableCellRenderer tablecellrenderer1 = tablecolumn.getHeaderRenderer();
			if (tablecellrenderer1 == null)
				tablecellrenderer1 = jtable.getTableHeader().getDefaultRenderer();
			Object obj1 = tablecolumn.getHeaderValue();
			Component component1 = tablecellrenderer1.getTableCellRendererComponent(jtable, obj1, false, false, 0, l);
			Dimension dimension1 = component1.getPreferredSize();
			if (dimension1.width > i1)
				i1 = dimension1.width;
			i1 += i;
			tablecolumn.setPreferredWidth(i1);
			k += i1;
		}

		return k;
	}

	static int ensureTableColumnWidths(JTable jtable)
	{
		int i = 0;
		TableColumnModel tablecolumnmodel = jtable.getColumnModel();
		for (int j = tablecolumnmodel.getColumnCount() - 1; j >= 0; j--) {
			TableColumn tablecolumn = tablecolumnmodel.getColumn(j);
			TableCellRenderer tablecellrenderer = tablecolumn.getHeaderRenderer();
			if (tablecellrenderer == null)
				tablecellrenderer = jtable.getTableHeader().getDefaultRenderer();
			Object obj = tablecolumn.getHeaderValue();
			Component component = tablecellrenderer.getTableCellRendererComponent(jtable, obj, false, false, 0, j);
			int k = tablecolumn.getPreferredWidth();
			Dimension dimension = component.getPreferredSize();
			int l = dimension.width + 2;
			if (k < l) {
				tablecolumn.setPreferredWidth(l);
				k = l;
			}
			i += k;
		}

		return i;
	}

	static void checkEditing(JTable jtable)
	{
		if (jtable.isEditing()) {
			TableCellEditor tablecelleditor = jtable.getCellEditor();
			if (tablecelleditor != null)
				tablecelleditor.stopCellEditing();
		}
	}

	static boolean isSynthLaF()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return false;
		LookAndFeel lookandfeel = UIManager.getLookAndFeel();
		if (lookandfeel != null && lookandfeel != lafLastLaf) {
			lafLastLaf = lookandfeel;
			bSynth = V2CJ2SE5Util.isSynthLaF(lookandfeel);
		}
		return bSynth;
	}

	static void updateVistaTableHeaderFlag()
	{
		boolean flag = false;
		if (V2CApp.isWindowsVista() && V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
			LookAndFeel lookandfeel = UIManager.getLookAndFeel();
			if (lookandfeel != null) {
				String s = lookandfeel.getID();
				if (s != null && s.equals("Windows")) {
					Object obj = Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
					if ((obj instanceof Boolean) && ((Boolean) obj).booleanValue())
						flag = true;
				}
			}
		}
		bVistaTableHeader = flag;
	}

	static boolean needsVistaTableHeader()
	{
		return bVistaTableHeader;
	}

	static GridBagConstraints createGridBagConstraints()
	{
		GridBagConstraints gridbagconstraints = new GridBagConstraints();
		gridbagconstraints.anchor = 17;
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy = 0;
		return gridbagconstraints;
	}

	static BufferedImage getCheckBoxImage(boolean flag)
	{
		BufferedImage bufferedimage = flag ? biSelectedCheckBox : biUnselectedCheckBox;
		if (bufferedimage != null) {
			return bufferedimage;
		}
		else {
			JCheckBox jcheckbox = new JCheckBox() {

				public boolean isShowing()
				{
					return true;
				}

			};
			jcheckbox.setVisible(true);
			Dimension dimension = jcheckbox.getPreferredSize();
			GraphicsConfiguration graphicsconfiguration = V2CMain.v2cMain.getGraphicsConfiguration();
			BufferedImage bufferedimage1 = graphicsconfiguration.createCompatibleImage(dimension.width, dimension.height, 3);
			Graphics2D graphics2d = bufferedimage1.createGraphics();
			jcheckbox.paintAll(graphics2d);
			graphics2d.dispose();
			biUnselectedCheckBox = bufferedimage1;
			jcheckbox.setSelected(true);
			bufferedimage1 = graphicsconfiguration.createCompatibleImage(dimension.width, dimension.height, 3);
			graphics2d = bufferedimage1.createGraphics();
			graphics2d.setColor(Color.RED);
			graphics2d.fillRect(0, 0, bufferedimage1.getWidth(), bufferedimage1.getHeight());
			jcheckbox.paintAll(graphics2d);
			graphics2d.dispose();
			biSelectedCheckBox = bufferedimage1;
			return flag ? biSelectedCheckBox : biUnselectedCheckBox;
		}
	}

	static JButton addButton(String s, ActionListener actionlistener, JPanel jpanel, GridBagConstraints gridbagconstraints,
			boolean flag)
	{
		JButton jbutton = new JButton(s);
		jbutton.setFocusable(false);
		if (actionlistener != null)
			jbutton.addActionListener(actionlistener);
		jpanel.add(jbutton, gridbagconstraints);
		if (flag)
			gridbagconstraints.gridy++;
		else
			gridbagconstraints.gridx++;
		return jbutton;
	}

	static JCheckBox addCheckBox(String s, boolean flag, JPanel jpanel, GridBagConstraints gridbagconstraints, boolean flag1)
	{
		JCheckBox jcheckbox = new JCheckBox(s, flag);
		jcheckbox.setFocusable(false);
		jpanel.add(jcheckbox, gridbagconstraints);
		if (flag1)
			gridbagconstraints.gridy++;
		else
			gridbagconstraints.gridx++;
		return jcheckbox;
	}

	static JComboBox createComboBox(ComboBoxModel comboboxmodel)
	{
		if (V2CApp.isWinType())
			return new V2CWinComboBox(comboboxmodel);
		else
			return new JComboBox(comboboxmodel);
	}

	static JComboBox createComboBox(Object aobj[])
	{
		if (V2CApp.isWinType())
			return new V2CWinComboBox(aobj);
		else
			return new JComboBox(aobj);
	}

	static JComboBox createComboBox()
	{
		if (V2CApp.isWinType())
			return new V2CWinComboBox();
		else
			return new JComboBox();
	}

	static JSpinner createIntSpinner(int i, int j, int k)
	{
		JSpinner jspinner = new JSpinner(new SpinnerNumberModel(i, j, k, 1));
		Dimension dimension = jspinner.getPreferredSize();
		dimension.width *= 1.2D;
		jspinner.setPreferredSize(dimension);
		return jspinner;
	}

	static void stiffen(JComponent jcomponent)
	{
		if (V2CApp.isWinType()) {
			Dimension dimension = jcomponent.getPreferredSize();
			dimension.width *= 0.69999999999999996D;
			jcomponent.setMinimumSize(dimension);
		}
	}

	static boolean shouldUseCoveredComboBox()
	{
		if (!bShouldUseCoveredComboBoxChecked) {
			bShouldUseCoveredComboBoxChecked = true;
			boolean flag;
			if (V2CApp.isMacintosh())
				flag = false;
			else if (V2CApp.javaVersionEqualOrGreaterThan(1, 6) && V2CApp.isWinType()) {
				flag = true;
			}
			else {
				String s = UIManager.getLookAndFeel().getID();
				flag = s.equals("Motif") || s.equals("SkinLF");
			}
			bShouldUseCoveredComboBox = flag;
		}
		return bShouldUseCoveredComboBox;
	}

	static void listenToComboBoxButton(JComboBox jcombobox, MouseListener mouselistener)
	{
		if (shouldUseCoveredComboBox() || mouselistener == null)
			return;
		int i = jcombobox.getComponentCount();
		for (int j = 0; j < i; j++) {
			Component component = jcombobox.getComponent(j);
			if (component instanceof JButton)
				component.addMouseListener(mouselistener);
		}

	}

	static JScrollPane createBoundedScrollPane(JComponent jcomponent, double d, double d1)
	{
		Rectangle rectangle = V2CMain.v2cMain.getBounds();
		Rectangle rectangle1 = getScreenBoundsAt(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
		int i = (int) ((double) rectangle1.width * d);
		int j = (int) ((double) rectangle1.height * d1);
		JScrollPane jscrollpane = new JScrollPane(jcomponent);
		Insets insets = jscrollpane.getInsets();
		jscrollpane.getViewport().setSize(i - insets.left - insets.right, j - insets.top - insets.bottom);
		Dimension dimension = jcomponent.getPreferredSize();
		int k = dimension.width + insets.left + insets.right;
		int l = dimension.height + insets.top + insets.bottom;
		int i1 = Math.min(k, i);
		int j1 = Math.min(l, j);
		if (j1 < l && i1 == k)
			i1 += UIManager.getInt("ScrollBar.width");
		Dimension dimension1 = new Dimension(i1, j1);
		jscrollpane.setPreferredSize(dimension1);
		jscrollpane.setMaximumSize(dimension1);
		return jscrollpane;
	}

	static void addToShortPhrase(String s)
	{
		if (s == null) {
			Toolkit.getDefaultToolkit().beep();
			return;
		}
		int i = s.indexOf('\n');
		if (i == s.length() - 1)
			s = s.substring(0, s.length() - 1);
		if (!V2CAAListMenu.addAA(s))
			V2CShortPhraseMenu.addPhrase(s);
	}

	static Component getFocusOwner()
	{
		return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
	}

	static void registerESCToDialog(final JDialog jd)
	{
		JRootPane jrootpane = jd.getRootPane();
		ActionMap actionmap = jrootpane.getActionMap();
		if (actionmap.get("close") == null)
			actionmap.put("close", new AbstractAction() {
				public void actionPerformed(ActionEvent actionevent)
				{
					jd.dispose();
				}
			});
		InputMap inputmap = jrootpane.getInputMap(1);
		inputmap.put(KeyStroke.getKeyStroke(27, 0), "close");
	}

	static boolean showDialogWithFocusRequest(JComponent jcomponent, String s, JComponent jcomponent1)
	{
		String as[] = { "OK", "Cancel" };
		int i = showDialogWithFocusRequest(jcomponent, s, jcomponent1, as, 0);
		return i == 0;
	}

	static int showDialogWithFocusRequest(JComponent jcomponent, String s, JComponent jcomponent1, String as[], int i)
	{
		Object aobj[] = createJButtonForOptionPane(as);
		Object obj = aobj[i];
		FocusOptionPane focusoptionpane = new FocusOptionPane(jcomponent, -1, -1, null, aobj, obj, jcomponent1);
		JDialog jdialog = focusoptionpane.createDialog(V2CMain.v2cMain, s);
		jdialog.setVisible(true);
		jdialog.dispose();
		Object obj1 = focusoptionpane.getValue();
		for (int j = 0; j < aobj.length; j++)
			if (obj1 == aobj[j])
				return j;

		return -1;
	}

	static Object showComboBoxDialog(java.util.List list, Object obj, String s, String s1)
	{
		if (list == null || list.size() == 0)
			return null;
		else
			return showComboBoxDialog(list.toArray(), obj, s, s1);
	}

	static Object showComboBoxDialog(Object aobj[], Object obj, String s, String s1)
	{
		if (aobj == null || aobj.length == 0)
			return null;
		JPanel jpanel = new JPanel(new GridBagLayout());
		GridBagConstraints gridbagconstraints = createGridBagConstraints();
		gridbagconstraints.insets = new Insets(5, 5, 5, 5);
		jpanel.add(new JLabel(s), gridbagconstraints);
		gridbagconstraints.gridy++;
		JComboBox jcombobox = createComboBox(aobj);
		if (obj != null) {
			int i = 0;
			do {
				if (i >= aobj.length)
					break;
				if (aobj[i] == obj) {
					jcombobox.setSelectedIndex(i);
					break;
				}
				i++;
			} while (true);
		}
		gridbagconstraints.insets = new Insets(5, 10, 5, 10);
		gridbagconstraints.fill = 2;
		jpanel.add(jcombobox, gridbagconstraints);
		if (!showDialogWithFocusRequest(jpanel, s1, jcombobox))
			return null;
		else
			return jcombobox.getSelectedItem();
	}

	static void hideDialogWithSelection(Component component, int i)
	{
		Container container = SwingUtilities.getAncestorOfClass(javax.swing.JOptionPane.class, component);
		if (container != null) {
			JOptionPane joptionpane = (JOptionPane) container;
			Object aobj[] = joptionpane.getOptions();
			if (aobj != null && aobj.length > i)
				joptionpane.setValue(aobj[i]);
		}
		container = SwingUtilities.getAncestorOfClass(javax.swing.JDialog.class, component);
		if (container != null)
			((JDialog) container).setVisible(false);
	}

	static Point showDialogWithClose(JComponent jcomponent, JTextComponent jtextcomponent, String s)
	{
		return showDialogWithClose(((JFrame) (V2CMain.v2cMain)), jcomponent, jtextcomponent, s, (String) null, null);
	}

	static Point showDialogWithClose(JComponent jcomponent, JTextComponent jtextcomponent, String s, Point point)
	{
		return showDialogWithClose(((JFrame) (V2CMain.v2cMain)), jcomponent, jtextcomponent, s, (String) null, point);
	}

	static Point showDialogWithClose(JFrame jframe, JComponent jcomponent, JTextComponent jtextcomponent, String s)
	{
		return showDialogWithClose(jframe, jcomponent, jtextcomponent, s, (String) null, null);
	}

	static Point showDialogWithClose(JComponent jcomponent, JTextComponent jtextcomponent, String s, String s1)
	{
		return showDialogWithClose(((JFrame) (V2CMain.v2cMain)), jcomponent, jtextcomponent, s, s1, null);
	}

	static Point showDialogWithClose(JFrame jframe, JComponent jcomponent, JTextComponent jtextcomponent, String s, String s1)
	{
		return showDialogWithClose(jframe, jcomponent, jtextcomponent, s, s1, null);
	}

	static Point showDialogWithClose(JFrame jframe, JComponent jcomponent, JTextComponent jtextcomponent, String s, String s1,
			Point point)
	{
		String as[];
		if (s1 != null)
			as = (new String[] { s1 });
		else
			as = null;
		return showDialogWithClose(jframe, jcomponent, jtextcomponent, s, as, point);
	}

	static Point showDialogWithClose(JFrame jframe, JComponent jcomponent, JTextComponent jtextcomponent, String s, String as[],
			Point point)
	{
		boolean flag = false;
		Object obj = null;
		Object aobj[];
		if (as != null && as.length > 1) {
			aobj = createJButtonForOptionPane(as, true);
			int i = 0;
			do {
				if (i >= as.length)
					break;
				if (as[i].equals("OK")) {
					obj = aobj[i];
					break;
				}
				i++;
			} while (true);
		}
		else {
			String s1;
			if (as != null) {
				s1 = as[0];
				if (V2CMiscUtil.isEqual(s1, "MODELESS")) {
					flag = true;
					s1 = "閉じる";
				}
			}
			else {
				s1 = "閉じる";
			}
			aobj = new Object[1];
			aobj[0] = new CloseButton(s1);
		}
		FocusOptionPane focusoptionpane = new FocusOptionPane(jcomponent, -1, -1, null, aobj, obj, jtextcomponent);
		JDialog jdialog = focusoptionpane.createDialog(jframe, s);
		jdialog.setResizable(true);
		if (point != null) {
			checkWindowPosition(point);
			jdialog.setLocation(point);
		}
		jdialog.pack();
		addWheelScroller(jcomponent);
		if (flag)
			jdialog.setModal(false);
		jdialog.setVisible(true);
		if (!flag) {
			jdialog.dispose();
			if (as != null && as.length > 1) {
				Object obj1 = focusoptionpane.getValue();
				for (int j = 0; j < aobj.length; j++)
					if (obj1 != aobj[j])
						as[j] = null;

			}
		}
		return jdialog.getLocation();
	}

	private static void addWheelScroller(final Component cmp)
	{
		SwingUtilities.invokeLater(new Runnable() {

			public void run()
			{
				Window window = SwingUtilities.getWindowAncestor(cmp);
				if (window instanceof JDialog) {
					final JDialog jd = (JDialog) window;
					jd.addMouseWheelListener(new MouseWheelListener() {

						public void mouseWheelMoved(MouseWheelEvent mousewheelevent)
						{
							Point point = mousewheelevent.getPoint();
							for (Object obj = SwingUtilities.getDeepestComponentAt(mousewheelevent.getComponent(), point.x,
									point.y); obj != null; obj = ((Component) (obj)).getParent())
								if (obj instanceof JScrollPane)
									return;

							Point point1 = jd.getLocation();
							if (point1 == null)
								return;
							byte byte0 = ((byte) (mousewheelevent.getWheelRotation() <= 0 ? 15 : -15));
							if (mousewheelevent.isShiftDown())
								point1.x += byte0;
							else
								point1.y += byte0;
							jd.setLocation(point1);
						}
					});
				}
			}
		});
	}

	static boolean showOKCancelDialog(String s, String s1)
	{
		return showOKCancelDialog(s, s1, -1);
	}

	static boolean showOKCancelWarningDialog(String s)
	{
		return showOKCancelDialog(s, "警告", 2);
	}

	static boolean showOKCancelWarningDialog(String s, String s1)
	{
		return showOKCancelDialog(s, s1, 2);
	}

	static boolean showOKCancelQuestionDialog(String s, String s1)
	{
		return showOKCancelDialog(s, s1, 3);
	}

	static boolean showOKCancelDialog(String s, String s1, int i)
	{
		int j = JOptionPane.showConfirmDialog(V2CMain.v2cMain, wrapString(s), s1, 2, i);
		return j == 0;
	}

	static boolean showOKCancelDialog(Component component, String s)
	{
		Object aobj[];
		Object obj;
		if (V2CApp.isWinType() && V2CBaseFont.getUIFontScale() != 0) {
			aobj = createJButtonForOptionPane(new String[] { "OK", "Cancel" }, true);
			obj = aobj[0];
		}
		else {
			aobj = null;
			obj = null;
		}
		addWheelScroller(component);
		int i = JOptionPane.showOptionDialog(V2CMain.v2cMain, component, s, 2, -1, null, aobj, obj);
		return i == 0;
	}

	static String showInputDialog(String s)
	{
		return JOptionPane.showInputDialog(wrapString(s));
	}

	static String showInputDialog(String s, String s1)
	{
		return JOptionPane.showInputDialog(wrapString(s), s1);
	}

	static String showInputDialog(Component component, String s, String s1)
	{
		return JOptionPane.showInputDialog(component, wrapString(s), s1);
	}

	static String showInputDialog(String s, String s1, int i)
	{
		return JOptionPane.showInputDialog(V2CMain.v2cMain, wrapString(s), s1, i);
	}

	static String showInputDialog(String s, String s1, String s2, int i)
	{
		Object obj = JOptionPane.showInputDialog(V2CMain.v2cMain, wrapString(s), s1, i, null, null, s2);
		return (obj instanceof String) ? (String) obj : null;
	}

	static void showPlainMessage(String s, String s1)
	{
		showMessage(s, s1, -1);
	}

	static void showInformationMessage(String s)
	{
		showInformationMessage(s, "情報");
	}

	static void showInformationMessage(String s, String s1)
	{
		showMessage(s, s1, 1);
	}

	static void showWarningMessage(String s)
	{
		showWarningMessage(s, "警告");
	}

	static void showWarningMessage(String s, String s1)
	{
		showMessage(s, s1, 2);
	}

	static void showErrorMessage(String s)
	{
		showErrorMessage(s, "エラー");
	}

	static void showErrorMessage(String s, String s1)
	{
		showMessage(s, s1, 0);
	}

	static void showMessage(String s, String s1, int i)
	{
		if (V2CApp.isInShutdownThread())
			return;
		if (i == 0)
			V2CApp.setErrorMessage(s, s1);
		JOptionPane.showMessageDialog(V2CMain.v2cMain, wrapString(s), s1, i);
	}

	public static void showMessageLater(final String sm, final String st, final int nt)
	{
		if (V2CApp.isInShutdownThread()) {
			return;
		}
		else {
			SwingUtilities.invokeLater(new Runnable() {

				public void run()
				{
					V2CSwingUtil.showMessage(sm, st, nt);
				}
			});
			return;
		}
	}

	static void showMessageDialogLater(final Object om, final String st, final int nt)
	{
		if (V2CApp.isInShutdownThread()) {
			return;
		}
		else {
			SwingUtilities.invokeLater(new Runnable() {

				public void run()
				{
					JOptionPane.showMessageDialog(V2CMain.v2cMain, V2CSwingUtil.wrapString(om), st, nt);
				}
			});
			return;
		}
	}

	static void showScrollableMessage(String s, String s1, int i)
	{
		JTextArea jtextarea = new JTextArea(s);
		jtextarea.setEditable(false);
		JScrollPane jscrollpane = createBoundedScrollPane(jtextarea, 0.5D, 0.5D);
		JOptionPane.showMessageDialog(V2CMain.v2cMain, jscrollpane, s1, i);
	}

	static boolean needsWrapString()
	{
		if (!V2CApp.isWinType())
			return false;
		LookAndFeel lookandfeel = UIManager.getLookAndFeel();
		if (lookandfeel != null) {
			String s = lookandfeel.getName();
			if (s != null && s.equals("Substance"))
				return true;
		}
		return false;
	}

	static JComponent wrapStringIntoComponent(String s)
	{
		if (s.indexOf('\n') >= 0) {
			JTextArea jtextarea = new JTextArea(s);
			jtextarea.setEditable(false);
			jtextarea.setOpaque(false);
			jtextarea.setBorder(null);
			return jtextarea;
		}
		else {
			return new JLabel(s);
		}
	}

	static Object wrapString(Object obj)
	{
		if (needsWrapString() && (obj instanceof String))
			return wrapStringIntoComponent((String) obj);
		else
			return obj;
	}

	static Object[] createJButtonForOptionPane(String as[])
	{
		return createJButtonForOptionPane(as, false);
	}

	static Object[] createJButtonForOptionPane(String as[], boolean flag)
	{
		if (!flag && !needsWrapString())
			return as;
		CloseButton aclosebutton[] = new CloseButton[as.length];
		int i = 0;
		int j = 0;
		for (int k = 0; k < as.length; k++) {
			CloseButton closebutton = new CloseButton(as[k]);
			aclosebutton[k] = closebutton;
			Dimension dimension1 = closebutton.getPreferredSize();
			if (dimension1.width > i)
				i = dimension1.width;
			if (dimension1.height > j)
				j = dimension1.height;
		}

		Dimension dimension = new Dimension(i, j);
		for (int l = 0; l < aclosebutton.length; l++)
			aclosebutton[l].setPreferredSize(dimension);

		return aclosebutton;
	}

	static final boolean bAAText;
	private static LookAndFeel lafLastLaf;
	private static boolean bSynth;
	static boolean bVistaTableHeader;
	static Color cTransparent = new Color(0, 0, 0, 0);
	static Color cMacTextShadow = new Color(0x5fffffff, true);
	private static final HashMap hmIcons = new HashMap();
	static final boolean bListenToComboBoxButton = !V2CApp.javaVersionEqualOrGreaterThan(1, 5);
	static Timer tDragScrollTimer;
	static ActionListener vDragScrollTimerOwner;
	static final HashMap hmColorNames = new HashMap(200);
	static boolean bCreateFileChooserTried;
	static boolean bUseWinWOFileChooser;
	static Reference refGraphicsConfigs;
	static Rectangle rTotalBounds;
	static final String sUIManagerTableFontKey = "Table.font";
	private static final int nDefAdditionalRowHeight = 4;
	static int nAdditionalRowHeight;
	static int nJustifiedY;
	private static final String sWinXPSThemeActive = "win.xpstyle.themeActive";
	static BufferedImage biUnselectedCheckBox;
	static BufferedImage biSelectedCheckBox;
	private static boolean bShouldUseCoveredComboBox;
	private static boolean bShouldUseCoveredComboBoxChecked;

	static {
		if (V2CApp.javaVersionEqualTo(1, 5)) {
			String s = System.getProperty("swing.aatext");
			bAAText = s != null && s.equals("true");
		}
		else {
			bAAText = false;
		}
	}

}
