/*     */ package org.monazilla.v2c;
/*     */ 
/*     */ import java.awt.AWTPermission;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.File;
/*     */ import java.io.FilePermission;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.SocketPermission;
/*     */ import java.net.URL;
/*     */ import java.security.AccessControlContext;
/*     */ import java.security.AccessController;
/*     */ import java.security.AllPermission;
/*     */ import java.security.CodeSource;
/*     */ import java.security.Permission;
/*     */ import java.security.PermissionCollection;
/*     */ import java.security.Permissions;
/*     */ import java.security.Policy;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.PropertyPermission;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ 
/*     */ 
/*     */ 
/*     */ public class V2CScriptUtil
/*     */ {
/*     */   private static final String sJavaScript = "JavaScript";
/*     */   private static AccessControlContext vDefaultAccessControlContext;
/*     */   private static AccessControlContext vAllAccessControlContext;
/*     */   private static boolean bSecurityManagerInstalled;
/*     */   private static boolean bSecurityManagerInstallFailed;
/*     */   private static boolean bSOMJ;
/*     */   private static boolean bSOMJChecked;
/*     */   
/*     */   private static class AllPermissionPolicy
/*     */     extends Policy
/*     */   {
/*     */     final Permissions vPermissions;
/*     */     
/*     */     public PermissionCollection getPermissions(CodeSource codesource) {
/*  48 */       return this.vPermissions;
/*     */     }
/*     */ 
/*     */     
/*     */     public PermissionCollection getPermissions(ProtectionDomain protectiondomain) {
/*  53 */       return this.vPermissions;
/*     */     }
/*     */ 
/*     */     
/*     */     public void refresh() {}
/*     */     
/*     */     AllPermissionPolicy() {
/*  60 */       Permissions permissions = new Permissions();
/*  61 */       permissions.add(new AllPermission());
/*  62 */       this.vPermissions = permissions;
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   static void printMessage(String s) {
/*  78 */     V2CScriptConsole.appendText(String.valueOf(s) + 
/*  79 */         '\n');
/*  80 */     V2CMain.setMessage(V2CMiscUtil.replaceChar(s, '\n', ' '));
/*     */   }
/*     */   
/*     */   private static void checkSOMJ(Permissions permissions) {
/*  84 */     if (!bSOMJChecked) {
/*     */       
/*  86 */       try { Class.forName("sun.org.mozilla.javascript.DefiningClassLoader");
/*  87 */         bSOMJ = true; }
/*  88 */       catch (ClassNotFoundException classNotFoundException) {  }
/*  89 */       catch (Exception exception)
/*  90 */       { exception.printStackTrace(); }
/*     */       
/*  92 */       bSOMJChecked = true;
/*     */     } 
/*  94 */     if (bSOMJ) {
/*  95 */       permissions.add(new RuntimePermission("createClassLoader"));
/*  96 */       permissions.add(new RuntimePermission(
/*  97 */             "accessClassInPackage.sun.org.mozilla.*"));
/*     */     } 
/*     */   }
/*     */   
/*     */   private static synchronized boolean checkSecurityManager() {
/* 102 */     if (bSecurityManagerInstallFailed) {
/* 103 */       return false;
/*     */     }
/* 105 */     if (bSecurityManagerInstalled) {
/* 106 */       return true;
/*     */     }
/* 108 */     boolean flag = false;
/* 109 */     bSecurityManagerInstallFailed = true;
/*     */     try {
/* 111 */       Policy.setPolicy(new AllPermissionPolicy());
/* 112 */       Method method = System.class.getMethod(
/* 113 */           "setSecurityManager", 
/* 114 */           new Class[] { SecurityManager.class });
/* 115 */       method.invoke(null, new Object[] { new SecurityManager() });
/* 116 */       flag = true;
/* 117 */       bSecurityManagerInstallFailed = false;
/* 118 */     } catch (Exception exception) {
/* 119 */       exception.printStackTrace();
/*     */     } 
/* 121 */     bSecurityManagerInstalled = flag;
/* 122 */     if (!flag)
/*     */     {
/* 124 */       V2CSwingUtil.showErrorMessage("SecurityManagerのインストールに失敗しました。\nスクリプトを実行することはできません。");
/*     */     }
/* 126 */     return flag;
/*     */   }
/*     */   
/*     */   private static void addAccessEventQueuePermission(Permissions permissions) {
/* 130 */     if (V2CApp.javaVersionEqualOrGreaterThan(1, 7)) {
/* 131 */       permissions.add(new AWTPermission("accessEventQueue"));
/*     */     }
/* 133 */     if (V2CApp.javaVersionEqualOrGreaterThan(1, 8)) {
/* 134 */       permissions.add(new RuntimePermission(
/* 135 */             "accessClassInPackage.jdk.nashorn.internal.objects"));
				permissions.add(new RuntimePermission("nashorn.JavaReflection"));
				permissions.add(new RuntimePermission("setContextClassLoader"));
/*     */     }
			  if (V2CApp.javaVersionEqualOrGreaterThan(1, 9)){
				  permissions.add(new RuntimePermission("accessClassInPackage.com.sun.java.swing.plaf.windows"));
				  permissions.add(new RuntimePermission("accessClassInPackage.com.apple.laf"));
			  }
/*     */   }
/*     */   
/*     */   private static void addDefaultPropertyPermissions(Permissions permissions) {
/* 140 */     String[] as = { "java.version", "java.vendor", "java.vendor.url", 
/* 141 */         "java.class.version", "os.name", "os.version", "os.arch", 
/* 142 */         "file.encoding", "file.separator", "path.separator", 
/* 143 */         "line.separator", "java.specification.version", 
/* 144 */         "java.specification.vendor", "java.specification.name", 
/* 145 */         "java.vm.specification.version", 
/* 146 */         "java.vm.specification.vendor", "java.vm.specification.name", 
/* 147 */         "java.vm.version", "java.vm.vendor", "java.vm.name" };
/* 148 */     for (int i = 0; i < as.length; i++) {
/* 149 */       permissions.add(new PropertyPermission(as[i], "read"));
/*     */     }
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   private static void addPermission(Permissions permissions, Permission permission, SecurityManager securitymanager) {
/* 156 */     if (securitymanager != null) {
/*     */       try {
/* 158 */         securitymanager.checkPermission(permission);
/* 159 */       } catch (SecurityException securityexception) {
/*     */         return;
/*     */       } 
/*     */     }
/* 163 */     permissions.add(permission);
/*     */   }
/*     */   
/*     */   static AccessControlContext createAccessControlContext(String s) {
/* 167 */     return createAccessControlContext(s, null);
/*     */   }
/*     */ 
/*     */   
/*     */   static AccessControlContext createAccessControlContext(String s, SecurityManager securitymanager) {
/*     */     int i;
/* 173 */     if (s == null || (i = s.length()) == 0) {
/* 174 */       AccessControlContext accesscontrolcontext = vDefaultAccessControlContext;
/* 175 */       if (accesscontrolcontext != null) {
/* 176 */         return accesscontrolcontext;
/*     */       }
/* 178 */       Permissions permissions1 = new Permissions();
/* 179 */       checkSOMJ(permissions1);
/* 180 */       addAccessEventQueuePermission(permissions1);
/* 181 */       addDefaultPropertyPermissions(permissions1);
/* 182 */       AccessControlContext accesscontrolcontext1 = new AccessControlContext(
/* 183 */           new ProtectionDomain[] { new ProtectionDomain(null, 
/* 184 */               permissions1) });
/* 185 */       vDefaultAccessControlContext = accesscontrolcontext1;
/* 186 */       return accesscontrolcontext1;
/*     */     } 
/*     */     
/* 189 */     if (i == 1 && s.charAt(0) == 'A') {
/* 190 */       AccessControlContext accesscontrolcontext2 = vAllAccessControlContext;
/* 191 */       if (accesscontrolcontext2 != null && securitymanager == null) {
/* 192 */         return accesscontrolcontext2;
/*     */       }
/* 194 */       Permissions permissions2 = new Permissions();
/* 195 */       checkSOMJ(permissions2);
/* 196 */       addAccessEventQueuePermission(permissions2);
/* 197 */       addPermission(permissions2, new PropertyPermission("*", "read"), 
/* 198 */           securitymanager);
/* 199 */       addPermission(permissions2, new FilePermission("<<ALL FILES>>", 
/* 200 */             "read,write,execute,delete"), securitymanager);
/* 201 */       addPermission(permissions2, new V2CRuntimePermission(
/* 202 */             "changeFavorite"), securitymanager);
/* 203 */       addPermission(permissions2, new V2CRuntimePermission(
/* 204 */             "changeProperty"), securitymanager);
/* 205 */       addPermission(permissions2, new RuntimePermission(
/* 206 */             "accessClassInPackage.com.sun.javafx.geom.BaseBounds"), 
/* 207 */           securitymanager);
/* 208 */       addPermission(permissions2, new RuntimePermission("exitVM"), 
/* 209 */           securitymanager);
/* 210 */       addPermission(permissions2, new SocketPermission("*", "connect"), 
/* 211 */           securitymanager);
/* 212 */       addPermission(permissions2, new AWTPermission("accessClipboard"), 
/* 213 */           securitymanager);
/* 214 */       addPermission(permissions2, new AWTPermission(
/* 215 */             "showWindowWithoutWarningBanner"), securitymanager);
/* 216 */       addPermission(permissions2, new AWTPermission(
/* 217 */             "setWindowAlwaysOnTop"), securitymanager);
				String sv = System.getProperty("java.version");
				if(V2CApp.javaVersionEqualOrGreaterThan(1, 8)){
					addPermission(permissions2, new RuntimePermission("accessDeclaredMembers"), securitymanager);
					addPermission(permissions2, new RuntimePermission("getClassLoader"), securitymanager);
				}
/* 218 */       accesscontrolcontext2 = new AccessControlContext(
/* 219 */           new ProtectionDomain[] { new ProtectionDomain(null, 
/* 220 */               permissions2) });
/* 221 */       if (securitymanager == null) {
/* 222 */         vAllAccessControlContext = accesscontrolcontext2;
/*     */       }
/* 224 */       return accesscontrolcontext2;
/*     */     } 
/* 226 */     Permissions permissions = new Permissions();
/* 227 */     checkSOMJ(permissions);
/* 228 */     addAccessEventQueuePermission(permissions);
/* 229 */     boolean flag = false;
/* 230 */     boolean flag1 = false;
/* 231 */     for (int j = 0; j < i; j++) {
/* 232 */       char c = s.charAt(j);
/* 233 */       if (c == 'A') {
/* 234 */         return null;
/*     */       }
/* 236 */       if (c > 'A' && c <= 'Z') {
/* 237 */         if (c == 'F') {
/* 238 */           String s1; StringBuilder sb = new StringBuilder();
/*     */           int j1;
/* 240 */           for (j1 = j + 1; j1 < i; j1++) {
/* 241 */             char c4 = s.charAt(j1);
/* 242 */             if (c4 >= 'A' && c4 <= 'Z') {
/*     */               break;
/*     */             }
/* 245 */             if (c4 == 'r') {
/* 246 */               sb.append("read,");
/* 247 */             } else if (c4 == 'w') {
/* 248 */               sb.append("write,");
/* 249 */             } else if (c4 == 'x') {
/* 250 */               sb.append("execute,");
/* 251 */             } else if (c4 == 'd') {
/* 252 */               sb.append("delete,");
/*     */             } else {
/* 254 */               return null;
/*     */             } 
/*     */           } 
/*     */           
/* 258 */           j = j1 - 1;
/* 259 */           j1 = sb.length();
/*     */           
/* 261 */           if (j1 > 0) {
/* 262 */             s1 = sb.substring(0, j1 - 1);
/*     */           } else {
/* 264 */             s1 = "read,write,execute,delete";
/*     */           } 
/* 266 */           addPermission(permissions, new FilePermission(
/* 267 */                 "<<ALL FILES>>", s1), securitymanager);
/* 268 */         } else if (c == 'P') {
/* 269 */           addPermission(permissions, new PropertyPermission("*", 
/* 270 */                 "read"), securitymanager);
/* 271 */           flag = true;
/* 272 */         } else if (c == 'R') {
/* 273 */           int k = j + 1;
/*     */           
/* 275 */           while (k < i) {
/*     */ 
/*     */             
/* 278 */             char c1 = s.charAt(k);
/* 279 */             if (c1 >= 'A' && c1 <= 'Z') {
/*     */               break;
/*     */             }
/* 282 */             if (c1 == 'x') {
/* 283 */               addPermission(permissions, new RuntimePermission(
/* 284 */                     "exitVM"), securitymanager);
					  }else
					  if (c1 == 'm'){
						  String sv = System.getProperty("java.version");
						  if(V2CApp.javaVersionEqualOrGreaterThan(1, 8)){
							  addPermission(permissions, new RuntimePermission("accessDeclaredMembers"), securitymanager);
						  }
					  }
					  else
					  if (c1 == 'c'){
						  String sv = System.getProperty("java.version");
						  if(V2CApp.javaVersionEqualOrGreaterThan(1, 8)){
							  addPermission(permissions, new RuntimePermission("getClassLoader"), securitymanager);
						  }
/*     */             } else {
/* 286 */               return null;
/*     */             } 
/* 288 */             k++;
/*     */           } 
/* 290 */           if (j == k - 1) {
/* 291 */             addPermission(permissions, new RuntimePermission(
/* 292 */                   "exitVM"), securitymanager);
					  String sv = System.getProperty("java.version");
					  if(V2CApp.javaVersionEqualOrGreaterThan(1, 8)){
						  addPermission(permissions, new RuntimePermission("accessDeclaredMembers"), securitymanager);
						  addPermission(permissions, new RuntimePermission("getClassLoader"), securitymanager);
					  }
/*     */           } else {
/* 294 */             j = k - 1;
/*     */           } 
/* 296 */         } else if (c == 'S') {
/* 297 */           addPermission(permissions, new SocketPermission("*", 
/* 298 */                 "connect"), securitymanager);
/* 299 */         } else if (c == 'T') {
/*     */           int l;
/* 301 */           for (l = j + 1; l < i; l++) {
/* 302 */             char c2 = s.charAt(l);
/* 303 */             if (c2 >= 'A' && c2 <= 'Z') {
/*     */               break;
/*     */             }
/* 306 */             if (c2 == 'c') {
/* 307 */               addPermission(permissions, new AWTPermission(
/* 308 */                     "accessClipboard"), securitymanager);
						if (V2CApp.javaVersionEqualOrGreaterThan(1, 9)){
							addPermission(permissions, new AllPermission("<all permissions>", "<all actions>"), securitymanager);
						}
/* 309 */             } else if (c2 == 't') {
/* 310 */               addPermission(permissions, new AWTPermission(
/* 311 */                     "setWindowAlwaysOnTop"), securitymanager);
					  } else if (c2 == 'r') {
						addPermission(permissions, new AWTPermission("createRobot"), securitymanager);
					  } else if (c2 == 'd') {
						  addPermission(permissions, new AWTPermission("readDisplayPixels"), securitymanager);
/* 312 */             } else if (c2 == 'w') {
/* 313 */               addPermission(permissions, new AWTPermission(
/* 314 */                     "showWindowWithoutWarningBanner"), 
/* 315 */                   securitymanager);
/*     */             } else {
/* 317 */               return null;
/*     */             } 
/*     */           } 
/*     */           
/* 321 */           if (j == l - 1) {
/* 322 */             addPermission(permissions, new AWTPermission(
/* 323 */                   "accessClipboard"), securitymanager);
/* 324 */             addPermission(permissions, new AWTPermission(
/* 325 */                   "showWindowWithoutWarningBanner"), 
/* 326 */                 securitymanager);
/* 327 */             addPermission(permissions, new AWTPermission(
/* 328 */                   "setWindowAlwaysOnTop"), securitymanager);
/*     */           } else {
/* 330 */             j = l - 1;
/*     */           } 
/* 332 */         } else if (c == 'V') {
/*     */           int i1;
/* 334 */           for (i1 = j + 1; i1 < i; i1++) {
/* 335 */             char c3 = s.charAt(i1);
/* 336 */             if (c3 >= 'A' && c3 <= 'Z') {
/*     */               break;
/*     */             }
/* 339 */             if (c3 == 'f') {
/* 340 */               addPermission(permissions, 
/* 341 */                   new V2CRuntimePermission("changeFavorite"), 
/* 342 */                   securitymanager);
/* 343 */             } else if (c3 == 'p') {
/* 344 */               addPermission(permissions, 
/* 345 */                   new V2CRuntimePermission("changeProperty"), 
/* 346 */                   securitymanager);
/*     */             } else {
/* 348 */               return null;
/*     */             } 
/*     */           } 
/*     */           
/* 352 */           if (j == i1 - 1) {
/* 353 */             addPermission(permissions, new V2CRuntimePermission(
/* 354 */                   "changeFavorite"), securitymanager);
/* 355 */             addPermission(permissions, new V2CRuntimePermission(
/* 356 */                   "changeProperty"), securitymanager);
/*     */           } else {
/* 358 */             j = i1 - 1;
/*     */           } 
/*     */         } else {
/* 361 */           return null;
/*     */         } 
/*     */       } else {
/* 364 */         return null;
/*     */       } 
/*     */     } 
/*     */     
/* 368 */     if (!flag) {
/* 369 */       addDefaultPropertyPermissions(permissions);
/*     */     }
/* 371 */     return new AccessControlContext(
/* 372 */         new ProtectionDomain[] { new ProtectionDomain(null, permissions) });
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private static V2CEvalScript createEvalScript(V2CExtCommand v2cextcommand, String s, ActionEvent actionevent, boolean flag, boolean flag1, boolean flag2) {
/*     */     File file;
/*     */     String s5;
/* 384 */     if (!checkSecurityManager()) {
/* 385 */       return null;
/*     */     }
/* 387 */     String s1 = v2cextcommand.getCommand();
			  String sCmd = "\n\n" + v2cextcommand.getCommand();
/* 388 */     Matcher matcher = 
/* 389 */       Pattern.compile(
/* 390 */         "\\$(?:SCRIPT|\\{SCRIPT(?:\\[([-/\\w]+)\\])?(?::(\\p{Alpha}*))?\\})\\s+")
/* 391 */       .matcher(s1);
/* 392 */     if (!matcher.lookingAt()) {
/* 393 */       V2CSwingUtil.showErrorMessage("スクリプトの指定が正しくありません。" + sCmd);
/* 394 */       return null;
/*     */     } 
/* 396 */     String s2 = null;
/* 397 */     if (matcher.groupCount() >= 1) {
/* 398 */       s2 = matcher.group(1);
/*     */     }
/* 400 */     if (s2 == null) {
/* 401 */       s2 = "JavaScript";
/*     */     }
/* 403 */     s1 = s1.substring(matcher.end());
/* 404 */     String s3 = s2;
/* 405 */     Matcher matcher1 = Pattern.compile("(<?[-\\w.\\\\/]+>?)\\s*").matcher(
/* 406 */         s1);
/* 407 */     if (!matcher1.lookingAt()) {
/* 408 */       V2CSwingUtil.showErrorMessage("スクリプトファイル名を取得できませんでした。" + sCmd);
/* 409 */       return null;
/*     */     } 
/* 411 */     String s4 = matcher1.group(1);
/* 412 */     int i = s4.length();
/*     */ 
/*     */     
/* 415 */     if (i > 2 && s4.charAt(0) == '<' && s4.charAt(i - 1) == '>') {
/* 416 */       file = null;
/* 417 */       s5 = V2CLocalFileHandler.restoreTextResource(
/* 418 */           "org/monazilla/v2c/script/" + 
/* 419 */           s4.substring(1, i - 1));
/*     */     } else {
/* 421 */       file = V2CLocalFileHandler.getScriptFile(s4);
/* 422 */       if (file == null) {
/* 423 */         V2CSwingUtil.showErrorMessage("スクリプトファイル名を取得できませんでした。" + sCmd);
/* 424 */         return null;
/*     */       } 
/* 426 */       if (!file.isFile()) {
/* 427 */         V2CSwingUtil.showErrorMessage("スクリプトファイルが存在しません。" + sCmd);
/* 428 */         return null;
/*     */       } 
/* 430 */       s5 = V2CLocalFileHandler.restoreFromFile(file, "UTF-8");
/*     */     } 
/* 432 */     if (s5 == null || s5.length() <= 1) {
/* 433 */       V2CSwingUtil.showErrorMessage("スクリプトファイルの内容が空です。" + sCmd);
/* 434 */       return null;
/*     */     } 
/* 436 */     if (s5.charAt(0) == '﻿') {
/* 437 */       if (s5.length() == 1) {
/* 438 */         V2CSwingUtil.showErrorMessage("スクリプトファイルの内容が空です。" + sCmd);
/* 439 */         return null;
/*     */       } 
/* 441 */       s5 = s5.substring(1);
/*     */     } 
/* 443 */     if (s != null) {
/* 444 */       s5 = String.valueOf(s5) + s;
/*     */     }
/* 446 */     V2CScriptClassLoader v2cscriptclassloader = 
/* 447 */       V2CScriptClassLoader.getInstance();
/* 448 */     if (v2cscriptclassloader == null) {
/* 449 */       V2CSwingUtil.showErrorMessage("クラスローダを作成できませんでした。" + sCmd);
/* 450 */       return null;
/*     */     } 
/* 452 */     AccessControlContext accesscontrolcontext = createAccessControlContext(matcher
/* 453 */         .group(2));
/* 454 */     if (accesscontrolcontext == null) {
/* 455 */       V2CSwingUtil.showErrorMessage(
/* 456 */           "パーミッションの指定が正しくありません。\n\n" + matcher.group(2) + sCmd);
/*     */       
/* 458 */       return null;
/*     */     } 
/* 460 */     V2CScriptApp v2cscriptapp = new V2CScriptApp(file, 
/* 461 */         s1.substring(matcher1.end()), v2cextcommand, actionevent, 
/* 462 */         flag, flag1, flag2);
/* 463 */     return new V2CEvalScript(s3, s5, v2cscriptapp, 
/* 464 */         v2cscriptclassloader, accesscontrolcontext);
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   static void execScript(V2CExtCommand v2cextcommand, ActionEvent actionevent, boolean flag, boolean flag1, boolean flag2) {
/* 470 */     V2CEvalScript v2cevalscript = createEvalScript(v2cextcommand, null, 
/* 471 */         actionevent, flag, flag1, flag2);
/* 472 */     if (v2cevalscript == null) {
/*     */       return;
/*     */     }
/* 475 */     Thread thread = new Thread(v2cevalscript);
/* 476 */     thread.start();
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   static Object evalScriptFunction(V2CExtCommand v2cextcommand, ActionEvent actionevent, String s, Object[] aobj) {
/* 483 */     V2CEvalScript v2cevalscript = createEvalScript(v2cextcommand, null, 
/* 484 */         actionevent, false, false, false);
/* 485 */     if (v2cevalscript == null) {
/* 486 */       return null;
/*     */     }
/* 488 */     v2cevalscript.setInvokeFunction(s, aobj);
/* 489 */     v2cevalscript.run();
/* 490 */     return v2cevalscript.getResult();
/*     */   }
/*     */ 
/*     */   
/*     */   static void redirectURL(V2CEvalScript v2cevalscript, URL url) {
/* 495 */     v2cevalscript.redirectURL(url);
/* 496 */     Thread thread = new Thread(v2cevalscript);
/* 497 */     thread.start();
/*     */   }
/*     */ 
/*     */   
/*     */   static void formSubmitted(V2CEvalScript v2cevalscript, URL url, String s, String s1) {
/* 502 */     v2cevalscript.formSubmitted(url, s, s1);
/* 503 */     Thread thread = new Thread(v2cevalscript);
/* 504 */     thread.start();
/*     */   }
/*     */   
/*     */   static boolean startResCheckScript() {
/* 508 */     if (V2CResCheckScript.bPrintDebugInfo) {
/* 509 */       System.out.println("V2CScriptUtil.startResCheckScript");
/*     */     }
/* 511 */     if (!V2CApp.javaVersionEqualOrGreaterThan(1, 6)) {
/* 512 */       return false;
/*     */     }
/* 514 */     if (!checkSecurityManager()) {
/* 515 */       return false;
/*     */     }
/* 517 */     if (V2CResCheckScript.bPrintDebugInfo) {
/* 518 */       System.out.println("SecurityManager OK");
/*     */     }
/* 520 */     File file = V2CLocalFileHandler.getSystemScriptFile("rescheck.js");
/* 521 */     if (!file.isFile()) {
/* 522 */       return false;
/*     */     }
/* 524 */     if (V2CResCheckScript.bPrintDebugInfo) {
/* 525 */       System.out.println("ResCheckScriptFile OK");
/*     */     }
/* 527 */     String s = V2CLocalFileHandler.restoreFromFile(file, "UTF-8");
/* 528 */     if (s == null || s.length() <= 1) {
/* 529 */       return false;
/*     */     }
/* 531 */     if (V2CResCheckScript.bPrintDebugInfo) {
/* 532 */       System.out.println("Read OK");
/*     */     }
/* 534 */     if (s.charAt(0) == '﻿') {
/* 535 */       if (s.length() == 1) {
/* 536 */         return false;
/*     */       }
/* 538 */       s = s.substring(1);
/*     */     } 
/* 540 */     if (V2CResCheckScript.bPrintDebugInfo) {
/* 541 */       System.out.println("Read2 OK");
/*     */     }
/* 543 */     V2CScriptClassLoader v2cscriptclassloader = 
/* 544 */       V2CScriptClassLoader.getInstance();
/* 545 */     if (v2cscriptclassloader == null) {
/* 546 */       return false;
/*     */     }
/* 548 */     if (V2CResCheckScript.bPrintDebugInfo) {
/* 549 */       System.out.println("ClassLoader OK");
/*     */     }
/* 551 */     AccessControlContext accesscontrolcontext = createAccessControlContext(
/* 552 */         V2CSystemScript.getPermissionString("rescheck.js"));
/* 553 */     if (accesscontrolcontext == null) {
/* 554 */       return false;
/*     */     }
/* 556 */     if (V2CResCheckScript.bPrintDebugInfo) {
/* 557 */       System.out.println("AccessControlContext OK");
/*     */     }
/* 559 */     return V2CResCheckScript.startScript(s, v2cscriptclassloader, 
/* 560 */         accesscontrolcontext);
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   static V2CSystemScript createSystemScript(String scriptFileName) {
/* 567 */     if (!checkSecurityManager()) {
/* 568 */       return null;
/*     */     }
/* 570 */     File file = V2CLocalFileHandler.getSystemScriptFile(scriptFileName);
/* 571 */     if (!file.isFile()) {
/* 572 */       return null;
/*     */     }
/* 574 */     String s1 = V2CLocalFileHandler.restoreFromFile(file, "UTF-8");
/* 575 */     if (s1 == null || s1.length() <= 1) {
/* 576 */       return null;
/*     */     }
/* 578 */     if (s1.charAt(0) == '﻿') {
/* 579 */       if (s1.length() == 1) {
/* 580 */         return null;
/*     */       }
/* 582 */       s1 = s1.substring(1);
/*     */     } 
/* 584 */     V2CScriptClassLoader v2cscriptclassloader = 
/* 585 */       V2CScriptClassLoader.getInstance();
/* 586 */     if (v2cscriptclassloader == null) {
/* 587 */       return null;
/*     */     }
/* 589 */     AccessControlContext accesscontrolcontext = createAccessControlContext(
/* 590 */         V2CSystemScript.getPermissionString(scriptFileName));
/* 591 */     if (accesscontrolcontext == null) {
/* 592 */       return null;
/*     */     }
/* 594 */     if (scriptFileName.equals("subject.js")) {
/* 595 */       return V2CSubjectScript.createSubjectScript(s1, 
/* 596 */           v2cscriptclassloader, accesscontrolcontext);
/*     */     }
/* 598 */     if (scriptFileName.equals("imgcache.js")) {
/* 599 */       return V2CImageCacheScript.createImageCacheScript(s1, 
/* 600 */           v2cscriptclassloader, accesscontrolcontext);
/*     */     }
/* 602 */     if (scriptFileName.equals("menu.js")) {
/* 603 */       return V2CMenuScript.createMenuScript(s1, v2cscriptclassloader, 
/* 604 */           accesscontrolcontext);
/*     */     }
/* 606 */     if (scriptFileName.equals("getdat.js")) {
/* 607 */       return V2CGetDatScript.createGetDatScript(s1, v2cscriptclassloader, 
/* 608 */           accesscontrolcontext);
/*     */     }
/* 610 */     if (scriptFileName.equals("threadld.js")) {
/* 611 */       return V2CThreadUpdateScript.createThreadUpdateScript(s1, 
/* 612 */           v2cscriptclassloader, accesscontrolcontext);
/*     */     }
/* 614 */     if (scriptFileName.equals("post.js")) {
/* 615 */       return V2CPostScript.createPostScript(s1, v2cscriptclassloader, 
/* 616 */           accesscontrolcontext);
/*     */     }
/* 618 */     if (scriptFileName.equals("proxy.js")) {
/* 619 */       return V2CProxyScript.createProxyScript(s1, v2cscriptclassloader, 
/* 620 */           accesscontrolcontext);
/*     */     }
/* 622 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   static V2CSystemScript createUserScript(String scriptFileName) {
/* 631 */     if (!checkSecurityManager()) {
/* 632 */       return null;
/*     */     }
/* 634 */     File file = V2CLocalFileHandler.getScriptFile(scriptFileName);
/* 635 */     if (!file.isFile()) {
/* 636 */       return null;
/*     */     }
/* 638 */     String s1 = V2CLocalFileHandler.restoreFromFile(file, "UTF-8");
/* 639 */     if (s1 == null || s1.length() <= 1) {
/* 640 */       return null;
/*     */     }
/* 642 */     if (s1.charAt(0) == '﻿') {
/* 643 */       if (s1.length() == 1) {
/* 644 */         return null;
/*     */       }
/* 646 */       s1 = s1.substring(1);
/*     */     } 
/* 648 */     V2CScriptClassLoader v2cscriptclassloader = 
/* 649 */       V2CScriptClassLoader.getInstance();
/* 650 */     if (v2cscriptclassloader == null) {
/* 651 */       return null;
/*     */     }
/* 653 */     AccessControlContext accesscontrolcontext = createAccessControlContext(
/* 654 */         V2CSystemScript.getPermissionString(scriptFileName));
/* 655 */     if (accesscontrolcontext == null) {
/* 656 */       return null;
/*     */     }
/* 658 */     if (scriptFileName.equals("analysis_slip.js")) {
/* 659 */       return V2CAnalysisScript.createAnalysisScript(s1, 
/* 660 */           v2cscriptclassloader, accesscontrolcontext);
/*     */     }
/* 662 */     if (scriptFileName.equals("web_thread_search.js")) {
/* 663 */       return V2CWebThreadSearchScript.createWebThreadSearchScript(s1, 
/* 664 */           v2cscriptclassloader, accesscontrolcontext);
/*     */     }
/* 666 */     if (scriptFileName.equals(V2CReadCgiScript.sScriptFileName)) {
/* 667 */       return V2CReadCgiScript.createReadCgiScript(s1, 
/* 668 */           v2cscriptclassloader, accesscontrolcontext);
/*     */     }
/* 670 */     if (scriptFileName.equals("be_popup.js")) {
/* 671 */       return V2CBePopupScript.createBePopupScript(s1, 
/* 672 */           v2cscriptclassloader, accesscontrolcontext);
/*     */     }
/* 674 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   static V2CSystemScript createBuiltinScript(String scriptFileName) {
/* 681 */     InputStream in = null;
/* 682 */     InputStreamReader reader = null;
/*     */     try {
/* 684 */       if (!checkSecurityManager()) {
/* 685 */         return null;
/*     */       }
/*     */       
/* 688 */       in = 
/* 689 */         ClassLoader.getSystemResourceAsStream("org/monazilla/v2c/script/" + 
/* 690 */           scriptFileName);
/* 691 */       if (in == null) {
/* 692 */         return null;
/*     */       }
/*     */       
/* 695 */       BufferedInputStream bIn = new BufferedInputStream(in);
/* 696 */       reader = new InputStreamReader(bIn, "UTF-8");
/* 697 */       StringBuilder sb = new StringBuilder();
/*     */       int i;
/* 699 */       while ((i = reader.read()) != -1) {
/* 700 */         sb.append((char)i);
/*     */       }
/* 702 */       reader.close();
/*     */       
/* 704 */       String str = sb.toString();
/*     */       
/* 706 */       V2CScriptClassLoader v2cscriptclassloader = 
/* 707 */         V2CScriptClassLoader.getInstance();
/* 708 */       if (v2cscriptclassloader == null) {
/* 709 */         return null;
/*     */       }
/* 711 */       AccessControlContext accesscontrolcontext = createAccessControlContext(
/* 712 */           V2CSystemScript.getPermissionString(scriptFileName));
/* 713 */       if (accesscontrolcontext == null) {
/* 714 */         return null;
/*     */       }
/* 716 */       scriptFileName.equals("readcgi.js");
/*     */ 
/*     */     
/*     */     }
/* 720 */     catch (Exception e) {
/* 721 */       e.printStackTrace();
/* 722 */       V2CLocalFileHandler.closeInputStream(in);
/* 723 */       V2CLocalFileHandler.closeReader(reader);
/*     */     } 
/*     */     
/* 726 */     return null;
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   static V2CScriptSP createScriptSP() {
/* 732 */     return new V2CScriptSP(new String[] { "subject.js", "rescheck.js", 
/* 733 */           "imgcache.js", "menu.js", "getdat.js", "threadld.js", 
/* 734 */           "post.js", "proxy.js" });
/*     */   }
/*     */ 
/*     */   
/*     */   static boolean getThreadsForTLBS(V2CExtCommand v2cextcommand, ArrayList<V2CThreadItem> arraylist, V2CScriptTLBSContext v2cscripttlbscontext) {
/* 739 */     String s = 
/* 740 */       V2CLocalFileHandler.restoreTextResource("org/monazilla/v2c/script/tlbsft.js");
/* 741 */     if (s == null) {
/* 742 */       return false;
/*     */     }
/* 744 */     V2CEvalScript v2cevalscript = createEvalScript(v2cextcommand, s, null, 
/* 745 */         false, false, false);
/* 746 */     if (v2cevalscript == null) {
/* 747 */       return false;
/*     */     }
/* 749 */     v2cevalscript.run();
/* 750 */     PrivilegedExceptionAction privilegedexceptionaction = v2cevalscript.vPrivilegedExceptionAction;
/* 751 */     if (privilegedexceptionaction == null) {
/* 752 */       return false;
/*     */     }
/* 754 */     V2CJSE6Util.setInvokeFunction(privilegedexceptionaction, 
/* 755 */         "_v2c_getThreads", new Object[] { v2cscripttlbscontext });
/* 756 */     Object obj = execPEA(privilegedexceptionaction, 
/* 757 */         v2cevalscript.vScriptApp, v2cevalscript.vScriptClassLoader, 
/* 758 */         v2cevalscript.vAccessControlContext);
/* 759 */     if (v2cscripttlbscontext.getSkip()) {
/* 760 */       return true;
/*     */     }
/* 762 */     if (!(obj instanceof List)) {
/* 763 */       return false;
/*     */     }
/* 765 */     List list = (List)obj;
/* 766 */     int i = list.size();
/* 767 */     for (int j = 0; j < i; j++) {
/* 768 */       Object obj1 = list.get(j);
/* 769 */       if (!(obj1 instanceof V2CScriptThread)) {
/* 770 */         return false;
/*     */       }
/* 772 */       arraylist.add(((V2CScriptThread)obj1).getThreadItem());
/*     */     } 
/*     */     
/* 775 */     return true;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   static Object execPEA(PrivilegedExceptionAction<?> privilegedexceptionaction, V2CScriptApp v2cscriptapp, V2CScriptClassLoader v2cscriptclassloader, AccessControlContext accesscontrolcontext) {
/* 782 */     String s = null;
/* 783 */     Thread thread = Thread.currentThread();
/* 784 */     ClassLoader classloader = thread.getContextClassLoader();
/* 785 */     thread.setContextClassLoader(v2cscriptclassloader);
/* 786 */     Object obj = null;
/*     */     try {
/* 788 */       obj = AccessController.doPrivileged(privilegedexceptionaction, 
/* 789 */           accesscontrolcontext);
/* 790 */     } catch (PrivilegedActionException privilegedactionexception) {
/* 791 */       s = "スクリプト実行エラー： " + 
/* 792 */         privilegedactionexception.getException().getMessage();
/*     */     } finally {
/* 794 */       thread.setContextClassLoader(classloader);
/* 795 */       V2CMain.endTempMessage(v2cscriptapp);
/*     */     } 
/* 797 */     if (s != null)
/* 798 */       setErrorMessage(s); 
/* 799 */     return obj;
/*     */   }
/*     */   
/*     */   static void setErrorMessage(String s) {
/* 803 */     if (s == null) {
/*     */       return;
/*     */     }
/* 806 */     V2CScriptConsole.appendText(String.valueOf(s) + 
/* 807 */         '\n');
/* 808 */     V2CMain.setErrorMessage(s);
/* 809 */     System.out.println(s);
/*     */   }
/*     */ }


/* Location:              E:\__dat\V2C\V2Cplus\launcher\V2C_R20171103.jar!\org\monazilla\v2c\V2CScriptUtil.class
 * Java compiler version: 7 (51.0)
 * JD-Core Version:       1.1.3
 */