/*      */ package org.monazilla.v2c;
/*      */ 
/*      */ import java.io.BufferedOutputStream;
/*      */ import java.io.BufferedReader;
/*      */ import java.io.File;
/*      */ import java.io.FilterInputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.InputStreamReader;
/*      */ import java.io.OutputStream;
/*      */ import java.io.PrintStream;
/*      */ import java.io.PrintWriter;
/*      */ import java.io.StringReader;
/*      */ import java.io.UnsupportedEncodingException;
/*      */ import java.net.Authenticator;
/*      */ import java.net.HttpURLConnection;
/*      */ import java.net.Inet6Address;
/*      */ import java.net.InetAddress;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.PasswordAuthentication;
/*      */ import java.net.SocketTimeoutException;
/*      */ import java.net.URL;
/*      */ import java.net.URLConnection;
/*      */ import java.net.URLDecoder;
/*      */ import java.net.UnknownHostException;
/*      */ import java.security.Key;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Collection;
/*      */ import java.util.Date;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Random;
/*      */ import java.util.Set;
/*      */ import java.util.regex.Matcher;
/*      */ import java.util.regex.Pattern;
/*      */ import java.util.zip.GZIPInputStream;
/*      */ import javax.crypto.Mac;
/*      */ import javax.crypto.spec.SecretKeySpec;
/*      */ import javax.net.ssl.HostnameVerifier;
/*      */ import javax.net.ssl.HttpsURLConnection;
/*      */ import javax.net.ssl.SSLHandshakeException;
/*      */ import javax.net.ssl.SSLSession;
/*      */ import javax.swing.JOptionPane;
/*      */ import javax.swing.SwingUtilities;
/*      */ import javax.swing.text.BadLocationException;
/*      */ import javax.swing.text.html.HTMLDocument;
/*      */ import javax.swing.text.html.HTMLEditorKit;
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ public class V2CPlusHttpUtil
/*      */ {
/*      */   static final String COMMENT = "readcgi機能を使うためにAPIパッチからクラス毎持ってきたが、使っているのはDAT取得関連のメソッドのみ。画像のダウンロードやスレ一覧の取得はV2CHttpUtilのメソッドを使う。";
/*   58 */   private static String sRequestTokenURL = "https://api.twitter.com/oauth/request_token";
/*   59 */   private static String sAuthorizeURL = "https://api.twitter.com/oauth/authorize";
/*   60 */   private static String sAccessTokenURL = "https://api.twitter.com/oauth/access_token";
/*      */   
/*      */   static final String sPreferIPv6AddressesKey = "PreferIPv6Addresses";
/*   63 */   private static final HashMap hmHosts = new HashMap();
/*   64 */   private static final HashMap hmKeySpecs = new HashMap();
/*      */   static final String sOtherUAName = "Mozilla/4.0 (compatible)";
/*   66 */   public static int nBufLen = 2048;
/*      */   
/*   68 */   private static int nInitialContentLength = 131072;
/*   69 */   private static int nMaxContentLength = 16777216;
/*      */   private static int iConnectTimeout;
/*      */   private static int iReadTimeout;
/*      */   public static boolean bPolipo;
/*      */   public static boolean bPolipoWarned;
/*   74 */   private static final byte[] blToken = {
/*   75 */     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 
/*   76 */     0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
/*   77 */     1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
/*   78 */     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 
/*   79 */     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
/*   80 */     1, 1, 1, 1, 1 };
/*      */   
/*      */ 
/*      */   private static Mac vMac;
/*      */   
/*      */   static long nOAuthTimeOffset;
/*      */   
/*      */   static Random vRandom;
/*      */   
/*   89 */   private static final Pattern get2chPattern = Pattern.compile("https?://([^\\.]*)(\\.[25]ch\\.net|\\.bbspink\\.com)/([^/]*)/dat/([0-9]*)\\.dat");
/*      */   
/*      */   private static String sid;
/*      */   
/*   93 */   public static boolean useSC = false;
/*   94 */   public static boolean useAPI = false;
/*   95 */   public static boolean useHTML = false;
/*      */   
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*  104 */   public static String apiHMKey = null;
/*  105 */   public static String apiAppKey = null;
/*  106 */   public static String apiUAName = null;
/*  107 */   public static String apiUAAuth = null;
/*  108 */   public static String apiX2CHUA = null;
/*  109 */   public static String uaPost = null;
/*  110 */   public static String uaRead1 = null;
/*  111 */   public static String uaRead2 = null;
/*  112 */   public static boolean bPropertyUseSc = false;
/*      */   
/*  114 */   public static boolean uaReadChanged = false;
/*      */   
/*      */ 
/*      */ 
/*      */ 
/*  119 */   private static boolean useV2crEngine = false;
/*      */   
/*      */ 
/*      */   public static final String DEFAULT_POST_UA = "Mozilla/5.0 (iPad; CPU OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1";
/*      */   
/*      */ 
/*      */   public static final String DEFAULT_READ_UA = "Mozilla/5.0 (iPad; CPU OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1";
/*      */   
/*      */ 
/*      */   public static final String DEFAULT_2CH_SUBJECT_READ_UA = "Monazilla/1.0 (twinkle/6.7; iOS11.0.3; iPhone9,2)";
/*      */   
/*      */ 
/*      */   public static final String DEFAULT_5CH_SUBJECT_READ_UA = "Monazilla/1.0 (twinkle/7.0; iOS11.0.3; iPhone9,2)";
/*      */   
/*      */ 
/*      */   static String prev_userId;
/*      */   
/*      */ 
/*      */   static String prev_passwd;
/*      */   
/*      */ 
/*      */ 
/*      */   static
/*      */   {
/*  143 */     V2CProperty v2cproperty = V2CMain.getUserProperty();
/*  144 */     HttpURLConnection.setFollowRedirects(false);
/*  145 */     iConnectTimeout = v2cproperty.getInt("HttpUtil.ConnectTimeout", 60) * 1000;
/*  146 */     iReadTimeout = v2cproperty.getInt("HttpUtil.ReadTimeout", 120) * 1000;
/*  147 */     Authenticator.setDefault(new DefAuth());
/*      */     
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*  154 */     loadPlusSetting();
/*      */   }
/*      */   
/*      */   public static void loadPlusSetting() {
/*  158 */     apiAppKey = V2CPlus2chProperty.getAPPKey();
/*  159 */     apiHMKey = V2CPlus2chProperty.getHMKey();
/*  160 */     apiUAName = V2CPlus2chProperty.getUAName();
/*  161 */     uaPost = V2CPlus2chProperty.getUAPost();
/*      */     
/*  163 */     if (V2CAppendUtil.isEmpty(uaPost)) {
/*  164 */       uaPost = "Mozilla/5.0 (iPad; CPU OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1";
/*      */     }
/*      */     
/*  167 */     if (V2CPlus2chProperty.isPostOsInfo()) {
/*  168 */       setUAPostOSInfo();
/*      */     }
/*      */     
/*      */ 
/*      */ 
/*  173 */     apiX2CHUA = V2CPlus2chProperty.getX2chUA();
/*  174 */     apiUAAuth = V2CPlus2chProperty.getUAAuth();
/*      */     
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*  198 */     uaRead1 = V2CPlus2chProperty.getUARead1();
/*  199 */     uaRead2 = V2CPlus2chProperty.getUARead2();
/*  200 */     uaReadChanged = false;
/*      */     
/*  202 */     if (V2CAppendUtil.isEmpty(uaRead1)) {
/*  203 */       uaRead1 = "Mozilla/5.0 (iPad; CPU OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1";
/*      */     } else {
/*  205 */       uaReadChanged = true;
/*      */     }
/*      */     
/*  208 */     if (V2CAppendUtil.isEmpty(uaRead2)) {
/*  209 */       uaRead2 = is5chBoard() ? "Monazilla/1.0 (twinkle/7.0; iOS11.0.3; iPhone9,2)" : "Monazilla/1.0 (twinkle/6.7; iOS11.0.3; iPhone9,2)";
/*      */     } else {
/*  211 */       uaReadChanged = true;
/*      */     }
/*      */     
/*  214 */     bPropertyUseSc = V2CPlus2chProperty.useSC();
/*      */   }
/*      */   
/*      */   private static boolean is5chBoard() {
/*      */     try {
/*  219 */       V2C2chBBS bbs = V2C2chBBS.get2chBBS();
/*      */       
/*  221 */       if (bbs == null) {
/*  222 */         return false;
/*      */       }
/*  224 */       String currentUrl = V2CMiscUtil.join(bbs.getBBSMenuURLStrings(), ",");
/*      */       
/*  226 */       return (currentUrl != null) && (currentUrl.contains("menu.5ch.net/"));
/*      */     } catch (Exception e) {
/*  228 */       e.printStackTrace(); }
/*  229 */     return false;
/*      */   }
/*      */   
/*      */   public static boolean isEnableUaPostOsInfoUA(String ua)
/*      */   {
/*  234 */     if ((ua == null) || (ua.length() == 0) || (ua.contains("Windows/"))) {
/*  235 */       return false;
/*      */     }
/*      */     
/*  238 */     if ((ua.contains("JaneStyle/3.83")) || 
/*  239 */       (ua.contains("JaneStyle/3.82")) || 
/*  240 */       (ua.contains("JaneStyle/3.81")) || 
/*  241 */       (ua.contains("V2C/3.0.3")) || 
/*  242 */       (ua.contains("V2C/3.0.2")) || 
/*  243 */       (ua.contains("V2C/3.0.1")) || 
/*  244 */       (ua.contains("V2C/2.")) || 
/*  245 */       (ua.contains("Live2ch/1.46")) || 
/*  246 */       (ua.contains("Live2ch/1.45")) || 
/*  247 */       (ua.contains("Live2ch/1.44")) || 
/*  248 */       (ua.contains("Live2ch/1.43")) || 
/*  249 */       (ua.contains("Live2ch/1.42")) || 
/*  250 */       (ua.contains("Live2ch/1.41")) || 
/*  251 */       (ua.contains("Live2ch/1.40"))) {
/*  252 */       return false;
/*      */     }
/*      */     
/*  255 */     if ((!ua.contains("JaneStyle")) && 
/*  256 */       (!ua.contains("Jane Style")) && 
/*  257 */       (!ua.contains("Live2ch")) && 
/*  258 */       (!ua.contains("V2C")) && 
/*  259 */       (!ua.contains("Hotzonu"))) {
/*  260 */       return false;
/*      */     }
/*      */     
/*  263 */     return true;
/*      */   }
/*      */   
/*      */   public static void setUAPostOSInfo() {
/*  267 */     if ((!"Mozilla/5.0 (iPad; CPU OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1".equals(uaPost)) && (!isEnableUaPostOsInfoUA(uaPost))) {
/*      */       return;
/*      */     }
/*      */     
/*      */     String temp;
/*  273 */     if ("Mozilla/5.0 (iPad; CPU OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1".equals(uaPost)) {
/*  274 */       temp = "Monazilla/1.00 JaneStyle/3.84";
/*      */     } else {
/*  276 */       temp = uaPost;
/*      */     }
/*      */     
/*  279 */     Thread thread = new Thread(new Runnable()
/*      */     {
/*      */       public void run() {
/*  282 */         String osInfo = V2CAppendUtil.getOSInfo();
/*      */         
/*  284 */         if (V2CAppendUtil.isEmpty(osInfo)) {
/*  285 */           return;
/*      */         }
/*      */         
/*  288 */         V2CPlusHttpUtil.uaPost = V2CPlusHttpUtil.uaPost + " " + osInfo;
/*      */       }
/*  290 */     });
/*  291 */     SwingUtilities.invokeLater(thread);
/*      */   }
/*      */   
/*      */   private static void setReadcgiMode(boolean isReadCgiMode) {
/*  295 */     useAPI = !isReadCgiMode;
/*  296 */     useHTML = isReadCgiMode;
/*  297 */     useSC = (bPropertyUseSc) && (isReadCgiMode);
/*      */   }
/*      */   
/*      */   public static String getHMKey() {
/*  301 */     if (apiHMKey != null) {
/*  302 */       return apiHMKey;
/*      */     }
/*  304 */     apiHMKey = "INVALID_HM_KEY";
/*  305 */     return apiHMKey;
/*      */   }
/*      */   
/*      */   public static String getUAName(boolean isAuth, boolean isPost, boolean is2ch) {
/*  309 */     return getUAName(isAuth, isPost, is2ch, false);
/*      */   }
/*      */   
/*      */   public static String getUAName(boolean isAuth, boolean isPost, boolean is2ch, boolean isMachiBBS)
/*      */   {
/*  314 */     if (!is2ch) {
/*  315 */       if (isPost) {
/*  316 */         return uaPost;
/*      */       }
/*  318 */       if ((isMachiBBS) && (uaRead1.contains("JaneStyle"))) {
/*  319 */         return "Mozilla/4.0 (compatible)";
/*      */       }
/*  321 */       return uaRead1;
/*      */     }
/*      */     
/*      */ 
/*  325 */     if (useAPI) {
/*  326 */       if (isPost)
/*  327 */         return uaPost;
/*  328 */       if (isAuth) {
/*  329 */         return apiUAAuth;
/*      */       }
/*  331 */       return apiUAName; }
/*  332 */     if (useHTML) {
/*  333 */       if (isPost) {
/*  334 */         return uaPost;
/*      */       }
/*  336 */       return "Mozilla/5.0 (iPad; CPU OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1";
/*      */     }
/*      */     
/*  339 */     if (isAuth) {
/*  340 */       return "DOLIB/1.00";
/*      */     }
/*  342 */     return "Mozilla/5.0 (iPad; CPU OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1";
/*      */   }
/*      */   
/*      */   public static String getX2chUA()
/*      */   {
/*  347 */     if (useAPI) {
/*  348 */       return apiX2CHUA;
/*      */     }
/*  350 */     return "V2C/" + V2CReleaseInfo.getVersionOrName();
/*      */   }
/*      */   
/*      */   public static String getAppKey()
/*      */   {
/*  355 */     if (apiAppKey != null) {
/*  356 */       return apiAppKey;
/*      */     }
/*  358 */     apiAppKey = "INVALID_APP_KEY";
/*  359 */     return apiAppKey;
/*      */   }
/*      */   
/*      */   static class DefAuth extends V2CJ2SE5Util.Auth2
/*      */   {
/*      */     protected PasswordAuthentication getPasswordAuthentication() {
/*  365 */       InetAddress inetaddress = getRequestingSite();
/*  366 */       if ((!this.bJ15) || (!isServerType())) {
/*  367 */         return V2CProxySetting.getProxyPasswordAuth(inetaddress, 
/*  368 */           getRequestingPort());
/*      */       }
/*  370 */       URL url = getRequestingURL();
/*  371 */       PasswordAuthentication passwordauthentication = 
/*  372 */         V2CBoardItem.getPWAuth(url);
/*  373 */       return passwordauthentication;
/*      */     }
/*      */     
/*      */     DefAuth()
/*      */     {
/*  378 */       super(V2CApp.javaVersionEqualOrGreaterThan(1, 5));
/*      */     }
/*      */   }
/*      */   
/*      */   public static class GZIPFilterInputStream extends FilterInputStream {
/*      */     V2CThreadRes vThreadRes;
/*      */     
/*  385 */     public boolean markSupported() { return false; }
/*      */     
/*      */     public int read() throws IOException
/*      */     {
/*  389 */       int i = super.read();
/*  390 */       this.vThreadRes.addProgressValue(1);
/*  391 */       return i;
/*      */     }
/*      */     
/*      */     public int read(byte[] abyte0) throws IOException {
/*  395 */       int i = super.read(abyte0);
/*  396 */       if (i > 0)
/*  397 */         this.vThreadRes.addProgressValue(i);
/*  398 */       return i;
/*      */     }
/*      */     
/*      */     public int read(byte[] abyte0, int i, int j) throws IOException {
/*  402 */       int k = super.read(abyte0, i, j);
/*  403 */       if (k > 0)
/*  404 */         this.vThreadRes.addProgressValue(k);
/*  405 */       return k;
/*      */     }
/*      */     
/*      */     public long skip(long l) throws IOException {
/*  409 */       return super.skip(l);
/*      */     }
/*      */     
/*      */ 
/*      */ 
/*      */     public GZIPFilterInputStream(InputStream inputstream, V2CThreadRes v2cthreadres)
/*      */     {
/*  416 */       super(inputstream);
/*  417 */       this.vThreadRes = v2cthreadres;
/*      */     } }
/*      */   
/*      */   static class GetHTTPFileBG implements Runnable { final String sURL;
/*      */     final String sCharsets;
/*      */     final String sContentType;
/*      */     
/*  424 */     boolean start() { Thread thread = new Thread(this);
/*  425 */       boolean flag = this.vProgressPanel.showPanel(thread);
/*  426 */       if (!flag)
/*  427 */         thread.interrupt();
/*  428 */       return flag;
/*      */     }
/*      */     
/*      */     final long ltLastModified;
/*      */     final int nRepeat;
/*      */     final V2CProgressPanel vProgressPanel;
/*      */     V2CHttpUtil.CAndC ccResult;
/*      */     /* Error */
/*      */     public void run()
/*      */     {
	try {
		ccResult = V2CHttpUtil.getHTTPFile(sURL, null, sCharsets,
				sContentType, ltLastModified, nRepeat);
	} finally {
		vProgressPanel.hidePanel();
	}
/*      */       // Byte code:
/*      */       //   0: aload_0
/*      */       //   1: aload_0
/*      */       //   2: getfield 79	org/monazilla/v2c/V2CPlusHttpUtil$GetHTTPFileBG:sURL	Ljava/lang/String;
/*      */       //   5: aconst_null
/*      */       //   6: aload_0
/*      */       //   7: getfield 77	org/monazilla/v2c/V2CPlusHttpUtil$GetHTTPFileBG:sCharsets	Ljava/lang/String;
/*      */       //   10: aload_0
/*      */       //   11: getfield 78	org/monazilla/v2c/V2CPlusHttpUtil$GetHTTPFileBG:sContentType	Ljava/lang/String;
/*      */       //   14: aload_0
/*      */       //   15: getfield 76	org/monazilla/v2c/V2CPlusHttpUtil$GetHTTPFileBG:ltLastModified	J
/*      */       //   18: aload_0
/*      */       //   19: getfield 75	org/monazilla/v2c/V2CPlusHttpUtil$GetHTTPFileBG:nRepeat	I
/*      */       //   22: invokestatic 85	org/monazilla/v2c/V2CPlusHttpUtil:getHTTPFile	(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JI)Lorg/monazilla/v2c/V2CHttpUtil$CAndC;
/*      */       //   25: putfield 80	org/monazilla/v2c/V2CPlusHttpUtil$GetHTTPFileBG:ccResult	Lorg/monazilla/v2c/V2CHttpUtil$CAndC;
/*      */       //   28: goto +13 -> 41
/*      */       //   31: astore_1
/*      */       //   32: aload_0
/*      */       //   33: getfield 81	org/monazilla/v2c/V2CPlusHttpUtil$GetHTTPFileBG:vProgressPanel	Lorg/monazilla/v2c/V2CProgressPanel;
/*      */       //   36: invokevirtual 87	org/monazilla/v2c/V2CProgressPanel:hidePanel	()V
/*      */       //   39: aload_1
/*      */       //   40: athrow
/*      */       //   41: aload_0
/*      */       //   42: getfield 81	org/monazilla/v2c/V2CPlusHttpUtil$GetHTTPFileBG:vProgressPanel	Lorg/monazilla/v2c/V2CProgressPanel;
/*      */       //   45: invokevirtual 87	org/monazilla/v2c/V2CProgressPanel:hidePanel	()V
/*      */       //   48: return
/*      */       // Line number table:
/*      */       //   Java source line #433	-> byte code offset #0
/*      */       //   Java source line #434	-> byte code offset #10
/*      */       //   Java source line #433	-> byte code offset #22
/*      */       //   Java source line #435	-> byte code offset #28
/*      */       //   Java source line #436	-> byte code offset #32
/*      */       //   Java source line #437	-> byte code offset #39
/*      */       //   Java source line #436	-> byte code offset #41
/*      */       //   Java source line #438	-> byte code offset #48
/*      */       // Local variable table:
/*      */       //   start	length	slot	name	signature
/*      */       //   0	49	0	this	GetHTTPFileBG
/*      */       //   31	9	1	localObject	Object
/*      */       // Exception table:
/*      */       //   from	to	target	type
/*      */       //   0	31	31	finally
/*      */     }
/*      */     
/*      */     GetHTTPFileBG(String s, String s1, String s2, String s3, long l)
/*      */     {
/*  449 */       this(s, null, s1, s2, s3, l, 0);
/*      */     }
/*      */     
/*      */     GetHTTPFileBG(String s, String s1, String s2, String s3, String s4, long l)
/*      */     {
/*  454 */       this(s, s1, s2, s3, s4, l, 0);
/*      */     }
/*      */     
/*      */     GetHTTPFileBG(String s, String s1, String s2, String s3, String s4, long l, int i)
/*      */     {
/*  459 */       this.sURL = s2;
/*  460 */       this.sCharsets = s3;
/*  461 */       this.sContentType = s4;
/*  462 */       this.ltLastModified = l;
/*  463 */       this.nRepeat = i;
/*  464 */       this.vProgressPanel = new V2CProgressPanel(s, s1);
/*      */     }
/*      */   }
/*      */   
/*      */   private static class MyHostnameVerifier implements HostnameVerifier
/*      */   {
/*      */     public boolean verify(String s, SSLSession sslsession) {
/*  471 */       String s1 = sslsession.getPeerHost();
/*  472 */       if (s.equals(s1))
/*  473 */         return true;
/*  474 */       InetAddress inetaddress = null;
/*  475 */       InetAddress inetaddress1 = null;
/*      */       try {
/*  477 */         inetaddress = InetAddress.getByName(s);
/*  478 */         inetaddress1 = InetAddress.getByName(s1);
/*      */       } catch (UnknownHostException unknownhostexception) {
/*  480 */         System.out.println(unknownhostexception.getMessage());
/*  481 */         return false;
/*      */       }
/*  483 */       return inetaddress.equals(inetaddress1);
/*      */     }
/*      */   }
/*      */   
/*      */   static class PostFormBG implements Runnable { final String sURL;
/*      */     final String sRef;
/*      */     final String sData;
/*      */     final String sCharsets;
/*      */     final V2CProgressPanel vProgressPanel;
/*      */     V2CHttpUtil.CAndC ccResult;
/*      */     
/*  494 */     boolean start() { Thread thread = new Thread(this);
/*  495 */       thread.start();
/*  496 */       boolean flag = this.vProgressPanel.showPanel();
/*  497 */       if (!flag)
/*  498 */         thread.interrupt();
/*  499 */       return flag;
/*      */     }
/*      */     
/*      */     /* Error */
/*      */     public void run()
/*      */     {
	try {
		ccResult = V2CHttpUtil.postForm(sURL, sRef, sData, sCharsets);
	} finally {
		vProgressPanel.hidePanel();
	}
/*      */       // Byte code:
/*      */       //   0: aload_0
/*      */       //   1: aload_0
/*      */       //   2: getfield 70	org/monazilla/v2c/V2CPlusHttpUtil$PostFormBG:sURL	Ljava/lang/String;
/*      */       //   5: aload_0
/*      */       //   6: getfield 69	org/monazilla/v2c/V2CPlusHttpUtil$PostFormBG:sRef	Ljava/lang/String;
/*      */       //   9: aload_0
/*      */       //   10: getfield 68	org/monazilla/v2c/V2CPlusHttpUtil$PostFormBG:sData	Ljava/lang/String;
/*      */       //   13: aload_0
/*      */       //   14: getfield 67	org/monazilla/v2c/V2CPlusHttpUtil$PostFormBG:sCharsets	Ljava/lang/String;
/*      */       //   17: invokestatic 77	org/monazilla/v2c/V2CPlusHttpUtil:postForm	(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lorg/monazilla/v2c/V2CHttpUtil$CAndC;
/*      */       //   20: putfield 71	org/monazilla/v2c/V2CPlusHttpUtil$PostFormBG:ccResult	Lorg/monazilla/v2c/V2CHttpUtil$CAndC;
/*      */       //   23: goto +13 -> 36
/*      */       //   26: astore_1
/*      */       //   27: aload_0
/*      */       //   28: getfield 72	org/monazilla/v2c/V2CPlusHttpUtil$PostFormBG:vProgressPanel	Lorg/monazilla/v2c/V2CProgressPanel;
/*      */       //   31: invokevirtual 78	org/monazilla/v2c/V2CProgressPanel:hidePanel	()V
/*      */       //   34: aload_1
/*      */       //   35: athrow
/*      */       //   36: aload_0
/*      */       //   37: getfield 72	org/monazilla/v2c/V2CPlusHttpUtil$PostFormBG:vProgressPanel	Lorg/monazilla/v2c/V2CProgressPanel;
/*      */       //   40: invokevirtual 78	org/monazilla/v2c/V2CProgressPanel:hidePanel	()V
/*      */       //   43: return
/*      */       // Line number table:
/*      */       //   Java source line #504	-> byte code offset #0
/*      */       //   Java source line #505	-> byte code offset #13
/*      */       //   Java source line #504	-> byte code offset #17
/*      */       //   Java source line #506	-> byte code offset #23
/*      */       //   Java source line #507	-> byte code offset #27
/*      */       //   Java source line #508	-> byte code offset #34
/*      */       //   Java source line #507	-> byte code offset #36
/*      */       //   Java source line #509	-> byte code offset #43
/*      */       // Local variable table:
/*      */       //   start	length	slot	name	signature
/*      */       //   0	44	0	this	PostFormBG
/*      */       //   26	9	1	localObject	Object
/*      */       // Exception table:
/*      */       //   from	to	target	type
/*      */       //   0	26	26	finally
/*      */     }
/*      */     
/*      */     PostFormBG(String s, String s1, String s2, String s3, String s4, String s5)
/*      */     {
/*  520 */       this.sURL = s2;
/*  521 */       this.sRef = s3;
/*  522 */       this.sData = s4;
/*  523 */       this.sCharsets = s5;
/*  524 */       this.vProgressPanel = new V2CProgressPanel(s, s1);
/*      */     }
/*      */   }
/*      */   
/*      */   public static class RemoteHost {
/*      */     final String sName;
/*      */     
/*  531 */     public void start() { ArrayList arraylist = this.alWaitingThread;
/*  532 */       Thread thread = Thread.currentThread();
/*      */       try {
/*  534 */         synchronized (arraylist) {
/*  535 */           arraylist.add(thread);
/*  536 */           if (thread != arraylist.get(0)) {
/*      */             do {
/*  538 */               arraylist.wait();
/*  537 */               if (arraylist.size() <= 0) break;
/*  538 */             } while (arraylist.get(0) != thread);
/*      */           }
/*      */         }
/*      */       } catch (InterruptedException interruptedexception) {
/*  542 */         synchronized (arraylist) {
/*  543 */           arraylist.remove(thread);
/*      */         }
/*  545 */         thread.interrupt();
/*      */       }
/*      */     }
/*      */     
/*      */     void finished() {
/*  550 */       ArrayList arraylist = this.alWaitingThread;
/*  551 */       synchronized (arraylist) {
/*  552 */         if (arraylist.size() > 0) {
/*  553 */           arraylist.remove(Thread.currentThread());
/*  554 */           for (int i = arraylist.size() - 1; i >= 0; i--) {
/*  555 */             if (!((Thread)arraylist.get(i)).isAlive())
/*  556 */               arraylist.remove(i);
/*      */           }
/*      */         }
/*  559 */         arraylist.notifyAll();
/*      */       }
/*      */     }
/*      */     
/*      */     void interrupted(Thread thread) {
/*  564 */       ArrayList arraylist = this.alWaitingThread;
/*  565 */       synchronized (arraylist) {
/*  566 */         if ((arraylist.size() > 0) && (thread == arraylist.get(0))) {
/*  567 */           arraylist.remove(0);
/*  568 */           arraylist.notifyAll();
/*      */         }
/*      */       }
/*      */     }
/*      */     
/*      */ 
/*      */     synchronized void check() {}
/*      */     
/*      */ 
/*  577 */     final ArrayList alWaitingThread = new ArrayList();
/*      */     
/*      */     RemoteHost(String s) {
/*  580 */       this.sName = s;
/*      */     }
/*      */   }
/*      */   
/*      */   static boolean getPreferIPv6Addresses() {
/*  585 */     return V2CApp.getUserProperty().getBoolean("PreferIPv6Addresses");
/*      */   }
/*      */   
/*      */   static URL checkPreferIPv6(URL url) {
/*  589 */     if (!getPreferIPv6Addresses())
/*  590 */       return url;
/*  591 */     String s = System.getProperty("java.net.preferIPv6Addresses");
/*  592 */     if ((s != null) && (s.equals("true")))
/*  593 */       return url;
/*  594 */     InetAddress[] ainetaddress = null;
/*      */     try {
/*  596 */       ainetaddress = InetAddress.getAllByName(url.getHost());
/*      */     }
/*      */     catch (UnknownHostException localUnknownHostException) {}
/*  599 */     if ((ainetaddress == null) || (ainetaddress.length == 0))
/*  600 */       return url;
/*  601 */     Inet6Address inet6address = null;
/*  602 */     int i = 0;
/*      */     
/*  604 */     while (i < ainetaddress.length)
/*      */     {
/*  606 */       InetAddress inetaddress = ainetaddress[i];
/*  607 */       if ((inetaddress instanceof Inet6Address)) {
/*  608 */         inet6address = (Inet6Address)inetaddress;
/*  609 */         break;
/*      */       }
/*  611 */       i++;
/*      */     }
/*  613 */     if (inet6address == null)
/*  614 */       return url;
/*      */     try {
/*  616 */       url = new URL(url.getProtocol(), inet6address.getHostAddress(), 
/*  617 */         url.getFile());
/*      */     } catch (MalformedURLException malformedurlexception) {
/*  619 */       V2CMiscUtil.printMalformedURLException(malformedurlexception);
/*      */     }
/*  621 */     return url;
/*      */   }
/*      */   
/*      */   static boolean isPolipoUsed() {
/*  625 */     boolean flag = bPolipo;
/*  626 */     if (bPolipo) {
/*  627 */       bPolipo = false;
/*  628 */       bPolipoWarned = true;
/*      */     }
/*  630 */     return flag;
/*      */   }
/*      */   
/*      */   private static URL str2URL(String s) {
/*      */     try {
/*  635 */       return new URL(s);
/*      */     } catch (MalformedURLException malformedurlexception) {
/*  637 */       V2CMiscUtil.printMalformedURLException(malformedurlexception);
/*      */     }
/*  639 */     return null;
/*      */   }
/*      */   
/*      */   private static boolean isRedirect(int i) {
/*  643 */     return (i == 301) || (i == 302) || (i == 303) || (i == 307);
/*      */   }
/*      */   
/*      */   static HashMap putOtherUAName(HashMap hashmap) {
/*  647 */     if (hashmap == null)
/*  648 */       hashmap = new HashMap();
/*  649 */     hashmap.put("User-Agent", "Mozilla/4.0 (compatible)");
/*  650 */     return hashmap;
/*      */   }
/*      */   
/*      */   private static void setUA(HttpURLConnection httpurlconnection, URL url) {
/*  654 */     String s = url.getHost();
/*      */     String s1;
/*  656 */     if (((!s.endsWith(".5ch.net")) && (!s.endsWith(".2ch.net"))) || ((!s.equals("find.2ch.net")) || 
/*  657 */       (s.endsWith(".bbspink.com")))) {
/*  658 */       s1 = getUAName(false, true, true);
/*      */     } else {
/*  660 */       s1 = "Mozilla/4.0 (compatible)";
/*      */     }
/*  662 */     httpurlconnection.setRequestProperty("User-Agent", s1);
/*      */   }
/*      */   
/*      */   static boolean isLocalURL(String s) {
/*  666 */     return (s != null) && (s.startsWith("http://localboard/"));
/*      */   }
/*      */   
/*      */   static boolean isLocalURL(URL url) {
/*  670 */     return (url != null) && ("localboard".equals(url.getHost()));
/*      */   }
/*      */   
/*      */   static URL checkShitarabaURL(URL url) {
/*  674 */     String s = url.getHost();
/*  675 */     if ((s == null) || (!s.startsWith("jbbs.")))
/*  676 */       return url;
/*      */     try {
/*  678 */       url = new URL(V2CJBBSShitarabaBBS.unnormalizeURL(url
/*  679 */         .toExternalForm()));
/*      */     } catch (MalformedURLException malformedurlexception) {
/*  681 */       V2CMiscUtil.printMalformedURLException(malformedurlexception);
/*      */     }
/*  683 */     return url;
/*      */   }
/*      */   
/*      */   static String getCharsetFromV2CHttpUtil$CAndC(V2CHttpUtil.CAndC candc) {
/*  687 */     if (candc == null)
/*  688 */       return null;
/*  689 */     String s = getCharsetFromBytes(candc.getRawContents());
/*  690 */     if (s != null) {
/*  691 */       return s;
/*      */     }
/*  693 */     HttpURLConnection httpurlconnection = candc.getConnection();
/*  694 */     return httpurlconnection == null ? null : 
/*  695 */       getCharsetFromString(httpurlconnection.getContentType());
/*      */   }
/*      */   
/*      */   static String getCharsetFromBytes(byte[] abyte0)
/*      */   {
/*  700 */     if (abyte0 == null)
/*  701 */       return null;
/*  702 */     String s = null;
/*      */     try {
/*  704 */       s = new String(abyte0, "ISO-8859-1");
/*      */     }
/*      */     catch (UnsupportedEncodingException localUnsupportedEncodingException) {}
/*  707 */     if (s == null) {
/*  708 */       return null;
/*      */     }
/*  710 */     Pattern pattern = Pattern.compile("<meta ([^>]+)>", 2);
/*  711 */     Matcher matcher = pattern.matcher(s);
/*  712 */     return matcher.find() ? getCharsetFromString(matcher.group(1)) : 
/*  713 */       null;
/*      */   }
/*      */   
/*      */   static String getCharsetFromString(String s)
/*      */   {
/*  718 */     if (s == null)
/*  719 */       return null;
/*  720 */     s = s.toLowerCase();
/*  721 */     if (s.indexOf("utf-8") >= 0)
/*  722 */       return "UTF-8";
/*  723 */     if ((s.indexOf("shift_jis") >= 0) || (s.indexOf("sjis") >= 0))
/*  724 */       return "MS932";
/*  725 */     if (s.indexOf("euc-jp") >= 0)
/*  726 */       return "EUC-JP";
/*  727 */     if (s.indexOf("iso-2022-jp") >= 0) {
/*  728 */       return "ISO-2022-JP";
/*      */     }
/*  730 */     return null;
/*      */   }
/*      */   
/*      */   static void getTimeoutValues(V2CHttpTimeoutSettingPanel v2chttptimeoutsettingpanel)
/*      */   {
/*  735 */     V2CProperty v2cproperty = V2CMain.getUserProperty();
/*  736 */     int i = iConnectTimeout / 1000;
/*  737 */     boolean flag = v2cproperty.containsKey("HttpUtil.ConnectTimeout");
/*  738 */     int j = iReadTimeout / 1000;
/*  739 */     boolean flag1 = v2cproperty.containsKey("HttpUtil.ReadTimeout");
/*  740 */     v2chttptimeoutsettingpanel.setTimeoutValues(i, flag, j, flag1);
/*      */   }
/*      */   
/*      */   static void setTimeoutValues(int i, int j) {
/*  744 */     V2CProperty v2cproperty = V2CMain.getUserProperty();
/*  745 */     if (i > 0) {
/*  746 */       iConnectTimeout = i * 1000;
/*  747 */       v2cproperty.putInt("HttpUtil.ConnectTimeout", i);
/*      */     } else {
/*  749 */       iConnectTimeout = 60000;
/*  750 */       v2cproperty.remove("HttpUtil.ConnectTimeout");
/*      */     }
/*  752 */     if (j > 0) {
/*  753 */       iReadTimeout = j * 1000;
/*  754 */       v2cproperty.putInt("HttpUtil.ReadTimeout", j);
/*      */     } else {
/*  756 */       iReadTimeout = 120000;
/*  757 */       v2cproperty.remove("HttpUtil.ReadTimeout");
/*      */     }
/*      */   }
/*      */   
/*      */   static void setTimeout(URLConnection urlconnection) {
/*  762 */     setTimeout(urlconnection, iConnectTimeout, iReadTimeout);
/*      */   }
/*      */   
/*      */   static void setTimeout(URLConnection urlconnection, int i, int j) {
/*  766 */     if (V2CApp.javaVersionLessThan(1, 5)) {
/*  767 */       return;
/*      */     }
/*  769 */     V2CJ2SE5Util.setURLConnectionTimeouts(urlconnection, i, j);
/*      */   }
/*      */   
/*      */ 
/*      */   static RemoteHost getRemoteHost(URL url)
/*      */   {
/*  775 */     String s = url.getHost();
/*  776 */     if (s == null)
/*  777 */       s = "";
/*  778 */     RemoteHost remotehost = null;
/*  779 */     synchronized (hmHosts) {
/*  780 */       remotehost = (RemoteHost)hmHosts.get(s);
/*  781 */       if (remotehost == null) {
/*  782 */         remotehost = new RemoteHost(s);
/*  783 */         hmHosts.put(s, remotehost);
/*      */       }
/*      */     }
/*  786 */     return remotehost;
/*      */   }
/*      */   
/*      */   static void threadInterrupted(Thread thread) {
/*  790 */     synchronized (hmHosts) {
/*  791 */       Iterator iterator = hmHosts.values().iterator();
/*  792 */       while (iterator.hasNext()) {
/*  793 */         ((RemoteHost)iterator.next()).interrupted(thread);
/*      */       }
/*      */     }
/*      */   }
/*      */   
/*      */   static int getMaxConnectionNumber() {
/*  799 */     return V2CMain.getUserProperty().getInt("HttpUtil.MaxConnectionNumber", 
/*  800 */       5);
/*      */   }
/*      */   
/*      */ 
/*      */   private static String getHash(String message)
/*      */   {
/*      */     try
/*      */     {
/*  808 */       Key key = new SecretKeySpec(getHMKey().getBytes(), "HmacSHA256");
/*  809 */       Mac mac = Mac.getInstance(key.getAlgorithm());
/*  810 */       mac.init(key);
/*  811 */       byte[] data = mac.doFinal(message.getBytes());
/*  812 */       StringBuilder sb = new StringBuilder();
/*  813 */       byte[] arrayOfByte1; int j = (arrayOfByte1 = data).length; for (int i = 0; i < j; i++) { byte b = arrayOfByte1[i];
/*  814 */         String s = Integer.toHexString(0xFF & b);
/*  815 */         if (s.length() == 1) {
/*  816 */           sb.append("0");
/*      */         }
/*  818 */         sb.append(s);
/*      */       }
/*  820 */       return sb.toString();
/*      */     } catch (Exception e) {
/*  822 */       e.printStackTrace(); }
/*  823 */     return "";
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */   static boolean login2ch(String userId, String passwd, V2CProgressPanel v2cprogresspanel, boolean flag)
/*      */   {
/*  832 */     prev_userId = userId;
/*  833 */     prev_passwd = passwd;
/*  834 */     URL url = null;
/*  835 */     if (useAPI) {
/*  836 */       url = str2URL(V2CPlus2chProperty.use5chApi ? "https://api.5ch.net/v1/auth/" : "https://api.2ch.net/v1/auth/");
/*      */     } else {
/*  838 */       url = V2C2chBBS.getLoginServerURL();
/*      */     }
/*  840 */     Thread thread = Thread.currentThread();
/*  841 */     PrintWriter printwriter = null;
/*  842 */     BufferedReader bufferedreader = null;
/*  843 */     char[] ac = new char[nBufLen];
/*  844 */     StringBuilder sb = new StringBuilder();
/*  845 */     if (!V2CMain.isOnlineMode()) {
/*  846 */       logNotOnline(userId);
/*  847 */       return false;
/*      */     }
/*  849 */     if (url == null) {
/*  850 */       V2CLogger.logError(url, "Error in bbs2ch.getLoginServerURL().");
/*  851 */       V2C2chBBS.maruLoginFailed(flag);
/*  852 */       return false;
/*      */     }
/*      */     try
/*      */     {
/*  856 */       if (v2cprogresspanel != null) {
/*  857 */         v2cprogresspanel.setMessage("opening connection ...");
/*      */       }
/*  859 */       HttpsURLConnection httpsurlconnection = (HttpsURLConnection)
/*  860 */         V2CProxySetting.openReadConnection(url);
/*  861 */       if (thread.isInterrupted()) {
/*  862 */         logInterrupt(url);
/*  863 */         V2C2chBBS.maruLoginFailed(flag);
/*  864 */         return false;
/*      */       }
/*  866 */       if (V2CApp.javaVersionLessThan(1, 5))
/*      */       {
/*  868 */         httpsurlconnection.setHostnameVerifier(new MyHostnameVerifier());
/*      */       }
/*  870 */       httpsurlconnection.setRequestMethod("POST");
/*  871 */       httpsurlconnection.setDoOutput(true);
/*  872 */       httpsurlconnection.setUseCaches(false);
/*  873 */       httpsurlconnection.setAllowUserInteraction(false);
/*  874 */       httpsurlconnection.setRequestProperty("Host", url.getHost());
/*  875 */       httpsurlconnection.setRequestProperty("Accept", "*/*");
/*  876 */       httpsurlconnection.setRequestProperty("User-Agent", 
/*  877 */         getUAName(true, false, true));
/*  878 */       httpsurlconnection.setRequestProperty("X-2ch-UA", getX2chUA());
/*  879 */       V2CLogger.logHTTPHeaderFields(url, "2ch Login Request:", 
/*  880 */         httpsurlconnection.getRequestProperties());
/*  881 */       printwriter = new PrintWriter(httpsurlconnection.getOutputStream());
/*  882 */       if (thread.isInterrupted()) {
/*  883 */         logInterrupt(url);
/*  884 */         V2C2chBBS.maruLoginFailed(flag);
/*  885 */         return false;
/*      */       }
/*      */       
/*      */ 
/*  889 */       if (v2cprogresspanel != null) {
/*  890 */         v2cprogresspanel.setMessage("sending id&pw ...");
/*      */       }
/*      */       
/*  893 */       printwriter.print("ID=" + V2CJPConverter.urlEncode(userId, "MS932") + 
/*  894 */         "&PW=" + V2CJPConverter.urlEncode(passwd, "MS932"));
/*  895 */       if (useAPI) {
/*  896 */         String CT = String.valueOf(System.currentTimeMillis());
/*  897 */         CT = CT.substring(0, 10);
/*  898 */         String message = getAppKey() + CT;
/*  899 */         String HB = getHash(message);
/*  900 */         printwriter.print("&KY=" + 
/*  901 */           V2CJPConverter.urlEncode(getAppKey(), "MS932") + 
/*  902 */           "&CT=" + V2CJPConverter.urlEncode(CT, "MS932") + 
/*  903 */           "&HB=" + V2CJPConverter.urlEncode(HB, "MS932"));
/*      */       }
/*  905 */       printwriter.close();
/*  906 */       bufferedreader = new BufferedReader(new InputStreamReader(
/*  907 */         httpsurlconnection.getInputStream()));
/*  908 */       if (thread.isInterrupted()) {
/*  909 */         logInterrupt(url);
/*  910 */         V2C2chBBS.maruLoginFailed(flag);
/*  911 */         return false;
/*      */       }
/*  913 */       if (v2cprogresspanel != null)
/*  914 */         v2cprogresspanel.setMessage("receiving session ID ...");
/*      */       int j;
/*  916 */       while ((j = bufferedreader.read(ac)) >= 0) {
/*  917 */         if (thread.isInterrupted()) {
/*  918 */           logInterrupt(url);
/*  919 */           V2C2chBBS.maruLoginFailed(flag);
/*  920 */           return false;
/*      */         }
/*  922 */         if (j > 0) {
/*  923 */           sb.append(ac, 0, j);
/*      */         }
/*      */       }
/*  926 */       Map map = httpsurlconnection.getHeaderFields();
/*  927 */       if (map.containsKey("Set-Cookie")) {
/*  928 */         List list = (List)map.get("Set-Cookie");
/*  929 */         for (int l = 0; l < list.size(); l++) {
/*  930 */           V2CCookie.addCookie((String)list.get(l), url);
/*      */         }
/*      */       }
/*  933 */       logHTTPResponse(httpsurlconnection, "2ch Login Response: ");
/*      */     } catch (IOException ioexception) {
/*  935 */       V2CLogger.logError(url, V2CMiscUtil.getMessage(ioexception), 
/*  936 */         ioexception);
/*  937 */       V2C2chBBS.maruLoginFailed(flag);
/*  938 */       return false;
/*      */     } finally {
/*  940 */       V2CProxySetting.resetReadProxy();
/*  941 */       V2CLocalFileHandler.closeWriter(printwriter);
/*  942 */       V2CLocalFileHandler.closeReader(bufferedreader);
/*      */     }
/*      */     HttpsURLConnection httpsurlconnection;
/*  940 */     V2CProxySetting.resetReadProxy();
/*  941 */     V2CLocalFileHandler.closeWriter(printwriter);
/*  942 */     V2CLocalFileHandler.closeReader(bufferedreader);
/*      */     
/*  944 */     for (int i = sb.length() - 1; i >= 0; i--) {
/*  945 */       char k = sb.charAt(i);
/*  946 */       if ((k != '\n') && (k != '\r'))
/*      */         break;
/*  948 */       sb.setLength(i);
/*      */     }
/*  950 */     String str = sb.toString();
/*  951 */     if ((!str.startsWith("SESSION-ID=")) || 
/*  952 */       (str.regionMatches(11, "ERROR", 0, 5))) {
/*  953 */       V2C2chBBS.maruLoginFailed(flag);
/*  954 */       return false;
/*      */     }
/*  956 */     str = str.substring(11);
/*  957 */     int k = str.indexOf(':');
/*  958 */     if (k < 0) {
/*  959 */       V2C2chBBS.maruLoginFailed(flag);
/*  960 */       return false;
/*      */     }
/*  962 */     if (useAPI) {
/*  963 */       sid = str.substring(k + 1);
/*      */     }
/*  965 */     V2C2chBBS.setMaruSessionID(str, flag);
/*  966 */     return true;
/*      */   }
/*      */   
/*      */   private static boolean checkContentType(String s, String s1) {
/*  970 */     return (s1 == null) || ((s != null) && (
/*  971 */       (V2CMiscUtil.isEqual(s, s1)) || (s.startsWith(s1 + ';'))));
/*      */   }
/*      */   
/*      */   private static void logHTTPResponse(HttpURLConnection httpurlconnection, String s) throws IOException
/*      */   {
/*  976 */     V2CLogger.logHTTPHeaderFields(httpurlconnection.getURL(), s, 
/*  977 */       httpurlconnection.getHeaderFields());
/*      */   }
/*      */   
/*      */   private static void logRemoteHostError(URL url) {
/*  981 */     V2CLogger.logError(url, "    Error in getRemoteHost(u).");
/*      */   }
/*      */   
/*      */   private static void logInterrupt(URL url) {
/*  985 */     V2CLogger.logInfo(url, "    Interrupt detected.");
/*      */   }
/*      */   
/*      */   private static void logNotOnline(URL url) {
/*  989 */     V2CLogger.logInfo(url, "    Not online.");
/*      */   }
/*      */   
/*      */   private static void logNotOnline(String s) {
/*  993 */     V2CLogger.logInfo(s, "    Not online.");
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC getDatOchiFile(boolean isReadCGImode, URL url, V2CBBSThreadRes v2cbbsthreadres, V2CBBS v2cbbs)
/*      */   {
/*  999 */     setReadcgiMode(isReadCGImode);
/*      */     
/* 1001 */     if ((isReadCGImode) || (!useV2crEngine)) {
/* 1002 */       return updateDatFile(url, 0, 0L, null, v2cbbsthreadres, v2cbbs, 
/* 1003 */         false);
/*      */     }
/* 1005 */     return V2CHttpUtil.getDatOchiFile(url, v2cbbsthreadres, v2cbbs);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC getDatGzFile(boolean isReadCGImode, URL url, V2CBBSThreadRes v2cbbsthreadres, V2CBBS v2cbbs, boolean flag)
/*      */   {
/* 1011 */     setReadcgiMode(isReadCGImode);
/*      */     
/* 1013 */     if ((isReadCGImode) || (!useV2crEngine)) {
/* 1014 */       return updateDatFile(url, 0, 0L, null, v2cbbsthreadres, v2cbbs, 
/* 1015 */         flag);
/*      */     }
/* 1017 */     return V2CHttpUtil.getDatGzFile(url, v2cbbsthreadres, v2cbbs, flag);
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */   static V2CHttpUtil.CAndC updateDatFile(boolean isReadCGImode, URL url, int i, long l, String s, V2CBBSThreadRes v2cbbsthreadres, V2CBBS v2cbbs)
/*      */   {
/* 1024 */     setReadcgiMode(isReadCGImode);
/*      */     
/* 1026 */     if ((isReadCGImode) || (!useV2crEngine)) {
/* 1027 */       return updateDatFile(url, i, l, s, v2cbbsthreadres, v2cbbs);
/*      */     }
/* 1029 */     return V2CHttpUtil.updateDatFile(url, i, l, s, v2cbbsthreadres, 
/* 1030 */       v2cbbs);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC updateDatFile(URL url, int i, long l, String s, V2CBBSThreadRes v2cbbsthreadres, V2CBBS v2cbbs)
/*      */   {
/* 1036 */     return updateDatFile(url, i, l, s, v2cbbsthreadres, v2cbbs, false);
/*      */   }
/*      */   
/* 1039 */   static Pattern readcgi5pattern = null;
/* 1040 */   static Pattern readcgi6pattern = null;
/* 1041 */   static Pattern readcgi7pattern = null;
/* 1042 */   static Pattern readcgiPinkPattern = null;
/* 1043 */   static Pattern newLinePattern = null;
/* 1044 */   static Pattern newLinePattern7 = null;
/* 1045 */   static Pattern newLinePatternPink = null;
/*      */   
/*      */ 
/* 1048 */   static Pattern ssspPattern3 = null;
/* 1049 */   static Pattern ssspPattern4 = null;
/* 1050 */   static Pattern nameFontColorEracePattern = null;
/* 1051 */   static Pattern bannerPattern = null;
/* 1052 */   static Pattern namePattern = null;
/* 1053 */   static Pattern brShapingPatternPattern = null;
/* 1054 */   static Pattern imageSrcEracePattern = null;
/* 1055 */   static Pattern datePattern = null;
/* 1056 */   static Pattern titlePattern = null;
/* 1057 */   static Pattern hrefRemovePattern = null;
/* 1058 */   static Pattern removeHttpLinkPattern = null;
/*      */   static final String TOUMEI_ABORN = "透明あぼ～ん<>透明あぼ～ん<>透明あぼ～ん ID:DELETED<>透明あぼ～ん<>透明あぼ～ん\n";
/*      */   
/*      */   private static void initialHtml2Dat() {
/* 1062 */     if (readcgi5pattern != null) {
/* 1063 */       return;
/*      */     }
/*      */     
/* 1066 */     readcgi5pattern = 
/* 1067 */       Pattern.compile("<dt>([0-9]*).+(<a href=\"(.+)\">(.+)<\\/a>|<font color=\"?green\"?>(.+)<\\/font>)：(.+)<dd>(.+)<br><br>");
/*      */     
/* 1069 */     readcgi6pattern = 
/* 1070 */       Pattern.compile("<div class=\"post\" id=\"([0-9]*)\" data-date=\"[0-9A-Z]+\".+<div class=\"name\"><b>(.+)<\\/b><\\/div><div class=\"date\">(.+)<\\/div>.*<div class=\"message\">(.+)<\\/div><\\/div>");
/*      */     
/* 1072 */     readcgiPinkPattern = 
/* 1073 */       Pattern.compile("<dl class=\"post\" id=\"([0-9]*)\" data-date=\"[0-9A-Z]+\".+<span class=\"name\"><b>(.+)<\\/b><\\/span><span class=\"date\">(.+)<\\/span>.*<dd class=\"thread_in\">(.+)<\\/dd><\\/dl>");
/*      */     
/* 1075 */     newLinePattern7 = Pattern.compile("<div class=\"post\" id=");
/*      */     
/* 1077 */     readcgi7pattern = 
/* 1078 */       Pattern.compile("<div class=\"post\" id=\"([0-9]*)\" data-date=\"[0-9A-Z]+\".+<span class=\"name\"><b>(.+)<\\/b><\\/span><span class=\"date\">(.+)<\\/span><span class=\"uid\">(.*)<\\/span><\\/div><div class=\"message\"><span class=\"escaped\">(.+)</span><\\/div><\\/div>");
/*      */     
/* 1080 */     newLinePattern = Pattern.compile("<div class=\"post\" id=");
/*      */     
/* 1082 */     newLinePatternPink = Pattern.compile("<dl class=\"post\" id=");
/*      */     
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/* 1090 */     ssspPattern3 = 
/* 1091 */       Pattern.compile("<img src=\"\\/\\/(img\\.[25]ch\\.net\\/.+?)\">");
/*      */     
/* 1093 */     ssspPattern4 = 
/* 1094 */       Pattern.compile("<img src=\"\\/\\/(o\\.8ch\\.net\\/.+?)\">");
/*      */     
/* 1096 */     nameFontColorEracePattern = 
/* 1097 */       Pattern.compile("<font color=\"[0-9a-zA-Z]+\">(.+)<\\/font><><>");
/*      */     
/* 1099 */     bannerPattern = 
/* 1100 */       Pattern.compile("<div id=\"banner\">.+<div class=\"push\">");
/*      */     
/* 1102 */     namePattern = Pattern.compile("<b>(.*)<\\/b>");
/*      */     
/* 1104 */     brShapingPatternPattern = Pattern.compile("<br> (?=<br>)");
/*      */     
/* 1106 */     imageSrcEracePattern = Pattern.compile("<img src=\"(.*?)\">");
/*      */     
/* 1108 */     datePattern = 
/* 1109 */       Pattern.compile("<a href=\"javascript:be\\(([0-9]*)\\);\">.([^<]*)</a>");
/*      */     
/* 1111 */     titlePattern = Pattern.compile("<title>([^<]+)<\\/title>");
/*      */     
/* 1113 */     hrefRemovePattern = Pattern.compile("<a href=\"http.*?>(.*?)<\\/a>");
/*      */     
/* 1115 */     removeHttpLinkPattern = Pattern.compile("<a href=\"http[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#\\[\\]^|]+\">([-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#\\[\\]^|]+?)<\\/a>");
/*      */   }
/*      */   
/*      */ 
/*      */   static String html2Dat(String html, URL url, V2CBoardItem v2cboarditem, int lastResNum, boolean isBreakHtml)
/*      */   {
/* 1121 */     if (V2CPlus2chProperty.useScriptWhenCreateDat) {
/* 1122 */       if (!V2CReadCgiScript.bLoadTried)
/*      */       {
/* 1124 */         V2CScriptUtil.createUserScript(V2CReadCgiScript.sScriptFileName);
/*      */       }
/*      */       
/* 1127 */       if (!V2CReadCgiScript.fileFound()) {
/* 1128 */         JOptionPane.showMessageDialog(V2CMain.v2cMain, "DAT変換用スクリプトが存在しません\n" + 
/* 1129 */           V2CReadCgiScript.getFilePath(), "DAT変換エラー", 
/* 1130 */           0);
/* 1131 */         return "";
/*      */       }
/*      */       
/* 1134 */       String datStr = (String)V2CReadCgiScript.htmlToDat(url.toString(), 
/* 1135 */         html, lastResNum);
/*      */       
/* 1137 */       if (V2CPlus2chProperty.debugCreateDat)
/*      */       {
/* 1139 */         String message = datStr == null ? "dat生成エラー" : datStr;
/* 1140 */         System.out.println("〓〓〓 " + url + " 〓〓〓\n" + message);
/*      */       }
/*      */       
/* 1143 */       if (datStr == null) {
/* 1144 */         JOptionPane.showMessageDialog(V2CMain.v2cMain, "[" + url + 
/* 1145 */           "]\n\nスクリプトによるdatの生成に失敗しました。", "DAT生成エラー", 
/* 1146 */           0);
/* 1147 */         return "";
/*      */       }
/* 1149 */       return datStr;
/*      */     }
/*      */     
/* 1152 */     initialHtml2Dat();
/*      */     
/* 1154 */     StringBuilder sb = new StringBuilder();
/* 1155 */     String result = null;
/*      */     
/*      */ 
/*      */ 
/* 1159 */     html = ssspPattern3.matcher(html).replaceAll("sssp://$1");
/* 1160 */     html = ssspPattern4.matcher(html).replaceAll("sssp://$1");
/* 1161 */     int count = 0;
/* 1162 */     boolean isReadCgi7 = html.contains("<div class=\"pagestats\">");
/* 1163 */     boolean isReadCgi6 = (!isReadCgi7) && (html.contains("<div class=\"post\""));
/* 1164 */     boolean isReadCgi6Pink = (!isReadCgi7) && (!isReadCgi6) && (html.contains("<span class=\"number\">"));
/*      */     
/* 1166 */     if (!isReadCgi7) {
/* 1167 */       html = bannerPattern.matcher(html).replaceAll("");
/*      */     }
/*      */     
/* 1170 */     if (isReadCgi7) {
/* 1171 */       html = newLinePattern7.matcher(html).replaceAll(
/* 1172 */         "\n<div class=\"post\" id=");
/*      */       
/* 1174 */       Matcher datMatcher = readcgi7pattern.matcher(html);
/* 1175 */       int nextNum = lastResNum + 1;
/*      */       
/* 1177 */       while (datMatcher.find()) {
/* 1178 */         int currentNum = Integer.parseInt(datMatcher.group(1));
/*      */         
/*      */ 
/*      */ 
/* 1182 */         if (currentNum > lastResNum)
/*      */         {
/*      */ 
/*      */ 
/* 1186 */           String name = datMatcher.group(2);
/*      */           
/* 1188 */           String mail = "";
/*      */           
/* 1190 */           if (name.contains("<a href=\"mailto"))
/*      */           {
/* 1192 */             if (name.contains("<a href=\"http")) {
/* 1193 */               mail = removeHttpLinkPattern.matcher(name).replaceAll("$1");
/*      */               
/* 1195 */               name = V2CAppendUtil.getLastSandString(mail, "\">", "</a>");
/* 1196 */               mail = V2CAppendUtil.getSandString(mail, "href=\"mailto:", "\">");
/*      */               
/* 1198 */               if ((name.contains("<a href=\"http")) || (mail.contains("<a href=\"http"))) {
/* 1199 */                 name = V2CAppendUtil.removeHtmlTag(name);
/* 1200 */                 mail = V2CAppendUtil.removeHtmlTag(mail);
/*      */               }
/*      */             } else {
/* 1203 */               mail = V2CAppendUtil.getSandString(name, "href=\"mailto:", "\">");
/* 1204 */               name = V2CAppendUtil.getLastSandString(name, "\">", "</a>");
/*      */             }
/*      */           }
/* 1207 */           sb.append(name);
/* 1208 */           sb.append("<>");
/* 1209 */           sb.append(mail);
/* 1210 */           sb.append("<>");
/*      */           
/* 1212 */           String date = datMatcher.group(3);
/* 1213 */           String id = null;
/* 1214 */           String tempId = datMatcher.group(4);
/*      */           
/* 1216 */           int idx = tempId.indexOf("</span>");
/* 1217 */           if (idx > 0) {
/* 1218 */             id = tempId.substring(0, idx);
/*      */           } else {
/* 1220 */             id = tempId;
/*      */           }
/*      */           
/* 1223 */           sb.append(date);
/* 1224 */           sb.append(" ");
/* 1225 */           sb.append(id);
/*      */           try
/*      */           {
/* 1228 */             int beIdx = tempId.indexOf("<span class=\"be");
/* 1229 */             if (beIdx != -1) {
/* 1230 */               tempId = V2CMiscUtil.replaceAll(tempId, "be.2ch.net", "be.5ch.net");
/*      */               
/* 1232 */               String beID = V2CAppendUtil.getSandString(tempId, 
/* 1233 */                 "http://be.5ch.net/user/", "\"");
/* 1234 */               String bePoint = V2CAppendUtil.getSandString(tempId, "target=\"_blank\">", 
/* 1235 */                 "</a>");
/*      */               
/* 1237 */               if ((beID.length() > 0) && (bePoint.length() > 0)) {
/* 1238 */                 sb.append(" BE:");
/* 1239 */                 sb.append(beID);
/* 1240 */                 sb.append("-");
/* 1241 */                 sb.append(bePoint.substring(1));
/*      */               }
/*      */             }
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/* 1247 */             e.printStackTrace();
/*      */           }
/*      */           
/* 1250 */           String message = datMatcher.group(5);
/*      */           
/* 1252 */           sb.append("<>");
/* 1253 */           sb.append(message);
/* 1254 */           sb.append("<>");
/*      */           
/* 1256 */           String title = "";
/* 1257 */           if (currentNum == 1) {
/* 1258 */             Matcher m = titlePattern.matcher(html);
/* 1259 */             if (m.find()) {
/* 1260 */               title = m.group(1);
/* 1261 */               title = V2CMiscUtil.replaceFirst(title, "\n", "");
/*      */             } else {
/* 1263 */               title = "";
/*      */             }
/*      */           }
/*      */           
/* 1267 */           sb.append(title);
/* 1268 */           sb.append("\n");
/*      */           
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/* 1277 */           while (nextNum < currentNum) {
/* 1278 */             sb.append("透明あぼ～ん<>透明あぼ～ん<>透明あぼ～ん ID:DELETED<>透明あぼ～ん<>透明あぼ～ん\n");
/* 1279 */             nextNum++;
/*      */           }
/*      */           
/* 1282 */           count++;
/*      */           
/* 1284 */           nextNum = currentNum + 1;
/*      */         } }
/* 1286 */       result = sb.toString();
/*      */       
/* 1288 */       result = brShapingPatternPattern.matcher(result).replaceAll("$0 ");
/* 1289 */       result = imageSrcEracePattern.matcher(result).replaceAll("$1");
/* 1290 */       result = nameFontColorEracePattern.matcher(result).replaceAll("$1<><>");
/*      */     }
/* 1292 */     else if (isReadCgi6Pink)
/*      */     {
/* 1294 */       html = newLinePatternPink.matcher(html).replaceAll(
/* 1295 */         "\n<dl class=\"post\" id=");
/*      */       
/* 1297 */       Matcher datMatcher = readcgiPinkPattern.matcher(html);
/* 1298 */       int nextNum = lastResNum + 1;
/*      */       
/* 1300 */       while (datMatcher.find()) {
/* 1301 */         int currentNum = Integer.parseInt(datMatcher.group(1));
/* 1302 */         if (currentNum > lastResNum)
/*      */         {
/*      */ 
/*      */ 
/* 1306 */           String name = datMatcher.group(2);
/*      */           
/* 1308 */           String mail = "";
/*      */           
/* 1310 */           if (name.contains("<a href=\"mailto"))
/*      */           {
/* 1312 */             if (name.contains("<a href=\"http")) {
/* 1313 */               mail = removeHttpLinkPattern.matcher(name).replaceAll("$1");
/*      */               
/* 1315 */               name = V2CAppendUtil.getLastSandString(mail, "\">", "</a>");
/* 1316 */               mail = V2CAppendUtil.getSandString(mail, "href=\"mailto:", "\">");
/*      */               
/* 1318 */               if ((name.contains("<a href=\"http")) || (mail.contains("<a href=\"http"))) {
/* 1319 */                 name = V2CAppendUtil.removeHtmlTag(name);
/* 1320 */                 mail = V2CAppendUtil.removeHtmlTag(mail);
/*      */               }
/*      */             } else {
/* 1323 */               mail = V2CAppendUtil.getSandString(name, "href=\"mailto:", "\">");
/* 1324 */               name = V2CAppendUtil.getLastSandString(name, "\">", "</a>");
/*      */             }
/*      */           }
/* 1327 */           String date = datMatcher.group(3);
/*      */           try
/*      */           {
/* 1330 */             String line = datMatcher.group(0);
/* 1331 */             int beIdx = line.indexOf("<div class=\"be");
/* 1332 */             if (beIdx != -1) {
/* 1333 */               line = V2CMiscUtil.replaceAll(line, "be.2ch.net", "be.5ch.net");
/*      */               
/* 1335 */               String beID = V2CAppendUtil.getSandString(line, 
/* 1336 */                 "http://be.5ch.net/user/", "\"");
/* 1337 */               String bePoint = V2CAppendUtil.getSandString(line, "target=\"_blank\">", 
/* 1338 */                 "</a>");
/*      */               
/* 1340 */               if ((beID.length() > 0) && (bePoint.length() > 0)) {
/* 1341 */                 date = 
/* 1342 */                   date + " BE:" + beID + "-" + bePoint.substring(1);
/*      */               }
/*      */             }
/*      */           } catch (Exception e) {
/* 1346 */             e.printStackTrace();
/*      */           }
/*      */           
/* 1349 */           String message = datMatcher.group(4);
/*      */           
/* 1351 */           String title = "";
/* 1352 */           if (currentNum == 1) {
/* 1353 */             Matcher m = titlePattern.matcher(html);
/* 1354 */             if (m.find()) {
/* 1355 */               title = m.group(1);
/* 1356 */               title = V2CMiscUtil.replaceFirst(title, "\n", "");
/*      */             } else {
/* 1358 */               title = "";
/*      */             }
/*      */           }
/*      */           
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/* 1367 */           while (nextNum < currentNum) {
/* 1368 */             sb.append("透明あぼ～ん<>透明あぼ～ん<>透明あぼ～ん ID:DELETED<>透明あぼ～ん<>透明あぼ～ん\n");
/* 1369 */             nextNum++;
/*      */           }
/*      */           
/* 1372 */           sb.append(name);
/* 1373 */           sb.append("<>");
/* 1374 */           sb.append(mail);
/* 1375 */           sb.append("<>");
/* 1376 */           sb.append(date);
/* 1377 */           sb.append("<>");
/* 1378 */           sb.append(message);
/* 1379 */           sb.append("<>");
/* 1380 */           sb.append(title);
/* 1381 */           sb.append("\n");
/* 1382 */           count++;
/*      */           
/* 1384 */           nextNum = currentNum + 1;
/*      */         } }
/* 1386 */       result = sb.toString();
/*      */       
/* 1388 */       result = brShapingPatternPattern.matcher(result).replaceAll("$0 ");
/* 1389 */       result = imageSrcEracePattern.matcher(result).replaceAll("$1");
/* 1390 */       result = nameFontColorEracePattern.matcher(result).replaceAll("$1<><>");
/*      */     }
/* 1392 */     else if (isReadCgi6) {
/* 1393 */       html = newLinePattern.matcher(html).replaceAll(
/* 1394 */         "\n<div class=\"post\" id=");
/*      */       
/* 1396 */       Matcher datMatcher = readcgi6pattern.matcher(html);
/*      */       
/* 1398 */       while (datMatcher.find()) {
/* 1399 */         int currentNum = Integer.parseInt(datMatcher.group(1));
/* 1400 */         if (currentNum > lastResNum)
/*      */         {
/*      */ 
/*      */ 
/* 1404 */           String name = datMatcher.group(2);
/*      */           
/* 1406 */           String mail = "";
/*      */           
/* 1408 */           if (name.contains("<a href=\"mailto"))
/*      */           {
/* 1410 */             if (name.contains("<a href=\"http"))
/*      */             {
/*      */ 
/* 1413 */               mail = removeHttpLinkPattern.matcher(name).replaceAll("$1");
/*      */               
/*      */ 
/* 1416 */               name = V2CAppendUtil.getLastSandString(mail, "\">", "</a>");
/* 1417 */               mail = V2CAppendUtil.getSandString(mail, "href=\"mailto:", "\">");
/*      */               
/* 1419 */               if ((name.contains("<a href=\"http")) || (mail.contains("<a href=\"http")))
/*      */               {
/* 1421 */                 name = V2CAppendUtil.removeHtmlTag(name);
/* 1422 */                 mail = V2CAppendUtil.removeHtmlTag(mail);
/*      */               }
/*      */             } else {
/* 1425 */               mail = V2CAppendUtil.getSandString(name, "href=\"mailto:", "\">");
/* 1426 */               name = V2CAppendUtil.getLastSandString(name, "\">", "</a>");
/*      */             }
/*      */           }
/*      */           
/*      */ 
/*      */ 
/* 1432 */           String date = datMatcher.group(3);
/* 1433 */           int beIdx = date.indexOf("</div><div class=\"be");
/* 1434 */           if (beIdx != -1) {
/* 1435 */             date = V2CMiscUtil.replaceAll(date, "be.2ch.net", "be.5ch.net");
/*      */             
/* 1437 */             String beID = V2CAppendUtil.getSandString(date, 
/* 1438 */               "http://be.5ch.net/user/", "\"");
/* 1439 */             String bePoint = V2CAppendUtil.getSandString(date, "target=\"_blank\">", 
/* 1440 */               "</a>");
/*      */             
/* 1442 */             if ((beID.length() > 0) && (bePoint.length() > 0)) {
/* 1443 */               date = 
/* 1444 */                 date.substring(0, beIdx) + " BE:" + beID + "-" + bePoint.substring(1);
/*      */             }
/*      */           }
/* 1447 */           String message = datMatcher.group(4);
/*      */           
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/* 1453 */           String title = "";
/* 1454 */           if (currentNum == 1) {
/* 1455 */             Matcher m = titlePattern.matcher(html);
/* 1456 */             if (m.find()) {
/* 1457 */               title = m.group(1);
/* 1458 */               title = V2CMiscUtil.replaceFirst(title, "\n", "");
/*      */             } else {
/* 1460 */               title = "";
/*      */             }
/*      */           }
/*      */           
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/* 1468 */           sb.append(name);
/* 1469 */           sb.append("<>");
/* 1470 */           sb.append(mail);
/* 1471 */           sb.append("<>");
/* 1472 */           sb.append(date);
/* 1473 */           sb.append("<>");
/* 1474 */           sb.append(message);
/* 1475 */           sb.append("<>");
/* 1476 */           sb.append(title);
/* 1477 */           sb.append("\n");
/* 1478 */           count++;
/*      */         } }
/* 1480 */       result = sb.toString();
/*      */       
/* 1482 */       result = brShapingPatternPattern.matcher(result).replaceAll("$0 ");
/* 1483 */       result = imageSrcEracePattern.matcher(result).replaceAll("$1");
/*      */       
/* 1485 */       result = V2CMiscUtil.replaceAll(result, "</div>", "");
/*      */ 
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*      */ 
/* 1492 */       Matcher datMatcher = readcgi5pattern.matcher(html);
/* 1493 */       while (datMatcher.find()) {
/* 1494 */         int currRes = Integer.parseInt(datMatcher.group(1).trim());
/* 1495 */         if (currRes > lastResNum)
/*      */         {
/*      */ 
/* 1498 */           String name = datMatcher.group(4) == null ? datMatcher.group(5) : 
/* 1499 */             datMatcher.group(4);
/*      */           
/* 1501 */           name = namePattern.matcher(name).replaceAll("$1");
/*      */           
/* 1503 */           String mail = datMatcher.group(3) == null ? "" : datMatcher
/* 1504 */             .group(3);
/* 1505 */           mail = V2CMiscUtil.replaceFirst(mail, "mailto:", "");
/*      */           
/* 1507 */           String date = datMatcher.group(6) == null ? "" : datMatcher
/* 1508 */             .group(6);
/* 1509 */           date = datePattern.matcher(date).replaceFirst("BE:$1-$2");
/*      */           
/* 1511 */           String message = datMatcher.group(7) == null ? "" : datMatcher
/* 1512 */             .group(7);
/*      */           
/* 1514 */           message = brShapingPatternPattern.matcher(message).replaceAll("$0 ");
/* 1515 */           message = imageSrcEracePattern.matcher(message).replaceAll("$1");
/*      */           
/* 1517 */           String title = "";
/* 1518 */           if (currRes == 1) {
/* 1519 */             Matcher m = titlePattern.matcher(html);
/* 1520 */             if (m.find()) {
/* 1521 */               title = m.group(1);
/*      */             } else {
/* 1523 */               title = "";
/*      */             }
/*      */           }
/* 1526 */           sb.append(name);
/* 1527 */           sb.append("<>");
/* 1528 */           sb.append(mail);
/* 1529 */           sb.append("<>");
/* 1530 */           sb.append(date);
/* 1531 */           sb.append("<>");
/* 1532 */           sb.append(message);
/* 1533 */           sb.append("<>");
/* 1534 */           sb.append(title);
/* 1535 */           sb.append("\n");
/* 1536 */           count++;
/*      */         } }
/* 1538 */       result = sb.toString();
/*      */     }
/*      */     
/* 1541 */     result = hrefRemovePattern.matcher(result).replaceAll("$1");
/*      */     
/* 1543 */     if ((isBreakHtml) && (result.length() > 100)) {
/* 1544 */       String urlStr = url.toString();
/*      */       
/* 1546 */       if (urlStr.endsWith("/")) {
/* 1547 */         urlStr = urlStr + (count + lastResNum);
/*      */       } else {
/* 1549 */         int lastIdx = urlStr.lastIndexOf("/");
/* 1550 */         if (lastIdx >= 0) {
/* 1551 */           urlStr = 
/* 1552 */             urlStr.substring(0, lastIdx) + "/" + (count + lastResNum);
/*      */         }
/*      */       }
/* 1555 */       urlStr = V2CMiscUtil.replaceAll(urlStr, "2ch.net/", "2ch.sc/");
/* 1556 */       urlStr = V2CMiscUtil.replaceAll(urlStr, "5ch.net/", "2ch.sc/");
/*      */       
/* 1558 */       result = result + "ERROR<>sage<>2000/01/01(土) 00:00:00.00 ID:XXXXXXXX<>スレッドが破損しているためこれ以上読み込むことができません。<BR><BR>※2ch.scで続きを見ることができるかもしれません<BR>" + 
/* 1559 */         urlStr + "<>\n";
/*      */     }
/*      */     
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/* 1583 */     return result;
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */   static V2CHttpUtil.CAndC updateDatFile(URL url, int startPos, long lastModified, String eTag, V2CBBSThreadRes threadRes, V2CBBS v2cbbs, boolean acceptGZ)
/*      */   {
/* 1780 */     return updateDatFile(url, startPos, lastModified, eTag, threadRes, 
/* 1781 */       v2cbbs, acceptGZ, false);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC updateDatFile(URL url, int startPos, long lastModified, String eTag, V2CBBSThreadRes v2cbbsthreadres, V2CBBS v2cbbs, boolean acceptGZ, boolean isAPIFail)
/*      */   {
/* 1787 */     return V2CHttpUtil.updateDatFile(url, startPos, lastModified, eTag, 
/* 1788 */       v2cbbsthreadres, v2cbbs, acceptGZ, isAPIFail/*, false*/);
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/* 2377 */   private static final String[] errorMesssages = { "datが存在しません。削除されたかURL間違ってますよ。", 
/* 2378 */     "もうずっと人大杉", "今、サーバの負荷が高いのね", "もう怒った寝てやる。", 
/* 2379 */     "2ch.net is very busy", "お茶でも飲みましょう", "ようこそバーボンハウスへ" };
/*      */   
/*      */   /* Error */
/*      */   // static V2CHttpUtil.CAndC updateDatFile(URL url, int startPos, long lastModified, String eTag, V2CBBSThreadRes v2cbbsthreadres, V2CBBS v2cbbs, boolean acceptGZ, boolean isAPIFail, boolean nowRedirect)
/*      */   // {
/*      */     // Byte code:
/*      */     //   0: aconst_null
/*      */     //   1: astore 10
/*      */     //   3: aconst_null
/*      */     //   4: astore 11
/*      */     //   6: aload_0
/*      */     //   7: ifnull +10 -> 17
/*      */     //   10: aload_0
/*      */     //   11: invokestatic 2567	org/monazilla/v2c/V2CPlusHttpUtil:isLocalURL	(Ljava/net/URL;)Z
/*      */     //   14: ifeq +5 -> 19
/*      */     //   17: aconst_null
/*      */     //   18: areturn
/*      */     //   19: invokestatic 2510	org/monazilla/v2c/V2CMain:isOnlineMode	()Z
/*      */     //   22: ifne +9 -> 31
/*      */     //   25: aload_0
/*      */     //   26: invokestatic 2565	org/monazilla/v2c/V2CPlusHttpUtil:logNotOnline	(Ljava/net/URL;)V
/*      */     //   29: aconst_null
/*      */     //   30: areturn
/*      */     //   31: aload_0
/*      */     //   32: invokestatic 2581	org/monazilla/v2c/V2CPlusHttpUtil:checkShitarabaURL	(Ljava/net/URL;)Ljava/net/URL;
/*      */     //   35: astore_0
/*      */     //   36: aload_0
/*      */     //   37: invokevirtual 2390	java/net/URL:toString	()Ljava/lang/String;
/*      */     //   40: astore 12
/*      */     //   42: getstatic 2218	org/monazilla/v2c/V2CPlusHttpUtil:useAPI	Z
/*      */     //   45: ifne +39 -> 84
/*      */     //   48: getstatic 2219	org/monazilla/v2c/V2CPlusHttpUtil:useHTML	Z
/*      */     //   51: ifeq +33 -> 84
/*      */     //   54: aload 12
/*      */     //   56: ldc_w 1179
/*      */     //   59: invokevirtual 2319	java/lang/String:contains	(Ljava/lang/CharSequence;)Z
/*      */     //   62: ifeq +22 -> 84
/*      */     //   65: aload 12
/*      */     //   67: ldc_w 1179
/*      */     //   70: ldc_w 1182
/*      */     //   73: invokestatic 2528	org/monazilla/v2c/V2CMiscUtil:replaceFirst	(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;
/*      */     //   76: astore 12
/*      */     //   78: aload 12
/*      */     //   80: invokestatic 2578	org/monazilla/v2c/V2CPlusHttpUtil:str2URL	(Ljava/lang/String;)Ljava/net/URL;
/*      */     //   83: astore_0
/*      */     //   84: invokestatic 2358	java/lang/Thread:currentThread	()Ljava/lang/Thread;
/*      */     //   87: astore 13
/*      */     //   89: aload_0
/*      */     //   90: invokestatic 2584	org/monazilla/v2c/V2CPlusHttpUtil:getRemoteHost	(Ljava/net/URL;)Lorg/monazilla/v2c/V2CPlusHttpUtil$RemoteHost;
/*      */     //   93: astore 14
/*      */     //   95: aload 14
/*      */     //   97: invokevirtual 2617	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:start	()V
/*      */     //   100: aconst_null
/*      */     //   101: astore 16
/*      */     //   103: aconst_null
/*      */     //   104: astore 17
/*      */     //   106: iconst_0
/*      */     //   107: istore 18
/*      */     //   109: iconst_0
/*      */     //   110: istore 19
/*      */     //   112: aconst_null
/*      */     //   113: astore 20
/*      */     //   115: iconst_0
/*      */     //   116: istore 21
/*      */     //   118: getstatic 2218	org/monazilla/v2c/V2CPlusHttpUtil:useAPI	Z
/*      */     //   121: ifeq +138 -> 259
/*      */     //   124: iload 8
/*      */     //   126: ifne +133 -> 259
/*      */     //   129: getstatic 2244	org/monazilla/v2c/V2CPlusHttpUtil:get2chPattern	Ljava/util/regex/Pattern;
/*      */     //   132: aload 12
/*      */     //   134: invokevirtual 2411	java/util/regex/Pattern:matcher	(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;
/*      */     //   137: astore 22
/*      */     //   139: aload 22
/*      */     //   141: invokevirtual 2407	java/util/regex/Matcher:matches	()Z
/*      */     //   144: ifeq +343 -> 487
/*      */     //   147: iconst_1
/*      */     //   148: istore 18
/*      */     //   150: iconst_1
/*      */     //   151: istore 21
/*      */     //   153: aload 22
/*      */     //   155: iconst_1
/*      */     //   156: invokevirtual 2408	java/util/regex/Matcher:group	(I)Ljava/lang/String;
/*      */     //   159: astore 23
/*      */     //   161: aload 22
/*      */     //   163: iconst_3
/*      */     //   164: invokevirtual 2408	java/util/regex/Matcher:group	(I)Ljava/lang/String;
/*      */     //   167: astore 24
/*      */     //   169: aload 22
/*      */     //   171: iconst_4
/*      */     //   172: invokevirtual 2408	java/util/regex/Matcher:group	(I)Ljava/lang/String;
/*      */     //   175: astore 25
/*      */     //   177: new 1463	java/lang/StringBuilder
/*      */     //   180: dup
/*      */     //   181: ldc_w 1187
/*      */     //   184: invokespecial 2345	java/lang/StringBuilder:<init>	(Ljava/lang/String;)V
/*      */     //   187: aload 23
/*      */     //   189: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   192: ldc_w 1185
/*      */     //   195: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   198: aload 24
/*      */     //   200: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   203: ldc_w 1185
/*      */     //   206: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   209: aload 25
/*      */     //   211: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   214: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   217: astore 10
/*      */     //   219: new 1463	java/lang/StringBuilder
/*      */     //   222: dup
/*      */     //   223: getstatic 2206	org/monazilla/v2c/V2CPlus2chProperty:use5chApi	Z
/*      */     //   226: ifeq +9 -> 235
/*      */     //   229: ldc_w 1362
/*      */     //   232: goto +6 -> 238
/*      */     //   235: ldc_w 1360
/*      */     //   238: invokestatic 2336	java/lang/String:valueOf	(Ljava/lang/Object;)Ljava/lang/String;
/*      */     //   241: invokespecial 2345	java/lang/StringBuilder:<init>	(Ljava/lang/String;)V
/*      */     //   244: aload 10
/*      */     //   246: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   249: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   252: invokestatic 2578	org/monazilla/v2c/V2CPlusHttpUtil:str2URL	(Ljava/lang/String;)Ljava/net/URL;
/*      */     //   255: astore_0
/*      */     //   256: goto +231 -> 487
/*      */     //   259: getstatic 2219	org/monazilla/v2c/V2CPlusHttpUtil:useHTML	Z
/*      */     //   262: ifeq +160 -> 422
/*      */     //   265: getstatic 2244	org/monazilla/v2c/V2CPlusHttpUtil:get2chPattern	Ljava/util/regex/Pattern;
/*      */     //   268: aload 12
/*      */     //   270: invokevirtual 2411	java/util/regex/Pattern:matcher	(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;
/*      */     //   273: astore 22
/*      */     //   275: aload 22
/*      */     //   277: invokevirtual 2407	java/util/regex/Matcher:matches	()Z
/*      */     //   280: ifeq +207 -> 487
/*      */     //   283: iconst_1
/*      */     //   284: istore 19
/*      */     //   286: iconst_1
/*      */     //   287: istore 21
/*      */     //   289: aload 22
/*      */     //   291: iconst_1
/*      */     //   292: invokevirtual 2408	java/util/regex/Matcher:group	(I)Ljava/lang/String;
/*      */     //   295: astore 23
/*      */     //   297: aload 22
/*      */     //   299: iconst_2
/*      */     //   300: invokevirtual 2408	java/util/regex/Matcher:group	(I)Ljava/lang/String;
/*      */     //   303: astore 24
/*      */     //   305: aload 22
/*      */     //   307: iconst_3
/*      */     //   308: invokevirtual 2408	java/util/regex/Matcher:group	(I)Ljava/lang/String;
/*      */     //   311: astore 25
/*      */     //   313: aload 22
/*      */     //   315: iconst_4
/*      */     //   316: invokevirtual 2408	java/util/regex/Matcher:group	(I)Ljava/lang/String;
/*      */     //   319: astore 26
/*      */     //   321: new 1463	java/lang/StringBuilder
/*      */     //   324: dup
/*      */     //   325: ldc_w 1353
/*      */     //   328: invokespecial 2345	java/lang/StringBuilder:<init>	(Ljava/lang/String;)V
/*      */     //   331: aload 23
/*      */     //   333: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   336: aload 24
/*      */     //   338: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   341: ldc_w 1186
/*      */     //   344: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   347: aload 25
/*      */     //   349: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   352: ldc_w 1185
/*      */     //   355: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   358: aload 26
/*      */     //   360: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   363: ldc_w 1185
/*      */     //   366: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   369: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   372: astore 10
/*      */     //   374: aload 5
/*      */     //   376: getfield 2198	org/monazilla/v2c/V2CBBSThreadRes:nRes	I
/*      */     //   379: ifle +34 -> 413
/*      */     //   382: new 1463	java/lang/StringBuilder
/*      */     //   385: dup
/*      */     //   386: aload 10
/*      */     //   388: invokestatic 2336	java/lang/String:valueOf	(Ljava/lang/Object;)Ljava/lang/String;
/*      */     //   391: invokespecial 2345	java/lang/StringBuilder:<init>	(Ljava/lang/String;)V
/*      */     //   394: aload 5
/*      */     //   396: getfield 2198	org/monazilla/v2c/V2CBBSThreadRes:nRes	I
/*      */     //   399: invokevirtual 2347	java/lang/StringBuilder:append	(I)Ljava/lang/StringBuilder;
/*      */     //   402: ldc_w 1175
/*      */     //   405: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   408: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   411: astore 10
/*      */     //   413: aload 10
/*      */     //   415: invokestatic 2578	org/monazilla/v2c/V2CPlusHttpUtil:str2URL	(Ljava/lang/String;)Ljava/net/URL;
/*      */     //   418: astore_0
/*      */     //   419: goto +68 -> 487
/*      */     //   422: getstatic 2220	org/monazilla/v2c/V2CPlusHttpUtil:useSC	Z
/*      */     //   425: ifeq +62 -> 487
/*      */     //   428: getstatic 2244	org/monazilla/v2c/V2CPlusHttpUtil:get2chPattern	Ljava/util/regex/Pattern;
/*      */     //   431: aload 12
/*      */     //   433: invokevirtual 2411	java/util/regex/Pattern:matcher	(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;
/*      */     //   436: astore 22
/*      */     //   438: aload 22
/*      */     //   440: invokevirtual 2407	java/util/regex/Matcher:matches	()Z
/*      */     //   443: ifeq +44 -> 487
/*      */     //   446: aload_0
/*      */     //   447: invokevirtual 2390	java/net/URL:toString	()Ljava/lang/String;
/*      */     //   450: astore 23
/*      */     //   452: iconst_1
/*      */     //   453: istore 21
/*      */     //   455: aload 23
/*      */     //   457: ldc_w 1178
/*      */     //   460: ldc_w 1180
/*      */     //   463: invokevirtual 2337	java/lang/String:replace	(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;
/*      */     //   466: astore 23
/*      */     //   468: aload 23
/*      */     //   470: ldc_w 1181
/*      */     //   473: ldc_w 1180
/*      */     //   476: invokevirtual 2337	java/lang/String:replace	(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;
/*      */     //   479: astore 23
/*      */     //   481: aload 23
/*      */     //   483: invokestatic 2578	org/monazilla/v2c/V2CPlusHttpUtil:str2URL	(Ljava/lang/String;)Ljava/net/URL;
/*      */     //   486: astore_0
/*      */     //   487: aload 13
/*      */     //   489: invokevirtual 2355	java/lang/Thread:isInterrupted	()Z
/*      */     //   492: ifeq +45 -> 537
/*      */     //   495: aload_0
/*      */     //   496: invokestatic 2564	org/monazilla/v2c/V2CPlusHttpUtil:logInterrupt	(Ljava/net/URL;)V
/*      */     //   499: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   502: aload 14
/*      */     //   504: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   507: aload 16
/*      */     //   509: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   512: aload 11
/*      */     //   514: ifnull +16 -> 530
/*      */     //   517: aload 11
/*      */     //   519: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   522: aconst_null
/*      */     //   523: astore 11
/*      */     //   525: goto +5 -> 530
/*      */     //   528: astore 46
/*      */     //   530: aload 20
/*      */     //   532: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   535: aconst_null
/*      */     //   536: areturn
/*      */     //   537: iconst_m1
/*      */     //   538: istore 22
/*      */     //   540: aload_0
/*      */     //   541: invokestatic 2629	org/monazilla/v2c/V2CProxySetting:openReadConnection	(Ljava/net/URL;)Ljava/net/HttpURLConnection;
/*      */     //   544: astore 23
/*      */     //   546: aload 23
/*      */     //   548: invokestatic 2568	org/monazilla/v2c/V2CPlusHttpUtil:setTimeout	(Ljava/net/URLConnection;)V
/*      */     //   551: aload 23
/*      */     //   553: ldc_w 1269
/*      */     //   556: aload_0
/*      */     //   557: invokevirtual 2386	java/net/URL:getHost	()Ljava/lang/String;
/*      */     //   560: invokevirtual 2380	java/net/HttpURLConnection:setRequestProperty	(Ljava/lang/String;Ljava/lang/String;)V
/*      */     //   563: aload 23
/*      */     //   565: ldc_w 1236
/*      */     //   568: ldc_w 1172
/*      */     //   571: invokevirtual 2380	java/net/HttpURLConnection:setRequestProperty	(Ljava/lang/String;Ljava/lang/String;)V
/*      */     //   574: iload 19
/*      */     //   576: ifeq +17 -> 593
/*      */     //   579: aload 23
/*      */     //   581: ldc_w 1320
/*      */     //   584: getstatic 2235	org/monazilla/v2c/V2CPlusHttpUtil:uaRead1	Ljava/lang/String;
/*      */     //   587: invokevirtual 2380	java/net/HttpURLConnection:setRequestProperty	(Ljava/lang/String;Ljava/lang/String;)V
/*      */     //   590: goto +41 -> 631
/*      */     //   593: aload 23
/*      */     //   595: ldc_w 1320
/*      */     //   598: aload 6
/*      */     //   600: ifnull +26 -> 626
/*      */     //   603: aload 6
/*      */     //   605: invokevirtual 2450	org/monazilla/v2c/V2CBBS:is2chEq	()Z
/*      */     //   608: ifne +18 -> 626
/*      */     //   611: iconst_0
/*      */     //   612: iconst_0
/*      */     //   613: iload 18
/*      */     //   615: aload 6
/*      */     //   617: invokevirtual 2451	org/monazilla/v2c/V2CBBS:isMachiBBS	()Z
/*      */     //   620: invokestatic 2562	org/monazilla/v2c/V2CPlusHttpUtil:getUAName	(ZZZZ)Ljava/lang/String;
/*      */     //   623: goto +5 -> 628
/*      */     //   626: ldc 8
/*      */     //   628: invokevirtual 2380	java/net/HttpURLConnection:setRequestProperty	(Ljava/lang/String;Ljava/lang/String;)V
/*      */     //   631: iload_1
/*      */     //   632: ifle +38 -> 670
/*      */     //   635: lload_2
/*      */     //   636: lconst_0
/*      */     //   637: lcmp
/*      */     //   638: ifle +32 -> 670
/*      */     //   641: aload 23
/*      */     //   643: lload_2
/*      */     //   644: invokevirtual 2364	java/net/HttpURLConnection:setIfModifiedSince	(J)V
/*      */     //   647: aload 4
/*      */     //   649: ifnull +21 -> 670
/*      */     //   652: aload 4
/*      */     //   654: invokevirtual 2313	java/lang/String:length	()I
/*      */     //   657: ifle +13 -> 670
/*      */     //   660: aload 23
/*      */     //   662: ldc_w 1277
/*      */     //   665: aload 4
/*      */     //   667: invokevirtual 2380	java/net/HttpURLConnection:setRequestProperty	(Ljava/lang/String;Ljava/lang/String;)V
/*      */     //   670: iload_1
/*      */     //   671: ifle +20 -> 691
/*      */     //   674: aload 6
/*      */     //   676: invokevirtual 2452	org/monazilla/v2c/V2CBBS:useRangeRequestHeader	()Z
/*      */     //   679: ifeq +12 -> 691
/*      */     //   682: iload 19
/*      */     //   684: ifne +7 -> 691
/*      */     //   687: iconst_1
/*      */     //   688: goto +4 -> 692
/*      */     //   691: iconst_0
/*      */     //   692: istore 24
/*      */     //   694: iload 24
/*      */     //   696: ifeq +48 -> 744
/*      */     //   699: aload 23
/*      */     //   701: ldc_w 1305
/*      */     //   704: new 1463	java/lang/StringBuilder
/*      */     //   707: dup
/*      */     //   708: ldc_w 1342
/*      */     //   711: invokespecial 2345	java/lang/StringBuilder:<init>	(Ljava/lang/String;)V
/*      */     //   714: iload_1
/*      */     //   715: invokevirtual 2347	java/lang/StringBuilder:append	(I)Ljava/lang/StringBuilder;
/*      */     //   718: ldc_w 1175
/*      */     //   721: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   724: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   727: invokevirtual 2380	java/net/HttpURLConnection:setRequestProperty	(Ljava/lang/String;Ljava/lang/String;)V
/*      */     //   730: aload 23
/*      */     //   732: ldc_w 1237
/*      */     //   735: ldc_w 1368
/*      */     //   738: invokevirtual 2380	java/net/HttpURLConnection:setRequestProperty	(Ljava/lang/String;Ljava/lang/String;)V
/*      */     //   741: goto +19 -> 760
/*      */     //   744: iload 7
/*      */     //   746: ifne +14 -> 760
/*      */     //   749: aload 23
/*      */     //   751: ldc_w 1237
/*      */     //   754: ldc_w 1350
/*      */     //   757: invokevirtual 2380	java/net/HttpURLConnection:setRequestProperty	(Ljava/lang/String;Ljava/lang/String;)V
/*      */     //   760: aload_0
/*      */     //   761: getstatic 2219	org/monazilla/v2c/V2CPlusHttpUtil:useHTML	Z
/*      */     //   764: ifeq +14 -> 778
/*      */     //   767: iload 21
/*      */     //   769: ifeq +9 -> 778
/*      */     //   772: ldc_w 1395
/*      */     //   775: goto +6 -> 781
/*      */     //   778: ldc_w 1251
/*      */     //   781: aload 23
/*      */     //   783: invokevirtual 2378	java/net/HttpURLConnection:getRequestProperties	()Ljava/util/Map;
/*      */     //   786: invokestatic 2509	org/monazilla/v2c/V2CLogger:logHTTPHeaderFields	(Ljava/net/URL;Ljava/lang/String;Ljava/util/Map;)V
/*      */     //   789: iload 18
/*      */     //   791: ifeq +170 -> 961
/*      */     //   794: invokestatic 2438	org/monazilla/v2c/V2C2chBBS:getMaruSessionID	()Ljava/lang/String;
/*      */     //   797: astore 25
/*      */     //   799: aload 25
/*      */     //   801: ifnull +9 -> 810
/*      */     //   804: aload 25
/*      */     //   806: invokevirtual 2313	java/lang/String:length	()I
/*      */     //   809: pop
/*      */     //   810: aload 23
/*      */     //   812: iconst_1
/*      */     //   813: invokevirtual 2366	java/net/HttpURLConnection:setDoOutput	(Z)V
/*      */     //   816: aload 23
/*      */     //   818: ldc_w 1302
/*      */     //   821: invokevirtual 2375	java/net/HttpURLConnection:setRequestMethod	(Ljava/lang/String;)V
/*      */     //   824: aload 5
/*      */     //   826: invokevirtual 2458	org/monazilla/v2c/V2CBBSThreadRes:getThreadItem	()Lorg/monazilla/v2c/V2CThreadItem;
/*      */     //   829: invokevirtual 2642	org/monazilla/v2c/V2CThreadItem:getURL	()Ljava/net/URL;
/*      */     //   832: astore 26
/*      */     //   834: aload 26
/*      */     //   836: invokestatic 2469	org/monazilla/v2c/V2CHttpUtil:getHost	(Ljava/net/URL;)Ljava/lang/String;
/*      */     //   839: astore 27
/*      */     //   841: aload 27
/*      */     //   843: iconst_0
/*      */     //   844: aload 27
/*      */     //   846: ldc_w 1177
/*      */     //   849: invokevirtual 2328	java/lang/String:indexOf	(Ljava/lang/String;)I
/*      */     //   852: invokevirtual 2325	java/lang/String:substring	(II)Ljava/lang/String;
/*      */     //   855: astore 27
/*      */     //   857: new 1463	java/lang/StringBuilder
/*      */     //   860: dup
/*      */     //   861: invokestatic 2465	org/monazilla/v2c/V2CHttpUtil:v1	()Ljava/lang/String;
/*      */     //   864: invokestatic 2336	java/lang/String:valueOf	(Ljava/lang/Object;)Ljava/lang/String;
/*      */     //   867: invokespecial 2345	java/lang/StringBuilder:<init>	(Ljava/lang/String;)V
/*      */     //   870: aload 27
/*      */     //   872: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   875: ldc_w 1185
/*      */     //   878: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   881: aload 5
/*      */     //   883: invokevirtual 2458	org/monazilla/v2c/V2CBBSThreadRes:getThreadItem	()Lorg/monazilla/v2c/V2CThreadItem;
/*      */     //   886: invokevirtual 2640	org/monazilla/v2c/V2CThreadItem:getBoardString	()Ljava/lang/String;
/*      */     //   889: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   892: ldc_w 1185
/*      */     //   895: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   898: aload 5
/*      */     //   900: invokevirtual 2458	org/monazilla/v2c/V2CBBSThreadRes:getThreadItem	()Lorg/monazilla/v2c/V2CThreadItem;
/*      */     //   903: invokevirtual 2641	org/monazilla/v2c/V2CThreadItem:getThreadKey	()Ljava/lang/String;
/*      */     //   906: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   909: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   912: astore 28
/*      */     //   914: aload 28
/*      */     //   916: invokestatic 2467	org/monazilla/v2c/V2CHttpUtil:genMessage	(Ljava/lang/String;)Ljava/lang/String;
/*      */     //   919: astore 29
/*      */     //   921: aload 29
/*      */     //   923: invokestatic 2466	org/monazilla/v2c/V2CHttpUtil:calcHmacSHA256	(Ljava/lang/String;)Ljava/lang/String;
/*      */     //   926: astore 30
/*      */     //   928: aload 30
/*      */     //   930: invokestatic 2468	org/monazilla/v2c/V2CHttpUtil:genParam	(Ljava/lang/String;)Ljava/lang/String;
/*      */     //   933: astore 31
/*      */     //   935: new 1449	java/io/PrintStream
/*      */     //   938: dup
/*      */     //   939: aload 23
/*      */     //   941: invokevirtual 2371	java/net/HttpURLConnection:getOutputStream	()Ljava/io/OutputStream;
/*      */     //   944: invokespecial 2294	java/io/PrintStream:<init>	(Ljava/io/OutputStream;)V
/*      */     //   947: astore 17
/*      */     //   949: aload 17
/*      */     //   951: aload 31
/*      */     //   953: invokevirtual 2296	java/io/PrintStream:print	(Ljava/lang/String;)V
/*      */     //   956: aload 17
/*      */     //   958: invokevirtual 2293	java/io/PrintStream:flush	()V
/*      */     //   961: aload 14
/*      */     //   963: invokevirtual 2615	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:check	()V
/*      */     //   966: iconst_0
/*      */     //   967: istore 25
/*      */     //   969: ldc_w 1137
/*      */     //   972: astore 26
/*      */     //   974: aconst_null
/*      */     //   975: astore 27
/*      */     //   977: aload 23
/*      */     //   979: invokevirtual 2361	java/net/HttpURLConnection:getResponseCode	()I
/*      */     //   982: istore 22
/*      */     //   984: goto +39 -> 1023
/*      */     //   987: astore 28
/*      */     //   989: sipush 999
/*      */     //   992: istore 22
/*      */     //   994: iconst_1
/*      */     //   995: istore 25
/*      */     //   997: aload 28
/*      */     //   999: astore 27
/*      */     //   1001: aload 28
/*      */     //   1003: invokevirtual 2384	java/net/SocketTimeoutException:getMessage	()Ljava/lang/String;
/*      */     //   1006: astore 26
/*      */     //   1008: goto +15 -> 1023
/*      */     //   1011: astore 28
/*      */     //   1013: aload 28
/*      */     //   1015: invokevirtual 2304	java/lang/Exception:printStackTrace	()V
/*      */     //   1018: sipush 999
/*      */     //   1021: istore 22
/*      */     //   1023: aload 13
/*      */     //   1025: invokevirtual 2355	java/lang/Thread:isInterrupted	()Z
/*      */     //   1028: ifeq +45 -> 1073
/*      */     //   1031: aload_0
/*      */     //   1032: invokestatic 2564	org/monazilla/v2c/V2CPlusHttpUtil:logInterrupt	(Ljava/net/URL;)V
/*      */     //   1035: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1038: aload 14
/*      */     //   1040: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1043: aload 16
/*      */     //   1045: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1048: aload 11
/*      */     //   1050: ifnull +16 -> 1066
/*      */     //   1053: aload 11
/*      */     //   1055: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1058: aconst_null
/*      */     //   1059: astore 11
/*      */     //   1061: goto +5 -> 1066
/*      */     //   1064: astore 46
/*      */     //   1066: aload 20
/*      */     //   1068: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1071: aconst_null
/*      */     //   1072: areturn
/*      */     //   1073: aload 23
/*      */     //   1075: getstatic 2219	org/monazilla/v2c/V2CPlusHttpUtil:useHTML	Z
/*      */     //   1078: ifeq +14 -> 1092
/*      */     //   1081: iload 21
/*      */     //   1083: ifeq +9 -> 1092
/*      */     //   1086: ldc_w 1396
/*      */     //   1089: goto +6 -> 1095
/*      */     //   1092: ldc_w 1252
/*      */     //   1095: invokestatic 2575	org/monazilla/v2c/V2CPlusHttpUtil:logHTTPResponse	(Ljava/net/HttpURLConnection;Ljava/lang/String;)V
/*      */     //   1098: new 1508	org/monazilla/v2c/V2CHttpUtil$CAndC
/*      */     //   1101: dup
/*      */     //   1102: aload 23
/*      */     //   1104: invokespecial 2482	org/monazilla/v2c/V2CHttpUtil$CAndC:<init>	(Ljava/net/HttpURLConnection;)V
/*      */     //   1107: astore 15
/*      */     //   1109: aload 23
/*      */     //   1111: invokevirtual 2373	java/net/HttpURLConnection:getContentType	()Ljava/lang/String;
/*      */     //   1114: astore 28
/*      */     //   1116: aload 6
/*      */     //   1118: invokevirtual 2449	org/monazilla/v2c/V2CBBS:is2ch	()Z
/*      */     //   1121: ifeq +57 -> 1178
/*      */     //   1124: iload 22
/*      */     //   1126: sipush 401
/*      */     //   1129: if_icmpne +49 -> 1178
/*      */     //   1132: invokestatic 2436	org/monazilla/v2c/V2C2chBBS:resetMaruSessionIDForRead	()V
/*      */     //   1135: aload 15
/*      */     //   1137: astore 45
/*      */     //   1139: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1142: aload 14
/*      */     //   1144: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1147: aload 16
/*      */     //   1149: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1152: aload 11
/*      */     //   1154: ifnull +16 -> 1170
/*      */     //   1157: aload 11
/*      */     //   1159: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1162: aconst_null
/*      */     //   1163: astore 11
/*      */     //   1165: goto +5 -> 1170
/*      */     //   1168: astore 46
/*      */     //   1170: aload 20
/*      */     //   1172: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1175: aload 45
/*      */     //   1177: areturn
/*      */     //   1178: iload 22
/*      */     //   1180: sipush 300
/*      */     //   1183: if_icmpge +82 -> 1265
/*      */     //   1186: iload 19
/*      */     //   1188: ifeq +8 -> 1196
/*      */     //   1191: ldc_w 1411
/*      */     //   1194: astore 28
/*      */     //   1196: iload 18
/*      */     //   1198: ifeq +1082 -> 2280
/*      */     //   1201: aload 23
/*      */     //   1203: invokevirtual 2360	java/net/HttpURLConnection:getContentLength	()I
/*      */     //   1206: istore 29
/*      */     //   1208: iload 29
/*      */     //   1210: iconst_3
/*      */     //   1211: if_icmpne +1069 -> 2280
/*      */     //   1214: iload 22
/*      */     //   1216: sipush 200
/*      */     //   1219: if_icmpne +1061 -> 2280
/*      */     //   1222: aload 15
/*      */     //   1224: astore 45
/*      */     //   1226: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1229: aload 14
/*      */     //   1231: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1234: aload 16
/*      */     //   1236: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1239: aload 11
/*      */     //   1241: ifnull +16 -> 1257
/*      */     //   1244: aload 11
/*      */     //   1246: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1249: aconst_null
/*      */     //   1250: astore 11
/*      */     //   1252: goto +5 -> 1257
/*      */     //   1255: astore 46
/*      */     //   1257: aload 20
/*      */     //   1259: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1262: aload 45
/*      */     //   1264: areturn
/*      */     //   1265: iload 25
/*      */     //   1267: ifne +137 -> 1404
/*      */     //   1270: iload 9
/*      */     //   1272: ifne +132 -> 1404
/*      */     //   1275: iload 22
/*      */     //   1277: invokestatic 2549	org/monazilla/v2c/V2CPlusHttpUtil:isRedirect	(I)Z
/*      */     //   1280: ifeq +124 -> 1404
/*      */     //   1283: aload 12
/*      */     //   1285: ldc_w 1194
/*      */     //   1288: invokevirtual 2319	java/lang/String:contains	(Ljava/lang/CharSequence;)Z
/*      */     //   1291: ifeq +113 -> 1404
/*      */     //   1294: aload 23
/*      */     //   1296: ldc_w 1294
/*      */     //   1299: invokevirtual 2379	java/net/HttpURLConnection:getHeaderField	(Ljava/lang/String;)Ljava/lang/String;
/*      */     //   1302: astore 29
/*      */     //   1304: aload 29
/*      */     //   1306: invokestatic 2578	org/monazilla/v2c/V2CPlusHttpUtil:str2URL	(Ljava/lang/String;)Ljava/net/URL;
/*      */     //   1309: astore_0
/*      */     //   1310: iconst_1
/*      */     //   1311: putstatic 2218	org/monazilla/v2c/V2CPlusHttpUtil:useAPI	Z
/*      */     //   1314: iconst_0
/*      */     //   1315: putstatic 2219	org/monazilla/v2c/V2CPlusHttpUtil:useHTML	Z
/*      */     //   1318: iconst_0
/*      */     //   1319: putstatic 2220	org/monazilla/v2c/V2CPlusHttpUtil:useSC	Z
/*      */     //   1322: ldc_w 1427
/*      */     //   1325: new 1463	java/lang/StringBuilder
/*      */     //   1328: dup
/*      */     //   1329: ldc_w 1432
/*      */     //   1332: invokespecial 2345	java/lang/StringBuilder:<init>	(Ljava/lang/String;)V
/*      */     //   1335: aload 29
/*      */     //   1337: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   1340: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   1343: invokestatic 2504	org/monazilla/v2c/V2CLogger:logInfo	(Ljava/lang/String;Ljava/lang/String;)V
/*      */     //   1346: aload_0
/*      */     //   1347: iload_1
/*      */     //   1348: lload_2
/*      */     //   1349: aload 4
/*      */     //   1351: aload 5
/*      */     //   1353: aload 6
/*      */     //   1355: iload 7
/*      */     //   1357: iload 8
/*      */     //   1359: iconst_1
/*      */     //   1360: invokestatic 2600	org/monazilla/v2c/V2CPlusHttpUtil:updateDatFile	(Ljava/net/URL;IJLjava/lang/String;Lorg/monazilla/v2c/V2CBBSThreadRes;Lorg/monazilla/v2c/V2CBBS;ZZZ)Lorg/monazilla/v2c/V2CHttpUtil$CAndC;
/*      */     //   1363: astore 45
/*      */     //   1365: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1368: aload 14
/*      */     //   1370: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1373: aload 16
/*      */     //   1375: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1378: aload 11
/*      */     //   1380: ifnull +16 -> 1396
/*      */     //   1383: aload 11
/*      */     //   1385: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1388: aconst_null
/*      */     //   1389: astore 11
/*      */     //   1391: goto +5 -> 1396
/*      */     //   1394: astore 46
/*      */     //   1396: aload 20
/*      */     //   1398: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1401: aload 45
/*      */     //   1403: areturn
/*      */     //   1404: iload 22
/*      */     //   1406: sipush 302
/*      */     //   1409: if_icmpne +146 -> 1555
/*      */     //   1412: iload 9
/*      */     //   1414: ifne +141 -> 1555
/*      */     //   1417: aload 12
/*      */     //   1419: ldc_w 1339
/*      */     //   1422: invokevirtual 2319	java/lang/String:contains	(Ljava/lang/CharSequence;)Z
/*      */     //   1425: ifeq +63 -> 1488
/*      */     //   1428: aload 12
/*      */     //   1430: invokestatic 2578	org/monazilla/v2c/V2CPlusHttpUtil:str2URL	(Ljava/lang/String;)Ljava/net/URL;
/*      */     //   1433: astore_0
/*      */     //   1434: aload_0
/*      */     //   1435: iconst_0
/*      */     //   1436: lconst_0
/*      */     //   1437: aconst_null
/*      */     //   1438: aload 5
/*      */     //   1440: aload 6
/*      */     //   1442: iconst_0
/*      */     //   1443: iconst_1
/*      */     //   1444: invokestatic 2599	org/monazilla/v2c/V2CPlusHttpUtil:updateDatFile	(Ljava/net/URL;IJLjava/lang/String;Lorg/monazilla/v2c/V2CBBSThreadRes;Lorg/monazilla/v2c/V2CBBS;ZZ)Lorg/monazilla/v2c/V2CHttpUtil$CAndC;
/*      */     //   1447: astore 45
/*      */     //   1449: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1452: aload 14
/*      */     //   1454: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1457: aload 16
/*      */     //   1459: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1462: aload 11
/*      */     //   1464: ifnull +16 -> 1480
/*      */     //   1467: aload 11
/*      */     //   1469: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1472: aconst_null
/*      */     //   1473: astore 11
/*      */     //   1475: goto +5 -> 1480
/*      */     //   1478: astore 46
/*      */     //   1480: aload 20
/*      */     //   1482: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1485: aload 45
/*      */     //   1487: areturn
/*      */     //   1488: iload 19
/*      */     //   1490: ifeq +790 -> 2280
/*      */     //   1493: ldc_w 1426
/*      */     //   1496: astore 29
/*      */     //   1498: aload_0
/*      */     //   1499: aload 29
/*      */     //   1501: invokestatic 2505	org/monazilla/v2c/V2CLogger:logError	(Ljava/net/URL;Ljava/lang/String;)V
/*      */     //   1504: new 1508	org/monazilla/v2c/V2CHttpUtil$CAndC
/*      */     //   1507: dup
/*      */     //   1508: ldc_w 1152
/*      */     //   1511: invokespecial 2479	org/monazilla/v2c/V2CHttpUtil$CAndC:<init>	(Ljava/lang/String;)V
/*      */     //   1514: astore 45
/*      */     //   1516: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1519: aload 14
/*      */     //   1521: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1524: aload 16
/*      */     //   1526: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1529: aload 11
/*      */     //   1531: ifnull +16 -> 1547
/*      */     //   1534: aload 11
/*      */     //   1536: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1539: aconst_null
/*      */     //   1540: astore 11
/*      */     //   1542: goto +5 -> 1547
/*      */     //   1545: astore 46
/*      */     //   1547: aload 20
/*      */     //   1549: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1552: aload 45
/*      */     //   1554: areturn
/*      */     //   1555: iload 22
/*      */     //   1557: sipush 304
/*      */     //   1560: if_icmpne +46 -> 1606
/*      */     //   1563: aload 15
/*      */     //   1565: astore 45
/*      */     //   1567: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1570: aload 14
/*      */     //   1572: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1575: aload 16
/*      */     //   1577: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1580: aload 11
/*      */     //   1582: ifnull +16 -> 1598
/*      */     //   1585: aload 11
/*      */     //   1587: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1590: aconst_null
/*      */     //   1591: astore 11
/*      */     //   1593: goto +5 -> 1598
/*      */     //   1596: astore 46
/*      */     //   1598: aload 20
/*      */     //   1600: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1603: aload 45
/*      */     //   1605: areturn
/*      */     //   1606: iload 22
/*      */     //   1608: sipush 300
/*      */     //   1611: if_icmplt +58 -> 1669
/*      */     //   1614: iload 22
/*      */     //   1616: sipush 400
/*      */     //   1619: if_icmpge +50 -> 1669
/*      */     //   1622: aload_0
/*      */     //   1623: invokestatic 2566	org/monazilla/v2c/V2CPlusHttpUtil:logRemoteHostError	(Ljava/net/URL;)V
/*      */     //   1626: aload 15
/*      */     //   1628: astore 45
/*      */     //   1630: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1633: aload 14
/*      */     //   1635: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1638: aload 16
/*      */     //   1640: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1643: aload 11
/*      */     //   1645: ifnull +16 -> 1661
/*      */     //   1648: aload 11
/*      */     //   1650: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1653: aconst_null
/*      */     //   1654: astore 11
/*      */     //   1656: goto +5 -> 1661
/*      */     //   1659: astore 46
/*      */     //   1661: aload 20
/*      */     //   1663: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1666: aload 45
/*      */     //   1668: areturn
/*      */     //   1669: iload 22
/*      */     //   1671: sipush 416
/*      */     //   1674: if_icmpne +46 -> 1720
/*      */     //   1677: aload 15
/*      */     //   1679: astore 45
/*      */     //   1681: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1684: aload 14
/*      */     //   1686: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1689: aload 16
/*      */     //   1691: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1694: aload 11
/*      */     //   1696: ifnull +16 -> 1712
/*      */     //   1699: aload 11
/*      */     //   1701: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1704: aconst_null
/*      */     //   1705: astore 11
/*      */     //   1707: goto +5 -> 1712
/*      */     //   1710: astore 46
/*      */     //   1712: aload 20
/*      */     //   1714: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1717: aload 45
/*      */     //   1719: areturn
/*      */     //   1720: iload 22
/*      */     //   1722: sipush 400
/*      */     //   1725: if_icmplt +287 -> 2012
/*      */     //   1728: iload 22
/*      */     //   1730: sipush 500
/*      */     //   1733: if_icmpge +279 -> 2012
/*      */     //   1736: aload 23
/*      */     //   1738: ldc_w 1257
/*      */     //   1741: invokevirtual 2379	java/net/HttpURLConnection:getHeaderField	(Ljava/lang/String;)Ljava/lang/String;
/*      */     //   1744: astore 29
/*      */     //   1746: iload 18
/*      */     //   1748: ifeq +68 -> 1816
/*      */     //   1751: aload 29
/*      */     //   1753: ifnonnull +63 -> 1816
/*      */     //   1756: aload 12
/*      */     //   1758: invokestatic 2578	org/monazilla/v2c/V2CPlusHttpUtil:str2URL	(Ljava/lang/String;)Ljava/net/URL;
/*      */     //   1761: astore_0
/*      */     //   1762: aload_0
/*      */     //   1763: iconst_0
/*      */     //   1764: lconst_0
/*      */     //   1765: aconst_null
/*      */     //   1766: aload 5
/*      */     //   1768: aload 6
/*      */     //   1770: iconst_0
/*      */     //   1771: iconst_1
/*      */     //   1772: invokestatic 2599	org/monazilla/v2c/V2CPlusHttpUtil:updateDatFile	(Ljava/net/URL;IJLjava/lang/String;Lorg/monazilla/v2c/V2CBBSThreadRes;Lorg/monazilla/v2c/V2CBBS;ZZ)Lorg/monazilla/v2c/V2CHttpUtil$CAndC;
/*      */     //   1775: astore 45
/*      */     //   1777: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1780: aload 14
/*      */     //   1782: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1785: aload 16
/*      */     //   1787: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1790: aload 11
/*      */     //   1792: ifnull +16 -> 1808
/*      */     //   1795: aload 11
/*      */     //   1797: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1800: aconst_null
/*      */     //   1801: astore 11
/*      */     //   1803: goto +5 -> 1808
/*      */     //   1806: astore 46
/*      */     //   1808: aload 20
/*      */     //   1810: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1813: aload 45
/*      */     //   1815: areturn
/*      */     //   1816: iload 18
/*      */     //   1818: ifeq +54 -> 1872
/*      */     //   1821: new 1508	org/monazilla/v2c/V2CHttpUtil$CAndC
/*      */     //   1824: dup
/*      */     //   1825: ldc_w 1433
/*      */     //   1828: invokespecial 2479	org/monazilla/v2c/V2CHttpUtil$CAndC:<init>	(Ljava/lang/String;)V
/*      */     //   1831: astore 45
/*      */     //   1833: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1836: aload 14
/*      */     //   1838: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1841: aload 16
/*      */     //   1843: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1846: aload 11
/*      */     //   1848: ifnull +16 -> 1864
/*      */     //   1851: aload 11
/*      */     //   1853: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1856: aconst_null
/*      */     //   1857: astore 11
/*      */     //   1859: goto +5 -> 1864
/*      */     //   1862: astore 46
/*      */     //   1864: aload 20
/*      */     //   1866: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1869: aload 45
/*      */     //   1871: areturn
/*      */     //   1872: iload 19
/*      */     //   1874: ifeq +91 -> 1965
/*      */     //   1877: getstatic 2220	org/monazilla/v2c/V2CPlusHttpUtil:useSC	Z
/*      */     //   1880: ifeq +85 -> 1965
/*      */     //   1883: iload 25
/*      */     //   1885: ifne +80 -> 1965
/*      */     //   1888: aload 12
/*      */     //   1890: ldc_w 1178
/*      */     //   1893: ldc_w 1180
/*      */     //   1896: invokevirtual 2337	java/lang/String:replace	(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;
/*      */     //   1899: ldc_w 1181
/*      */     //   1902: ldc_w 1180
/*      */     //   1905: invokevirtual 2337	java/lang/String:replace	(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;
/*      */     //   1908: invokestatic 2578	org/monazilla/v2c/V2CPlusHttpUtil:str2URL	(Ljava/lang/String;)Ljava/net/URL;
/*      */     //   1911: astore_0
/*      */     //   1912: aload_0
/*      */     //   1913: iconst_0
/*      */     //   1914: lconst_0
/*      */     //   1915: aconst_null
/*      */     //   1916: aload 5
/*      */     //   1918: aload 6
/*      */     //   1920: iconst_0
/*      */     //   1921: invokestatic 2598	org/monazilla/v2c/V2CPlusHttpUtil:updateDatFile	(Ljava/net/URL;IJLjava/lang/String;Lorg/monazilla/v2c/V2CBBSThreadRes;Lorg/monazilla/v2c/V2CBBS;Z)Lorg/monazilla/v2c/V2CHttpUtil$CAndC;
/*      */     //   1924: astore 45
/*      */     //   1926: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1929: aload 14
/*      */     //   1931: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1934: aload 16
/*      */     //   1936: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1939: aload 11
/*      */     //   1941: ifnull +16 -> 1957
/*      */     //   1944: aload 11
/*      */     //   1946: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1949: aconst_null
/*      */     //   1950: astore 11
/*      */     //   1952: goto +5 -> 1957
/*      */     //   1955: astore 46
/*      */     //   1957: aload 20
/*      */     //   1959: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   1962: aload 45
/*      */     //   1964: areturn
/*      */     //   1965: aload_0
/*      */     //   1966: invokestatic 2566	org/monazilla/v2c/V2CPlusHttpUtil:logRemoteHostError	(Ljava/net/URL;)V
/*      */     //   1969: aload 15
/*      */     //   1971: astore 45
/*      */     //   1973: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   1976: aload 14
/*      */     //   1978: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   1981: aload 16
/*      */     //   1983: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   1986: aload 11
/*      */     //   1988: ifnull +16 -> 2004
/*      */     //   1991: aload 11
/*      */     //   1993: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   1996: aconst_null
/*      */     //   1997: astore 11
/*      */     //   1999: goto +5 -> 2004
/*      */     //   2002: astore 46
/*      */     //   2004: aload 20
/*      */     //   2006: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   2009: aload 45
/*      */     //   2011: areturn
/*      */     //   2012: iload 22
/*      */     //   2014: sipush 500
/*      */     //   2017: if_icmplt +263 -> 2280
/*      */     //   2020: iload 18
/*      */     //   2022: ifeq +63 -> 2085
/*      */     //   2025: aload 12
/*      */     //   2027: invokestatic 2578	org/monazilla/v2c/V2CPlusHttpUtil:str2URL	(Ljava/lang/String;)Ljava/net/URL;
/*      */     //   2030: astore_0
/*      */     //   2031: aload_0
/*      */     //   2032: iconst_0
/*      */     //   2033: lconst_0
/*      */     //   2034: aconst_null
/*      */     //   2035: aload 5
/*      */     //   2037: aload 6
/*      */     //   2039: iconst_0
/*      */     //   2040: iconst_1
/*      */     //   2041: invokestatic 2599	org/monazilla/v2c/V2CPlusHttpUtil:updateDatFile	(Ljava/net/URL;IJLjava/lang/String;Lorg/monazilla/v2c/V2CBBSThreadRes;Lorg/monazilla/v2c/V2CBBS;ZZ)Lorg/monazilla/v2c/V2CHttpUtil$CAndC;
/*      */     //   2044: astore 45
/*      */     //   2046: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   2049: aload 14
/*      */     //   2051: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   2054: aload 16
/*      */     //   2056: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   2059: aload 11
/*      */     //   2061: ifnull +16 -> 2077
/*      */     //   2064: aload 11
/*      */     //   2066: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   2069: aconst_null
/*      */     //   2070: astore 11
/*      */     //   2072: goto +5 -> 2077
/*      */     //   2075: astore 46
/*      */     //   2077: aload 20
/*      */     //   2079: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   2082: aload 45
/*      */     //   2084: areturn
/*      */     //   2085: iload 19
/*      */     //   2087: ifeq +91 -> 2178
/*      */     //   2090: getstatic 2220	org/monazilla/v2c/V2CPlusHttpUtil:useSC	Z
/*      */     //   2093: ifeq +85 -> 2178
/*      */     //   2096: iload 25
/*      */     //   2098: ifne +80 -> 2178
/*      */     //   2101: aload 12
/*      */     //   2103: ldc_w 1178
/*      */     //   2106: ldc_w 1180
/*      */     //   2109: invokevirtual 2337	java/lang/String:replace	(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;
/*      */     //   2112: ldc_w 1181
/*      */     //   2115: ldc_w 1180
/*      */     //   2118: invokevirtual 2337	java/lang/String:replace	(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;
/*      */     //   2121: invokestatic 2578	org/monazilla/v2c/V2CPlusHttpUtil:str2URL	(Ljava/lang/String;)Ljava/net/URL;
/*      */     //   2124: astore_0
/*      */     //   2125: aload_0
/*      */     //   2126: iconst_0
/*      */     //   2127: lconst_0
/*      */     //   2128: aconst_null
/*      */     //   2129: aload 5
/*      */     //   2131: aload 6
/*      */     //   2133: iconst_0
/*      */     //   2134: invokestatic 2598	org/monazilla/v2c/V2CPlusHttpUtil:updateDatFile	(Ljava/net/URL;IJLjava/lang/String;Lorg/monazilla/v2c/V2CBBSThreadRes;Lorg/monazilla/v2c/V2CBBS;Z)Lorg/monazilla/v2c/V2CHttpUtil$CAndC;
/*      */     //   2137: astore 45
/*      */     //   2139: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   2142: aload 14
/*      */     //   2144: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   2147: aload 16
/*      */     //   2149: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   2152: aload 11
/*      */     //   2154: ifnull +16 -> 2170
/*      */     //   2157: aload 11
/*      */     //   2159: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   2162: aconst_null
/*      */     //   2163: astore 11
/*      */     //   2165: goto +5 -> 2170
/*      */     //   2168: astore 46
/*      */     //   2170: aload 20
/*      */     //   2172: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   2175: aload 45
/*      */     //   2177: areturn
/*      */     //   2178: iload 25
/*      */     //   2180: ifeq +53 -> 2233
/*      */     //   2183: new 1463	java/lang/StringBuilder
/*      */     //   2186: dup
/*      */     //   2187: ldc_w 1431
/*      */     //   2190: invokespecial 2345	java/lang/StringBuilder:<init>	(Ljava/lang/String;)V
/*      */     //   2193: aload 26
/*      */     //   2195: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   2198: ldc_w 1171
/*      */     //   2201: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   2204: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   2207: astore 29
/*      */     //   2209: aload_0
/*      */     //   2210: aload 29
/*      */     //   2212: aload 27
/*      */     //   2214: invokestatic 2508	org/monazilla/v2c/V2CLogger:logError	(Ljava/net/URL;Ljava/lang/String;Ljava/lang/Exception;)V
/*      */     //   2217: aload 15
/*      */     //   2219: aload 29
/*      */     //   2221: putfield 2203	org/monazilla/v2c/V2CHttpUtil$CAndC:sErrorMessage	Ljava/lang/String;
/*      */     //   2224: aload 15
/*      */     //   2226: iconst_1
/*      */     //   2227: putfield 2201	org/monazilla/v2c/V2CHttpUtil$CAndC:bError	Z
/*      */     //   2230: goto +7 -> 2237
/*      */     //   2233: aload_0
/*      */     //   2234: invokestatic 2566	org/monazilla/v2c/V2CPlusHttpUtil:logRemoteHostError	(Ljava/net/URL;)V
/*      */     //   2237: aload 15
/*      */     //   2239: astore 45
/*      */     //   2241: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   2244: aload 14
/*      */     //   2246: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   2249: aload 16
/*      */     //   2251: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   2254: aload 11
/*      */     //   2256: ifnull +16 -> 2272
/*      */     //   2259: aload 11
/*      */     //   2261: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   2264: aconst_null
/*      */     //   2265: astore 11
/*      */     //   2267: goto +5 -> 2272
/*      */     //   2270: astore 46
/*      */     //   2272: aload 20
/*      */     //   2274: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   2277: aload 45
/*      */     //   2279: areturn
/*      */     //   2280: iload 24
/*      */     //   2282: ifeq +15 -> 2297
/*      */     //   2285: iload 22
/*      */     //   2287: sipush 200
/*      */     //   2290: if_icmpne +7 -> 2297
/*      */     //   2293: iconst_1
/*      */     //   2294: goto +4 -> 2298
/*      */     //   2297: iconst_0
/*      */     //   2298: istore 29
/*      */     //   2300: iload 29
/*      */     //   2302: ifeq +45 -> 2347
/*      */     //   2305: aload 23
/*      */     //   2307: invokevirtual 2360	java/net/HttpURLConnection:getContentLength	()I
/*      */     //   2310: istore 31
/*      */     //   2312: aload 23
/*      */     //   2314: ldc_w 1241
/*      */     //   2317: invokevirtual 2379	java/net/HttpURLConnection:getHeaderField	(Ljava/lang/String;)Ljava/lang/String;
/*      */     //   2320: astore 32
/*      */     //   2322: iload 31
/*      */     //   2324: iload_1
/*      */     //   2325: if_icmple +19 -> 2344
/*      */     //   2328: aload 32
/*      */     //   2330: ifnull +14 -> 2344
/*      */     //   2333: aload 32
/*      */     //   2335: ldc_w 1373
/*      */     //   2338: invokevirtual 2320	java/lang/String:equals	(Ljava/lang/Object;)Z
/*      */     //   2341: ifne +6 -> 2347
/*      */     //   2344: iconst_0
/*      */     //   2345: istore 29
/*      */     //   2347: iload 29
/*      */     //   2349: ifeq +19 -> 2368
/*      */     //   2352: getstatic 2215	org/monazilla/v2c/V2CPlusHttpUtil:bPolipoWarned	Z
/*      */     //   2355: ifne +13 -> 2368
/*      */     //   2358: getstatic 2218	org/monazilla/v2c/V2CPlusHttpUtil:useAPI	Z
/*      */     //   2361: ifne +7 -> 2368
/*      */     //   2364: iconst_1
/*      */     //   2365: putstatic 2214	org/monazilla/v2c/V2CPlusHttpUtil:bPolipo	Z
/*      */     //   2368: aload 23
/*      */     //   2370: invokevirtual 2372	java/net/HttpURLConnection:getContentEncoding	()Ljava/lang/String;
/*      */     //   2373: astore 31
/*      */     //   2375: iload 7
/*      */     //   2377: ifne +23 -> 2400
/*      */     //   2380: aload 31
/*      */     //   2382: ifnull +14 -> 2396
/*      */     //   2385: aload 31
/*      */     //   2387: ldc_w 1350
/*      */     //   2390: invokevirtual 2320	java/lang/String:equals	(Ljava/lang/Object;)Z
/*      */     //   2393: ifne +7 -> 2400
/*      */     //   2396: iconst_0
/*      */     //   2397: goto +4 -> 2401
/*      */     //   2400: iconst_1
/*      */     //   2401: istore 30
/*      */     //   2403: aload 28
/*      */     //   2405: ifnull +17 -> 2422
/*      */     //   2408: aload 28
/*      */     //   2410: aload 6
/*      */     //   2412: invokevirtual 2453	org/monazilla/v2c/V2CBBS:getDatContentType	()Ljava/lang/String;
/*      */     //   2415: iconst_1
/*      */     //   2416: invokestatic 2523	org/monazilla/v2c/V2CMiscUtil:contentTypeStartsWith	(Ljava/lang/String;Ljava/lang/String;Z)Z
/*      */     //   2419: ifne +246 -> 2665
/*      */     //   2422: iconst_0
/*      */     //   2423: istore 32
/*      */     //   2425: aload 28
/*      */     //   2427: ifnull +130 -> 2557
/*      */     //   2430: aload_0
/*      */     //   2431: invokevirtual 2390	java/net/URL:toString	()Ljava/lang/String;
/*      */     //   2434: astore 33
/*      */     //   2436: iload 30
/*      */     //   2438: ifeq +52 -> 2490
/*      */     //   2441: aload 28
/*      */     //   2443: ldc_w 1337
/*      */     //   2446: invokevirtual 2331	java/lang/String:equalsIgnoreCase	(Ljava/lang/String;)Z
/*      */     //   2449: ifne +14 -> 2463
/*      */     //   2452: aload 28
/*      */     //   2454: ldc_w 1410
/*      */     //   2457: invokevirtual 2331	java/lang/String:equalsIgnoreCase	(Ljava/lang/String;)Z
/*      */     //   2460: ifeq +30 -> 2490
/*      */     //   2463: aload 6
/*      */     //   2465: invokevirtual 2449	org/monazilla/v2c/V2CBBS:is2ch	()Z
/*      */     //   2468: ifeq +22 -> 2490
/*      */     //   2471: aload_0
/*      */     //   2472: invokevirtual 2390	java/net/URL:toString	()Ljava/lang/String;
/*      */     //   2475: ldc_w 1184
/*      */     //   2478: invokevirtual 2330	java/lang/String:endsWith	(Ljava/lang/String;)Z
/*      */     //   2481: ifeq +9 -> 2490
/*      */     //   2484: iconst_1
/*      */     //   2485: istore 32
/*      */     //   2487: goto +87 -> 2574
/*      */     //   2490: aload 28
/*      */     //   2492: ldc_w 1336
/*      */     //   2495: invokevirtual 2331	java/lang/String:equalsIgnoreCase	(Ljava/lang/String;)Z
/*      */     //   2498: ifeq +35 -> 2533
/*      */     //   2501: aload 33
/*      */     //   2503: ldc_w 1356
/*      */     //   2506: invokevirtual 2333	java/lang/String:startsWith	(Ljava/lang/String;)Z
/*      */     //   2509: ifne +18 -> 2527
/*      */     //   2512: aload 33
/*      */     //   2514: ldc_w 1359
/*      */     //   2517: invokevirtual 2333	java/lang/String:startsWith	(Ljava/lang/String;)Z
/*      */     //   2520: ifne +7 -> 2527
/*      */     //   2523: iconst_0
/*      */     //   2524: goto +4 -> 2528
/*      */     //   2527: iconst_1
/*      */     //   2528: istore 32
/*      */     //   2530: goto +44 -> 2574
/*      */     //   2533: aload 28
/*      */     //   2535: ldc_w 1343
/*      */     //   2538: invokevirtual 2331	java/lang/String:equalsIgnoreCase	(Ljava/lang/String;)Z
/*      */     //   2541: ifeq +33 -> 2574
/*      */     //   2544: aload 33
/*      */     //   2546: ldc_w 1357
/*      */     //   2549: invokevirtual 2333	java/lang/String:startsWith	(Ljava/lang/String;)Z
/*      */     //   2552: istore 32
/*      */     //   2554: goto +20 -> 2574
/*      */     //   2557: aload 6
/*      */     //   2559: invokevirtual 2449	org/monazilla/v2c/V2CBBS:is2ch	()Z
/*      */     //   2562: ifeq +9 -> 2571
/*      */     //   2565: iconst_1
/*      */     //   2566: istore 32
/*      */     //   2568: goto +6 -> 2574
/*      */     //   2571: iconst_1
/*      */     //   2572: istore 32
/*      */     //   2574: iload 32
/*      */     //   2576: ifne +89 -> 2665
/*      */     //   2579: new 1508	org/monazilla/v2c/V2CHttpUtil$CAndC
/*      */     //   2582: dup
/*      */     //   2583: new 1463	java/lang/StringBuilder
/*      */     //   2586: dup
/*      */     //   2587: ldc_w 1243
/*      */     //   2590: invokespecial 2345	java/lang/StringBuilder:<init>	(Ljava/lang/String;)V
/*      */     //   2593: aload 6
/*      */     //   2595: invokevirtual 2453	org/monazilla/v2c/V2CBBS:getDatContentType	()Ljava/lang/String;
/*      */     //   2598: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   2601: ldc_w 1424
/*      */     //   2604: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   2607: aload 28
/*      */     //   2609: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   2612: ldc_w 1434
/*      */     //   2615: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   2618: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   2621: invokespecial 2479	org/monazilla/v2c/V2CHttpUtil$CAndC:<init>	(Ljava/lang/String;)V
/*      */     //   2624: astore 45
/*      */     //   2626: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   2629: aload 14
/*      */     //   2631: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   2634: aload 16
/*      */     //   2636: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   2639: aload 11
/*      */     //   2641: ifnull +16 -> 2657
/*      */     //   2644: aload 11
/*      */     //   2646: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   2649: aconst_null
/*      */     //   2650: astore 11
/*      */     //   2652: goto +5 -> 2657
/*      */     //   2655: astore 46
/*      */     //   2657: aload 20
/*      */     //   2659: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   2662: aload 45
/*      */     //   2664: areturn
/*      */     //   2665: aload 23
/*      */     //   2667: invokevirtual 2370	java/net/HttpURLConnection:getInputStream	()Ljava/io/InputStream;
/*      */     //   2670: astore 16
/*      */     //   2672: aload 23
/*      */     //   2674: invokevirtual 2360	java/net/HttpURLConnection:getContentLength	()I
/*      */     //   2677: istore 34
/*      */     //   2679: iload 19
/*      */     //   2681: ifeq +592 -> 3273
/*      */     //   2684: iload 30
/*      */     //   2686: ifeq +23 -> 2709
/*      */     //   2689: new 1488	java/util/zip/GZIPInputStream
/*      */     //   2692: dup
/*      */     //   2693: new 1523	org/monazilla/v2c/V2CPlusHttpUtil$GZIPFilterInputStream
/*      */     //   2696: dup
/*      */     //   2697: aload 16
/*      */     //   2699: aload 5
/*      */     //   2701: invokespecial 2608	org/monazilla/v2c/V2CPlusHttpUtil$GZIPFilterInputStream:<init>	(Ljava/io/InputStream;Lorg/monazilla/v2c/V2CThreadRes;)V
/*      */     //   2704: invokespecial 2414	java/util/zip/GZIPInputStream:<init>	(Ljava/io/InputStream;)V
/*      */     //   2707: astore 16
/*      */     //   2709: aload 16
/*      */     //   2711: invokevirtual 2283	java/io/InputStream:available	()I
/*      */     //   2714: sipush 2048
/*      */     //   2717: if_icmpge +9 -> 2726
/*      */     //   2720: sipush 2048
/*      */     //   2723: goto +8 -> 2731
/*      */     //   2726: aload 16
/*      */     //   2728: invokevirtual 2283	java/io/InputStream:available	()I
/*      */     //   2731: newarray <illegal type>
/*      */     //   2733: astore 35
/*      */     //   2735: iconst_0
/*      */     //   2736: istore 36
/*      */     //   2738: new 1444	java/io/ByteArrayOutputStream
/*      */     //   2741: dup
/*      */     //   2742: invokespecial 2274	java/io/ByteArrayOutputStream:<init>	()V
/*      */     //   2745: astore 20
/*      */     //   2747: iconst_0
/*      */     //   2748: istore 37
/*      */     //   2750: aconst_null
/*      */     //   2751: astore 38
/*      */     //   2753: goto +13 -> 2766
/*      */     //   2756: aload 20
/*      */     //   2758: aload 35
/*      */     //   2760: iconst_0
/*      */     //   2761: iload 36
/*      */     //   2763: invokevirtual 2280	java/io/ByteArrayOutputStream:write	([BII)V
/*      */     //   2766: aload 16
/*      */     //   2768: aload 35
/*      */     //   2770: invokevirtual 2285	java/io/InputStream:read	([B)I
/*      */     //   2773: dup
/*      */     //   2774: istore 36
/*      */     //   2776: ifgt -20 -> 2756
/*      */     //   2779: goto +81 -> 2860
/*      */     //   2782: astore 39
/*      */     //   2784: iconst_1
/*      */     //   2785: istore 37
/*      */     //   2787: aload 39
/*      */     //   2789: astore 38
/*      */     //   2791: aload 39
/*      */     //   2793: invokestatic 2524	org/monazilla/v2c/V2CMiscUtil:getMessage	(Ljava/lang/Throwable;)Ljava/lang/String;
/*      */     //   2796: astore 40
/*      */     //   2798: aload_0
/*      */     //   2799: aload 40
/*      */     //   2801: aload 39
/*      */     //   2803: invokestatic 2508	org/monazilla/v2c/V2CLogger:logError	(Ljava/net/URL;Ljava/lang/String;Ljava/lang/Exception;)V
/*      */     //   2806: getstatic 2197	java/lang/System:out	Ljava/io/PrintStream;
/*      */     //   2809: new 1463	java/lang/StringBuilder
/*      */     //   2812: dup
/*      */     //   2813: invokespecial 2339	java/lang/StringBuilder:<init>	()V
/*      */     //   2816: aload_0
/*      */     //   2817: invokevirtual 2350	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*      */     //   2820: ldc_w 1149
/*      */     //   2823: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   2826: aload 40
/*      */     //   2828: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   2831: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   2834: invokevirtual 2297	java/io/PrintStream:println	(Ljava/lang/String;)V
/*      */     //   2837: aload 39
/*      */     //   2839: invokevirtual 2282	java/io/IOException:printStackTrace	()V
/*      */     //   2842: aload 16
/*      */     //   2844: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   2847: goto +18 -> 2865
/*      */     //   2850: astore 41
/*      */     //   2852: aload 16
/*      */     //   2854: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   2857: aload 41
/*      */     //   2859: athrow
/*      */     //   2860: aload 16
/*      */     //   2862: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   2865: aload 20
/*      */     //   2867: ldc_w 1327
/*      */     //   2870: invokevirtual 2281	java/io/ByteArrayOutputStream:toString	(Ljava/lang/String;)Ljava/lang/String;
/*      */     //   2873: astore 39
/*      */     //   2875: iload 37
/*      */     //   2877: ifeq +16 -> 2893
/*      */     //   2880: aload 39
/*      */     //   2882: invokevirtual 2313	java/lang/String:length	()I
/*      */     //   2885: bipush 30
/*      */     //   2887: if_icmpge +6 -> 2893
/*      */     //   2890: aload 38
/*      */     //   2892: athrow
/*      */     //   2893: aload 5
/*      */     //   2895: getfield 2198	org/monazilla/v2c/V2CBBSThreadRes:nRes	I
/*      */     //   2898: istore 40
/*      */     //   2900: aload 39
/*      */     //   2902: aload_0
/*      */     //   2903: aload 5
/*      */     //   2905: getfield 2200	org/monazilla/v2c/V2CBBSThreadRes:vtiThreadItem	Lorg/monazilla/v2c/V2CThreadItem;
/*      */     //   2908: getfield 2265	org/monazilla/v2c/V2CThreadItem:vBoardItem	Lorg/monazilla/v2c/V2CBoardItem;
/*      */     //   2911: iload 40
/*      */     //   2913: iload 37
/*      */     //   2915: invokestatic 2593	org/monazilla/v2c/V2CPlusHttpUtil:html2Dat	(Ljava/lang/String;Ljava/net/URL;Lorg/monazilla/v2c/V2CBoardItem;IZ)Ljava/lang/String;
/*      */     //   2918: astore 41
/*      */     //   2920: aload 41
/*      */     //   2922: invokevirtual 2313	java/lang/String:length	()I
/*      */     //   2925: ifne +26 -> 2951
/*      */     //   2928: iconst_0
/*      */     //   2929: istore 40
/*      */     //   2931: aload 39
/*      */     //   2933: aload_0
/*      */     //   2934: aload 5
/*      */     //   2936: getfield 2200	org/monazilla/v2c/V2CBBSThreadRes:vtiThreadItem	Lorg/monazilla/v2c/V2CThreadItem;
/*      */     //   2939: getfield 2265	org/monazilla/v2c/V2CThreadItem:vBoardItem	Lorg/monazilla/v2c/V2CBoardItem;
/*      */     //   2942: iload 40
/*      */     //   2944: iload 37
/*      */     //   2946: invokestatic 2593	org/monazilla/v2c/V2CPlusHttpUtil:html2Dat	(Ljava/lang/String;Ljava/net/URL;Lorg/monazilla/v2c/V2CBoardItem;IZ)Ljava/lang/String;
/*      */     //   2949: astore 41
/*      */     //   2951: aload 41
/*      */     //   2953: invokevirtual 2313	java/lang/String:length	()I
/*      */     //   2956: ifne +12 -> 2968
/*      */     //   2959: aload_0
/*      */     //   2960: aload 39
/*      */     //   2962: invokestatic 2576	org/monazilla/v2c/V2CPlusHttpUtil:outHTMLErrorLog	(Ljava/net/URL;Ljava/lang/String;)V
/*      */     //   2965: goto +14 -> 2979
/*      */     //   2968: aload 15
/*      */     //   2970: ifnull +9 -> 2979
/*      */     //   2973: aload 15
/*      */     //   2975: iconst_1
/*      */     //   2976: putfield 2202	org/monazilla/v2c/V2CHttpUtil$CAndC:bGetReadCgi	Z
/*      */     //   2979: aload 41
/*      */     //   2981: invokevirtual 2313	java/lang/String:length	()I
/*      */     //   2984: ifne +178 -> 3162
/*      */     //   2987: getstatic 2220	org/monazilla/v2c/V2CPlusHttpUtil:useSC	Z
/*      */     //   2990: ifeq +172 -> 3162
/*      */     //   2993: getstatic 2219	org/monazilla/v2c/V2CPlusHttpUtil:useHTML	Z
/*      */     //   2996: ifeq +166 -> 3162
/*      */     //   2999: iload 9
/*      */     //   3001: ifne +161 -> 3162
/*      */     //   3004: aload 12
/*      */     //   3006: ldc_w 1178
/*      */     //   3009: invokevirtual 2319	java/lang/String:contains	(Ljava/lang/CharSequence;)Z
/*      */     //   3012: ifne +14 -> 3026
/*      */     //   3015: aload 12
/*      */     //   3017: ldc_w 1181
/*      */     //   3020: invokevirtual 2319	java/lang/String:contains	(Ljava/lang/CharSequence;)Z
/*      */     //   3023: ifeq +139 -> 3162
/*      */     //   3026: aload 39
/*      */     //   3028: invokestatic 2560	org/monazilla/v2c/V2CPlusHttpUtil:isNotFoundDat	(Ljava/lang/String;)Z
/*      */     //   3031: ifeq +131 -> 3162
/*      */     //   3034: aload_0
/*      */     //   3035: ldc_w 1196
/*      */     //   3038: invokestatic 2505	org/monazilla/v2c/V2CLogger:logError	(Ljava/net/URL;Ljava/lang/String;)V
/*      */     //   3041: invokestatic 2531	org/monazilla/v2c/V2CPlus2chProperty:isChangeReadCgiStatusColor	()Z
/*      */     //   3044: ifeq +12 -> 3056
/*      */     //   3047: invokestatic 2514	org/monazilla/v2c/V2CMessageField:getInstance	()Lorg/monazilla/v2c/V2CMessageField;
/*      */     //   3050: getstatic 2195	java/awt/Color:CYAN	Ljava/awt/Color;
/*      */     //   3053: invokevirtual 2513	org/monazilla/v2c/V2CMessageField:setBackground	(Ljava/awt/Color;)V
/*      */     //   3056: ldc_w 1400
/*      */     //   3059: invokestatic 2511	org/monazilla/v2c/V2CMain:setMessage	(Ljava/lang/String;)V
/*      */     //   3062: aload 12
/*      */     //   3064: ldc_w 1178
/*      */     //   3067: ldc_w 1180
/*      */     //   3070: invokevirtual 2337	java/lang/String:replace	(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;
/*      */     //   3073: ldc_w 1181
/*      */     //   3076: ldc_w 1180
/*      */     //   3079: invokevirtual 2337	java/lang/String:replace	(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;
/*      */     //   3082: invokestatic 2578	org/monazilla/v2c/V2CPlusHttpUtil:str2URL	(Ljava/lang/String;)Ljava/net/URL;
/*      */     //   3085: astore_0
/*      */     //   3086: aload_0
/*      */     //   3087: iload_1
/*      */     //   3088: lload_2
/*      */     //   3089: aload 4
/*      */     //   3091: aload 5
/*      */     //   3093: aload 6
/*      */     //   3095: iload 7
/*      */     //   3097: iload 8
/*      */     //   3099: invokestatic 2599	org/monazilla/v2c/V2CPlusHttpUtil:updateDatFile	(Ljava/net/URL;IJLjava/lang/String;Lorg/monazilla/v2c/V2CBBSThreadRes;Lorg/monazilla/v2c/V2CBBS;ZZ)Lorg/monazilla/v2c/V2CHttpUtil$CAndC;
/*      */     //   3102: astore 43
/*      */     //   3104: invokestatic 2514	org/monazilla/v2c/V2CMessageField:getInstance	()Lorg/monazilla/v2c/V2CMessageField;
/*      */     //   3107: aconst_null
/*      */     //   3108: invokevirtual 2513	org/monazilla/v2c/V2CMessageField:setBackground	(Ljava/awt/Color;)V
/*      */     //   3111: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   3114: aload 14
/*      */     //   3116: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   3119: aload 16
/*      */     //   3121: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   3124: aload 11
/*      */     //   3126: ifnull +16 -> 3142
/*      */     //   3129: aload 11
/*      */     //   3131: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   3134: aconst_null
/*      */     //   3135: astore 11
/*      */     //   3137: goto +5 -> 3142
/*      */     //   3140: astore 46
/*      */     //   3142: aload 20
/*      */     //   3144: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   3147: aload 43
/*      */     //   3149: areturn
/*      */     //   3150: astore 42
/*      */     //   3152: invokestatic 2514	org/monazilla/v2c/V2CMessageField:getInstance	()Lorg/monazilla/v2c/V2CMessageField;
/*      */     //   3155: aconst_null
/*      */     //   3156: invokevirtual 2513	org/monazilla/v2c/V2CMessageField:setBackground	(Ljava/awt/Color;)V
/*      */     //   3159: aload 42
/*      */     //   3161: athrow
/*      */     //   3162: aload 41
/*      */     //   3164: ldc_w 1327
/*      */     //   3167: invokevirtual 2334	java/lang/String:getBytes	(Ljava/lang/String;)[B
/*      */     //   3170: astore 42
/*      */     //   3172: iload 40
/*      */     //   3174: ifne +27 -> 3201
/*      */     //   3177: iload_1
/*      */     //   3178: ifle +23 -> 3201
/*      */     //   3181: new 1443	java/io/ByteArrayInputStream
/*      */     //   3184: dup
/*      */     //   3185: aload 42
/*      */     //   3187: iload_1
/*      */     //   3188: aload 42
/*      */     //   3190: arraylength
/*      */     //   3191: iload_1
/*      */     //   3192: isub
/*      */     //   3193: invokespecial 2272	java/io/ByteArrayInputStream:<init>	([BII)V
/*      */     //   3196: astore 16
/*      */     //   3198: goto +173 -> 3371
/*      */     //   3201: iload 40
/*      */     //   3203: ifle +51 -> 3254
/*      */     //   3206: aload 20
/*      */     //   3208: invokevirtual 2276	java/io/ByteArrayOutputStream:reset	()V
/*      */     //   3211: aload 20
/*      */     //   3213: bipush 10
/*      */     //   3215: invokevirtual 2278	java/io/ByteArrayOutputStream:write	(I)V
/*      */     //   3218: aload 20
/*      */     //   3220: aload 42
/*      */     //   3222: invokevirtual 2279	java/io/ByteArrayOutputStream:write	([B)V
/*      */     //   3225: new 1443	java/io/ByteArrayInputStream
/*      */     //   3228: dup
/*      */     //   3229: aload 20
/*      */     //   3231: invokevirtual 2277	java/io/ByteArrayOutputStream:toByteArray	()[B
/*      */     //   3234: invokespecial 2271	java/io/ByteArrayInputStream:<init>	([B)V
/*      */     //   3237: astore 16
/*      */     //   3239: aload 20
/*      */     //   3241: invokevirtual 2273	java/io/ByteArrayOutputStream:size	()I
/*      */     //   3244: istore 34
/*      */     //   3246: aload 20
/*      */     //   3248: invokevirtual 2275	java/io/ByteArrayOutputStream:close	()V
/*      */     //   3251: goto +120 -> 3371
/*      */     //   3254: new 1443	java/io/ByteArrayInputStream
/*      */     //   3257: dup
/*      */     //   3258: aload 42
/*      */     //   3260: invokespecial 2271	java/io/ByteArrayInputStream:<init>	([B)V
/*      */     //   3263: astore 16
/*      */     //   3265: aload 42
/*      */     //   3267: arraylength
/*      */     //   3268: istore 34
/*      */     //   3270: goto +101 -> 3371
/*      */     //   3273: iload 30
/*      */     //   3275: ifeq +96 -> 3371
/*      */     //   3278: new 1488	java/util/zip/GZIPInputStream
/*      */     //   3281: dup
/*      */     //   3282: new 1523	org/monazilla/v2c/V2CPlusHttpUtil$GZIPFilterInputStream
/*      */     //   3285: dup
/*      */     //   3286: aload 16
/*      */     //   3288: aload 5
/*      */     //   3290: invokespecial 2608	org/monazilla/v2c/V2CPlusHttpUtil$GZIPFilterInputStream:<init>	(Ljava/io/InputStream;Lorg/monazilla/v2c/V2CThreadRes;)V
/*      */     //   3293: invokespecial 2414	java/util/zip/GZIPInputStream:<init>	(Ljava/io/InputStream;)V
/*      */     //   3296: astore 16
/*      */     //   3298: goto +73 -> 3371
/*      */     //   3301: astore 35
/*      */     //   3303: iload 22
/*      */     //   3305: sipush 302
/*      */     //   3308: if_icmpne +52 -> 3360
/*      */     //   3311: invokestatic 2628	org/monazilla/v2c/V2CProxySetting:isO2onUsed	()Z
/*      */     //   3314: ifeq +46 -> 3360
/*      */     //   3317: aload 15
/*      */     //   3319: astore 45
/*      */     //   3321: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   3324: aload 14
/*      */     //   3326: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   3329: aload 16
/*      */     //   3331: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   3334: aload 11
/*      */     //   3336: ifnull +16 -> 3352
/*      */     //   3339: aload 11
/*      */     //   3341: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   3344: aconst_null
/*      */     //   3345: astore 11
/*      */     //   3347: goto +5 -> 3352
/*      */     //   3350: astore 46
/*      */     //   3352: aload 20
/*      */     //   3354: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   3357: aload 45
/*      */     //   3359: areturn
/*      */     //   3360: iload 22
/*      */     //   3362: sipush 200
/*      */     //   3365: if_icmpeq +6 -> 3371
/*      */     //   3368: aload 35
/*      */     //   3370: athrow
/*      */     //   3371: aload 5
/*      */     //   3373: iload 29
/*      */     //   3375: ifeq +14 -> 3389
/*      */     //   3378: iload 34
/*      */     //   3380: iload_1
/*      */     //   3381: isub
/*      */     //   3382: iconst_1
/*      */     //   3383: invokestatic 2308	java/lang/Math:max	(II)I
/*      */     //   3386: goto +5 -> 3391
/*      */     //   3389: iload 34
/*      */     //   3391: invokevirtual 2455	org/monazilla/v2c/V2CBBSThreadRes:setContentLength	(I)V
/*      */     //   3394: aload 5
/*      */     //   3396: aload 23
/*      */     //   3398: invokevirtual 2457	org/monazilla/v2c/V2CBBSThreadRes:setHeaderFields	(Ljava/net/HttpURLConnection;)V
/*      */     //   3401: iload 29
/*      */     //   3403: ifeq +7 -> 3410
/*      */     //   3406: iload_1
/*      */     //   3407: goto +4 -> 3411
/*      */     //   3410: iconst_0
/*      */     //   3411: istore 32
/*      */     //   3413: getstatic 2210	org/monazilla/v2c/V2CPlusHttpUtil:nBufLen	I
/*      */     //   3416: newarray <illegal type>
/*      */     //   3418: astore 33
/*      */     //   3420: aload 14
/*      */     //   3422: invokevirtual 2615	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:check	()V
/*      */     //   3425: aload 16
/*      */     //   3427: aload 33
/*      */     //   3429: invokevirtual 2285	java/io/InputStream:read	([B)I
/*      */     //   3432: istore 35
/*      */     //   3434: aload 13
/*      */     //   3436: invokevirtual 2355	java/lang/Thread:isInterrupted	()Z
/*      */     //   3439: ifeq +45 -> 3484
/*      */     //   3442: aload_0
/*      */     //   3443: invokestatic 2564	org/monazilla/v2c/V2CPlusHttpUtil:logInterrupt	(Ljava/net/URL;)V
/*      */     //   3446: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   3449: aload 14
/*      */     //   3451: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   3454: aload 16
/*      */     //   3456: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   3459: aload 11
/*      */     //   3461: ifnull +16 -> 3477
/*      */     //   3464: aload 11
/*      */     //   3466: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   3469: aconst_null
/*      */     //   3470: astore 11
/*      */     //   3472: goto +5 -> 3477
/*      */     //   3475: astore 46
/*      */     //   3477: aload 20
/*      */     //   3479: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   3482: aconst_null
/*      */     //   3483: areturn
/*      */     //   3484: iload 35
/*      */     //   3486: ifge +23 -> 3509
/*      */     //   3489: aload 5
/*      */     //   3491: getfield 2199	org/monazilla/v2c/V2CBBSThreadRes:bCheckFirstLine	Z
/*      */     //   3494: ifeq +97 -> 3591
/*      */     //   3497: aload 5
/*      */     //   3499: aload 33
/*      */     //   3501: iconst_0
/*      */     //   3502: invokevirtual 2456	org/monazilla/v2c/V2CBBSThreadRes:appendToDatFile	([BI)Z
/*      */     //   3505: pop
/*      */     //   3506: goto +85 -> 3591
/*      */     //   3509: iload 35
/*      */     //   3511: ifle -91 -> 3420
/*      */     //   3514: iload 32
/*      */     //   3516: ifle +45 -> 3561
/*      */     //   3519: iload 32
/*      */     //   3521: iload 35
/*      */     //   3523: if_icmplt +13 -> 3536
/*      */     //   3526: iload 32
/*      */     //   3528: iload 35
/*      */     //   3530: isub
/*      */     //   3531: istore 32
/*      */     //   3533: goto -113 -> 3420
/*      */     //   3536: iload 35
/*      */     //   3538: iload 32
/*      */     //   3540: isub
/*      */     //   3541: istore 35
/*      */     //   3543: aload 33
/*      */     //   3545: iload 32
/*      */     //   3547: aload 33
/*      */     //   3549: iconst_0
/*      */     //   3550: iload 35
/*      */     //   3552: invokestatic 2353	java/lang/System:arraycopy	(Ljava/lang/Object;ILjava/lang/Object;II)V
/*      */     //   3555: iconst_0
/*      */     //   3556: istore 32
/*      */     //   3558: goto -138 -> 3420
/*      */     //   3561: aload 5
/*      */     //   3563: aload 33
/*      */     //   3565: iload 35
/*      */     //   3567: invokevirtual 2456	org/monazilla/v2c/V2CBBSThreadRes:appendToDatFile	([BI)Z
/*      */     //   3570: ifne +6 -> 3576
/*      */     //   3573: goto +18 -> 3591
/*      */     //   3576: iload 30
/*      */     //   3578: ifne -158 -> 3420
/*      */     //   3581: aload 5
/*      */     //   3583: iload 35
/*      */     //   3585: invokevirtual 2454	org/monazilla/v2c/V2CBBSThreadRes:addProgressValue	(I)V
/*      */     //   3588: goto -168 -> 3420
/*      */     //   3591: new 1442	java/io/BufferedReader
/*      */     //   3594: dup
/*      */     //   3595: new 1447	java/io/InputStreamReader
/*      */     //   3598: dup
/*      */     //   3599: aload 16
/*      */     //   3601: aload 5
/*      */     //   3603: invokevirtual 2458	org/monazilla/v2c/V2CBBSThreadRes:getThreadItem	()Lorg/monazilla/v2c/V2CThreadItem;
/*      */     //   3606: invokevirtual 2643	org/monazilla/v2c/V2CThreadItem:getBoardItem	()Lorg/monazilla/v2c/V2CBoardItem;
/*      */     //   3609: invokevirtual 2459	org/monazilla/v2c/V2CBoardItem:getCharsetString	()Ljava/lang/String;
/*      */     //   3612: invokespecial 2289	java/io/InputStreamReader:<init>	(Ljava/io/InputStream;Ljava/lang/String;)V
/*      */     //   3615: invokespecial 2269	java/io/BufferedReader:<init>	(Ljava/io/Reader;)V
/*      */     //   3618: astore 11
/*      */     //   3620: new 1463	java/lang/StringBuilder
/*      */     //   3623: dup
/*      */     //   3624: invokespecial 2339	java/lang/StringBuilder:<init>	()V
/*      */     //   3627: astore 35
/*      */     //   3629: goto +61 -> 3690
/*      */     //   3632: aload 13
/*      */     //   3634: invokevirtual 2355	java/lang/Thread:isInterrupted	()Z
/*      */     //   3637: ifeq +45 -> 3682
/*      */     //   3640: aload_0
/*      */     //   3641: invokestatic 2564	org/monazilla/v2c/V2CPlusHttpUtil:logInterrupt	(Ljava/net/URL;)V
/*      */     //   3644: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   3647: aload 14
/*      */     //   3649: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   3652: aload 16
/*      */     //   3654: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   3657: aload 11
/*      */     //   3659: ifnull +16 -> 3675
/*      */     //   3662: aload 11
/*      */     //   3664: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   3667: aconst_null
/*      */     //   3668: astore 11
/*      */     //   3670: goto +5 -> 3675
/*      */     //   3673: astore 46
/*      */     //   3675: aload 20
/*      */     //   3677: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   3680: aconst_null
/*      */     //   3681: areturn
/*      */     //   3682: aload 35
/*      */     //   3684: aload 36
/*      */     //   3686: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   3689: pop
/*      */     //   3690: aload 11
/*      */     //   3692: invokevirtual 2270	java/io/BufferedReader:readLine	()Ljava/lang/String;
/*      */     //   3695: dup
/*      */     //   3696: astore 36
/*      */     //   3698: ifnonnull -66 -> 3632
/*      */     //   3701: aload 15
/*      */     //   3703: aload 35
/*      */     //   3705: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   3708: invokevirtual 2480	org/monazilla/v2c/V2CHttpUtil$CAndC:setContents	(Ljava/lang/String;)V
/*      */     //   3711: goto +181 -> 3892
/*      */     //   3714: astore 22
/*      */     //   3716: aload 22
/*      */     //   3718: invokevirtual 2282	java/io/IOException:printStackTrace	()V
/*      */     //   3721: iconst_0
/*      */     //   3722: putstatic 2214	org/monazilla/v2c/V2CPlusHttpUtil:bPolipo	Z
/*      */     //   3725: aload 22
/*      */     //   3727: invokestatic 2524	org/monazilla/v2c/V2CMiscUtil:getMessage	(Ljava/lang/Throwable;)Ljava/lang/String;
/*      */     //   3730: astore 23
/*      */     //   3732: aload_0
/*      */     //   3733: aload 23
/*      */     //   3735: aload 22
/*      */     //   3737: invokestatic 2508	org/monazilla/v2c/V2CLogger:logError	(Ljava/net/URL;Ljava/lang/String;Ljava/lang/Exception;)V
/*      */     //   3740: getstatic 2197	java/lang/System:out	Ljava/io/PrintStream;
/*      */     //   3743: new 1463	java/lang/StringBuilder
/*      */     //   3746: dup
/*      */     //   3747: invokespecial 2339	java/lang/StringBuilder:<init>	()V
/*      */     //   3750: aload_0
/*      */     //   3751: invokevirtual 2350	java/lang/StringBuilder:append	(Ljava/lang/Object;)Ljava/lang/StringBuilder;
/*      */     //   3754: ldc_w 1148
/*      */     //   3757: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   3760: aload 23
/*      */     //   3762: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   3765: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   3768: invokevirtual 2297	java/io/PrintStream:println	(Ljava/lang/String;)V
/*      */     //   3771: new 1508	org/monazilla/v2c/V2CHttpUtil$CAndC
/*      */     //   3774: dup
/*      */     //   3775: new 1463	java/lang/StringBuilder
/*      */     //   3778: dup
/*      */     //   3779: aload 22
/*      */     //   3781: invokevirtual 2312	java/lang/Object:getClass	()Ljava/lang/Class;
/*      */     //   3784: invokevirtual 2303	java/lang/Class:getName	()Ljava/lang/String;
/*      */     //   3787: invokestatic 2336	java/lang/String:valueOf	(Ljava/lang/Object;)Ljava/lang/String;
/*      */     //   3790: invokespecial 2345	java/lang/StringBuilder:<init>	(Ljava/lang/String;)V
/*      */     //   3793: ldc_w 1198
/*      */     //   3796: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   3799: aload 23
/*      */     //   3801: invokevirtual 2351	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   3804: invokevirtual 2343	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   3807: invokespecial 2479	org/monazilla/v2c/V2CHttpUtil$CAndC:<init>	(Ljava/lang/String;)V
/*      */     //   3810: astore 45
/*      */     //   3812: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   3815: aload 14
/*      */     //   3817: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   3820: aload 16
/*      */     //   3822: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   3825: aload 11
/*      */     //   3827: ifnull +16 -> 3843
/*      */     //   3830: aload 11
/*      */     //   3832: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   3835: aconst_null
/*      */     //   3836: astore 11
/*      */     //   3838: goto +5 -> 3843
/*      */     //   3841: astore 46
/*      */     //   3843: aload 20
/*      */     //   3845: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   3848: aload 45
/*      */     //   3850: areturn
/*      */     //   3851: astore 44
/*      */     //   3853: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   3856: aload 14
/*      */     //   3858: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   3861: aload 16
/*      */     //   3863: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   3866: aload 11
/*      */     //   3868: ifnull +16 -> 3884
/*      */     //   3871: aload 11
/*      */     //   3873: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   3876: aconst_null
/*      */     //   3877: astore 11
/*      */     //   3879: goto +5 -> 3884
/*      */     //   3882: astore 46
/*      */     //   3884: aload 20
/*      */     //   3886: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   3889: aload 44
/*      */     //   3891: athrow
/*      */     //   3892: invokestatic 2626	org/monazilla/v2c/V2CProxySetting:resetReadProxy	()V
/*      */     //   3895: aload 14
/*      */     //   3897: invokevirtual 2616	org/monazilla/v2c/V2CPlusHttpUtil$RemoteHost:finished	()V
/*      */     //   3900: aload 16
/*      */     //   3902: invokestatic 2499	org/monazilla/v2c/V2CLocalFileHandler:closeInputStream	(Ljava/io/InputStream;)V
/*      */     //   3905: aload 11
/*      */     //   3907: ifnull +16 -> 3923
/*      */     //   3910: aload 11
/*      */     //   3912: invokevirtual 2267	java/io/BufferedReader:close	()V
/*      */     //   3915: aconst_null
/*      */     //   3916: astore 11
/*      */     //   3918: goto +5 -> 3923
/*      */     //   3921: astore 46
/*      */     //   3923: aload 20
/*      */     //   3925: invokestatic 2500	org/monazilla/v2c/V2CLocalFileHandler:closeOutputStream	(Ljava/io/OutputStream;)V
/*      */     //   3928: aload 15
/*      */     //   3930: areturn
/*      */     // Line number table:
/*      */     //   Java source line #1813	-> byte code offset #0
/*      */     //   Java source line #1814	-> byte code offset #3
/*      */     //   Java source line #1815	-> byte code offset #6
/*      */     //   Java source line #1816	-> byte code offset #17
/*      */     //   Java source line #1818	-> byte code offset #19
/*      */     //   Java source line #1819	-> byte code offset #25
/*      */     //   Java source line #1820	-> byte code offset #29
/*      */     //   Java source line #1822	-> byte code offset #31
/*      */     //   Java source line #1823	-> byte code offset #36
/*      */     //   Java source line #1834	-> byte code offset #42
/*      */     //   Java source line #1835	-> byte code offset #65
/*      */     //   Java source line #1836	-> byte code offset #78
/*      */     //   Java source line #1871	-> byte code offset #84
/*      */     //   Java source line #1872	-> byte code offset #89
/*      */     //   Java source line #1873	-> byte code offset #95
/*      */     //   Java source line #1875	-> byte code offset #100
/*      */     //   Java source line #1876	-> byte code offset #103
/*      */     //   Java source line #1877	-> byte code offset #106
/*      */     //   Java source line #1878	-> byte code offset #109
/*      */     //   Java source line #1879	-> byte code offset #112
/*      */     //   Java source line #1880	-> byte code offset #115
/*      */     //   Java source line #1883	-> byte code offset #118
/*      */     //   Java source line #1884	-> byte code offset #129
/*      */     //   Java source line #1885	-> byte code offset #139
/*      */     //   Java source line #1886	-> byte code offset #147
/*      */     //   Java source line #1887	-> byte code offset #150
/*      */     //   Java source line #1891	-> byte code offset #153
/*      */     //   Java source line #1892	-> byte code offset #161
/*      */     //   Java source line #1893	-> byte code offset #169
/*      */     //   Java source line #1894	-> byte code offset #177
/*      */     //   Java source line #1895	-> byte code offset #219
/*      */     //   Java source line #1897	-> byte code offset #256
/*      */     //   Java source line #1898	-> byte code offset #265
/*      */     //   Java source line #1899	-> byte code offset #275
/*      */     //   Java source line #1900	-> byte code offset #283
/*      */     //   Java source line #1901	-> byte code offset #286
/*      */     //   Java source line #1902	-> byte code offset #289
/*      */     //   Java source line #1903	-> byte code offset #297
/*      */     //   Java source line #1904	-> byte code offset #305
/*      */     //   Java source line #1905	-> byte code offset #313
/*      */     //   Java source line #1906	-> byte code offset #321
/*      */     //   Java source line #1907	-> byte code offset #352
/*      */     //   Java source line #1906	-> byte code offset #369
/*      */     //   Java source line #1908	-> byte code offset #374
/*      */     //   Java source line #1909	-> byte code offset #382
/*      */     //   Java source line #1911	-> byte code offset #413
/*      */     //   Java source line #1916	-> byte code offset #419
/*      */     //   Java source line #1917	-> byte code offset #428
/*      */     //   Java source line #1918	-> byte code offset #438
/*      */     //   Java source line #1919	-> byte code offset #446
/*      */     //   Java source line #1920	-> byte code offset #452
/*      */     //   Java source line #1921	-> byte code offset #455
/*      */     //   Java source line #1922	-> byte code offset #468
/*      */     //   Java source line #1923	-> byte code offset #481
/*      */     //   Java source line #1927	-> byte code offset #487
/*      */     //   Java source line #1928	-> byte code offset #495
/*      */     //   Java source line #2358	-> byte code offset #499
/*      */     //   Java source line #2359	-> byte code offset #502
/*      */     //   Java source line #2360	-> byte code offset #507
/*      */     //   Java source line #2362	-> byte code offset #512
/*      */     //   Java source line #2364	-> byte code offset #517
/*      */     //   Java source line #2365	-> byte code offset #522
/*      */     //   Java source line #2366	-> byte code offset #525
/*      */     //   Java source line #2370	-> byte code offset #530
/*      */     //   Java source line #1929	-> byte code offset #535
/*      */     //   Java source line #1932	-> byte code offset #537
/*      */     //   Java source line #1933	-> byte code offset #540
/*      */     //   Java source line #1934	-> byte code offset #546
/*      */     //   Java source line #1935	-> byte code offset #551
/*      */     //   Java source line #1936	-> byte code offset #563
/*      */     //   Java source line #1937	-> byte code offset #574
/*      */     //   Java source line #1938	-> byte code offset #579
/*      */     //   Java source line #1939	-> byte code offset #590
/*      */     //   Java source line #1940	-> byte code offset #593
/*      */     //   Java source line #1941	-> byte code offset #595
/*      */     //   Java source line #1942	-> byte code offset #598
/*      */     //   Java source line #1943	-> byte code offset #612
/*      */     //   Java source line #1942	-> byte code offset #620
/*      */     //   Java source line #1943	-> byte code offset #623
/*      */     //   Java source line #1944	-> byte code offset #626
/*      */     //   Java source line #1940	-> byte code offset #628
/*      */     //   Java source line #1946	-> byte code offset #631
/*      */     //   Java source line #1947	-> byte code offset #641
/*      */     //   Java source line #1948	-> byte code offset #647
/*      */     //   Java source line #1949	-> byte code offset #660
/*      */     //   Java source line #1952	-> byte code offset #670
/*      */     //   Java source line #1953	-> byte code offset #682
/*      */     //   Java source line #1952	-> byte code offset #687
/*      */     //   Java source line #1954	-> byte code offset #694
/*      */     //   Java source line #1955	-> byte code offset #699
/*      */     //   Java source line #1956	-> byte code offset #730
/*      */     //   Java source line #1957	-> byte code offset #741
/*      */     //   Java source line #1958	-> byte code offset #749
/*      */     //   Java source line #1960	-> byte code offset #760
/*      */     //   Java source line #1961	-> byte code offset #781
/*      */     //   Java source line #1960	-> byte code offset #786
/*      */     //   Java source line #1962	-> byte code offset #789
/*      */     //   Java source line #1974	-> byte code offset #794
/*      */     //   Java source line #1975	-> byte code offset #799
/*      */     //   Java source line #1976	-> byte code offset #804
/*      */     //   Java source line #1978	-> byte code offset #810
/*      */     //   Java source line #1979	-> byte code offset #816
/*      */     //   Java source line #1980	-> byte code offset #824
/*      */     //   Java source line #1981	-> byte code offset #834
/*      */     //   Java source line #1982	-> byte code offset #841
/*      */     //   Java source line #1984	-> byte code offset #857
/*      */     //   Java source line #1985	-> byte code offset #881
/*      */     //   Java source line #1986	-> byte code offset #892
/*      */     //   Java source line #1984	-> byte code offset #909
/*      */     //   Java source line #1987	-> byte code offset #914
/*      */     //   Java source line #1988	-> byte code offset #921
/*      */     //   Java source line #1989	-> byte code offset #928
/*      */     //   Java source line #1991	-> byte code offset #935
/*      */     //   Java source line #1992	-> byte code offset #949
/*      */     //   Java source line #1993	-> byte code offset #956
/*      */     //   Java source line #1995	-> byte code offset #961
/*      */     //   Java source line #1997	-> byte code offset #966
/*      */     //   Java source line #1998	-> byte code offset #969
/*      */     //   Java source line #1999	-> byte code offset #974
/*      */     //   Java source line #2001	-> byte code offset #977
/*      */     //   Java source line #2002	-> byte code offset #984
/*      */     //   Java source line #2003	-> byte code offset #989
/*      */     //   Java source line #2004	-> byte code offset #994
/*      */     //   Java source line #2005	-> byte code offset #997
/*      */     //   Java source line #2006	-> byte code offset #1001
/*      */     //   Java source line #2007	-> byte code offset #1011
/*      */     //   Java source line #2008	-> byte code offset #1013
/*      */     //   Java source line #2009	-> byte code offset #1018
/*      */     //   Java source line #2012	-> byte code offset #1023
/*      */     //   Java source line #2013	-> byte code offset #1031
/*      */     //   Java source line #2358	-> byte code offset #1035
/*      */     //   Java source line #2359	-> byte code offset #1038
/*      */     //   Java source line #2360	-> byte code offset #1043
/*      */     //   Java source line #2362	-> byte code offset #1048
/*      */     //   Java source line #2364	-> byte code offset #1053
/*      */     //   Java source line #2365	-> byte code offset #1058
/*      */     //   Java source line #2366	-> byte code offset #1061
/*      */     //   Java source line #2370	-> byte code offset #1066
/*      */     //   Java source line #2014	-> byte code offset #1071
/*      */     //   Java source line #2016	-> byte code offset #1073
/*      */     //   Java source line #2017	-> byte code offset #1098
/*      */     //   Java source line #2018	-> byte code offset #1109
/*      */     //   Java source line #2020	-> byte code offset #1116
/*      */     //   Java source line #2021	-> byte code offset #1132
/*      */     //   Java source line #2022	-> byte code offset #1135
/*      */     //   Java source line #2358	-> byte code offset #1139
/*      */     //   Java source line #2359	-> byte code offset #1142
/*      */     //   Java source line #2360	-> byte code offset #1147
/*      */     //   Java source line #2362	-> byte code offset #1152
/*      */     //   Java source line #2364	-> byte code offset #1157
/*      */     //   Java source line #2365	-> byte code offset #1162
/*      */     //   Java source line #2366	-> byte code offset #1165
/*      */     //   Java source line #2370	-> byte code offset #1170
/*      */     //   Java source line #2022	-> byte code offset #1175
/*      */     //   Java source line #2025	-> byte code offset #1178
/*      */     //   Java source line #2026	-> byte code offset #1186
/*      */     //   Java source line #2027	-> byte code offset #1191
/*      */     //   Java source line #2029	-> byte code offset #1196
/*      */     //   Java source line #2030	-> byte code offset #1201
/*      */     //   Java source line #2031	-> byte code offset #1208
/*      */     //   Java source line #2032	-> byte code offset #1222
/*      */     //   Java source line #2358	-> byte code offset #1226
/*      */     //   Java source line #2359	-> byte code offset #1229
/*      */     //   Java source line #2360	-> byte code offset #1234
/*      */     //   Java source line #2362	-> byte code offset #1239
/*      */     //   Java source line #2364	-> byte code offset #1244
/*      */     //   Java source line #2365	-> byte code offset #1249
/*      */     //   Java source line #2366	-> byte code offset #1252
/*      */     //   Java source line #2370	-> byte code offset #1257
/*      */     //   Java source line #2032	-> byte code offset #1262
/*      */     //   Java source line #2035	-> byte code offset #1265
/*      */     //   Java source line #2036	-> byte code offset #1283
/*      */     //   Java source line #2038	-> byte code offset #1294
/*      */     //   Java source line #2039	-> byte code offset #1304
/*      */     //   Java source line #2040	-> byte code offset #1310
/*      */     //   Java source line #2041	-> byte code offset #1314
/*      */     //   Java source line #2042	-> byte code offset #1318
/*      */     //   Java source line #2043	-> byte code offset #1322
/*      */     //   Java source line #2045	-> byte code offset #1346
/*      */     //   Java source line #2046	-> byte code offset #1351
/*      */     //   Java source line #2045	-> byte code offset #1360
/*      */     //   Java source line #2358	-> byte code offset #1365
/*      */     //   Java source line #2359	-> byte code offset #1368
/*      */     //   Java source line #2360	-> byte code offset #1373
/*      */     //   Java source line #2362	-> byte code offset #1378
/*      */     //   Java source line #2364	-> byte code offset #1383
/*      */     //   Java source line #2365	-> byte code offset #1388
/*      */     //   Java source line #2366	-> byte code offset #1391
/*      */     //   Java source line #2370	-> byte code offset #1396
/*      */     //   Java source line #2045	-> byte code offset #1401
/*      */     //   Java source line #2047	-> byte code offset #1404
/*      */     //   Java source line #2048	-> byte code offset #1417
/*      */     //   Java source line #2049	-> byte code offset #1428
/*      */     //   Java source line #2050	-> byte code offset #1434
/*      */     //   Java source line #2051	-> byte code offset #1440
/*      */     //   Java source line #2050	-> byte code offset #1444
/*      */     //   Java source line #2358	-> byte code offset #1449
/*      */     //   Java source line #2359	-> byte code offset #1452
/*      */     //   Java source line #2360	-> byte code offset #1457
/*      */     //   Java source line #2362	-> byte code offset #1462
/*      */     //   Java source line #2364	-> byte code offset #1467
/*      */     //   Java source line #2365	-> byte code offset #1472
/*      */     //   Java source line #2366	-> byte code offset #1475
/*      */     //   Java source line #2370	-> byte code offset #1480
/*      */     //   Java source line #2050	-> byte code offset #1485
/*      */     //   Java source line #2053	-> byte code offset #1488
/*      */     //   Java source line #2054	-> byte code offset #1493
/*      */     //   Java source line #2055	-> byte code offset #1498
/*      */     //   Java source line #2057	-> byte code offset #1504
/*      */     //   Java source line #2358	-> byte code offset #1516
/*      */     //   Java source line #2359	-> byte code offset #1519
/*      */     //   Java source line #2360	-> byte code offset #1524
/*      */     //   Java source line #2362	-> byte code offset #1529
/*      */     //   Java source line #2364	-> byte code offset #1534
/*      */     //   Java source line #2365	-> byte code offset #1539
/*      */     //   Java source line #2366	-> byte code offset #1542
/*      */     //   Java source line #2370	-> byte code offset #1547
/*      */     //   Java source line #2057	-> byte code offset #1552
/*      */     //   Java source line #2059	-> byte code offset #1555
/*      */     //   Java source line #2060	-> byte code offset #1563
/*      */     //   Java source line #2358	-> byte code offset #1567
/*      */     //   Java source line #2359	-> byte code offset #1570
/*      */     //   Java source line #2360	-> byte code offset #1575
/*      */     //   Java source line #2362	-> byte code offset #1580
/*      */     //   Java source line #2364	-> byte code offset #1585
/*      */     //   Java source line #2365	-> byte code offset #1590
/*      */     //   Java source line #2366	-> byte code offset #1593
/*      */     //   Java source line #2370	-> byte code offset #1598
/*      */     //   Java source line #2060	-> byte code offset #1603
/*      */     //   Java source line #2061	-> byte code offset #1606
/*      */     //   Java source line #2062	-> byte code offset #1622
/*      */     //   Java source line #2063	-> byte code offset #1626
/*      */     //   Java source line #2358	-> byte code offset #1630
/*      */     //   Java source line #2359	-> byte code offset #1633
/*      */     //   Java source line #2360	-> byte code offset #1638
/*      */     //   Java source line #2362	-> byte code offset #1643
/*      */     //   Java source line #2364	-> byte code offset #1648
/*      */     //   Java source line #2365	-> byte code offset #1653
/*      */     //   Java source line #2366	-> byte code offset #1656
/*      */     //   Java source line #2370	-> byte code offset #1661
/*      */     //   Java source line #2063	-> byte code offset #1666
/*      */     //   Java source line #2064	-> byte code offset #1669
/*      */     //   Java source line #2065	-> byte code offset #1677
/*      */     //   Java source line #2358	-> byte code offset #1681
/*      */     //   Java source line #2359	-> byte code offset #1684
/*      */     //   Java source line #2360	-> byte code offset #1689
/*      */     //   Java source line #2362	-> byte code offset #1694
/*      */     //   Java source line #2364	-> byte code offset #1699
/*      */     //   Java source line #2365	-> byte code offset #1704
/*      */     //   Java source line #2366	-> byte code offset #1707
/*      */     //   Java source line #2370	-> byte code offset #1712
/*      */     //   Java source line #2065	-> byte code offset #1717
/*      */     //   Java source line #2066	-> byte code offset #1720
/*      */     //   Java source line #2067	-> byte code offset #1736
/*      */     //   Java source line #2068	-> byte code offset #1746
/*      */     //   Java source line #2069	-> byte code offset #1756
/*      */     //   Java source line #2070	-> byte code offset #1762
/*      */     //   Java source line #2071	-> byte code offset #1768
/*      */     //   Java source line #2070	-> byte code offset #1772
/*      */     //   Java source line #2358	-> byte code offset #1777
/*      */     //   Java source line #2359	-> byte code offset #1780
/*      */     //   Java source line #2360	-> byte code offset #1785
/*      */     //   Java source line #2362	-> byte code offset #1790
/*      */     //   Java source line #2364	-> byte code offset #1795
/*      */     //   Java source line #2365	-> byte code offset #1800
/*      */     //   Java source line #2366	-> byte code offset #1803
/*      */     //   Java source line #2370	-> byte code offset #1808
/*      */     //   Java source line #2070	-> byte code offset #1813
/*      */     //   Java source line #2072	-> byte code offset #1816
/*      */     //   Java source line #2073	-> byte code offset #1821
/*      */     //   Java source line #2358	-> byte code offset #1833
/*      */     //   Java source line #2359	-> byte code offset #1836
/*      */     //   Java source line #2360	-> byte code offset #1841
/*      */     //   Java source line #2362	-> byte code offset #1846
/*      */     //   Java source line #2364	-> byte code offset #1851
/*      */     //   Java source line #2365	-> byte code offset #1856
/*      */     //   Java source line #2366	-> byte code offset #1859
/*      */     //   Java source line #2370	-> byte code offset #1864
/*      */     //   Java source line #2073	-> byte code offset #1869
/*      */     //   Java source line #2074	-> byte code offset #1872
/*      */     //   Java source line #2075	-> byte code offset #1888
/*      */     //   Java source line #2076	-> byte code offset #1890
/*      */     //   Java source line #2075	-> byte code offset #1896
/*      */     //   Java source line #2077	-> byte code offset #1899
/*      */     //   Java source line #2076	-> byte code offset #1905
/*      */     //   Java source line #2075	-> byte code offset #1908
/*      */     //   Java source line #2078	-> byte code offset #1912
/*      */     //   Java source line #2079	-> byte code offset #1918
/*      */     //   Java source line #2078	-> byte code offset #1921
/*      */     //   Java source line #2358	-> byte code offset #1926
/*      */     //   Java source line #2359	-> byte code offset #1929
/*      */     //   Java source line #2360	-> byte code offset #1934
/*      */     //   Java source line #2362	-> byte code offset #1939
/*      */     //   Java source line #2364	-> byte code offset #1944
/*      */     //   Java source line #2365	-> byte code offset #1949
/*      */     //   Java source line #2366	-> byte code offset #1952
/*      */     //   Java source line #2370	-> byte code offset #1957
/*      */     //   Java source line #2078	-> byte code offset #1962
/*      */     //   Java source line #2081	-> byte code offset #1965
/*      */     //   Java source line #2082	-> byte code offset #1969
/*      */     //   Java source line #2358	-> byte code offset #1973
/*      */     //   Java source line #2359	-> byte code offset #1976
/*      */     //   Java source line #2360	-> byte code offset #1981
/*      */     //   Java source line #2362	-> byte code offset #1986
/*      */     //   Java source line #2364	-> byte code offset #1991
/*      */     //   Java source line #2365	-> byte code offset #1996
/*      */     //   Java source line #2366	-> byte code offset #1999
/*      */     //   Java source line #2370	-> byte code offset #2004
/*      */     //   Java source line #2082	-> byte code offset #2009
/*      */     //   Java source line #2084	-> byte code offset #2012
/*      */     //   Java source line #2085	-> byte code offset #2020
/*      */     //   Java source line #2086	-> byte code offset #2025
/*      */     //   Java source line #2087	-> byte code offset #2031
/*      */     //   Java source line #2088	-> byte code offset #2037
/*      */     //   Java source line #2087	-> byte code offset #2041
/*      */     //   Java source line #2358	-> byte code offset #2046
/*      */     //   Java source line #2359	-> byte code offset #2049
/*      */     //   Java source line #2360	-> byte code offset #2054
/*      */     //   Java source line #2362	-> byte code offset #2059
/*      */     //   Java source line #2364	-> byte code offset #2064
/*      */     //   Java source line #2365	-> byte code offset #2069
/*      */     //   Java source line #2366	-> byte code offset #2072
/*      */     //   Java source line #2370	-> byte code offset #2077
/*      */     //   Java source line #2087	-> byte code offset #2082
/*      */     //   Java source line #2089	-> byte code offset #2085
/*      */     //   Java source line #2090	-> byte code offset #2101
/*      */     //   Java source line #2091	-> byte code offset #2103
/*      */     //   Java source line #2090	-> byte code offset #2109
/*      */     //   Java source line #2092	-> byte code offset #2112
/*      */     //   Java source line #2091	-> byte code offset #2118
/*      */     //   Java source line #2090	-> byte code offset #2121
/*      */     //   Java source line #2093	-> byte code offset #2125
/*      */     //   Java source line #2094	-> byte code offset #2131
/*      */     //   Java source line #2093	-> byte code offset #2134
/*      */     //   Java source line #2358	-> byte code offset #2139
/*      */     //   Java source line #2359	-> byte code offset #2142
/*      */     //   Java source line #2360	-> byte code offset #2147
/*      */     //   Java source line #2362	-> byte code offset #2152
/*      */     //   Java source line #2364	-> byte code offset #2157
/*      */     //   Java source line #2365	-> byte code offset #2162
/*      */     //   Java source line #2366	-> byte code offset #2165
/*      */     //   Java source line #2370	-> byte code offset #2170
/*      */     //   Java source line #2093	-> byte code offset #2175
/*      */     //   Java source line #2096	-> byte code offset #2178
/*      */     //   Java source line #2097	-> byte code offset #2183
/*      */     //   Java source line #2098	-> byte code offset #2193
/*      */     //   Java source line #2097	-> byte code offset #2204
/*      */     //   Java source line #2099	-> byte code offset #2209
/*      */     //   Java source line #2100	-> byte code offset #2217
/*      */     //   Java source line #2101	-> byte code offset #2224
/*      */     //   Java source line #2102	-> byte code offset #2230
/*      */     //   Java source line #2103	-> byte code offset #2233
/*      */     //   Java source line #2105	-> byte code offset #2237
/*      */     //   Java source line #2358	-> byte code offset #2241
/*      */     //   Java source line #2359	-> byte code offset #2244
/*      */     //   Java source line #2360	-> byte code offset #2249
/*      */     //   Java source line #2362	-> byte code offset #2254
/*      */     //   Java source line #2364	-> byte code offset #2259
/*      */     //   Java source line #2365	-> byte code offset #2264
/*      */     //   Java source line #2366	-> byte code offset #2267
/*      */     //   Java source line #2370	-> byte code offset #2272
/*      */     //   Java source line #2105	-> byte code offset #2277
/*      */     //   Java source line #2110	-> byte code offset #2280
/*      */     //   Java source line #2111	-> byte code offset #2300
/*      */     //   Java source line #2112	-> byte code offset #2305
/*      */     //   Java source line #2113	-> byte code offset #2312
/*      */     //   Java source line #2114	-> byte code offset #2322
/*      */     //   Java source line #2115	-> byte code offset #2344
/*      */     //   Java source line #2118	-> byte code offset #2347
/*      */     //   Java source line #2119	-> byte code offset #2364
/*      */     //   Java source line #2121	-> byte code offset #2368
/*      */     //   Java source line #2123	-> byte code offset #2375
/*      */     //   Java source line #2124	-> byte code offset #2380
/*      */     //   Java source line #2125	-> byte code offset #2387
/*      */     //   Java source line #2123	-> byte code offset #2396
/*      */     //   Java source line #2127	-> byte code offset #2403
/*      */     //   Java source line #2128	-> byte code offset #2408
/*      */     //   Java source line #2127	-> byte code offset #2416
/*      */     //   Java source line #2128	-> byte code offset #2419
/*      */     //   Java source line #2129	-> byte code offset #2422
/*      */     //   Java source line #2130	-> byte code offset #2425
/*      */     //   Java source line #2131	-> byte code offset #2430
/*      */     //   Java source line #2132	-> byte code offset #2436
/*      */     //   Java source line #2133	-> byte code offset #2441
/*      */     //   Java source line #2134	-> byte code offset #2443
/*      */     //   Java source line #2135	-> byte code offset #2454
/*      */     //   Java source line #2136	-> byte code offset #2463
/*      */     //   Java source line #2137	-> byte code offset #2471
/*      */     //   Java source line #2138	-> byte code offset #2484
/*      */     //   Java source line #2139	-> byte code offset #2487
/*      */     //   Java source line #2140	-> byte code offset #2492
/*      */     //   Java source line #2141	-> byte code offset #2501
/*      */     //   Java source line #2142	-> byte code offset #2503
/*      */     //   Java source line #2143	-> byte code offset #2512
/*      */     //   Java source line #2141	-> byte code offset #2523
/*      */     //   Java source line #2144	-> byte code offset #2530
/*      */     //   Java source line #2145	-> byte code offset #2535
/*      */     //   Java source line #2146	-> byte code offset #2544
/*      */     //   Java source line #2147	-> byte code offset #2546
/*      */     //   Java source line #2146	-> byte code offset #2552
/*      */     //   Java source line #2149	-> byte code offset #2554
/*      */     //   Java source line #2150	-> byte code offset #2565
/*      */     //   Java source line #2151	-> byte code offset #2568
/*      */     //   Java source line #2153	-> byte code offset #2571
/*      */     //   Java source line #2167	-> byte code offset #2574
/*      */     //   Java source line #2169	-> byte code offset #2579
/*      */     //   Java source line #2170	-> byte code offset #2593
/*      */     //   Java source line #2171	-> byte code offset #2607
/*      */     //   Java source line #2169	-> byte code offset #2621
/*      */     //   Java source line #2358	-> byte code offset #2626
/*      */     //   Java source line #2359	-> byte code offset #2629
/*      */     //   Java source line #2360	-> byte code offset #2634
/*      */     //   Java source line #2362	-> byte code offset #2639
/*      */     //   Java source line #2364	-> byte code offset #2644
/*      */     //   Java source line #2365	-> byte code offset #2649
/*      */     //   Java source line #2366	-> byte code offset #2652
/*      */     //   Java source line #2370	-> byte code offset #2657
/*      */     //   Java source line #2169	-> byte code offset #2662
/*      */     //   Java source line #2174	-> byte code offset #2665
/*      */     //   Java source line #2177	-> byte code offset #2672
/*      */     //   Java source line #2179	-> byte code offset #2679
/*      */     //   Java source line #2180	-> byte code offset #2684
/*      */     //   Java source line #2181	-> byte code offset #2689
/*      */     //   Java source line #2182	-> byte code offset #2697
/*      */     //   Java source line #2181	-> byte code offset #2704
/*      */     //   Java source line #2185	-> byte code offset #2709
/*      */     //   Java source line #2186	-> byte code offset #2726
/*      */     //   Java source line #2185	-> byte code offset #2731
/*      */     //   Java source line #2188	-> byte code offset #2735
/*      */     //   Java source line #2189	-> byte code offset #2738
/*      */     //   Java source line #2190	-> byte code offset #2747
/*      */     //   Java source line #2191	-> byte code offset #2750
/*      */     //   Java source line #2193	-> byte code offset #2753
/*      */     //   Java source line #2194	-> byte code offset #2756
/*      */     //   Java source line #2193	-> byte code offset #2766
/*      */     //   Java source line #2196	-> byte code offset #2779
/*      */     //   Java source line #2197	-> byte code offset #2784
/*      */     //   Java source line #2198	-> byte code offset #2787
/*      */     //   Java source line #2200	-> byte code offset #2791
/*      */     //   Java source line #2201	-> byte code offset #2798
/*      */     //   Java source line #2202	-> byte code offset #2806
/*      */     //   Java source line #2203	-> byte code offset #2837
/*      */     //   Java source line #2206	-> byte code offset #2842
/*      */     //   Java source line #2204	-> byte code offset #2850
/*      */     //   Java source line #2206	-> byte code offset #2852
/*      */     //   Java source line #2207	-> byte code offset #2857
/*      */     //   Java source line #2206	-> byte code offset #2860
/*      */     //   Java source line #2209	-> byte code offset #2865
/*      */     //   Java source line #2211	-> byte code offset #2875
/*      */     //   Java source line #2212	-> byte code offset #2890
/*      */     //   Java source line #2217	-> byte code offset #2893
/*      */     //   Java source line #2218	-> byte code offset #2900
/*      */     //   Java source line #2219	-> byte code offset #2903
/*      */     //   Java source line #2220	-> byte code offset #2913
/*      */     //   Java source line #2218	-> byte code offset #2915
/*      */     //   Java source line #2226	-> byte code offset #2920
/*      */     //   Java source line #2227	-> byte code offset #2928
/*      */     //   Java source line #2228	-> byte code offset #2931
/*      */     //   Java source line #2229	-> byte code offset #2934
/*      */     //   Java source line #2230	-> byte code offset #2944
/*      */     //   Java source line #2228	-> byte code offset #2946
/*      */     //   Java source line #2233	-> byte code offset #2951
/*      */     //   Java source line #2234	-> byte code offset #2959
/*      */     //   Java source line #2235	-> byte code offset #2965
/*      */     //   Java source line #2236	-> byte code offset #2968
/*      */     //   Java source line #2237	-> byte code offset #2973
/*      */     //   Java source line #2240	-> byte code offset #2979
/*      */     //   Java source line #2241	-> byte code offset #3004
/*      */     //   Java source line #2243	-> byte code offset #3034
/*      */     //   Java source line #2248	-> byte code offset #3041
/*      */     //   Java source line #2249	-> byte code offset #3047
/*      */     //   Java source line #2250	-> byte code offset #3050
/*      */     //   Java source line #2249	-> byte code offset #3053
/*      */     //   Java source line #2252	-> byte code offset #3056
/*      */     //   Java source line #2254	-> byte code offset #3062
/*      */     //   Java source line #2255	-> byte code offset #3064
/*      */     //   Java source line #2254	-> byte code offset #3082
/*      */     //   Java source line #2257	-> byte code offset #3086
/*      */     //   Java source line #2258	-> byte code offset #3089
/*      */     //   Java source line #2259	-> byte code offset #3097
/*      */     //   Java source line #2257	-> byte code offset #3099
/*      */     //   Java source line #2261	-> byte code offset #3104
/*      */     //   Java source line #2358	-> byte code offset #3111
/*      */     //   Java source line #2359	-> byte code offset #3114
/*      */     //   Java source line #2360	-> byte code offset #3119
/*      */     //   Java source line #2362	-> byte code offset #3124
/*      */     //   Java source line #2364	-> byte code offset #3129
/*      */     //   Java source line #2365	-> byte code offset #3134
/*      */     //   Java source line #2366	-> byte code offset #3137
/*      */     //   Java source line #2370	-> byte code offset #3142
/*      */     //   Java source line #2257	-> byte code offset #3147
/*      */     //   Java source line #2260	-> byte code offset #3150
/*      */     //   Java source line #2261	-> byte code offset #3152
/*      */     //   Java source line #2262	-> byte code offset #3159
/*      */     //   Java source line #2265	-> byte code offset #3162
/*      */     //   Java source line #2266	-> byte code offset #3172
/*      */     //   Java source line #2267	-> byte code offset #3181
/*      */     //   Java source line #2268	-> byte code offset #3188
/*      */     //   Java source line #2267	-> byte code offset #3193
/*      */     //   Java source line #2269	-> byte code offset #3198
/*      */     //   Java source line #2270	-> byte code offset #3206
/*      */     //   Java source line #2271	-> byte code offset #3211
/*      */     //   Java source line #2272	-> byte code offset #3218
/*      */     //   Java source line #2273	-> byte code offset #3225
/*      */     //   Java source line #2274	-> byte code offset #3239
/*      */     //   Java source line #2275	-> byte code offset #3246
/*      */     //   Java source line #2276	-> byte code offset #3251
/*      */     //   Java source line #2277	-> byte code offset #3254
/*      */     //   Java source line #2278	-> byte code offset #3265
/*      */     //   Java source line #2280	-> byte code offset #3270
/*      */     //   Java source line #2282	-> byte code offset #3278
/*      */     //   Java source line #2283	-> byte code offset #3286
/*      */     //   Java source line #2282	-> byte code offset #3293
/*      */     //   Java source line #2285	-> byte code offset #3298
/*      */     //   Java source line #2286	-> byte code offset #3303
/*      */     //   Java source line #2287	-> byte code offset #3317
/*      */     //   Java source line #2358	-> byte code offset #3321
/*      */     //   Java source line #2359	-> byte code offset #3324
/*      */     //   Java source line #2360	-> byte code offset #3329
/*      */     //   Java source line #2362	-> byte code offset #3334
/*      */     //   Java source line #2364	-> byte code offset #3339
/*      */     //   Java source line #2365	-> byte code offset #3344
/*      */     //   Java source line #2366	-> byte code offset #3347
/*      */     //   Java source line #2370	-> byte code offset #3352
/*      */     //   Java source line #2287	-> byte code offset #3357
/*      */     //   Java source line #2289	-> byte code offset #3360
/*      */     //   Java source line #2290	-> byte code offset #3368
/*      */     //   Java source line #2294	-> byte code offset #3371
/*      */     //   Java source line #2295	-> byte code offset #3378
/*      */     //   Java source line #2294	-> byte code offset #3383
/*      */     //   Java source line #2295	-> byte code offset #3386
/*      */     //   Java source line #2294	-> byte code offset #3391
/*      */     //   Java source line #2296	-> byte code offset #3394
/*      */     //   Java source line #2297	-> byte code offset #3401
/*      */     //   Java source line #2298	-> byte code offset #3413
/*      */     //   Java source line #2301	-> byte code offset #3420
/*      */     //   Java source line #2302	-> byte code offset #3425
/*      */     //   Java source line #2303	-> byte code offset #3434
/*      */     //   Java source line #2304	-> byte code offset #3442
/*      */     //   Java source line #2358	-> byte code offset #3446
/*      */     //   Java source line #2359	-> byte code offset #3449
/*      */     //   Java source line #2360	-> byte code offset #3454
/*      */     //   Java source line #2362	-> byte code offset #3459
/*      */     //   Java source line #2364	-> byte code offset #3464
/*      */     //   Java source line #2365	-> byte code offset #3469
/*      */     //   Java source line #2366	-> byte code offset #3472
/*      */     //   Java source line #2370	-> byte code offset #3477
/*      */     //   Java source line #2305	-> byte code offset #3482
/*      */     //   Java source line #2307	-> byte code offset #3484
/*      */     //   Java source line #2308	-> byte code offset #3489
/*      */     //   Java source line #2309	-> byte code offset #3497
/*      */     //   Java source line #2310	-> byte code offset #3506
/*      */     //   Java source line #2314	-> byte code offset #3509
/*      */     //   Java source line #2315	-> byte code offset #3514
/*      */     //   Java source line #2316	-> byte code offset #3519
/*      */     //   Java source line #2317	-> byte code offset #3526
/*      */     //   Java source line #2318	-> byte code offset #3533
/*      */     //   Java source line #2319	-> byte code offset #3536
/*      */     //   Java source line #2320	-> byte code offset #3543
/*      */     //   Java source line #2321	-> byte code offset #3555
/*      */     //   Java source line #2323	-> byte code offset #3558
/*      */     //   Java source line #2324	-> byte code offset #3561
/*      */     //   Java source line #2325	-> byte code offset #3573
/*      */     //   Java source line #2327	-> byte code offset #3576
/*      */     //   Java source line #2328	-> byte code offset #3581
/*      */     //   Java source line #2300	-> byte code offset #3588
/*      */     //   Java source line #2334	-> byte code offset #3591
/*      */     //   Java source line #2335	-> byte code offset #3601
/*      */     //   Java source line #2336	-> byte code offset #3609
/*      */     //   Java source line #2334	-> byte code offset #3615
/*      */     //   Java source line #2337	-> byte code offset #3620
/*      */     //   Java source line #2339	-> byte code offset #3629
/*      */     //   Java source line #2340	-> byte code offset #3632
/*      */     //   Java source line #2341	-> byte code offset #3640
/*      */     //   Java source line #2358	-> byte code offset #3644
/*      */     //   Java source line #2359	-> byte code offset #3647
/*      */     //   Java source line #2360	-> byte code offset #3652
/*      */     //   Java source line #2362	-> byte code offset #3657
/*      */     //   Java source line #2364	-> byte code offset #3662
/*      */     //   Java source line #2365	-> byte code offset #3667
/*      */     //   Java source line #2366	-> byte code offset #3670
/*      */     //   Java source line #2370	-> byte code offset #3675
/*      */     //   Java source line #2342	-> byte code offset #3680
/*      */     //   Java source line #2344	-> byte code offset #3682
/*      */     //   Java source line #2339	-> byte code offset #3690
/*      */     //   Java source line #2346	-> byte code offset #3701
/*      */     //   Java source line #2347	-> byte code offset #3711
/*      */     //   Java source line #2348	-> byte code offset #3716
/*      */     //   Java source line #2349	-> byte code offset #3721
/*      */     //   Java source line #2350	-> byte code offset #3725
/*      */     //   Java source line #2351	-> byte code offset #3732
/*      */     //   Java source line #2353	-> byte code offset #3740
/*      */     //   Java source line #2355	-> byte code offset #3771
/*      */     //   Java source line #2356	-> byte code offset #3793
/*      */     //   Java source line #2355	-> byte code offset #3807
/*      */     //   Java source line #2358	-> byte code offset #3812
/*      */     //   Java source line #2359	-> byte code offset #3815
/*      */     //   Java source line #2360	-> byte code offset #3820
/*      */     //   Java source line #2362	-> byte code offset #3825
/*      */     //   Java source line #2364	-> byte code offset #3830
/*      */     //   Java source line #2365	-> byte code offset #3835
/*      */     //   Java source line #2366	-> byte code offset #3838
/*      */     //   Java source line #2370	-> byte code offset #3843
/*      */     //   Java source line #2355	-> byte code offset #3848
/*      */     //   Java source line #2357	-> byte code offset #3851
/*      */     //   Java source line #2358	-> byte code offset #3853
/*      */     //   Java source line #2359	-> byte code offset #3856
/*      */     //   Java source line #2360	-> byte code offset #3861
/*      */     //   Java source line #2362	-> byte code offset #3866
/*      */     //   Java source line #2364	-> byte code offset #3871
/*      */     //   Java source line #2365	-> byte code offset #3876
/*      */     //   Java source line #2366	-> byte code offset #3879
/*      */     //   Java source line #2370	-> byte code offset #3884
/*      */     //   Java source line #2371	-> byte code offset #3889
/*      */     //   Java source line #2358	-> byte code offset #3892
/*      */     //   Java source line #2359	-> byte code offset #3895
/*      */     //   Java source line #2360	-> byte code offset #3900
/*      */     //   Java source line #2362	-> byte code offset #3905
/*      */     //   Java source line #2364	-> byte code offset #3910
/*      */     //   Java source line #2365	-> byte code offset #3915
/*      */     //   Java source line #2366	-> byte code offset #3918
/*      */     //   Java source line #2370	-> byte code offset #3923
/*      */     //   Java source line #2372	-> byte code offset #3928
/*      */     // Local variable table:
/*      */     //   start	length	slot	name	signature
/*      */     //   0	3931	0	url	URL
/*      */     //   0	3931	1	startPos	int
/*      */     //   0	3931	2	lastModified	long
/*      */     //   0	3931	4	eTag	String
/*      */     //   0	3931	5	v2cbbsthreadres	V2CBBSThreadRes
/*      */     //   0	3931	6	v2cbbs	V2CBBS
/*      */     //   0	3931	7	acceptGZ	boolean
/*      */     //   0	3931	8	isAPIFail	boolean
/*      */     //   0	3931	9	nowRedirect	boolean
/*      */     //   1	413	10	uri	String
/*      */     //   4	3913	11	bufferedreader	BufferedReader
/*      */     //   40	3023	12	originalUrl	String
/*      */     //   87	3546	13	thread	Thread
/*      */     //   93	3803	14	remotehost	RemoteHost
/*      */     //   1107	2595	15	candc	V2CHttpUtil.CAndC
/*      */     //   3892	37	15	candc	V2CHttpUtil.CAndC
/*      */     //   101	3800	16	istream	InputStream
/*      */     //   104	853	17	out	PrintStream
/*      */     //   107	1914	18	usingAPI	boolean
/*      */     //   110	2570	19	usingHTML	boolean
/*      */     //   113	3811	20	bos	java.io.ByteArrayOutputStream
/*      */     //   116	966	21	is2ch	boolean
/*      */     //   137	33	22	matcher	Matcher
/*      */     //   273	41	22	matcher	Matcher
/*      */     //   436	3	22	matcher	Matcher
/*      */     //   538	2823	22	responseCode	int
/*      */     //   3714	66	22	ioexception	IOException
/*      */     //   159	29	23	server	String
/*      */     //   295	37	23	server	String
/*      */     //   450	32	23	s	String
/*      */     //   544	2853	23	urlConn	HttpURLConnection
/*      */     //   3730	70	23	s1	String
/*      */     //   167	32	24	board	String
/*      */     //   303	34	24	s2ch	String
/*      */     //   692	1589	24	useRange	boolean
/*      */     //   175	35	25	threadId	String
/*      */     //   311	37	25	board	String
/*      */     //   797	8	25	maruSessionID	String
/*      */     //   967	1212	25	socketTimeoutError	boolean
/*      */     //   319	40	26	threadId	String
/*      */     //   832	3	26	url2	URL
/*      */     //   972	1222	26	socketErrorMessage	String
/*      */     //   839	32	27	host	String
/*      */     //   975	1238	27	ste	SocketTimeoutException
/*      */     //   912	3	28	accessPoint	String
/*      */     //   987	15	28	e	SocketTimeoutException
/*      */     //   1011	3	28	e	Exception
/*      */     //   1114	1494	28	contentType	String
/*      */     //   919	3	29	message	String
/*      */     //   1206	3	29	len	int
/*      */     //   1302	34	29	location	String
/*      */     //   1496	4	29	message	String
/*      */     //   1744	8	29	etag	String
/*      */     //   2207	13	29	message	String
/*      */     //   2298	1104	29	polipoDetection	boolean
/*      */     //   926	3	30	hobo	String
/*      */     //   2401	1176	30	isGZip	boolean
/*      */     //   933	19	31	param	String
/*      */     //   2310	13	31	k	int
/*      */     //   2373	13	31	contentEncoding	String
/*      */     //   2320	14	32	s3	String
/*      */     //   2423	152	32	hasContentType	boolean
/*      */     //   3411	146	32	offset	int
/*      */     //   2434	111	33	s4	String
/*      */     //   3418	146	33	abyte0	byte[]
/*      */     //   2677	713	34	contentLength	int
/*      */     //   2733	36	35	buff	byte[]
/*      */     //   3301	68	35	ioexception1	IOException
/*      */     //   3432	152	35	k1	int
/*      */     //   3627	77	35	sb	StringBuilder
/*      */     //   2736	39	36	read	int
/*      */     //   3632	53	36	line	String
/*      */     //   3696	3	36	line	String
/*      */     //   2748	197	37	isBreakHtml	boolean
/*      */     //   2751	140	38	ioe	IOException
/*      */     //   2782	56	39	e	IOException
/*      */     //   2873	154	39	html	String
/*      */     //   2796	31	40	s1	String
/*      */     //   2898	304	40	lastRes	int
/*      */     //   2850	8	41	localObject1	Object
/*      */     //   2918	245	41	dat	String
/*      */     //   3150	10	42	localObject2	Object
/*      */     //   3170	96	42	data	byte[]
/*      */     //   3102	46	43	localCAndC1	V2CHttpUtil.CAndC
/*      */     //   3851	39	44	localObject3	Object
/*      */     //   1137	2712	45	localCAndC2	V2CHttpUtil.CAndC
/*      */     //   528	1	46	localIOException1	IOException
/*      */     //   1064	1	46	localIOException2	IOException
/*      */     //   1168	1	46	localIOException3	IOException
/*      */     //   1255	1	46	localIOException4	IOException
/*      */     //   1394	1	46	localIOException5	IOException
/*      */     //   1478	1	46	localIOException6	IOException
/*      */     //   1545	1	46	localIOException7	IOException
/*      */     //   1596	1	46	localIOException8	IOException
/*      */     //   1659	1	46	localIOException9	IOException
/*      */     //   1710	1	46	localIOException10	IOException
/*      */     //   1806	1	46	localIOException11	IOException
/*      */     //   1862	1	46	localIOException12	IOException
/*      */     //   1955	1	46	localIOException13	IOException
/*      */     //   2002	1	46	localIOException14	IOException
/*      */     //   2075	1	46	localIOException15	IOException
/*      */     //   2168	1	46	localIOException16	IOException
/*      */     //   2270	1	46	localIOException17	IOException
/*      */     //   2655	1	46	localIOException18	IOException
/*      */     //   3140	1	46	localIOException19	IOException
/*      */     //   3350	1	46	localIOException20	IOException
/*      */     //   3475	1	46	localIOException21	IOException
/*      */     //   3673	1	46	localIOException22	IOException
/*      */     //   3841	1	46	localIOException23	IOException
/*      */     //   3882	1	46	localIOException24	IOException
/*      */     //   3921	1	46	localIOException25	IOException
/*      */     // Exception table:
/*      */     //   from	to	target	type
/*      */     //   517	525	528	java/io/IOException
/*      */     //   977	984	987	java/net/SocketTimeoutException
/*      */     //   977	984	1011	java/lang/Exception
/*      */     //   1053	1061	1064	java/io/IOException
/*      */     //   1157	1165	1168	java/io/IOException
/*      */     //   1244	1252	1255	java/io/IOException
/*      */     //   1383	1391	1394	java/io/IOException
/*      */     //   1467	1475	1478	java/io/IOException
/*      */     //   1534	1542	1545	java/io/IOException
/*      */     //   1585	1593	1596	java/io/IOException
/*      */     //   1648	1656	1659	java/io/IOException
/*      */     //   1699	1707	1710	java/io/IOException
/*      */     //   1795	1803	1806	java/io/IOException
/*      */     //   1851	1859	1862	java/io/IOException
/*      */     //   1944	1952	1955	java/io/IOException
/*      */     //   1991	1999	2002	java/io/IOException
/*      */     //   2064	2072	2075	java/io/IOException
/*      */     //   2157	2165	2168	java/io/IOException
/*      */     //   2259	2267	2270	java/io/IOException
/*      */     //   2644	2652	2655	java/io/IOException
/*      */     //   2753	2779	2782	java/io/IOException
/*      */     //   2753	2842	2850	finally
/*      */     //   3129	3137	3140	java/io/IOException
/*      */     //   3041	3104	3150	finally
/*      */     //   3278	3298	3301	java/io/IOException
/*      */     //   3339	3347	3350	java/io/IOException
/*      */     //   3464	3472	3475	java/io/IOException
/*      */     //   3662	3670	3673	java/io/IOException
/*      */     //   118	499	3714	java/io/IOException
/*      */     //   537	1035	3714	java/io/IOException
/*      */     //   1073	1139	3714	java/io/IOException
/*      */     //   1178	1226	3714	java/io/IOException
/*      */     //   1265	1365	3714	java/io/IOException
/*      */     //   1404	1449	3714	java/io/IOException
/*      */     //   1488	1516	3714	java/io/IOException
/*      */     //   1555	1567	3714	java/io/IOException
/*      */     //   1606	1630	3714	java/io/IOException
/*      */     //   1669	1681	3714	java/io/IOException
/*      */     //   1720	1777	3714	java/io/IOException
/*      */     //   1816	1833	3714	java/io/IOException
/*      */     //   1872	1926	3714	java/io/IOException
/*      */     //   1965	1973	3714	java/io/IOException
/*      */     //   2012	2046	3714	java/io/IOException
/*      */     //   2085	2139	3714	java/io/IOException
/*      */     //   2178	2241	3714	java/io/IOException
/*      */     //   2280	2626	3714	java/io/IOException
/*      */     //   2665	3111	3714	java/io/IOException
/*      */     //   3150	3321	3714	java/io/IOException
/*      */     //   3360	3446	3714	java/io/IOException
/*      */     //   3484	3644	3714	java/io/IOException
/*      */     //   3682	3711	3714	java/io/IOException
/*      */     //   3830	3838	3841	java/io/IOException
/*      */     //   118	499	3851	finally
/*      */     //   537	1035	3851	finally
/*      */     //   1073	1139	3851	finally
/*      */     //   1178	1226	3851	finally
/*      */     //   1265	1365	3851	finally
/*      */     //   1404	1449	3851	finally
/*      */     //   1488	1516	3851	finally
/*      */     //   1555	1567	3851	finally
/*      */     //   1606	1630	3851	finally
/*      */     //   1669	1681	3851	finally
/*      */     //   1720	1777	3851	finally
/*      */     //   1816	1833	3851	finally
/*      */     //   1872	1926	3851	finally
/*      */     //   1965	1973	3851	finally
/*      */     //   2012	2046	3851	finally
/*      */     //   2085	2139	3851	finally
/*      */     //   2178	2241	3851	finally
/*      */     //   2280	2626	3851	finally
/*      */     //   2665	3111	3851	finally
/*      */     //   3150	3321	3851	finally
/*      */     //   3360	3446	3851	finally
/*      */     //   3484	3644	3851	finally
/*      */     //   3682	3812	3851	finally
/*      */     //   3871	3879	3882	java/io/IOException
/*      */     //   3910	3918	3921	java/io/IOException
/*      */   // }
/*      */   
/*      */   static boolean isNotFoundDat(String html)
/*      */   {
/* 2382 */     if (V2CAppendUtil.isEmpty(html)) {
/* 2383 */       return false;
/*      */     }
/*      */     
/* 2386 */     if (html.contains("datが存在しません。削除されたかURL間違ってますよ。")) {
/* 2387 */       return true;
/*      */     }
/*      */     String[] arrayOfString;
/* 2390 */     int j = (arrayOfString = errorMesssages).length; for (int i = 0; i < j; i++) { String messages = arrayOfString[i];
/* 2391 */       if (html.contains(messages)) {
/* 2392 */         return false;
/*      */       }
/*      */     }
/*      */     
/* 2396 */     return true;
/*      */   }
/*      */   
/*      */   static void outHTMLErrorLog(URL url, String html) {
/* 2400 */     if (V2CAppendUtil.isEmpty(html)) {
/*      */       return;
/*      */     }
/*      */     String[] arrayOfString;
/* 2404 */     int j = (arrayOfString = errorMesssages).length; for (int i = 0; i < j; i++) { String msg = arrayOfString[i];
/* 2405 */       if (html.contains(msg)) {
/* 2406 */         V2CLogger.logError(url, msg);
/* 2407 */         V2CMain.setMessage(url + " : " + msg);
/* 2408 */         return;
/*      */       }
/*      */     }
/*      */     
/* 2412 */     V2CMain.setMessage(url + " : 予期せぬエラー");
/* 2413 */     V2CLogger.logError(url, "予期せぬエラー");
/*      */   }
/*      */   
/*      */   static int connectTwitterStream(V2CTwitterUserStream paramV2CTwitterUserStream, HashMap paramHashMap)
/*      */   {
/* 2418 */     boolean bool = V2CReleaseInfo.isEqual(102, 91, 0);
/* 2419 */     int i = paramHashMap == null ? 1 : 0;
/* 2420 */     if (i != 0) {
/* 2421 */       paramHashMap = new HashMap();
/* 2422 */       paramHashMap.put("with", "followings");
/*      */     }
/* 2424 */     paramHashMap.put("delimited", "length");
/* 2425 */     String str1 = i != 0 ? "https://userstream.twitter.com/1.1/user.json" : 
/* 2426 */       "https://stream.twitter.com/1.1/statuses/filter.json";
/* 2427 */     URL localURL = str2URL(str1);
/* 2428 */     int j = 0;
/* 2429 */     PrintWriter localPrintWriter = null;
/* 2430 */     Object localObject1 = null;
/* 2431 */     Thread localThread = Thread.currentThread();
/* 2432 */     int k = 0;
/* 2433 */     int m = 0;
/* 2434 */     int n = 0;
/* 2435 */     int i1 = 0;
/* 2436 */     int i2 = 0;
/*      */     for (;;) {
/* 2438 */       if (bool)
/* 2439 */         System.out.println("ncto,nrto: " + m + "," + n);
/* 2440 */       int i3 = 0;
/*      */       try
/*      */       {
/* 2443 */         if (localThread.isInterrupted()) {
/* 2444 */           logInterrupt(localURL);
/* 2445 */           int i4 = 2;
/* 2446 */           return i4;
/*      */         }
/* 2448 */         if ((m >= 10) || (k >= 10)) {
/* 2449 */           int i4 = 5;
/* 2450 */           return i4;
/*      */         }
/* 2452 */         if (m > 1) {
/* 2453 */           if (i1 <= 0) {
/* 2454 */             int i4 = (int)System.currentTimeMillis() & 0x7FFF;
/* 2455 */             i1 = 20 + i4 % 20;
/* 2456 */             i2 = 240 + (i4 >>> 5) % 60;
/*      */           } else {
/* 2458 */             i1 = Math.min(i1 * 2, i2);
/*      */           }
/* 2460 */           if (bool)
/* 2461 */             System.out.println("sleeping: " + i1);
/*      */           try {
/* 2463 */             Thread.sleep(i1 * 1000);
/*      */           } catch (InterruptedException localInterruptedException) {
/* 2465 */             int i5 = 2;
/* 2466 */             return i5;
/*      */           }
/*      */         }
/* 2469 */         HttpURLConnection conn = 
/* 2470 */           V2CProxySetting.openReadConnection(localURL);
/* 2471 */         setTimeout(conn, 5000, 90000);
/* 2472 */         conn.setRequestMethod("POST");
/* 2473 */         conn.setDoOutput(true);
/* 2474 */         conn.setUseCaches(false);
/* 2475 */         conn.setAllowUserInteraction(false);
/* 2476 */         conn.setRequestProperty("Host", localURL.getHost());
/* 2477 */         conn.setRequestProperty("Accept", "*/*");
/* 2478 */         conn.setRequestProperty("Accept-Encoding", "deflate,gzip");
/*      */         
/*      */ 
/*      */ 
/* 2482 */         conn.setRequestProperty("User-Agent", 
/* 2483 */           "Mozilla/4.0 (compatible)");
/*      */         
/* 2485 */         String str2 = createOAuthHeader(
/* 2486 */           paramV2CTwitterUserStream.getUser(), true, str1, 
/* 2487 */           paramHashMap);
/* 2488 */         conn.setRequestProperty("Authorization", str2);
/*      */         
/* 2490 */         if (paramV2CTwitterUserStream.disconnectReceived()) {
/* 2491 */           int i6 = 4;
/* 2492 */           return i6;
/*      */         }
/* 2494 */         V2CLogger.logHTTPHeaderFields(localURL, 
/* 2495 */           "TwitterUserStream Request:", 
/* 2496 */           conn.getRequestProperties());
/* 2497 */         localPrintWriter = new PrintWriter(conn.getOutputStream());
/* 2498 */         if (localThread.isInterrupted()) {
/* 2499 */           logInterrupt(localURL);
/* 2500 */           int i6 = 2;
/* 2501 */           return i6;
/*      */         }
/* 2503 */         localPrintWriter.print(constructQuery(paramHashMap));
/* 2504 */         localPrintWriter.close();
/* 2505 */         localPrintWriter = null;
/* 2506 */         j = conn.getResponseCode();
/* 2507 */         if (localThread.isInterrupted()) {
/* 2508 */           logInterrupt(localURL);
/* 2509 */           int i6 = 2;
/* 2510 */           return i6;
/*      */         }
/* 2512 */         i3 = 1;
/* 2513 */         logHTTPResponse(conn, "TwitterUserStream Response: ");
/* 2514 */         paramV2CTwitterUserStream.addToConsole("接続 (ResponseCode: " + j + 
/* 2515 */           ")", false);
/* 2516 */         if (j != 200) {
/* 2517 */           if (bool)
/* 2518 */             System.out.println("Response Code: " + j + " " + 
/* 2519 */               conn.getResponseMessage());
/* 2520 */           int i6 = j;
/* 2521 */           return i6;
/*      */         }
/* 2523 */         k = m = n = 0;
/* 2524 */         localObject1 = conn.getInputStream();
/* 2525 */         String str3 = conn.getContentEncoding();
/* 2526 */         if ((str3 != null) && (str3.matches("gzip|deflate")))
/* 2527 */           localObject1 = new GZIPInputStream(
/* 2528 */             (InputStream)localObject1);
/* 2529 */         byte[] arrayOfByte = new byte['က'];
/*      */         int i8;
/* 2531 */         while ((i8 = ((InputStream)localObject1).read(arrayOfByte)) >= 0) {
/* 2533 */           if (localThread.isInterrupted()) {
/* 2534 */             logInterrupt(localURL);
/* 2535 */             int i10 = 2;
/* 2536 */             return i10;
/*      */           }
/* 2538 */           if (((i != 0) && 
/* 2539 */             (!paramV2CTwitterUserStream.getUser().getUseUserStream())) || 
/*      */             
/* 2541 */             (!paramV2CTwitterUserStream.newStreamData(arrayOfByte, i8))) {
/* 2542 */             int i10 = 6;
/* 2543 */             return i10;
/*      */           }
/*      */         }
/*      */       } catch (IOException localIOException) {
/* 2547 */         k++;
/* 2548 */         String str2 = V2CMiscUtil.getMessage(localIOException);
/* 2549 */         if ((str2 != null) && 
/* 2550 */           ((localIOException instanceof SocketTimeoutException))) {
/* 2551 */           paramV2CTwitterUserStream.notifySocketTimeout();
/* 2552 */           if (i3 != 0) {
/* 2553 */             m++;
/* 2554 */             n = 0;
/*      */           } else {
/* 2556 */             n++;
/* 2557 */             m = 0;
/* 2558 */             i1 = 0;
/*      */           }
/*      */         }
/* 2561 */         if (bool)
/* 2562 */           System.out.println(str2 + ", " + new Date());
/* 2563 */         V2CLogger.logError(localURL, str2, localIOException);
/* 2564 */         paramV2CTwitterUserStream.addToConsole(str2, false);
/* 2565 */         if ((localIOException instanceof SSLHandshakeException)) {
/* 2566 */           int i7 = 3;
/* 2567 */           return i7;
/*      */         }
/*      */         
/* 2570 */         V2CProxySetting.resetReadProxy();
/* 2571 */         V2CLocalFileHandler.closeWriter(localPrintWriter);
/*      */         
/* 2573 */         V2CLocalFileHandler.closeInputStream((InputStream)localObject1); continue;
/*      */       }
/*      */       finally
/*      */       {
/* 2570 */         V2CProxySetting.resetReadProxy();
/* 2571 */         V2CLocalFileHandler.closeWriter(localPrintWriter);
/*      */         
/* 2573 */         V2CLocalFileHandler.closeInputStream((InputStream)localObject1);
/*      */       }
/* 2570 */       V2CProxySetting.resetReadProxy();
/* 2571 */       V2CLocalFileHandler.closeWriter(localPrintWriter);
/*      */       
/* 2573 */       V2CLocalFileHandler.closeInputStream((InputStream)localObject1);
/*      */     }
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */   static boolean getImageFile(URL paramURL, String paramString1, String paramString2, OutputStream paramOutputStream, V2CLink paramV2CLink, V2CSHA1Value paramV2CSHA1Value, HashMap paramHashMap, boolean paramBoolean1, boolean paramBoolean2, int paramInt)
/*      */   {
/* 2583 */     if (paramURL == null)
/* 2584 */       return false;
/* 2585 */     if (!V2CMain.isOnlineMode()) {
/* 2586 */       logNotOnline(paramURL);
/* 2587 */       return false;
/*      */     }
/* 2589 */     InputStream localInputStream = null;
/* 2590 */     Thread localThread = Thread.currentThread();
/* 2591 */     boolean bool1 = true;
/* 2592 */     HttpURLConnection localHttpURLConnection = null;
/*      */     try {
/* 2594 */       localHttpURLConnection = 
/* 2595 */         V2CProxySetting.openReadConnection(paramURL);
/* 2596 */       setTimeout(localHttpURLConnection);
/* 2597 */       String str1 = paramURL.getHost();
/* 2598 */       localHttpURLConnection.setRequestProperty("Host", str1);
/* 2599 */       localHttpURLConnection.setRequestProperty("Accept", "*/*");
/* 2600 */       localHttpURLConnection.setRequestProperty("Accept-Language", 
/* 2601 */         "ja,en;q=0.5");
/* 2602 */       localHttpURLConnection.setRequestProperty("User-Agent", 
/* 2603 */         paramString2 != null ? paramString2 : 
/* 2604 */         "Mozilla/4.0 (compatible)");
/* 2605 */       localHttpURLConnection.setUseCaches(true);
/* 2606 */       if ((paramString1 == null) && (str1.equals("up.80.kg")))
/* 2607 */         paramString1 = "http://up.80.kg/";
/* 2608 */       if (paramString1 != null)
/* 2609 */         localHttpURLConnection.setRequestProperty("Referer", 
/* 2610 */           paramString1);
/* 2611 */       String str2 = V2CCookie.getCookie(paramURL);
/* 2612 */       if (str2 != null)
/* 2613 */         localHttpURLConnection.setRequestProperty("Cookie", str2);
/* 2614 */       if (paramHashMap != null) {
/* 2615 */         Iterator localIterator = paramHashMap.keySet().iterator();
/* 2616 */         while (localIterator.hasNext()) {
/* 2617 */           String str3 = (String)localIterator.next();
/* 2618 */           localHttpURLConnection.setRequestProperty(str3, 
/* 2619 */             (String)paramHashMap.get(str3));
/*      */         }
/*      */       }
/* 2622 */       V2CLogger.logHTTPHeaderFields(paramURL, "Image Request:", 
/* 2623 */         localHttpURLConnection.getRequestProperties());
/* 2624 */       int i = localHttpURLConnection.getResponseCode();
/* 2625 */       if (localThread.isInterrupted()) {
/* 2626 */         logInterrupt(paramURL);
/* 2627 */         return false;
/*      */       }
/* 2629 */       logHTTPResponse(localHttpURLConnection, "Image Response: ");
/* 2630 */       paramV2CLink.setFields(localHttpURLConnection);
/* 2631 */       if ((isRedirect(i)) && (paramInt > 0)) {
/* 2632 */         paramInt--;
/* 2633 */         String str4 = localHttpURLConnection.getHeaderField("Location");
/* 2634 */         if (str4 != null) {
/* 2635 */           URL localURL = null;
/*      */           try {
/* 2637 */             localURL = new URL(paramURL, str4);
/*      */           } catch (MalformedURLException localMalformedURLException) {
/* 2639 */             paramV2CLink.setResponseCode(4, 
/* 2640 */               localMalformedURLException.getMessage());
/*      */           }
/* 2642 */           if (localURL != null) {
/* 2643 */             String str5 = localURL.toExternalForm();
/* 2644 */             if (!str5.equals(str4))
/* 2645 */               paramV2CLink.setLocationString(str5);
/* 2646 */             boolean k = getImageFile(localURL, 
/* 2647 */               paramURL.toExternalForm(), paramString2, 
/* 2648 */               paramOutputStream, paramV2CLink, 
/* 2649 */               paramV2CSHA1Value, paramHashMap, paramBoolean1, 
/* 2650 */               paramBoolean2, paramInt);
/* 2651 */             return k;
/*      */           }
/*      */         }
/*      */       }
/* 2655 */       if (!paramBoolean1)
/*      */       {
/*      */ 
/* 2658 */         if (paramV2CLink.exceedsFileSizeLimit(localHttpURLConnection.getContentLength()))
/* 2659 */           return false;
/*      */       }
/* 2661 */       boolean bool4 = !paramV2CLink.isDisplayableImage();
/* 2662 */       if ((!paramBoolean2) && (bool4)) {
/* 2663 */         boolean bool5 = false;
/* 2664 */         return bool5;
/*      */       }
/* 2666 */       localInputStream = localHttpURLConnection.getInputStream();
/* 2667 */       byte[] arrayOfByte = new byte[nBufLen];
/* 2668 */       int k = 0;
/*      */       int j;
/* 2670 */       while ((j = localInputStream.read(arrayOfByte)) >= 0) {
/* 2671 */         if (localThread.isInterrupted()) {
/* 2672 */           logInterrupt(paramURL);
/* 2673 */           boolean bool6 = false;
/* 2674 */           return bool6;
/*      */         }
/* 2676 */         if (j != 0) {
/* 2677 */           if (bool4) {
/* 2678 */             if (V2CLink.checkImageExt(arrayOfByte, j) == 1) {
/* 2679 */               String str6 = localHttpURLConnection
/* 2680 */                 .getContentType();
/* 2681 */               if ((str6 == null) || 
/* 2682 */                 (!str6.startsWith("text/html"))) {
/* 2683 */                 return false;
/*      */               }
/* 2685 */               bool1 = false;
/*      */             }
/* 2687 */             bool4 = false;
/*      */           }
/* 2689 */           paramOutputStream.write(arrayOfByte, 0, j);
/* 2690 */           paramV2CSHA1Value.update(arrayOfByte, 0, j);
/* 2691 */           k += j;
/* 2692 */           if (!paramV2CLink.setDownloadedLength(k, paramBoolean1))
/* 2693 */             return false;
/*      */         }
/*      */       }
/*      */     } catch (IOException localIOException) {
/* 2698 */       paramV2CLink.setError(localIOException);
/* 2699 */       V2CLogger.logError(paramURL, 
/* 2700 */         V2CMiscUtil.getMessage(localIOException), localIOException);
/* 2701 */       boolean bool2 = false;
/* 2702 */       return bool2;
/*      */     } finally {
/* 2704 */       V2CProxySetting.resetReadProxy();
/* 2705 */       V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */     }
/* 2704 */     V2CProxySetting.resetReadProxy();
/* 2705 */     V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */     
/*      */ 
/* 2708 */     return bool1;
/*      */   }
/*      */   
/*      */   static boolean saveContentsToFile(String s, String s1, File file) {
/* 2712 */     if (!V2CMain.isOnlineMode()) {
/* 2713 */       return false;
/*      */     }
/* 2715 */     BufferedOutputStream bufferedoutputstream = 
/* 2716 */       V2CLocalFileHandler.getBufferedOutputStream(file);
/* 2717 */     if (bufferedoutputstream == null) {
/* 2718 */       return false;
/*      */     }
/* 2720 */     return saveContentsToFile(s, s1, bufferedoutputstream);
/*      */   }
/*      */   
/*      */ 
/*      */   static boolean saveContentsToFile(String paramString1, String paramString2, BufferedOutputStream paramBufferedOutputStream)
/*      */   {
/* 2726 */     URL localURL = null;
/* 2727 */     InputStream localInputStream = null;
/*      */     try {
/* 2729 */       if (!V2CMain.isOnlineMode()) {
/* 2730 */         boolean bool1 = false;
/* 2731 */         return bool1;
/*      */       }
/*      */       try {
/* 2734 */         localURL = new URL(paramString1);
/*      */       }
/*      */       catch (MalformedURLException localMalformedURLException) {
/* 2737 */         V2CMiscUtil.printMalformedURLException(localMalformedURLException);
/* 2738 */         boolean bool2 = false;
/* 2739 */         return bool2;
/*      */       }
/* 2741 */       Thread localThread = Thread.currentThread();
/* 2742 */       HttpURLConnection localHttpURLConnection = 
/* 2743 */         V2CProxySetting.openReadConnection(localURL);
/* 2744 */       setTimeout(localHttpURLConnection);
/* 2745 */       String str1 = localURL.getHost();
/* 2746 */       localHttpURLConnection.setRequestProperty("Host", str1);
/* 2747 */       localHttpURLConnection.setRequestProperty("Accept", "*/*");
/* 2748 */       if (paramString2 != null)
/* 2749 */         localHttpURLConnection.setRequestProperty("Referer", 
/* 2750 */           paramString2);
/* 2751 */       setUA(localHttpURLConnection, localURL);
/* 2752 */       localHttpURLConnection.setRequestProperty("Accept-Language", 
/* 2753 */         "ja,en;q=0.5");
/* 2754 */       String str2 = V2CCookie.getCookie(localURL);
/* 2755 */       if (str2 != null)
/* 2756 */         localHttpURLConnection.setRequestProperty("Cookie", str2);
/* 2757 */       V2CLogger.logHTTPHeaderFields(localURL, "Contents Request:", 
/* 2758 */         localHttpURLConnection.getRequestProperties());
/* 2759 */       int i = localHttpURLConnection.getResponseCode();
/* 2760 */       if (localThread.isInterrupted()) {
/* 2761 */         logInterrupt(localURL);
/* 2762 */         boolean bool4 = false;
/* 2763 */         return bool4;
/*      */       }
/* 2765 */       Map localMap = localHttpURLConnection.getHeaderFields();
/*      */       
/* 2767 */       if (localMap.containsKey("Set-Cookie")) {
/* 2768 */         List localList = (List)localMap.get("Set-Cookie");
/* 2769 */         for (int j = 0; j < localList.size(); j++)
/* 2770 */           V2CCookie.addCookie((String)localList.get(j), localURL);
/*      */       }
/* 2772 */       logHTTPResponse(localHttpURLConnection, "Contents Response: ");
/* 2773 */       if (i != 200) {
/* 2774 */         boolean bool5 = false;
/* 2775 */         return bool5;
/*      */       }
/* 2777 */       localInputStream = localHttpURLConnection.getInputStream();
/* 2778 */       byte[] arrayOfByte = new byte[nBufLen];
/*      */       try { int j;
/* 2780 */         while ((j = localInputStream.read(arrayOfByte)) >= 0) {
/* 2781 */           if (localThread.isInterrupted())
/*      */           {
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/* 2788 */             localInputStream.close();return false;
/*      */           }
/* 2784 */           if (j > 0)
/* 2785 */             paramBufferedOutputStream.write(arrayOfByte, 0, j);
/*      */         }
/*      */       } finally {
/* 2788 */         localInputStream.close(); } int j; localInputStream.close();
/*      */     } catch (IOException localIOException) {
/*      */       boolean bool1;
/* 2791 */       V2CLogger.logError(localURL, 
/* 2792 */         V2CMiscUtil.getMessage(localIOException), localIOException);
/* 2793 */       boolean bool3 = false;
/* 2794 */       return bool3;
/*      */     } finally {
/* 2796 */       V2CProxySetting.resetReadProxy();
/* 2797 */       V2CLocalFileHandler.closeOutputStream(paramBufferedOutputStream);
/* 2798 */       V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */     }
/* 2796 */     V2CProxySetting.resetReadProxy();
/* 2797 */     V2CLocalFileHandler.closeOutputStream(paramBufferedOutputStream);
/* 2798 */     V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */     
/* 2800 */     return true;
/*      */   }
/*      */   
/*      */   static URL getRedirectURL(URL paramURL) {
/* 2804 */     if (paramURL == null)
/* 2805 */       return null;
/* 2806 */     if (!V2CMain.isOnlineMode()) {
/* 2807 */       logNotOnline(paramURL);
/* 2808 */       return null;
/*      */     }
/* 2810 */     InputStream localInputStream = null;
/* 2811 */     Thread localThread = Thread.currentThread();
/*      */     try {
/* 2813 */       HttpURLConnection localHttpURLConnection = 
/* 2814 */         V2CProxySetting.openReadConnection(paramURL);
/* 2815 */       setTimeout(localHttpURLConnection);
/* 2816 */       String str = paramURL.getHost();
/* 2817 */       localHttpURLConnection.setRequestProperty("Host", str);
/* 2818 */       localHttpURLConnection.setRequestProperty("Accept", "*/*");
/* 2819 */       localHttpURLConnection.setRequestProperty("Accept-Language", 
/* 2820 */         "ja,en;q=0.5");
/* 2821 */       localHttpURLConnection.setRequestProperty("User-Agent", 
/* 2822 */         "Mozilla/4.0 (compatible)");
/* 2823 */       V2CLogger.logHTTPHeaderFields(paramURL, "RedirectCheck Request:", 
/* 2824 */         localHttpURLConnection.getRequestProperties());
/* 2825 */       int i = localHttpURLConnection.getResponseCode();
/*      */       
/* 2827 */       if (localThread.isInterrupted()) {
/* 2828 */         logInterrupt(paramURL);
/* 2829 */         return null;
/*      */       }
/* 2831 */       logHTTPResponse(localHttpURLConnection, "RedirectCheck Response: ");
/* 2832 */       URL localURL1; if (isRedirect(i)) {
/* 2833 */         Object localObject1 = localHttpURLConnection
/* 2834 */           .getHeaderField("Location");
/* 2835 */         if (localObject1 != null)
/*      */           try {
/* 2837 */             localURL1 = new URL(paramURL, (String)localObject1);
/* 2838 */             return localURL1;
/*      */           } catch (MalformedURLException localMalformedURLException) {
/* 2840 */             System.out.println("u,loc: " + paramURL + "," + 
/* 2841 */               (String)localObject1);
/* 2842 */             URL localURL2 = null;
/* 2843 */             return localURL2;
/*      */           }
/*      */       }
/* 2846 */       if (i == 200) {
/* 2847 */         int j = Math.min(localHttpURLConnection.getContentLength(), 
/* 2848 */           10000);
/* 2849 */         if (j == 0) {
/* 2850 */           return null;
/*      */         }
/* 2852 */         if (j < 0)
/* 2853 */           j = 10000;
/* 2854 */         Object localObject2 = new byte[j];
/* 2855 */         localInputStream = localHttpURLConnection.getInputStream();
/* 2856 */         int k = 0;
/* 2857 */         int m = 0;
/*      */         try {
/* 2859 */           while ((k = localInputStream.read((byte[])localObject2, m, 
/* 2860 */             j - m)) >= 0) {
/* 2861 */             if (localThread.isInterrupted()) {
/* 2862 */               logInterrupt(paramURL);
/*      */               
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/* 2872 */               localInputStream.close();return null;
/*      */             }
/* 2865 */             if (k != 0) {
/* 2866 */               m += k;
/* 2867 */               if (m >= j)
/*      */                 break;
/*      */             }
/*      */           }
/*      */         } finally {
/* 2872 */           localInputStream.close(); } localInputStream.close();
/*      */         
/* 2874 */         if (m == 0) {
/* 2875 */           return null;
/*      */         }
/* 2877 */         if (m < j) {
/* 2878 */           byte[] localObject3 = new byte[m];
/* 2879 */           System.arraycopy(localObject2, 0, localObject3, 0, m);
/* 2880 */           localObject2 = localObject3;
/*      */         }
/* 2882 */         Object localObject3 = V2CMiscUtil.byteArrayToString(
/* 2883 */           (byte[])localObject2, null, 
/* 2884 */           localHttpURLConnection.getContentType());
/* 2885 */         if (localObject3 != null)
/*      */         {
/*      */ 
/*      */ 
/* 2889 */           if ((str.equals("url4.eu")) || (str.equals("om.ly")) || 
/* 2890 */             (str.equals("viigo.im")) || 
/* 2891 */             (str.equals("nxy.in"))) {
/* 2892 */             Matcher localMatcher = 
/* 2893 */               Pattern.compile(
/* 2894 */               "<iframe\\s[^>]*src=\"(https?://[!-~&&[^\">]]+)\"", 
/* 2895 */               2)
/* 2896 */               .matcher((CharSequence)localObject3);
/* 2897 */             if (localMatcher.find()) {
/* 2898 */               return new URL(localMatcher.group(1));
/*      */             }
/* 2900 */             if (str.equals("nxy.in")) {
/* 2901 */               Object localObject4 = 
/* 2902 */                 Pattern.compile(
/* 2903 */                 "Redirect\\('(https?://[!-~&&[^\">]]+)'", 
/* 2904 */                 2)
/* 2905 */                 .matcher(
/* 2906 */                 (CharSequence)localObject3);
/* 2907 */               if (((Matcher)localObject4).find()) {
/* 2908 */                 URL localURL3 = new URL(localMatcher.group(1));
/* 2909 */                 return localURL3;
/*      */               }
/*      */             }
/*      */           } else {
/* 2913 */             if (str.equals("i.s-a.cc")) {
/* 2914 */               Matcher localMatcher = Pattern.compile(
/* 2915 */                 "<iframe\\s[^>]*src=\"" + 
/* 2916 */                 paramURL.getPath() + 
/* 2917 */                 "\\?([!-~&&[^\">]]+)\"", 
/* 2918 */                 2)
/* 2919 */                 .matcher((CharSequence)localObject3);
/* 2920 */               if (!localMatcher.find()) {
/* 2921 */                 return null;
/*      */               }
/* 2923 */               Object localObject4 = Pattern.compile(
/* 2924 */                 "&utm_content=(http[^&]+)(?:&|$)").matcher(
/* 2925 */                 V2CResItem.replaceEscapes(localMatcher
/* 2926 */                 .group(1)));
/* 2927 */               if (!((Matcher)localObject4).find()) {
/* 2928 */                 URL localURL3 = null;
/* 2929 */                 return localURL3;
/*      */               }
/* 2931 */               URL localURL3 = new URL(URLDecoder.decode(
/* 2932 */                 ((Matcher)localObject4).group(1), "UTF-8"));
/* 2933 */               return localURL3;
/*      */             }
/* 2935 */             if (str.equals("shar.es")) {
/* 2936 */               Matcher localMatcher = 
/* 2937 */                 Pattern.compile(
/* 2938 */                 "window\\.='(https?://[!-~&&[^\"'>]]+)'", 
/* 2939 */                 2)
/* 2940 */                 .matcher(
/* 2941 */                 (CharSequence)localObject3);
/* 2942 */               if (localMatcher.find()) {
/* 2943 */                 return new URL(localMatcher.group(1));
/*      */               }
/* 2945 */             } else if (str.equals("p.tl")) {
/* 2946 */               Matcher localMatcher = 
/* 2947 */                 Pattern.compile(
/* 2948 */                 "\\bwindow\\.short_url *= *\"(https?://[!-~&&[^\"'>]]+)\"", 
/* 2949 */                 2)
/* 2950 */                 .matcher(
/* 2951 */                 (CharSequence)localObject3);
/* 2952 */               if (localMatcher.find())
/*      */               {
/* 2954 */                 if (localMatcher.group(1).equals(paramURL.toString())) {
/* 2955 */                   Object localObject4 = 
/* 2956 */                     Pattern.compile(
/* 2957 */                     "\\bwindow\\.long_url *= *\"(https?://[!-~&&[^\"'>]]+)\"", 
/* 2958 */                     2)
/* 2959 */                     .matcher(
/* 2960 */                     (CharSequence)localObject3);
/* 2961 */                   if (((Matcher)localObject4).find()) {
/* 2962 */                     URL localURL3 = new URL(
/* 2963 */                       ((Matcher)localObject4).group(1));
/* 2964 */                     return localURL3;
/*      */                   }
/*      */                 } }
/* 2967 */             } else if (str.equals("ll.ly")) {
/* 2968 */               Matcher localMatcher = 
/* 2969 */                 Pattern.compile(
/* 2970 */                 "<a\\s[^>]*href=\"([^\"]+\\.axfc\\.net/uploader/[^\"]+)\"", 
/* 2971 */                 2)
/* 2972 */                 .matcher(
/* 2973 */                 (CharSequence)localObject3);
/* 2974 */               if (localMatcher.find()) {
/* 2975 */                 return new URL(localMatcher.group(1));
/*      */               }
/* 2977 */               Object localObject4 = 
/* 2978 */                 Pattern.compile(
/* 2979 */                 "<h\\d>リンク先</h\\d>\\s*(?:<p>)?<a href=\"([^\"]+)\">")
/* 2980 */                 .matcher((CharSequence)localObject3);
/* 2981 */               if (((Matcher)localObject4).find()) {
/* 2982 */                 return new URL(
/* 2983 */                   ((Matcher)localObject4).group(1));
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/* 2989 */       localHttpURLConnection.disconnect();
/*      */     } catch (Exception localException) {
/* 2991 */       localException.printStackTrace();
/* 2992 */       V2CLogger.logError(paramURL, 
/* 2993 */         V2CMiscUtil.getMessage(localException), localException);
/* 2994 */       return null;
/*      */     } finally {
/* 2996 */       V2CProxySetting.resetReadProxy();
/* 2997 */       V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */     }
/* 2996 */     V2CProxySetting.resetReadProxy();
/* 2997 */     V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */     
/* 2999 */     return null;
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC postFormBG(String s, String s1, String s2, String s3, String s4, String s5)
/*      */   {
/* 3004 */     PostFormBG postformbg = new PostFormBG(s, s1, s2, s3, s4, s5);
/* 3005 */     return postformbg.start() ? postformbg.ccResult : null;
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC postForm(String s, String s1) {
/* 3009 */     return postForm(s, null, s1, null, null, false, null);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC postForm(String s, String s1, String s2, String s3) {
/* 3013 */     return postForm(s, s1, s2, s3, null, false, null);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC postForm(String s, String s1, HashMap hashmap) {
/* 3017 */     return postForm(s, null, s1, null, hashmap, false, null);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC postForm(String s, String s1, String s2, String s3, HashMap hashmap)
/*      */   {
/* 3022 */     return postForm(s, s1, s2, s3, hashmap, false, null);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC postForm(String paramString1, String paramString2, String paramString3, String paramString4, HashMap paramHashMap, boolean paramBoolean, V2CProxyItem paramV2CProxyItem)
/*      */   {
/* 3028 */     if (isLocalURL(paramString1))
/* 3029 */       return null;
/* 3030 */     if (!V2CMain.isOnlineMode()) {
/* 3031 */       logNotOnline(paramString1);
/* 3032 */       return new V2CHttpUtil.CAndC("Not Online");
/*      */     }
/* 3034 */     URL localURL = null;
/*      */     try {
/* 3036 */       localURL = new URL(paramString1);
/*      */     } catch (MalformedURLException localMalformedURLException) {
/* 3038 */       V2CMiscUtil.printMalformedURLException(localMalformedURLException);
/*      */     }
/* 3040 */     if (localURL == null) {
/* 3041 */       V2CLogger.logError(localURL, "URL for posting form is null");
/* 3042 */       return new V2CHttpUtil.CAndC("URL for posting form is null");
/*      */     }
/* 3044 */     int i = paramString4 == null ? 1 : 0;
/* 3045 */     InputStream localInputStream = null;
/* 3046 */     PrintWriter localPrintWriter = null;
/* 3047 */     BufferedReader localBufferedReader = null;
/* 3048 */     String str1 = null;
/* 3049 */     Object localObject1 = null;
/* 3050 */     HttpURLConnection localHttpURLConnection = null;
/* 3051 */     Thread localThread = Thread.currentThread();
/*      */     try {
/* 3053 */       if (paramBoolean) {
/* 3054 */         localHttpURLConnection = V2CProxySetting.openWriteConnection(
/* 3055 */           localURL, paramV2CProxyItem);
/*      */       } else
/* 3057 */         localHttpURLConnection = 
/* 3058 */           V2CProxySetting.openReadConnection(localURL);
/* 3059 */       setTimeout(localHttpURLConnection);
/* 3060 */       localHttpURLConnection.setRequestMethod("POST");
/* 3061 */       localHttpURLConnection.setDoOutput(true);
/* 3062 */       localHttpURLConnection.setUseCaches(false);
/* 3063 */       localHttpURLConnection.setAllowUserInteraction(false);
/* 3064 */       localHttpURLConnection.setRequestProperty("Host", 
/* 3065 */         localURL.getHost());
/* 3066 */       localHttpURLConnection.setRequestProperty("Accept", "*/*");
/* 3067 */       setUA(localHttpURLConnection, localURL);
/*      */       
/* 3069 */       if (paramString1.startsWith("https://www.googleapis.com/urlshortener/v1/url")) {
/* 3070 */         localHttpURLConnection.setRequestProperty("Content-Type", 
/* 3071 */           "application/json");
/*      */       } else
/* 3073 */         localHttpURLConnection.setRequestProperty("Content-Type", 
/* 3074 */           "application/x-www-form-urlencoded");
/* 3075 */       if (paramString2 != null)
/* 3076 */         localHttpURLConnection.setRequestProperty("Referer", 
/* 3077 */           paramString2);
/* 3078 */       if (i != 0)
/* 3079 */         localHttpURLConnection.setRequestProperty("Accept-Encoding", 
/* 3080 */           "gzip");
/* 3081 */       String str2 = V2CCookie.getCookie(localURL);
/* 3082 */       if (str2 != null) {
/* 3083 */         localHttpURLConnection.setRequestProperty("Cookie", str2);
/*      */       }
/* 3085 */       if (paramHashMap != null) {
/* 3086 */         Iterator localIterator = paramHashMap.keySet().iterator();
/* 3087 */         while (localIterator.hasNext()) {
/* 3088 */           String localObject2 = (String)localIterator.next();
/* 3089 */           localHttpURLConnection.setRequestProperty(
/* 3090 */             localObject2, 
/* 3091 */             (String)paramHashMap.get(localObject2));
/*      */         }
/*      */       }
/* 3094 */       V2CLogger.logHTTPHeaderFields(localURL, "PostForm Request:", 
/* 3095 */         localHttpURLConnection.getRequestProperties());
/* 3096 */       localPrintWriter = new PrintWriter(
/* 3097 */         localHttpURLConnection.getOutputStream());
/* 3098 */       if (localThread.isInterrupted()) {
/* 3099 */         logInterrupt(localURL);
/* 3100 */         return null;
/*      */       }
/* 3102 */       localPrintWriter.print(paramString3);
/* 3103 */       localPrintWriter.close();
/* 3104 */       localPrintWriter = null;
/* 3105 */       if (localThread.isInterrupted()) {
/* 3106 */         logInterrupt(localURL);
/* 3107 */         return null;
/*      */       }
/* 3109 */       Object localObject2 = localHttpURLConnection.getHeaderFields();
/*      */       
/*      */ 
/* 3112 */       if (((Map)localObject2).containsKey("Set-Cookie")) {
/* 3113 */         Object localObject3 = (List)((Map)localObject2).get("Set-Cookie");
/* 3114 */         for (int k = 0; k < ((List)localObject3).size(); k++)
/* 3115 */           V2CCookie.addCookie((String)((List)localObject3).get(k), 
/* 3116 */             localURL);
/*      */       }
/* 3118 */       logHTTPResponse(localHttpURLConnection, "PostForm Response: ");
/* 3119 */       localInputStream = localHttpURLConnection.getInputStream();
/*      */       
/* 3121 */       if (i != 0) {
/* 3122 */         Object localObject3 = localHttpURLConnection.getContentEncoding();
/* 3123 */         int k = (localObject3 != null) && 
/* 3124 */           (((String)localObject3).equals("gzip")) ? 1 : 0;
/* 3125 */         int m = localHttpURLConnection.getContentLength();
/* 3126 */         if (m == 0) {
/* 3127 */           localObject1 = new byte[0];
/*      */         } else {
/* 3129 */           int n = m > 0 ? 1 : 0;
/* 3130 */           if (n == 0)
/* 3131 */             m = nInitialContentLength;
/* 3132 */           localObject1 = new byte[m];
/* 3133 */           int i1 = 0;
/*      */           for (;;) {
/* 3135 */             int i2 = localInputStream.read((byte[])localObject1, 
/* 3136 */               i1, m - i1);
/* 3137 */             if (localThread.isInterrupted()) {
/* 3138 */               logInterrupt(localURL);
/* 3139 */               return null;
/*      */             }
/* 3141 */             if (i2 < 0)
/*      */               break;
/* 3143 */             i1 += i2;
/* 3144 */             if (i1 >= m) {
/* 3145 */               if ((n != 0) || (m >= nMaxContentLength))
/*      */                 break;
/* 3147 */               byte[] localObject5 = new byte[m * 2];
/* 3148 */               System.arraycopy(localObject1, 0, localObject5, 0, 
/* 3149 */                 m);
/* 3150 */               m = localObject5.length;
/* 3151 */               localObject1 = localObject5;
/*      */             }
/*      */           }
/* 3154 */           if (n == 0) {
/* 3155 */             if (i1 == m) {
/* 3156 */               return null;
/*      */             }
/* 3158 */             Object localObject4 = new byte[i1];
/* 3159 */             System.arraycopy(localObject1, 0, localObject4, 0, i1);
/* 3160 */             localObject1 = localObject4;
/*      */           }
/* 3162 */           if (k != 0)
/* 3163 */             localObject1 = 
/* 3164 */               V2CMiscUtil.unGZIP((byte[])localObject1);
/*      */         }
/*      */       } else {
/* 3167 */         Object localObject3 = new char[nBufLen];
/* 3168 */         StringBuilder sb = new StringBuilder();
/* 3169 */         localBufferedReader = new BufferedReader(new InputStreamReader(
/* 3170 */           localInputStream, paramString4));
/* 3171 */         int m; while ((m = localBufferedReader.read((char[])localObject3)) >= 0) {
/* 3172 */           if (m > 0)
/* 3173 */             sb.append((char[])localObject3, 0, m); }
/* 3174 */         str1 = sb.toString();
/*      */       }
/*      */     } catch (IOException localIOException) {
/* 3177 */       String str3 = V2CMiscUtil.getMessage(localIOException);
/* 3178 */       V2CLogger.logError(localURL, str3, localIOException);
/* 3179 */       V2CHttpUtil.CAndC localObject2 = new V2CHttpUtil.CAndC(
/* 3180 */         localIOException.getClass().getName() + ": " + str3, 
/* 3181 */         localHttpURLConnection, getErrorContents(
/* 3182 */         localHttpURLConnection, localURL));
/* 3183 */       return localObject2;
/*      */     } finally {
/* 3185 */       if (paramBoolean) {
/* 3186 */         V2CProxySetting.resetWriteProxy();
/*      */       } else {
/* 3188 */         V2CProxySetting.resetReadProxy();
/*      */       }
/* 3190 */       V2CLocalFileHandler.closeWriter(localPrintWriter);
/* 3191 */       V2CLocalFileHandler.closeReader(localBufferedReader);
/* 3192 */       V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */       try {
/* 3194 */         localInputStream.close();
/*      */       }
/*      */       catch (Exception localException5) {}
/*      */     }
/* 3185 */     if (paramBoolean) {
/* 3186 */       V2CProxySetting.resetWriteProxy();
/*      */     } else {
/* 3188 */       V2CProxySetting.resetReadProxy();
/*      */     }
/* 3190 */     V2CLocalFileHandler.closeWriter(localPrintWriter);
/* 3191 */     V2CLocalFileHandler.closeReader(localBufferedReader);
/* 3192 */     V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */     try {
/* 3194 */       localInputStream.close();
/*      */     }
/*      */     catch (Exception localException6) {}
/*      */     
/* 3198 */     return i != 0 ? new V2CHttpUtil.CAndC(localHttpURLConnection, 
/* 3199 */       (byte[])localObject1) : new V2CHttpUtil.CAndC(
/* 3200 */       localHttpURLConnection, str1);
/*      */   }
/*      */   
/*      */   private static byte[] getErrorContents(HttpURLConnection paramHttpURLConnection, URL paramURL)
/*      */   {
/* 3205 */     byte[] localObject1 = null;
/* 3206 */     InputStream localInputStream = null;
/*      */     try {
/* 3208 */       localInputStream = paramHttpURLConnection.getErrorStream();
/* 3209 */       if (localInputStream == null) {
/* 3210 */         return null;
/*      */       }
/* 3212 */       Object localObject2 = paramHttpURLConnection.getContentEncoding();
/* 3213 */       int i = (localObject2 != null) && 
/* 3214 */         (((String)localObject2).equals("gzip")) ? 1 : 0;
/* 3215 */       int j = paramHttpURLConnection.getContentLength();
/* 3216 */       if (j == 0) {
/* 3217 */         localObject1 = new byte[0];
/*      */       } else {
/* 3219 */         int k = j > 0 ? 1 : 0;
/* 3220 */         if (k == 0)
/* 3221 */           j = 65536;
/* 3222 */         localObject1 = new byte[j];
/* 3223 */         int m = 0;
/*      */         for (;;) {
/* 3225 */           int n = localInputStream.read(localObject1, m, j - 
/* 3226 */             m);
/* 3227 */           if (Thread.currentThread().isInterrupted()) {
/* 3228 */             logInterrupt(paramURL);
/* 3229 */             return null;
/*      */           }
/* 3231 */           if ((n < 0) || (m + n >= j))
/*      */             break;
/* 3233 */           m += n;
/*      */         }
/* 3235 */         if (k == 0) {
/* 3236 */           if (m == j) {
/* 3237 */             return null;
/*      */           }
/* 3239 */           byte[] arrayOfByte2 = new byte[m];
/* 3240 */           System.arraycopy(localObject1, 0, arrayOfByte2, 0, m);
/* 3241 */           localObject1 = arrayOfByte2;
/*      */         }
/* 3243 */         if (i != 0)
/* 3244 */           localObject1 = V2CMiscUtil.unGZIP(localObject1);
/*      */       }
/*      */     } catch (IOException localIOException) {
/* 3247 */       String str = V2CMiscUtil.getMessage(localIOException);
/* 3248 */       V2CLogger.logError(paramURL, str, localIOException);
/* 3249 */       return null;
/*      */     } finally {
/* 3251 */       V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */       try {
/* 3253 */         localInputStream.close();
/*      */       }
/*      */       catch (Exception localException4) {}
/*      */     }
/* 3251 */     V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */     try {
/* 3253 */       localInputStream.close();
/*      */     }
/*      */     catch (Exception localException5) {}
/*      */     
/* 3257 */     return localObject1;
/*      */   }
/*      */   
/*      */   static String encodeMIMEParameterValue(String s) {
/* 3261 */     if (s == null)
/* 3262 */       return null;
/* 3263 */     byte[] abyte0 = V2CJPConverter.getBytes(s, "UTF-8");
/* 3264 */     byte[] abyte1 = blToken;
/* 3265 */     StringBuilder sb = new StringBuilder();
/* 3266 */     for (int i = 0; i < abyte0.length; i++) {
/* 3267 */       byte byte0 = abyte0[i];
/* 3268 */       if ((byte0 > 0) && (abyte1[byte0] != 0)) {
/* 3269 */         sb.append((char)byte0);
/*      */       } else {
/* 3271 */         sb.append('%');
/* 3272 */         String s1 = "00" + 
/* 3273 */           Integer.toHexString(byte0 & 0xFF).toUpperCase();
/* 3274 */         sb.append(s1.substring(s1.length() - 2));
/*      */       }
/*      */     }
/*      */     
/* 3278 */     return sb.toString();
/*      */   }
/*      */   
/*      */   private static byte[] generateMultiPartBoundary() {
/* 3282 */     Random random = new Random(System.currentTimeMillis());
/* 3283 */     byte[] abyte0 = new byte[24];
/* 3284 */     for (int i = 0; i < abyte0.length; i++) {
/* 3285 */       int j = Math.abs(random.nextInt()) % 62;
/* 3286 */       if (j < 26) {
/* 3287 */         j += 65;
/* 3288 */       } else if (j < 52) {
/* 3289 */         j += 71;
/*      */       } else
/* 3291 */         j -= 4;
/* 3292 */       abyte0[i] = ((byte)j);
/*      */     }
/*      */     
/* 3295 */     return abyte0;
/*      */   }
/*      */   
/*      */   static String getMultiPartBoundary() {
/* 3299 */     return 
/* 3300 */       "---------------------------" + new String(generateMultiPartBoundary());
/*      */   }
/*      */   
/*      */   static String getMultiPartBoundary(String[] paramArrayOfString, byte[] paramArrayOfByte)
/*      */   {
/* 3305 */     byte[][] arrayOfByte = new byte[paramArrayOfString.length][];
/*      */     try {
/* 3307 */       for (int i = 0; i < paramArrayOfString.length; i++)
/* 3308 */         if (paramArrayOfString[i] != null)
/* 3309 */           arrayOfByte[i] = paramArrayOfString[i].getBytes("MS932");
/*      */     } catch (UnsupportedEncodingException localUnsupportedEncodingException) {
/* 3311 */       return null;
/*      */     }
/* 3313 */     byte[] arrayOfByte1 = null;
/* 3314 */     for (int j = 0; j < 100; j++) {
/* 3315 */       arrayOfByte1 = generateMultiPartBoundary();
/* 3316 */       for (int k = 0; k < arrayOfByte.length; k++)
/* 3317 */         if ((arrayOfByte[k] != null) && 
/* 3318 */           (containsByteArray(arrayOfByte[k], arrayOfByte1)))
/*      */           break;
/* 3320 */       if ((paramArrayOfByte == null) || 
/* 3321 */         (!containsByteArray(paramArrayOfByte, arrayOfByte1)))
/* 3322 */         return "---------------------------" + new String(arrayOfByte1);
/*      */     }
/* 3324 */     return null;
/*      */   }
/*      */   
/*      */   private static boolean containsByteArray(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*      */   {
/* 3329 */     int i = paramArrayOfByte2[0];
/* 3330 */     for (int j = paramArrayOfByte1.length - 
/* 3331 */           paramArrayOfByte2.length; 
/* 3331 */           j >= 0; j--)
/* 3332 */       if (paramArrayOfByte1[j] == i) {
/* 3333 */         for (int k = paramArrayOfByte2.length - 1; k > 0; k--)
/* 3334 */           if (paramArrayOfByte2[k] != paramArrayOfByte1[(j + k)])
/*      */             break;
/* 3336 */         return true;
/*      */       }
/* 3338 */     return false;
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC postMultiPartMessage(URL url, String referer, String boundary, byte[] arrayWriteByte, V2CProxyItem proxyitem, String encode)
/*      */   {
/* 3344 */     return postMultiPartMessage(url, referer, boundary, arrayWriteByte, 
/* 3345 */       proxyitem, encode, null);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC postMultiPartMessage(URL url, String referer, String boundary, byte[] arrayWriteByte, V2CProxyItem proxyitem, String encode, HashMap requestPropertyMap)
/*      */   {
/* 3351 */     if (url == null) {
/* 3352 */       V2CLogger.logError(url, "URL for posting is null");
/* 3353 */       return new V2CHttpUtil.CAndC("URL for posting is null");
/*      */     }
/* 3355 */     if (isLocalURL(url))
/* 3356 */       return null;
/* 3357 */     if (!V2CMain.isOnlineMode()) {
/* 3358 */       logNotOnline(url);
/* 3359 */       return new V2CHttpUtil.CAndC("Not Online");
/*      */     }
/* 3361 */     String str1 = url.getHost();
/* 3362 */     url = checkShitarabaURL(url);
/* 3363 */     char[] arrayOfChar = new char[nBufLen];
/* 3364 */     StringBuilder sb = new StringBuilder();
/* 3365 */     BufferedReader localBufferedReader = null;
/* 3366 */     HttpURLConnection localHttpURLConnection = null;
/* 3367 */     Thread localThread = Thread.currentThread();
/*      */     try {
/* 3369 */       localHttpURLConnection = V2CProxySetting.openWriteConnection(url, 
/* 3370 */         proxyitem);
/* 3371 */       setTimeout(localHttpURLConnection);
/* 3372 */       localHttpURLConnection.setRequestMethod("POST");
/* 3373 */       localHttpURLConnection.setDoOutput(true);
/* 3374 */       localHttpURLConnection.setUseCaches(false);
/* 3375 */       localHttpURLConnection.setAllowUserInteraction(false);
/* 3376 */       localHttpURLConnection.setRequestProperty("Host", str1);
/* 3377 */       localHttpURLConnection.setRequestProperty("Accept", "*/*");
/* 3378 */       if (str1.endsWith("ula.cc")) {
/* 3379 */         localHttpURLConnection.setRequestProperty("User-Agent", 
/* 3380 */           getUAName(false, true, true));
/*      */       } else
/* 3382 */         localHttpURLConnection.setRequestProperty("User-Agent", 
/* 3383 */           "Mozilla/4.0 (compatible)");
/* 3384 */       if (referer != null)
/* 3385 */         localHttpURLConnection.setRequestProperty("Referer", referer);
/* 3386 */       String str2 = V2CCookie.getCookie(url);
/* 3387 */       if (str2 != null)
/* 3388 */         localHttpURLConnection.setRequestProperty("Cookie", str2);
/* 3389 */       localHttpURLConnection.setRequestProperty("Content-Type", 
/* 3390 */         "multipart/form-data; boundary=" + boundary);
/*      */       
/* 3392 */       if (requestPropertyMap != null) {
/* 3393 */         Iterator localObject1 = requestPropertyMap.keySet().iterator();
/* 3394 */         while (localObject1.hasNext()) {
/* 3395 */           Object localObject2 = localObject1.next();
/* 3396 */           if ((localObject2 instanceof String)) {
/* 3397 */             Object localObject3 = requestPropertyMap
/* 3398 */               .get(localObject2);
/* 3399 */             if ((localObject3 instanceof String))
/* 3400 */               localHttpURLConnection.setRequestProperty(
/* 3401 */                 (String)localObject2, 
/* 3402 */                 (String)localObject3);
/*      */           }
/*      */         }
/*      */       }
/* 3406 */       V2CLogger.logHTTPHeaderFields(url, "MPPost Request:", 
/* 3407 */         localHttpURLConnection.getRequestProperties());
/* 3408 */       OutputStream localObject1 = localHttpURLConnection
/* 3409 */         .getOutputStream();
/* 3410 */       if (localThread.isInterrupted()) {
/* 3411 */         logInterrupt(url);
/* 3412 */         return null;
/*      */       }
/* 3414 */       localObject1.write(arrayWriteByte);
/* 3415 */       localObject1.close();
/* 3416 */       if (localThread.isInterrupted()) {
/* 3417 */         logInterrupt(url);
/* 3418 */         return null;
/*      */       }
/* 3420 */       Object localObject3 = localHttpURLConnection.getHeaderFields();
/* 3421 */       if (((Map)localObject3).containsKey("Set-Cookie")) {
/* 3422 */         List localList = (List)((Map)localObject3).get("Set-Cookie");
/* 3423 */         for (int k = 0; k < localList.size(); k++)
/* 3424 */           V2CCookie.addCookie((String)localList.get(k), url);
/*      */       }
/* 3426 */       logHTTPResponse(localHttpURLConnection, "MPPost Response: ");
/* 3427 */       localBufferedReader = new BufferedReader(new InputStreamReader(
/* 3428 */         localHttpURLConnection.getInputStream(), encode));
/*      */       int j;
/* 3430 */       while ((j = localBufferedReader.read(arrayOfChar)) >= 0) {
/* 3431 */         if (j > 0) {
/* 3432 */           sb.append(arrayOfChar, 0, j);
/*      */         }
/*      */       }
/*      */     } catch (IOException localIOException) {
/* 3436 */       Object localObject1 = V2CMiscUtil.getMessage(localIOException);
/* 3437 */       V2CLogger.logError(url, (String)localObject1, localIOException);
/* 3438 */       V2CHttpUtil.CAndC localV2CHttpUtil$CAndC = new V2CHttpUtil.CAndC(
/* 3439 */         localIOException.getClass().getName() + ": " + 
/* 3440 */         (String)localObject1, 
/* 3441 */         localHttpURLConnection, 
/* 3442 */         getErrorContents(localHttpURLConnection, url));
/* 3443 */       return localV2CHttpUtil$CAndC;
/*      */     } finally {
/* 3445 */       V2CProxySetting.resetWriteProxy();
/* 3446 */       V2CLocalFileHandler.closeReader(localBufferedReader);
/*      */     }
/* 3445 */     V2CProxySetting.resetWriteProxy();
/* 3446 */     V2CLocalFileHandler.closeReader(localBufferedReader);
/*      */     
/* 3448 */     String str3 = sb.toString();
/* 3449 */     return new V2CHttpUtil.CAndC(localHttpURLConnection, str3);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC getHTTPFileBG(String paramString1, String paramString2, String paramString3, String paramString4, long paramLong)
/*      */   {
/* 3455 */     return getHTTPFileBG(paramString1, null, paramString2, paramString3, 
/* 3456 */       paramString4, paramLong);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC getHTTPFileBG(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, long paramLong)
/*      */   {
/* 3462 */     GetHTTPFileBG localGetHTTPFileBG = new GetHTTPFileBG(paramString1, 
/* 3463 */       paramString2, paramString3, paramString4, paramString5, 
/* 3464 */       paramLong);
/* 3465 */     return localGetHTTPFileBG.start() ? localGetHTTPFileBG.ccResult : null;
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC getHTTPFileBG(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, long paramLong, int paramInt)
/*      */   {
/* 3471 */     GetHTTPFileBG localGetHTTPFileBG = new GetHTTPFileBG(paramString1, 
/* 3472 */       paramString2, paramString3, paramString4, paramString5, 
/* 3473 */       paramLong, paramInt);
/* 3474 */     return localGetHTTPFileBG.start() ? localGetHTTPFileBG.ccResult : null;
/*      */   }
/*      */   
/*      */   static String getHTMLFile(String paramString) {
/* 3478 */     return getHTMLFile(paramString, "MS932");
/*      */   }
/*      */   
/*      */   static String getHTMLFile(String paramString1, String paramString2) {
/* 3482 */     return getHTMLFile(paramString1, paramString2, 0);
/*      */   }
/*      */   
/*      */   static String getHTMLFile(String paramString1, String paramString2, int paramInt)
/*      */   {
/* 3487 */     V2CHttpUtil.CAndC localV2CHttpUtil$CAndC = getHTTPFile(paramString1, 
/* 3488 */       null, paramString2, "text/html", 0L, paramInt);
/* 3489 */     if (localV2CHttpUtil$CAndC != null)
/* 3490 */       return localV2CHttpUtil$CAndC.getContents();
/* 3491 */     return null;
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC getTextFile(String paramString) {
/* 3495 */     return getHTTPFile(paramString, null, "MS932", "text/plain", 0L);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC getTextFile(String paramString1, String paramString2)
/*      */   {
/* 3500 */     return getHTTPFile(paramString1, null, paramString2, "text/plain", 0L);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC getGenTextFile(String paramString1, String paramString2)
/*      */   {
/* 3505 */     return getHTTPFile(paramString1, null, paramString2, "text/", 0L);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC getHTTPFile(String url, String paramString2, String paramString3, String paramString4, long paramLong)
/*      */   {
/* 3510 */     return getHTTPFile(url, paramString2, paramString3, paramString4, 
/* 3511 */       paramLong, 0);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC getHTTPFile(String url, String paramString2, String paramString3, String paramString4, long paramLong, int paramInt)
/*      */   {
/* 3517 */     return getHTTPFile(url, paramString2, paramString3, paramString4, 
/* 3518 */       paramLong, paramInt, false);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC getHTTPFile(String url, String paramString2, String paramString3, String paramString4, long paramLong, int paramInt, boolean paramBoolean)
/*      */   {
/* 3524 */     if (isLocalURL(url))
/* 3525 */       return null;
/* 3526 */     if (!V2CMain.isOnlineMode()) {
/* 3527 */       logNotOnline(url);
/* 3528 */       return null;
/*      */     }
/* 3530 */     URL localURL = null;
/*      */     try {
/* 3532 */       localURL = new URL(url);
/*      */     } catch (MalformedURLException localMalformedURLException) {
/* 3534 */       V2CLogger.logError(url, 
/* 3535 */         V2CMiscUtil.getMessage(localMalformedURLException), 
/* 3536 */         localMalformedURLException);
/* 3537 */       V2CMiscUtil.printMalformedURLException(localMalformedURLException);
/* 3538 */       return null;
/*      */     }
/* 3540 */     localURL = checkShitarabaURL(localURL);
/* 3541 */     char[] arrayOfChar = new char[nBufLen];
/* 3542 */     StringBuilder sb = new StringBuilder();
/* 3543 */     InputStreamReader localInputStreamReader = null;
/* 3544 */     HttpURLConnection localHttpURLConnection = null;
/* 3545 */     Thread localThread = Thread.currentThread();
/* 3546 */     RemoteHost localRemoteHost = getRemoteHost(localURL);
/* 3547 */     localRemoteHost.start();
/*      */     
/* 3549 */     InputStream inStream = null;
/*      */     try {
/* 3551 */       if (localThread.isInterrupted()) {
/* 3552 */         logInterrupt(localURL);
/* 3553 */         return null;
/*      */       }
/* 3555 */       if (paramBoolean) {
/* 3556 */         localHttpURLConnection = 
/* 3557 */           V2CProxySetting.openWriteConnection(localURL);
/*      */       } else
/* 3559 */         localHttpURLConnection = 
/* 3560 */           V2CProxySetting.openReadConnection(localURL);
/* 3561 */       setTimeout(localHttpURLConnection);
/* 3562 */       localHttpURLConnection.setRequestProperty("Host", 
/* 3563 */         localURL.getHost());
/* 3564 */       localHttpURLConnection.setRequestProperty("Accept", "*/*");
/* 3565 */       setUA(localHttpURLConnection, localURL);
/* 3566 */       localHttpURLConnection.setRequestProperty("Accept-Language", 
/* 3567 */         "ja,en;q=0.5");
/* 3568 */       localHttpURLConnection
/* 3569 */         .setRequestProperty("Accept-Encoding", "gzip");
/* 3570 */       if (paramLong > 0L)
/* 3571 */         localHttpURLConnection.setIfModifiedSince(paramLong);
/* 3572 */       Object localObject1 = V2CCookie.getCookie(localURL);
/* 3573 */       if (localObject1 != null)
/* 3574 */         localHttpURLConnection.setRequestProperty("Cookie", 
/* 3575 */           (String)localObject1);
/* 3576 */       V2CLogger.logHTTPHeaderFields(localURL, "File Request:", 
/* 3577 */         localHttpURLConnection.getRequestProperties());
/* 3578 */       localRemoteHost.check();
/* 3579 */       int i = localHttpURLConnection.getResponseCode();
/* 3580 */       Object localObject2 = localHttpURLConnection.getHeaderFields();
/* 3581 */       if (((Map)localObject2).containsKey("Set-Cookie")) {
/* 3582 */         List localObject3 = 
/* 3583 */           (List)((Map)localObject2).get("Set-Cookie");
/* 3584 */         for (int j = 0; j < localObject3.size(); j++)
/* 3585 */           V2CCookie.addCookie((String)localObject3.get(j), 
/* 3586 */             localURL);
/*      */       }
/* 3588 */       if (localThread.isInterrupted()) {
/* 3589 */         logInterrupt(localURL);
/* 3590 */         return null;
/*      */       }
/* 3592 */       logHTTPResponse(localHttpURLConnection, "File Response: ");
/* 3593 */       V2CHttpUtil.CAndC localCAndC1; if ((i == 304) || (i == 404)) {
/* 3594 */         return new V2CHttpUtil.CAndC(localHttpURLConnection, 
/* 3595 */           (String) null);
/*      */       }
/*      */       
/* 3598 */       if ((isRedirect(i)) && (paramInt > 0)) {
/* 3599 */         paramInt--;
/* 3600 */         Object localObject3 = localHttpURLConnection
/* 3601 */           .getHeaderField("Location");
/* 3602 */         if (localObject3 == null) {
/* 3603 */           V2CHttpUtil.CAndC localV2CHttpUtil$CAndC = new V2CHttpUtil.CAndC(
/* 3604 */             "Response Code: " + i + " Locationが不明です。");
/* 3605 */           return localV2CHttpUtil$CAndC;
/*      */         }
/* 3607 */         V2CHttpUtil.CAndC localV2CHttpUtil$CAndC = getHTTPFile((String)localObject3, 
/* 3608 */           paramString2, paramString3, paramString4, paramLong, 
/* 3609 */           paramInt, paramBoolean);
/* 3610 */         return localV2CHttpUtil$CAndC;
/*      */       }
/* 3612 */       if (i != 200) {
/* 3613 */         return new V2CHttpUtil.CAndC("Response Code: " + i + " " + 
/* 3614 */           localHttpURLConnection.getResponseMessage());
/*      */       }
/* 3616 */       Object localObject3 = localHttpURLConnection.getContentType();
/* 3617 */       if ((paramString4 != null) && (
/* 3618 */         (localObject3 == null) || 
/*      */         
/* 3620 */         (!V2CMiscUtil.contentTypeStartsWith((String)localObject3, paramString4, false)))) {
/* 3621 */         V2CHttpUtil.CAndC localV2CHttpUtil$CAndC = null;
/* 3622 */         return localV2CHttpUtil$CAndC;
/*      */       }
/* 3624 */       int k = localHttpURLConnection.getContentLength();
/* 3625 */       if (k > 0)
/* 3626 */         sb.ensureCapacity(k);
/* 3627 */       inStream = localHttpURLConnection.getInputStream();
/* 3628 */       String str3 = localHttpURLConnection.getContentEncoding();
/* 3629 */       if ((str3 != null) && (str3.equals("gzip"))) {
/* 3630 */         inStream = new GZIPInputStream(inStream);
/*      */       }
/* 3632 */       if (paramString3 == null) {
/* 3633 */         if (localObject3 != null) {
/* 3634 */           Matcher localMatcher = Pattern.compile(
/* 3635 */             "text/(?:plain|html);charset=([\\w-]+)").matcher(
/* 3636 */             (CharSequence)localObject3);
/* 3637 */           if (localMatcher.matches()) {
/* 3638 */             String str4 = localMatcher.group(1);
/* 3639 */             if (str4.equals("utf-8")) {
/* 3640 */               paramString3 = "UTF-8";
/* 3641 */             } else if (str4.equals("euc-jp"))
/* 3642 */               paramString3 = "EUC-JP";
/*      */           }
/*      */         }
/* 3645 */         if (paramString3 == null)
/* 3646 */           paramString3 = "MS932";
/*      */       }
/* 3648 */       localInputStreamReader = new InputStreamReader(
/* 3649 */         inStream, paramString3);
/*      */       for (;;) {
/* 3651 */         localRemoteHost.check();
/* 3652 */         int m = localInputStreamReader.read(arrayOfChar);
/* 3653 */         if (localThread.isInterrupted()) {
/* 3654 */           logInterrupt(localURL);
/* 3655 */           return null;
/*      */         }
/* 3657 */         if (m < 0)
/*      */           break;
/* 3659 */         if (m > 0) {
/* 3660 */           sb.append(arrayOfChar, 0, m);
/*      */         }
/*      */       }
/*      */       
/*      */ 
/*      */       String str2;
/*      */       
/*      */ 
/*      */       
/*      */ 
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 3663 */       String str2 = V2CMiscUtil.getMessage(localIOException);
/* 3664 */       V2CLogger.logError(localURL, str2, localIOException);
/* 3665 */       return new V2CHttpUtil.CAndC(localIOException.getClass().getName() + 
/* 3666 */         ": " + str2);
/*      */     } catch (Exception exception) {
/* 3668 */       String str2 = V2CMiscUtil.getMessage(exception);
/* 3669 */       V2CLogger.logError(localURL, str2, exception);
/*      */     } finally {
/* 3671 */       if (paramBoolean) {
/* 3672 */         V2CProxySetting.resetWriteProxy();
/*      */       } else {
/* 3674 */         V2CProxySetting.resetReadProxy();
/*      */       }
/* 3676 */       localRemoteHost.finished();
/* 3677 */       V2CLocalFileHandler.closeInputStream(inStream);
/* 3678 */       V2CLocalFileHandler.closeReader(localInputStreamReader);
/*      */     }
/*      */     
/* 3680 */     String str1 = sb.toString();
/* 3681 */     return new V2CHttpUtil.CAndC(localHttpURLConnection, str1);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC getRawTextFile(String paramString) {
/* 3685 */     return getRawHTTPFile(paramString, null, "text/plain", 0L, null, 0, 
/* 3686 */       null);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC getRawTextFile(boolean isReadCGImode, String paramString, HashMap paramHashMap)
/*      */   {
/* 3691 */     setReadcgiMode(isReadCGImode);
/*      */     
/* 3693 */     if ((isReadCGImode) || (!useV2crEngine)) {
/* 3694 */       return getRawHTTPFile(paramString, null, "text/plain", 0L, null, 0, 
/* 3695 */         paramHashMap);
/*      */     }
/* 3697 */     return V2CHttpUtil.getRawTextFile(paramString, paramHashMap);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC getRawTextFile(String paramString, long paramLong)
/*      */   {
/* 3702 */     return getRawHTTPFile(paramString, null, "text/plain", paramLong, null, 
/* 3703 */       0, null);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC getRawTextFile(String paramString1, long paramLong, String paramString2)
/*      */   {
/* 3708 */     return getRawHTTPFile(paramString1, null, "text/plain", paramLong, 
/* 3709 */       paramString2, 0, null);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC getRawHTTPFile(boolean isReadCGImode, String paramString)
/*      */   {
/* 3714 */     setReadcgiMode(isReadCGImode);
/*      */     
/* 3716 */     if ((isReadCGImode) || (!useV2crEngine)) {
/* 3717 */       return getRawHTTPFile(paramString, null, null, 0L, null, 0, null);
/*      */     }
/* 3719 */     return V2CHttpUtil.getRawHTTPFile(paramString);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC getRawHTTPFile(String paramString, int paramInt, HashMap paramHashMap)
/*      */   {
/* 3725 */     return getRawHTTPFile(paramString, null, null, 0L, null, paramInt, 
/* 3726 */       paramHashMap);
/*      */   }
/*      */   
/*      */   static V2CHttpUtil.CAndC getRawHTTPFile(String paramString1, String paramString2, long paramLong)
/*      */   {
/* 3731 */     return getRawHTTPFile(paramString1, null, paramString2, paramLong, 
/* 3732 */       null, 0, null);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC getRawHTTPFile(boolean isReadCGImode, String paramString1, String paramString2, long paramLong, int paramInt)
/*      */   {
/* 3738 */     setReadcgiMode(isReadCGImode);
/*      */     
/* 3740 */     if ((isReadCGImode) || (!useV2crEngine)) {
/* 3741 */       return getRawHTTPFile(paramString1, null, paramString2, paramLong, 
/* 3742 */         null, paramInt, null);
/*      */     }
/* 3744 */     return V2CHttpUtil.getRawHTTPFile(paramString1, paramString2, 
/* 3745 */       paramLong, paramInt);
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */   static V2CHttpUtil.CAndC getRawHTTPFile(String paramString1, String paramString2, long paramLong, String paramString3, int paramInt)
/*      */   {
/* 3752 */     return getRawHTTPFile(paramString1, null, paramString2, paramLong, 
/* 3753 */       paramString3, paramInt, null);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC getRawHTTPFile(String paramString1, String paramString2, String paramString3, long paramLong, String paramString4, int paramInt)
/*      */   {
/* 3759 */     return getRawHTTPFile(paramString1, paramString2, paramString3, 
/* 3760 */       paramLong, paramString4, paramInt, null);
/*      */   }
/*      */   
/*      */ 
/*      */   static V2CHttpUtil.CAndC getRawHTTPFile(String paramString1, String paramString2, String paramString3, long paramLong, String paramString4, int paramInt, HashMap paramHashMap)
/*      */   {
/* 3766 */     if (isLocalURL(paramString1))
/* 3767 */       return null;
/* 3768 */     if (!V2CMain.isOnlineMode()) {
/* 3769 */       logNotOnline(paramString1);
/* 3770 */       return null;
/*      */     }
/* 3772 */     URL localURL = null;
/*      */     try {
/* 3774 */       localURL = new URL(paramString1);
/*      */     } catch (MalformedURLException localMalformedURLException1) {
/* 3776 */       V2CLogger.logError(paramString1, 
/* 3777 */         V2CMiscUtil.getMessage(localMalformedURLException1), 
/* 3778 */         localMalformedURLException1);
/* 3779 */       V2CMiscUtil.printMalformedURLException(localMalformedURLException1);
/* 3780 */       return null;
/*      */     }
/* 3782 */     localURL = checkShitarabaURL(localURL);
/* 3783 */     Object localObject1 = null;
/* 3784 */     InputStream localInputStream = null;
/* 3785 */     HttpURLConnection localHttpURLConnection = null;
/* 3786 */     Thread localThread = Thread.currentThread();
/* 3787 */     RemoteHost localRemoteHost = getRemoteHost(localURL);
/* 3788 */     localRemoteHost.start();
/*      */     try {
/* 3790 */       if (localThread.isInterrupted()) {
/* 3791 */         logInterrupt(localURL);
/* 3792 */         return null;
/*      */       }
/* 3794 */       localHttpURLConnection = 
/* 3795 */         V2CProxySetting.openReadConnection(localURL);
/* 3796 */       setTimeout(localHttpURLConnection);
/* 3797 */       localHttpURLConnection.setRequestProperty("Host", 
/* 3798 */         localURL.getHost());
/* 3799 */       localHttpURLConnection.setRequestProperty("Accept", "*/*");
/* 3800 */       setUA(localHttpURLConnection, localURL);
/* 3801 */       if (paramString2 != null) {
/* 3802 */         localHttpURLConnection.setRequestProperty("Referer", 
/* 3803 */           paramString2);
/*      */       }
/* 3805 */       localHttpURLConnection.setRequestProperty("Accept-Language", 
/* 3806 */         "ja,en;q=0.5");
/* 3807 */       localHttpURLConnection
/* 3808 */         .setRequestProperty("Accept-Encoding", "gzip");
/* 3809 */       if (paramLong > 0L)
/* 3810 */         localHttpURLConnection.setIfModifiedSince(paramLong);
/* 3811 */       if ((paramString4 != null) && (paramString4.length() > 0))
/* 3812 */         localHttpURLConnection.setRequestProperty("If-None-Match", 
/* 3813 */           paramString4);
/* 3814 */       Object localObject2 = V2CCookie.getCookie(localURL);
/* 3815 */       if (localObject2 != null)
/* 3816 */         localHttpURLConnection.setRequestProperty("Cookie", 
/* 3817 */           (String)localObject2);
/* 3818 */       int i = 0;
/*      */       
/* 3820 */       if (paramHashMap != null) {
/* 3821 */         Iterator localIterator = paramHashMap.keySet().iterator();
/* 3822 */         while (localIterator.hasNext()) {
/* 3823 */           Object localObject3 = localIterator.next();
/* 3824 */           Object localObject4 = paramHashMap.get(localObject3);
/* 3825 */           if ((localObject3 instanceof String)) {
/* 3826 */             if ((localObject4 instanceof String))
/* 3827 */               localHttpURLConnection.setRequestProperty(
/* 3828 */                 (String)localObject3, 
/* 3829 */                 (String)localObject4);
/* 3830 */           } else if ((localObject3 instanceof Character)) {
/* 3831 */             int k = ((Character)localObject3).charValue();
/* 3832 */             if ((k == 77) && 
/* 3833 */               (V2CMiscUtil.isEqual(localObject4, "HEAD"))) {
/* 3834 */               localHttpURLConnection.setRequestMethod("HEAD");
/* 3835 */               i = 1;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/* 3840 */       V2CLogger.logHTTPHeaderFields(localURL, "RawFile Request:", 
/* 3841 */         localHttpURLConnection.getRequestProperties());
/* 3842 */       localRemoteHost.check();
/* 3843 */       int j = localHttpURLConnection.getResponseCode();
/* 3844 */       if (localThread.isInterrupted()) {
/* 3845 */         logInterrupt(localURL);
/* 3846 */         return null;
/*      */       }
/* 3848 */       if (i != 0) {
/* 3849 */         logHTTPResponse(localHttpURLConnection, "HEAD Response: ");
/* 3850 */         return new V2CHttpUtil.CAndC(localHttpURLConnection, 
/* 3851 */           new byte[0]);
/*      */       }
/* 3853 */       Object localObject3 = localHttpURLConnection.getHeaderFields();
/* 3854 */       if (((Map)localObject3).containsKey("Set-Cookie")) {
/* 3855 */         List localObject4 = 
/* 3856 */           (List)((Map)localObject3).get("Set-Cookie");
/* 3857 */         for (int k = 0; k < localObject4.size(); k++)
/* 3858 */           V2CCookie.addCookie((String)localObject4.get(k), 
/* 3859 */             localURL);
/*      */       }
/* 3861 */       if (localThread.isInterrupted()) {
/* 3862 */         logInterrupt(localURL);
/* 3863 */         return null;
/*      */       }
/* 3865 */       logHTTPResponse(localHttpURLConnection, "RawFile Response: ");
/* 3866 */       if ((isRedirect(j)) && (paramInt > 0)) {
/* 3867 */         paramInt--;
/* 3868 */         Object localObject4 = localHttpURLConnection
/* 3869 */           .getHeaderField("Location");
/* 3870 */         if (localObject4 == null) {
/* 3871 */           return null;
/*      */         }
/* 3873 */         URL localObject5 = null;
/*      */         try {
/* 3875 */           localObject5 = new URL(localURL, (String)localObject4);
/*      */         } catch (MalformedURLException localMalformedURLException2) {
/* 3877 */           V2CHttpUtil.CAndC localV2CHttpUtil$CAndC3 = null;
/* 3878 */           return localV2CHttpUtil$CAndC3;
/*      */         }
/* 3880 */         V2CHttpUtil.CAndC localV2CHttpUtil$CAndC2 = getRawHTTPFile(
/* 3881 */           localObject5.toExternalForm(), paramString2, 
/* 3882 */           paramString3, paramLong, paramString4, paramInt, 
/* 3883 */           paramHashMap);
/* 3884 */         return localV2CHttpUtil$CAndC2;
/*      */       }
/* 3886 */       if ((j == 302) || (j == 304) || (j == 404)) {
/* 3887 */         return new V2CHttpUtil.CAndC(localHttpURLConnection);
/*      */       }
/* 3889 */       if ((j == 401) && (paramString1.indexOf("twitter.com/") > 0)) {
/* 3890 */         return new V2CHttpUtil.CAndC("Response Code: " + 
/* 3891 */           localHttpURLConnection.getResponseCode() + " " + 
/* 3892 */           localHttpURLConnection.getResponseMessage(), 
/* 3893 */           localHttpURLConnection);
/*      */       }
/* 3895 */       if ((j != 200) && 
/* 3896 */         (j != 203) && (
/* 3897 */         (paramString1.indexOf("twitter.com/") <= 0) || (j < 400))) {
/* 3898 */         return new V2CHttpUtil.CAndC("Response Code: " + 
/* 3899 */           localHttpURLConnection.getResponseCode() + " " + 
/* 3900 */           localHttpURLConnection.getResponseMessage());
/*      */       }
/* 3902 */       Object localObject4 = localHttpURLConnection.getContentType();
/* 3903 */       if (localObject4 != null) {
/* 3904 */         if (paramString3 != null)
/*      */         {
/* 3906 */           if (V2CMiscUtil.contentTypeStartsWith((String)localObject4, paramString3, false)) {} }
/* 3907 */       } else { return null;
/*      */       }
/* 3909 */       localInputStream = localHttpURLConnection.getInputStream();
/* 3910 */       Object localObject5 = localHttpURLConnection.getContentEncoding();
/* 3911 */       int m = (localObject5 != null) && 
/* 3912 */         (((String)localObject5).equals("gzip")) ? 1 : 0;
/* 3913 */       int n = localHttpURLConnection.getContentLength();
/* 3914 */       if (n == 0) {
/* 3915 */         localObject1 = new byte[0];
/*      */       } else {
/* 3917 */         int i1 = n > 0 ? 1 : 0;
/* 3918 */         if (i1 == 0)
/* 3919 */           n = nInitialContentLength;
/* 3920 */         localObject1 = new byte[n];
/* 3921 */         int i2 = 0;
/*      */         for (;;) {
/* 3923 */           localRemoteHost.check();
/* 3924 */           int i3 = localInputStream.read((byte[])localObject1, i2, n - 
/* 3925 */             i2);
/* 3926 */           if (localThread.isInterrupted()) {
/* 3927 */             logInterrupt(localURL);
/* 3928 */             return null;
/*      */           }
/* 3930 */           if (i3 < 0)
/*      */             break;
/* 3932 */           i2 += i3;
/* 3933 */           if (i2 >= n) {
/* 3934 */             if ((i1 != 0) || (n >= nMaxContentLength))
/*      */               break;
/* 3936 */             byte[] localObject7 = new byte[n * 2];
/* 3937 */             System.arraycopy(localObject1, 0, localObject7, 0, n);
/* 3938 */             n = localObject7.length;
/* 3939 */             localObject1 = localObject7;
/*      */           }
/*      */         }
/* 3942 */         if (i1 == 0) {
/* 3943 */           if (i2 == n) {
/* 3944 */             return null;
/*      */           }
/* 3946 */           Object localObject6 = new byte[i2];
/* 3947 */           System.arraycopy(localObject1, 0, localObject6, 0, i2);
/* 3948 */           localObject1 = localObject6;
/*      */         }
/* 3950 */         if (m != 0)
/* 3951 */           localObject1 = V2CMiscUtil.unGZIP((byte[])localObject1);
/*      */       }
/*      */     } catch (IOException localIOException) { V2CHttpUtil.CAndC localCAndC1;
/* 3954 */       String str = V2CMiscUtil.getMessage(localIOException);
/* 3955 */       V2CLogger.logError(localURL, str, localIOException);
/* 3956 */       V2CHttpUtil.CAndC localV2CHttpUtil$CAndC1 = new V2CHttpUtil.CAndC(
/* 3957 */         localIOException.getClass().getName() + ": " + str, 
/* 3958 */         localHttpURLConnection, getErrorContents(
/* 3959 */         localHttpURLConnection, localURL));
/* 3960 */       return localV2CHttpUtil$CAndC1;
/*      */     } finally {
/* 3962 */       V2CProxySetting.resetReadProxy();
/* 3963 */       localRemoteHost.finished();
/* 3964 */       V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */       try {
/* 3966 */         localInputStream.close();
/*      */       }
/*      */       catch (Exception localException14) {}
/*      */     }
/* 3962 */     V2CProxySetting.resetReadProxy();
/* 3963 */     localRemoteHost.finished();
/* 3964 */     V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */     try {
/* 3966 */       localInputStream.close();
/*      */     }
/*      */     catch (Exception localException15) {}
/*      */     
/* 3970 */     return new V2CHttpUtil.CAndC(localHttpURLConnection, 
/* 3971 */       (byte[])localObject1);
/*      */   }
/*      */   
/*      */   static HTMLDocument getHTMLDocument(String paramString) {
/* 3975 */     return getHTMLDocument(paramString, "MS932");
/*      */   }
/*      */   
/*      */   static HTMLDocument getHTMLDocument(String paramString1, String paramString2) {
/* 3979 */     String str = getHTMLFile(paramString1, paramString2);
/* 3980 */     if (str == null)
/* 3981 */       return null;
/* 3982 */     return parseHTMLDocument(str);
/*      */   }
/*      */   
/*      */   static HTMLDocument parseHTMLDocument(String paramString) {
/* 3986 */     StringReader localStringReader = new StringReader(paramString);
/* 3987 */     HTMLEditorKit localHTMLEditorKit = new HTMLEditorKit();
/* 3988 */     HTMLDocument localHTMLDocument = (HTMLDocument)localHTMLEditorKit
/* 3989 */       .createDefaultDocument();
/* 3990 */     localHTMLDocument.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
/*      */     try {
/* 3992 */       localHTMLEditorKit.read(localStringReader, localHTMLDocument, 0);
/*      */     } catch (IOException localIOException) {
/* 3994 */       System.out.println(localIOException);
/* 3995 */       localIOException.printStackTrace();
/* 3996 */       return null;
/*      */     } catch (BadLocationException localBadLocationException) {
/* 3998 */       System.out.println(localBadLocationException);
/* 3999 */       localBadLocationException.printStackTrace();
/* 4000 */       return null;
/*      */     }
/* 4002 */     return localHTMLDocument;
/*      */   }
/*      */   
/*      */   static String downloadFile(String paramString, int paramInt, V2CDownloader paramV2CDownloader)
/*      */   {
/* 4007 */     if (!V2CMain.isOnlineMode()) {
/* 4008 */       logNotOnline(paramString);
/* 4009 */       return "オンラインではありません。";
/*      */     }
/* 4011 */     URL localURL = null;
/*      */     try {
/* 4013 */       localURL = new URL(paramString);
/*      */     } catch (MalformedURLException localMalformedURLException1) {
/* 4015 */       V2CLogger.logError(paramString, 
/* 4016 */         V2CMiscUtil.getMessage(localMalformedURLException1), 
/* 4017 */         localMalformedURLException1);
/* 4018 */       V2CMiscUtil.printMalformedURLException(localMalformedURLException1);
/* 4019 */       return "不正なURLです。";
/*      */     }
/* 4021 */     InputStream localInputStream = null;
/* 4022 */     HttpURLConnection localHttpURLConnection = null;
/* 4023 */     Thread localThread = Thread.currentThread();
/* 4024 */     if (localThread.isInterrupted()) {
/* 4025 */       logInterrupt(localURL);
/* 4026 */       return null;
/*      */     }
/*      */     try {
/* 4029 */       localHttpURLConnection = 
/* 4030 */         V2CProxySetting.openReadConnection(localURL);
/* 4031 */       setTimeout(localHttpURLConnection);
/* 4032 */       localHttpURLConnection.setRequestProperty("Host", 
/* 4033 */         localURL.getHost());
/* 4034 */       localHttpURLConnection.setRequestProperty("Accept", "*/*");
/* 4035 */       localHttpURLConnection
/* 4036 */         .setRequestProperty("Accept-Encoding", "gzip");
/* 4037 */       setUA(localHttpURLConnection, localURL);
/* 4038 */       String str1 = V2CCookie.getCookie(localURL);
/* 4039 */       if (str1 != null)
/* 4040 */         localHttpURLConnection.setRequestProperty("Cookie", str1);
/* 4041 */       V2CLogger.logHTTPHeaderFields(localURL, "Download Request:", 
/* 4042 */         localHttpURLConnection.getRequestProperties());
/* 4043 */       localInputStream = localHttpURLConnection.getInputStream();
/* 4044 */       int i = localHttpURLConnection.getResponseCode();
/*      */       
/* 4046 */       if (localThread.isInterrupted()) {
/* 4047 */         logInterrupt(localURL);
/* 4048 */         String str3 = null;
/* 4049 */         return str3;
/*      */       }
/* 4051 */       logHTTPResponse(localHttpURLConnection, "Download Response: ");
/* 4052 */       if ((isRedirect(i)) && (paramInt > 0)) {
/* 4053 */         paramInt--;
/* 4054 */         String str3 = localHttpURLConnection.getHeaderField("Location");
/* 4055 */         if (str3 == null) {
/* 4056 */           return "Locationが不明です。";
/*      */         }
/*      */         try {
/* 4059 */           localURL = new URL(localURL, str3);
/*      */         } catch (MalformedURLException localMalformedURLException2) {
/* 4061 */           return "不正なURLです。";
/*      */         }
/* 4063 */         return downloadFile(str3, paramInt, paramV2CDownloader);
/*      */       }
/* 4065 */       if (!paramV2CDownloader.setHeaderFields(localHttpURLConnection)) {
/* 4066 */         return null;
/*      */       }
/* 4068 */       int j = localHttpURLConnection.getContentLength();
/* 4069 */       if (j == 0) {
/* 4070 */         return null;
/*      */       }
/* 4072 */       int k = (j > 0) && (j < 2048) ? j : 2048;
/* 4073 */       Object localObject2 = new byte[k];
/* 4074 */       int m = 0;
/*      */       do {
/* 4076 */         int n = localInputStream.read((byte[])localObject2);
/* 4077 */         if (localThread.isInterrupted()) {
/* 4078 */           logInterrupt(localURL);
/* 4079 */           return null;
/*      */         }
/* 4081 */         if (n < 0)
/*      */           break;
/* 4083 */         if (n > 0) {
/* 4084 */           m += n;
/*      */           
/* 4086 */           if (!paramV2CDownloader.appendBytes((byte[])localObject2, n, m)) {
/* 4087 */             return null;
/*      */           }
/*      */         }
/* 4090 */       } while ((j <= 0) || (m < j));
/*      */     }
/*      */     catch (IOException localIOException) {
/*      */       String str1;
/* 4094 */       String str2 = V2CMiscUtil.getMessage(localIOException);
/* 4095 */       V2CLogger.logError(localURL, str2, localIOException);
/* 4096 */       String str4 = str2;
/* 4097 */       return str4;
/*      */     } finally {
/* 4099 */       V2CProxySetting.resetReadProxy();
/* 4100 */       V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */       try {
/* 4102 */         localInputStream.close();
/*      */       }
/*      */       catch (Exception localException9) {}
/*      */     }
/* 4099 */     V2CProxySetting.resetReadProxy();
/* 4100 */     V2CLocalFileHandler.closeInputStream(localInputStream);
/*      */     try {
/* 4102 */       localInputStream.close();
/*      */     }
/*      */     catch (Exception localException10) {}
/*      */     
/* 4106 */     return null;
/*      */   }
/*      */   
/*      */   static boolean isOAuthTimeOffsetChanged(long paramLong) {
/* 4110 */     return Math.abs(nOAuthTimeOffset - paramLong) > 120000L;
/*      */   }
/*      */   
/*      */   static String constructQuery(HashMap paramHashMap) {
/* 4114 */     if ((paramHashMap == null) || (paramHashMap.size() == 0))
/* 4115 */       return null;
/* 4116 */     StringBuilder sb = new StringBuilder();
/* 4117 */     Iterator localIterator = paramHashMap.keySet().iterator();
/* 4118 */     while (localIterator.hasNext()) {
/* 4119 */       String str = (String)localIterator.next();
/* 4120 */       sb.append(str);
/* 4121 */       sb.append('=');
/* 4122 */       sb.append((String)paramHashMap.get(str));
/* 4123 */       sb.append('&');
/*      */     }
/* 4125 */     int i = sb.length();
/* 4126 */     return i > 0 ? sb.substring(0, i - 1) : null;
/*      */   }
/*      */   
/*      */   static HashMap splitQuery(String paramString) {
/* 4130 */     HashMap localHashMap = new HashMap();
/* 4131 */     if ((paramString != null) && (paramString.length() > 0)) {
/* 4132 */       if (paramString.charAt(0) == '?')
/* 4133 */         paramString = paramString.substring(1);
/* 4134 */       String[] arrayOfString = V2CMiscUtil.split(paramString, '&', true);
/* 4135 */       if (arrayOfString != null)
/* 4136 */         for (int i = 0; i < arrayOfString.length; i++) {
/* 4137 */           String str = arrayOfString[i];
/* 4138 */           int j = str.indexOf('=');
/* 4139 */           if (j > 0)
/* 4140 */             localHashMap.put(str.substring(0, j), 
/* 4141 */               str.substring(j + 1));
/*      */         }
/*      */     }
/* 4144 */     return localHashMap;
/*      */   }
/*      */   
/*      */   static void checkOAuthTimeOffset(V2CHttpUtil.CAndC paramV2CHttpUtilCAndC, long paramLong1, long paramLong2)
/*      */   {
/* 4149 */     if ((paramV2CHttpUtilCAndC == null) || (paramLong1 <= 0L) || 
/* 4150 */       (paramLong2 <= paramLong1) || 
/* 4151 */       (paramLong1 + 30000L <= paramLong2))
/* 4152 */       return;
/* 4153 */     HttpURLConnection localHttpURLConnection = paramV2CHttpUtilCAndC
/* 4154 */       .getConnection();
/* 4155 */     if (localHttpURLConnection == null)
/* 4156 */       return;
/* 4157 */     long l = localHttpURLConnection.getDate();
/* 4158 */     if (l > 0L)
/* 4159 */       nOAuthTimeOffset = l - (2L * paramLong1 + paramLong2) / 3L;
/*      */   }
/*      */   
/*      */   static boolean getOAuthRequestToken(V2CTwitterUser paramV2CTwitterUser) {
/* 4163 */     String str1 = V2CTwitterBBS.getOAuthConsumerKey();
/* 4164 */     String str2 = V2CTwitterBBS.getOAuthConsumerSecret();
/* 4165 */     if ((str1 == null) || (str2 == null))
/* 4166 */       return false;
/* 4167 */     String str3 = "oauth_consumer_key=" + str1 + "&oauth_nonce=" + 
/* 4168 */       createNonce() + 
/* 4169 */       "&oauth_signature_method=HMAC-SHA1&oauth_timestamp=" + 
/* 4170 */       (System.currentTimeMillis() + nOAuthTimeOffset) / 1000L + 
/* 4171 */       "&oauth_version=1.0";
/* 4172 */     String str4 = "GET&" + oauthURLEncode(sRequestTokenURL) + '&' + 
/* 4173 */       oauthURLEncode(str3);
/* 4174 */     String str5 = calcAndEncodeSignature(str4, "");
/* 4175 */     if (str5 == null)
/* 4176 */       return false;
/* 4177 */     String str6 = sRequestTokenURL + '?' + str3 + "&oauth_signature=" + 
/* 4178 */       str5;
/* 4179 */     long l1 = System.currentTimeMillis();
/* 4180 */     V2CHttpUtil.CAndC localV2CHttpUtil$CAndC1 = getRawHTTPFile(str6, 0, 
/* 4181 */       null);
/* 4182 */     long l2 = System.currentTimeMillis();
/* 4183 */     checkOAuthTimeOffset(localV2CHttpUtil$CAndC1, l1, l2);
/* 4184 */     if ((localV2CHttpUtil$CAndC1 == null) || 
/* 4185 */       (localV2CHttpUtil$CAndC1.getResponseCode() != 200))
/* 4186 */       return false;
/* 4187 */     byte[] arrayOfByte1 = localV2CHttpUtil$CAndC1.getRawContents();
/* 4188 */     if (arrayOfByte1 == null)
/* 4189 */       return false;
/* 4190 */     String str7 = new String(arrayOfByte1);
/* 4191 */     HashMap localHashMap1 = splitQuery(str7);
/* 4192 */     String str8 = (String)localHashMap1.get("oauth_token");
/* 4193 */     if (str8 == null)
/* 4194 */       return false;
/* 4195 */     String str9 = (String)localHashMap1.get("oauth_token_secret");
/* 4196 */     if (str9 == null)
/* 4197 */       return false;
/* 4198 */     addSecretKeySpec(str9);
/* 4199 */     String str10 = paramV2CTwitterUser.getUserName();
/* 4200 */     String str11 = sAuthorizeURL + "?oauth_token=" + str8 + 
/* 4201 */       "&oauth_callback=oob&force_login=true&screen_name=" + str10;
/* 4202 */     V2CMiscUtil.openLinkOutside(str11);
/* 4203 */     V2CPINInputPanel localV2CPINInputPanel = new V2CPINInputPanel(str10, 
/* 4204 */       str11);
/* 4205 */     String str12 = localV2CPINInputPanel.showDialog();
/* 4206 */     if ((str12 == null) || (str12.length() == 0))
/* 4207 */       return false;
/* 4208 */     int i = V2CMiscUtil.parseInt(str12, -1);
/* 4209 */     if (i < 0)
/* 4210 */       return false;
/* 4211 */     String str13 = "oauth_consumer_key=" + str1 + "&oauth_nonce=" + 
/* 4212 */       createNonce() + 
/* 4213 */       "&oauth_signature_method=HMAC-SHA1&oauth_timestamp=" + 
/* 4214 */       (System.currentTimeMillis() + nOAuthTimeOffset) / 1000L + 
/* 4215 */       "&oauth_token=" + str8 + "&oauth_verifier=" + str12 + 
/* 4216 */       "&oauth_version=1.0";
/* 4217 */     String str14 = "GET&" + oauthURLEncode(sAccessTokenURL) + '&' + 
/* 4218 */       oauthURLEncode(str13);
/* 4219 */     String str15 = calcAndEncodeSignature(str14, str9);
/* 4220 */     if (str15 == null)
/* 4221 */       return false;
/* 4222 */     String str16 = sAccessTokenURL + '?' + str13 + "&oauth_signature=" + 
/* 4223 */       str15;
/* 4224 */     V2CHttpUtil.CAndC localV2CHttpUtil$CAndC2 = getRawHTTPFile(str16, 0, 
/* 4225 */       null);
/* 4226 */     if ((localV2CHttpUtil$CAndC2 == null) || 
/* 4227 */       (localV2CHttpUtil$CAndC2.getResponseCode() != 200))
/* 4228 */       return false;
/* 4229 */     byte[] arrayOfByte2 = localV2CHttpUtil$CAndC2.getRawContents();
/* 4230 */     if (arrayOfByte2 == null)
/* 4231 */       return false;
/* 4232 */     String str17 = new String(arrayOfByte2);
/* 4233 */     HashMap localHashMap2 = splitQuery(str17);
/* 4234 */     long l3 = V2CMiscUtil.parseLong((String)localHashMap2.get("user_id"));
/* 4235 */     if (l3 <= 0L)
/* 4236 */       return false;
/* 4237 */     return paramV2CTwitterUser.setOAuthAccessTokens(l3, 
/* 4238 */       (String)localHashMap2.get("screen_name"), 
/* 4239 */       (String)localHashMap2.get("oauth_token"), 
/* 4240 */       (String)localHashMap2.get("oauth_token_secret"), null);
/*      */   }
/*      */   
/*      */   static String createOAuthHeader(V2CTwitterUser paramV2CTwitterUser, boolean usePost, String paramString, HashMap paramHashMap)
/*      */   {
/* 4245 */     String consumerKey = V2CTwitterBBS.getOAuthConsumerKey();
/* 4246 */     String consumerSecret = V2CTwitterBBS.getOAuthConsumerSecret();
/* 4247 */     if ((consumerKey == null) || (consumerSecret == null)) {
/* 4248 */       return null;
/*      */     }
/* 4250 */     String accessToken = paramV2CTwitterUser.getOAuthAccessToken();
/* 4251 */     String tokenSecret = paramV2CTwitterUser.getOAuthAccessTokenSecret();
/* 4252 */     if ((accessToken == null) || (tokenSecret == null)) {
/* 4253 */       return null;
/*      */     }
/* 4255 */     HashMap parameterMap = new HashMap();
/* 4256 */     if (paramHashMap != null) {
/* 4257 */       parameterMap.putAll(paramHashMap);
/*      */     }
/* 4259 */     parameterMap.put("oauth_consumer_key", consumerKey);
/* 4260 */     parameterMap.put("oauth_token", accessToken);
/* 4261 */     parameterMap.put("oauth_signature_method", "HMAC-SHA1");
/* 4262 */     parameterMap.put("oauth_timestamp", String.valueOf((
/* 4263 */       System.currentTimeMillis() + nOAuthTimeOffset) / 1000L));
/* 4264 */     parameterMap.put("oauth_nonce", createNonce());
/* 4265 */     parameterMap.put("oauth_version", "1.0");
/* 4266 */     String[] parameterNames = (String[])parameterMap.keySet().toArray(
/* 4267 */       new String[parameterMap.size()]);
/* 4268 */     Arrays.sort(parameterNames);
/* 4269 */     StringBuilder buff = new StringBuilder();
/* 4270 */     for (int i = 0; i < parameterNames.length; i++) {
/* 4271 */       String parameter = parameterNames[i];
/* 4272 */       buff.append(parameter);
/* 4273 */       buff.append('=');
/* 4274 */       buff.append(parameterMap.get(parameter));
/* 4275 */       buff.append('&');
/*      */     }
/* 4277 */     String str7 = buff.substring(0, buff.length() - 1);
/* 4278 */     String str8 = (usePost ? "POST" : "GET") + '&' + 
/* 4279 */       oauthURLEncode(paramString) + '&' + oauthURLEncode(str7);
/* 4280 */     String str9 = calcAndEncodeSignature(str8, tokenSecret);
/* 4281 */     if (str9 == null) {
/* 4282 */       return null;
/*      */     }
/* 4284 */     buff.setLength(0);
/* 4285 */     buff.append("OAuth ");
/* 4286 */     for (int j = 0; j < parameterNames.length; j++) {
/* 4287 */       String str10 = parameterNames[j];
/* 4288 */       if (str10.startsWith("oauth_")) {
/* 4289 */         buff.append(str10);
/* 4290 */         buff.append("=\"");
/* 4291 */         buff.append(parameterMap.get(str10));
/* 4292 */         buff.append("\",");
/*      */       }
/*      */     }
/* 4295 */     buff.append("oauth_signature=\"");
/* 4296 */     buff.append(str9);
/* 4297 */     buff.append('"');
/* 4298 */     return buff.toString();
/*      */   }
/*      */   
/*      */   static void addSecretKeySpec(String userId) {
/* 4302 */     addSecretKeySpec(userId, V2CTwitterBBS.getOAuthConsumerSecret());
/*      */   }
/*      */   
/*      */   static void addSecretKeySpec(String userId, String secret) {
/* 4306 */     if ((userId == null) || (secret == null)) {
/* 4307 */       return;
/*      */     }
/* 4309 */     HashMap localHashMap = hmKeySpecs;
/* 4310 */     synchronized (localHashMap) {
/* 4311 */       localHashMap.put(userId, 
/* 4312 */         new SecretKeySpec((secret + '&' + userId).getBytes(), 
/* 4313 */         "HmacSHA1"));
/*      */     }
/*      */   }
/*      */   
/*      */   static String calcAndEncodeSignature(String message, String userId) {
/* 4318 */     byte[] arrayOfByte = null;
/*      */     try {
/*      */       SecretKeySpec keySpec;
/* 4321 */       synchronized (hmKeySpecs) {
/* 4322 */         keySpec = (SecretKeySpec)hmKeySpecs.get(userId); }
/* 4324 */       if (keySpec == null) {
/* 4325 */         return null;
/*      */       }
/* 4327 */       if (vMac == null) {
/* 4328 */         vMac = Mac.getInstance("HmacSHA1");
/*      */       }
/* 4330 */       synchronized (vMac) {
/* 4331 */         vMac.init(keySpec);
/* 4332 */         arrayOfByte = vMac.doFinal(message.getBytes());
/*      */       }
/*      */       
/*      */ 
/*      */ 
/* 4337 */       return 
/* 4338 */         null;
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/* 4335 */       localException.printStackTrace();
/*      */     }
				return arrayOfByte != null ? oauthURLEncode(new String(
						V2CMiscUtil.encodeBase64(arrayOfByte))) : null;
/*      */   	}
/*      */   
/*      */   static URL get5chPostUrl(URL url) {
/* 4343 */     try { String urlStr = url.toString();
/* 4344 */       urlStr = V2CMiscUtil.replaceFirst(urlStr, ".2ch.net/", ".5ch.net/");
/* 4345 */       return new URL(urlStr);
/*      */     }
/*      */     catch (Exception e) {
/* 4348 */       e.printStackTrace(); }
/* 4349 */     return url;
/*      */   }
/*      */   
/*      */   static String oauthURLEncode(String paramString)
/*      */   {
/* 4354 */     if ((paramString == null) || (paramString.length() == 0)) {
/* 4355 */       return paramString;
/*      */     }
/* 4357 */     byte[] arrayOfByte = V2CJPConverter.getBytes(paramString, "UTF-8");
/* 4358 */     if (arrayOfByte == null) {
/* 4359 */       return null;
/*      */     }
/* 4361 */     StringBuilder sb = new StringBuilder();
/* 4362 */     for (int i = 0; i < arrayOfByte.length; i++) {
/* 4363 */       int j = arrayOfByte[i] & 0xFF;
/* 4364 */       if ((j == 45) || (j == 46) || (j == 95) || (j == 126) || 
/* 4365 */         ((j >= 48) && (j <= 57)) || ((j >= 65) && (j <= 90)) || (
/* 4366 */         (j >= 97) && (j <= 122))) {
/* 4367 */         sb.append((char)j);
/*      */       } else {
/* 4369 */         sb.append('%');
/* 4370 */         sb.append(toHexChar(j >> 4 & 0xF));
/* 4371 */         sb.append(toHexChar(j & 0xF));
/*      */       }
/*      */     }
/* 4374 */     return sb.toString();
/*      */   }
/*      */   
/*      */   private static char toHexChar(int paramInt) {
/* 4378 */     return (char)(paramInt + (paramInt < 10 ? 48 : 55));
/*      */   }
/*      */   
/*      */   static String createNonce() {
/* 4382 */     if (vRandom == null) {
/* 4383 */       vRandom = new Random(System.currentTimeMillis());
/*      */     }
/* 4385 */     char[] arrayOfChar = new char[32];
/* 4386 */     for (int i = 0; i < arrayOfChar.length; i++) {
/* 4387 */       arrayOfChar[i] = ((char)((vRandom.nextInt() & 0x7FFF) % 10 + 48));
/*      */     }
/* 4389 */     return new String(arrayOfChar);
/*      */   }
/*      */ }


/* Location:              H:\__Apps\jd-gui-windows-1.4.0\V2C_R20171103.jar!\org\monazilla\v2c\V2CPlusHttpUtil.class
 * Java compiler version: 7 (51.0)
 * JD-Core Version:       0.7.1
 */