package org.monazilla.v2c;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import javax.imageio.ImageIO;

public class V2COekakiTimerTask
{
	Timer t = new Timer();
	static int loopCont = 0;

	public void timer_period() throws InterruptedException {
		t.schedule( new V2COekakiTimerRun(), 0L, 500L);
	}

	public void timer_cancel() throws InterruptedException {
		t.cancel();
		loopCont = 0;
	}
}
class V2COekakiTimerRun extends TimerTask {
	/** このメソッドがTimerから呼ばれる */
	@Override
	public void run() {
//		if((V2COekakiTimerTask.loopCont % 100) == 0){
//			System.out.println("V2COekakiTimerRun " + V2COekakiTimerTask.loopCont);
//		}
		V2COekakiTimerTask.loopCont++;

		String t;
        if((t = getClipboardString()) != null){
            if(t.indexOf("data:image/png;base64,") != 0){
            	return;
            }
            	                
		    try {
		    	String efn = V2COekaki.oekakiDir + "pictures" + java.io.File.separator + V2COekaki.g_BBSKey_efn + ".png";
				byte[] decoded = null;
				t = t.replace("data:image/png;base64,", "");
				decoded = V2CMiscUtil.decodeBase64(t.getBytes());

				BufferedImage fin = ImageIO.read(new ByteArrayInputStream(decoded));
                BufferedImage BufImage = V2COekaki.convertNoneTransparent(fin);
                ImageIO.write(BufImage, "png", new File(efn));

                List<File> list = Arrays.asList(new File(efn));
                OekakiDropListener fileDropped = new OekakiDropListener();
			    fileDropped.fileDropped(list, true);


				Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

				StringSelection ss = new StringSelection("");
				clipboard.setContents(ss, ss);
		    }catch(Exception e){
				e.printStackTrace();
            	return;
        	}
        }
	}

	String getClipboardString() {
		Toolkit kit = Toolkit.getDefaultToolkit();
		Clipboard clip = kit.getSystemClipboard();

		try {
			return (String) clip.getData(DataFlavor.stringFlavor);
		} catch (UnsupportedFlavorException e) {
			return null;
		} catch (IOException e) {
			return null;
		}
	}

	public class OekakiDropListener extends V2CFileDropListener
	{

		boolean fileDropped(java.util.List list)
		{
			if (list == null || list.size() == 0)
				return false;

			for(int i=0; i<list.size(); i++){
				Object obj = list.get(i);
				if (!(obj instanceof File))
					return false;
				File file = (File) obj;
				if (!file.isFile() || !file.canRead()) {
					return false;
				}
				else {
			    	String efn1 = V2COekaki.oekakiDir + "pictures" + java.io.File.separator + V2COekaki.g_BBSKey_efn + ".png";

	                try {
	                	BufferedImage fin = ImageIO.read(file);
	                	BufferedImage BufImage = V2COekaki.convertNoneTransparent(fin);
	                	ImageIO.write(BufImage, "png", new File(efn1));
					} catch (Exception e) {
						return false;
					}

	                V2COekaki.postOekaki(new File(efn1));
				}
			}
			V2COekaki.previewOekaki(V2COekaki.g_BBSKey_efn);
			return true;
		}

		boolean fileDropped(java.util.List list, boolean x)
		{
			if (list == null || list.size() == 0)
				return false;

			for(int i=0; i<list.size(); i++){
				Object obj = list.get(i);
				if (!(obj instanceof File))
					return false;
				File file = (File) obj;
				if (!file.isFile() || !file.canRead()) {
					return false;
				}
				else {
					V2COekaki.postOekaki(file);
				}
			}
			V2COekaki.previewOekaki(V2COekaki.g_BBSKey_efn);
			return true;
		}

		OekakiDropListener()
		{
			super();
		}

	}
}

