package org.monazilla.v2c;

import java.awt.Graphics;
import java.awt.Rectangle;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import javax.swing.plaf.metal.MetalScrollButton;

public class V2CMetalScrollBarUIDark extends MetalScrollBarUI
{
	//https://flylib.com/books/en/2.715.1.208/1/
	//UIManager.put("ScrollBarUI", "V2CMetalScrollBarUIDark");

	public static ComponentUI createUI(JComponent c)
	{
		return new V2CMetalScrollBarUIDark();
	}

	protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds)
	{
		if(!c.isEnabled()){
			return;
		}
		g.translate(thumbBounds.x, thumbBounds.y);
		if(scrollbar.getOrientation() == JScrollBar.VERTICAL){
			// VERTICAL
			if(!isFreeStanding){
				thumbBounds.width += 2;
			}
			g.setColor(UIManager.getColor("ScrollBar.thumb"));
			g.fillRect(0, 1, thumbBounds.width, thumbBounds.height - 2);
			if(!isFreeStanding){
				thumbBounds.width -= 2;
			}
		}else{
			// HORIZONTAL
			if(!isFreeStanding){
				thumbBounds.height += 2;
			}
			g.setColor(UIManager.getColor("ScrollBar.thumb"));
			g.fillRect(1, 0, thumbBounds.width - 2, thumbBounds.height);
			if(!isFreeStanding){
				thumbBounds.height -= 2;
			}
		}
		g.translate(-thumbBounds.x, -thumbBounds.y);
	}

	protected JButton createDecreaseButton(int orientation)
	{
		decreaseButton = (MetalScrollButton) new V2CMetalScrollButtonDark(orientation, scrollBarWidth, isFreeStanding);
		return decreaseButton;
	}

	protected JButton createIncreaseButton(int orientation)
	{
		increaseButton = (MetalScrollButton) new V2CMetalScrollButtonDark(orientation, scrollBarWidth, isFreeStanding);
		return increaseButton;
	}
}
