package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class V2CHttpUtil_SecondaryUAPlus
{
	public static final Pattern PatternStyle = Pattern
			.compile("Monazilla/.+?Windows/([\\d.]+)");
	public static final Pattern PatternFirefox = Pattern
			.compile("Mozilla/.+?Firefox/([\\d.]+)");
	public static final Pattern PatternChrome = Pattern
			.compile("Mozilla/.+?Chrome/([\\d.]+) .+?");
	public static final Pattern PatternEdg = Pattern
			.compile("Mozilla/.+?Edg/([\\d.]+)");

	static void load(){
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File cache = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_SecondaryUAPlus.txt");

		Map <String, String> hmSecondaryUA_W = V2CHttpUtil.hmSecondaryUA.get("W");

		String verStyle = "";
		String verFirefox = "";
		String varChrome = "";
		String varEdg = "";
		for(Map.Entry<String, String> entry : hmSecondaryUA_W.entrySet()) {
//			if((""+entry.getValue()).indexOf("JaneStyle/") != -1 || (""+entry.getValue()).indexOf("Live5ch/") != -1){
//				if(verStyle == ""){
//					Matcher m = PatternStyle.matcher((""+entry.getValue()));
//					if(m.find()){
//						verStyle = m.group(1);
//					}
//				}
//			}
			if((""+entry.getValue()).indexOf("Firefox/") != -1){
				if(verFirefox == ""){
					Matcher m = PatternFirefox.matcher((""+entry.getValue()));
					if(m.find()){
						verFirefox = m.group(1);
					}
				}
			}
			if((""+entry.getValue()).indexOf("Chrome/") != -1){
				if(varChrome == ""){
					Matcher m = PatternChrome.matcher((""+entry.getValue()));
					if(m.find()){
						varChrome = m.group(1);
					}
				}
			}
			if((""+entry.getValue()).indexOf("Edg/") != -1){
				if(varEdg == ""){
					Matcher m = PatternEdg.matcher((""+entry.getValue()));
					if(m.find()){
						varEdg = m.group(1);
					}
				}
			}
		}
		System.out.println("4式+ JaneStyle Windowsビルド：" + verStyle);
		System.out.println("4式+ Firefoxバージョン：" + verFirefox);
		System.out.println("4式+ Chromeバージョン：" + varChrome);
		System.out.println("4式+ Edgeバージョン：" + varEdg);
		
		if(cache.exists()){
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(cache));
		 
				String line;
				while ((line = br.readLine()) != null) {
					if(line.length() >= 3){
						char mode = line.charAt(0);
						if(mode == 'W'){
							int delim = line.indexOf("#");
							String key = "";
							String ua = "";
							if(delim != -1){
								key = line.substring(1, delim);
								ua = line.substring(delim+1);
							}

							if(key != null && ua != null){
								if(key.length() > 0 && ua.length() > 0){
									if(mode == 'W' && !key.endsWith(":T")){
//										if(ua.indexOf("JaneStyle/") != -1 || ua.indexOf("Live5ch/") != -1){
//											if(verStyle != ""){
//												ua = ua.replaceAll("Windows/[*.]+", "Windows/" + verStyle);
//											}
//										}
										if(ua.indexOf("Firefox/") != -1){
											if(verFirefox != ""){
												ua = ua.replaceAll("Firefox/[*.]+", "Firefox/" + verFirefox).replaceAll("rv:[*.]+", "rv:" + verFirefox);
											}
										}
										if(ua.indexOf("Chrome/") != -1){
											if(varChrome != ""){
												ua = ua.replaceAll("Chrome/[*.]+", "Chrome/" + varChrome);
											}
										}
										if(ua.indexOf("Edg/") != -1){
											if(varEdg != ""){
												ua = ua.replaceAll("Edg/[*.]+", "Edg/" + varEdg);
											}
										}

										hmSecondaryUA_W.put(key, ua);
										hmSecondaryUA_W.put(key + ":T", ua);
									}
								}
							}
						}
					}
				}
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		V2CHttpUtil.hmSecondaryUA.put("W", hmSecondaryUA_W);
	}

	static String[] getSecondaryUA(){
		return getSecondaryUA(null);
	}

	static String[] getSecondaryUA(String SurveySupport){
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File cache = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_SecondaryUAPlus" + (SurveySupport==null?"":SurveySupport) + ".txt");
		
		String sUA_A = "";
		String sUA_R = "";
		String sUA_W = "";

		if(cache.exists()){
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(cache));
		 
				String line;
				while ((line = br.readLine()) != null) {
					if(line.length() >= 3){
						char mode = line.charAt(0);
						if(mode == 'W'){
							int delim = line.indexOf("#");
							String key = "";
							String ua = "";
							if(delim != -1){
								key = line.substring(1, delim);
								ua = line.substring(delim+1);
							}
							if(key != null && ua != null){
								if(key.length() > 0 && ua.length() > 0){
									if(mode == 'W'){
										sUA_W += line.substring(1) + "\n";
									}
								}
							}
						}
					}
				}
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		
		return new String[] {sUA_A, sUA_R, sUA_W};
	}
	
	static void save(String text){
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File cache = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_SecondaryUAPlus.txt");

		BufferedWriter wr = null;
		try {
			wr = new BufferedWriter(new FileWriter(cache));
		 
			String[] lines = text.split("\n");
			for(int i=0; i<lines.length; i++){
				if(lines[i] != ""){
					wr.write(lines[i]);
					wr.newLine();
				}
			}
		} catch (FileNotFoundException e) {
			try {
				wr.close();
				cache.delete();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		} catch (IOException e) {
			try {
				wr.close();
				cache.delete();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		} catch (OutOfMemoryError e) {
			try {
				wr.close();
				cache.delete();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		} finally {
			try {
				wr.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		wr = null;
		cache = null;
	}
}
