package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class V2CHttpUtil_SecondaryUA
{
	static void load(){
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File cache = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_SecondaryUA.txt");

		Map <String, String> hmSecondaryUA_A = new HashMap <String, String> ();;
		Map <String, String> hmSecondaryUA_R = new HashMap <String, String> ();
		Map <String, String> hmSecondaryUA_W = new HashMap <String, String> ();
		if(cache.exists()){
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(cache));
		 
				String line;
				while ((line = br.readLine()) != null) {
					if(line.length() >= 3){
						char mode = line.charAt(0);
						if(mode == 'A' || mode == 'R' || mode == 'W'){
							int delim = line.indexOf("#");
							String key = "";
							String ua = "";
							if(delim != -1){
								key = line.substring(1, delim);
								ua = line.substring(delim+1);
							}
							if(key != null && ua != null){
								if(key.length() > 0 && ua.length() > 0){
									if(mode == 'A'){
										hmSecondaryUA_A.put(key, ua);
									}
									if(mode == 'R'){
										hmSecondaryUA_R.put(key, ua);
									}
									if(mode == 'W' && !key.endsWith(":T")){
										hmSecondaryUA_W.put(key, ua);
										hmSecondaryUA_W.put(key + ":T", ua);
									}
								}
							}
						}
					}
				}
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		V2CHttpUtil.hmSecondaryUA.put("A", hmSecondaryUA_A);
		V2CHttpUtil.hmSecondaryUA.put("R", hmSecondaryUA_R);
		V2CHttpUtil.hmSecondaryUA.put("W", hmSecondaryUA_W);
	}

	static String[] getSecondaryUA(){
		return getSecondaryUA(null);
	}

	static String[] getSecondaryUA(String SurveySupport){
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File cache = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_SecondaryUA" + (SurveySupport==null?"":SurveySupport) + ".txt");
		
		String sUA_A = "";
		String sUA_R = "";
		String sUA_W = "";

		if(cache.exists()){
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(cache));
		 
				String line;
				while ((line = br.readLine()) != null) {
					if(line.length() >= 3){
						char mode = line.charAt(0);
						if(mode == 'A' || mode == 'R' || mode == 'W'){
							int delim = line.indexOf("#");
							String key = "";
							String ua = "";
							if(delim != -1){
								key = line.substring(1, delim);
								ua = line.substring(delim+1);
							}
							if(key != null && ua != null){
								if(key.length() > 0 && ua.length() > 0){
									if(mode == 'A'){
										sUA_A += line.substring(1) + "\n";
									}
									if(mode == 'R'){
										sUA_R += line.substring(1) + "\n";
									}
									if(mode == 'W'){
										sUA_W += line.substring(1) + "\n";
									}
								}
							}
						}
					}
				}
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		
		return new String[] {sUA_A, sUA_R, sUA_W};
	}
	
	static void save(String text){
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File cache = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_SecondaryUA.txt");

		BufferedWriter wr = null;
		try {
			wr = new BufferedWriter(new FileWriter(cache));
		 
			String[] lines = text.split("\n");
			for(int i=0; i<lines.length; i++){
				if(lines[i] != ""){
					wr.write(lines[i]);
					wr.newLine();
				}
			}
		} catch (FileNotFoundException e) {
			try {
				wr.close();
				cache.delete();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		} catch (IOException e) {
			try {
				wr.close();
				cache.delete();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		} catch (OutOfMemoryError e) {
			try {
				wr.close();
				cache.delete();
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
		} finally {
			try {
				wr.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		wr = null;
		cache = null;
	}
}
