package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;

public class V2CDarkMode
{
	static public boolean using = false;
	static public boolean usingExt = false;
	static public boolean MacNative = false;

	public static void setcolorkeys()
	{
		File dm = new File(V2CLauncher.getJarDir(), "v2cdarkmode.txt");
		File dc = new File(V2CLauncher.getJarDir(), "v2cdarkmode_Mac.txt");
		File xl = new File(V2CLauncher.getJarDir(), "v2cextlaf.txt");

		if(dm.exists()){
			System.out.println("Use DarkMode");
			using = true;
			try {
				UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
			} catch (ClassNotFoundException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
			} catch (InstantiationException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
			} catch (IllegalAccessException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
			} catch (UnsupportedLookAndFeelException e1) {
				// TODO 自動生成された catch ブロック
				e1.printStackTrace();
			}
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(dm));
		 
				String line;
				while ((line = br.readLine()) != null) {
					if(line.length() != 0){
						char mode = line.charAt(0);
						if(mode != '/'){
							String[] delim = line.split("\t");
							if(delim.length >= 2){
								if((((String) delim[0]).endsWith("UI"))){
									UIManager.put(delim[0], delim[1]);
								}
								if((((String) delim[1]).substring(0, 1)).equals("#")){
									int r = Integer.decode("0x" + ((String) delim[1]).substring(1, 3));
									int g = Integer.decode("0x" + ((String) delim[1]).substring(3, 5));
									int b = Integer.decode("0x" + ((String) delim[1]).substring(5, 7));
									UIManager.put(delim[0], new Color(r, g, b));
								}
								if(V2CApp.isMacintosh() && ((String) delim[0]).endsWith(".font")){
									Font baseSystemFont = new FontUIResource((String) delim[1], Font.BOLD, Integer.valueOf((String) delim[2]).intValue());
									Object menuFont = new UIDefaults.ProxyLazyValue(
											"javax.swing.plaf.FontUIResource",
											null,
											new Object[]{baseSystemFont.deriveFont(Font.BOLD, 14f)});
									UIManager.put(delim[0], menuFont);
								}
								if((((String) delim[1]).substring(0, 2)).equals("I(")){
									String insets[] = ((String) delim[1]).replaceAll("[ I()]", "").split(",");
									System.out.println(delim[0] + " " + delim[1] + " " + insets[0] + " " + insets[1] + " " + insets[2] + " " + insets[3]);
									UIManager.put(delim[0],  new Insets(
											 Integer.valueOf((String) insets[0])
											,Integer.valueOf((String) insets[1])
											,Integer.valueOf((String) insets[2])
											,Integer.valueOf((String) insets[3])
									));
								}
								if((((String) delim[1]).substring(0, 1)).equals("N")){
									UIManager.put(delim[0], Integer.valueOf(((String) delim[1]).substring(1)));
								}
							}
						}
					}
				}

			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}else
		if(dc.exists()){
			System.out.println("Use DarkMode Mac");
			using = true;
			MacNative = true;
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(dc));
		 
				String line;
				while ((line = br.readLine()) != null) {
					if(line.length() != 0){
						char mode = line.charAt(0);
						if(mode != '/'){
							String[] delim = line.split("\t");
							if(delim.length >= 2){
								if((((String) delim[0]).endsWith("UI"))){
									UIManager.put(delim[0], delim[1]);
								}
								if((((String) delim[1]).substring(0, 1)).equals("#")){
									int r = Integer.decode("0x" + ((String) delim[1]).substring(1, 3));
									int g = Integer.decode("0x" + ((String) delim[1]).substring(3, 5));
									int b = Integer.decode("0x" + ((String) delim[1]).substring(5, 7));
									UIManager.put(delim[0], new Color(r, g, b));
								}
								if(V2CApp.isMacintosh() && ((String) delim[0]).endsWith(".font")){
									Font baseSystemFont = new FontUIResource((String) delim[1], Font.BOLD, Integer.valueOf((String) delim[2]).intValue());
									Object menuFont = new UIDefaults.ProxyLazyValue(
											"javax.swing.plaf.FontUIResource",
											null,
											new Object[]{baseSystemFont.deriveFont(Font.BOLD, 14f)});
									UIManager.put(delim[0], menuFont);
								}
								if((((String) delim[1]).substring(0, 2)).equals("I(")){
									String insets[] = ((String) delim[1]).replaceAll("[ I()]", "").split(",");
									System.out.println(delim[0] + " " + delim[1] + " " + insets[0] + " " + insets[1] + " " + insets[2] + " " + insets[3]);
									UIManager.put(delim[0],  new Insets(
											 Integer.valueOf((String) insets[0])
											,Integer.valueOf((String) insets[1])
											,Integer.valueOf((String) insets[2])
											,Integer.valueOf((String) insets[3])
									));
								}
								if((((String) delim[1]).substring(0, 1)).equals("N")){
									UIManager.put(delim[0], Integer.valueOf(((String) delim[1]).substring(1)));
								}
							}
						}
					}
				}
				UIManager.put("CheckBoxMenuItem.checkIcon", (Object) V2CBasicIconFactoryDark.getCheckBoxMenuItemIcon());
				UIManager.put("Menu.arrowIcon", (Object) V2CBasicIconFactoryDark.getMenuArrowIcon());
				UIManager.put("RadioButtonMenuItem.checkIcon", (Object) V2CBasicIconFactoryDark.getCheckBoxMenuItemIcon());
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}else
		if(xl.exists()){
			usingExt = true;
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(xl));
		 
				String line;
				while ((line = br.readLine()) != null) {
					if(line.length() != 0){
						char mode = line.charAt(0);
						if(mode != '/'){
							System.out.println("Use " + line);
							String elm[] = line.split("\t");
							try {
								UIManager.setLookAndFeel(elm[0]);
								if(elm.length == 2){
									String[] sp = elm[1].split("=");
									if(sp.length == 2){
										System.setProperty((String) sp[0], (String) sp[1]);
										System.out.println((String) sp[0] + "=" + System.getProperty((String) sp[0]));
									}
								}
							} catch (ClassNotFoundException e1) {
								// TODO 自動生成された catch ブロック
								e1.printStackTrace();
							} catch (InstantiationException e1) {
								// TODO 自動生成された catch ブロック
								e1.printStackTrace();
							} catch (IllegalAccessException e1) {
								// TODO 自動生成された catch ブロック
								e1.printStackTrace();
							} catch (UnsupportedLookAndFeelException e1) {
								// TODO 自動生成された catch ブロック
								e1.printStackTrace();
							}
							break;
						}
					}
				}

			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		
		if(using || usingExt){
			V2CScriptApp.putProperty("DarkMpde", "on");
		}
	}

	public static void printcolorkeys()
	{

		System.out.println("//" + System.getProperty("swing.defaultlaf"));

		List<String> colorKeys = new ArrayList<String>();
		Map <String, Object> map = new HashMap <String, Object> ();
		Set<Entry<Object, Object>> entries = UIManager.getLookAndFeelDefaults().entrySet();
		for (Entry entry : entries)
		{
			if (entry.getValue() instanceof Color)
			{
				colorKeys.add((String) entry.getKey());
				map.put((String) entry.getKey(), entry);
			}
			if (entry.getValue() instanceof Insets)
			{
				colorKeys.add((String) entry.getKey());
				map.put((String) entry.getKey(), entry);
			}
			if (entry.getKey().toString().endsWith("UI"))
			{
				colorKeys.add((String) entry.getKey());
				map.put((String) entry.getKey(), entry);
			}
			if (entry.getValue() instanceof Icon)
			{
				colorKeys.add((String) entry.getKey());
				map.put((String) entry.getKey(), entry);
			}
		}

		// sort the color keys
		Collections.sort(colorKeys);

		// print the color keys
		for (String colorKey : colorKeys)
		{
			Object entry = map.get(colorKey);
			if (((Entry <Object, Object>) entry).getValue() instanceof Color){
				String key = (String) ((Entry <Object, Object>) entry).getKey();
				String color =    key + "\t#" 
						+ String.format("%02x", ((Color) ((Entry <Object, Object>) entry).getValue()).getRed()) 
						+ String.format("%02x", ((Color) ((Entry <Object, Object>) entry).getValue()).getGreen()) 
						+ String.format("%02x", ((Color) ((Entry <Object, Object>) entry).getValue()).getBlue())
						;
				System.out.println(color);
			}
			if (((Entry <Object, Object>) entry).getValue() instanceof Insets){
				String key = (String) ((Entry <Object, Object>) entry).getKey();
				String color =    key + "\t" 
						+ ((Insets) ((Entry <Object, Object>) entry).getValue()).top + ", "
						+ ((Insets) ((Entry <Object, Object>) entry).getValue()).left + ", "
						+ ((Insets) ((Entry <Object, Object>) entry).getValue()).bottom + ", "
						+ ((Insets) ((Entry <Object, Object>) entry).getValue()).right
						;
				System.out.println(color);
			}
			if (((Entry <Object, Object>) entry).getKey().toString().endsWith("UI")){
				String key = (String) ((Entry <Object, Object>) entry).getKey();
				String color =    key + "\t" 
						+ ((String) ((Entry <Object, Object>) entry).getValue())
						;
				System.out.println(color);
			}
			if (((Entry <Object, Object>) entry).getValue() instanceof Icon){
				String key = (String) ((Entry <Object, Object>) entry).getKey();
				String color =    key + "\t" 
						+ ((Icon) ((Entry <Object, Object>) entry).getValue()).toString()
						;
				System.out.println(color);
			}
		}
	}

}
