package org.monazilla.v2c;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Locale;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;

public class V2CCreateBugReportTemplate {
	private static String mStr1 = null;
	private static String mStr2 = null;
	private static String rhino = null; 
	private static String BouncyCastle = null;
	private static String webp_imageio = null;
	private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

	private static String editDisplayName(String s){
		String el[] = s.split(" ");
		String sName = "";
		if((""+el[0]).indexOf("2.11.4.1") == 0){
			sName = "(V2C/2) ";
		}else if((""+el[0]).indexOf("2.11.4.2") == 0){
			sName = "(V2CMOD/2) ";
		}else
		if(el[0].equals("2.11.4")){
			if(el.length < 3 ){
				File jar = new File(V2CLauncher.getJarDir(), "V2C_R20131210.jar");
				if(jar.exists()){
					SimpleDateFormat Lsdf = new SimpleDateFormat("yyyyMMdd");
					String sDate = Lsdf.format(new File(V2CLauncher.getJarDir(), "V2C_R20131210.jar").lastModified());
					if(Integer.valueOf(sDate) < 20131231){
						sName = "(V2C) ";
					}else{
						sName = "(V2CMOD) ";
					}
				}else{
					sName = "(V2C/V2CMOD) ";
				}
			}else{
				sName = "(V2CMOD-Z) ";
			}
		}else if(el[0].equals("2.11.8")){
			sName = "(広告なしV2C-R) ";
		}else if((""+el[0]).indexOf("3.") == 0){
/*
			try{
				V2CPlusProperty a = new V2CPlusProperty();
				el[0] += "+";
				sName = "(V2C-R+) ";
				a = null;
			} catch(NoClassDefFoundError e){
				sName = "(広告ありV2C-R) ";
			}
*/
		}else if((""+el[0]).indexOf("2.12") == 0 ||
				 (""+el[0]).indexOf("2.13") == 0 ||
				 (""+el[0]).indexOf("2.14") == 0 ||
				 (""+el[0]).indexOf("2.15") == 0 ||
				 (""+el[0]).indexOf("2.16") == 0 ||
				 (""+el[0]).indexOf("2.17") == 0 ||
				 (""+el[0]).indexOf("2.18") == 0 ||
				 (""+el[0]).indexOf("2.19") == 0 ||
				 (""+el[0]).indexOf("2.20") == 0){
			sName = "(V2CMOD-Z) ";
		}
		return el[0] + " " + sName + el[el.length-1];
	}
	
	public static void main()
	{
		if(mStr1 == null){
			StringBuffer stringbuffer = new StringBuffer();
			stringbuffer.append("【V2C】 ");
			stringbuffer.append(editDisplayName(V2CReleaseInfo.getDisplayName()));
			String s = V2CLauncher.getLauncherVersion();
			if (s != null && s.length() > 0) {
				stringbuffer.append(" (L-");
				stringbuffer.append(s);
				if (V2CApp.isWinType()) {
					String s1 = V2CLauncher.getLauncherArch();
					if (s1 != null && s1.length() > 0) {
						stringbuffer.append(':');
						stringbuffer.append(s1);
						String s3 = V2CLauncher.getLauncherJavaCmd();
						if (s3 != null && s3.length() > 0) {
							stringbuffer.append('-');
							int i = s3.lastIndexOf('\\');
							stringbuffer.append(i <= 0 ? "???" : s3.substring(i + 1));
						}
					}
				}
				stringbuffer.append(')');
			}
			else if (V2CApp.isJavaWebStart())
				stringbuffer.append(" (JWS)");
			if (V2CApp.isMacintosh())
				V2CMacQuaquaSupport.appendQuaquaInfo(stringbuffer);
			stringbuffer.append("\n【Java】 ");
			if (System.getProperty("launcher.Userpjre") != null && System.getProperty("launcher.Userpjre") != "")
				stringbuffer.append("[P]");
			String s2 = System.getProperty("java.runtime.version");
			if (s2 != null && s2.length() > 0)
				stringbuffer.append(s2);
			else
				stringbuffer.append(System.getProperty("java.version"));
			stringbuffer.append(" (");
			stringbuffer.append(System.getProperty("java.vendor"));
			stringbuffer.append(")\n【OS】 ");
			String s4 = V2CApp.getOSInfo();
			if (s4 != null) {
				stringbuffer.append(s4);
				stringbuffer.append(" (");
				stringbuffer.append(System.getProperty("os.arch"));
				stringbuffer.append(')');
			}
			else {
				stringbuffer.append(System.getProperty("os.name"));
				stringbuffer.append(' ');
				stringbuffer.append(System.getProperty("os.version"));
				stringbuffer.append(" (");
				stringbuffer.append(System.getProperty("os.arch"));
				stringbuffer.append(')');
				if (V2CApp.isUNIX()) {
					File file = new File("/etc/issue");
					if (file.isFile() && file.canRead()) {
						String s5 = V2CLocalFileHandler.restoreFromFile(file);
						if (s5 != null) {
							int j = s5.indexOf('\n');
							if (j >= 0)
								s5 = s5.substring(0, j);
							j = s5.indexOf('\\');
							if (j >= 0)
								s5 = s5.substring(0, j);
							if (s5.length() > 0) {
								stringbuffer.append("  [ ");
								stringbuffer.append(s5);
								stringbuffer.append(" ]");
							}
						}
					}
				}
			}
			Runtime runtime = Runtime.getRuntime();
			System.gc();
			System.gc();
			stringbuffer.append("\n【メモリ】 Total(Free)/Max.: ");
			stringbuffer.append(runtime.totalMemory() >>> 20);
			stringbuffer.append("(");
			stringbuffer.append(runtime.freeMemory() >>> 20);
			stringbuffer.append(")/");
			long l = runtime.maxMemory();
			if (V2CApp.isMacintosh() && V2CApp.javaVersionEqualTo(1, 4))
				l -= 0x5000000L;
			stringbuffer.append(l >>> 20);
			int ai[] = V2CApp.getMemInfo();
			if (ai != null && ai.length == 4) {
				stringbuffer.append("　(Phys. Total/Avail.: ");
				stringbuffer.append(ai[0]);
				stringbuffer.append('/');
				stringbuffer.append(ai[1]);
				stringbuffer.append(')');
			}
			stringbuffer
					.append("　[MB] ");

			mStr1 = stringbuffer.toString();
		}

		if(mStr2 == null){
			StringBuffer stringbuffer = new StringBuffer();
			stringbuffer
			.append("\n");
			stringbuffer
			.append("\n【不具合内容】 \n【不具合URL(「すべて」禁止)】\n【再現方法】 \n【調査済項目】 ");

			mStr2 = stringbuffer.toString();
		}
		
		if(rhino == null){
			System.out.println("rhino check");
			if(V2CApp.javaVersionEqualOrGreaterThan(1, 8)){
				StringBuffer stringbuffer = new StringBuffer();
				String stat = "なし";
				if(hasRhinoScriptEngine("JavaScript")){
					stat = "あり";
				}
				stringbuffer
				.append("\n【Rhinoスクリプトエンジン】 " + stat);
				rhino = stringbuffer.toString();
			}else{
				rhino = "";
			}
		}

		if(BouncyCastle == null){
			System.out.println("BouncyCastle check");
			StringBuffer stringbuffer = new StringBuffer();
			String stat = "なし";
			String castat = "";
			File bcprov = new File(V2CLauncher.getJarDir(), "bcprov-jdk15to18.jar");
			if(bcprov.exists()){
				if( V2CApp.javaVersionLessThan(1, 8) ||
				   (V2CApp.javaVersionEqualOrGreaterThan(1, 8) && V2CHttpUtil.UseBouncyCastle)){
					stat = "あり" + " (最終更新日：" + sdf.format(bcprov.lastModified()) + ")";
					File cacerts = new File(V2CLauncher.getJarDir(), "cacerts");
					if(cacerts.exists()){
						castat = "\n【外付けcacerts(Java CA 証明書)】 " + "あり" + " (最終更新日：" + sdf.format(cacerts.lastModified()) + ")";
					}else{
						castat = "\n【外付けcacerts(Java CA 証明書)】 " + "なし";
					}
				}
				stringbuffer
				.append("\n【BouncyCastle】 " + stat + castat);
				BouncyCastle = stringbuffer.toString();
			}else{
				BouncyCastle = "";
			}
		}
		
		if(webp_imageio == null){
			System.out.println("webp-imageio check");
			StringBuffer stringbuffer = new StringBuffer();
			String jar = "なし";
			String dlls = "";
			File webpimageio = new File(V2CLauncher.getJarDir(), "WebP_luciad-webp-imageio.jar");
			if(webpimageio.exists()){
				jar = webpimageio.getName() +"(最終更新日：" + sdf.format(webpimageio.lastModified()) + ")";
				String as[] = new String[] {"webp-imageio.dll", "libwebp-imageio.dylib", "libwebp-imageio.so"};
				int i = as.length;
				for (int j = 0; j < i; j++) {
					File dll = new File(V2CLauncher.getJarDir(), as[j]);
					if(dll.exists()){
						dlls = ((dlls.length() == 0)?"":", ") + dll.getName() + "(最終更新日：" + sdf.format(dll.lastModified()) + ")";
					}
				}
				stringbuffer
				.append("\n【webp-imageio.jar】 " + jar + "\n【webp-imageioライブラリ】 " + dlls);
				webp_imageio = stringbuffer.toString();
			}else{
				webp_imageio = "";
			}
		}
		
		String com = "";
		{
			StringBuffer stringbuffer = new StringBuffer();
			stringbuffer
			.append("\n");
			String names = "";
			String as[] = new String[] { "subject.js", "rescheck.js", "imgcache.js", "menu.js", "getdat.js", "threadld.js", "post.js", "proxy.js" };
			int i = as.length;
			for (int j = 0; j < i; j++) {
				File scr = V2CLocalFileHandler.getSystemScriptFile(as[j]);
				if(scr.exists()){
					String s1 = V2CSystemScript.getPermissionString(as[j]);
					if (s1 == null){
						s1 = ", ";
					}else{
						s1 = "(" + s1 + "), ";
					}
					names += (as[j] + s1);
				}
			}
			if(names.length() != 0){
				names = names.substring(0, names.length() - 2);
			}
			stringbuffer
			.append("\n【systemスクリプト】 " + names);
				
			names = "";
			as = new String[] { "msgkw.txt", "ImageViewURLReplace.dat", "ReplaceStr.txt", "ReplaceStr_Tw.txt", "URLExec.dat", "URLExec2.dat", "URLExec3.dat" };
			i = as.length;
			for (int j = 0; j < i; j++) {
				File scr = new File(V2CLocalFileHandler.v2cDir, as[j]);
				if(scr.exists()){
					String s1 = V2CSystemScript.getPermissionString(as[j]);
					names += (as[j] + ", ");
				}
			}
			if(names.length() != 0){
				names = names.substring(0, names.length() - 2);
			}
			stringbuffer
			.append("\n【ReplaceStr,URLExec等】 " + names);

			com = stringbuffer.toString();
		}

		String brs = "";
		{
			StringBuffer stringbuffer = new StringBuffer();
			stringbuffer
			.append("\n");
	    	String bbsmenu = "";
			try {
				String line = "";
				BufferedReader br = null;
				File file = new File(new File(V2CLocalFileHandler.fBBSDir, "2ch"), "bbsprops.txt");
				if(file.exists()){
					br = new BufferedReader(new InputStreamReader(new FileInputStream(file),"UTF-8"));
		    		while ((line = br.readLine()) != null){
		    			if(line.indexOf("2ch.BBSMenuURL:=") != -1){
		    				bbsmenu = line.replace("2ch.BBSMenuURL:=", "");
		    				break;
		    			}
		    		}
		    		//終了処理
						br.close();
				}
				if(bbsmenu == ""){
					bbsmenu = "http://menu.2ch.net/bbsmenu.html";
				}
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}			
			String bbstreeUpdated = sdf.format((new File(new File(V2CLocalFileHandler.fBBSDir, "2ch"), "bbstree.txt")).lastModified());
			stringbuffer
			.append("\n【2ch板一覧取得URL】 " + bbsmenu + " (最終更新日：" + bbstreeUpdated + ")");
			
			stringbuffer
			.append("\n【起動時に2chの板一覧を更新】 " + (V2CApp.getUserProperty().getPackedValue("BoardTree.Conf")!=null?"チェック済":"未チェック"));

			stringbuffer
			.append("\n【レス表示フォント】 " + getFontName("ThreadDefault"));

			stringbuffer
			.append("\n【指定フォントにない文字は他のフォントを使用】 " + (V2CApp.getUserProperty().getPackedValue("Font.CheckChars")!=null?"チェック済":"未チェック"));

			if(V2CApp.getUserProperty().getPackedValue("Font.CheckChars")!=null){
				stringbuffer
				.append("\n　【参考：黒電話絵文字を表示するフォント】 " + getEmojiFontName(128384));
				stringbuffer
				.append("\n　【参考：ロケット・ダブルハート絵文字を表示するフォント】 " + getEmojiFontName(128149));
			}
			
			String aaa = editDisplayName(V2CReleaseInfo.getDisplayName());
			if(aaa.indexOf("V2CMOD-Z") != -1 || aaa.indexOf("V2C/2") != -1 || aaa.indexOf("V2CMOD/2") != -1){
				stringbuffer
				.append("\n【スレ一覧フォント】 " + getFontName("ThreadListDefault"));
			}

			stringbuffer
			.append("\n【代替 (AA用)フォント】 " + getFontName("ThreadAlt"));

			stringbuffer
			.append("\n【その他 (UI用)フォント】 " + getFontName("Default"));

			stringbuffer
			.append("\n【おπ送りを監視する】 " + (V2CHttpUtil.UseOPPAI?"チェック済":"未チェック"));

			brs = stringbuffer.toString();
		}

		String brp = "";
		{
			StringBuffer stringbuffer = new StringBuffer();
			String names = "";
			stringbuffer
			.append("\n");
			names = "B11" + V2CAPISettings.SubVersion;
			if(V2CHttpUtil.useAPI && V2CHttpUtil.useHTML){
				names += "　dat & read.cgi";
			}else if(V2CHttpUtil.useAPI){
				names += "　dat Only";
			}else if(V2CHttpUtil.useHTML){
				names += "　read.cgi Only";
			}else{
				names += "";
			}
			if(V2CHttpUtil.useAPI && V2CHttpUtil.useHYBRID){
				names = (""+names).replace("API", "API(1式HYBRID)");
			}
			stringbuffer
			.append("\n【2chAPIパッチ】 " + names);
			
			names = "";
			names  = "readcgi" + V2CAPISettings.exp + "(" + sdf.format(new File(V2CLauncher.getJarDir(), "readcgi" + V2CAPISettings.exp).lastModified()) + "), ";
			names += "readcgi_aux" + V2CAPISettings.exp + "(" + sdf.format(new File(V2CLauncher.getJarDir(), "readcgi_aux" + V2CAPISettings.exp).lastModified()) + ")";
			stringbuffer
			.append("\n【B11スクリプト】 " + names);
			
			File file0 = new File(V2CLauncher.getJarDir(), "ReplaceStr_B11_Dev.txt");
			if(!file0.exists()){
				file0 = new File(V2CLauncher.getJarDir(), "ReplaceStr_B11.txt");
			}
			String ReplaceStr = (file0.exists()?file0.getName() + "(" + sdf.format(file0.lastModified()) + ")":"未使用");
			stringbuffer
			.append("\n【B11用 ReplaceStr.txt】 " + ReplaceStr);
						
			file0 = new File(V2CLauncher.getJarDir(), "URLExec_B11.dat");
			String URLExec = (file0.exists()?file0.getName() + "(" + sdf.format(file0.lastModified()) + ")":"未使用");
			stringbuffer
			.append("\n【B11用 URLExec.dat】 " + URLExec);
						
			stringbuffer
			.append("\n");
			stringbuffer
			.append("\n【UA(専ブラ DAT取得)】 " + V2CHttpUtil.UAName);
			stringbuffer
			.append("\n【UA(専ブラ 書き込み)】 " + V2CHttpUtil.UAPost);
			stringbuffer
			.append("\n【UA(read.cgi ページ取得)】 " + V2CHttpUtil.UAPostCGI);
			stringbuffer
			.append("\n【UA(read.cgi 書き込み)】 " + V2CHttpUtil.UAPostCGIPost);

			brp = stringbuffer.toString();
		}
		String ipv6 = "";
		{
			StringBuffer stringbuffer = new StringBuffer();
			String s = System.getProperty("java.net.preferIPv6Addresses");
			String value = "";
			if (s != null && s.equals("true")){
				value = "IPv6";
			}else{
				value = "IPv4";
			}
			stringbuffer
			.append("\n【優先IPアドレスバージョン】 " + value);
			V2CProperty v2cproperty = V2CApp.getUserProperty();
			stringbuffer
			.append("\n【書き込み時" + (value=="IPv6"?"IPv4":"IPv6") + "のアドレスを優先する】 " + (v2cproperty.getBoolean("PreferIPv6Addresses")?"はい":"いいえ"));
			stringbuffer
			.append("\n");
			ipv6 = stringbuffer.toString();
		}

//		V2CScriptApp.putProperty("?brs", mStr1 + rhino + BouncyCastle + webp_imageio + com + brs + mStr2) ;
//		V2CScriptApp.putProperty("?brp", mStr1 + rhino + BouncyCastle + webp_imageio + com + brp + mStr2) ;
		V2CScriptApp.putProperty("?br",  mStr1 + ipv6 + rhino + BouncyCastle + webp_imageio + com + brs + brp + mStr2) ;
	}

	private static boolean hasRhinoScriptEngine(final String scn)
	{
		V2CScriptClassLoader v2cscriptclassloader = V2CScriptClassLoader.getInstance();
		if (v2cscriptclassloader == null)
			return false;
		AccessControlContext accesscontrolcontext = V2CScriptUtil.createAccessControlContext(V2CSystemScript.getPermissionString(""));
		if (accesscontrolcontext == null)
			return false;

		final ScriptEngineManager sem = new ScriptEngineManager(v2cscriptclassloader);
		Object obj1 = null;
		try {
			obj1 = AccessController.doPrivileged(new PrivilegedAction() {

				public Object run()
				{
					return sem.getEngineByName(scn);
				}
			}, accesscontrolcontext);
		}
		catch (Exception exception) {
		}
		if (!(obj1 instanceof ScriptEngine))
			return false;

		ScriptEngine scriptengine = (ScriptEngine) obj1;
		String s2 = scriptengine.getFactory().getEngineName();
		if (s2 == null || s2.indexOf("Rhino") < 0) {
			scriptengine = null;
			java.util.List list = sem.getEngineFactories();
			int i = list.size();
			int j = 0;
			do {
				if (j >= i)
					break;
				ScriptEngineFactory scriptenginefactory = (ScriptEngineFactory) list.get(j);
				String s3 = scriptenginefactory.getEngineName();
				if (s3 != null && s3.indexOf("Rhino") >= 0) {
					scriptengine = scriptenginefactory.getScriptEngine();
					break;
				}
				j++;
			} while (true);
			if (scriptengine == null)
				return false;
		}
		return true;
	}

	static String getBaseFontName0(V2CBaseFont font){
		try {
			return font.getFaceName(Locale.JAPANESE);
		} catch (Exception exception1) {
			try {
				return font.getFaceName(Locale.JAPAN);
			} catch (Exception exception2) {
				try {
					return font.getFaceName();
				} catch (Exception exception3) {
					try {
						return font.getName();
					} catch (Exception exception4) {
						try {
							return font.getTTFileName();
						} catch (Exception exception5) {
							return CanNotGetFontName(1);
						}
					}
				}
			}
		}
	}

	static String getFontName0(Font font){
		try {
			return font.getFontName(Locale.JAPANESE);
		} catch (Exception exception1) {
			try {
				return font.getFontName(Locale.JAPAN);
			} catch (Exception exception2) {
				try {
					return font.getFontName();
				} catch (Exception exception3) {
					try {
						return font.getName();
					} catch (Exception exception4) {
						try {
							return font.getPSName();
						} catch (Exception exception5) {
							return CanNotGetFontName(2);
						}
					}
				}
			}
		}
	}

	static String CanNotGetFontName(int i){
		return "B11バグ報告用テンプレはフォント名を取得できませんでした(" + i + ")";
	}

	static String getFontName(String s){
		try {
			Font font = V2CBaseFont.getBaseFont(s).getFont();
			return getFontName0(font);
		} catch (Exception exception) {
			try {
				V2CBaseFont font = V2CBaseFont.getBaseFont(s);
				return getBaseFontName0(font);
			} catch (Exception exception1) {
				return CanNotGetFontName(3);
			}
		}
	}

	static String getEmojiFontName(int l){
		try {
			Font font = V2CBaseFont.getBaseFont("ThreadDefault").getFont();
			try {
				Font efont = V2CFont.getAvailableFont(font, l);
				String[] ret = {"", "", ""};
				ret[0] = getFontName0(efont);
				if(ret[0].indexOf("Monospaced") != -1){
					ret[1] = efont.MONOSPACED;
				}
				return ret[0] + (ret[1].length()!=0?" (" + ret[1] + ")":"");
			} catch (Exception exception1) {
				return CanNotGetFontName(4);
			}
		} catch (Exception exception) {
			try {
				V2CBaseFont font = V2CBaseFont.getBaseFont("ThreadDefault");
				return getBaseFontName0(font);
			} catch (Exception exception2) {
				return CanNotGetFontName(5);
			}
		}
	}
}
