package org.monazilla.v2c;

import java.io.BufferedWriter;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class V2CCookieMonaTicketUA
{
	private static Map <String, String> hmMonaTicketUA = new HashMap <String, String> ();
	public static File MonaTicketUA = new File(V2CLocalFileHandler.getV2CDir(), "2ch_api_MonaTicketUA.txt");

	static String getKey(URL url){
		return check_by_board(getKey0(url));
	}
	
	static String getKey0(URL url){
		if(url == null) return "null";
		String yosoMonaTicket2Board = null;
		if(V2CYosoHelperPanel.vYosoHelperPanel != null){
			yosoMonaTicket2Board = V2CYosoHelperPanel.getMonaTicket2Board();
		}
		return url.toString().replace("?guid=ON", "")
							 .replace("bbs.cgi", V2CHttpUtil.MonaTicketBoard != null ? V2CHttpUtil.MonaTicketBoard : "bbs.cgi")
							 .replace("bbs.cgi", yosoMonaTicket2Board        != null ? yosoMonaTicket2Board        : "bbs.cgi")
							 ;
	}
	
	static String get(URL url){
		String key = getKey(url);
		if(key.indexOf(".5ch.net") != -1){
			load();
			synchronized (hmMonaTicketUA) {
				return hmMonaTicketUA.get(key);
			}
		}
		return null;
	}

	static void set(URL url, String raw){
		String key = getKey(url);
		if(key.indexOf(".5ch.net") != -1){
			load();
			synchronized (hmMonaTicketUA) {
				hmMonaTicketUA.put(key, raw);
				save();
			}
		}
	}

	static void remove(URL url){
		String key = getKey(url);
		if(key.indexOf(".5ch.net") != -1){
			load();
			synchronized (hmMonaTicketUA) {
				hmMonaTicketUA.remove(key);
				save();
			}
		}
	}

	static boolean exists(URL url){
		String key = getKey(url);
		if(key.indexOf(".5ch.net") != -1){
			load();
			return hmMonaTicketUA.containsKey(key);
		}
		return false;
	}

	
	static void load(){
		String[] mts = V2CLocalFileHandler.readLines(MonaTicketUA, "UTF-8");
		if(mts == null){
			mts = new String[0];
		}
		synchronized (hmMonaTicketUA) {
			hmMonaTicketUA = new HashMap <String, String> ();
			for(int i=0; i<mts.length; i++){
				String[] a = mts[i].split("\t",2);
				if(a.length == 2){
					hmMonaTicketUA.put(check_by_board(a[0]), a[1]);
				}
			}
		}
	}
	
	static void save(){
		BufferedWriter bufferedwriter = V2CLocalFileHandler.getBufferedWriter(MonaTicketUA, "UTF-8");
		if (bufferedwriter == null)
			return;
		try {
			synchronized (hmMonaTicketUA) {
				for(Map.Entry<String, String> entry : hmMonaTicketUA.entrySet()){
					bufferedwriter.write(entry.getKey() + "\t" + entry.getValue());
					bufferedwriter.newLine();
				}
			}
		}
		catch (Exception exception) {
			exception.printStackTrace();
		}
		finally {
			V2CLocalFileHandler.closeWriter(bufferedwriter);
		}
	}

	static String check_by_board(String url){
		if(!url.endsWith("bbs.cgi")){
			return url.replaceAll("^https://\\w+\\.", "https://by_board.");
		}else{
			return url;
		}
	}


	static void physicalRemove(String[] p){
		load();
		if(p.length == 2){
			hmMonaTicketUA.remove(p[1]);
			save();
		}
	}
}
