package org.monazilla.v2c;

import java.io.BufferedWriter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class V2CCookieMonaTicketTime
{
	private static Map <String, String> hmMonaTicketTime = new HashMap <String, String> ();
	public static File MonaTicketTime = new File(V2CLocalFileHandler.getV2CDir(), "2ch_api_MonaTicketTime.txt");

	static String getKey(URL url){
		return V2CCookieMonaTicketUA.check_by_board(getKey0(url));
	}
	
	static String getKey0(URL url){
		if(url == null) return "null";
		return url.toString().replace("?guid=ON", "")
							 .replace("bbs.cgi", V2CHttpUtil.MonaTicketBoardTime)
							 ;
	}
	
	static String get(URL url){
		String key = getKey(url);
		if(key.indexOf(".5ch.net") != -1){
			load();
			synchronized (hmMonaTicketTime) {
				return hmMonaTicketTime.get(key);
			}
		}
		return null;
	}

	static void set(URL url, String raw){
		String key = V2CCookieMonaTicketUA.getKey(url);
		if(key.indexOf(".5ch.net") != -1){
			load();
			synchronized (hmMonaTicketTime) {
				hmMonaTicketTime.put(key, raw);
				save();
			}
		}
	}

	static void load(){
		String[] mts = V2CLocalFileHandler.readLines(MonaTicketTime, "UTF-8");
		if(mts == null){
			mts = new String[0];
		}
		synchronized (hmMonaTicketTime) {
			hmMonaTicketTime = new HashMap <String, String> ();
			for(int i=0; i<mts.length; i++){
				String[] a = mts[i].split("\t",2);
				if(!a[0].endsWith("bbs.cgi")){
					if(a.length == 2){
						try {
							Integer.parseInt(a[1]);
						} catch (Exception e) {
							a[1] = String.valueOf(V2CHttpUtil.postTimeDiff);
						}
						hmMonaTicketTime.put(V2CCookieMonaTicketUA.check_by_board(a[0]), a[1]);
					}else
					if(a.length == 2){
						hmMonaTicketTime.put(V2CCookieMonaTicketUA.check_by_board(a[0]), String.valueOf(V2CHttpUtil.postTimeDiff));
					}
				}
			}
		}
	}
	
	static void save(){
		BufferedWriter bufferedwriter = V2CLocalFileHandler.getBufferedWriter(MonaTicketTime, "UTF-8");
		if (bufferedwriter == null)
			return;
		try {
			synchronized (hmMonaTicketTime) {
				for(Map.Entry<String, String> entry : hmMonaTicketTime.entrySet()){
					if(!entry.getKey().endsWith("bbs.cgi")){
						String value = entry.getValue();
						try {
							Integer.parseInt(value);
						} catch (Exception e) {
							value = String.valueOf(V2CHttpUtil.postTimeDiff);
						}
						bufferedwriter.write(entry.getKey() + "\t" + value);
						bufferedwriter.newLine();
					}
				}
			}
		}
		catch (Exception exception) {
			exception.printStackTrace();
		}
		finally {
			V2CLocalFileHandler.closeWriter(bufferedwriter);
		}
	}

	static void setPostTimeDiffByBoard(String[] p){
		load();
		if(p.length == 3 && p[1] != null){
			hmMonaTicketTime.put(p[1], p[2]);
			save();
		}else
		if(p.length == 2){
			hmMonaTicketTime.remove(p[1]);
			save();
		}
	}
}
