package org.monazilla.v2c;

import java.io.BufferedWriter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class V2CCookieMonaTicket
{
	private static Map <String, String> hmMonaTicket = new HashMap <String, String> ();
	public static File CookieMonaTicket = new File(V2CLocalFileHandler.getV2CDir(), "2ch_api_MonaTicket.txt");

	static String get(URL url){
		String key = V2CCookieMonaTicketUA.getKey(url);
		if(key.indexOf(".5ch.net") != -1){
			load();
			synchronized (hmMonaTicket) {
				return hmMonaTicket.get(key);
			}
		}
		return null;
	}

	static void set(URL url, String raw){
		String key = V2CCookieMonaTicketUA.getKey(url);
		if(key.indexOf(".5ch.net") != -1 && (raw.indexOf("MonaTicket") == 0 || raw.equals("INIT"))){
			load();
			synchronized (hmMonaTicket) {
				hmMonaTicket.put(key, (raw.equals("INIT")?"":raw));
				save();
			}
		}
	}

	static void remove(URL url){
		String key = V2CCookieMonaTicketUA.getKey(url);
		if(key.indexOf(".5ch.net") != -1){
			if(V2CCookieMonaTicketUA.exists(url)){
				set(url, "INIT");
			}
			V2CCookie.UpdateCookie(null, "MonaTicket", ".5ch.net", null);
		}
	}

	
	static void load(){
		String[] mts = V2CLocalFileHandler.readLines(CookieMonaTicket, "UTF-8");
		if(mts == null){
			mts = new String[0];
		}
		synchronized (hmMonaTicket) {
			hmMonaTicket = new HashMap <String, String> ();
			for(int i=0; i<mts.length; i++){
				String[] a = mts[i].split("\t",2);
				if(a.length == 2){
					try {
						V2CCookie localV2CCookie = new V2CCookie(a[1], new URL(a[0]), null);
						int j = (localV2CCookie.bMaxAge) && (localV2CCookie.nMaxAge == 0) ? 1 : 0;
						if (localV2CCookie.ltExpires > 0L && localV2CCookie.ltExpires < System.currentTimeMillis()) {
							j = 1;
						}
						if(j == 0){
							hmMonaTicket.put(V2CCookieMonaTicketUA.check_by_board(a[0]), a[1]);
						}
					} catch (MalformedURLException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					}
				}
			}
		}
	}
	
	static void save(){
		BufferedWriter bufferedwriter = V2CLocalFileHandler.getBufferedWriter(CookieMonaTicket, "UTF-8");
		if (bufferedwriter == null)
			return;
		try {
			synchronized (hmMonaTicket) {
				for(Map.Entry<String, String> entry : hmMonaTicket.entrySet()){
					bufferedwriter.write(entry.getKey() + "\t" + entry.getValue());
					bufferedwriter.newLine();
				}
			}
		}
		catch (Exception exception) {
			exception.printStackTrace();
		}
		finally {
			V2CLocalFileHandler.closeWriter(bufferedwriter);
		}
	}

	static void physicalRemove(String[] p){
		load();
		if(p.length == 2){
			hmMonaTicket.remove(p[1]);
			save();
		}
	}
}
