/*     */ package org.monazilla.v2c;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Date;
/*     */ 
/*     */ public class V2CCookie
/*     */ {
/*     */   private static final String sCookieFile = "cookie.txt";
/*     */   private static final String sBeMailName = "DMDM";
/*     */   private static final String sBeCodeName = "MDMD";
/*     */   
/*     */   static Object getBeLoginMonitor()
/*     */   {
/*  16 */     sDMDMValue = sMDMDValue = null;
/*  17 */     return vBeLoginMonitor;
/*     */   }
/*     */   
/*     */   static boolean hasHAP(boolean paramBoolean) {
/*  21 */     ArrayList localArrayList = alCookieList;
/*  22 */     synchronized (localArrayList) {
/*  23 */       for (int i = localArrayList.size() - 1; i >= 0; i--) {
/*  24 */         V2CCookie localV2CCookie = (V2CCookie)localArrayList.get(i);
/*  25 */         String str1 = localV2CCookie.sName;
/*  26 */         if ((str1 != null) && (str1.equals("HAP"))) {
/*  27 */           URL localURL = localV2CCookie.uURL;
/*  28 */           if (localURL != null) {
/*  29 */             String str2 = localURL.getHost().toLowerCase();
/*  30 */             if (str2.endsWith(paramBoolean ? ".bbspink.com" : ".2ch.net")) {
/*  31 */               return true;
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*  37 */     return false;
/*     */   }
/*     */   
/*     */   static void discardHAP(boolean flag) {
/*  41 */     ArrayList arraylist = alCookieList;
/*  42 */     synchronized (arraylist) {
/*  43 */       boolean flag1 = false;
/*  44 */       for (int i = arraylist.size() - 1; i >= 0; i--) {
/*  45 */         V2CCookie v2ccookie = (V2CCookie)arraylist.get(i);
/*  46 */         String s = v2ccookie.sName;
/*  47 */         if ((s != null) && (s.equals("HAP")))
/*     */         {
/*  49 */           URL url = v2ccookie.uURL;
/*  50 */           if (url != null)
/*     */           {
/*  52 */             String s1 = url.getHost().toLowerCase();
/*  53 */             if (s1.endsWith(flag ? ".bbspink.com" : ".2ch.net")) {
/*  54 */               flag1 = true;
/*  55 */               arraylist.remove(i);
/*     */             }
/*     */           }
/*     */         } }
/*  59 */       if (flag1) {
/*  60 */         bChanged = true;
/*  61 */         saveCookies();
/*     */       }
/*     */     }
/*     */   }
/*     */   
/*     */   static void addCookie(String paramString, URL paramURL) {
			  if(paramURL.toString().equals("https://donguri.5ch.net/auth") || paramURL.toString().equals("https://donguri.5ch.net/login")){
				if(paramString.indexOf("acorn=") == 0 && paramString.indexOf("Max-Age=") == -1){
					paramString += "; Max-Age=604800; Path=/";
				}
			  }
/*  67 */     restoreCookies();
/*  68 */     V2CCookie localV2CCookie = new V2CCookie(paramString, paramURL, null);
/*  69 */     if (!localV2CCookie.isValid()) {
/*  70 */       localV2CCookie.printErrorMessage();
/*  71 */       return;
/*     */     }
/*  73 */     if (!localV2CCookie.miscCheck()) {
/*  74 */       return;
/*     */     }
/*  76 */     if (((localV2CCookie.sDomain.endsWith(".2ch.net")) || (localV2CCookie.sDomain.endsWith(".5ch.net"))) && (localV2CCookie.sPath.equals("/"))) {
/*  77 */       if (localV2CCookie.sName.equals("DMDM")) {
/*  78 */         sDMDMValue = localV2CCookie.sValue;
/*  79 */         return;
/*     */       }
/*  81 */       if (localV2CCookie.sName.equals("MDMD")) {
/*  82 */         sMDMDValue = localV2CCookie.sValue;
/*  83 */         return;
/*     */       }
/*     */     }
			  if(localV2CCookie.sName.equals("tako") || localV2CCookie.sName.equals("TAKO")){
				  V2CSwingUtil.showWarningMessage("この書き込みに対してcookieで TAKO=ODORI が返されました\nこのcookieは保存しません\n可能ならばBBx規制回避のためIPアドレスを変更して下さい");
				  return;
			  }
/*  86 */     bChanged = true;
/*  87 */     int i = (localV2CCookie.bMaxAge) && (localV2CCookie.nMaxAge == 0) ? 1 : 0;
/*  88 */     ArrayList localArrayList = alCookieList;
/*  89 */     synchronized (localArrayList) {
/*  90 */       for (int j = 0; j < localArrayList.size(); j++) {
/*  91 */         if (localV2CCookie.matches((V2CCookie)localArrayList.get(j))) {
/*  92 */           if (i != 0) {
/*  93 */             localArrayList.remove(j);
/*     */           } else {
/*  95 */             localArrayList.set(j, localV2CCookie);
					  if(localV2CCookie.sDomain.equalsIgnoreCase(".5ch.net") && localV2CCookie.sName.equalsIgnoreCase("MonaTicket")){
					  	V2CCookieMonaTicket.set(paramURL, paramString);
					  }
/*     */           }
/*  97 */           return;
/*     */         }
/*     */       }
/* 100 */       if (i == 0) {
/* 101 */         localArrayList.add(localV2CCookie);
				  if(localV2CCookie.sDomain.equalsIgnoreCase(".5ch.net") && localV2CCookie.sName.equalsIgnoreCase("MonaTicket")){
				    V2CCookieMonaTicket.set(paramURL, paramString);
				  }
/*     */       }
/*     */     }
/*     */   }
/*     */   
/*     */   static void removeCookie(String s, String s1, String s2) {
/* 107 */     restoreCookies();
/* 108 */     ArrayList arraylist = alCookieList;
/* 109 */     synchronized (arraylist) {
/* 110 */       for (int i = 0; i < arraylist.size(); i++) {
/* 111 */         V2CCookie v2ccookie = (V2CCookie)arraylist.get(i);
/* 112 */         if (v2ccookie.matches(s, s1, s2)) {
/* 113 */           bChanged = true;
/* 114 */           arraylist.remove(i--);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */   
/*     */   static String getOneCookieValue(String paramString1, String paramString2, String paramString3)
/*     */   {
/* 122 */     restoreCookies();
/* 123 */     ArrayList localArrayList = alCookieList;
/* 124 */     synchronized (localArrayList) {
/* 125 */       for (int i = 0; i < localArrayList.size(); i++) {
/* 126 */         V2CCookie localV2CCookie = (V2CCookie)localArrayList.get(i);
/* 127 */         if (localV2CCookie.matches(paramString1, paramString2, paramString3)) {
/* 128 */           return localV2CCookie.sValue;
/*     */         }
/*     */       }
/*     */     }
/* 132 */     return null;
/*     */   }
/*     */   
/*     */   static String getCookie(URL url) {
/* 136 */     return getCookie(url, null);
/*     */   }
/*     */   
/*     */   static void remove2chCookie()
/*     */   {
/* 141 */     restoreCookies();
/* 142 */     ArrayList arraylist = alCookieList;
/* 143 */     synchronized (arraylist) {
/* 144 */       for (int i = 0; i < arraylist.size(); i++) {
/* 145 */         V2CCookie v2ccookie = (V2CCookie)arraylist.get(i);
/* 146 */         String domain = v2ccookie.sDomain;
/* 147 */         if ((domain.equalsIgnoreCase(".2ch.net")) || (domain.equalsIgnoreCase(".5ch.net")) || (domain.equalsIgnoreCase(".bbspink.com"))) {
/* 148 */           System.out.println("del cookie: " + v2ccookie.getURLString() + " " + v2ccookie.sRaw);
/* 149 */           bChanged = true;
/* 150 */           arraylist.remove(i--);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */   
/*     */   static void removeHostCookie(String hostName) {
/* 157 */     if (hostName == null) {
/* 158 */       return;
/*     */     }
/*     */     
/* 161 */     restoreCookies();
/* 162 */     ArrayList arraylist = alCookieList;
/* 163 */     synchronized (arraylist) {
/* 164 */       for (int i = 0; i < arraylist.size(); i++) {
/* 165 */         V2CCookie v2ccookie = (V2CCookie)arraylist.get(i);
/* 166 */         URL url = v2ccookie.uURL;
/* 167 */         if (url != null)
/*     */         {
/*     */ 
/* 170 */           String host = url.getHost();
/*     */           
/* 172 */           if ((hostName.equalsIgnoreCase(host)) || (hostName.equalsIgnoreCase(host))) {
/* 173 */             System.out.println("del cookie: " + v2ccookie.getURLString() + " " + v2ccookie.sRaw);
/* 174 */             bChanged = true;
/* 175 */             arraylist.remove(i--);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */   
/*     */   static String getCookie(URL url, V2CBeIDListItem v2cbeidlistitem)
/*     */   {
/* 184 */     restoreCookies();
/* 185 */     ArrayList arraylist = alCookieList;
/* 186 */     if (arraylist.size() == 0)
/* 187 */       return null;
/* 188 */     ArrayList arraylist1 = new ArrayList();
/* 189 */     synchronized (arraylist) {
/* 190 */       long l = System.currentTimeMillis();
/* 191 */       for (int i1 = 0; i1 < arraylist.size(); i1++) {
/* 192 */         V2CCookie v2ccookie3 = (V2CCookie)arraylist.get(i1);
/* 193 */         if ((v2ccookie3.ltExpires > 0L) && (v2ccookie3.ltExpires < l)) {
/* 194 */           bChanged = true;
/* 195 */           arraylist.remove(i1--);
/*     */         }
/*     */         else {
/* 198 */           String s = v2ccookie3.sName;
/* 199 */           if ((!s.equals("DMDM")) && (!s.equals("MDMD")) && (v2ccookie3.applicableTo(url)))
/*     */           {
/* 201 */             int j1 = 0;
/*     */             
/* 203 */             while (j1 < arraylist1.size())
/*     */             {
/* 205 */               if (v2ccookie3.compareTo((V2CCookie)arraylist1.get(j1)) >= 0) {
/* 206 */                 arraylist1.add(j1, v2ccookie3);
/* 207 */                 v2ccookie3 = null;
/* 208 */                 break;
/*     */               }
/* 210 */               j1++;
/*     */             }
/* 212 */             if (v2ccookie3 != null)
/* 213 */               arraylist1.add(v2ccookie3);
/*     */           }
/*     */         }
/*     */       } }
/* 217 */     boolean flag = false;
/* 218 */     int i = arraylist1.size() - 1;
/*     */     
/* 220 */     while (i >= 0)
/*     */     {
/* 222 */       V2CCookie v2ccookie = (V2CCookie)arraylist1.get(i);
/* 223 */       if ((v2ccookie.isValid()) && (v2ccookie.sName.equalsIgnoreCase("HAP")) && 
/* 224 */         ((v2ccookie.sDomain.equalsIgnoreCase(".2ch.net")) || (v2ccookie.sDomain.equalsIgnoreCase(".5ch.net")) || (v2ccookie.sDomain.equalsIgnoreCase(".bbspink.com"))) && 
/* 225 */         (v2ccookie.sPath.equals("/"))) {
/* 226 */         flag = true;
/* 227 */         break;
/*     */       }
/* 229 */       i--;
/*     */     }
/* 231 */     if (flag) {
/* 232 */       for (int j = arraylist1.size() - 2; j >= 0; j--) {
/* 233 */         V2CCookie v2ccookie1 = (V2CCookie)arraylist1.get(j);
/* 234 */         if ((v2ccookie1.isValid()) && 
/* 235 */           (v2ccookie1.sName.equalsIgnoreCase("HAP")) && (
/* 236 */           ((v2ccookie1.sDomain.length() > 8) && ((v2ccookie1.sDomain.endsWith(".2ch.net")) || (v2ccookie1.sDomain.endsWith(".5ch.net")))) || (
/* 237 */           (v2ccookie1.sDomain.length() > 12) && (v2ccookie1.sDomain.endsWith(".bbspink.com")) && 
/* 238 */           (v2ccookie1.sPath.equals("/"))))) {
/* 239 */           arraylist1.remove(j);
/* 240 */           arraylist1.add(v2ccookie1);
/*     */         }
/*     */       }
/*     */     }
/*     */     
/* 245 */     StringBuilder sb = new StringBuilder();
/* 246 */     for (int k = 0; k < arraylist1.size(); k++) {
/* 247 */       V2CCookie v2ccookie2 = (V2CCookie)arraylist1.get(k);
				if(v2ccookie2.sValue.length() != 0){
				  if(v2ccookie2.sDomain.equalsIgnoreCase(".5ch.net") && v2ccookie2.sName.equalsIgnoreCase("MonaTicket")){
					String val = V2CCookieMonaTicket.get(url);
					if(val != null){
					  val = val.replaceAll("(?i)^MonaTicket=([^;]+);.+$", "$1");
					  if(val.length() != 0){
						sb.append(v2ccookie2.sName + '=' + val + "; ");
					  }
					}
				  }else{
/* 248 */           sb.append(v2ccookie2.sName + '=' + v2ccookie2.sValue + "; ");
				  }
				}
/*     */     }
/*     */     
/* 251 */     if (v2cbeidlistitem != null)
/* 252 */       sb.append("DMDM=" + v2cbeidlistitem.sDMDM + "; " + "MDMD" + '=' + v2cbeidlistitem.sMDMD + "; ");
/* 253 */     return sb.length() <= 0 ? null : sb.substring(0, sb.length() - 2);
/*     */   }
/*     */   
/*     */   static synchronized void restoreCookies() {
/* 257 */     if (bRestored)
/* 258 */       return;
/* 259 */     bRestored = true;
/* 260 */     java.io.BufferedReader bufferedreader = V2CLocalFileHandler.getUserSaveFileReader("cookie.txt");
/* 261 */     if (bufferedreader == null) {
/* 262 */       return;
/*     */     }
/*     */     try {
/*     */       String s;
/* 266 */       while ((s = bufferedreader.readLine()) != null)
/*     */       {
/* 268 */         if ((s.length() != 0) && (s.charAt(0) != '#'))
/*     */         {
/* 270 */           String s1 = null;
/* 271 */           int i = 0;
/* 272 */           char c = s.charAt(0);
/* 273 */           if ((c >= '0') && (c <= '9')) {
/* 274 */             i = s.indexOf('\t');
/* 275 */             if (i >= 0)
/*     */             {
/* 277 */               s1 = s.substring(0, i);
/* 278 */               i++;
/*     */             }
/* 280 */           } else { int j = s.indexOf('\t', i);
/* 281 */             if (j >= 0)
/*     */             {
/* 283 */               String s2 = s.substring(j + 1);
						URL url;
/*     */               try
/*     */               {
/* 286 */                 url = new URL(s.substring(i, j));
/*     */               } catch (java.net.MalformedURLException malformedurlexception) { // URL url;
/* 288 */                 V2CMiscUtil.printMalformedURLException(malformedurlexception); //}
/* 289 */               	continue;
						}
/*     *///               URL url;
/* 291 */               V2CCookie v2ccookie = new V2CCookie(s2, url, s1);
/* 292 */               if (v2ccookie.sName != null)
/* 293 */                 alCookieList.add(v2ccookie);
/*     */             } } } }
/* 295 */       bufferedreader.close();
/*     */     }
/*     */     catch (java.io.IOException localIOException) {}
/*     */   }
/*     */   
/*     */   /* Error */
/*     */   static void saveCookies()
/*     */   {
/*     */     // Byte code:
/*     */     //   0: getstatic 440	org/monazilla/v2c/V2CCookie:alCookieList	Ljava/util/ArrayList;
/*     */     //   3: astore_0
/*     */     //   4: aload_0
/*     */     //   5: dup
/*     */     //   6: astore_1
/*     */     //   7: monitorenter
/*     */     //   8: getstatic 426	org/monazilla/v2c/V2CCookie:bChanged	Z
/*     */     //   11: ifne +6 -> 17
/*     */     //   14: aload_1
/*     */     //   15: monitorexit
/*     */     //   16: return
/*     */     //   17: iconst_0
/*     */     //   18: putstatic 426	org/monazilla/v2c/V2CCookie:bChanged	Z
/*     */     //   21: new 276	org/monazilla/v2c/V2CSaveFile
/*     */     //   24: dup
/*     */     //   25: ldc 11
/*     */     //   27: invokespecial 519	org/monazilla/v2c/V2CSaveFile:<init>	(Ljava/lang/String;)V
/*     */     //   30: astore_2
/*     */     //   31: aload_2
/*     */     //   32: invokevirtual 518	org/monazilla/v2c/V2CSaveFile:getWriter	()Ljava/io/BufferedWriter;
/*     */     //   35: astore_3
/*     */     //   36: aload_3
/*     */     //   37: ifnonnull +10 -> 47
/*     */     //   40: iconst_1
/*     */     //   41: putstatic 426	org/monazilla/v2c/V2CCookie:bChanged	Z
/*     */     //   44: aload_1
/*     */     //   45: monitorexit
/*     */     //   46: return
/*     */     //   47: invokestatic 477	java/lang/System:currentTimeMillis	()J
/*     */     //   50: lstore 4
/*     */     //   52: iconst_0
/*     */     //   53: istore 6
/*     */     //   55: goto +114 -> 169
/*     */     //   58: aload_0
/*     */     //   59: iload 6
/*     */     //   61: invokevirtual 487	java/util/ArrayList:get	(I)Ljava/lang/Object;
/*     */     //   64: checkcast 273	org/monazilla/v2c/V2CCookie
/*     */     //   67: astore 7
/*     */     //   69: aload 7
/*     */     //   71: getfield 424	org/monazilla/v2c/V2CCookie:ltExpires	J
/*     */     //   74: lload 4
/*     */     //   76: lcmp
/*     */     //   77: iflt +89 -> 166
/*     */     //   80: aload 7
/*     */     //   82: getfield 427	org/monazilla/v2c/V2CCookie:bMaxAge	Z
/*     */     //   85: ifeq +36 -> 121
/*     */     //   88: aload 7
/*     */     //   90: getfield 423	org/monazilla/v2c/V2CCookie:nMaxAge	I
/*     */     //   93: ifeq +73 -> 166
/*     */     //   96: aload_3
/*     */     //   97: aload 7
/*     */     //   99: getfield 425	org/monazilla/v2c/V2CCookie:ltMaxAgeOrigin	J
/*     */     //   102: ldc2_w 227
/*     */     //   105: ldiv
/*     */     //   106: invokestatic 460	java/lang/String:valueOf	(J)Ljava/lang/String;
/*     */     //   109: invokevirtual 445	java/io/BufferedWriter:write	(Ljava/lang/String;)V
/*     */     //   112: aload_3
/*     */     //   113: bipush 9
/*     */     //   115: invokevirtual 444	java/io/BufferedWriter:write	(I)V
/*     */     //   118: goto +48 -> 166
/*     */     //   121: aload 7
/*     */     //   123: invokevirtual 499	org/monazilla/v2c/V2CCookie:getURLString	()Ljava/lang/String;
/*     */     //   126: astore 8
/*     */     //   128: aload 8
/*     */     //   130: ifnull +17 -> 147
/*     */     //   133: aload 8
/*     */     //   135: invokevirtual 448	java/lang/String:length	()I
/*     */     //   138: ifle +9 -> 147
/*     */     //   141: aload_3
/*     */     //   142: aload 8
/*     */     //   144: invokevirtual 445	java/io/BufferedWriter:write	(Ljava/lang/String;)V
/*     */     //   147: aload_3
/*     */     //   148: bipush 9
/*     */     //   150: invokevirtual 444	java/io/BufferedWriter:write	(I)V
/*     */     //   153: aload_3
/*     */     //   154: aload 7
/*     */     //   156: getfield 436	org/monazilla/v2c/V2CCookie:sRaw	Ljava/lang/String;
/*     */     //   159: invokevirtual 445	java/io/BufferedWriter:write	(Ljava/lang/String;)V
/*     */     //   162: aload_3
/*     */     //   163: invokevirtual 443	java/io/BufferedWriter:newLine	()V
/*     */     //   166: iinc 6 1
/*     */     //   169: iload 6
/*     */     //   171: aload_0
/*     */     //   172: invokevirtual 485	java/util/ArrayList:size	()I
/*     */     //   175: if_icmplt -117 -> 58
/*     */     //   178: aload_2
/*     */     //   179: invokevirtual 517	org/monazilla/v2c/V2CSaveFile:setOK	()V
/*     */     //   182: goto +25 -> 207
/*     */     //   185: astore 6
/*     */     //   187: iconst_1
/*     */     //   188: putstatic 426	org/monazilla/v2c/V2CCookie:bChanged	Z
/*     */     //   191: aload_3
/*     */     //   192: invokestatic 511	org/monazilla/v2c/V2CLocalFileHandler:closeWriter	(Ljava/io/Writer;)V
/*     */     //   195: goto +16 -> 211
/*     */     //   198: astore 9
/*     */     //   200: aload_3
/*     */     //   201: invokestatic 511	org/monazilla/v2c/V2CLocalFileHandler:closeWriter	(Ljava/io/Writer;)V
/*     */     //   204: aload 9
/*     */     //   206: athrow
/*     */     //   207: aload_3
/*     */     //   208: invokestatic 511	org/monazilla/v2c/V2CLocalFileHandler:closeWriter	(Ljava/io/Writer;)V
/*     */     //   211: aload_2
/*     */     //   212: invokevirtual 516	org/monazilla/v2c/V2CSaveFile:replaceTmpFile	()V
/*     */     //   215: aload_1
/*     */     //   216: monitorexit
/*     */     //   217: goto +6 -> 223
/*     */     //   220: aload_1
/*     */     //   221: monitorexit
/*     */     //   222: athrow
/*     */     //   223: return
/*     */     // Line number table:
/*     */     //   Java source line #301	-> byte code offset #0
/*     */     //   Java source line #302	-> byte code offset #4
/*     */     //   Java source line #303	-> byte code offset #8
/*     */     //   Java source line #304	-> byte code offset #14
/*     */     //   Java source line #306	-> byte code offset #17
/*     */     //   Java source line #307	-> byte code offset #21
/*     */     //   Java source line #308	-> byte code offset #31
/*     */     //   Java source line #309	-> byte code offset #36
/*     */     //   Java source line #310	-> byte code offset #40
/*     */     //   Java source line #311	-> byte code offset #44
/*     */     //   Java source line #313	-> byte code offset #47
/*     */     //   Java source line #315	-> byte code offset #52
/*     */     //   Java source line #316	-> byte code offset #58
/*     */     //   Java source line #317	-> byte code offset #69
/*     */     //   Java source line #318	-> byte code offset #80
/*     */     //   Java source line #319	-> byte code offset #88
/*     */     //   Java source line #320	-> byte code offset #96
/*     */     //   Java source line #321	-> byte code offset #112
/*     */     //   Java source line #323	-> byte code offset #118
/*     */     //   Java source line #324	-> byte code offset #121
/*     */     //   Java source line #325	-> byte code offset #128
/*     */     //   Java source line #326	-> byte code offset #141
/*     */     //   Java source line #328	-> byte code offset #147
/*     */     //   Java source line #329	-> byte code offset #153
/*     */     //   Java source line #330	-> byte code offset #162
/*     */     //   Java source line #315	-> byte code offset #166
/*     */     //   Java source line #334	-> byte code offset #178
/*     */     //   Java source line #335	-> byte code offset #182
/*     */     //   Java source line #336	-> byte code offset #187
/*     */     //   Java source line #338	-> byte code offset #191
/*     */     //   Java source line #337	-> byte code offset #198
/*     */     //   Java source line #338	-> byte code offset #200
/*     */     //   Java source line #339	-> byte code offset #204
/*     */     //   Java source line #338	-> byte code offset #207
/*     */     //   Java source line #340	-> byte code offset #211
/*     */     //   Java source line #302	-> byte code offset #215
/*     */     //   Java source line #342	-> byte code offset #223
/*     */     // Local variable table:
/*     */     //   start	length	slot	name	signature
/*     */     //   3	169	0	localArrayList	ArrayList
/*     */     //   6	215	1	Ljava/lang/Object;	Object
/*     */     //   30	182	2	localV2CSaveFile	V2CSaveFile
/*     */     //   35	173	3	localBufferedWriter	java.io.BufferedWriter
/*     */     //   50	25	4	l	long
/*     */     //   53	117	6	i	int
/*     */     //   185	3	6	localIOException	java.io.IOException
/*     */     //   67	88	7	localV2CCookie	V2CCookie
/*     */     //   126	17	8	str	String
/*     */     //   198	7	9	localObject1	Object
/*     */     // Exception table:
/*     */     //   from	to	target	type
/*     */     //   52	182	185	java/io/IOException
/*     */     //   52	191	198	finally
/*     */     //   8	16	220	finally
/*     */     //   17	46	220	finally
/*     */     //   47	217	220	finally
/*     */     //   220	222	220	finally
		ArrayList localArrayList = alCookieList;
		synchronized (localArrayList) {
			if (!bChanged) {
				return;
			}
			bChanged = false;
			V2CSaveFile localV2CSaveFile = new V2CSaveFile("cookie.txt");
			BufferedWriter localBufferedWriter = localV2CSaveFile.getWriter();
			if (localBufferedWriter == null) {
				bChanged = true;
				return;
			}
			long l = System.currentTimeMillis();
			try {
				for (int i = 0; i < localArrayList.size(); i++) {
					V2CCookie localV2CCookie = (V2CCookie) localArrayList.get(i);
					if (localV2CCookie.ltExpires >= l) {
/*
						if (localV2CCookie.bMaxAge) {
							if (localV2CCookie.nMaxAge != 0) {
								localBufferedWriter.write(String.valueOf(localV2CCookie.ltMaxAgeOrigin / 1000L));
								localBufferedWriter.write(9);
							}
						}
						else {
*/
							String str = localV2CCookie.getURLString();
							if ((str != null) && (str.length() > 0)) {
								localBufferedWriter.write(str);
							}
							localBufferedWriter.write(9);
							localBufferedWriter.write(localV2CCookie.sRaw);
							localBufferedWriter.newLine();
/*
						}
*/
					}
				}
				localV2CSaveFile.setOK();
			}
			catch (IOException localIOException) {
				bChanged = true;
			}
			finally {
				V2CLocalFileHandler.closeWriter(localBufferedWriter);
			}
			localV2CSaveFile.replaceTmpFile();
		}
/*     */   }
/*     */   
/*     */   static long parseHttpDate(String s)
/*     */   {
/* 345 */     if (s == null)
/* 346 */       return 0L;
/* 347 */     SimpleDateFormat[] asimpledateformat = lSimpleDateFormat;
/* 348 */     for (int i = 0; i < asimpledateformat.length; i++) {
/* 349 */       java.text.ParsePosition parseposition = new java.text.ParsePosition(0);
/* 350 */       Date date = asimpledateformat[i].parse(s, parseposition);
/* 351 */       if (date != null) {
/* 352 */         return date.getTime();
/*     */       }
/*     */     }
/* 355 */     return -1L;
/*     */   }
/*     */   
/*     */   public V2CCookie(String s, URL url, String s1) {
/* 359 */     this.uURL = url;
/* 360 */     this.bValid = false;
/* 361 */     this.sRaw = s;
/* 362 */     if (s1 != null)
/* 363 */       this.ltMaxAgeOrigin = (V2CMiscUtil.parseLong(s1) * 1000L);
/* 364 */     parseCookieString(s, url);
/*     */   }
/*     */   
/*     */   private void printErrorMessage() {
/* 368 */     if (this.bValid) {}
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */   void parseCookieString(String s, URL url)
/*     */   {
/* 375 */     if ((s == null) || (s.length() < 3))
/* 376 */       return;
/* 377 */     String[] as = s.split("\\s*;\\s*");
/* 378 */     if (!parseNameAndValue(as[0]))
/* 379 */       return;
/* 380 */     int i = as.length;
/* 381 */     for (int j = 1; j < i; j++) {
/* 382 */       String s3 = as[j];
/* 383 */       if ((!parseFields(s3)) && (!s3.equalsIgnoreCase("HttpOnly")) && (!s3.equalsIgnoreCase("secure"))) {
/* 384 */         return;
/*     */       }
/*     */     }
/* 387 */     String s1 = this.sDomain;
/* 388 */     if ((s1 != null) && (s1.length() > 0) && (s1.charAt(0) != '.')) {
/* 389 */       s1 = '.' + s1;
/* 390 */       this.sDomain = s1;
/*     */     }
/* 392 */     if (url != null) {
/* 393 */       if (this.sDomain == null)
/* 394 */         this.sDomain = url.getHost();
/* 395 */       if (this.sPath == null) {
/* 396 */         String s4 = url.getPath();
/* 397 */         if (s4.length() == 1) {
/* 398 */           this.sPath = s4;
/*     */         } else {
/* 400 */           int k = s4.lastIndexOf('/');
/* 401 */           if (k == 0) {
/* 402 */             this.sPath = s4.substring(0, 1);
/* 403 */           } else if (k > 0)
/* 404 */             this.sPath = s4.substring(0, k);
/*     */         }
/*     */       }
/*     */     }
/* 408 */     if ((this.sName == null) || (this.sName.length() == 0) || (this.sDomain == null) || (this.sDomain.length() == 0) || (this.sPath == null))
/* 409 */       return;
/* 410 */     if (url != null) {
/* 411 */       String s5 = url.getPath();
/* 412 */       if ((s5.length() > 0) && (!s5.startsWith(this.sPath)))
/* 413 */         return;
/* 414 */       String s2 = this.sDomain;
/* 415 */       int l = s2.length();
/* 416 */       if (s2.lastIndexOf('.') == 0)
/* 417 */         return;
/* 418 */       String s6 = url.getHost();
/* 419 */       if (s6.length() > 0) {
/* 420 */         char c = s6.charAt(0);
/* 421 */         if ((c >= '0') && (c <= '9') && (s6.matches("(?:\\d+\\.){3}\\d+"))) {
/* 422 */           if (s6.equals(s2)) {}
/*     */         }
/* 424 */         else if ((!s2.equals(s6)) && ((s2.charAt(0) != '.') || (!s2.regionMatches(true, 1, s6, 0, s6.length())))) {
/* 425 */           if (s6.indexOf('.') != s6.length() - s2.length())
/* 426 */             return;
/* 427 */           if (!s6.toLowerCase().endsWith(s2.toLowerCase()))
/* 428 */             return;
/*     */         }
/*     */       }
/*     */     }
/* 432 */     this.bValid = true;
/*     */   }
/*     */   
/*     */   boolean parseFields(String s) {
/*     */     int i;
/* 437 */     if ((i = s.indexOf('=')) < 0)
/* 438 */       return false;
/* 439 */     String s1 = s.substring(0, i).toLowerCase();
/* 440 */     String s2 = s.substring(i + 1, s.length());
/* 441 */     if (s1.equals("domain")) {
/* 442 */       this.sDomain = s2;
/* 443 */     } else if (s1.equals("path")) {
/* 444 */       this.sPath = s2;
/* 445 */     } else if (s1.equals("max-age")) {
/* 446 */       this.nMaxAge = V2CMiscUtil.parseInt(s2);
/* 447 */       if (this.nMaxAge < 0)
/* 448 */         return false;
/* 449 */       this.bMaxAge = true;
/* 450 */       long l = this.ltMaxAgeOrigin;
/* 451 */       if (l <= 0L) {
/* 452 */         l = System.currentTimeMillis();
/* 453 */         this.ltMaxAgeOrigin = l;
/*     */       }
/* 455 */       this.ltExpires = (this.nMaxAge * 1000L + l);
/* 456 */     } else if (s1.equals("expires")) {
/* 457 */       this.ltExpires = parseExpiresString(s2);
/* 458 */       if (this.ltExpires < 0L)
/* 459 */         return false;
/* 460 */     } else if (s1.equals("version")) {
/* 461 */       if (!s2.equals("1"))
/* 462 */         return false;
		}
		else if (s1.equals("samesite")){
			sSamesite = s2;
			System.out.println("samesite:URL=" + uURL);
/* 463 */     } else if (!s1.equals("comment")) {
/* 464 */       System.out.println("Unknown field: " + s1);
/* 465 */       return false;
/*     */     }
/* 467 */     return true;
/*     */   }
/*     */   
/*     */   long parseExpiresString(String s) {
/* 471 */     if (s.length() < 10)
/* 472 */       return -1L;
/* 473 */     if ((s.length() == 27) && (s.charAt(11) == '-') && (s.charAt(14) == ' '))
/* 474 */       s = s.substring(0, 12) + "20" + s.substring(12);
/* 475 */     return parseHttpDate(s);
/*     */   }
/*     */   
/*     */   boolean parseNameAndValue(String s) {
/*     */     int i;
/* 480 */     if ((i = s.indexOf('=')) <= 0) {
/* 481 */       return false;
/*     */     }
/* 483 */     this.sName = s.substring(0, i).trim();
/* 484 */     this.sValue = s.substring(i + 1, s.length());
/* 485 */     return true;
/*     */   }
/*     */   
/*     */   public boolean applicableTo(URL url)
/*     */   {
/* 490 */     String s = url.getHost();
/* 491 */     String s1 = url.getPath();
/* 492 */     if ((s == null) || (s1 == null))
/* 493 */       return false;
/* 494 */     String s2 = this.sDomain;
/*     */     boolean flag;
/* 496 */     /*boolean flag;*/ if (s2.startsWith(".")) {
/* 497 */       flag = (s.endsWith(s2)) || ((s.length() == s2.length() - 1) && (s.regionMatches(0, s2, 1, s.length())));
/*     */     } else
/* 499 */       flag = s.equals(s2);
/*     */     boolean flag1;
/* 501 */     /*boolean flag1;*/ if (this.sPath.endsWith("/")) {
/* 502 */       flag1 = s1.startsWith(this.sPath); } else { // boolean flag1;
/* 503 */       if (s1.length() < this.sPath.length()) {
/* 504 */         flag1 = false; } else { // boolean flag1;
/* 505 */         if (s1.length() > this.sPath.length()) {
/* 506 */           flag1 = (s1.startsWith(this.sPath)) && (s1.charAt(this.sPath.length()) == '/');
/*     */         } else
/* 508 */           flag1 = s1.equals(this.sPath); } }
/* 509 */     return (flag) && (flag1);
/*     */   }
/*     */   
/*     */   boolean miscCheck() {
/* 513 */     if (this.sDomain.indexOf(".yourfilehost.com") >= 0)
/* 514 */       return false;
/* 515 */     if ((this.sDomain.indexOf(".twitter.com") >= 0) && (this.sName.matches("_twitter_sess|twid")))
/* 516 */       return false;
/* 517 */     return this.sDomain.indexOf(".twitpic.com") < 0;
/*     */   }
/*     */   
/*     */   public int compareTo(V2CCookie v2ccookie) {
/* 521 */     return this.sPath.length() - v2ccookie.sPath.length();
/*     */   }
/*     */   
/*     */   public boolean matches(V2CCookie v2ccookie) {
/* 525 */     return (this.bValid) && (v2ccookie.isValid()) && (this.sName.equals(v2ccookie.sName)) && (this.sDomain.equals(v2ccookie.sDomain)) && 
/* 526 */       (this.sPath.equals(v2ccookie.sPath));
/*     */   }
/*     */   
/*     */   boolean matches(String s, String s1, String s2) {
/* 530 */     return (this.bValid) && (this.sName.equals(s)) && (this.sDomain.equals(s1)) && (this.sPath.equals(s2));
/*     */   }
/*     */   
/*     */   String getURLString() {
/* 534 */     return this.uURL.toString();
/*     */   }
/*     */   
/*     */   public boolean isValid() {
/* 538 */     return this.bValid;
/*     */   }
/*     */   
/*     */   public String toString() {
/* 542 */     return 
/* 543 */       "name: " + this.sName + "\nvalue: " + this.sValue + "\ndomain: " + this.sDomain + "\npath: " + this.sPath + "\nexpires: " + new Date(this.ltExpires) + "\n";
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/* 549 */   private static final Object vBeLoginMonitor = new Object();
/*     */   static String sDMDMValue;
/*     */   static String sMDMDValue;
/* 552 */   private static ArrayList alCookieList = new ArrayList();
/*     */   private static boolean bRestored;
/*     */   private static boolean bChanged;
/*     */   String sRaw;
/*     */   String sName;
/*     */   String sValue;
/*     */   String sDomain;
/*     */   String sPath;
/*     */   long ltExpires;
/*     */   int nMaxAge;
/*     */   boolean bMaxAge;
/*     */   long ltMaxAgeOrigin;
/*     */   boolean bValid;
/*     */   URL uURL;
/* 566 */   private static SimpleDateFormat[] lSimpleDateFormat = { new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z"), 
/* 567 */     new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z") };
	public static void removeAllCookies(){
		int cnum = alCookieList.size();
		synchronized (alCookieList) {
			alCookieList = new ArrayList();
			File cookieTxt = new File(V2CLocalFileHandler.getV2CDir(), "cookie.txt");
			if(cookieTxt.exists()){
				cookieTxt.delete();
			}
			if(alCookieList.size() == 0){
				V2CSwingUtil.showInformationMessage(cnum + "個のクッキーを全て削除しました");
			}else{
				V2CSwingUtil.showErrorMessage(cnum + "個のクッキーを削除できませんでした");
			}
		}
	}

	public static void removeTargetCookies(){
		removeTargetCookies(".5ch.net,.bbspink.com");
	}

	public static void removeTargetCookies(String sDomains){
		String[] aDomains = sDomains.replaceAll(" ", "").replaceAll(",+", ",").replaceAll("^,|,$", "").split(",");
		int cnum = alCookieList.size();
		int dnum = 0;
		ArrayList localArrayList = (ArrayList) alCookieList;
		synchronized (alCookieList) {
			for(int k=0; k<aDomains.length; k++){
				if(aDomains[k].length() != 0){
					System.out.println("クッキー削除対象ドメイン：" + aDomains[k]);
					for (int j = localArrayList.size()-1; j >= 0; j--) {
						V2CCookie localV2CCookie = (V2CCookie) localArrayList.get(j);
						if(localV2CCookie.sDomain.indexOf(aDomains[k]) != -1){
							if(localV2CCookie.sDMDMValue == null || localV2CCookie.sMDMDValue == null ||
							   localV2CCookie.sDMDMValue == ""   || localV2CCookie.sMDMDValue == ""
							){
								System.out.println("削除したクッキー：" + localV2CCookie.uURL + " " + localV2CCookie.sName + "=" + localV2CCookie.sValue);
								localArrayList.remove(j);
								dnum++;
							}
						}
					}
				}
			}
			if(dnum != 0){
				bChanged = true;
				saveCookies();
			}
			V2CSwingUtil.showInformationMessage("「" + sDomains + "」のクッキーを" + dnum + "個の削除しました");
		}
	}

	public static void UpdateCookie(String sUrl, String sName, String sDomain, String sRaw){
		UpdateCookie(sUrl, sName, sDomain, sRaw, true);
	}

	public static void UpdateCookie(String sUrl, String sName, String sDomain, String sRaw, boolean showDialog){
			int cnum = alCookieList.size();
			int dnum = 0;
			int dnum1 = 0;
			ArrayList localArrayList = (ArrayList) alCookieList;
			synchronized (alCookieList) {
				if(sDomain.length() != 0){
					for (int j = localArrayList.size()-1; j >= 0; j--) {
						V2CCookie localV2CCookie = (V2CCookie) localArrayList.get(j);
						if(localV2CCookie.sDomain.indexOf(sDomain) != -1 && localV2CCookie.sName.equals(sName)){
							System.out.println("削除したクッキー：" + localV2CCookie.uURL + " " + localV2CCookie.sName + "=" + localV2CCookie.sValue);
							localArrayList.remove(j);
							bChanged = true;
							saveCookies();
							dnum++;
							break;
						}
					}
					if(sRaw != null){
						try {
							System.out.println((dnum!=0?"更新":"追加") + "対象：ドメイン：" + sDomain + "、名前：" + sName + "、生Cookie：" + sRaw);
							addCookie(sRaw, new URL(sUrl));
							bChanged = true;
							saveCookies();
							dnum1++;
						} catch (MalformedURLException e) {
							// TODO 自動生成された catch ブロック
							e.printStackTrace();
						}
					}
				}
				if(dnum != 0){
					String label = "削除";
					if(dnum1 != 0){
						label = "更新";
					}
					if(showDialog) V2CSwingUtil.showInformationMessage("「" + sDomain + "」の「" + sName + "」を" + label + "しました");
				}
			}
	}

	String sSamesite;
/*     */ 
}


/* Location:              H:\__dat\V2C\jar\V2C_R20171103_p_1.1.3.jar!\org\monazilla\v2c\V2CCookie.class
 * Java compiler version: 7 (51.0)
 * JD-Core Version:       0.7.1
 */