/*     */ package org.monazilla.v2c;
/*     */ 
/*     */ import java.awt.Container;
/*     */ import java.awt.Dimension;
/*     */ import java.awt.FlowLayout;
/*     */ import java.awt.Insets;
/*     */ import java.awt.Point;
/*     */ import java.awt.Rectangle;
/*     */ import java.awt.Window;
/*     */ import java.awt.event.ActionEvent;
/*     */ import java.awt.event.ActionListener;
/*     */ import java.awt.event.MouseEvent;
/*     */ import java.net.URL;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ import javax.swing.BorderFactory;
/*     */ import javax.swing.JButton;
/*     */ import javax.swing.JDialog;
/*     */ import javax.swing.JLabel;
/*     */ import javax.swing.JPanel;
/*     */ import javax.swing.JScrollPane;
/*     */ import javax.swing.JWindow;
/*     */ import javax.swing.SwingUtilities;
/*     */ import javax.swing.event.HyperlinkEvent;
/*     */ import javax.swing.event.HyperlinkEvent.EventType;
/*     */ import javax.swing.event.HyperlinkListener;
/*     */ import javax.swing.event.MouseInputAdapter;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public final class V2CBePopup
/*     */   extends V2CHTMLPane
/*     */   implements V2CPopupPanel, HyperlinkListener
/*     */ {
/*     */   static final String sBeCondKey = "ThreadView.BePopup";
/*     */   
/*     */   private class ClickListener
/*     */     extends MouseInputAdapter
/*     */   {
/*     */     boolean bDragged;
/*     */     
/*     */     public void mouseDragged(MouseEvent mouseevent)
/*     */     {
/*  49 */       this.bDragged = true;
/*     */     }
/*     */     
/*     */     public void mousePressed(MouseEvent mouseevent) {
/*  53 */       this.bDragged = false;
/*     */     }
/*     */     
/*     */     public void mouseClicked(MouseEvent mouseevent) {
/*  57 */       if ((this.bDragged) || (mouseevent.getButton() != 1)) {
/*  58 */         return;
/*     */       }
/*  60 */       V2CBePopup.this.closePopupWindow();
/*     */     }
/*     */     
/*     */ 
/*     */     ClickListener(ClickListener param1)
/*     */     {
/*  66 */       this();
/*     */     }
/*     */     
/*     */ 
/*     */     private ClickListener() {}
/*     */   }
/*     */   
/*     */   private class GetFlogThread
/*     */     implements Runnable
/*     */   {
/*     */     String sFlogURL;
/*     */     
/*     */     public void run()
/*     */     {
/*  80 */       V2CHttpUtil.CAndC candc = V2CHttpUtil.getHTTPFile(this.sFlogURL, null, "EUC-JP", "application/x-javascript", 0L);
/*  81 */       if (Thread.currentThread().isInterrupted()) {
/*  82 */         return;
/*     */       }
/*  84 */       String s = null;
/*  85 */       if (candc != null) {
/*  86 */         s = candc.getContents();
/*     */       }
/*  88 */       V2CBePopup.this.putFlog(this.sFlogURL, s);
/*  89 */       SwingUtilities.invokeLater(new Runnable() {
/*     */         public void run() {
/*  91 */           V2CBePopup.this.updateFlog();
/*     */         }
/*     */       });
/*     */     }
/*     */     
/*     */     GetFlogThread(String s)
/*     */     {
/*  98 */       this.sFlogURL = s;
/*     */     }
/*     */   }
/*     */   
/*     */   private static String execBePopupScript(String id)
/*     */   {
/*     */     try {
/* 105 */       if (!V2CBePopupScript.bLoadTried) {
/* 106 */         V2CBePopupScript localV2CBePopupScript = (V2CBePopupScript)
/* 107 */           V2CScriptUtil.createUserScript("be_popup.js");
/*     */       }
/* 109 */       String dmdm = null;
/* 110 */       String mdmd = null;
/*     */       
/* 112 */       V2CBeIDListItem beItem = V2C2chBBS.getDefBeIDListItem();
/* 113 */       if (beItem != null) {
/* 114 */         dmdm = beItem.sDMDM;
/* 115 */         mdmd = beItem.sMDMD;
/*     */       }
/*     */       
/* 118 */       String result = (String)V2CBePopupScript.getBePopupText(id, dmdm, mdmd);
/*     */       
/* 120 */       if (result == null) {}
/* 121 */       return "<html><body>スクリプト実行エラー<br>be_popup.js</body></html>";
/*     */ 
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 126 */       e.printStackTrace(); }
/* 127 */     return null;
/*     */   }
/*     */   
/*     */ 
/*     */   private static class GetProfileThread
/*     */     extends Thread
/*     */   {
/*     */     final Integer iLocalBeID;
/*     */     
/*     */     final String sProfileURL;
/*     */     
/*     */     final V2CBePopup vBePopup;
/*     */     
/*     */     final V2CAbstractThreadPanel vAbstractThreadPanel;
/*     */     final Object vPopupKey;
/*     */     final String sHtml;
/*     */     
/*     */     public void run()
/*     */     {
/* 146 */       String html = this.sHtml;
/*     */       
/*     */ 
/* 149 */       if (html == null) {
/* 150 */         html = V2CHttpUtil.getHTMLFileUseBeCookie(this.sProfileURL, "UTF-8");
/*     */       }
/*     */       
/*     */ 
/* 154 */       if (Thread.currentThread().isInterrupted()) {
/* 155 */         return;
/*     */       }
/*     */       
/* 158 */       if ((html != null) && (!html.contains("ちゃんねる")) && (!html.contains("BEポイント")) && (!html.toLowerCase().contains("charset=\"utf-8\""))) {
/* 159 */         String charSet = V2CAppendUtil.getSandString(html, "charset=\"", "\">");
/* 160 */         html = V2CHttpUtil.getHTMLFileUseBeCookie(this.sProfileURL, charSet);
/*     */       }
/*     */       
/* 163 */       if (Thread.currentThread().isInterrupted()) {
/* 164 */         return;
/*     */       }
/*     */       
/* 167 */       if ((html == null) || (html.length() == 0)) {
/* 168 */         StringBuilder sb = new StringBuilder();
/* 169 */         sb.append("<html><body>ダウンロード失敗");
/*     */         
/* 171 */         if (V2CAppendUtil.isBeLoggedIn()) {
/* 172 */           sb.append("<br><br><font size=\"-1\">BEの再ログインを行うと<br>改善されるかもしれません。</font>");
/*     */         }
/*     */         
/* 175 */         sb.append("</body></html>");
/*     */         
/* 177 */         html = sb.toString();
/*     */       }
/*     */       
/*     */ 
/* 181 */       boolean bFollowed = V2CAppendUtil.isBeFollowd(html);
/* 182 */       V2CBePopup.followIdMap.put(this.iLocalBeID, Boolean.valueOf(bFollowed));
/*     */       final String popupText;
/* 184 */       if (V2CPlusProperty.isUseBePopupScript()) {
/* 185 */         popupText = V2CBePopup.execBePopupScript(String.valueOf(this.iLocalBeID));
/* 186 */         V2CBePopup.hmProfiles.put(this.iLocalBeID, popupText);
/*     */       } else {
/* 188 */         popupText = V2CBePopup.putProfile(this.iLocalBeID, html);
/*     */       }
/*     */       
/*     */ 
/* 192 */       if (this.vBePopup != null) {
/* 193 */         this.vBePopup.vtpParent.forceRepaint();
/* 194 */         SwingUtilities.invokeLater(new Runnable() {
/*     */           public void run() {
/* 196 */             V2CBePopup.GetProfileThread.this.vBePopup.updateText(popupText, true);
/*     */           }
/*     */         });
/* 199 */       } else if (this.vAbstractThreadPanel != null) {
/* 200 */         this.vAbstractThreadPanel.beProfileUpdated(this.vPopupKey);
/*     */       }
/*     */     }
/*     */     
/*     */     GetProfileThread(Integer integer, String s, V2CAbstractThreadPanel v2cabstractthreadpanel, Object obj) {
/* 205 */       this(integer, s, null, v2cabstractthreadpanel, obj, null);
/*     */     }
/*     */     
/*     */     GetProfileThread(String s, V2CBePopup v2cbepopup) {
/* 209 */       this(v2cbepopup.iBeID, s, v2cbepopup, null, null, null);
/*     */     }
/*     */     
/*     */     GetProfileThread(String s, V2CBePopup v2cbepopup, String html) {
/* 213 */       this(v2cbepopup.iBeID, s, v2cbepopup, null, null, html);
/*     */     }
/*     */     
/*     */     GetProfileThread(Integer integer, String s, V2CBePopup v2cbepopup, V2CAbstractThreadPanel v2cabstractthreadpanel, Object popupKey) {
/* 217 */       this(integer, s, v2cbepopup, v2cabstractthreadpanel, popupKey, null);
/*     */     }
/*     */     
/*     */     GetProfileThread(Integer integer, String s, V2CBePopup v2cbepopup, V2CAbstractThreadPanel v2cabstractthreadpanel, Object popupKey, String html) {
/* 221 */       this.iLocalBeID = integer;
/* 222 */       this.sProfileURL = s;
/* 223 */       this.vBePopup = v2cbepopup;
/* 224 */       this.vAbstractThreadPanel = v2cabstractthreadpanel;
/* 225 */       this.vPopupKey = popupKey;
/* 226 */       this.sHtml = html;
/*     */       
/* 228 */       if ((this.iLocalBeID != null) && (this.sProfileURL != null)) {
/* 229 */         V2CBePopup.profileUrlMap.put(this.iLocalBeID, this.sProfileURL);
/*     */       }
/*     */     }
/*     */   }
/*     */   
/*     */ 
/* 235 */   static Pattern pHTTP = Pattern.compile("([^=\"])(https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+)");
/*     */   
/* 237 */   static Map hmProfiles = Collections.synchronizedMap(new HashMap());
/* 238 */   static Map hmFlogBookmarks = Collections.synchronizedMap(new HashMap());
/*     */   
/* 240 */   static Map<Integer, Boolean> followIdMap = Collections.synchronizedMap(new HashMap());
/* 241 */   static Map<Integer, String> profileUrlMap = Collections.synchronizedMap(new HashMap());
/*     */   
/*     */   V2CAbstractThreadPanel vtpParent;
/*     */   Window jwPopupWindow;
/*     */   Container cContainer;
/*     */   JScrollPane jScrollPane;
/*     */   JLabel jlURL;
/*     */   Point pLocation;
/*     */   int iFlogIndex;
/*     */   final boolean bRemote;
/*     */   Thread thGetProfile;
/*     */   Thread thGetFlogBookmark;
/*     */   Integer iBeID;
/* 254 */   static Pattern pFlogScript = Pattern.compile("<script src=\"(http://www.flog.jp/[-_a-zA-Z0-9/]+.js)\" type=\"text/javascript\">");
/* 255 */   private static final Pattern pDivLeft = Pattern.compile("<div\\sid=\"leftside\">");
/* 256 */   private static final Pattern pDivRight = Pattern.compile("<div\\sid=\"rightside\">");
/* 257 */   private static final Pattern pDivContent = Pattern.compile("<div\\sid=\"content\">");
/*     */   
/*     */   static boolean hasCache(Integer integer) {
/* 260 */     return hmProfiles.containsKey(integer);
/*     */   }
/*     */   
/*     */   static void clearCache(Integer integer)
/*     */   {
/* 265 */     hmProfiles.remove(integer);
/*     */   }
/*     */   
/*     */   static String getSimpleInfo(Integer integer)
/*     */   {
/* 270 */     return (String)hmProfiles.get(integer);
/*     */   }
/*     */   
/*     */   private static String getBodyTextTagString() {
/* 274 */     return "<body bgcolor=\"" + V2CSwingUtil.colorToString(V2CThreadPopup.cPopupBG) + "\" text=\"" + V2CSwingUtil.colorToString(V2CThreadStyle.getDefaultForeground()) + "\">";
/*     */   }
/*     */   
/*     */   public V2CBePopup(V2CAbstractThreadPanel v2cabstractthreadpanel, Point point, Integer integer) {
/* 278 */     this(v2cabstractthreadpanel, null, point, integer, false);
/*     */   }
/*     */   
/*     */   public V2CBePopup(V2CAbstractThreadPanel v2cabstractthreadpanel, String s, Point point, Integer integer) {
/* 282 */     this(v2cabstractthreadpanel, s, point, integer, true);
/*     */   }
/*     */   
/*     */   private V2CBePopup(V2CAbstractThreadPanel v2cabstractthreadpanel, String s, Point point, Integer integer, boolean flag) {
/* 286 */     this.iBeID = integer;
/* 287 */     this.bRemote = flag;
/* 288 */     setBackground(V2CThreadPopup.cPopupBG);
/* 289 */     this.vtpParent = v2cabstractthreadpanel;
/* 290 */     this.pLocation = point;
/* 291 */     ClickListener clicklistener = new ClickListener(null);
/* 292 */     addMouseListener(clicklistener);
/* 293 */     addMouseMotionListener(clicklistener);
/* 294 */     addHyperlinkListener(this);
/* 295 */     this.jScrollPane = new JScrollPane(this);
/* 296 */     if (V2CApp.isUNIX()) {
/* 297 */       JWindow jwindow = new JWindow(V2CMain.v2cMain);
/* 298 */       this.jwPopupWindow = jwindow;
/* 299 */       this.cContainer = jwindow.getContentPane();
/*     */     } else {
/* 301 */       JDialog jdialog = new JDialog(V2CMain.v2cMain, false);
/* 302 */       this.jwPopupWindow = jdialog;
/* 303 */       jdialog.setUndecorated(true);
/* 304 */       this.cContainer = jdialog.getContentPane();
/*     */     }
/* 306 */     this.cContainer.add(this.jScrollPane, "Center");
/*     */     
/*     */ 
/* 309 */     this.followButton.addActionListener(new ActionListener()
/*     */     {
/*     */       public void actionPerformed(ActionEvent arg0) {
/* 312 */         V2CBePopup.this.changeFollow();
/*     */ 
/*     */ 
/*     */ 
/*     */       }
/*     */       
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/* 322 */     });
/* 323 */     this.jwPopupWindow.setLocation(point);
/* 324 */     this.jwPopupWindow.setSize(0, 0);
/* 325 */     this.jwPopupWindow.setVisible(true);
/*     */     String s1;
/* 327 */     if (flag) {
/* 328 */       s1 = "<html>" + getBodyTextTagString() + "プロフィール取得中…</body></html>";
/*     */     } else {
/* 330 */       s1 = (String)hmProfiles.get(integer);
/* 331 */       if (s1 == null) {
/* 332 */         s1 = "<html>" + getBodyTextTagString() + "プロフィール情報がありません。</body></html>";
/*     */       }
/*     */     }
/* 335 */     updateText(s1, true);
/*     */     
/* 337 */     if (flag) {
/* 338 */       this.thGetProfile = new Thread(new GetProfileThread(s, this));
/* 339 */       this.thGetProfile.start();
/*     */     }
/*     */   }
/*     */   
/*     */   public boolean isCloseOnExit() {
/* 344 */     return false;
/*     */   }
/*     */   
/*     */   public void closePopupWindow() {
/* 348 */     if (this.vtpParent != null) {
/* 349 */       V2CAbstractThreadPanel v2cabstractthreadpanel = this.vtpParent;
/* 350 */       this.vtpParent = null;
/* 351 */       if (v2cabstractthreadpanel.requestClosePopup(this)) {
/* 352 */         return;
/*     */       }
/*     */     }
/* 355 */     if ((this.thGetProfile != null) && (this.thGetProfile.isAlive())) {
/* 356 */       this.thGetProfile.interrupt();
/*     */     }
/* 358 */     if ((this.thGetFlogBookmark != null) && (this.thGetFlogBookmark.isAlive())) {
/* 359 */       this.thGetFlogBookmark.interrupt();
/*     */     }
/* 361 */     this.jwPopupWindow.dispose();
/*     */   }
/*     */   
/*     */   private void updateText(String s, boolean flag)
/*     */   {
/* 366 */     Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(this.pLocation);
/* 367 */     Dimension dimension = V2CThreadPopup.getMaxPopupSize();
/* 368 */     Insets insets = this.jScrollPane.getInsets();
/* 369 */     int i = Math.min(dimension.width, rectangle.width - 2);
/* 370 */     int j = Math.min(dimension.height, rectangle.height - 2);
/* 371 */     s = checkFlog(s, flag);
/* 372 */     createLabelIfNecessary(s);
/*     */     
/*     */ 
/*     */ 
/* 376 */     if (!V2CPlusProperty.isUseBePopupScript()) {
/* 377 */       s = s.replaceAll("(?s)<script(?: [^>]+)?>.*?</script>", "\n");
/*     */     }
/*     */     
/*     */ 
/* 381 */     doSetText(s);
/* 382 */     V2CHTMLPane v2chtmlpane = new V2CHTMLPane(s);
/* 383 */     Dimension dimension1 = v2chtmlpane.getPreferredSize();
/*     */     int k;
/* 385 */     if (this.jlURL != null) {
/* 386 */       k = this.jlURL.getPreferredSize().height;
/*     */     } else {
/* 388 */       k = 0;
/*     */     }
/* 390 */     int width = Math.min(dimension1.width + insets.left + insets.right + 20, i);
/*     */     
/*     */     int height;

/* 394 */     if (V2CPlusProperty.isFixedBePopupHeight()) {
/* 395 */       height = V2CPlusProperty.getBePopupHeight();
/*     */     }
/*     */     else {
/* 398 */       height = Math.min(dimension1.height + insets.top + insets.bottom + 45, j - k);
/*     */     }
/*     */     
/*     */ 
/* 402 */     this.jScrollPane.setPreferredSize(new Dimension(width, height));
/* 403 */     height += k;
/* 404 */     int j1 = (int)this.pLocation.getX();
/* 405 */     int k1 = (int)this.pLocation.getY();
/* 406 */     boolean flag1 = false;
/* 407 */     if (j1 + width + 2 > rectangle.x + rectangle.width) {
/* 408 */       flag1 = true;
/* 409 */       j1 = rectangle.x + rectangle.width - width - 1;
/*     */     }
/* 411 */     if (k1 + height + 2 > rectangle.y + rectangle.height) {
/* 412 */       flag1 = true;
/* 413 */       k1 = rectangle.y + rectangle.height - height - 1;
/*     */     }
/* 415 */     if (flag1) {
/* 416 */       this.jwPopupWindow.setLocation(j1, k1);
/*     */     }
/*     */     
/* 419 */     if ((V2CPlusProperty.isShowBeFollowButton()) && (V2CAppendUtil.isBeLoggedIn()) && (!s.contains("プロフィール情報がありません。</body></html>")) && (!s.contains("プロフィール取得中…</body></html>")) && (!s.contains("<html><body>ダウンロード失敗"))) {
/* 420 */       this.followButton.setText(isFollowed(this.iBeID) ? "フォロー解除" : "フォローする");
/* 421 */       JPanel p = new JPanel(new FlowLayout());
/* 422 */       p.add(this.followButton);
/*     */       
/*     */ 
/* 425 */       this.jwPopupWindow.add(p, "North");
/*     */     }
/*     */     
/* 428 */     this.jwPopupWindow.pack();
/* 429 */     SwingUtilities.invokeLater(new Runnable() {
/*     */       public void run() {
/* 431 */         V2CBePopup.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
/*     */       }
/*     */     });
/*     */   }
/*     */   
/*     */   static boolean isFollowed(Integer iBeID)
/*     */   {
/* 438 */     Boolean boo = (Boolean)followIdMap.get(iBeID);
/* 439 */     return (boo != null) && (boo.booleanValue());
/*     */   }
/*     */   
/* 442 */   private JButton followButton = new JButton();
/*     */   
/*     */   private void changeFollow()
/*     */   {
/* 446 */     if ((this.iBeID == null) || (this.iBeID.intValue() <= 0)) {
/* 447 */       return;
/*     */     }
/*     */     
/* 450 */     String beid = String.valueOf(this.iBeID);
/* 451 */     String userPageUrl = V2CAppendUtil.getBeUserPageUrl(beid);
/*     */     
/* 453 */     boolean follow = !isFollowed(this.iBeID);
/* 454 */     String postUrl = V2CAppendUtil.getBeFollowPostUrl(follow, beid);
/*     */     
/*     */ 
/*     */ 
/*     */ 
/* 459 */     V2CHttpUtil.CAndC candc = V2CHttpUtil.postFormUseBeCookie(postUrl, userPageUrl, "", "UTF-8", null, false, null);
/*     */     
/* 461 */     if (candc != null) {
/* 462 */       String sProfileUrl = (String)profileUrlMap.get(this.iBeID);
/* 463 */       clearCache(this.iBeID);
/*     */       
/* 465 */       if (V2CAppendUtil.isEmpty(sProfileUrl)) {
/* 466 */         return;
/*     */       }
/*     */       
/* 469 */       String html = V2CHttpUtil.getHTMLFileUseBeCookie(sProfileUrl, "UTF-8");
/* 470 */       boolean bFollowed = V2CAppendUtil.isBeFollowd(html);
/*     */       
/* 472 */       if (((follow) && (bFollowed)) || ((!follow) && (!bFollowed))) {
/* 473 */         this.thGetProfile = new Thread(new GetProfileThread(sProfileUrl, this, html));
/* 474 */         this.thGetProfile.start();
/*     */       } else {
/* 476 */         V2CSwingUtil.showErrorMessage((follow ? "フォロー" : "フォロー解除") + "リクエストを送信しましたがステータスが更新されなかったようです。\nBEの再ログインを行うことで改善されるかもしれません。");
/*     */       }
/*     */     }
/*     */   }
/*     */   
/*     */   String checkFlog(String s, boolean flag)
/*     */   {
/* 483 */     int i = 0;
/*     */     
/*     */     for (;;)
/*     */     {
/* 487 */       Matcher matcher = pFlogScript.matcher(s);
/* 488 */       if (!matcher.find(i)) {
/* 489 */         return s;
/*     */       }
/* 491 */       i = matcher.start();
/* 492 */       s = s.substring(0, i) + s.substring(matcher.end());
/* 493 */       String s1 = matcher.group(1);
/* 494 */       if (s1.endsWith("/sb-euc.js")) {
/* 495 */         this.iFlogIndex = i;
/* 496 */         if ((flag) && (this.bRemote)) {
/* 497 */           this.thGetFlogBookmark = new Thread(new GetFlogThread(s1));
/* 498 */           this.thGetFlogBookmark.start();
/*     */         } else {
/* 500 */           String s2 = (String)hmFlogBookmarks.get(s1);
/* 501 */           if (s2 != null) {
/* 502 */             s = insertFlog(s, s2);
/* 503 */             i += s2.length();
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */   
/* 510 */   private void updateFlog() { String s = (String)hmProfiles.get(this.iBeID);
/* 511 */     if ((s == null) || (s.length() < this.iFlogIndex)) {
/* 512 */       return;
/*     */     }
/* 514 */     updateText(s, false);
/*     */   }
/*     */   
/*     */ 
/*     */   private String insertFlog(String s, String s1)
/*     */   {
/* 520 */     return s.substring(0, this.iFlogIndex) + s1 + s.substring(this.iFlogIndex);
/*     */   }
/*     */   
/*     */   private void createLabelIfNecessary(String s) {
/* 524 */     if ((this.jlURL != null) || ((s.indexOf("<a ") < 0) && (s.indexOf("<A ") < 0))) {
/* 525 */       return;
/*     */     }
/* 527 */     this.jlURL = new JLabel(" ");
/* 528 */     this.jlURL.setOpaque(true);
/* 529 */     this.jlURL.setForeground(V2CThreadStyle.getDefaultForeground());
/* 530 */     this.jlURL.setBackground(V2CThreadPopup.cPopupBG);
/* 531 */     this.jlURL.setBorder(BorderFactory.createBevelBorder(1));
/* 532 */     this.cContainer.add(this.jlURL, "South");
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */   private static String putProfile(Integer iBeID, String s)
/*     */   {
/* 539 */     for (int i = 0; (i = s.indexOf("<form ", i)) > 0;) {
/* 540 */       int j = s.indexOf("</form>", i + 6);
/* 541 */       if (j > 0) {
/* 542 */         s = s.substring(0, i) + s.substring(j + 7);
/*     */       } else {
/* 544 */         i += 6;
/*     */       }
/*     */     }
/*     */     
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/* 553 */     s = s.replaceAll("<p></p>", "");
/* 554 */     Matcher matcher = pHTTP.matcher(s);
/*     */     
/* 556 */     s = matcher.replaceAll("$1<a href=\"$2\">$2</a>");
/* 557 */     Matcher matcher1 = pDivContent.matcher(s);
/* 558 */     Matcher matcher2 = pDivLeft.matcher(s);
/* 559 */     Matcher matcher3 = pDivRight.matcher(s);
/* 560 */     if ((matcher1.find()) && (matcher2.find()) && (matcher3.find())) {
/* 561 */       int k = s.indexOf("</div>", matcher1.end());
/* 562 */       int l = s.indexOf("</div>", matcher2.end());
/* 563 */       int i1 = s.indexOf("</div>", matcher3.end());
/* 564 */       if ((k > 0) && (l > 0) && (i1 > 0)) {
/* 565 */         StringBuilder sb = new StringBuilder();
/* 566 */         sb.append("<html><body bgcolor=\"");
/* 567 */         sb.append(V2CSwingUtil.colorToString(V2CThreadPopup.cPopupBG));
/* 568 */         sb.append("\" text=\"");
/* 569 */         sb.append(V2CSwingUtil.colorToString(V2CThreadStyle.getDefaultForeground()));
/* 570 */         sb.append("\"><table border=\"1\" rules=\"all\" cellspacing=\"1\" cellpadding=\"5\"><tr><td width=\"170\" valign=\"top\">");
/* 571 */         sb.append(s.substring(matcher2.end(), l).replaceAll("/>", ">"));
/* 572 */         sb.append("</font></td><td width=\"400\" valign=\"top\">");
/* 573 */         sb.append(s.substring(matcher1.end(), k).replaceAll("/>", ">"));
/* 574 */         sb.append("</font></td><td width=\"150\" valign=\"top\">");
/* 575 */         sb.append(s.substring(matcher3.end(), i1).replaceAll("/>", ">"));
/* 576 */         sb.append("</font></td></tr></body></html>");
/* 577 */         s = sb.toString();
/*     */       }
/*     */     }
/*     */     
/*     */ 
/*     */ 
/*     */ 
/* 584 */     s = V2CMiscUtil.replaceAll(s, "<img src=\"/", "<img src=\"https://be.5ch.net/");
/* 585 */     s = V2CMiscUtil.replaceFirst(s, "href=\"/\">", "href=\"https://be.5ch.net/\">");
/*     */     
/*     */ 
/* 588 */     String cutStr = "<div class=\"be-status\">";
/* 589 */     if (s.contains(cutStr)) {
/* 590 */       s = V2CAppendUtil.getSandString(s, cutStr, "</body>") + "</body>";
/*     */     }
/*     */     
/* 593 */     cutStr = "<div class=\"clearfix\" style=\"background-color:black;\">";
/* 594 */     if (s.contains(cutStr)) {
/* 595 */       String replaceStr = V2CAppendUtil.getLastSandString(s, cutStr, "</body>");
/* 596 */       s = V2CMiscUtil.replaceFirst(s, replaceStr, "");
/*     */     }
/*     */     
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/* 603 */     String idReplaceStr = "<div class=\"be-id be-stat-mleft\">\n<span>([0-9]+)</span>\n</div>";
/* 604 */     Pattern idPattern = Pattern.compile(idReplaceStr);
/* 605 */     Matcher m = idPattern.matcher(s);
/* 606 */     if (m.find()) {
/* 607 */       String id = m.group(1);
/* 608 */       String str = "ID： <a href=\"https://be.5ch.net/user/" + id + "\">" + id + "</a>";
/* 609 */       s = s.replaceFirst(idReplaceStr, str);
/*     */     }
/*     */     
/*     */ 
/*     */ 
/* 614 */     if (s.contains("<div id=\"eStat\">\n</div>")) {
/* 615 */       s = V2CMiscUtil.replaceFirst(s, "\n<div class=\"form-group eStatCont\">\n<div id=\"eStat\">\n</div>\n</div>", "");
/*     */     } else {
/* 617 */       s = V2CMiscUtil.replaceFirst(s, "<div id=\"eStat\">\n", "<div id=\"eStat\">紹介文： ");
/* 618 */       s = V2CMiscUtil.replaceFirst(s, "</div>\n<div class=\"clearfix\" style=\"background-color:black;\">", "");
/*     */     }
/*     */     
/* 621 */     s = s.replaceFirst("<span id=\"eName\">.+</span>", "$0\n<div class=\"test\"></div>");
/* 622 */     s = s.replaceAll("</span>\n<div class=\"be-in-cont\">([0-9]{1,10})</div>", "： $1</span>");
/*     */     
/*     */ 
/* 625 */     if (isFollowed(iBeID)) {
/* 626 */       s = s.replaceFirst("<span id=\"eName\">(.+)</span>", "<span id=\"eName\"><font color=green>$1</font></span>");
/*     */     }
/*     */     
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/* 633 */     hmProfiles.put(iBeID, s);
/* 634 */     return s;
/*     */   }
/*     */   
/*     */   private String putFlog(String s, String s1)
/*     */   {
/* 639 */     String s2 = "flog error !!";
/* 640 */     if (s1 != null) {
/* 641 */       Matcher matcher = Pattern.compile("document.write\\(\"(.+)\"\\);").matcher(s1);
/* 642 */       if (matcher.matches()) {
/* 643 */         s2 = matcher.group(1);
/*     */       }
/*     */     }
/* 646 */     hmFlogBookmarks.put(s, s2);
/* 647 */     return s2;
/*     */   }
/*     */   
/*     */   public void hyperlinkUpdate(HyperlinkEvent hyperlinkevent) {
/* 651 */     URL url = hyperlinkevent.getURL();
/* 652 */     if (url == null) {
/* 653 */       return;
/*     */     }
/* 655 */     String s = url.toString();
/* 656 */     if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
/* 657 */       if (this.jlURL == null) {
/* 658 */         return;
/*     */       }
/* 660 */       String s1 = V2CMiscUtil.maybeGetURLDecodedString(s);
/* 661 */       if (s1 != null) {
/* 662 */         int i = s1.indexOf('\n');
/* 663 */         if (i >= 0) {
/* 664 */           s1 = s1.substring(0, i);
/*     */         }
/*     */       } else {
/* 667 */         s1 = s;
/*     */       }
/* 669 */       this.jlURL.setText(s1);
/* 670 */     } else if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.EXITED) {
/* 671 */       if (this.jlURL != null) {
/* 672 */         this.jlURL.setText(" ");
/*     */       }
/* 674 */     } else if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
/* 675 */       V2CMiscUtil.openUnknownLink(s, true, false, true);
/*     */     }
/*     */   }
/*     */   
/*     */   static boolean getBeProfileBG(Integer integer, String s, V2CAbstractThreadPanel v2cabstractthreadpanel, Object obj) {
/* 680 */     if (!V2CMain.isOnlineMode()) {
/* 681 */       return false;
/*     */     }
/* 683 */     new Thread(new GetProfileThread(integer, s, v2cabstractthreadpanel, obj)).start();
/* 684 */     return true;
/*     */   }
/*     */ }


/* Location:              H:\__dat\V2C\jar\V2C_R20171103_p_1.1.3.jar!\org\monazilla\v2c\V2CBePopup.class
 * Java compiler version: 7 (51.0)
 * JD-Core Version:       0.7.1
 */