/*      */ package org.monazilla.v2c;
/*      */ 
/*      */ import java.awt.BorderLayout;
/*      */ import java.awt.Color;
/*      */ import java.awt.EventQueue;
/*      */ import java.awt.FlowLayout;
/*      */ import java.awt.Font;
/*      */ import java.awt.GridBagConstraints;
/*      */ import java.awt.GridBagLayout;
/*      */ import java.awt.Insets;
/*      */ import java.awt.event.ActionEvent;
/*      */ import java.awt.event.ActionListener;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URL;
/*      */ import java.text.SimpleDateFormat;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.TimeZone;
/*      */ import java.util.regex.Matcher;
/*      */ import java.util.regex.Pattern;
/*      */ import javax.swing.AbstractAction;
/*      */ import javax.swing.Icon;
/*      */ import javax.swing.ImageIcon;
/*      */ import javax.swing.JButton;
/*      */ import javax.swing.JCheckBox;
/*      */ import javax.swing.JComponent;
/*      */ import javax.swing.JDialog;
/*      */ import javax.swing.JLabel;
/*      */ import javax.swing.JMenuItem;
/*      */ import javax.swing.JOptionPane;
/*      */ import javax.swing.JPanel;
/*      */ import javax.swing.JPopupMenu;
/*      */ import javax.swing.JScrollPane;
/*      */ import javax.swing.JTextField;
/*      */ 
/*      */ public abstract class V2CBBS implements V2CPropertyOwner
/*      */ {
/*      */   private static class OpenBoardAction extends AbstractAction
/*      */   {
/*      */     final V2CBoardItem vBoardItem;
/*      */     final boolean bNewTab;
/*      */     
/*      */     public void actionPerformed(ActionEvent actionevent)
/*      */     {
/*   48 */       this.vBoardItem.open(true, this.bNewTab);
/*      */     }
/*      */     
/*      */     OpenBoardAction(V2CBoardItem v2cboarditem, boolean flag) {
/*   52 */       this.vBoardItem = v2cboarditem;
/*   53 */       this.bNewTab = flag;
/*      */     }
/*      */   }
/*      */   
/*   57 */   static final Color COLOR_UNKNOWN = new Color(0, true);
/*      */   static final String sTestReadCGI = "/test/read.cgi/";
/*      */   static final String sBBSMenuURLKeyExt = ".BBSMenuURL:";
/*      */   static final String sBBSLabelKey = "BBS.Label:";
/*      */   static final String sBBSColorKey = "BBS.Color:";
/*   62 */   static final HashMap hmBBSs = new HashMap();
/*      */   static V2CBBS[] lBBSs;
/*      */   static V2C2chBBS v2chBBS;
/*      */   static V2CJBBSShitarabaBBS vJBBSShitarabaBBS;
/*      */   static V2C2chEqBBS v2chEqBBS;
/*      */   static V2CMachiBBS vMachiBBS;
/*      */   static V2CUserDefinedBBS vUserDefinedBBS;
/*      */   static V2CTwitterBBS vTwitterBBS;
/*      */   static final SimpleDateFormat dfForWritePreview;
/*      */   static final SimpleDateFormat dfForWritePreviewM;
/*      */   static final SimpleDateFormat dfForWritePreviewSS;
/*      */   static TimeZone tzWritePreview;
/*   74 */   static Icon icDefault = V2CSwingUtil.getItemIcon("BBS");
/*      */   
/*   76 */   static Pattern pPostStatusTag = Pattern.compile("<!-- *2ch_X:(true|false|error|check|cookie) *-->");
/*      */   
/*   78 */   static Pattern pSamba24 = Pattern.compile(" ([1-9][0-9]*) sec たたないと書けません");
/*   79 */   static Pattern pSamba24_2 = Pattern.compile("([1-9][0-9]*) ?秒 ?たたないと書けません");
/*      */   String sID;
/*      */   String sName;
/*      */   boolean bCreateTab;
/*      */   boolean bSetting;
/*      */   boolean bHead;
/*      */   String sCharset;
/*      */   String sDatContentType;
/*      */   int nDatFieldOffset;
/*      */   String sDatExt;
/*      */   Pattern pSubject;
/*      */   boolean bFileEndCheck;
/*      */   boolean bUseRangeRequestHeader;
/*      */   boolean bUseLocalResNum;
/*      */   boolean bCreateThreadSupported;
/*      */   boolean bPostSupported;
/*      */   boolean bWritePreviewSupported;
/*      */   boolean bUpdateModelSupported;
/*      */   boolean bResURLSupported;
/*      */   boolean bCanChangeBBSMenuURL;
/*      */   String sDefaultBBSMenuURL;
/*      */   V2CBoardTree vBoardTree;
/*      */   V2CTreeModel vTreeModel;
/*      */   V2CProperty vpProperties;
/*      */   String sSubmitInputValue;
/*      */   String sCreateThreadSubmitInputValue;
/*      */   String sTitleInputName;
/*      */   String sNameInputName;
/*      */   String sMailInputName;
/*      */   String sMessageInputName;
/*      */   String sBBSInputName;
/*      */   String sKeyInputName;
/*      */   String sTimeInputName;
/*      */   String sBBSCGI;
/*      */   String sSubBBSCGI;
/*      */   HashMap hmSamba24Time;
/*      */   V2CProperty vpSamba24Time;
/*      */   Color cBBSColor;
/*      */   private static final String KAKIKOMI_ERROR = "書き込みエラー";
/*      */   
/*      */   static V2CBBS[] getBBSArray() {
/*  120 */     return lBBSs;
/*      */   }
/*      */   
/*      */   static Iterator getBBSiterator() {
/*  124 */     return hmBBSs.values().iterator();
/*      */   }
/*      */   
/*      */   static V2CBBS get(String s) {
/*  128 */     return (V2CBBS)hmBBSs.get(s);
/*      */   }
/*      */   
/*      */   static V2CBBS guessBBS(String s) {
/*  132 */     for (Iterator iterator = getBBSiterator(); iterator.hasNext();) {
/*  133 */       V2CBBS v2cbbs = (V2CBBS)iterator.next();
/*  134 */       if (v2cbbs.containsBoard(s)) {
/*  135 */         return v2cbbs;
/*      */       }
/*      */     }
/*      */     
/*  139 */     return v2chEqBBS;
/*      */   }
/*      */   
/*      */   static String trimForBoardURL(String s) {
/*  143 */     if ((s == null) || (s.length() < 8)) {
/*  144 */       return null;
/*      */     }
/*  146 */     if ((s.charAt(7) == 'f') && 
/*  147 */       (s.startsWith("http://find.2ch.net/enq/board.php"))) {
/*  148 */       Matcher matcher = Pattern.compile("(?:\\?CAT=(\\d+))?").matcher(
/*  149 */         s.substring(33));
/*  150 */       if (matcher.matches()) {
/*  151 */         String s1 = matcher.group(1);
/*  152 */         if (s1 != null) {
/*  153 */           s = "http://find.2ch.net/enq/" + s1 + '/';
/*      */         } else {
/*  155 */           s = "http://find.2ch.net/enq/0/";
/*      */         }
/*      */       }
/*      */     }
/*  159 */     if (s.indexOf('?') >= 0) {
/*  160 */       return null;
/*      */     }
/*  162 */     if (s.indexOf('#') >= 0) {
/*  163 */       Matcher matcher1 = Pattern.compile("([^#]+)#\\d+").matcher(s);
/*  164 */       if (!matcher1.matches()) {
/*  165 */         return null;
/*      */       }
/*  167 */       s = matcher1.group(1);
/*      */     }
/*  169 */     if (s.charAt(s.length() - 1) != '/') {
/*  170 */       s = s + '/';
/*      */     }
/*  172 */     return s;
/*      */   }
/*      */   
/*      */   boolean is2ch() {
/*  176 */     return false;
/*      */   }
/*      */   
/*      */   boolean is2chEq() {
/*  180 */     return false;
/*      */   }
/*      */   
/*      */   boolean isMachiBBS() {
/*  184 */     return false;
/*      */   }
/*      */   
/*      */   boolean isJBBSShitarabaBBS() {
/*  188 */     return false;
/*      */   }
/*      */   
/*      */   boolean isTwitter() {
/*  192 */     return false;
/*      */   }
/*      */   
/*      */   static V2C2chBBS get2chBBS() {
/*  196 */     return v2chBBS;
/*      */   }
/*      */   
/*      */   static V2CJBBSShitarabaBBS getJBBSShitarabaBBS() {
/*  200 */     return vJBBSShitarabaBBS;
/*      */   }
/*      */   
/*      */   static V2C2chEqBBS get2chEqBBS() {
/*  204 */     return v2chEqBBS;
/*      */   }
/*      */   
/*      */   static V2CMachiBBS getMachiBBS() {
/*  208 */     return vMachiBBS;
/*      */   }
/*      */   
/*      */   static V2CUserDefinedBBS getUserDefinedBBS() {
/*  212 */     return vUserDefinedBBS;
/*      */   }
/*      */   
/*      */   static V2CTwitterBBS getTwitterBBS() {
/*  216 */     return vTwitterBBS;
/*      */   }
/*      */   
/*      */   static void restoreBBS() {
/*  220 */     v2chBBS = V2C2chBBS.createInstance("2ch", "2ch");
/*  221 */     vJBBSShitarabaBBS = new V2CJBBSShitarabaBBS("JBBSShitaraba", "したらばJBBS");
/*  222 */     v2chEqBBS = new V2C2chEqBBS("2chEq", "外部板");
/*  223 */     vMachiBBS = new V2CMachiBBS("Machi", "まちBBS");
/*  224 */     vUserDefinedBBS = new V2CUserDefinedBBS("UserDefined", "ユーザ定義");
/*  225 */     vTwitterBBS = new V2CTwitterBBS("Twitter", "Twitter");
/*  226 */     lBBSs = new V2CBBS[] { v2chBBS, vMachiBBS, vJBBSShitarabaBBS, 
/*  227 */       v2chEqBBS, vUserDefinedBBS, vTwitterBBS };
/*  228 */     for (int i = 0; i < lBBSs.length; i++) {
/*  229 */       V2CBBS v2cbbs = lBBSs[i];
/*  230 */       v2cbbs.createTreeModel();
/*  231 */       v2cbbs.createBoardTree();
/*      */     }
/*      */     
/*      */ 
/*  235 */     ((V2CUserDefinedTreeModel)vUserDefinedBBS.vTreeModel).restoreHiddenBoard();
/*  236 */ //    V2CMain.addBoardTreeSeparator(true);
/*      */   }
/*      */   
/*      */   static V2CUserDefinedBoardTree getUserDefinedBoardTree() {
/*  240 */     return (V2CUserDefinedBoardTree)vUserDefinedBBS.vBoardTree;
/*      */   }
/*      */   
/*      */   static void addHiddenBoard(V2CBoardItem v2cboarditem)
/*      */   {
/*  245 */     ((V2CUserDefinedTreeModel)vUserDefinedBBS.vTreeModel).addHiddenBoard(v2cboarditem);
/*      */   }
/*      */   
/*      */   static void removeUnknownBoard(V2CBoardItem v2cboarditem)
/*      */   {
/*  250 */     ((V2CUserDefinedBoardTree)vUserDefinedBBS.vBoardTree).removeUnknownBoard(v2cboarditem);
/*      */   }
/*      */   
/*      */   static boolean isHiddenBoard(V2CBoardItem v2cboarditem) {
/*  254 */     return 
/*  255 */       ((V2CUserDefinedTreeModel)vUserDefinedBBS.vTreeModel).isHiddenBoard(v2cboarditem);
/*      */   }
/*      */   
/*      */   static boolean shouldCheckName(V2CBoardItem v2cboarditem) {
/*  259 */     if (isHiddenBoard(v2cboarditem)) {
/*  260 */       return true;
/*      */     }
/*  262 */     String s = v2cboarditem.getName();
/*  263 */     return (s == null) || (s.length() == 0);
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */ 
/*      */   static void saveTreeStates()
/*      */   {
/*  271 */     Iterator iterator = getBBSiterator();
/*      */     
/*  273 */     while (iterator.hasNext())
/*      */     {
/*      */ 
/*  276 */       V2CBBS v2cbbs = (V2CBBS)iterator.next();
/*  277 */       V2CBoardTree v2cboardtree = v2cbbs.vBoardTree;
/*  278 */       if (v2cboardtree != null) {
/*  279 */         v2cboardtree.saveTreeStates();
/*      */       }
/*      */     }
/*      */   }
/*      */   
/*      */   static V2CTreeModel[] getBBSTreeModels() {
/*  285 */     ArrayList arraylist = new ArrayList();
/*  286 */     for (int i = 0; i < lBBSs.length; i++) {
/*  287 */       V2CTreeModel v2ctreemodel = lBBSs[i].vTreeModel;
/*  288 */       if (v2ctreemodel != null) {
/*  289 */         arraylist.add(v2ctreemodel);
/*      */       }
/*      */     }
/*      */     
/*  293 */     return 
/*  294 */       (V2CTreeModel[])arraylist.toArray(new V2CTreeModel[arraylist.size()]);
/*      */   }
/*      */   
/*      */   static V2CBoardItem getAnyBoardIfPossible(String s) {
/*  298 */     return getAnyBoardIfPossible(s, false);
/*      */   }
/*      */   
/*      */   static V2CBoardItem getAnyBoardIfPossible(String s, boolean flag) {
/*  302 */     V2CBoardItem v2cboarditem = V2CBoardItem.getBoardItem(s);
/*  303 */     if (v2cboarditem != null) {
/*  304 */       return v2cboarditem;
/*      */     }
/*  306 */     v2cboarditem = v2chBBS.getBoardIfPossible(s);
/*  307 */     if (v2cboarditem != null) {
/*  308 */       return v2cboarditem;
/*      */     }
/*  310 */     v2cboarditem = vJBBSShitarabaBBS.getBoardIfPossible(s);
/*  311 */     if (v2cboarditem != null) {
/*  312 */       return v2cboarditem;
/*      */     }
/*  314 */     v2cboarditem = v2chEqBBS.getBoardIfPossible(s, flag);
/*  315 */     if (v2cboarditem != null) {
/*  316 */       return v2cboarditem;
/*      */     }
/*  318 */     return null;
/*      */   }
/*      */   
/*      */   static V2CBoardItem[] getAllBoards()
/*      */   {
/*  323 */     HashSet hashset = new HashSet(1500);
/*  324 */     ArrayList arraylist = new ArrayList(1500);
/*  325 */     for (int i = 0; i < lBBSs.length; i++) {
/*  326 */       V2CBoardItem[] av2cboarditem1 = lBBSs[i].createBoardList();
/*  327 */       if (av2cboarditem1 != null)
/*      */       {
/*      */ 
/*  330 */         for (int l = 0; l < av2cboarditem1.length; l++) {
/*  331 */           V2CBoardItem v2cboarditem1 = av2cboarditem1[l];
/*  332 */           if (!hashset.contains(v2cboarditem1)) {
/*  333 */             arraylist.add(v2cboarditem1);
/*  334 */             hashset.add(v2cboarditem1);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     
/*  340 */     V2CBoardItem[] av2cboarditem = ((V2CUserDefinedTreeModel)vUserDefinedBBS.vTreeModel)
/*  341 */       .getHiddenBoards();
/*  342 */     if (av2cboarditem != null) {
/*  343 */       for (int j = 0; j < av2cboarditem.length; j++) {
/*  344 */         V2CBoardItem v2cboarditem = av2cboarditem[j];
/*  345 */         if (!hashset.contains(v2cboarditem)) {
/*  346 */           arraylist.add(v2cboarditem);
/*  347 */           hashset.add(v2cboarditem);
/*      */         }
/*      */       }
/*      */     }
/*      */     
/*  352 */     int k = arraylist.size();
/*  353 */     return k <= 0 ? null : 
/*  354 */       (V2CBoardItem[])arraylist.toArray(new V2CBoardItem[k]);
/*      */   }
/*      */   
/*      */   static void logSearch() {
/*  358 */     V2CBoardItem[] av2cboarditem = getAllBoards();
/*  359 */     if ((av2cboarditem != null) && (av2cboarditem.length > 0)) {
/*  360 */       V2CLogSearchPanel.showPanel(av2cboarditem, "全体", true);
/*      */     }
/*      */   }
/*      */   
/*      */   public V2CBBS(String s, String s1) {
/*  365 */     this.bCreateTab = true;
/*  366 */     this.cBBSColor = COLOR_UNKNOWN;
/*  367 */     this.sID = s;
/*  368 */     this.sName = s1;
/*  369 */     hmBBSs.put(s, this);
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */   void createBoardTree()
/*      */   {
/*  376 */     if (!this.bCreateTab) {
/*  377 */       return;
/*      */     }
/*  379 */     this.vBoardTree = new V2CBoardTree(this);
/*  380 */     V2CMain.registerBBS(this.vBoardTree);
/*      */   }
/*      */   
/*      */ 
/*      */   void setBBSMenuURL()
/*      */   {
/*  386 */     if (!this.bCanChangeBBSMenuURL) {
/*  387 */       V2CSwingUtil.showErrorMessage(this.sName + " では板一覧取得URLを変更することはできません。");
/*  388 */       return;
/*      */     }
/*      */     
/*  391 */     ChangeBBSMenuURLDialog dialog = new ChangeBBSMenuURLDialog();
/*  392 */     dialog.setVisible(true);
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */ 
/*      */   private class ChangeBBSMenuURLDialog
/*      */     extends JDialog
/*      */   {
/*  442 */     private JTextField urlTextField = new JTextField(40);
/*  443 */     boolean is2ch = !V2CBBS.this.is2chEq();
/*  444 */     private String initUrl = null;
/*  445 */     private boolean initCustomBBSReplace5ch = V2CPlusProperty.isReplaceCustomBBS5ch();
/*      */     
/*      */     public ChangeBBSMenuURLDialog()
/*      */     {
/*  449 */       init();
/*      */     }
/*      */     
/*      */     private void init() {
/*  453 */       setTitle("板一覧取得URLの設定");
/*  454 */       setDefaultCloseOperation(2);
/*  455 */       setIconImage(V2CMain.getV2CIcon(false).getImage());
/*  456 */       setModal(true);
/*  457 */       setResizable(false);
/*      */       
/*  459 */       JLabel captionLabel = new JLabel("<HTML>板一覧取得URL</HTML>");
/*  460 */       JLabel infoLabel = new JLabel(
/*  461 */         this.is2ch ? "<HTML>注意：現在この設定をデフォルトから変更することは<BR>　　　あまりお勧めできません。</HTML>" : 
/*  462 */         "<HTML>カンマ（,）区切りで複数のURLを指定することができます。</HTML>");
/*      */       
/*  464 */       JButton okButton = new JButton("OK");
/*  465 */       JButton resetButton = new JButton("リセット");
/*  466 */       JButton customBBSButton = new JButton("カスタムBBS");
/*  467 */       JButton cancelButton = new JButton("キャンセル");
/*      */       
/*  469 */       GridBagLayout gridBaglayout = new GridBagLayout();
/*  470 */       GridBagConstraints gbc = new GridBagConstraints();
/*  471 */       gbc.gridwidth = 1;
/*  472 */       gbc.gridheight = 1;
/*  473 */       gbc.gridx = 0;
/*  474 */       gbc.gridy = 0;
/*      */       
/*  476 */       setLayout(gridBaglayout);
/*      */       
/*  478 */       gbc.anchor = 17;
/*  479 */       gridBaglayout.setConstraints(captionLabel, gbc);
/*  480 */       add(captionLabel);
/*      */       
/*  482 */       gbc.gridy += 1;
/*  483 */       gbc.anchor = 10;
/*  484 */       gridBaglayout.setConstraints(this.urlTextField, gbc);
/*  485 */       add(this.urlTextField);
/*      */       
/*  487 */       if (!this.is2ch) {
/*  488 */         gbc.gridy += 1;
/*      */         
/*  490 */         gbc.anchor = 17;
/*  491 */         gridBaglayout.setConstraints(infoLabel, gbc);
/*  492 */         add(infoLabel);
/*      */       }
/*  494 */       gbc.gridy += 1;
/*      */       
/*  496 */       JPanel buttonPanel = new JPanel(new FlowLayout());
/*      */       
/*  498 */       buttonPanel.add(okButton);
/*  499 */       buttonPanel.add(resetButton);
/*  500 */       buttonPanel.add(customBBSButton);
/*  501 */       buttonPanel.add(cancelButton);
/*      */       
/*  503 */       gbc.anchor = 10;
/*  504 */       gridBaglayout.setConstraints(buttonPanel, gbc);
/*  505 */       add(buttonPanel);
/*      */       
/*  507 */       this.initUrl = V2CMiscUtil.join(V2CBBS.this.getBBSMenuURLStrings(), ",");
/*  508 */       this.urlTextField.setText(this.initUrl);
/*      */       
/*  510 */       cancelButton.addActionListener(new ActionListener()
/*      */       {
/*      */         public void actionPerformed(ActionEvent action) {
/*  513 */           V2CBBS.ChangeBBSMenuURLDialog.this.dispose();
/*      */         }
/*      */         
/*  516 */       });
/*  517 */       okButton.addActionListener(new ActionListener()
/*      */       {
/*      */         public void actionPerformed(ActionEvent action) {
/*  520 */           V2CBBS.ChangeBBSMenuURLDialog.this.okAction();
/*      */         }
/*      */         
/*  523 */       });
/*  524 */       resetButton.addActionListener(new ActionListener()
/*      */       {
/*      */         public void actionPerformed(ActionEvent action) {
/*  527 */           V2CBBS.ChangeBBSMenuURLDialog.this.resetAction();
/*      */         }
/*      */         
/*  530 */       });
/*  531 */       customBBSButton.addActionListener(new ActionListener()
/*      */       {
/*      */         public void actionPerformed(ActionEvent action) {
/*  534 */           V2CBBS.ChangeBBSMenuURLDialog.this.customBBSAction();
/*      */         }
/*      */         
/*  537 */       });
/*  538 */       pack();
/*  539 */       V2CAppendUtil.displayCenter(this);
/*      */     }
/*      */     
/*      */     private void okAction() {
/*  543 */       V2CProperty v2cproperty = V2CBBS.this.getProperty();
/*  544 */       String propertyKey = V2CBBS.this.getID() + ".BBSMenuURL:";
/*      */       
/*  546 */       String s1 = V2CMiscUtil.trim(this.urlTextField.getText());
/*      */       
/*  548 */       if (s1.length() == 0) {
/*  549 */         v2cproperty.remove(propertyKey);
/*  550 */         return;
/*      */       }
/*  552 */       String[] as = s1.split("[ 　]*[,、][ 　]*");
/*  553 */       if ((this.is2ch) && (as.length > 1)) {
/*  554 */         V2CSwingUtil.showErrorMessage("「外部板」タブ以外で複数のURLを指定することはできません。");
/*  555 */         return;
/*      */       }
/*  557 */       for (int j = as.length - 1; j >= 0; j--) {
/*      */         try
/*      */         {
/*  560 */           URL url = new URL(as[j]);
/*      */         } catch (MalformedURLException malformedurlexception) { URL url;
/*  562 */           V2CSwingUtil.showErrorMessage("不正なURLです: " + as[j]);
/*  563 */           return;
/*      */         }
/*      */       }
/*      */       
/*  567 */       String url = V2CMiscUtil.join(as, " ");
/*  568 */       v2cproperty.put(propertyKey, url);
/*      */       
/*  570 */       dispose();
/*      */       
/*  572 */       boolean urlChanged = (this.initUrl != null) && (!this.initUrl.equals(url));
/*  573 */       boolean replaceCustomBBS5chChanged = (url != null) && (url.contains("kita.jikkyo.org/cbm")) && (this.initCustomBBSReplace5ch != V2CPlusProperty.isReplaceCustomBBS5ch());
/*      */       
/*  575 */       if ((V2CBBS.this.vBoardTree != null) && ((urlChanged) || (replaceCustomBBS5chChanged))) {
/*  576 */         String message = (urlChanged ? "板一覧取得URLを変更しました。" : "") + "今すぐ板一覧を更新しますか？";
/*      */         
/*  578 */         boolean isChange5ch = (this.initUrl.contains("menu.2ch.net/bbsmenu.html")) && (url.contains("menu.5ch.net/bbsmenu.html"));
/*  579 */         if (isChange5ch) {
/*  580 */           message = message + "\n\n※2ch.netから5ch.netへの初回切替時は更新に時間がかかる可能性があります。";
/*      */         }
/*      */         
/*  583 */         int option = JOptionPane.showConfirmDialog(this, 
/*  584 */           message, "確認", 
/*  585 */           0, 1);
/*      */         
/*  587 */         if (option == 0) {
/*  588 */           V2CBBS.this.vBoardTree.updateTreeModel(false);
/*      */           
/*  590 */           if (isChange5ch) {
/*  591 */             V2CPlusHttpUtil.loadPlusSetting();
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     
/*      */     private void resetAction() {
/*  598 */       this.urlTextField.setText("http://menu.5ch.net/bbsmenu.html");
/*      */     }
/*      */     
/*      */     private void customBBSAction() {
/*  602 */       setModal(false);
/*  603 */       V2CBBS.SelectCustomBBSDialog dialog = new V2CBBS.SelectCustomBBSDialog(
/*  604 */         this.urlTextField);
/*  605 */       dialog.setVisible(true);
/*  606 */       setModal(true);
/*      */     }
/*      */   }
/*      */   
/*      */   private class SelectCustomBBSDialog extends JDialog {
/*  611 */     private JTextField urlTextField = null;
/*  612 */     private JCheckBox check2chAuto = new JCheckBox("2ch(kaz-ic.net)");
/*  613 */     private JCheckBox check2ch = new JCheckBox("2ch(非推奨)");
/*  614 */     private JCheckBox checkPinkAuto = new JCheckBox("BBSPINK(kaz-ic.net)");
/*  615 */     private JCheckBox checkPink = new JCheckBox("BBSPINK(非推奨)");
/*  616 */     private JCheckBox checkOpen = new JCheckBox("Open2ch");
/*  617 */     private JCheckBox checkSC = new JCheckBox("2chsc");
/*  618 */     private JCheckBox checkJikkyoorg = new JCheckBox("jikkyo.orgBBS");
/*  619 */     private JCheckBox checkShitaraba = new JCheckBox("したらば掲示板(抜粋)");
/*  620 */     private JCheckBox checkNicoNico = new JCheckBox("ニコニコ動画");
/*  621 */     private JCheckBox checkNext2ch = new JCheckBox("Next2ch");
/*  622 */     private JCheckBox checkSuper2ch = new JCheckBox("super2ch");
/*  623 */     private JCheckBox checkMattari = new JCheckBox("まったり速報＋VIP");
/*  624 */     private JCheckBox checkSougou = new JCheckBox("総合避難所");
/*  625 */     private JCheckBox checkMMOBBS = new JCheckBox("MMOBBS");
/*  626 */     private JCheckBox checkHappa = new JCheckBox("葉っぱ天国");
/*      */     
/*  628 */     private JCheckBox checkReplace5chUrl = new JCheckBox("2ch.netのURLを5ch.netに置換して更新する");
/*  629 */     private boolean initReplace5chUrl = V2CPlusProperty.isReplaceCustomBBS5ch();
/*      */     
/*      */     public SelectCustomBBSDialog(JTextField urlTextField)
/*      */     {
/*  633 */       this.urlTextField = urlTextField;
/*  634 */       init();
/*      */     }
/*      */     
/*      */     private void init() {
/*  638 */       setTitle("CBM カスタムBBSMENU");
/*  639 */       setDefaultCloseOperation(2);
/*  640 */       setIconImage(V2CMain.getV2CIcon(false).getImage());
/*  641 */       setModal(true);
/*      */       
/*  643 */       this.check2chAuto.setToolTipText("2ch netの「地震」から「雑談系２」までの板一覧です。");
/*  644 */       this.check2ch.setToolTipText("2ch netの「地震」から「雑談系２」までの板一覧です。");
/*  645 */       this.checkPinkAuto.setToolTipText("おなじみBBSPINK。18歳未満はだめ。");
/*  646 */       this.checkPink.setToolTipText("おなじみBBSPINK。18歳未満はだめ。");
/*  647 */       this.checkOpen.setToolTipText("Open2ch掲示板群。");
/*  648 */       this.checkSC.setToolTipText("2ch scの「地震」から「雑談系２」までの板一覧です。");
/*      */       
/*  650 */       this.checkJikkyoorg.setToolTipText("実況避難所や雑談板など。サロンfreeにCBM運営スレあり。");
/*      */       
/*  652 */       this.checkShitaraba
/*  653 */         .setToolTipText("レンタル掲示板したらばのある時点のランキング上位を少しずついじって人気板をまとめました。");
/*  654 */       this.checkNicoNico.setToolTipText("ニコニコ動画掲示板です。");
/*  655 */       this.checkNext2ch.setToolTipText("Next2ch掲示板群。運用中の板のみ(β)");
/*  656 */       this.checkSuper2ch
/*  657 */         .setToolTipText("super2ch掲示板群。自由に板を新設できますが、このカテゴリ内容は手動で更新しています。");
/*  658 */       this.checkMattari.setToolTipText("３つのサーバーに分かれた速報・VIP系掲示板群。");
/*      */       
/*  660 */       this.checkSougou.setToolTipText("いわゆる売りスレ売上関係を扱うアニメ関係の総合避難所掲示板群。");
/*  661 */       this.checkMMOBBS.setToolTipText("MMOBBS掲示板群。");
/*  662 */       this.checkHappa.setToolTipText("葉っぱ天国掲示板群。");
/*      */       
/*  664 */       boolean is2ch = V2CBBS.this.is2ch();
/*  665 */       boolean b = false;
/*  666 */       String preUrl = this.urlTextField.getText();
/*      */       
/*  668 */       this.checkReplace5chUrl.setSelected(this.initReplace5chUrl);
/*      */       
/*  670 */       if (!V2CAppendUtil.isEmpty(preUrl))
/*      */       {
/*  672 */         String matchPatternStr = "http://kita.jikkyo.org/cbm/cbm.cgi/(.+)/-all/bbsmenu.html";
/*  673 */         Pattern p = Pattern.compile(matchPatternStr);
/*  674 */         Matcher m = p.matcher(preUrl);
/*      */         
/*  676 */         if (m.find()) {
/*  677 */           String s = m.group(1);
/*      */           
/*  679 */           if ((is2ch) && (s.contains("2r"))) {
/*  680 */             this.check2chAuto.setSelected(true);
/*      */           }
/*  682 */           if ((is2ch) && (s.contains("20"))) {
/*  683 */             this.check2ch.setSelected(true);
/*      */           }
/*  685 */           if ((is2ch) && (s.contains("pr"))) {
/*  686 */             this.checkPinkAuto.setSelected(true);
/*      */           }
/*  688 */           if ((is2ch) && (s.contains("p0"))) {
/*  689 */             this.checkPink.setSelected(true);
/*      */           }
/*  691 */           if (s.contains("op")) {
/*  692 */             this.checkOpen.setSelected(true);
/*      */           }
/*  694 */           if (s.contains("sc")) {
/*  695 */             this.checkSC.setSelected(true);
/*      */           }
/*  697 */           if (s.contains("jb")) {
/*  698 */             this.checkJikkyoorg.setSelected(true);
/*      */           }
/*      */           
/*  701 */           if (s.contains("st")) {
/*  702 */             this.checkShitaraba.setSelected(true);
/*      */           }
/*  704 */           if (s.contains("nv")) {
/*  705 */             this.checkNicoNico.setSelected(true);
/*      */           }
/*  707 */           if (s.contains("nb")) {
/*  708 */             this.checkNext2ch.setSelected(true);
/*      */           }
/*  710 */           if (s.contains("s2")) {
/*  711 */             this.checkSuper2ch.setSelected(true);
/*      */           }
/*  713 */           if (s.contains("mv")) {
/*  714 */             this.checkMattari.setSelected(true);
/*      */           }
/*      */           
/*  717 */           if (s.contains("rc")) {
/*  718 */             this.checkSougou.setSelected(true);
/*      */           }
/*  720 */           if (s.contains("mo")) {
/*  721 */             this.checkMMOBBS.setSelected(true);
/*      */           }
/*  723 */           if (s.contains("ha")) {
/*  724 */             this.checkHappa.setSelected(true);
/*      */           }
/*      */           
/*  727 */           b = true;
/*      */         }
/*      */       }
/*      */       
/*  731 */       this.check2chAuto.setEnabled(is2ch);
/*  732 */       this.checkPinkAuto.setEnabled(is2ch);
/*  733 */       this.check2ch.setEnabled(is2ch);
/*  734 */       this.checkPink.setEnabled(is2ch);
/*      */       
/*  736 */       if (!b) {
/*  737 */         this.check2chAuto.setSelected(is2ch);
/*  738 */         this.checkPinkAuto.setSelected(is2ch);
/*      */       }
/*      */       
/*  741 */       setResizable(false);
/*      */       
/*  743 */       JButton okButton = new JButton("OK");
/*  744 */       JButton cancelButton = new JButton("キャンセル");
/*      */       
/*  746 */       V2CURILabel urlLabel = new V2CURILabel("カスタムBBSMENUについて", 
/*  747 */         "http://kita.jikkyo.org/cbm/");
/*      */       
/*  749 */       add(urlLabel, "North");
/*      */       
/*      */ 
/*  752 */       JPanel centerPanel = new JPanel();
/*      */       
/*  754 */       GridBagLayout gridBaglayout = new GridBagLayout();
/*  755 */       centerPanel.setLayout(gridBaglayout);
/*  756 */       add(centerPanel, "Center");
/*  757 */       GridBagConstraints gbc = new GridBagConstraints();
/*  758 */       gbc.gridwidth = 1;
/*  759 */       gbc.gridheight = 1;
/*  760 */       gbc.gridx = 0;
/*  761 */       gbc.gridy = 0;
/*  762 */       gbc.anchor = 17;
/*  763 */       gbc.insets = new Insets(5, 5, 5, 5);
/*      */       
/*      */ 
/*      */ 
/*  767 */       gbc.gridy += 1;
/*      */       
/*  769 */       gbc.gridx = 0;
/*  770 */       gridBaglayout.setConstraints(this.check2chAuto, gbc);
/*  771 */       centerPanel.add(this.check2chAuto);
/*      */       
/*  773 */       gbc.gridx += 1;
/*  774 */       gridBaglayout.setConstraints(this.check2ch, gbc);
/*  775 */       centerPanel.add(this.check2ch);
/*      */       
/*  777 */       gbc.gridx += 1;
/*  778 */       gridBaglayout.setConstraints(this.checkPinkAuto, gbc);
/*  779 */       centerPanel.add(this.checkPinkAuto);
/*      */       
/*  781 */       gbc.gridx += 1;
/*  782 */       gridBaglayout.setConstraints(this.checkPink, gbc);
/*  783 */       centerPanel.add(this.checkPink);
/*      */       
/*  785 */       gbc.gridx += 1;
/*  786 */       gridBaglayout.setConstraints(this.checkOpen, gbc);
/*  787 */       centerPanel.add(this.checkOpen);
/*      */       
/*  789 */       gbc.gridy += 1;
/*      */       
/*  791 */       gbc.gridx = 0;
/*  792 */       gridBaglayout.setConstraints(this.checkSC, gbc);
/*  793 */       centerPanel.add(this.checkSC);
/*      */       
/*  795 */       gbc.gridx += 1;
/*  796 */       gridBaglayout.setConstraints(this.checkJikkyoorg, gbc);
/*  797 */       centerPanel.add(this.checkJikkyoorg);
/*      */       
/*  799 */       gbc.gridx += 1;
/*  800 */       gridBaglayout.setConstraints(this.checkShitaraba, gbc);
/*  801 */       centerPanel.add(this.checkShitaraba);
/*      */       
/*  803 */       gbc.gridx += 1;
/*  804 */       gridBaglayout.setConstraints(this.checkNicoNico, gbc);
/*  805 */       centerPanel.add(this.checkNicoNico);
/*      */       
/*  807 */       gbc.gridx += 1;
/*  808 */       gridBaglayout.setConstraints(this.checkNext2ch, gbc);
/*  809 */       centerPanel.add(this.checkNext2ch);
/*      */       
/*  811 */       gbc.gridy += 1;
/*      */       
/*  813 */       gbc.gridx = 0;
/*  814 */       gridBaglayout.setConstraints(this.checkSuper2ch, gbc);
/*  815 */       centerPanel.add(this.checkSuper2ch);
/*      */       
/*  817 */       gbc.gridx += 1;
/*  818 */       gridBaglayout.setConstraints(this.checkMattari, gbc);
/*  819 */       centerPanel.add(this.checkMattari);
/*      */       
/*  821 */       gbc.gridx += 1;
/*  822 */       gridBaglayout.setConstraints(this.checkSougou, gbc);
/*  823 */       centerPanel.add(this.checkSougou);
/*      */       
/*  825 */       gbc.gridx += 1;
/*  826 */       gridBaglayout.setConstraints(this.checkMMOBBS, gbc);
/*  827 */       centerPanel.add(this.checkMMOBBS);
/*      */       
/*  829 */       gbc.gridx += 1;
/*  830 */       gridBaglayout.setConstraints(this.checkHappa, gbc);
/*  831 */       centerPanel.add(this.checkHappa);
/*      */       
/*      */ 
/*  834 */       if (is2ch) {
/*  835 */         this.checkReplace5chUrl.setForeground(Color.BLUE);
/*  836 */         gbc.gridy += 1;
/*  837 */         gbc.gridx = 0;
/*  838 */         gridBaglayout.setConstraints(this.checkReplace5chUrl, gbc);
/*  839 */         centerPanel.add(this.checkReplace5chUrl);
/*      */       }
/*      */       
/*  842 */       JPanel buttonPanel = new JPanel(new FlowLayout());
/*  843 */       buttonPanel.add(okButton);
/*  844 */       buttonPanel.add(cancelButton);
/*      */       
/*  846 */       add(buttonPanel, "South");
/*      */       
/*  848 */       cancelButton.addActionListener(new ActionListener()
/*      */       {
/*      */         public void actionPerformed(ActionEvent action) {
/*  851 */           V2CBBS.SelectCustomBBSDialog.this.dispose();
/*      */         }
/*      */         
/*  854 */       });
/*  855 */       okButton.addActionListener(new ActionListener()
/*      */       {
/*      */         public void actionPerformed(ActionEvent action) {
/*  858 */           V2CBBS.SelectCustomBBSDialog.this.okAction();
/*      */         }
/*      */         
/*  861 */       });
/*  862 */       this.check2chAuto.addActionListener(new ActionListener()
/*      */       {
/*      */         public void actionPerformed(ActionEvent arg0) {
/*  865 */           if (V2CBBS.SelectCustomBBSDialog.this.check2chAuto.isSelected()) {
/*  866 */             V2CBBS.SelectCustomBBSDialog.this.check2ch.setSelected(false);
/*      */           }
/*      */           
/*      */         }
/*  870 */       });
/*  871 */       this.check2ch.addActionListener(new ActionListener()
/*      */       {
/*      */         public void actionPerformed(ActionEvent arg0) {
/*  874 */           if (V2CBBS.SelectCustomBBSDialog.this.check2ch.isSelected()) {
/*  875 */             V2CBBS.SelectCustomBBSDialog.this.check2chAuto.setSelected(false);
/*      */           }
/*      */           
/*      */         }
/*  879 */       });
/*  880 */       this.checkPinkAuto.addActionListener(new ActionListener()
/*      */       {
/*      */         public void actionPerformed(ActionEvent arg0) {
/*  883 */           if (V2CBBS.SelectCustomBBSDialog.this.checkPinkAuto.isSelected()) {
/*  884 */             V2CBBS.SelectCustomBBSDialog.this.checkPink.setSelected(false);
/*      */           }
/*      */           
/*      */         }
/*  888 */       });
/*  889 */       this.checkPink.addActionListener(new ActionListener()
/*      */       {
/*      */         public void actionPerformed(ActionEvent arg0) {
/*  892 */           if (V2CBBS.SelectCustomBBSDialog.this.checkPink.isSelected()) {
/*  893 */             V2CBBS.SelectCustomBBSDialog.this.checkPinkAuto.setSelected(false);
/*      */           }
/*      */           
/*      */         }
/*  897 */       });
/*  898 */       pack();
/*  899 */       V2CAppendUtil.displayCenter(this);
/*      */     }
/*      */     
/*      */     private void okAction()
/*      */     {
/*  904 */       StringBuilder sb = new StringBuilder();
/*      */       
/*  906 */       if (this.check2chAuto.isSelected()) {
/*  907 */         sb.append("2r.");
/*      */       }
/*  909 */       if (this.check2ch.isSelected()) {
/*  910 */         sb.append("20.");
/*      */       }
/*  912 */       if (this.checkPinkAuto.isSelected()) {
/*  913 */         sb.append("pr.");
/*      */       }
/*  915 */       if (this.checkPink.isSelected()) {
/*  916 */         sb.append("p0.");
/*      */       }
/*  918 */       if (this.checkOpen.isSelected()) {
/*  919 */         sb.append("op.");
/*      */       }
/*  921 */       if (this.checkSC.isSelected()) {
/*  922 */         sb.append("sc.");
/*      */       }
/*  924 */       if (this.checkJikkyoorg.isSelected()) {
/*  925 */         sb.append("jb.");
/*      */       }
/*      */       
/*  928 */       if (this.checkShitaraba.isSelected()) {
/*  929 */         sb.append("st.");
/*      */       }
/*  931 */       if (this.checkNicoNico.isSelected()) {
/*  932 */         sb.append("nv.");
/*      */       }
/*  934 */       if (this.checkNext2ch.isSelected()) {
/*  935 */         sb.append("nb.");
/*      */       }
/*  937 */       if (this.checkSuper2ch.isSelected()) {
/*  938 */         sb.append("s2.");
/*      */       }
/*  940 */       if (this.checkMattari.isSelected()) {
/*  941 */         sb.append("mv.");
/*      */       }
/*      */       
/*  944 */       if (this.checkSougou.isSelected()) {
/*  945 */         sb.append("rc.");
/*      */       }
/*  947 */       if (this.checkMMOBBS.isSelected()) {
/*  948 */         sb.append("mo.");
/*      */       }
/*  950 */       if (this.checkHappa.isSelected()) {
/*  951 */         sb.append("ha.");
/*      */       }
/*      */       
/*  954 */       String bbs = sb.toString();
/*      */       
/*  956 */       if (V2CAppendUtil.isEmpty(bbs)) {
/*  957 */         dispose();
/*  958 */         return;
/*      */       }
/*      */       
/*  961 */       if (bbs.endsWith(".")) {
/*  962 */         bbs = bbs.substring(0, bbs.length() - 1);
/*      */       }
/*      */       
/*  965 */       if (this.checkReplace5chUrl.isSelected() != this.initReplace5chUrl) {
/*  966 */         V2CPlusProperty.setReplaceCustomBBS5ch(this.checkReplace5chUrl.isSelected());
/*  967 */         V2CPlusProperty.save();
/*      */       }
/*      */       
/*  970 */       String url = "http://kita.jikkyo.org/cbm/cbm.cgi/" + bbs + 
/*  971 */         "/-all/bbsmenu.html";
/*  972 */       this.urlTextField.setText(url);
/*      */       
/*  974 */       dispose();
/*      */     }
/*      */   }
/*      */   
/*      */ 
/*      */   String getLabel()
/*      */   {
/*  981 */     return getProperty().get("BBS.Label:", this.sName);
/*      */   }
/*      */   
/*      */   void setLabel() {
/*  985 */     if ((this.vBoardTree == null) || (this.vTreeModel == null)) {
/*  986 */       return;
/*      */     }
/*  988 */     String s = getLabel();
/*  989 */     V2CInputDialog v2cinputdialog = new V2CInputDialog(
/*  990 */       getName() + " のタブ名：", null, null, s, 20, "板一覧のタブ名設定");
/*  991 */     String s1 = v2cinputdialog.showDialog();
/*  992 */     if (s1 == null) {
/*  993 */       return;
/*      */     }
/*  995 */     s1 = V2CMiscUtil.replaceChar(s1, '\t', ' ').trim();
/*  996 */     if (s1.equals(s)) {
/*  997 */       return;
/*      */     }
/*  999 */     V2CProperty v2cproperty = getProperty();
/* 1000 */     if ((s1.length() == 0) || (s1.equals(this.sName))) {
/* 1001 */       v2cproperty.remove("BBS.Label:");
/*      */     } else {
/* 1003 */       v2cproperty.put("BBS.Label:", s1);
/*      */     }
/* 1005 */     V2CBoardTreePane v2cboardtreepane = V2CMain.vtpTreePane;
/* 1006 */     v2cboardtreepane.titleChanged(this.vBoardTree);
/* 1007 */     this.vTreeModel.rootLabelChanged();
/*      */   }
/*      */   
/*      */   String getBBSMenuURLString() {
/* 1011 */     String[] as = getBBSMenuURLStrings();
/* 1012 */     return (as == null) || (as.length <= 0) ? this.sDefaultBBSMenuURL : as[0];
/*      */   }
/*      */   
/*      */   String[] getBBSMenuURLStrings() {
/* 1016 */     String s = getProperty().get(getID() + ".BBSMenuURL:");
/* 1017 */     if ((s == null) || (s.length() == 0)) {
/* 1018 */       s = this.sDefaultBBSMenuURL;
/*      */     }
/* 1020 */     return V2CMiscUtil.split(s, ' ', true);
/*      */   }
/*      */   
/*      */   void updateModel(boolean flag) {
/* 1024 */     if (this.vBoardTree != null) {
/* 1025 */       this.vBoardTree.updateTreeModel(flag);
/*      */     }
/*      */   }
/*      */   
/*      */   V2CBoardItem findBoardByDirName(String s) {
/* 1030 */     return this.vBoardTree.findBoardByDirName(s);
/*      */   }
/*      */   
/*      */   boolean containsBoard(String s) {
/* 1034 */     return false;
/*      */   }
/*      */   
/*      */   boolean has(V2CBoardItem v2cboarditem) {
/* 1038 */     return (this.vTreeModel != null) && (this.vTreeModel.has(v2cboarditem));
/*      */   }
/*      */   
/*      */   boolean containedElsewhere(V2CBoardItem v2cboarditem) {
/* 1042 */     for (Iterator iterator = getBBSiterator(); iterator.hasNext();) {
/* 1043 */       V2CBBS v2cbbs = (V2CBBS)iterator.next();
/* 1044 */       if ((v2cbbs != this) && (v2cbbs.has(v2cboarditem))) {
/* 1045 */         return true;
/*      */       }
/*      */     }
/*      */     
/* 1049 */     return false;
/*      */   }
/*      */   
/*      */   String getAddressBarString(V2CThreadItem v2cthreaditem) {
/* 1053 */     return getFormalThreadURLString(v2cthreaditem);
/*      */   }
/*      */   
/*      */   URL getRealThreadURL(V2CThreadItem v2cthreaditem, int i, int j, int k) {
/* 1057 */     return getThreadURL(v2cthreaditem);
/*      */   }
/*      */   
/*      */   URL getThreadURL(V2CThreadItem v2cthreaditem) {
/* 1061 */     URL url = null;
/*      */     try {
/* 1063 */       url = new URL(v2cthreaditem.getBoardURLString() + "dat/" + 
/* 1064 */         v2cthreaditem.getDatName());
/*      */     } catch (MalformedURLException malformedurlexception) {
/* 1066 */       V2CMiscUtil.printMalformedURLException(malformedurlexception);
/*      */     }
/* 1068 */     return url;
/*      */   }
/*      */   
/*      */   String getFormalThreadURLString(V2CThreadItem v2cthreaditem) {
/* 1072 */     return v2cthreaditem.getURLString();
/*      */   }
/*      */   
/*      */   String getMobileThreadURLString(V2CThreadItem v2cthreaditem, boolean flag) {
/* 1076 */     return getFormalThreadURLString(v2cthreaditem);
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */ 
/*      */   V2CTreeModel getTreeModel()
/*      */   {
/* 1084 */     return this.vTreeModel;
/*      */   }
/*      */   
/*      */   V2CBoardCategoryItem getBoardCategoryItem(String s) {
/* 1088 */     return this.vTreeModel.getBoardCategoryItem(s);
/*      */   }
/*      */   
/*      */   JPopupMenu createBoardMenu(V2CBoardCategoryItem v2cboardcategoryitem, boolean flag)
/*      */   {
/* 1093 */     ArrayList arraylist = this.vTreeModel.getBoardList(v2cboardcategoryitem);
/* 1094 */     if ((arraylist == null) || (arraylist.size() == 0)) {
/* 1095 */       return null;
/*      */     }
/* 1097 */     Icon icon = V2CBoardItem.getIcon();
/* 1098 */     JPopupMenu jpopupmenu = new JPopupMenu();
/* 1099 */     for (int i = 0; i < arraylist.size(); i++) {
/* 1100 */       V2CBoardItem v2cboarditem = (V2CBoardItem)arraylist.get(i);
/* 1101 */       OpenBoardAction openboardaction = new OpenBoardAction(v2cboarditem, 
/* 1102 */         flag);
/* 1103 */       JMenuItem jmenuitem = new JMenuItem(openboardaction);
/* 1104 */       jmenuitem.setText(v2cboarditem.getName());
/* 1105 */       jmenuitem.setIcon(icon);
/* 1106 */       jpopupmenu.add(jmenuitem);
/*      */     }
/*      */     
/* 1109 */     return jpopupmenu;
/*      */   }
/*      */   
/*      */   V2CBoardItem[] createBoardList() {
/* 1113 */     return this.vTreeModel == null ? null : this.vTreeModel.createBoardList();
/*      */   }
/*      */   
/*      */   V2CBoardItem[] createBoardList(V2CBoardCategoryItem v2cboardcategoryitem) {
/* 1117 */     return this.vTreeModel == null ? null : this.vTreeModel
/* 1118 */       .createBoardList(v2cboardcategoryitem);
/*      */   }
/*      */   
/*      */   boolean saveBBSTree() {
/* 1122 */     return this.vTreeModel.saveBBSTree();
/*      */   }
/*      */   
/*      */   boolean getSetting() {
/* 1126 */     return this.bSetting;
/*      */   }
/*      */   
/*      */   boolean getHeadTxt() {
/* 1130 */     return this.bHead;
/*      */   }
/*      */   
/*      */   final Pattern getSubjectPattern(V2CBoardItem v2cboarditem) {
/* 1134 */     return this.pSubject;
/*      */   }
/*      */   
/*      */   boolean titlePictureAvailable(V2CBoardItem v2cboarditem) {
/* 1138 */     if (!this.bSetting) {
/* 1139 */       return true;
/*      */     }
/* 1141 */     String s = v2cboarditem.getSettingProperty().get(
/* 1142 */       "BBS_TITLE_PICTURE");
/* 1143 */     return (s != null) && (s.length() > 0);
/*      */   }
/*      */   
/*      */   String getTitlePictureURLString(V2CBoardItem v2cboarditem)
/*      */   {
/* 1148 */     if (!this.bSetting) {
/* 1149 */       return null;
/*      */     }
/* 1151 */     return v2cboarditem.getSettingProperty().get("BBS_TITLE_PICTURE");
/*      */   }
/*      */   
/*      */   V2CThreadRes createNewThreadRes(V2CThreadPanel v2cthreadpanel)
/*      */   {
/* 1156 */     return new V2CBBSThreadRes(v2cthreadpanel);
/*      */   }
/*      */   
/*      */   V2CThreadRes createNewThreadRes(V2CThreadItem v2cthreaditem) {
/* 1160 */     return new V2CBBSThreadRes(v2cthreaditem);
/*      */   }
/*      */   
/*      */   V2CNameAndMail createNameAndMail(V2CWritePanel v2cwritepanel) {
/* 1164 */     return new V2CNameAndMail(v2cwritepanel);
/*      */   }
/*      */   
/*      */ 
/*      */   V2CResItem createResItemForPreview(V2CThreadRes v2cthreadres, V2CThreadItem v2cthreaditem, String s, String s1, String s2, String s3, V2CResItem v2cresitem, String s4)
/*      */   {
/* 1170 */     return null;
/*      */   }
/*      */   
/*      */   static String checkTrip(String s, V2CBoardItem v2cboarditem) {
/* 1174 */     String s1 = v2cboarditem.getCharsetString();
/* 1175 */     int i = s.indexOf('#');
/* 1176 */     if (i < 0) {
/* 1177 */       return s;
/*      */     }
/* 1179 */     String s2 = V2CTrip.calc(s.substring(i + 1), v2cboarditem);
/* 1180 */     if (s2 == null) {
/* 1181 */       return s;
/*      */     }
/* 1183 */     StringBuilder sb = new StringBuilder();
/* 1184 */     if (i == 0) {
/* 1185 */       sb.append("</b> ");
/*      */     } else {
/* 1187 */       sb.append(s.substring(0, i));
/* 1188 */       sb.append(" </b>");
/*      */     }
/* 1190 */     sb.append('◆');
/* 1191 */     sb.append(s2);
/* 1192 */     sb.append(" <b>");
/* 1193 */     return sb.toString();
/*      */   }
/*      */   
/*      */   boolean createThread(String s, V2CNameAndMail v2cnameandmail, String s1, V2CThreadItem v2cthreaditem)
/*      */   {
/* 1198 */     return false;
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */   URL getCreateThreadURL(V2CThreadItem v2cthreaditem, boolean flag)
/*      */   {
/* 1205 */     URL url = null;
/*      */     try {
/* 1207 */       URL url1 = v2cthreaditem.getBoardItem().getURL();
/* 1208 */       if (url1 != null) {
/* 1209 */         url = new URL("http://" + url1.getHost() + (
/* 1210 */           flag ? this.sSubBBSCGI : this.sBBSCGI));
/*      */       }
/*      */     } catch (MalformedURLException malformedurlexception) {
/* 1213 */       V2CMiscUtil.printMalformedURLException(malformedurlexception);
/*      */     }
/* 1215 */     return url;
/*      */   }
/*      */   
/*      */   URL getPostURL(V2CThreadItem v2cthreaditem) {
/* 1219 */     URL url = null;
/*      */     try {
/* 1221 */       URL url1 = v2cthreaditem.getBoardItem().getURL();
/* 1222 */       if (url1 != null) {
/* 1223 */         url = new URL("http://" + url1.getHost() + this.sBBSCGI);
/*      */       }
/*      */     } catch (MalformedURLException malformedurlexception) {
/* 1226 */       V2CMiscUtil.printMalformedURLException(malformedurlexception);
/*      */     }
/* 1228 */     return url;
/*      */   }
/*      */   
/*      */   String createPostMessage(String s, String s1, String s2, String s3, String s4)
/*      */   {
/* 1233 */     return createMessage(this.sSubmitInputValue, null, s, s1, s2, s3, s4);
/*      */   }
/*      */   
/*      */   String createCreateThreadMessage(String s, String s1, String s2, String s3, String s4, String s5, String s6)
/*      */   {
/* 1238 */     return createMessage(s, s1, s2, s3, s4, s5, s6);
/*      */   }
/*      */   
/*      */   private String createMessage(String s, String s1, String s2, String s3, String s4, String s5, String s6)
/*      */   {
/* 1243 */     StringBuilder sb = new StringBuilder();
/* 1244 */     if (s != null) {
/* 1245 */       sb.append("submit=");
/* 1246 */       sb.append(V2CJPConverter.urlEncode(s, s6));
/* 1247 */       sb.append('&');
/*      */     }
/* 1249 */     if (s1 != null) {
/* 1250 */       sb.append(this.sTitleInputName);
/* 1251 */       sb.append('=');
/* 1252 */       sb.append(V2CJPConverter.urlEncode(s1, s6));
/* 1253 */       sb.append('&');
/*      */     }
/* 1255 */     sb.append(this.sNameInputName);
/* 1256 */     sb.append('=');
/* 1257 */     sb.append(V2CJPConverter.urlEncode(s2, s6));
/* 1258 */     sb.append('&');
/* 1259 */     sb.append(this.sMailInputName);
/* 1260 */     sb.append('=');
/* 1261 */     sb.append(V2CJPConverter.urlEncode(s3, s6));
/* 1262 */     sb.append('&');
/* 1263 */     sb.append(this.sMessageInputName);
/* 1264 */     sb.append('=');
/* 1265 */     sb.append(V2CJPConverter.urlEncode(s4, s6));
/* 1266 */     sb.append(s5);
/* 1267 */     return sb.toString();
/*      */   }
/*      */   
/*      */   String getBBSKeyTime(String s, String s1, long l) {
/* 1271 */     StringBuilder sb = new StringBuilder();
/* 1272 */     if ((this.sBBSInputName != null) && (s != null)) {
/* 1273 */       sb.append('&');
/* 1274 */       sb.append(this.sBBSInputName);
/* 1275 */       sb.append('=');
/* 1276 */       sb.append(s);
/*      */     }
/* 1278 */     if ((this.sKeyInputName != null) && (s1 != null)) {
/* 1279 */       sb.append('&');
/* 1280 */       sb.append(this.sKeyInputName);
/* 1281 */       sb.append('=');
/* 1282 */       sb.append(s1);
/*      */     }
/* 1284 */     if (this.sTimeInputName != null) {
/* 1285 */       sb.append('&');
/* 1286 */       sb.append(this.sTimeInputName);
/* 1287 */       sb.append('=');
/* 1288 */       if (l <= 0L) {
/* 1289 */         l = System.currentTimeMillis();
/*      */       }
/* 1291 */       sb.append(l / 1000L - 100L);
/*      */     }
/* 1293 */     return sb.toString();
/*      */   }
/*      */   
/*      */   static void showWriteWarningMessage(String s) {
/* 1297 */     showWriteResultMessage(s, "書き込み警告", 2);
/*      */   }
/*      */   
/*      */   static void showWriteErrorMessage(String s) {
/* 1301 */     showWriteResultMessage(s, "書き込みエラー", 0);
/*      */   }
/*      */   
/*      */   static void showWriteResultMessage(String s, String s1, int i) {
/* 1305 */     V2CApp.setErrorMessage(s, s1);
/* 1306 */     V2CHTMLPane v2chtmlpane = new V2CHTMLPane(s);
/* 1307 */     v2chtmlpane.listenToHyperlinkEvent(false);
/*      */     Object obj;
/* 1309 */     if (Pattern.compile("<form\\s", 2).matcher(s).find()) {
/* 1310 */       JPanel jpanel = new JPanel(new GridBagLayout());
/* 1311 */       obj = jpanel;
/* 1312 */       GridBagConstraints gridbagconstraints = 
/* 1313 */         V2CSwingUtil.createGridBagConstraints();
/* 1314 */       gridbagconstraints.anchor = 10;
/* 1315 */       gridbagconstraints.fill = 1;
/* 1316 */       gridbagconstraints.weightx = 1.0D;
/* 1317 */       gridbagconstraints.weighty = 1.0D;
/* 1318 */       jpanel.add(v2chtmlpane, gridbagconstraints);
/* 1319 */       gridbagconstraints.gridy += 1;
/* 1320 */       gridbagconstraints.weighty = 0.0D;
/* 1321 */       gridbagconstraints.fill = 0;
/* 1322 */       gridbagconstraints.insets = new Insets(5, 5, 5, 5);
/* 1323 */       JLabel jlabel = new JLabel("☆★☆上のフォームでは絶対に入力・操作しないでください。☆★☆");
/* 1324 */       jlabel.setFont(jlabel.getFont().deriveFont(20.0F));
/* 1325 */       jlabel.setForeground(Color.RED);
/* 1326 */       jpanel.add(jlabel, gridbagconstraints);
/*      */     } else {
/* 1328 */       obj = v2chtmlpane;
/*      */     }
/* 1330 */     JScrollPane jscrollpane = 
/* 1331 */       V2CSwingUtil.createBoundedScrollPane((JComponent)obj, 
/* 1332 */       0.5D, 0.5D);
/* 1333 */     JOptionPane.showMessageDialog(V2CMain.v2cMain, jscrollpane, s1, i);
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */   static void showWriteErrorMessage(String mainMessage, String subMessage)
/*      */   {
/* 1340 */     JPanel panel = getKakikomiErrorPanel(mainMessage, subMessage);
/* 1341 */     JOptionPane.showMessageDialog(V2CMain.v2cMain, panel, "書き込みエラー", 0);
/*      */   }
/*      */   
/*      */   static void showBrowserErrorMessage(String mainMessage, String subMessage) {
/* 1345 */     JPanel panel = getKakikomiErrorPanel(mainMessage, subMessage);
/*      */     
/* 1347 */     String[] as = { "閉じる", "2ch接続設定を開く" };
/* 1348 */     final Object[] ol = V2CSwingUtil.createJButtonForOptionPane(as);
/*      */     try {
/* 1350 */       EventQueue.invokeAndWait(new Runnable() {
/*      */         public void run() {
/* 1352 */           int result = JOptionPane.showOptionDialog(V2CMain.v2cMain, this, 
/* 1353 */             "書き込みエラー", 2, 0, null, ol, ol[0]);
/*      */           
/* 1355 */           if (result == 1) {
/* 1356 */             V2CConnectionConfigDialog dialog = new V2CConnectionConfigDialog();
/* 1357 */             dialog.setVisible(true);
/* 1358 */             return;
/*      */           }
/*      */         }
/*      */       });
/*      */     } catch (Exception e) {
/* 1363 */       e.printStackTrace();
/*      */     }
/*      */   }
/*      */   
/*      */   static void showRentouErrorMessage(String mainMessage, String subMessage, final V2CBoardItem boardItem) {
/* 1368 */     JPanel panel = getKakikomiErrorPanel(mainMessage, subMessage);
/*      */     
/* 1370 */     String[] as = { "閉じる", "クッキーを削除する" };
/* 1371 */     final Object[] ol = V2CSwingUtil.createJButtonForOptionPane(as);
/*      */     try {
/* 1373 */       EventQueue.invokeAndWait(new Runnable() {
/*      */         public void run() {
/* 1375 */           int result = JOptionPane.showOptionDialog(V2CMain.v2cMain, this, 
/* 1376 */             "書き込みエラー", 2, 0, null, ol, ol[0]);
/*      */           
/* 1378 */           if ((result == 1) && (boardItem != null)) {
/* 1379 */             V2CCookie.removeHostCookie(boardItem.getURL().getHost());
/* 1380 */             V2CSwingUtil.showInformationMessage(boardItem.getURL().getHost() + "のクッキーを削除しました");
/* 1381 */             return;
/*      */           }
/*      */         }
/*      */       });
/*      */     } catch (Exception e) {
/* 1386 */       e.printStackTrace();
/*      */     }
/*      */   }
/*      */   
/*      */   static JPanel getKakikomiErrorPanel(String mainMessage, String subMessage) {
/* 1391 */     subMessage = "<html><body><font color=red size=+1><b>" + subMessage + "</b></font></body></html>";
/*      */     
/* 1393 */     V2CApp.setErrorMessage(mainMessage, "書き込みエラー");
/* 1394 */     V2CHTMLPane v2chtmlpane = new V2CHTMLPane(mainMessage);
/* 1395 */     v2chtmlpane.listenToHyperlinkEvent(false);
/*      */     Object obj;
/* 1397 */     if (Pattern.compile("<form\\s", 2).matcher(mainMessage).find()) {
/* 1398 */       JPanel jpanel = new JPanel(new GridBagLayout());
/* 1399 */       obj = jpanel;
/* 1400 */       GridBagConstraints gridbagconstraints = 
/* 1401 */         V2CSwingUtil.createGridBagConstraints();
/* 1402 */       gridbagconstraints.anchor = 10;
/* 1403 */       gridbagconstraints.fill = 1;
/* 1404 */       gridbagconstraints.weightx = 1.0D;
/* 1405 */       gridbagconstraints.weighty = 1.0D;
/* 1406 */       jpanel.add(v2chtmlpane, gridbagconstraints);
/* 1407 */       gridbagconstraints.gridy += 1;
/* 1408 */       gridbagconstraints.weighty = 0.0D;
/* 1409 */       gridbagconstraints.fill = 0;
/* 1410 */       gridbagconstraints.insets = new Insets(5, 5, 5, 5);
/* 1411 */       JLabel jlabel = new JLabel("☆★☆上のフォームでは絶対に入力・操作しないでください。☆★☆");
/* 1412 */       jlabel.setFont(jlabel.getFont().deriveFont(20.0F));
/* 1413 */       jlabel.setForeground(Color.RED);
/* 1414 */       jpanel.add(jlabel, gridbagconstraints);
/*      */     } else {
/* 1416 */       obj = v2chtmlpane;
/*      */     }
/* 1418 */     JScrollPane jscrollpane = 
/* 1419 */       V2CSwingUtil.createBoundedScrollPane((JComponent)obj, 
/* 1420 */       0.5D, 0.5D);
/*      */     
/* 1422 */     BorderLayout layout = new BorderLayout();
/*      */     
/* 1424 */     JPanel parentPanel = new JPanel(layout);
/* 1425 */     parentPanel.add(jscrollpane, "Center");
/*      */     
/*      */ 
/*      */ 
/* 1429 */     JLabel label = new JLabel(subMessage);
/*      */     
/*      */ 
/*      */ 
/* 1433 */     parentPanel.add(label, "South");
/*      */     
/* 1435 */     return parentPanel;
/*      */   }
/*      */   
/*      */ 
/*      */   boolean getPostViaP2()
/*      */   {
/* 1441 */     return false;
/*      */   }
/*      */   
/*      */   V2CPostProvision getPostProvision() {
/* 1445 */     return null;
/*      */   }
/*      */   
/*      */   static int checkSamba24(String s, V2CThreadItem v2cthreaditem, boolean flag) {
/*      */     try {
/* 1450 */       Matcher matcher = pSamba24_2.matcher(s);
/* 1451 */       if (matcher.find()) {
/* 1452 */         V2CBoardItem v2cboarditem = v2cthreaditem.getBoardItem();
/* 1453 */         v2cboarditem.setTLastWrite(flag);
/* 1454 */         V2CWritePanelCounter.checkCountUpAll(v2cboarditem);
/* 1455 */         return V2CMiscUtil.parseInt(matcher.group(1));
/*      */       }
/*      */       
/* 1458 */       matcher = pSamba24.matcher(s);
/* 1459 */       if (matcher.find()) {
/* 1460 */         V2CBoardItem v2cboarditem = v2cthreaditem.getBoardItem();
/* 1461 */         v2cboarditem.setTLastWrite(flag);
/* 1462 */         V2CWritePanelCounter.checkCountUpAll(v2cboarditem);
/* 1463 */         return V2CMiscUtil.parseInt(matcher.group(1));
/*      */       }
/*      */       
/* 1466 */       return 0;
/*      */     }
/*      */     catch (Exception e) {
/* 1469 */       e.printStackTrace(); }
/* 1470 */     return 0;
/*      */   }
/*      */   
/*      */   void reloadSamba24()
/*      */   {
/* 1475 */     V2CProperty v2cproperty = this.vpSamba24Time;
/* 1476 */     if (v2cproperty != null) {
/* 1477 */       this.vpSamba24Time = null;
/*      */       
/* 1479 */       v2cproperty.doSaveState();
/*      */     }
/*      */     
/* 1482 */     this.hmSamba24Time = null;
/* 1483 */     getSamba24Property();
/*      */   }
/*      */   
/*      */   V2CProperty getSamba24Property() {
/* 1487 */     V2CProperty v2cproperty = this.vpSamba24Time;
/* 1488 */     if (v2cproperty == null) {
/* 1489 */       v2cproperty = new V2CProperty(V2CLocalFileHandler.getFileInBBSDir(
/* 1490 */         this, "samba24.txt"), this, null);
/* 1491 */       this.vpSamba24Time = v2cproperty;
/*      */     }
/* 1493 */     return v2cproperty;
/*      */   }
/*      */   
/*      */ 
/*      */ 
/*      */   int getSamba24Time(V2CBoardItem v2cboarditem)
/*      */   {
/* 1500 */     return 0;
/*      */   }
/*      */   
/*      */   final int getSamba24TimeCache(V2CBoardItem v2cboarditem) {
/* 1504 */     HashMap hashmap = this.hmSamba24Time;
/* 1505 */     if (hashmap == null) {
/* 1506 */       return -1;
/*      */     }
/*      */     Object obj;
/* 1509 */     synchronized (hashmap) {
/* 1510 */       obj = hashmap.get(v2cboarditem); }
/* 1512 */     return (obj instanceof Integer) ? ((Integer)obj).intValue() : -1;
/*      */   }
/*      */   
/*      */   boolean isSambaSupported() {
/* 1516 */     return getSamba24SPMessage(null) != null;
/*      */   }
/*      */   
/*      */   String getSamba24SPMessage(V2CBoardItem v2cboarditem) {
/* 1520 */     return null;
/*      */   }
/*      */   
/*      */   void setSamba24Time(V2CBoardItem v2cboarditem) {
/* 1524 */     String s = getSamba24SPMessage(v2cboarditem);
/* 1525 */     if (s == null) {
/* 1526 */       return;
/*      */     }
/* 1528 */     String s1 = JOptionPane.showInputDialog(V2CMain.v2cMain, 
/* 1529 */       V2CSwingUtil.wrapString(s), 
/* 1530 */       String.valueOf(getSamba24Time(v2cboarditem)));
/* 1531 */     if ((s1 == null) || (s1.length() == 0)) {
/* 1532 */       return;
/*      */     }
/* 1534 */     setSamba24Time(V2CMiscUtil.parseInt(s1, -1), v2cboarditem);
/*      */   }
/*      */   
/*      */ 
/*      */   final void clearSamba24Cache()
/*      */   {
/* 1540 */     HashMap hashmap = getSamba24TimeMap();
/* 1541 */     synchronized (hashmap) {
/* 1542 */       hashmap.clear();
/*      */     }
/*      */   }
/*      */   
/*      */   final void cacheSamba24Time(int i, V2CBoardItem v2cboarditem) {
/* 1547 */     HashMap hashmap = getSamba24TimeMap();
/* 1548 */     synchronized (hashmap)
/*      */     {
/* 1550 */       hashmap.put(v2cboarditem, Integer.valueOf(i));
/*      */     }
/*      */   }
/*      */   
/*      */   private HashMap getSamba24TimeMap() {
/* 1555 */     HashMap hashmap = this.hmSamba24Time;
/* 1556 */     if (hashmap == null) {
/* 1557 */       hashmap = new HashMap();
/* 1558 */       this.hmSamba24Time = hashmap;
/*      */     }
/* 1560 */     return hashmap;
/*      */   }
/*      */   
/*      */   int getDatFieldOffset() {
/* 1564 */     return this.nDatFieldOffset;
/*      */   }
/*      */   
/*      */   String getCharsetString() {
/* 1568 */     return this.sCharset;
/*      */   }
/*      */   
/*      */   String getCharsetString(V2CBoardItem v2cboarditem) {
/* 1572 */     return this.sCharset;
/*      */   }
/*      */   
/*      */   String getHostDir(String s) {
/* 1576 */     return null;
/*      */   }
/*      */   
/*      */   char getIDPlusDot() {
/* 1580 */     return '+';
/*      */   }
/*      */   
/*      */   String getDatContentType() {
/* 1584 */     return this.sDatContentType;
/*      */   }
/*      */   
/*      */   String getID() {
/* 1588 */     return this.sID;
/*      */   }
/*      */   
/*      */   String getName(V2CBoardItem v2cboarditem) {
/* 1592 */     return this.sName;
/*      */   }
/*      */   
/*      */   String getName() {
/* 1596 */     return this.sName;
/*      */   }
/*      */   
/*      */   Icon getIcon() {
/* 1600 */     ImageIcon imageicon = V2CSwingUtil.getSystemIcon(this.sID);
/* 1601 */     return imageicon == null ? icDefault : imageicon;
/*      */   }
/*      */   
/*      */   boolean setColor(Color color) {
/* 1605 */     Color color1 = getColor();
/* 1606 */     if (color1 == null ? color == null : color1.equals(color)) {
/* 1607 */       return false;
/*      */     }
/* 1609 */     V2CProperty v2cproperty = getProperty();
/* 1610 */     if (color != null) {
/* 1611 */       v2cproperty.putColor("BBS.Color:", color);
/*      */     } else {
/* 1613 */       v2cproperty.remove("BBS.Color:");
/*      */     }
/* 1615 */     this.cBBSColor = color;
/* 1616 */     return true;
/*      */   }
/*      */   
/*      */   Color getColor() {
/* 1620 */     Color color = this.cBBSColor;
/* 1621 */     if (color != COLOR_UNKNOWN) {
/* 1622 */       return color;
/*      */     }
/* 1624 */     Color color1 = getProperty().getColor("BBS.Color:", null);
/* 1625 */     this.cBBSColor = color1;
/* 1626 */     return color1;
/*      */   }
/*      */   
/*      */   String getDatExt()
/*      */   {
/* 1631 */     return this.sDatExt;
/*      */   }
/*      */   
/*      */   final boolean isCreateThreadSupported(V2CBoardItem v2cboarditem) {
/* 1635 */     return this.bCreateThreadSupported;
/*      */   }
/*      */   
/*      */   boolean isPostSupported(V2CThreadItem v2cthreaditem) {
/* 1639 */     return this.bPostSupported;
/*      */   }
/*      */   
/*      */   boolean isWritePreviewSupported() {
/* 1643 */     return this.bWritePreviewSupported;
/*      */   }
/*      */   
/*      */   boolean shouldCheckFileEnd() {
/* 1647 */     return this.bFileEndCheck;
/*      */   }
/*      */   
/*      */   boolean useRangeRequestHeader() {
/* 1651 */     return this.bUseRangeRequestHeader;
/*      */   }
/*      */   
/*      */   boolean useLocalResNum() {
/* 1655 */     return this.bUseLocalResNum;
/*      */   }
/*      */   
/*      */   boolean isUpdateModelSupported() {
/* 1659 */     return this.bUpdateModelSupported;
/*      */   }
/*      */   
/*      */   boolean isResURLSupported() {
/* 1663 */     return this.bResURLSupported;
/*      */   }
/*      */   
/*      */   boolean resToGetExists(V2CThreadItem v2cthreaditem) {
/* 1667 */     return true;
/*      */   }
/*      */   
/*      */   boolean isWritable(V2CThreadItem v2cthreaditem) {
/* 1671 */     return true;
/*      */   }
/*      */   
/*      */   boolean isFinished(V2CThreadItem v2cthreaditem) {
/* 1675 */     return false;
/*      */   }
/*      */   
/*      */   public V2CProperty getProperty() {
/* 1679 */     if (this.vpProperties == null) {
/* 1680 */       this.vpProperties = new V2CProperty(
/* 1681 */         V2CLocalFileHandler.getBBSPropertyFile(this), this, 
/* 1682 */         V2CApp.v2cApp);
/*      */     }
/* 1684 */     return this.vpProperties;
/*      */   }
/*      */   
/*      */   public String getLevelString(boolean flag) {
/* 1688 */     if (isTwitter()) {
/* 1689 */       return "Twitter";
/*      */     }
/* 1691 */     return flag ? "BBS [ " + this.sName + " ]" : "BBS";
/*      */   }
/*      */   
/*      */   public String getPropertyClassString()
/*      */   {
/* 1696 */     return "BBS";
/*      */   }
/*      */   
/*      */   static {
/* 1700 */     tzWritePreview = V2CApp.tzJST;
/* 1701 */     dfForWritePreview = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
/* 1702 */     dfForWritePreview.setTimeZone(tzWritePreview);
/* 1703 */     dfForWritePreviewM = new SimpleDateFormat("yy/MM/dd HH:mm");
/* 1704 */     dfForWritePreviewM.setTimeZone(tzWritePreview);
/* 1705 */     dfForWritePreviewSS = new SimpleDateFormat("yy/MM/dd HH:mm:ss.SSS");
/* 1706 */     dfForWritePreviewSS.setTimeZone(tzWritePreview);
/*      */   }
/*      */   
/*      */   void checkName(V2CBoardItem v2cboarditem) {}
/*      */   
/*      */   void createTreeModel() {}
/*      */   
/*      */   void parseURLString(String s, V2CParseLinkResult v2cparselinkresult, boolean flag) {}
/*      */   
/*      */   abstract boolean postMessage(V2CNameAndMail paramV2CNameAndMail, String paramString, V2CThreadItem paramV2CThreadItem);
/*      */   
/*      */   void setSamba24Time(int i, V2CBoardItem v2cboarditem) {}
/*      */ }


/* Location:              H:\__Apps\jd-gui-windows-1.4.0\V2C_R20171103.jar!\org\monazilla\v2c\V2CBBS.class
 * Java compiler version: 7 (51.0)
 * JD-Core Version:       0.7.1
 */