package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Iterator;

import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;

import org.monazilla.v2c.V2CImgurB11UpLoader.DeleteImgurImage;

public class V2CB11ScriptUtil
{
	static JMenuBar menubar1 = null;

	static void performAction(String s){
		// https://b11.script.v2c.net/perform?action=s
		String[] query = s.split("&");
		if(query[0].equals("addToNGUserOnSearchThread")){
			addToNGUserOnSearchThread(query[1].split("=")[1], query[2].split("=")[1], query[3].split("=")[1]);
		}else
		if(query[0].equals("paste")){
			Paste();
		}else
		if(query[0].equals("cut")){
			Cut();
		}else
		if(query[0].equals("YosoUAHelper")){
			YosoHelper();
		}else
		if(query[0].equals("PutStrToClipboard")){
			PutStrToClipboard();
		}else
		if(query[0].equals("GetStrFromClipboard")){
			GetStrFromClipboard();
		}else
		if(query[0].equals("ImgurUpLoader")){
			ImgurUpLoader();
		}else
		if(query[0].equals("ImgurRemover")){
			ImgurRemover();
		}else
		if(query[0].equals("removeCookies")){
			removeCookies();
		}else
		if(query[0].equals("removeTargetCookies")){
			removeTargetCookies();
		}else
		if(query[0].startsWith("removeTargetCookies#")){
			String[] p = query[0].split("#");
			removeTargetCookies(p[1]);
		}else
		if(query[0].equals("removeCookieByName")){
			removeCookieByName(s);
		}else
		if(query[0].startsWith("doClickMainMenu")){
			String[] p = query[0].split("#");
			doClickMainMenu(p);
		}else
		if(query[0].startsWith("Oekaki")){
			String[] p = query[0].split("#");
			Oekaki(p[1]);
		}else
		if(query[0].startsWith("toggleCMDButton")){
			String[] p = query[0].split("#");
			toggleCMDButton(p);
			if(p[1].equals("ハンター")){
				p[1] = "警備員";
				p[2] = "keibiinLogin";
				p[3] = "Foreground=";
				p[4] = "Background=";
				toggleCMDButton(p);
			}else
			if(p[1].equals("警備員")){
				p[1] = "ハンター";
				p[2] = "hunterLogin";
				p[3] = "Foreground=";
				p[4] = "Background=";
				toggleCMDButton(p);
			}
			if(p[1].equals("ハンター") || p[1].equals("警備員")){
				V2CUPLIFTandDonguri.showDonguriID();
			}
		}else
		if(query[0].equals("hunterLogin")){
			hunterLogin();
		}else
		if(query[0].equals("DonguriCannonConfirmer")){
			DonguriCannonConfirmer(query[0]);
		}else
		if(query[0].equals("upliftLogin")){
			V2CUPLIFTandDonguri.upliftLogin();
		}else
		if(query[0].startsWith("keibiinLogin")){
			String[] p = query[0].split("#");
			keibiinLogin(p);
		}else
		if(query[0].startsWith("setPostTimeDiffByBoard")){
			String[] p = query[0].split("#");
			V2CCookieMonaTicketTime.setPostTimeDiffByBoard(p);
		}else
		if(query[0].startsWith("removeMonaTicketByBoard")){
			String[] p = query[0].split("#");
			V2CCookieMonaTicketUA.physicalRemove(p);
			V2CCookieMonaTicket.physicalRemove(p);
		}
	}

	static boolean putGlobalBoolean(String s, boolean obj)
    {
		V2CScriptApp.putProperty(s, ""+obj);
		if((s.equals("hunterLogin") || s.equals("keibiinLogin")) && obj == false){
			V2CScriptApp.removeProperty(s);
		}
		V2CApp.getUserProperty().putBoolean(s, obj);
		return V2CApp.getUserProperty().getBoolean(s);
    }

	static void removeGlobalBoolean(String s)
    {
		V2CScriptApp.removeProperty(s);
		V2CApp.getUserProperty().remove(s);
    }

	static boolean getGlobalBoolean(String s)
    {
		return V2CApp.getUserProperty().getBoolean(s);
    }

	static boolean syncGlobalBooleanP2S(String s)
    {
		if(V2CApp.getUserProperty().getBoolean(s)){
			V2CScriptApp.putProperty(s, "true");
		}else{
			V2CScriptApp.removeProperty(s);
		}
		return V2CApp.getUserProperty().getBoolean(s);
    }

	static boolean syncGlobalBooleanS2P(String s)
    {
		if((s.equals("hunterLogin")) && !V2CApp.getUserProperty().getBoolean(s)){
			V2CScriptApp.removeProperty(s);
		}
		V2CApp.getUserProperty().putBoolean(s, (""+V2CScriptApp.getProperty(s)).equals("true")?true:false);
		return V2CApp.getUserProperty().getBoolean(s);
    }

	static void addToNGUserOnSearchThread(String s, String s1, String type)
	{
		if (s == null || s.length() == 0 || type == null || type.length() == 0 || !type.startsWith("NGU")){
			return;
		}

		V2CThreadPanel v2cthreadpanel = null;

		V2CThreadPanel.TPIterator tpiterator = V2CThreadPanel.getTPIterator();
		long l = 0L;
		label0: do {
			if (tpiterator.hasNext()) {
				v2cthreadpanel = tpiterator.next();
				if (!v2cthreadpanel.isTwitter())
					continue;
				if (!V2CTwitterBBS.isSearchThread(v2cthreadpanel.getThreadItem()))
					continue;
				V2CTwitterThreadRes v2ctwitterthreadres = (V2CTwitterThreadRes) v2cthreadpanel.getThreadRes();
				Iterator iterator = v2ctwitterthreadres.getNameSet().iterator();
				boolean flag = false;
				do {
					if (!iterator.hasNext())
						break;
					if (!s.equalsIgnoreCase((String) iterator.next()))
						continue;
					flag = true;
					break;
				} while (true);
				if (!flag)
					continue;
				int i = v2ctwitterthreadres.getNRes() - 1;
				do {
					if (i < 0)
						continue label0;
					V2CTweetItem v2ctweetitem = v2ctwitterthreadres.getTweetItem(i);
					if (v2ctweetitem != null && s1.equalsIgnoreCase(v2ctweetitem.getUserName())) {
						long l2 = v2ctweetitem.getTime();
						if (l2 > l) {
							l = l2;

							System.out.println("Twitter NGユーザに追加：" + v2ctweetitem.getName() + "/@" + v2ctweetitem.getUserName() + " (" + v2cthreadpanel.getThreadItem().getFormalURLString() + ")");
							String type1 = type.substring(3);
							V2CTwitterBBS.addToNGUser(v2ctweetitem, new V2CNGTwitterUserSet(v2cthreadpanel.getThreadItem().getProperty()), v2cthreadpanel.getThreadItem(), type1);
							if (type1.length() == 1){
								v2cthreadpanel.applyNGWord(type1.charAt(0) != '0' ? 'I' : 'T');
							}
						}
						continue label0;
					}
					i--;
				} while (true);
			}
			return;
		} while (true);
	}

	static void Paste(){
		Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
		if (component instanceof JTextComponent)
			((JTextComponent) component).paste();
	}

	static void Cut(){
		Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
		if (component instanceof JTextComponent)
			((JTextComponent) component).cut();
	}

	static void YosoHelper(){
		V2CYosoHelperPanel.showDialog(null);
	}

	static void PutStrToClipboard(){
		String s = "";
		synchronized (s) {
			s = (String) V2CScriptApp.getProperty("Clipboard");
			if (s == null)
				return;
			Toolkit toolkit = Toolkit.getDefaultToolkit();
			Clipboard clipboard = toolkit.getSystemClipboard();
			if (clipboard == null)
				return;
			try {
				StringSelection selection = new StringSelection(s);
				clipboard.setContents(selection, null);
			}
			catch (IllegalStateException illegalstateexception) {
				System.out.println(illegalstateexception.getMessage());
			}
		}
	}

	static void GetStrFromClipboard(){
		String s = "";
		synchronized (s) {
			Toolkit toolkit = Toolkit.getDefaultToolkit();
			Clipboard clipboard = toolkit.getSystemClipboard();
			Transferable object = clipboard.getContents(null);
			try {
				s = (String) object.getTransferData(DataFlavor.stringFlavor);
			} catch(UnsupportedFlavorException e){
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
			V2CScriptApp.putProperty("Clipboard", s);
			System.out.println("str="+s);
			System.out.println("V2CScriptApp.getProperty(\"Clipboard\")="+V2CScriptApp.getProperty("Clipboard"));
		}
	}

	static void ImgurUpLoader(){
		if(V2CThreadPanel.getActivePanel().vwpWritePanel != null){
			V2CImgurB11UpLoader a = new V2CImgurB11UpLoader();
			a.previewPostImages();
			a = null;
		}
	}

	static void ImgurRemover(){
		DeleteImgurImage a = new DeleteImgurImage();
		a.action();
		a = null;
	}

	static void removeCookies(){
		if(V2CSwingUtil.showOKCancelDialog("クッキーを全て削除しますか？", "クッキー削除")){
			V2CCookie.removeAllCookies();
		}
	}

	static void removeTargetCookies(){
		if(V2CSwingUtil.showOKCancelDialog("5ch/BBSPINKのクッキーを削除しますか？", "クッキー削除")){
			V2CCookie.removeTargetCookies();
		}
	}

	static void removeTargetCookies(String p){
		if(V2CSwingUtil.showOKCancelDialog("「" + p + "」のクッキーを削除しますか？", "クッキー削除")){
			V2CCookie.removeTargetCookies(p);
		}
	}

	static void removeCookieByName(String s){
		String p[] = s.split("&");
		String[] name = p[1].split("=");
		String[] domain = p[2].split("=");
		if(V2CSwingUtil.showOKCancelDialog("「" + domain[1] + "」の「" + name[1] + "」を削除しますか？", "クッキー削除")){
			V2CCookie.UpdateCookie(null, name[1], domain[1], null);
		}
	}

	static void doClickMainMenu(String[] p){
		if(menubar1 == null){
			menubar1 = V2CMain.v2cMain.getJMenuBar();
		}
        if(p[1].equals("PrintMainMenu")) System.out.println("\n--- MainMenu Start ---");
		for (int i = 0; i < menubar1.getMenuCount(); i++) {
		    JMenu menu1 = menubar1.getMenu(i);
		    if(!p[1].startsWith(menu1.getText())){
		    	if(!p[1].equals("PrintMainMenu")) continue;
		    }
		    for (int j = 0; j < menu1.getMenuComponentCount(); j++) {
		        java.awt.Component comp = menu1.getMenuComponent(j);
		        if(comp instanceof JMenu) {
				    for (int j1 = 0; j1 < ((JMenu) comp).getMenuComponentCount(); j1++) {
				        java.awt.Component comp2 = ((JMenu) comp).getMenuComponent(j1);
				        if (comp2 instanceof JMenuItem) {
				            JMenuItem menuItem1 = (JMenuItem) comp2;
				            String tmp = (menu1.getText() + "＞" + ((AbstractButton) comp).getText() + "＞" + menuItem1.getText() + "＞" + menuItem1.getActionCommand());
				            if(p[1].equals("PrintMainMenu")) System.out.println(tmp);
				            if(tmp.equals(p[1])){
				            	if(menuItem1.getActionCommand().equals("Config$ExtCommand")){
				            		if(p.length == 3){
				            			if(p[2].matches("\\d+")){
				            				V2CExtCommandSP.nLastSelectedIndex = Integer.parseInt(p[2]);
				            			}
				            		}
				            	}
					            menuItem1.doClick();
					            i = menubar1.getMenuCount();
					            break;
				            }
				        }
				    }
		        }else
		        if (comp instanceof JMenuItem) {
		            JMenuItem menuItem1 = (JMenuItem) comp;
		            String tmp = (menu1.getText() + "＞" + menuItem1.getText() + "＞" + menuItem1.getActionCommand());
		            if(p[1].equals("PrintMainMenu")) System.out.println(tmp);
		            if(tmp.equals(p[1])){
		            	if(menuItem1.getActionCommand().equals("Config$ExtCommand")){
		            		if(p.length == 3){
		            			if(p[2].matches("\\d+")){
		            				V2CExtCommandSP.nLastSelectedIndex = Integer.parseInt(p[2]);
		            			}
		            		}
		            	}
			            menuItem1.doClick();
			            i = menubar1.getMenuCount();
			            break;
		            }
		        }
		    }
		}
        if(p[1].equals("PrintMainMenu")) System.out.println("--- MainMenu End ---\n");
	}

	static void Oekaki(String p){
		V2CThreadPanel v2cthreadpanel = V2CThreadPanel.getActivePanel();
		if(p.equals("open")){
			V2COekaki.open(v2cthreadpanel);
		}else
		if(p.equals("preview")){
			V2COekaki.preview(v2cthreadpanel);
		}
	}

	static void toggleCMDButton(String[] p){
		boolean showIcon = syncGlobalBooleanS2P(p[2]);
		Color Background = OrgBackground;
		Color Foreground = OrgForeground;
		String IconName = null;
		
		for(int i=3; i<p.length; i++){
			String[] q = (""+p[i]).split("=");
			if((""+q[0]).indexOf("ground") != -1){
				if(q.length == 2){
					if(q[1].length() == 6){
						if((""+q[0]).equals("Background")) Background = getColor(q[1]);
						if((""+q[0]).equals("Foreground")) Foreground = getColor(q[1]);
					}
				}
			}else
			if((""+q[0]).equals("showIcon")){
				if((""+q[1]).equals("true")){
					showIcon = true;
				}else
				if((""+q[1]).equals("false")){
					showIcon = false;
				}
			}else
			if((""+q[0]).equals("IconName")){
				IconName = q[1];
			}
		}

		String as[] = { "Display", "Table", "Main" };
		int i = as.length - 1;
		do {
			if (i < 0)
				break;
			V2CToolBarButtonPanel v2ctoolbarbuttonpanel = V2CToolBarButtonPanel.getButtonPanel(as[i]);
			synchronized (v2ctoolbarbuttonpanel) {
				int j = v2ctoolbarbuttonpanel.getComponentCount();
				for (int k = 0; k < j; k++) {
					Component component = v2ctoolbarbuttonpanel.getComponent(k);
					if (!(component instanceof V2CToolBarButtonPanel.CMDButton))
						continue;
					V2CExtCommand v2cextcommand = ((V2CToolBarButtonPanel.CMDButton) component).vExtCommand;
					if(v2cextcommand.sLabel.equals(p[1])){
						V2CToolBarButtonPanel.CMDButton cmdbutton = (V2CToolBarButtonPanel.CMDButton) component;
						cmdbutton.toggleCMDButton(component, showIcon, IconName);
						((V2CToolBarButtonPanel.CMDButton) component).setBackground(Background);
						((V2CToolBarButtonPanel.CMDButton) component).setForeground(Foreground);
						i = -1;
						break;
					}
				}
			}
			i--;
		} while (true);
	}
	static Color getColor(String s){
		int	r = Integer.parseInt((""+s).substring(0, 2), 16);
		int	g = Integer.parseInt((""+s).substring(2, 4), 16);
		int	b = Integer.parseInt((""+s).substring(4, 6), 16);
		return new Color(r,g,b);
	}
	private static Color OrgBackground = null;
	private static Color OrgForeground = null;
	static void getCMDButtonColor(){
		V2CToolBarButtonPanel.CMDButton cmd = new V2CToolBarButtonPanel.CMDButton("CMD,G:C${SCRIPT} dummy.js\tLダミー");
		OrgBackground =	cmd.getBackground();
		OrgForeground = cmd.getForeground();
		cmd = null;
	}

	static void hunterLogin(){
		String p = (String) V2CScriptApp.getProperty("hunterLogin");
		if(p != null){
			V2CUPLIFTandDonguri.logoutHunter(null);
			V2CB11ScriptUtil.putGlobalBoolean("hunterLogin", false);
		}else{
			boolean b = V2CUPLIFTandDonguri.loginHunter(null);
			if(b){
				V2CB11ScriptUtil.putGlobalBoolean("hunterLogin", true);
			}else{
				V2CB11ScriptUtil.putGlobalBoolean("hunterLogin", false);
			}
		}
	}

	static void DonguriCannonConfirmer(String key){
		V2CUPLIFTandDonguri.DonguriCannonConfirmer(key);
	}

	static void keibiinLogin(String[] data){
		String p = (String) V2CScriptApp.getProperty("keibiinLogin");
		if(p != null){
			V2CUPLIFTandDonguri.logoutKeibiin(null);
			V2CB11ScriptUtil.putGlobalBoolean("keibiinLogin", false);
		}else{
			boolean b = V2CUPLIFTandDonguri.loginKeibiin(null, data[1] + "&" + data[2]);
			if(b){
				V2CB11ScriptUtil.putGlobalBoolean("keibiinLogin", true);
			}else{
				V2CB11ScriptUtil.putGlobalBoolean("keibiinLogin", false);
			}
		}
	}
}
