package org.monazilla.v2c;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;

public class V2CAddressBar
  extends JPanel
  implements V2CEditOperation, ActionListener, V2CKeyPopupMenu, FocusListener
{
  private static final String sWidthKey = "AddressBar.Width";
  private static final boolean bWinSelection = V2CApp.isWinType();;
  private static V2CAddressBar vAddresBar;
	private static final Pattern LockUrl = Pattern
			.compile("https?://[^\\.]*(?:\\.[25]ch\\.net/|\\.bbspink\\.com/).+?#(lock|unlock)$");
	private static final Pattern patternReadCGI = Pattern
			.compile("https?://([^\\.]*)(\\.[25]ch\\.net|\\.bbspink\\.com)/test/read\\.cgi/([^/]*)/([0-9]*).*");
	private static final Pattern patternInputtalkjpUrl = Pattern
			.compile("https?://talk\\.jp/boards/([^/]+)/(\\d+)/?");
  static int nFixedWidth = V2CMain.getUserProperty().getInt("AddressBar.Width");
  JTextField jtfAddress;
  PopupListener vPopupListener;
  JButton jbGo;
  private boolean bTempFocusLost;
  
  static V2CAddressBar getInstance()
  {
    if (vAddresBar == null) {
      vAddresBar = new V2CAddressBar();
    }
    return vAddresBar;
  }
  
  static void openLocation()
  {
    String[] arrayOfString;
    if (V2CWebBrowserUtil.checkJDIC()) {
      arrayOfString = new String[] { "開く", "外部ブラウザ", "内部ブラウザ", "キャンセル" };
    } else {
      arrayOfString = new String[] { "開く", "外部ブラウザ", "キャンセル" };
    }
    int i = arrayOfString.length - 1;
    V2CInputDialog localV2CInputDialog = new V2CInputDialog(null, "URL：", null, null, 40, "URLを開く");
    int j = localV2CInputDialog.showDialog(arrayOfString, 0);
    if ((j < 0) || (j >= i)) {
      return;
    }
    String str = localV2CInputDialog.getInputString();
    if (str.length() == 0) {
      return;
    }
    if (j == 0) {
      openLocation(str, true, false);
    } else if (j == 1) {
      V2CMiscUtil.openLinkWithWebBrowser(str, true, false, true, false);
    } else if (j == 2) {
      V2CMiscUtil.openLinkWithWebBrowser(str, true, true, false, false);
    }
  }
  
  static void openLocation(String paramString, boolean paramBoolean1, boolean paramBoolean2)
  {
    if ((paramString == null) || (paramString.length() == 0)) {
      return;
    }
    if (paramString.startsWith(V2CApp.getV2CBaseURLString()))
    {
      Pattern localPattern = Pattern.compile("/iconimg\\.(?:gif|png|jpg|tiff)$");
      Matcher localMatcher = localPattern.matcher(paramString);
      File localFile;
      if (localMatcher.find())
      {
        localFile = V2CLocalFileHandler.getUserConfigFile("iconimg");
        if (V2CMiscUtil2.getContentWithDialog(paramString, localFile, null, "iconimg"))
        {
          V2CMain.clearV2CIcon();
          String[] arrayOfString = { "OK" };
          JOptionPane.showOptionDialog(V2CMain.v2cMain, "アイコンが設定されました。", "icon set", 0, -1, V2CMain.getV2CIcon(true), arrayOfString, arrayOfString[0]);
        }
        else
        {
          V2CSwingUtil.showErrorMessage("iconimgのダウンロードに失敗しました。");
        }
      }
      else if (paramString.endsWith("/toolbar.zip"))
      {
        localFile = V2CLocalFileHandler.getTempFile("tmp.zip");
        if (V2CMiscUtil2.getContentWithDialog(paramString, null, localFile, "ツールバーアイコン"))
        {
          if (V2CLocalFileHandler.extractToolBarIcons(localFile)) {
            V2CSwingUtil.showInformationMessage("ツールバーアイコンが設定されました。\n再起動後に変更が反映されます。");
          } else {
            V2CSwingUtil.showErrorMessage("ツールバーアイコンの解凍に失敗しました。");
          }
        }
        else {
          V2CSwingUtil.showErrorMessage("ツールバーアイコンのダウンロードに失敗しました。");
        }
      }
      else if (paramString.endsWith("/item.zip"))
      {
        localFile = V2CLocalFileHandler.getTempFile("tmp.zip");
        if (V2CMiscUtil2.getContentWithDialog(paramString, null, localFile, "アイテム用アイコン"))
        {
          if (V2CLocalFileHandler.extractItemIcons(localFile)) {
            V2CSwingUtil.showInformationMessage("アイテム用アイコンが設定されました。\n再起動後に変更が反映されます。");
          } else {
            V2CSwingUtil.showErrorMessage("アイテム用アイコンの解凍に失敗しました。");
          }
        }
        else {
          V2CSwingUtil.showErrorMessage("アイテム用アイコンのダウンロードに失敗しました。");
        }
      }
      else if ((V2CApp.isMacintosh()) && (V2CLauncher.startedByLauncher()) && (paramString.endsWith("/V2C.icns")))
      {
        V2CLauncher.getMacIcnsFile(paramString);
      }
      return;
    }
    V2CMiscUtil.openUnknownLink(paramString, paramBoolean1, true, paramBoolean2, paramBoolean2, true);
  }
  
  static void setComponentSize()
  {
    if (vAddresBar == null) {
      return;
    }
    boolean bool = nFixedWidth > 0;
    V2CToolBarComponentSettingPanel localV2CToolBarComponentSettingPanel = new V2CToolBarComponentSettingPanel(bool, vAddresBar.getWidth());
    if (!localV2CToolBarComponentSettingPanel.showDialog()) {
      return;
    }
    V2CProperty localV2CProperty = V2CMain.getUserProperty();
    int i = localV2CToolBarComponentSettingPanel.getFixedWidth();
    if (i == nFixedWidth) {
      return;
    }
    nFixedWidth = i;
    if (i > 0) {
      localV2CProperty.putInt("AddressBar.Width", i);
    } else {
      localV2CProperty.remove("AddressBar.Width");
    }
    vAddresBar.invalidate();
    V2CToolBar localV2CToolBar = (V2CToolBar)SwingUtilities.getAncestorOfClass(V2CToolBar.class, vAddresBar);
    if (localV2CToolBar != null)
    {
      localV2CToolBar.revalidate();
      localV2CToolBar.repaint();
    }
  }
  
  static void resetFont()
  {
    if (vAddresBar != null) {
      vAddresBar.jtfAddress.setFont(null);
    }
  }
  
  public static void setAddressText(String paramString)
  {
    if (vAddresBar == null) {
      return;
    }
    vAddresBar.setText(paramString);
  }
  
  public V2CAddressBar()
  {
    super(new GridBagLayout());
    setOpaque(false);
    GridBagConstraints localGridBagConstraints = V2CSwingUtil.createGridBagConstraints();
    Insets localInsets = localGridBagConstraints.insets;
    JTextField localJTextField = V2CSwingUtil.createTextField();
    this.jtfAddress = localJTextField;
    localJTextField.enableInputMethods(true);
    if ((V2CApp.isMacintosh()) && (V2CMacQuaquaSupport.needsGeometryTweak())) {
      V2CMacQuaquaSupport.resetVisualMargin(localJTextField);
    }
    localJTextField.addActionListener(this);
    this.vPopupListener = new PopupListener();
    localJTextField.addMouseListener(this.vPopupListener);
    if (bWinSelection) {
      localJTextField.addFocusListener(this);
    }
    localGridBagConstraints.weightx = 1.0D;
    localGridBagConstraints.fill = 2;
    if (V2CSwingUtil.isSynthLaF()) {
      localGridBagConstraints.insets = new Insets(0, 0, 1, 0);
    }
    add(localJTextField, localGridBagConstraints);
    localGridBagConstraints.gridx += 1;
    localGridBagConstraints.fill = 0;
    localGridBagConstraints.weightx = 0.0D;
    JButton localJButton = V2CToolBar.createButtonForToolBar("gotoaddr");
    this.jbGo = localJButton;
    localJButton.addActionListener(this);
    localJButton.setFocusable(false);
    localGridBagConstraints.insets = localInsets;
    add(localJButton, localGridBagConstraints);
    V2CInputMap.interceptNormalKeyForTextComponent(this);
  }
  
  public void cut(String paramString)
  {
    this.jtfAddress.cut();
  }
  
  public void copy(String paramString)
  {
    this.jtfAddress.copy();
  }
  
  public void paste(String paramString)
  {
    this.jtfAddress.paste();
  }
  
  public void selectAll(String paramString)
  {
    this.jtfAddress.selectAll();
  }
  
  private void setText(String paramString)
  {
    if ((paramString != null) && (!paramString.equals(this.jtfAddress.getText()))) {
      this.jtfAddress.setText(paramString);
    }
  }
  
  void openLinkOutside()
  {
    String str = this.jtfAddress.getText();
    if ((str != null) && (str.length() > 0)) {
      V2CMiscUtil.openLinkWithWebBrowser(str, true, false, true, false);
    }
  }
  
  void openLinkInside()
  {
    String str = this.jtfAddress.getText();
    if ((str != null) && (str.length() > 0)) {
      V2CMiscUtil.openLinkWithWebBrowser(str, true, true, false, false);
    }
  }
  
  void getThreadWithMoritapo()
  {
    V2CParseLinkResult localV2CParseLinkResult = new V2CParseLinkResult(this.jtfAddress.getText());
    if (localV2CParseLinkResult.parse(true)) {
      V2CThreadPanel.getThreadWithMoritapo(localV2CParseLinkResult.getThreadItem());
    }
  }
  
  void pasteAndGo(ActionEvent paramActionEvent)
  {
    this.jtfAddress.selectAll();
    this.jtfAddress.paste();
    actionPerformed(paramActionEvent);
  }
  
  void openWithCurrentTab()
  {
    openLocation(this.jtfAddress.getText(), false, false);
  }
  
  void openLinkAsBoard()
  {
    String str = V2CBBS.trimForBoardURL(this.jtfAddress.getText());
    if (str == null)
    {
      V2CMain.setErrorMessage("板のURLではありません。");
      return;
    }
    V2CBoardItem localV2CBoardItem = V2CBBS.getAnyBoardIfPossible(str, true);
    if (localV2CBoardItem == null)
    {
      V2CMain.setErrorMessage("板のURLではありません。");
      return;
    }
    localV2CBoardItem.open(true, true);
  }
  
  public void actionPerformed(ActionEvent paramActionEvent)
  {
		String s = this.jtfAddress.getText();
		Matcher lu = LockUrl.matcher(s);
		while (lu.find()) {
			s = s.replace("#"+lu.group(1), "");
			jtfAddress.setText(s);
			dolock0(lu.group(1), s);
			return;
		}
		Matcher m = patternInputtalkjpUrl.matcher(s);
		while (m.find()) {
			s = "https://classic.talk-platform.com/test/read.cgi/" + m.group(1) + "/" + m.group(2) + "/";
		}
		jtfAddress.setText(s);
    openLocation(this.jtfAddress.getText(), (paramActionEvent.getModifiers() & 0x1) == 0, false);
  }
  
  public Dimension getMaximumSize()
  {
    Dimension localDimension = super.getPreferredSize();
    if (localDimension != null)
    {
      if (nFixedWidth > 0) {
        return new Dimension(nFixedWidth, localDimension.height);
      }
      return new Dimension(Integer.MAX_VALUE, localDimension.height);
    }
    return super.getMaximumSize();
  }
  
  public Dimension getPreferredSize()
  {
    Dimension localDimension = super.getPreferredSize();
    if (nFixedWidth > 0) {
      return new Dimension(nFixedWidth, localDimension.height);
    }
    return localDimension;
  }
  
  public Dimension getMinimumSize()
  {
    Dimension localDimension = super.getMinimumSize();
    if (nFixedWidth > 0) {
      return new Dimension(nFixedWidth, localDimension.height);
    }
    return localDimension;
  }
  
  public void focusGained(FocusEvent paramFocusEvent)
  {
    if (this.bTempFocusLost) {
      return;
    }
    this.jtfAddress.selectAll();
  }
  
  public void focusLost(FocusEvent paramFocusEvent)
  {
    this.bTempFocusLost = paramFocusEvent.isTemporary();
    if (this.bTempFocusLost) {
      return;
    }
    Caret localCaret = this.jtfAddress.getCaret();
    int i = localCaret.getDot();
    this.jtfAddress.setSelectionStart(i);
    this.jtfAddress.setSelectionEnd(i);
  }
  
  public void showPopupMenuByKB(ActionEvent paramActionEvent)
  {
    this.vPopupListener.showPopup(this.jtfAddress);
  }
  
  private class PopupListener
    extends V2CPopupListener
  {
    PopupListener()
    {
      super("AddressBar", V2CAddressBar.this);
    }
    
    void setupAction(MouseEvent paramMouseEvent)
    {
      V2CAction.setEnabled("OpenLinkInside", V2CWebBrowserUtil.checkJDIC());
      JTextField localJTextField = V2CAddressBar.this.jtfAddress;
      String str = localJTextField.getText();
      boolean bool1 = false;
      V2CParseLinkResult localV2CParseLinkResult = new V2CParseLinkResult(str);
      if (localV2CParseLinkResult.parse(true))
      {
        Object localObject = localV2CParseLinkResult.getThreadItem();
        if ((localObject != null) && (((V2CThreadItem)localObject).is2ch()) && (V2C2chBBS.isMoritapoLoggedIn())) {
          bool1 = true;
        }
      }
      V2CAction.setEnabled("GetThreadWithMoritapo", bool1);
      if (paramMouseEvent == null) {
        return;
      }
      if (V2CAddressBar.bWinSelection) {
        return;
      }
      Object localObject = localJTextField.getCaret();
      int i = localJTextField.getSelectionStart();
      int j = localJTextField.getSelectionEnd();
      boolean bool2 = V2CApp.isWinType() ? ((Caret)localObject).isSelectionVisible() : ((Caret)localObject).isVisible();
      if ((bool2) && (i < j))
      {
        int k = paramMouseEvent.getPoint().x;
        try
        {
          Rectangle localRectangle = localJTextField.modelToView(i);
          if ((localRectangle != null) && (k > localRectangle.x))
          {
            localRectangle = localJTextField.modelToView(j);
            if ((localRectangle != null) && (k < localRectangle.x)) {
              return;
            }
          }
        }
        catch (BadLocationException localBadLocationException) {}
      }
      if ((!bool2) || (i > 0) || (j < str.length()))
      {
        localJTextField.requestFocusInWindow();
        localJTextField.selectAll();
      }
    }
  }
	public void doLock(V2CThreadPanel v2cthreadpanel, String lock)
	{
		String s = v2cthreadpanel.getThreadItem().getFormalURLString();
		Matcher lu = patternReadCGI.matcher(s);
		while (lu.find()) {
			dolock0(lock, s);
			return;
		}
		V2CSwingUtil.showWarningMessage("スレの" + (lock.equals("lock")?"ロック":"ロック解除") + "は、5ちゃん(V2C上では2ちゃん表記)とBBSPINKでのみ有効です");
	}
	
	private void dolock0(String lock, String s){
		V2CLockedThreadList v2ckockedthreadlist = new V2CLockedThreadList();
		if(lock.equals("lock")){
			v2ckockedthreadlist.update(null, s, null);
		}else if(lock.equals("unlock")){
			v2ckockedthreadlist.update(null, null, s);
		}
		v2ckockedthreadlist = null;
		String sLabel = s;
		Matcher matcher = patternReadCGI.matcher(s);
		if (matcher.matches()) {
			V2CBoardItem v2cboarditem = V2C2chBBS.getBoardItem(s);
			if(v2cboarditem != null){
				if(v2cboarditem.is2ch()){
					V2CThreadItem v2cthreaditem = v2cboarditem.getThreadItem(matcher.group(4) + ".dat");
					sLabel = v2cthreaditem.getTabTitle();
				}else{
					V2CSwingUtil.showWarningMessage("スレの" + (lock.equals("lock")?"ロック":"ロック解除") + "は、5ちゃん(V2C上では2ちゃん表記)とBBSPINKでのみ有効です");
					return;
				}
			}
		}
		V2CSwingUtil.showInformationMessage("「" + sLabel + "」 " + (lock.equals("lock")?"をロックしました":"のロックを解除しました"));
		return;
	}
}


/* Location:              H:\__dat\V2C\V2Cplus\launcher\V2C_R20171103.jar!\org\monazilla\v2c\V2CAddressBar.class
 * Java compiler version: 4 (48.0)
 * JD-Core Version:       0.7.1
 */