package org.monazilla.v2c;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class V2CAPISettings6 extends JPanel {

	JPanel jPanel;
	static JTextField[] config = new JTextField[2];

	private static final String CreateMovieThumb_Key = "2chAPI.CreateMovieThumb";
	private static final String CreateMovieThumbShowCmd_Key = "2chAPI.CreateMovieThumbShowCmd";
	static JCheckBox CreateMovieThumb = new JCheckBox("動画のサムネを作成する", V2CHttpUtil.apiProperty.getBoolean(CreateMovieThumb_Key));
	static JCheckBox CreateMovieThumbShowCmd = new JCheckBox("デバッグ情報を出力する", V2CHttpUtil.apiProperty.getBoolean(CreateMovieThumbShowCmd_Key));

	private static final String webpAnimHQ_Key = "2chAPI.webpAnimHQ";
	static JCheckBox webpAnimHQ = new JCheckBox("品質を優先してwebpアニメを再生", V2CHttpUtil.apiProperty.getBoolean(webpAnimHQ_Key));
	private static final String webpAnimThumbsWait_Key = "2chAPI.webpAnimThumbsWait";
	static JSpinner webpAnimThumbsWait = V2CSwingUtil.createIntSpinner(
			  Integer.valueOf(
					  (
						V2CHttpUtil.apiProperty.get(webpAnimThumbsWait_Key)!=null
					   ?V2CHttpUtil.apiProperty.get(webpAnimThumbsWait_Key)
					   :V2CHttpUtil.webpAnimThumbsWait
					  )
			  )
			, 5, 30);
	private static JLabel label = new JLabel("(WebPダウンロードページからanim_dumpの入手が必要)");

	private static final String UseMS932OnWTSforGoogle_Key = "2chAPI.UseMS932OnWTSforGoogle";
	static JCheckBox UseMS932OnWTSforGoogle = new JCheckBox("GoogleのWebスレッド検索が文字化けするので文字コード変換にMS932を使ってみる", V2CHttpUtil.apiProperty.getBoolean(UseMS932OnWTSforGoogle_Key));

	private static final String Post5chRequestCookieAutoFill_Key = "2chAPI.Post5chRequestCookieAutoFill";
	static JCheckBox Post5chRequestCookieAutoFill = new JCheckBox("書き込みCookieに「yuki=akari; 」を補完する (通常はチェックする必要はありません)", V2CHttpUtil.apiProperty.getBoolean(Post5chRequestCookieAutoFill_Key));
	private static final String Post5chRequestCookieAutoFillCfduid_Key = "2chAPI.Post5chRequestCookieAutoFillCfduid";
	static JCheckBox Post5chRequestCookieAutoFillCfduid = new JCheckBox("書き込みCookieに「__cfduid=」が無い場合Cookieを丸ごと送らない (通常はチェックする必要はありません)", V2CHttpUtil.apiProperty.getBoolean(Post5chRequestCookieAutoFillCfduid_Key));

	private static final String SetCookieToAPIModeDat_Key = "2chAPI.SetCookieToAPIModeDat";
	static JCheckBox SetCookieToAPIModeDat = new JCheckBox("APIモードでのDat取得時にCookieを送信する (通常はチェックする必要はありません)", V2CHttpUtil.apiProperty.getBoolean(SetCookieToAPIModeDat_Key));
	private static final String SetCookieToReadCgiModeDat_Key = "2chAPI.SetCookieToReadCgiModeDat";
	static JCheckBox SetCookieToReadCgiModeDat = new JCheckBox("read.cgiモードでのDat取得時にCookieを送信する (通常はチェックする必要はありません)", V2CHttpUtil.apiProperty.getBoolean(SetCookieToReadCgiModeDat_Key));

	private static final String AllowRentouBoards_Key = "2chAPI.AllowRentouBoards";

	public V2CAPISettings6() {
		this.jPanel = new JPanel(new GridBagLayout());

		GridBagConstraints constraints = V2CSwingUtil
				.createGridBagConstraints();

		JPanel CreateMovieThumbPanel = new JPanel(new GridBagLayout());
		CreateMovieThumbPanel.setBorder(new TitledBorder("動画のサムネ作成 (外部ツールとしてffmpegが必要)"));
		constraints.insets = new Insets(2, 7, 2, 7);

		constraints.gridx = 0;
		constraints.gridy = 0;
		CreateMovieThumbPanel.add(CreateMovieThumb, constraints);

		constraints.gridx = 0;
		constraints.gridy++;
		CreateMovieThumbPanel.add(CreateMovieThumbShowCmd, constraints);

		constraints.gridx = 0;
		constraints.gridy++;
		CreateMovieThumbPanel.add(new JLabel("ffmpegコマンド："),
				constraints);
		config[0] = new JTextField(V2CHttpUtil.CreateMovieThumb_ffmpeg, 30);
		constraints.gridx = 1;
		CreateMovieThumbPanel.add(config[0], constraints);

		constraints.gridx = 0;
		constraints.gridy++;
		CreateMovieThumbPanel.add(webpAnimHQ, constraints);
		constraints.gridx++;
		CreateMovieThumbPanel.add(label, constraints);
		

		constraints.gridx = 0;
		constraints.gridy++;
		JLabel jlabel = new JLabel("サムネ切り出し待ち(秒)");
		CreateMovieThumbPanel.add(jlabel, constraints);
		constraints.gridx++;
		CreateMovieThumbPanel.add(webpAnimThumbsWait, constraints);

		JPanel WebThreadSearchPanel = new JPanel(new GridBagLayout());
		WebThreadSearchPanel.setBorder(new TitledBorder("Webスレッド検索"));
		constraints.insets = new Insets(2, 7, 2, 7);

		constraints.gridx = 0;
		constraints.gridy = 0;
		WebThreadSearchPanel.add(UseMS932OnWTSforGoogle, constraints);

		JPanel Post5chRequestCookieAutoFillPanel = new JPanel(new GridBagLayout());
		Post5chRequestCookieAutoFillPanel.setBorder(new TitledBorder("5ch/BBSPINK 書き込みCookie補完"));
		constraints.insets = new Insets(2, 7, 2, 7);

		constraints.gridx = 0;
		constraints.gridy = 0;
		Post5chRequestCookieAutoFillPanel.add(Post5chRequestCookieAutoFill, constraints);
		constraints.gridy++;
		Post5chRequestCookieAutoFillPanel.add(Post5chRequestCookieAutoFillCfduid, constraints);

		JPanel SetCookieToxxxxxModeDatPanel = new JPanel(new GridBagLayout());
		SetCookieToxxxxxModeDatPanel.setBorder(new TitledBorder("5ch/BBSPINK Dat取得時のCookie送信"));
		constraints.insets = new Insets(2, 7, 2, 7);

		constraints.gridx = 0;
		constraints.gridy = 0;
		SetCookieToxxxxxModeDatPanel.add(SetCookieToAPIModeDat, constraints);
		constraints.gridy++;
		SetCookieToxxxxxModeDatPanel.add(SetCookieToReadCgiModeDat, constraints);

		JPanel AllowRentouBoards = new JPanel(new GridBagLayout());
		AllowRentouBoards.setBorder(new TitledBorder("「同一本文の連投」を規制しない板 (複数ある場合は半角カンマで区切る)"));
		constraints.insets = new Insets(2, 7, 2, 7);

		constraints.gridx = 0;
		constraints.gridy = 0;
		AllowRentouBoards.add(new JLabel("板のurl(http://は不要、全ての板を規制しない場合はall)："),
				constraints);
		config[1] = new JTextField(V2CHttpUtil.AllowRentouBoards, 30);
		constraints.gridx = 1;
		AllowRentouBoards.add(config[1], constraints);

		constraints = V2CSwingUtil.createGridBagConstraints();
		constraints.gridx = 0;
		constraints.gridy = 0;
		this.jPanel.add(CreateMovieThumbPanel, constraints);
		constraints.gridy++;
		this.jPanel.add(WebThreadSearchPanel, constraints);
		constraints.gridy++;
		this.jPanel.add(Post5chRequestCookieAutoFillPanel, constraints);
		constraints.gridy++;
		this.jPanel.add(SetCookieToxxxxxModeDatPanel, constraints);
		constraints.gridy++;
		this.jPanel.add(AllowRentouBoards, constraints);
	}

	JPanel getPanel() {
		return this.jPanel;
	}
	public static V2CProperty saveChanges(V2CProperty apiProperty) {
		String text = (config[0].getText().length()==0
						?V2CGetMovieThumb.ffmpegCmd
						:config[0].getText().replaceAll(" +", " ").replaceAll("^ +", "").replaceAll(" +$", "")
					  );

		String config1 = (""+config[1].getText()).replaceAll("\\.2ch\\.net/", ".5ch.net/").replaceAll(" ", "");
		apiProperty.putBoolean(CreateMovieThumb_Key, CreateMovieThumb.isSelected());
		apiProperty.putBoolean(CreateMovieThumbShowCmd_Key, CreateMovieThumbShowCmd.isSelected());
		apiProperty.put(V2CAPISettings.CreateMovieThumb_ffmpeg_Key, text);
		apiProperty.putBoolean(webpAnimHQ_Key, webpAnimHQ.isSelected());
		apiProperty.put(webpAnimThumbsWait_Key, String.valueOf(webpAnimThumbsWait.getValue()));
		apiProperty.putBoolean(UseMS932OnWTSforGoogle_Key, UseMS932OnWTSforGoogle.isSelected());
		apiProperty.putBoolean(Post5chRequestCookieAutoFill_Key, Post5chRequestCookieAutoFill.isSelected());
		apiProperty.putBoolean(Post5chRequestCookieAutoFillCfduid_Key, Post5chRequestCookieAutoFillCfduid.isSelected());
		apiProperty.putBoolean(SetCookieToAPIModeDat_Key, SetCookieToAPIModeDat.isSelected());
		apiProperty.putBoolean(SetCookieToReadCgiModeDat_Key, SetCookieToReadCgiModeDat.isSelected());
		apiProperty.put(AllowRentouBoards_Key, config1);
		V2CHttpUtil.CreateMovieThumb = CreateMovieThumb.isSelected();
		V2CHttpUtil.CreateMovieThumbShowCmd = CreateMovieThumbShowCmd.isSelected();
		V2CHttpUtil.CreateMovieThumb_ffmpeg = text;
		V2CHttpUtil.webpAnimHQ = webpAnimHQ.isSelected();
		V2CHttpUtil.webpAnimThumbsWait = String.valueOf(webpAnimThumbsWait.getValue());
		V2CHttpUtil.UseMS932OnWTSforGoogle = UseMS932OnWTSforGoogle.isSelected();
		V2CHttpUtil.Post5chRequestCookieAutoFill = Post5chRequestCookieAutoFill.isSelected();
		V2CHttpUtil.Post5chRequestCookieAutoFillCfduid = Post5chRequestCookieAutoFillCfduid.isSelected();
		V2CHttpUtil.SetCookieToAPIModeDat = SetCookieToAPIModeDat.isSelected();
		V2CHttpUtil.SetCookieToReadCgiModeDat = SetCookieToReadCgiModeDat.isSelected();
		V2CHttpUtil.AllowRentouBoards = config1;
		V2CHttpUtil.AllowRentouBoardsArrayList = V2CHttpUtil.StringToArrayList("B11が連投を許可する板", V2CHttpUtil.AllowRentouBoards);
		return apiProperty;
	}
}
