package org.monazilla.v2c;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class V2C0chBBSUrlConverter
{
	private static final Pattern patternHost = Pattern
			.compile("(^https?://[^/]+/).+");
	private static Map <String, String> hm0chBBSURL = new HashMap <String, String> ();
	private static Map <String, String> hm0chBBSURLEnc = new HashMap <String, String> ();
	private static boolean hm0chBBSURL_exists;

	static public void read(){
		hm0chBBSURL = new HashMap <String, String> ();

		V2CProperty v2cproperty = V2CMain.getUserProperty();
		File file = new File(v2cproperty.fParentFolder.getAbsolutePath()
				+ "/2ch_api_hosts.txt");
		
		if(file.exists()){
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(file));
		 
				String line;
				while ((line = br.readLine()) != null) {
					if(line.length() != 0){
						String w[] = (""+line).replaceAll(" ", "").split("\t");
						hm0chBBSURL.put(w[0], w[1]);
						hm0chBBSURLEnc.put(
								V2CJPConverter.urlEncode((""+w[0]).replaceAll("https?", ""), "UTF-8")
							  , V2CJPConverter.urlEncode((""+w[1]).replaceAll("https?", ""), "UTF-8")
						);
					}
				}
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			br = null;
		}

		hm0chBBSURL_exists = (hm0chBBSURL.size()!=0?true:false);
	}

	static public  URL check0chURL(URL url) {
		if(!hm0chBBSURL_exists)
			return url;
		String s = url.toString();
		if (s == null)
			return url;

		String sUrl = check0chURLString(s);
		if(sUrl == null)
			return url;
		try {
			return new URL(sUrl);
		} catch (MalformedURLException malformedurlexception) {
			V2CMiscUtil.printMalformedURLException(malformedurlexception);
		}
		return url;
	}

	static public  String check0chURLString(String s) {
		if(!hm0chBBSURL_exists)
			return s;
		if (s == null)
			return s;

    	Matcher m = patternHost.matcher(s);
    	if(m.find()){
    		String host = m.group(1);
			if(hm0chBBSURL.containsKey(host)){
				return s.replace(host, (String) hm0chBBSURL.get(host));
			}
    	}
		return s;
	}

	static public String ReplaceHosts(String s){
		if(!hm0chBBSURL_exists)
			return s;
		if (s == null)
			return s;
		
		Iterator localIterator = hm0chBBSURLEnc.keySet().iterator();
		while (localIterator.hasNext()) {
			String str3 = (String) localIterator.next();
			s = s.replaceAll(str3, (String) hm0chBBSURLEnc.get(str3));
		}
		return s;
	}
}
