/*     */ package javax.script;
/*     */ 
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.Reader;
/*     */ import java.io.Writer;
import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class SimpleScriptContext
/*     */   implements ScriptContext
/*     */ {
/*     */   protected Writer writer;
/*     */   protected Writer errorWriter;
/*     */   protected Reader reader;
/*     */   protected Bindings engineScope;
/*     */   protected Bindings globalScope;
/*     */   
/*     */   public SimpleScriptContext()
/*     */   {
/*  70 */     this.engineScope = new SimpleBindings();
/*  71 */     this.globalScope = null;
/*  72 */     this.reader = new InputStreamReader(System.in);
/*  73 */     this.writer = new PrintWriter(System.out, true);
/*  74 */     this.errorWriter = new PrintWriter(System.err, true);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public void setBindings(Bindings bindings, int scope)
/*     */   {
/*  93 */     switch (scope)
/*     */     {
/*     */     case 100: 
/*  96 */       if (bindings == null) {
/*  97 */         throw new NullPointerException("Engine scope cannot be null.");
/*     */       }
/*  99 */       this.engineScope = bindings;
/* 100 */       break;
/*     */     case 200: 
/* 102 */       this.globalScope = bindings;
/* 103 */       break;
/*     */     default: 
/* 105 */       throw new IllegalArgumentException("Invalid scope value.");
/*     */     }
/*     */     
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object getAttribute(String name)
/*     */   {
/* 124 */     if (this.engineScope.containsKey(name))
/* 125 */       return getAttribute(name, 100);
/* 126 */     if ((this.globalScope != null) && (this.globalScope.containsKey(name))) {
/* 127 */       return getAttribute(name, 200);
/*     */     }
/*     */     
/* 130 */     return null;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object getAttribute(String name, int scope)
/*     */   {
/* 147 */     switch (scope)
/*     */     {
/*     */     case 100: 
/* 150 */       return this.engineScope.get(name);
/*     */     
/*     */     case 200: 
/* 153 */       if (this.globalScope != null) {
/* 154 */         return this.globalScope.get(name);
/*     */       }
/* 156 */       return null;
/*     */     }
/*     */     
/* 159 */     throw new IllegalArgumentException("Illegal scope value.");
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object removeAttribute(String name, int scope)
/*     */   {
/* 176 */     switch (scope)
/*     */     {
/*     */     case 100: 
/* 179 */       if (getBindings(100) != null) {
/* 180 */         return getBindings(100).remove(name);
/*     */       }
/* 182 */       return null;
/*     */     
/*     */     case 200: 
/* 185 */       if (getBindings(200) != null) {
/* 186 */         return getBindings(200).remove(name);
/*     */       }
/* 188 */       return null;
/*     */     }
/*     */     
/* 191 */     throw new IllegalArgumentException("Illegal scope value.");
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public void setAttribute(String name, Object value, int scope)
/*     */   {
/* 208 */     switch (scope)
/*     */     {
/*     */     case 100: 
/* 211 */       this.engineScope.put(name, value);
/* 212 */       return;
/*     */     
/*     */     case 200: 
/* 215 */       if (this.globalScope != null) {
/* 216 */         this.globalScope.put(name, value);
/*     */       }
/* 218 */       return;
/*     */     }
/*     */     
/* 221 */     throw new IllegalArgumentException("Illegal scope value.");
/*     */   }
/*     */   
/*     */ 
/*     */   public Writer getWriter()
/*     */   {
/* 227 */     return this.writer;
/*     */   }
/*     */   
/*     */   public Reader getReader()
/*     */   {
/* 232 */     return this.reader;
/*     */   }
/*     */   
/*     */   public void setReader(Reader reader)
/*     */   {
/* 237 */     this.reader = reader;
/*     */   }
/*     */   
/*     */   public void setWriter(Writer writer)
/*     */   {
/* 242 */     this.writer = writer;
/*     */   }
/*     */   
/*     */   public Writer getErrorWriter()
/*     */   {
/* 247 */     return this.errorWriter;
/*     */   }
/*     */   
/*     */   public void setErrorWriter(Writer writer)
/*     */   {
/* 252 */     this.errorWriter = writer;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public int getAttributesScope(String name)
/*     */   {
/* 265 */     if (this.engineScope.containsKey(name))
/* 266 */       return 100;
/* 267 */     if ((this.globalScope != null) && (this.globalScope.containsKey(name))) {
/* 268 */       return 200;
/*     */     }
/* 270 */     return -1;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Bindings getBindings(int scope)
/*     */   {
/* 284 */     if (scope == 100)
/* 285 */       return this.engineScope;
/* 286 */     if (scope == 200) {
/* 287 */       return this.globalScope;
/*     */     }
/* 289 */     throw new IllegalArgumentException("Illegal scope value.");
/*     */   }
/*     */   
/*     */ 
/*     */   public List<Integer> getScopes()
/*     */   {
/* 295 */     return scopes;
/*     */   }
/*     */   
/*     */ 
/* 303 */   private static List<Integer> scopes = new ArrayList<Integer>();
			private static boolean flag = false;
/*     */   static
/*     */   {
				if(!flag){
/* 301 */     		scopes.add(Integer.valueOf(100));
/* 302 */     		scopes.add(Integer.valueOf(200)); //}
					flag = true;
				}
			}
/*     */ }


/* Location:              E:\__Apps\jd-gui-windows-1.4.0\script-api.jar!\javax\script\SimpleScriptContext.class
 * Java compiler version: 5 (49.0)
 * JD-Core Version:       0.7.1
 */