/*     */ package javax.script;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class SimpleBindings
/*     */   implements Bindings
/*     */ {
/*     */   private Map<String, Object> map;
/*     */   
/*     */   public SimpleBindings(Map<String, Object> m)
/*     */   {
/*  36 */     if (m == null) {
/*  37 */       throw new NullPointerException();
/*     */     }
/*  39 */     this.map = m;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */   public SimpleBindings()
/*     */   {
/*  46 */     this(new HashMap());
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object put(String name, Object value)
/*     */   {
/*  62 */     checkKey(name);
/*  63 */     return this.map.put(name, value);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public void putAll(Map<? extends String, ? extends Object> toMerge)
/*     */   {
/*  77 */     if (toMerge == null) {
/*  78 */       throw new NullPointerException("toMerge map is null");
/*     */     }
/*  80 */     for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
/*  81 */       String key = (String)entry.getKey();
/*  82 */       checkKey(key);
/*  83 */       put(key, entry.getValue());
/*     */     }
/*     */   }
/*     */   
/*     */   public void clear()
/*     */   {
/*  89 */     this.map.clear();
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/* 108 */     checkKey(key);
/* 109 */     return this.map.containsKey(key);
/*     */   }
/*     */   
/*     */   public boolean containsValue(Object value)
/*     */   {
/* 114 */     return this.map.containsValue(value);
/*     */   }
/*     */   
/*     */   public Set<Map.Entry<String, Object>> entrySet()
/*     */   {
/* 119 */     return this.map.entrySet();
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 144 */     checkKey(key);
/* 145 */     return this.map.get(key);
/*     */   }
/*     */   
/*     */   public boolean isEmpty()
/*     */   {
/* 150 */     return this.map.isEmpty();
/*     */   }
/*     */   
/*     */   public Set<String> keySet()
/*     */   {
/* 155 */     return this.map.keySet();
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object remove(Object key)
/*     */   {
/* 181 */     checkKey(key);
/* 182 */     return this.map.remove(key);
/*     */   }
/*     */   
/*     */   public int size()
/*     */   {
/* 187 */     return this.map.size();
/*     */   }
/*     */   
/*     */   public Collection<Object> values()
/*     */   {
/* 192 */     return this.map.values();
/*     */   }
/*     */   
/*     */   private void checkKey(Object key) {
/* 196 */     if (key == null) {
/* 197 */       throw new NullPointerException("key can not be null");
/*     */     }
/* 199 */     if (!(key instanceof String)) {
/* 200 */       throw new ClassCastException("key should be a String");
/*     */     }
/* 202 */     if (key.equals("")) {
/* 203 */       throw new IllegalArgumentException("key can not be empty");
/*     */     }
/*     */   }
/*     */ }


/* Location:              E:\__Apps\jd-gui-windows-1.4.0\script-api.jar!\javax\script\SimpleBindings.class
 * Java compiler version: 5 (49.0)
 * JD-Core Version:       0.7.1
 */