/*     */ package javax.script;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class ScriptException
/*     */   extends Exception
/*     */ {
/*     */   private String fileName;
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   private int lineNumber;
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   private int columnNumber;
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public ScriptException(String s)
/*     */   {
/*  33 */     super(s);
/*  34 */     this.fileName = null;
/*  35 */     this.lineNumber = -1;
/*  36 */     this.columnNumber = -1;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public ScriptException(Exception e)
/*     */   {
/*  46 */     super(e);
/*  47 */     this.fileName = null;
/*  48 */     this.lineNumber = -1;
/*  49 */     this.columnNumber = -1;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public ScriptException(String message, String fileName, int lineNumber)
/*     */   {
/*  65 */     super(message);
/*  66 */     this.fileName = fileName;
/*  67 */     this.lineNumber = lineNumber;
/*  68 */     this.columnNumber = -1;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public ScriptException(String message, String fileName, int lineNumber, int columnNumber)
/*     */   {
/*  83 */     super(message);
/*  84 */     this.fileName = fileName;
/*  85 */     this.lineNumber = lineNumber;
/*  86 */     this.columnNumber = columnNumber;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public String getMessage()
/*     */   {
/*  95 */     String ret = super.getMessage();
/*  96 */     if (this.fileName != null) {
/*  97 */       ret = ret + " in " + this.fileName;
/*  98 */       if (this.lineNumber != -1) {
/*  99 */         ret = ret + " at line number " + this.lineNumber;
/*     */       }
/*     */       
/* 102 */       if (this.columnNumber != -1) {
/* 103 */         ret = ret + " at column number " + this.columnNumber;
/*     */       }
/*     */     }
/*     */     
/* 107 */     return ret;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */   public int getLineNumber()
/*     */   {
/* 115 */     return this.lineNumber;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */   public int getColumnNumber()
/*     */   {
/* 123 */     return this.columnNumber;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public String getFileName()
/*     */   {
/* 133 */     return this.fileName;
/*     */   }
/*     */ }


/* Location:              E:\__Apps\jd-gui-windows-1.4.0\script-api.jar!\javax\script\ScriptException.class
 * Java compiler version: 5 (49.0)
 * JD-Core Version:       0.7.1
 */