/*     */ package javax.script;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;

/*     */ import sun.misc.Service;
/*     */ import sun.misc.ServiceConfigurationError;
/*     */ import sun.reflect.Reflection;
/*     */ import sun.security.util.SecurityConstants;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public class ScriptEngineManager
/*     */ {
/*     */   private static final boolean DEBUG = false;
/*     */   private HashSet<ScriptEngineFactory> engineSpis;
/*     */   private HashMap<String, ScriptEngineFactory> nameAssociations;
/*     */   private HashMap<String, ScriptEngineFactory> extensionAssociations;
/*     */   private HashMap<String, ScriptEngineFactory> mimeTypeAssociations;
/*     */   private Bindings globalScope;
/*     */   
/*     */   public ScriptEngineManager()
/*     */   {
/*  48 */     ClassLoader ctxtLoader = Thread.currentThread().getContextClassLoader();
/*  49 */     if (canCallerAccessLoader(ctxtLoader))
/*     */     {
/*  51 */       init(ctxtLoader);
/*     */     }
/*     */     else {
/*  54 */       init(null);
/*     */     }
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public ScriptEngineManager(ClassLoader loader)
/*     */   {
/*  69 */     init(loader);
/*     */   }
/*     */   
/*     */   private void init(final ClassLoader loader) {
/*  73 */     this.globalScope = new SimpleBindings();
/*  74 */     this.engineSpis = new HashSet();
/*  75 */     this.nameAssociations = new HashMap();
/*  76 */     this.extensionAssociations = new HashMap();
/*  77 */     this.mimeTypeAssociations = new HashMap();
/*  78 */     AccessController.doPrivileged(new PrivilegedAction() {
/*     */       public Object run() {
/*  80 */         ScriptEngineManager.this.initEngines(loader);
/*  81 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */   
/*     */   private void initEngines(ClassLoader loader) {
/*  87 */     Iterator itr = null;
/*     */     try {
/*  89 */       if (loader != null) {
/*  90 */         itr = Service.providers(ScriptEngineFactory.class, loader);
/*     */       } else {
/*  92 */         itr = Service.installedProviders(ScriptEngineFactory.class);
/*     */       }
/*     */     } catch (ServiceConfigurationError err) {
/*  95 */       System.err.println("Can't find ScriptEngineFactory providers: " + err.getMessage());
/*     */       
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/* 103 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 107 */       while (itr.hasNext()) {
/*     */         try {
/* 109 */           ScriptEngineFactory fact = (ScriptEngineFactory)itr.next();
/* 110 */           this.engineSpis.add(fact);
/*     */         } catch (ServiceConfigurationError err) {
/* 112 */           System.err.println("ScriptEngineManager providers.next(): " + err.getMessage());
				  } catch (UnsupportedClassVersionError err) {
/*     */         }
/*     */         
/*     */       }
/*     */       
/*     */ 
/*     */     }
/*     */     catch (ServiceConfigurationError err)
/*     */     {
/*     */ 
/* 122 */       System.err.println("ScriptEngineManager providers.hasNext(): " + err.getMessage());
/*     */       
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/* 130 */       return;
/*     */     }
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public void setBindings(Bindings bindings)
/*     */   {
/* 144 */     if (bindings == null) {
/* 145 */       throw new IllegalArgumentException("Global scope cannot be null.");
/*     */     }
/*     */     
/* 148 */     this.globalScope = bindings;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Bindings getBindings()
/*     */   {
/* 159 */     return this.globalScope;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public void put(String key, Object value)
/*     */   {
/* 170 */     this.globalScope.put(key, value);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object get(String key)
/*     */   {
/* 179 */     return this.globalScope.get(key);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public ScriptEngine getEngineByName(String shortName)
/*     */   {
/* 199 */     if (shortName == null) { throw new NullPointerException();
/*     */     }
/*     */     Object obj;
/*     */     ScriptEngineFactory spi;
/* 202 */     if (null != (obj = this.nameAssociations.get(shortName))) {
/* 203 */       /*ScriptEngineFactory*/ spi = (ScriptEngineFactory)obj;
/*     */       try {
/* 205 */         ScriptEngine engine = spi.getScriptEngine();
/* 206 */         engine.setBindings(getBindings(), 200);
/* 207 */         return engine;
/*     */       }
/*     */       catch (Exception exp) {}
/*     */     }
/*     */     
/*     */ 
/* 213 */     for (Iterator i$ = this.engineSpis.iterator(); i$.hasNext();) { spi = (ScriptEngineFactory)i$.next();
/* 214 */       List<String> names = null;
/*     */       try {
/* 216 */         names = spi.getNames();
/*     */       }
/*     */       catch (Exception exp) {}
/*     */       
/*     */ 
/* 221 */       if (names != null) {
/* 222 */         for (String name : names) {
/* 223 */           if (shortName.equals(name)) {
/*     */             try {
/* 225 */               ScriptEngine engine = spi.getScriptEngine();
/* 226 */               engine.setBindings(getBindings(), 200);
/* 227 */               return engine;
/*     */             }
/*     */             catch (Exception exp) {}
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     
/* 236 */     return null;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public ScriptEngine getEngineByExtension(String extension)
/*     */   {
/* 250 */     if (extension == null) { throw new NullPointerException();
/*     */     }
/*     */     Object obj;
/*     */     ScriptEngineFactory spi;
/* 253 */     if (null != (obj = this.extensionAssociations.get(extension))) {
/* 254 */       /*ScriptEngineFactory*/ spi = (ScriptEngineFactory)obj;
/*     */       try {
/* 256 */         ScriptEngine engine = spi.getScriptEngine();
/* 257 */         engine.setBindings(getBindings(), 200);
/* 258 */         return engine;
/*     */       }
/*     */       catch (Exception exp) {}
/*     */     }
/*     */     
/*     */ 
/* 264 */     for (Iterator i$ = this.engineSpis.iterator(); i$.hasNext();) { spi = (ScriptEngineFactory)i$.next();
/* 265 */       List<String> exts = null;
/*     */       try {
/* 267 */         exts = spi.getExtensions();
/*     */       }
/*     */       catch (Exception exp) {}
/*     */       
/* 271 */       if (exts != null) {
/* 272 */         for (String ext : exts) {
/* 273 */           if (extension.equals(ext)) {
/*     */             try {
/* 275 */               ScriptEngine engine = spi.getScriptEngine();
/* 276 */               engine.setBindings(getBindings(), 200);
/* 277 */               return engine;
/*     */             } catch (Exception exp) {}
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 284 */     return null;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public ScriptEngine getEngineByMimeType(String mimeType)
/*     */   {
/* 298 */     if (mimeType == null) { throw new NullPointerException();
/*     */     }
/*     */     Object obj;
/*     */     ScriptEngineFactory spi;
/* 301 */     if (null != (obj = this.mimeTypeAssociations.get(mimeType))) {
/* 302 */       /*ScriptEngineFactory*/ spi = (ScriptEngineFactory)obj;
/*     */       try {
/* 304 */         ScriptEngine engine = spi.getScriptEngine();
/* 305 */         engine.setBindings(getBindings(), 200);
/* 306 */         return engine;
/*     */       }
/*     */       catch (Exception exp) {}
/*     */     }
/*     */     
/*     */ 
/* 312 */     for (Iterator i$ = this.engineSpis.iterator(); i$.hasNext();) { spi = (ScriptEngineFactory)i$.next();
/* 313 */       List<String> types = null;
/*     */       try {
/* 315 */         types = spi.getMimeTypes();
/*     */       }
/*     */       catch (Exception exp) {}
/*     */       
/* 319 */       if (types != null) {
/* 320 */         for (String type : types) {
/* 321 */           if (mimeType.equals(type)) {
/*     */             try {
/* 323 */               ScriptEngine engine = spi.getScriptEngine();
/* 324 */               engine.setBindings(getBindings(), 200);
/* 325 */               return engine;
/*     */             } catch (Exception exp) {}
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 332 */     return null;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public List<ScriptEngineFactory> getEngineFactories()
/*     */   {
/* 341 */     List<ScriptEngineFactory> res = new ArrayList(this.engineSpis.size());
/* 342 */     for (ScriptEngineFactory spi : this.engineSpis) {
/* 343 */       res.add(spi);
/*     */     }
/* 345 */     return Collections.unmodifiableList(res);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public void registerEngineName(String name, ScriptEngineFactory factory)
/*     */   {
/* 356 */     if ((name == null) || (factory == null)) throw new NullPointerException();
/* 357 */     this.nameAssociations.put(name, factory);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public void registerEngineMimeType(String type, ScriptEngineFactory factory)
/*     */   {
/* 371 */     if ((type == null) || (factory == null)) throw new NullPointerException();
/* 372 */     this.mimeTypeAssociations.put(type, factory);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public void registerEngineExtension(String extension, ScriptEngineFactory factory)
/*     */   {
/* 385 */     if ((extension == null) || (factory == null)) throw new NullPointerException();
/* 386 */     this.extensionAssociations.put(extension, factory);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   private boolean canCallerAccessLoader(ClassLoader loader)
/*     */   {
/* 405 */     SecurityManager sm = System.getSecurityManager();
/* 406 */     if (sm != null) {
/* 407 */       ClassLoader callerLoader = getCallerClassLoader();
/* 408 */       if ((callerLoader != null) && (
/* 409 */         (loader != callerLoader) || (!isAncestor(loader, callerLoader)))) {
/*     */         try {
/* 411 */           sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
/*     */         }
/*     */         catch (SecurityException exp) {
/* 414 */           return false;
/*     */         }
/*     */       }
/*     */     }
/*     */     
/*     */ 
/* 420 */     return true;
/*     */   }
/*     */   
/*     */ 
/*     */   private ClassLoader getCallerClassLoader()
/*     */   {
/* 426 */     Class caller = Reflection.getCallerClass(3);
/* 427 */     if (caller == null) {
/* 428 */       return null;
/*     */     }
/* 430 */     return caller.getClassLoader();
/*     */   }
/*     */   
/*     */   private boolean isAncestor(ClassLoader cl1, ClassLoader cl2)
/*     */   {
/*     */     do {
/* 436 */       cl2 = cl2.getParent();
/* 437 */       if (cl1 == cl2) return true;
/* 438 */     } while (cl2 != null);
/* 439 */     return false;
/*     */   }
/*     */ }


/* Location:              E:\__Apps\jd-gui-windows-1.4.0\script-api.jar!\javax\script\ScriptEngineManager.class
 * Java compiler version: 5 (49.0)
 * JD-Core Version:       0.7.1
 */