/*     */ package javax.script;
/*     */ 
/*     */ import java.io.Reader;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ public abstract class AbstractScriptEngine
/*     */   implements ScriptEngine
/*     */ {
/*     */   protected ScriptContext context;
/*     */   
/*     */   public AbstractScriptEngine()
/*     */   {
/*  47 */     this.context = new SimpleScriptContext();
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public AbstractScriptEngine(Bindings n)
/*     */   {
/*  60 */     this();
/*  61 */     if (n == null) {
/*  62 */       throw new NullPointerException("n is null");
/*     */     }
/*  64 */     this.context.setBindings(n, 100);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public void setContext(ScriptContext ctxt)
/*     */   {
/*  75 */     if (ctxt == null) {
/*  76 */       throw new NullPointerException("null context");
/*     */     }
/*  78 */     this.context = ctxt;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public ScriptContext getContext()
/*     */   {
/*  87 */     return this.context;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Bindings getBindings(int scope)
/*     */   {
/* 103 */     if (scope == 200)
/* 104 */       return this.context.getBindings(200);
/* 105 */     if (scope == 100) {
/* 106 */       return this.context.getBindings(100);
/*     */     }
/* 108 */     throw new IllegalArgumentException("Invalid scope value.");
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public void setBindings(Bindings bindings, int scope)
/*     */   {
/* 126 */     if (scope == 200) {
/* 127 */       this.context.setBindings(bindings, 200);
/* 128 */     } else if (scope == 100) {
/* 129 */       this.context.setBindings(bindings, 100);
/*     */     } else {
/* 131 */       throw new IllegalArgumentException("Invalid scope value.");
/*     */     }
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public void put(String key, Object value)
/*     */   {
/* 147 */     Bindings nn = getBindings(100);
/* 148 */     if (nn != null) {
/* 149 */       nn.put(key, value);
/*     */     }
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object get(String key)
/*     */   {
/* 165 */     Bindings nn = getBindings(100);
/* 166 */     if (nn != null) {
/* 167 */       return nn.get(key);
/*     */     }
/*     */     
/* 170 */     return null;
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object eval(Reader reader, Bindings bindings)
/*     */     throws ScriptException
/*     */   {
/* 193 */     ScriptContext ctxt = getScriptContext(bindings);
/*     */     
/* 195 */     return eval(reader, ctxt);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object eval(String script, Bindings bindings)
/*     */     throws ScriptException
/*     */   {
/* 214 */     ScriptContext ctxt = getScriptContext(bindings);
/*     */     
/* 216 */     return eval(script, ctxt);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object eval(Reader reader)
/*     */     throws ScriptException
/*     */   {
/* 232 */     return eval(reader, this.context);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   public Object eval(String script)
/*     */     throws ScriptException
/*     */   {
/* 247 */     return eval(script, this.context);
/*     */   }
/*     */   
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   protected ScriptContext getScriptContext(Bindings nn)
/*     */   {
/* 273 */     SimpleScriptContext ctxt = new SimpleScriptContext();
/* 274 */     Bindings gs = getBindings(200);
/*     */     
/* 276 */     if (gs != null) {
/* 277 */       ctxt.setBindings(gs, 200);
/*     */     }
/*     */     
/* 280 */     if (nn != null) {
/* 281 */       ctxt.setBindings(nn, 100);
/*     */     }
/*     */     else {
/* 284 */       throw new NullPointerException("Engine scope Bindings may not be null.");
/*     */     }
/*     */     
/* 287 */     ctxt.setReader(this.context.getReader());
/* 288 */     ctxt.setWriter(this.context.getWriter());
/* 289 */     ctxt.setErrorWriter(this.context.getErrorWriter());
/*     */     
/* 291 */     return ctxt;
/*     */   }
/*     */ }


/* Location:              E:\__Apps\jd-gui-windows-1.4.0\script-api.jar!\javax\script\AbstractScriptEngine.class
 * Java compiler version: 5 (49.0)
 * JD-Core Version:       0.7.1
 */