//【内容】　　 クリップボード内の「.2ch.net」を「.5ch.net」に置換する
//【設置場所】 V2Cログ・設定保存用フォルダ\script\ReplaceCB2to5.js
//【登録場所】 全体、ツールバーのボタン登録領域
//【ラベル】　 2chTo5ch
//【コマンド】 ${SCRIPT:Tc} ReplaceCB2to5.js
//【備考】　スレタイ中のタブ文字も削除する

var chBadge    = ' [5ch→2ch]';
var httpsBadge = ' [https→http]';

// クリップボード
v2c.readURL('https://b11.script.v2c.net/perform?action=GetStrFromClipboard');
var str = ''+v2c.getProperty('Clipboard');
if(''+str != 'null'){
	str = rep2to5(''+str);
	str = (''+str).replace(/\t/igm, '')
	v2c.putProperty('Clipboard', str);
	v2c.readURL("https://b11.script.v2c.net/perform?action=PutStrToClipboard");
}

// 選択範囲
if(''+v2c.getSelectedText() != 'null'){
	v2c.replaceSelectedText(rep2to5(''+v2c.getSelectedText()));
}

function rep2to5(s){
	var ss = s;

	if(chBadge != ''){
		while((''+ss).indexOf(chBadge) != -1){
			ss = (''+ss).replace(chBadge, '');
		}
	}
	if(httpsBadge != ''){
		while((''+ss).indexOf(httpsBadge) != -1){
			ss = (''+ss).replace(httpsBadge, '');
		}
	}
	ss = ss.replace(/\._?2ch\.net\//gi, '.5ch.net/');

	return ss;
}
