package org.monazilla.v2c;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.ZipInputStream;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class V2CWebpAnimation
{
	public static final String VP8_STATUS_UNSUPPORTED_FEATURE = "Decode returned code VP8_STATUS_UNSUPPORTED_FEATURE";
	public static final String wait_message = "準備中";
	private static final String ua = "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36";
	private static boolean c0_print = false;
	private static int iconsBufSize = 5;
	
	private static String id = "";
	private static int nWidth;
	private static int nHeight;
	private static int nDispWidth;
	private static int nDispHeight;
	private static int duration;
	private static boolean play;
	private static long durationAdjust = 0;	
	private static File gIDfldr;
	private static File gIDfldr2;
	private static ImageIcon icons[] = new ImageIcon[iconsBufSize];
	private static ZipInputStream zis = null;
	private static V2CWebpANIMReader war = null;
	private static File ImageFile = null;
	private static boolean webpAnimHQ;
	private static byte origin[] = null;
	private static int iplay = -1;

	private static char controllStatus;
	private static final char NormalPlay = 0x00;
	private static final char Stop = 0x01;
	private static final char NextFrame = 0x02;
	
	public V2CWebpAnimation(V2CLink v2clink) {
		webpAnimHQ = setWebpAnimHQ();
		gIDfldr = createFolder(new File(V2CLocalFileHandler.v2cDir, "/tmp").getAbsolutePath(), v2clink.getImageFile().getName());
		
		setWidth(100);
		setHeight(100);
		setDispWidth(0);
		setDispHeight(0);

		play = true;
		duration = V2CWebpANIMReader.getDuration(v2clink.getImageFile());
		ImageFile = v2clink.getImageFile();
		controllStatus = NormalPlay;

		if(webpAnimHQ){
//			Chunk_ANMF = readANMFnum(gIDfldr);
			try {
				zis = new ZipInputStream(new FileInputStream(new File(gIDfldr, "dump.zip")));
			} catch (FileNotFoundException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		}else{
			war = new V2CWebpANIMReader(ImageFile);
		}
	}

	private static int createIconBuffer(File IDfldr, int i){
		BufferedImage image = null;
		ImageIcon icon = null;
		icons[i % iconsBufSize] = null;
		byte[] FullBuffer = new byte[3*1024*1024];
		byte[] partBuffer = new byte[4096];
		byte b[] = null;
		int fullSize = 0;
		int partSize = 0;
		int l = -1;
		try {
			if(webpAnimHQ){
				l = (zis.getNextEntry()!=null?0:-1);
				if(l != -1){
					while ((partSize = zis.read(partBuffer)) != -1) {
				        System.arraycopy(partBuffer, 0, FullBuffer, fullSize, partSize);
				        fullSize += partSize;
			        }
			        zis.closeEntry();
			        l = fullSize;
			        b = new byte[fullSize];
			        System.arraycopy(FullBuffer, 0, b, 0, fullSize);
					image = ImageIO.read(new ByteArrayInputStream(b));
					icon = new ImageIcon(image);
					icons[i % iconsBufSize] = icon;
					if(c0_print) System.out.println("HQ:" + "dump_" + createSeq(i) + ":" + l);
				}
			}else{
				l = war.getNextEntry();
				if(l != -1){
					b = war.read();
					image = ImageIO.read(new ByteArrayInputStream(b));
					if(getDispWidth() != 0){
						int Offset_Y = getDispHeight() - image.getHeight();
						if(Offset_Y > 0){
							BufferedImage canvas = ImageIO.read(new ByteArrayInputStream(origin));
							Graphics g = canvas.getGraphics();
							g.drawImage(image, 0, Offset_Y, null);
							image = canvas;
							canvas = null;
						}
					}else{
						origin = b.clone();
					}
					icon = new ImageIcon(image);
					icons[i % iconsBufSize] = icon;
					if(c0_print) System.out.println("LQ:" + "dump_" + createSeq(i) + ":" + l);
				}
			}
			if(getDispWidth() == 0){
				setDispWidth(icon.getIconWidth());
				setDispHeight(icon.getIconHeight());
			}
		} catch (IOException e) {
			System.out.println(getDumpflName(IDfldr, i) + ":IOException");
		} catch (NullPointerException e){
			System.out.println(getDumpflName(IDfldr, i) + ":NullPointerException");
		}
		icon = null;
		image = null;
		FullBuffer = null;
		partBuffer = null;
		b = null;
		return l;
	}
	
	public static void setFirst(V2CImagePopup imagepopup, JLabel jLabel){
		for(int i=0; i<iconsBufSize; i++){
			createIconBuffer(gIDfldr, i);
		}
		imagepopup.setLayout(new GridBagLayout());
		GridBagConstraints gridbagconstraints = new GridBagConstraints();
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy = 0;
		gridbagconstraints.fill = 2;
		gridbagconstraints.insets = new Insets(2, 2, 2, 2);
		gridbagconstraints.gridwidth = 2;
		int i = 0;
		if(icons[i % iconsBufSize] != null){
			jLabel.setIcon(icons[i % iconsBufSize]);
		}
		imagepopup.add(jLabel, gridbagconstraints);
		durationAdjust = System.currentTimeMillis();
	}
	
	public static void resetFirst(V2CImagePopup imagepopup, JLabel jLabel){
		if(imagepopup.dScale != 1.0D && imagepopup.dScale != 0.0D){
			icons[0] = new ImageIcon(scaleImage(0, (BufferedImage) icons[0].getImage(), imagepopup.dScale));
			jLabel.setIcon(icons[0]);
		}
		createIconBuffer(gIDfldr, 0);
	}
	
	public static void play(final V2CImagePopup imagepopup, final JLabel jLabel, final int loopcnt){
		new Thread(new Runnable() {
			public void run() {
				for(int l=0; l<loopcnt; l++){
					iplay=(l==0?1:0);
					while(icons[iplay%iconsBufSize] != null){
						if(!play){
//							V2CSwingUtil.showInformationMessage("再生終了 " + i);
							stopRun();
							return;
						}
						while(controllStatus == Stop || controllStatus == NextFrame){
							if(controllStatus == NextFrame){
								paintNextFrame(imagepopup, jLabel);
								iplay++;
								controllStatus = Stop;
							}
							try {
								Thread.sleep(250L);
							} catch (InterruptedException e) {
								// TODO 自動生成された catch ブロック
								e.printStackTrace();
							}
						}
						try {
							long diff = System.currentTimeMillis() - durationAdjust;
							if(diff >= duration) diff = (duration - 1);
							Thread.sleep(duration - diff);
						} catch (InterruptedException e) {
							// TODO 自動生成された catch ブロック
							e.printStackTrace();
						}
						durationAdjust = System.currentTimeMillis();
						int icons_idx = iplay % iconsBufSize;
						if(imagepopup.dScale != 1.0D && imagepopup.dScale != 0.0D){
							icons[icons_idx] = new ImageIcon(scaleImage(iplay, (BufferedImage) icons[icons_idx].getImage(), imagepopup.dScale));
						}
						jLabel.setIcon(icons[icons_idx]);
						createIconBuffer(gIDfldr, icons_idx);

						iplay++;
					}
					loopReset();
				}
				stopRun();
			}
		}).start();
	}
	
	private static void paintNextFrame(V2CImagePopup imagepopup, JLabel jLabel){
		if(icons[iplay % iconsBufSize] == null){
			loopReset();
			iplay = 0;
		}
		int icons_idx = iplay % iconsBufSize;
		if(imagepopup.dScale != 1.0D && imagepopup.dScale != 0.0D){
			icons[icons_idx] = new ImageIcon(scaleImage(iplay, (BufferedImage) icons[icons_idx].getImage(), imagepopup.dScale));
		}
		jLabel.setIcon(icons[icons_idx]);
		createIconBuffer(gIDfldr, icons_idx);
	}
	
	private static void loopReset(){
		if(V2CHttpUtil.CreateMovieThumbShowCmd){
			System.out.println(ImageFile+":"+iplay+" frames");
		}
		if(webpAnimHQ){
			try {
				zis.close();
				zis = new ZipInputStream(new FileInputStream(new File(gIDfldr, "dump.zip")));
			} catch (FileNotFoundException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		}else{
			war.close();
			war = new V2CWebpANIMReader(ImageFile);
		}
		for(int i=0; i<iconsBufSize; i++){
			createIconBuffer(gIDfldr, i);
		}
	}

	private static void stopRun(){
		icons = new ImageIcon[iconsBufSize];
		gIDfldr2 = gIDfldr;
		deleteANIMSource();
		gIDfldr = null;
		ImageFile = null;
		origin = null;
		iplay = -1;
		controllStatus = NormalPlay;
		if(webpAnimHQ){
			try {
				zis.close();
				zis = null;
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		}else{
			war.close();
			war = null;
		}
	}
	
	public static File createFolder(String rootfldr, String ImageFileName){
		File fldr = null;;
		if(rootfldr != "" && rootfldr != null){
			fldr = new File(rootfldr);
		}else{
			fldr = new File(V2CLocalFileHandler.v2cDir, "tmp");
		}
		if(!fldr.exists()){
			fldr.mkdir();
		}
		fldr = new File(fldr, "webp");
		if(!fldr.exists()){
			fldr.mkdir();
		}

		id = ImageFileName.replaceAll("\\.webp$", "");

		String digit = id.substring(0, 1);
		fldr = new File(fldr, digit);
		if(!fldr.exists()){
			fldr.mkdir();
		}
		fldr = new File(fldr, id);
		if(!fldr.exists()){
			fldr.mkdir();
			(new File(fldr, "dump")).mkdir();
		}
		return fldr;
	}

	private static File checkFolder(String rootfldr, String ImageFileName){
		File fldr = null;;
		if(rootfldr != "" && rootfldr != null){
			fldr = new File(rootfldr);
		}else{
			fldr = new File(V2CLocalFileHandler.v2cDir, "tmp");
		}
		fldr = new File(fldr, "webp");

		id = ImageFileName.replaceAll("\\.webp$", "");

		String digit = id.substring(0, 1);
		fldr = new File(fldr, digit);
		fldr = new File(fldr, id);
		return fldr;
	}

	private static void Download(File IDfldr, URL url, HashMap paramHashMap){
		String surl = url.toString().replaceAll(":[^/][^:]+$", "");
		File input = new File(IDfldr, "source.webp");

		URL murl = null;
		OutputStream paramOutputStream = null;;
		try {
			murl = new URL(surl);
			paramOutputStream = new FileOutputStream(input);
			boolean b = V2CHttpUtil.getMovieFile(murl, murl.getHost(), ua, paramOutputStream, paramHashMap, 3);
		} catch (MalformedURLException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
		} catch (FileNotFoundException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
		} catch (IOException e1) {
			// TODO 自動生成された catch ブロック
			e1.printStackTrace();
		}
		paramHashMap = null;
		paramOutputStream = null;
	}
	
	private static void setWidth(int i){
		nWidth = i;
	}
	public static int getWidth(){
		return nWidth;
	}

	private static void setHeight(int i){
		nHeight = i;
	}
	public static int getHeight(){
		return nHeight;
	}

	private static void setDispWidth(int i){
		nDispWidth = i;
	}
	public static int getDispWidth(){
		return nDispWidth;
	}

	private static void setDispHeight(int i){
		nDispHeight = i;
	};
	public static int getDispHeight(){
		return nDispHeight;
	};

	public static void stopPlay(){
		play = false;
	};

	private static String getDumpflName(File IDfldr, int i){
		return (new File((new File(IDfldr, "dump")).getAbsoluteFile() + "/dump_" + createSeq(i) + ".png")).getAbsolutePath();	
	}

	public static String createSeq(int i){
		String seq = "";
		if(i<10){
			seq = "000" + i;
		}else
		if(i<100){
			seq = "00" + i;
		}else
		if(i<1000){
			seq = "0" + i;
		}else
		if(i<10000){
			seq = "" + i;
		}
		return seq;
	}
	
	synchronized public static void deleteANIMSource(){
		new Thread(new Runnable() {
			public void run() {
				if((new File(gIDfldr2, "dump")).exists()){
					File[] files = (new File(gIDfldr2, "dump")).listFiles();
					for(int i=0; i<files.length; i++){
//						System.out.println(files[i].getAbsoluteFile());
						files[i].delete();
					}
					(new File(gIDfldr2, "dump")).delete();
				}
				gIDfldr2 = null;
			}
		}).start();
	}
	
	public static boolean setWebpAnimHQ(){
		return     V2CHttpUtil.webpAnimHQ
				&& V2CGetContainerOfAnimTools.anim_dump_exists() 
				&& V2CApp.javaVersionEqualOrGreaterThan(1, 6)
				?  true:false;
	}

	public static BufferedImage scaleImage(int i, BufferedImage org, double dscale, boolean w) {
		if(c0_print) System.out.println("i="+i+";dscale="+dscale);
		ImageFilter filter = new AreaAveragingScaleFilter(
			(int)(org.getWidth() * dscale), (int)(org.getHeight() * dscale));
		ImageProducer p = new FilteredImageSource(org.getSource(), filter);
		java.awt.Image dstImage = Toolkit.getDefaultToolkit().createImage(p);
		BufferedImage dst = new BufferedImage(
			dstImage.getWidth(null), dstImage.getHeight(null), BufferedImage.TYPE_INT_RGB);
		Graphics2D g = dst.createGraphics();
		g.drawImage(dstImage, 0, 0, null);
		g.dispose();
		return dst;
	}

	public static BufferedImage scaleImage(int i, BufferedImage org, double dscale) {
		if(c0_print) System.out.println("i="+i+";dscale="+dscale+":Affine");
		BufferedImage dst;
		AffineTransformOp xform = null;
		int width = org.getWidth();
		int height = org.getHeight();
		int new_height = (int) (height * dscale);
		int new_width = (int) (width * dscale);
		xform = new AffineTransformOp( AffineTransform.getScaleInstance( ( double )new_width / width, ( double )new_height / height ), AffineTransformOp.TYPE_BILINEAR );
		dst = new BufferedImage( new_width, new_height, org.getType() );
		xform.filter( org, dst );
		return dst;
	}
	
	public static void controllStatus(String s){
		if (s == null || iplay == -1 || !V2CWebpANIMReader.isWebpANIM(ImageFile))
			return;
		if (s.equals("NormalPlay")) {
			controllStatus = NormalPlay;
		}
		else if (s.equals("NextFrame")) {
			controllStatus = NextFrame;
		}
		else if (s.equals("Stop")) {
			controllStatus = Stop;
		}
		else if (s.equals("FastPlay")) {
//			stopAnimation();
//			iRateIndex++;
//			startAnimation();
		}
	}
}
