package org.monazilla.v2c;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class V2CWebThreadSearchPanel implements ActionListener
{

	static void showPanel()
	{
		showPanel(null);
	}

	static void showPanel(String s)
	{
		if (!V2CMain.isOnlineMode()) {
			V2CSwingUtil.showErrorMessage("オンライン状態ではありません。");
			return;
		}
		else {
			V2CWebThreadSearchPanel v2cwebthreadsearchpanel = new V2CWebThreadSearchPanel(s, null, null, null);
			v2cwebthreadsearchpanel.showDialog();
			return;
		}
	}

	// V2CMOD-twZ by MCZ, Date:2017/06/06, Googleサイト検索強化
	static void showPanel(String s, V2CPanel v2cpanel)
	{
		if (!V2CMain.isOnlineMode()) {
			V2CSwingUtil.showErrorMessage("オンライン状態ではありません。");
			return;
		}
		else {
			V2CPanel wv2cpanel = (v2cpanel instanceof V2CThreadPanel?v2cpanel:null);
			V2CWebThreadSearchPanel v2cwebthreadsearchpanel = new V2CWebThreadSearchPanel(s, null, null, wv2cpanel);
			v2cwebthreadsearchpanel.showDialog(wv2cpanel);
			wv2cpanel = null;
			return;
		}
	}
	// ---- END of V2CMOD-twZ ----

	static void showPanel(String as[], V2CThreadItem v2cthreaditem)
	{
		if (!V2CMain.isOnlineMode()) {
			V2CSwingUtil.showErrorMessage("オンライン状態ではありません。");
			return;
		}
		else {
			V2CWebThreadSearchPanel v2cwebthreadsearchpanel = new V2CWebThreadSearchPanel(null, as, v2cthreaditem, null);
			v2cwebthreadsearchpanel.showDialog();
			return;
		}
	}

	private V2CWebThreadSearchPanel(String s, String as[], V2CThreadItem v2cthreaditem, V2CPanel v2cpanel)
	{
		JPanel jpanel = new JPanel(new GridBagLayout());
		jPanel = jpanel;
		b2chKeyword = as != null;
		vThreadItem = v2cthreaditem;
		GridBagConstraints gridbagconstraints = V2CSwingUtil.createGridBagConstraints();
		Insets insets = new Insets(5, 5, 5, 5);
		gridbagconstraints.insets = insets;
		jpanel.add(new JLabel("サイト： "), gridbagconstraints);

		gridbagconstraints.gridx++;
		
		JPanel jpanelSub = new JPanel(new GridBagLayout());
		GridBagConstraints gridbagconstraintsSub = V2CSwingUtil.createGridBagConstraints();
		Insets insetsSub = new Insets(0, 0, 0, 0);
		gridbagconstraintsSub.insets = insetsSub;
		
		ArrayList arraylist = V2CWebSearchEntry.getEntries();
		jcbEntry = V2CSwingUtil.createComboBox(arraylist.toArray());
		jcbEntry.addActionListener(this);
		jpanelSub.add(jcbEntry, gridbagconstraintsSub);

		gridbagconstraintsSub.gridx++;
		BoardTitle = new JLabel("　" + getBoardTitle(v2cpanel));
		BoardTitle.setVisible(false);
		jpanelSub.add(BoardTitle, gridbagconstraintsSub);

		jpanel.add(jpanelSub, gridbagconstraints);

		gridbagconstraints.gridy++;
		gridbagconstraints.gridx = 0;
		jpanel.add(new JLabel("検索語： "), gridbagconstraints);
		gridbagconstraints.gridx++;
		if (b2chKeyword) {
			jlKeywords = new JList(as);
			jlKeywords.setSelectionMode(0);
			if (as.length > 0)
				jlKeywords.setSelectedIndex(0);
			gridbagconstraints.fill = 2;
			gridbagconstraints.insets = new Insets(5, 5, 5, 20);
			jpanel.add(jlKeywords, gridbagconstraints);
			gridbagconstraints.insets = insets;
			gridbagconstraints.fill = 0;
		}
		else {
			jtfSearchWord = V2CSwingUtil.createTextField(25);
			if (s == null)
				s = sLastSearchWord;
			if (s != null && s.length() > 0) {
				jtfSearchWord.setText(s);
				jtfSearchWord.setSelectionStart(0);
				jtfSearchWord.setSelectionEnd(s.length());
			}
			jtfSearchWord.addMouseListener(new V2CPopupListener("WebSearchPanel", jtfSearchWord));
			jpanel.add(jtfSearchWord, gridbagconstraints);
		}
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy++;
		if (vwtsLastEntry != null)
			jcbEntry.setSelectedItem(vwtsLastEntry);
		else if (arraylist.size() > 0)
			jcbEntry.setSelectedIndex(0);
	}

/*
	void showDialog()
	{
		String as[];
		if (b2chKeyword)
			as = (new String[] { "スレ一覧", "スレ一覧（新タブ）", "Webブラウザ", "リスト再取得", "キャンセル" });
		else
			as = (new String[] { "スレ一覧", "スレ一覧（新タブ）", "Webブラウザ", "URLコピー", "キャンセル" });
		int i = V2CSwingUtil.showDialogWithFocusRequest(jPanel, "Webスレッド検索",
				((javax.swing.JComponent) (b2chKeyword ? ((javax.swing.JComponent) (jlKeywords))
						: ((javax.swing.JComponent) (jtfSearchWord)))), as, 1);
		if (b2chKeyword && i == 3) {
			vThreadItem.show2chKeyword(true);
			return;
		}
		if (i < 0 || i > 3)
			return;
		V2CWebSearchEntry v2cwebsearchentry = (V2CWebSearchEntry) jcbEntry.getSelectedItem();
		wtseSelected = v2cwebsearchentry;
		vwtsLastEntry = v2cwebsearchentry;
		if (wtseSelected == null)
			return;
		String s;
		if (b2chKeyword) {
			Object obj = jlKeywords.getSelectedValue();
			s = obj == null ? "" : obj.toString();
		}
		else {
			s = jtfSearchWord.getText();
		}
		sLastSearchWord = s;
		V2CWebSearchItem v2cwebsearchitem = V2CWebSearchItem.createItem(v2cwebsearchentry, s);
		if (v2cwebsearchitem == null)
			return;

		V2CBoardItem v2cboarditemTop = V2CThreadListHistory.getTopBoardItem();
		V2CScriptApp.putProperty("WebThreadSerchMark", v2cboarditemTop.getURLString());

		V2CThreadList v2cthreadlist = V2CThreadList.getActivePanel();
		System.out.println(v2cthreadlist.getTitleString() + "=" + v2cthreadlist.getClass().getSimpleName());
		if (!(v2cthreadlist instanceof V2CBoardList)) {
			V2CSwingUtil
					.showErrorMessage("板のスレ一覧が選択されていません。");
			return;
		}else{
			if((v2cwebsearchitem.getSearchURL()).indexOf("&Bbs=#") != -1 ||
			   (v2cwebsearchitem.getSearchURL()).indexOf("&board=#") != -1)
			{
				Matcher gmatcher = gpattern.matcher(V2CScriptApp.getProperty("WebThreadSerchMark").toString());
				if(!gmatcher.find()){
					V2CSwingUtil
					.showErrorMessage("板のスレ一覧が選択されていません。");
					return;
				}
			}
		}

		if (i == 0 || i == 1)
//			V2CWebSearchList.openWebSearchList(v2cwebsearchitem, i == 1);
		{
			String s1 = v2cwebsearchitem.getSearchURL();
			V2CAbstractThreadPanel v2cabstractthreadpanel = null;
			s1 = editSearchUrl(s1, v2cabstractthreadpanel);
			if (s1 == isNot2chBBSLabel){
				return;
			}
			V2CWebSearchList.openWebSearchList(v2cwebsearchitem, i == 1);
			
		}
		else if (i == 2)
//			V2CMiscUtil.openLinkWithWebBrowser(v2cwebsearchitem.getSearchURL());
		{
			String s1 = v2cwebsearchitem.getSearchURL();
			V2CAbstractThreadPanel v2cabstractthreadpanel = null;
			s1 = editSearchUrl(s1, v2cabstractthreadpanel);
			if (s1 == isNot2chBBSLabel){
				return;
			}
			V2CMiscUtil.openLinkWithWebBrowser(s1);
		}
		else if (i == 3)
//			V2CMain.copyString(v2cwebsearchitem.getSearchURL());
		{
			String s1 = v2cwebsearchitem.getSearchURL();
			V2CAbstractThreadPanel v2cabstractthreadpanel = null;
			s1 = editSearchUrl(s1, v2cabstractthreadpanel);
			if (s1 == isNot2chBBSLabel){
				return;
			}
			V2CMain.copyString(s1);
		}
	}
*/
	void showDialog()
	{
		showDialog(null);
	}
	// V2CMOD-twZ by MCZ, Date:2017/06/06, Googleサイト検索強化
	void showDialog(V2CPanel v2cpanel)
	{
		v2cpanelAction = v2cpanel;
		String as[];
		if (b2chKeyword)
			as = (new String[] { "スレ一覧", "スレ一覧（新タブ）", "Webブラウザ", "リスト再取得", "キャンセル" });
		else
			as = (new String[] { "スレ一覧", "スレ一覧（新タブ）", "Webブラウザ", "URLコピー", "キャンセル" });
		int i = V2CSwingUtil.showDialogWithFocusRequest(jPanel, "Webスレッド検索",
				((javax.swing.JComponent) (b2chKeyword ? ((javax.swing.JComponent) (jlKeywords))
						: ((javax.swing.JComponent) (jtfSearchWord)))), as, 1);
		if (b2chKeyword && i == 3) {
			vThreadItem.show2chKeyword(true);
			return;
		}
		if (i < 0 || i > 3)
			return;
		V2CWebSearchEntry v2cwebsearchentry = (V2CWebSearchEntry) jcbEntry.getSelectedItem();
		wtseSelected = v2cwebsearchentry;
		vwtsLastEntry = v2cwebsearchentry;
		if (wtseSelected == null)
			return;
		String s;
		if (b2chKeyword) {
			Object obj = jlKeywords.getSelectedValue();
			s = obj == null ? "" : obj.toString();
		}
		else {
			s = jtfSearchWord.getText();
		}
		sLastSearchWord = s;
		V2CWebSearchItem v2cwebsearchitem = V2CWebSearchItem.createItem(v2cwebsearchentry, s);
		if (v2cwebsearchitem == null)
			return;

		V2CBoardItem v2cboarditemTop = V2CThreadListHistory.getTopBoardItem();
		V2CScriptApp.putProperty("WebThreadSerchMark", v2cboarditemTop.getURLString());

		if(v2cpanel == null){
			if( (v2cwebsearchitem.getSearchURL()).indexOf("&Bbs=#")   != -1 ||	// dig.5ch.net
			   ((v2cwebsearchitem.getSearchURL()).indexOf(".google.") != -1 && (v2cwebsearchitem.getSearchURL()).indexOf("site:") != -1 && (v2cwebsearchitem.getSearchURL()).indexOf("&board=all") == -1) ||	// www.google.co.jp
			    (v2cwebsearchitem.getSearchURL()).indexOf("&board=#") != -1)	// www.logsoku.com
			{
				V2CThreadList v2cthreadlist = V2CThreadList.getActivePanel();
				if (!(v2cthreadlist instanceof V2CBoardList)) {
					V2CSwingUtil
					.showErrorMessage("板のスレ一覧が選択されていません。");
					System.out.println("V2CWebThreadSearchPanel Error 001 unKown");
					return;
				}else{
					Matcher gmatcher = gpattern.matcher(V2CScriptApp.getProperty("WebThreadSerchMark").toString());
					if(!gmatcher.find()){
						V2CSwingUtil
						.showErrorMessage("板のスレ一覧が選択されていません。");
						System.out.println("V2CWebThreadSearchPanel Error 002 url=" + V2CScriptApp.getProperty("WebThreadSerchMark").toString());
						return;
					}
				}
			}
		}else{
			if( (v2cwebsearchitem.getSearchURL()).indexOf("&Bbs=#")   != -1 ||	// dig.5ch.net
			   ((v2cwebsearchitem.getSearchURL()).indexOf(".google.") != -1 && (v2cwebsearchitem.getSearchURL()).indexOf("site:") != -1 && (v2cwebsearchitem.getSearchURL()).indexOf("&board=all") == -1) ||	// www.google.co.jp
			    (v2cwebsearchitem.getSearchURL()).indexOf("&board=#") != -1)	// www.logsoku.com
			{
				V2CAbstractThreadPanel v2cabstractthreadpanel = ((V2CAbstractThreadPanel) v2cpanel);
				Matcher gmatcher = gpattern.matcher(v2cabstractthreadpanel.getThreadItem().getBoardURLString());
				if(!gmatcher.find()){
					V2CSwingUtil
					.showErrorMessage("板のスレ一覧が選択されていません。");
					System.out.println("V2CWebThreadSearchPanel Error 003 url=" + v2cabstractthreadpanel.getThreadItem().getBoardURLString());
					return;
				}
			}
		}

		if (i == 0 || i == 1)
//			V2CWebSearchList.openWebSearchList(v2cwebsearchitem, i == 1, v2cpanel);
		{
			String s1 = v2cwebsearchitem.getSearchURL();
			V2CAbstractThreadPanel v2cabstractthreadpanel = ((V2CAbstractThreadPanel) v2cpanel);
			s1 = editSearchUrl(s1, v2cabstractthreadpanel);
			if (s1 == isNot2chBBSLabel){
				return;
			}
			V2CWebSearchList.openWebSearchList(v2cwebsearchitem, i == 1, v2cpanel);
			
		}
		else if (i == 2)
//			V2CMiscUtil.openLinkWithWebBrowser(v2cwebsearchitem.getSearchURL());
		{
			String s1 = v2cwebsearchitem.getSearchURL();
			V2CAbstractThreadPanel v2cabstractthreadpanel = ((V2CAbstractThreadPanel) v2cpanel);
			s1 = editSearchUrl(s1, v2cabstractthreadpanel);
			if (s1 == isNot2chBBSLabel){
				return;
			}
			V2CMiscUtil.openLinkWithWebBrowser(s1);
		}
		else if (i == 3)
//			V2CMain.copyString(v2cwebsearchitem.getSearchURL());
		{
			String s1 = v2cwebsearchitem.getSearchURL();
			V2CAbstractThreadPanel v2cabstractthreadpanel = ((V2CAbstractThreadPanel) v2cpanel);
			s1 = editSearchUrl(s1, v2cabstractthreadpanel);
			if (s1 == isNot2chBBSLabel){
				return;
			}
			V2CMain.copyString(s1);
		}
	}

	public static String editSearchUrl(String s, V2CAbstractThreadPanel v2cabstractthreadpanel){
		String s1 = s;
		boolean edit = (v2cabstractthreadpanel != null || V2CScriptApp.getProperty("WebThreadSerchMark") != null);
		if(!edit) s1 = isNot2chBBSLabel;
		if(edit && s1.indexOf("://www.google.co.jp/") != -1 && 
			(s1.indexOf("+site:.2ch.net") != -1 || s1.indexOf("+site:.5ch.net") != -1 || s1.indexOf("+site:.bbspink.com") != -1 ||
			 s1.indexOf("+site:.shitaraba.com") != -1 || s1.indexOf("+site:.shitaraba.net") != -1 || s1.indexOf("+site:.machi.to") != -1)){
			s1 = editSearchUrlGoogleSite(s1, v2cabstractthreadpanel);
			V2CMain.setMessage("google search "+ s1);
		}
		if(!edit && s1.indexOf("://www.google.co.jp/") != -1 && 
			(s1.indexOf("+site:.2ch.net") != -1 || s1.indexOf("+site:.5ch.net") != -1 || s1.indexOf("+site:.bbspink.com") != -1 ||
			 s1.indexOf("+site:.shitaraba.com") != -1 || s1.indexOf("+site:.shitaraba.net") != -1 || s1.indexOf("+site:.machi.to") != -1)){
			s1 = isNot2chBBSLabel;
		}

		if(edit && s1.indexOf("://dig.5ch.net/") != -1 && s1.indexOf("&Bbs=#") != -1){
			if(isNot2chBBS(v2cabstractthreadpanel)){
				s1 = isNot2chBBSLabel;
			}else{
				s1 = editSearchUrlDig5chNet(s1, v2cabstractthreadpanel);
				V2CMain.setMessage("dig.5ch.net "+ s1);
			}
		}
		if(!edit && s1.indexOf("://dig.5ch.net/") != -1 && s1.indexOf("&Bbs=#") != -1){
			s1 = isNot2chBBSLabel;
		}

		if(edit && s1.indexOf("://www.logsoku.com/") != -1 && s1.indexOf("&site=#") != -1 && s1.indexOf("&board=#") != -1){
			if(isNot2chBBS(v2cabstractthreadpanel)){
				s1 = isNot2chBBSLabel;
			}else{
				s1 = editSearchUrlLogsoku(s1, v2cabstractthreadpanel);
				V2CMain.setMessage("www.logsoku.com "+ s1);
			}
		}
		if(!edit && s1.indexOf("://www.logsoku.com/") != -1 && s1.indexOf("&site=#") != -1 && s1.indexOf("&board=#") != -1){
			s1 = isNot2chBBSLabel;
		}

		if(s1 == isNot2chBBSLabel){
			V2CSwingUtil
			.showErrorMessage("板のスレ一覧が選択されていません。");
			System.out.println("V2CWebThreadSearchPanel Error 004 " + isNot2chBBSLabel);
		}
		return s1;
	}

	private static boolean isNot2chBBS(V2CAbstractThreadPanel v2cabstractthreadpanel){
		if(v2cabstractthreadpanel == null){
			Matcher gmatcher = gpattern.matcher(V2CScriptApp.getProperty("WebThreadSerchMark").toString());
//			System.out.println("V2CScriptApp.getProperty(\"WebThreadSerchMark\").toString()="+V2CScriptApp.getProperty("WebThreadSerchMark").toString());
			if(gmatcher.find()){
				return false;
			}
		}else{
			Matcher gmatcher = gpattern.matcher(v2cabstractthreadpanel.getThreadItem().getBoardURLString());
			if(gmatcher.find()){
				return false;
			}
		}
		return true;
	}

	public static String editSearchUrlGoogleSite(String s, V2CAbstractThreadPanel V2Cabstractthreadpanel){
		String s1 = s;
		String BoardURLString = (V2Cabstractthreadpanel!=null
				?V2Cabstractthreadpanel.getThreadItem().getBoardURLString()
				:V2CScriptApp.getProperty("WebThreadSerchMark").toString()
		);
		Pattern gpattern = Pattern.compile("https?://[^\\.]+(\\.[^/]+)/([^/]+)/?([^/]+)?/?");
		Matcher gmatcher = gpattern.matcher(""+BoardURLString);
//		System.out.println("BoardURLString="+BoardURLString);
		if(gmatcher.find() && s1.indexOf("&board=all") == -1){
//			System.out.println("gmatcher.group(1)="+gmatcher.group(1));
//			System.out.println("gmatcher.group(2)="+gmatcher.group(2));
//			System.out.println("gmatcher.group(3)="+gmatcher.group(3));
			if(gmatcher.group(1).equals(".2ch.net") || gmatcher.group(1).equals(".5ch.net")){
//				s1 = s1.replace("site:.2ch.net%20OR%20site:.5ch.net", "site:" + gmatcher.group(1) + "/test/read.cgi/" + gmatcher.group(2) + "/");
//				s1 = s1.replace("site:.5ch.net%20OR%20site:.2ch.net", "site:" + gmatcher.group(1) + "/test/read.cgi/" + gmatcher.group(2) + "/");
				s1 = s1.replace(".2ch.net", ".2ch.net/test/read.cgi/" + gmatcher.group(2) + "/");
				s1 = s1.replace(".5ch.net", ".5ch.net/test/read.cgi/" + gmatcher.group(2) + "/");
			}
			if(gmatcher.group(1).equals(".shitaraba.com") || gmatcher.group(1).equals(".shitaraba.net")){
				s1 = s1.replace(".2ch.net%20OR%20site:.5ch.net", "jbbs.shitaraba.net/bbs/read.cgi/" + gmatcher.group(2) + "/" + gmatcher.group(3) + "/");
				s1 = s1.replace(".5ch.net%20OR%20site:.2ch.net", "jbbs.shitaraba.net/bbs/read.cgi/" + gmatcher.group(2) + "/" + gmatcher.group(3) + "/");
				s1 = s1.replace(".2ch.net", "jbbs.shitaraba.net/bbs/read.cgi/" + gmatcher.group(2) + "/" + gmatcher.group(3) + "/");
				s1 = s1.replace(".5ch.net", "jbbs.shitaraba.net/bbs/read.cgi/" + gmatcher.group(2) + "/" + gmatcher.group(3) + "/");
			}
			if(gmatcher.group(1).equals(".machi.to")){
				s1 = s1.replace(".2ch.net%20OR%20site:.5ch.net", ".machi.to/bbs/read.cgi/" + gmatcher.group(2) + "/");
				s1 = s1.replace(".5ch.net%20OR%20site:.2ch.net", ".machi.to/bbs/read.cgi/" + gmatcher.group(2) + "/");
				s1 = s1.replace(".2ch.net", ".machi.to/bbs/read.cgi/" + gmatcher.group(2) + "/");
				s1 = s1.replace(".5ch.net", ".machi.to/bbs/read.cgi/" + gmatcher.group(2) + "/");
			}
			if(gmatcher.group(1).equals(".bbspink.com")){
				s1 = s1.replace(".2ch.net%20OR%20site:.5ch.net", ".bbspink.com/test/read.cgi/" + gmatcher.group(2) + "/");
				s1 = s1.replace(".5ch.net%20OR%20site:.2ch.net", ".bbspink.com/test/read.cgi/" + gmatcher.group(2) + "/");
				s1 = s1.replace(".2ch.net", ".bbspink.com/test/read.cgi/" + gmatcher.group(2) + "/");
				s1 = s1.replace(".5ch.net", ".bbspink.com/test/read.cgi/" + gmatcher.group(2) + "/");
			}
		}
		else if(gmatcher.find() && s1.indexOf("&board=all") != -1){
			if(gmatcher.group(1).equals(".shitaraba.com") || gmatcher.group(1).equals(".shitaraba.net")){
				s1 = s1.replace(".2ch.net%20OR%20site:.5ch.net", "jbbs.shitaraba.net");
				s1 = s1.replace(".5ch.net%20OR%20site:.2ch.net", "jbbs.shitaraba.net");
				s1 = s1.replace(".2ch.net", "jbbs.shitaraba.net");
				s1 = s1.replace(".5ch.net", "jbbs.shitaraba.net");
				if(gmatcher.group(1).equals(".shitaraba.com")){
					s1 = s1.replace("jbbs.shitaraba.com", "jbbs.shitaraba.net");
				}
			}
			if(gmatcher.group(1).equals(".machi.to")){
				s1 = s1.replace(".2ch.net%20OR%20site:.5ch.net", ".machi.to");
				s1 = s1.replace(".5ch.net%20OR%20site:.2ch.net", ".machi.to");
				s1 = s1.replace(".2ch.net", ".machi.to");
				s1 = s1.replace(".5ch.net", ".machi.to");
			}
			if(gmatcher.group(1).equals(".bbspink.com")){
				s1 = s1.replace(".2ch.net%20OR%20site:.5ch.net", ".bbspink.com");
				s1 = s1.replace(".5ch.net%20OR%20site:.2ch.net", ".bbspink.com");
				s1 = s1.replace(".2ch.net", ".bbspink.com");
				s1 = s1.replace(".5ch.net", ".bbspink.com");
			}
		}
		return s1;
	}

	public static String editSearchUrlDig5chNet(String s, V2CAbstractThreadPanel V2Cabstractthreadpanel){
		String s1 = s;
		String BoardURLString = (V2Cabstractthreadpanel!=null
				?V2Cabstractthreadpanel.getThreadItem().getBoardURLString()
				:V2CScriptApp.getProperty("WebThreadSerchMark").toString()
		);
		Pattern gpattern = Pattern.compile("https?://[^\\.]+(\\.[^/]+)/([^/]+)/?([^/]+)?/?");
		Matcher gmatcher = gpattern.matcher(""+BoardURLString);
		if(gmatcher.find()){
			s1 = s1.replace("&Bbs=#", "&Bbs=" + gmatcher.group(2));
		}
		return s1;
	}

	public static String editSearchUrlLogsoku(String s, V2CAbstractThreadPanel V2Cabstractthreadpanel){
		String s1 = s;
		String BoardURLString = (V2Cabstractthreadpanel!=null
				?V2Cabstractthreadpanel.getThreadItem().getBoardURLString()
				:V2CScriptApp.getProperty("WebThreadSerchMark").toString()
		);
		Pattern gpattern = Pattern.compile("https?://[^\\.]+\\.([^/]+)/([^/]+)/?([^/]+)?/?");
		Matcher gmatcher = gpattern.matcher(""+BoardURLString);
		if(gmatcher.find()){
			s1 = s1.replace("&site=#", "&site=" + gmatcher.group(1)).replace("&board=#", "&board=" + gmatcher.group(2));
		}
		return s1;
	}
	// ---- END of V2CMOD-twZ ----

	public void actionPerformed(ActionEvent actionevent)
	{
		Object obj = actionevent.getSource();
		if (obj == jcbEntry) {
			V2CWebSearchEntry v2cwebsearchentry = (V2CWebSearchEntry) jcbEntry.getSelectedItem();
			boolean flag = v2cwebsearchentry.needsSearchWord();
			if (b2chKeyword)
				jlKeywords.setEnabled(flag);
			else
				jtfSearchWord.setEnabled(flag);

			if( v2cwebsearchentry.sURL.indexOf("&Bbs=#")   != -1 ||	// dig.5ch.net
			   (v2cwebsearchentry.sURL.indexOf(".google.") != -1 && v2cwebsearchentry.sURL.indexOf("site:") != -1) ||	// www.google.co.jp
			    v2cwebsearchentry.sURL.indexOf("&board=#") != -1)	// www.logsoku.com
			{
				V2CAbstractThreadPanel V2Cabstractthreadpanel = (V2CAbstractThreadPanel) v2cpanelAction;
				V2CBoardItem v2cboarditemTop = V2CThreadListHistory.getTopBoardItem();
				String BoardURLString = (V2Cabstractthreadpanel!=null
						?V2Cabstractthreadpanel.getThreadItem().getBoardURLString()
						:v2cboarditemTop.getURLString()
				);
				if(BoardURLString != "" && v2cwebsearchentry.sURL.indexOf("://dig.") != -1){// dig.5ch.net
					if(BoardURLString.indexOf(".open2ch.net") != -1 || BoardURLString.indexOf(".2ch.sc") != -1 || BoardURLString.indexOf(".5ch.sc") != -1){
						BoardTitle.setVisible(false);
					}else{
						BoardTitle.setVisible(true);
					}
				}else if(v2cwebsearchentry.sURL.indexOf(".google.") != -1 && v2cwebsearchentry.sURL.indexOf("site:") != -1){	// www.google.co.jp){
					if(v2cwebsearchentry.sURL.indexOf("&board=all") != -1){
						BoardTitle.setVisible(false);
					}else{
						BoardTitle.setVisible(true);
					}
				}else{
					BoardTitle.setVisible(true);
				}
			}else{
				BoardTitle.setVisible(false);
			}
		}
	}

	String getSearchURL()
	{
		return sURL;
	}

	String getTitleString()
	{
		return sTitle;
	}

	private static V2CWebSearchEntry vwtsLastEntry;
	private static String sLastSearchWord;
	JPanel jPanel;
	final boolean b2chKeyword;
	JComboBox jcbEntry;
	JTextField jtfSearchWord;
	V2CThreadItem vThreadItem;
	JList jlKeywords;
	V2CWebSearchEntry wtseSelected;
	String sURL;
	String sTitle;
	
	static public String isNot2chBBSLabel = "isNot2chBBS";
	static Pattern gpattern = Pattern.compile("https?://[^\\.]+(\\.(?:open)?[25]ch\\.(?:net|sc)|\\.bbspink\\.com|\\.shitaraba\\.(?:net|com)|\\.machi\\.to)/([^/]+)/?([^/]+)?/?");
	static private JLabel BoardTitle;
	static private V2CPanel v2cpanelAction;

	private String getBoardTitle(V2CPanel v2cpanel){
		if(v2cpanel == null){
			V2CThreadList v2cthreadlist = V2CThreadList.getActivePanel();
			if (v2cthreadlist instanceof V2CBoardList) {
				if(V2CThreadList.getActivePanel().getPanelURLString() != null){
					Matcher gmatcher = gpattern.matcher(V2CThreadList.getActivePanel().getPanelURLString());
					if(gmatcher.find()){
						return V2CThreadList.getActivePanel().getTitleString();
					}
				}
			}
		}else{
			V2CAbstractThreadPanel v2cabstractthreadpanel = ((V2CAbstractThreadPanel) v2cpanel);
			if(v2cabstractthreadpanel.getThreadItem().getBoardURLString() != null){
				Matcher gmatcher = gpattern.matcher(v2cabstractthreadpanel.getThreadItem().getBoardURLString());
				if(gmatcher.find()){
					return v2cabstractthreadpanel.getThreadItem().getBoardName();
				}
			}
		}
		return "";
	}
}
