package org.monazilla.v2c;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.Icon;
import javax.swing.Timer;

public class V2CWebSearchList extends V2CThreadList implements ActionListener
{

	static void restoreURL2Num()
	{
		if (alNum2URL != null)
			return;
		ArrayList arraylist = new ArrayList(100);
		alNum2URL = arraylist;
		BufferedReader bufferedreader = V2CLocalFileHandler.getSaveFileReader(V2CLocalFileHandler
				.getWebSearchFile(sURL2NumFileName));
		if (bufferedreader == null)
			return;
		try {
			do {
				String s;
				if ((s = bufferedreader.readLine()) == null)
					break;
				if (s.length() != 0 && s.charAt(0) != '#') {
					int i = s.indexOf(',');
					if (i > 0 && s.indexOf(',', i + 1) < 0) {
						int j = V2CMiscUtil.parseInt(s, 0, i, -1);
						if (j >= 0) {
							String s1 = s.substring(i + 1);
							if (V2CURLItem.containsURL(s1)) {
								if (arraylist.size() <= j) {
									int k = 2 * (j + 1);
									for (int l = arraylist.size(); l < k; l++)
										arraylist.add(null);

								}
								if (arraylist.get(j) == null)
									arraylist.set(j, s1);
							}
						}
					}
				}
			} while (true);
		}
		catch (IOException ioexception) {
			ioexception.printStackTrace();
		}
		finally {
			V2CLocalFileHandler.closeReader(bufferedreader);
		}
	}

	static void saveURL2Num()
	{
		File file = V2CLocalFileHandler.getWebSearchFile(sURL2NumFileName);
		V2CSaveFile v2csavefile = new V2CSaveFile(file);
		BufferedWriter bufferedwriter = v2csavefile.getWriter();
		if (bufferedwriter == null)
			return;
		ArrayList arraylist = alNum2URL;
		HashSet hashset = new HashSet();
		try {
			int i = arraylist.size();
			for (int j = 0; j < i; j++) {
				String s = (String) arraylist.get(j);
				if (s != null && !hashset.contains(s)) {
					hashset.add(s);
					bufferedwriter.write(String.valueOf(j));
					bufferedwriter.write(44);
					bufferedwriter.write(s);
					bufferedwriter.newLine();
				}
			}

			v2csavefile.setOK();
		}
		catch (IOException ioexception) {
			ioexception.printStackTrace();
		}
		finally {
			V2CLocalFileHandler.closeWriter(bufferedwriter);
		}
		v2csavefile.replaceTmpFile();
	}

	static File getNumber(String s)
	{
		restoreURL2Num();
		int i = -1;
		ArrayList arraylist = alNum2URL;
		int j = arraylist.size();
		int k = 0;
		do {
			if (k >= j)
				break;
			Object obj = arraylist.get(k);
			if (obj != null) {
				if (s.equals(obj)) {
					i = k;
					break;
				}
			}
			else {
				arraylist.set(k, s);
				i = k;
				break;
			}
			k++;
		} while (true);
		boolean flag = i >= 0;
		if (!flag) {
			i = j;
			int l = 2 * (j + 1);
			for (int i1 = j; i1 < l; i1++)
				arraylist.add(null);

			arraylist.set(j, s);
		}
		saveURL2Num();
		File file = V2CLocalFileHandler.getThreadCacheFile(i);
		if (!flag)
			file.delete();
		return file;
	}

	static boolean isAutoChecking(V2CWebSearchItem v2cwebsearchitem)
	{
		V2CThreadList v2cthreadlist;
		synchronized (hmThreadList) {
			v2cthreadlist = getThreadList(v2cwebsearchitem);
		}
		return (v2cthreadlist instanceof V2CWebSearchList) && ((V2CWebSearchList) v2cthreadlist).isAutoChecking();
	}

	static void stopAutoChecking(V2CWebSearchItem v2cwebsearchitem)
	{
		V2CThreadList v2cthreadlist;
		synchronized (hmThreadList) {
			v2cthreadlist = getThreadList(v2cwebsearchitem);
		}
		if (v2cthreadlist instanceof V2CWebSearchList)
			((V2CWebSearchList) v2cthreadlist).stopAutoCheck();
	}

	static void openWebSearchList(String s, boolean flag)
	{
		int i = s.indexOf('\t');
		int j = 0;
		long l = 0L;
		String s1;
		if (i >= 0) {
			s1 = s.substring(0, i);
			if (i + 1 < s.length() && s.charAt(i + 1) == 'I') {
				int k = s.indexOf('\t', i + 1);
				if (k > 0) {
					j = V2CMiscUtil.parseInt(s, i + 2, k, 0);
					if (k + 1 < s.length() && s.charAt(k + 1) == 'T') {
						int i1 = s.indexOf('\t', k + 1);
						if (i1 > 0)
							l = V2CMiscUtil.parseInt(s, k + 2, i1, 0);
						else
							l = V2CMiscUtil.parseInt(s, k + 2, s.length(), 0);
					}
				}
				else {
					j = V2CMiscUtil.parseInt(s, i + 2, s.length(), 0);
				}
			}
		}
		else {
			s1 = s;
		}
		if (s1 == null || s1.length() == 0)
			return;
		V2CURLItem v2curlitem = V2CToolBarButtonPanel.getURLButton(s1);
		if (v2curlitem != null && v2curlitem.getOpenAction() == 2)
			openWebSearchList(new V2CWebSearchItem(v2curlitem, true), false, true, j, l, flag);
	}

	static void openWebSearchList(V2CWebSearchItem v2cwebsearchitem)
	{
		openWebSearchList(v2cwebsearchitem, false, true, 0, 0L, false);
	}

	static void openWebSearchList(V2CWebSearchItem v2cwebsearchitem, boolean flag)
	{
		openWebSearchList(v2cwebsearchitem, true, flag, 0, 0L, false);
	}

	// V2CMOD-twZ by MCZ, Date:2017/06/06, Googleサイト検索強化
	static void openWebSearchList(V2CWebSearchItem v2cwebsearchitem, boolean flag, V2CPanel v2cpanel)
	{
		pv2cpanel = v2cpanel;
		openWebSearchList(v2cwebsearchitem, true, flag, 0, 0L, false);
	}
	// ---- END of V2CMOD-twZ ----

	static void openWebSearchList(V2CWebSearchItem v2cwebsearchitem, boolean flag, int i)
	{
		openWebSearchList(v2cwebsearchitem, true, flag, i, 0L, false);
	}

	private static void openWebSearchList(V2CWebSearchItem v2cwebsearchitem, boolean flag, boolean flag1, int i, long l,
			boolean flag2)
	{
		V2CWebSearchList v2cwebsearchlist;
		synchronized (hmThreadList) {
			V2CThreadList v2cthreadlist = getThreadList(v2cwebsearchitem);
			if (v2cthreadlist instanceof V2CWebSearchList) {
				v2cwebsearchlist = (V2CWebSearchList) v2cthreadlist;
				if (i > 0)
					v2cwebsearchlist.setAutoCheckInterval(i);
				else
					v2cwebsearchlist.bSearchDone = false;
			}
			else {
				v2cwebsearchlist = new V2CWebSearchList(v2cwebsearchitem, i, l);
				putThreadList(v2cwebsearchitem, v2cwebsearchlist);
			}
		}
		if (flag2)
			v2cwebsearchlist.setLocked(true);
		v2cwebsearchlist.openThreadList(v2cwebsearchitem.getTitleString(), v2cwebsearchitem.getIcon(), flag, flag1);
	}

	private V2CWebSearchList(V2CWebSearchItem v2cwebsearchitem, int i, long l)
	{
		vWebSearchItem = v2cwebsearchitem;
		boolean flag = v2cwebsearchitem.isURLButton();
		bURLButton = flag;
		if (v2cwebsearchitem.getSaveHistory())
			fLocalCache = getNumber(vWebSearchItem.getSearchURL());
		else
			fLocalCache = null;
		sMessageHeader = "Web検索[" + v2cwebsearchitem.getTitleString() + "]: ";
		ltLastCheckTime = l * 1000L;
		if (flag)
			setAutoCheckInterval(i);
	}

	public String getSaveTabString()
	{
		if (!bURLButton)
			return null;
		String s = vWebSearchItem.getSearchURL();
		if (nRepeatInterval > 0) {
			StringBuffer stringbuffer = new StringBuffer();
			stringbuffer.append(s);
			stringbuffer.append("\tI");
			stringbuffer.append(nRepeatInterval);
			if (ltLastCheckTime > 0L) {
				stringbuffer.append("\tT");
				stringbuffer.append(ltLastCheckTime / 1000L);
			}
			s = stringbuffer.toString();
		}
		return createSaveTabString('U', s);
	}

	public void detouch()
	{
		if (bURLButton)
			stopAutoCheck();
		super.detouch();
	}

	public Icon getIcon()
	{
		return vWebSearchItem.getIcon();
	}

	public Icon getDefaultIcon()
	{
		return vWebSearchItem.getIcon();
	}

	public String getTitleString()
	{
		return vWebSearchItem.getTitleString();
	}

	public boolean canLock()
	{
		return bURLButton;
	}

	V2CThreadListDefaultSort getDefaultSort()
	{
		return vThreadListDefaultSort;
	}

	Object getItem()
	{
		return vWebSearchItem;
	}

	void listAllThread()
	{
	}

	boolean isAutoChecking()
	{
		return bURLButton && nRepeatInterval > 0;
	}

	void setAutoCheckInterval(int i)
	{
		if (!bURLButton)
			return;
		nTotalCount = 0;
		nErrorCount = 0;
		if (i > 0) {
			nRepeatInterval = Math.max(i, MINREPEATINTERVAL);
			hsNewThread = null;
			bSearchDone = false;
			repaint();
		}
		else {
			stopAutoCheck();
		}
	}

	void startAutoCheck(boolean flag)
	{
		int i = nRepeatInterval * 60000;
		if (i <= 0) {
			stopAutoCheck();
			return;
		}
		if (hsNewThread != null) {
			stopAutoCheck();
			return;
		}
		if (flag)
			nErrorCount = 0;
		else
			nErrorCount++;
		if (nTotalCount >= MAXCHECKCOUNT || nErrorCount >= MAXERRORCOUNT) {
			stopAutoCheck();
			return;
		}
		Timer timer = tWebSearchTimer;
		if (timer == null) {
			timer = new Timer(i, this);
			timer.setRepeats(false);
			tWebSearchTimer = timer;
		}
		timer.setInitialDelay(i - V2CMiscUtil.restrictRange(0, (int) (System.currentTimeMillis() - ltLastCheckTime), i));
		timer.start();
	}

	void stopAutoCheck()
	{
		Timer timer = tWebSearchTimer;
		if (timer != null) {
			tWebSearchTimer = null;
			timer.stop();
		}
		nRepeatInterval = 0;
		ltLastCheckTime = 0L;
		notifyCurrentState();
	}

	void notifyCurrentState()
	{
		V2CToolBarButtonPanel.webSearchStateChanged(vWebSearchItem.getSearchURL(), hsNewThread != null, nRepeatInterval > 0);
	}

	public void actionPerformed(ActionEvent actionevent)
	{
		if (actionevent.getSource() == tWebSearchTimer) {
			bSearchDone = false;
			nTotalCount++;
			checkList(true);
		}
	}

	boolean displayList(boolean flag)
	{
		if (flag)
			flag = V2CMain.isOnlineMode();
		boolean flag1 = bSearchDone;
		boolean flag2 = displayList0(flag);
		if (!flag1 && bURLButton) {
			startAutoCheck(flag2);
			notifyCurrentState();
		}
		return flag2;
	}

	private boolean displayList0(boolean flag)
	{
		ArrayList arraylist = restorePrevResult();
		ArrayList arraylist1 = null;
		boolean flag1 = bSearchDone;
		if (!flag1)
			if (flag) {
				arraylist1 = getAndParse(arraylist);
				if (arraylist1 == null)
					return false;
			}
			else {
				arraylist1 = new ArrayList();
				bSearchDone = true;
				if (arraylist != null) {
					for (int i = 0; i < arraylist.size(); i++)
						arraylist1.add(((Object) (createThreadListRowArray((V2CThreadItem) arraylist.get(i)))));

				}
			}
		setNewThreadList(arraylist1, true, true);
		if (flag1 && flag)
			if (bRounding) {
				doRound();
			}
			else {
				checkUpdate();
				setNewThreadList(arraylist1, true, false);
			}
		return true;
	}

	ArrayList getAndParse(ArrayList arraylist)
	{
		String s = vWebSearchItem.getSearchURL();
		String Pager = null;
		String PageIdentifier = null;
		String[] arr = s.split("=\\(");
		if(arr.length == 2){
			s = ((String) arr[0]) + "=";
			PageIdentifier = "(" + arr[1];
			Pattern maPager = Pattern.compile(".*(&[^=]+=$)");
    		Matcher matcher = maPager.matcher(s);
			if (matcher.matches()) {
				Pager = matcher.group(1);
				s = s.replaceAll(Pager + "$", "");
			}
		}
//		if (s.startsWith("http://find.2ch.net/") && !V2C2chBBS.isMoritapoLoggedIn() && s.indexOf("&COUNT=") < 0)
//			s = s + "&COUNT=50";

		// V2CMOD-twZ by MCZ, Date:2017/06/06, Googleサイト検索強化
		if (pv2cpanel instanceof V2CThreadPanel || V2CScriptApp.getProperty("WebThreadSerchMark") != null){
			V2CAbstractThreadPanel v2cabstractthreadpanel = ((V2CAbstractThreadPanel) pv2cpanel);
			s = V2CWebThreadSearchPanel.editSearchUrl(s, v2cabstractthreadpanel);
			if (s == V2CWebThreadSearchPanel.isNot2chBBSLabel){
				return null;
			}
		}
		// ---- END of V2CMOD-twZ ----

		long refind2chSleep = 3000L;
		int refind2chMaxPage = 5;
		if(s.indexOf("://refind2ch.org/") != -1){
			Pattern pattern = Pattern.compile("&sleep=(\\d+)");
			Matcher matcher = pattern.matcher(s);
			if(matcher.find()){
				long w = Long.parseLong(matcher.group(1));
				if(w >= 2L){
					refind2chSleep = w * 1000L;
				}
				s = s.replaceAll("&sleep=\\d+", "");
			}
			pattern = Pattern.compile("&maxpage=(\\d+)");
			matcher = pattern.matcher(s);
			if(matcher.find()){
				refind2chMaxPage = Integer.parseInt(matcher.group(1));
				s = s.replaceAll("&maxpage=\\d+", "");
			}
			matcher = null;
			pattern = null;
		}

		URL url = null;
		try {
			url = new URL(s);
		}
		catch (MalformedURLException malformedurlexception) {
			V2CMain.setErrorMessage(sMessageHeader + malformedurlexception.getMessage());
			return null;
		}
		String s1 = null;
		String s2 = null;
		if(V2CApp.javaVersionEqualTo(1, 6)){
			V2CScriptApp.putProperty("B11_Use_JavaVersion", 6);
		}else if(V2CApp.javaVersionEqualTo(1, 5)){
			V2CScriptApp.putProperty("B11_Use_JavaVersion", 6);
		}else{
			V2CScriptApp.putProperty("B11_Use_JavaVersion", 7);
		}
		// V2CMOD-twZ by MCZ, Date:2017/06/06, Googleサイト検索強化
//		V2CHttpUtil.CAndC candc = V2CHttpUtil.getRawHTTPFile(s, "text/html", 0L, 2);
		V2CHttpUtil.CAndC candc = null;
		if(s.indexOf("://www.google.co.jp/") != -1 && (s.indexOf("+site:.2ch.net") != -1 || s.indexOf("+site:.5ch.net") != -1)){
			HashMap hm = new HashMap();
			hm.put("Cookie", "");
			candc = V2CHttpUtil.getRawHTTPFile(s, null, "text/html", 0L, null, 2, hm);
		}else if(s.indexOf("://refind2ch.org/") != -1){
			HashMap hm = new HashMap();
			hm.put("User-Agent", V2CHttpUtil.UAPostCGI);
			candc = V2CHttpUtil.getRawHTTPFile(s, null, "text/html", 0L, null, 2, hm);
		}else{
			candc = V2CHttpUtil.getRawHTTPFile(s, "text/html", 0L, 2);
		}
		// ---- END of V2CMOD-twZ ----
		if (Thread.currentThread().isInterrupted()) {
			return null;
		}
		if (candc == null) {
			return null;
		}
		// V2CMOD-twZ by MCZ, Date:2017/06/06, Googleサイト検索強化
		if(s.indexOf("://www.google.co.jp/") != -1 && (s.indexOf("+site:.2ch.net") != -1 || s.indexOf("+site:.5ch.net") != -1) && candc.getResponseCode() == 0){
			V2CSwingUtil.showErrorMessage(sMessageHeader + "\n検索回数過多でGoogleにロボット認定された可能性があります\nV2Cで継続して検索するにはIPアドレスを変更して下さい");
			return null;
		}
		// ---- END of V2CMOD-twZ ----
		byte abyte0[] = candc.getRawContents();
		if (abyte0 == null || abyte0.length == 0) {
			V2CMain.setErrorMessage(sMessageHeader + candc.getErrorMessage());
			return null;
		}
		// 検索がスレ一覧に出ないのはgetCharsetFromCAndC で文字コード変換例外によるnullが原因
		s1 = V2CHttpUtil.getCharsetFromCAndC(candc);
		if (s1 == null) {
//			return null;
			s1 = "UTF-8";
		}
		if(s.indexOf("://www.google.co.jp/") != -1 && V2CHttpUtil.UseMS932OnWTSforGoogle){
			s1 = "MS932";
		}
		s2 = null;
		try {
			s2 = new String(abyte0, s1);
		}
		catch (UnsupportedEncodingException unsupportedencodingexception) {
		}
		if (s2 == null) {
			return null;
		}
		String s3 = url.getHost();
		// V2CMOD-twZ by MCZ, Date:2017/06/06, Googleサイト検索強化
		if (s3.equals("www.google.co.jp")) {
			Pattern gpattern = Pattern.compile(".*?num=(\\d{1,3}).*");
			Matcher gmatcher = gpattern.matcher(s);
			int num = 50;
			if(gmatcher.find()){
				num = Integer.parseInt(gmatcher.group(1));
			}
			if(num > 100){
				num = 100;
			}
			String surfix = "";
//			gpattern = Pattern.compile(".+&amp;ei=([^&]+)&amp;", 2);
//			gmatcher = gpattern.matcher(s2);
//			if(gmatcher.find()){
//				surfix = "&ei=" + gmatcher.group(1) + "&sa=N";
//			}
//			Integer LongGoogleSiteSearchPageNum = Integer.parseInt(V2CGetUsrProps_Tw.Get("LongGoogleSiteSearchPageNum"));
			Integer LongGoogleSiteSearchPageNum = 1;
			for(int i=1; i<LongGoogleSiteSearchPageNum; i++){
				try {
					Thread.sleep(1500);
				} catch (InterruptedException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				}
				String start = "&start=" + (i*num);
				V2CMain.setMessage("google search "+ s + start + surfix);
				V2CHttpUtil.CAndC gcandc = V2CHttpUtil.getRawHTTPFile(s + start + surfix, "text/html", 0L, 2);
				if (Thread.currentThread().isInterrupted()) {
					break;
				}
				if (gcandc == null) {
					break;
				}
				byte gabyte0[] = gcandc.getRawContents();
				if (gabyte0 == null || gabyte0.length == 0) {
					V2CMain.setErrorMessage(sMessageHeader + gcandc.getErrorMessage());
					gcandc = null;
					gabyte0 = null;
					break;
				}
				// 検索がスレ一覧に出ないのはgetCharsetFromCAndC で文字コード変換例外によるnullが原因
				String gs1 = V2CHttpUtil.getCharsetFromCAndC(gcandc);
				if (gs1 == null) {
//					return null;
					gs1 = "UTF-8";
				}
				if(V2CHttpUtil.UseMS932OnWTSforGoogle){
					gs1 = "MS932";
				}
				String gs2 = null;
				try {
					gs2 = new String(gabyte0, s1);
					if(gs2.indexOf("に一致する情報は見つかりませんでした。") != -1){
						s2 += "\n" + gs2;
						gcandc = null;
						gabyte0 = null;
						gs1 = null;
						gs2 = null;
						break;
					}
				}
				catch (UnsupportedEncodingException unsupportedencodingexception) {
				}
				if (gs2 == null) {
					gcandc = null;
					gabyte0 = null;
					gs1 = null;
					gs2 = null;
					break;
				}
				s2 += "\n" + gs2;
				gcandc = null;
				gabyte0 = null;
				gs1 = null;
				gs2 = null;
			}
		}
		if(s.indexOf(".machi.to") != -1){
			Matcher matcher = Pattern.compile(".+\\.machi\\.to/bbs/read.cgi/([^/]+)/?").matcher(s);
			if(matcher.find()){
				s2 = s2.replace("http://machi.to/", "http://" + matcher.group(1) + ".machi.to/");
			}
		}
		// ---- END of V2CMOD-twZ ----
		if (s3.equals("find.2ch.net") || s3.equals("find.5ch.net")) {
			Matcher matcher = Pattern.compile("<a href=\"([^\"]+)\">次へ</a>").matcher(s2);
			int i = 0;
			do {
				if (i >= 1 || !matcher.find())
					break;
				String s4 = matcher.group(1);
				URL url1 = null;
				try {
					url1 = new URL(url, s4);
				}
				catch (MalformedURLException malformedurlexception1) {
					break;
				}
				V2CHttpUtil.CAndC candc1 = V2CHttpUtil.getRawHTTPFile(url1.toExternalForm(), "text/html", 0L, 2);
				if (Thread.currentThread().isInterrupted()) {
					return null;
				}
				if (candc1 == null) {
					return null;
				}
				byte abyte1[] = candc1.getRawContents();
				if (abyte1 == null || abyte1.length == 0) {
					V2CMain.setErrorMessage(sMessageHeader + candc1.getErrorMessage());
					return null;
				}
				String s5 = null;
				try {
					s5 = new String(abyte1, s1);
				}
				catch (UnsupportedEncodingException unsupportedencodingexception1) {
				}
				if (s5 == null) {
					return null;
				}
				s2 = s2 + s5;
				matcher.reset(s5);
				i++;
			} while (true);
		}
		if (PageIdentifier != null) {
			System.out.println(PageIdentifier);
			PageIdentifier = PageIdentifier.replaceAll("^\\(", "").replaceAll("\\)$", "");
			int j = 0;
			int sta = 2;
			int end = 50;
			int inc = 1;
			if(PageIdentifier.length() != 0){
				String[] a = PageIdentifier.split(";");
				if(a.length == 3){
					if(a[0].length() != 0) sta = Integer.valueOf(a[0]);
					end = Integer.valueOf(a[1]);
					inc = Integer.valueOf(a[2]);
				}else
				if(a.length == 2){
					if(a[0].length() != 0) sta = Integer.valueOf(a[0]);
					end = Integer.valueOf(a[1]);
				}
				
			}
			for(int i=sta; i<=end; i+=inc){
				URL url1 = null;
				try {
					url1 = new URL(s + Pager + i);
				}
				catch (MalformedURLException malformedurlexception1) {
					break;
				}
				V2CHttpUtil.CAndC candc1 = V2CHttpUtil.getRawHTTPFile(url1.toExternalForm(), "text/html", 0L, 2);
				if (Thread.currentThread().isInterrupted()) {
					return null;
				}
				if (candc1 == null) {
					return null;
				}
				if(candc1.getResponseCode() == 404){
					break;
				}
				byte abyte1[] = candc1.getRawContents();
				if (abyte1 == null || abyte1.length == 0) {
					V2CMain.setErrorMessage(sMessageHeader + candc1.getErrorMessage());
					return null;
				}
				String s5 = null;
				try {
					s5 = new String(abyte1, s1);
				}
				catch (UnsupportedEncodingException unsupportedencodingexception1) {
				}
				if (s5 == null) {
					return null;
				}
				Matcher matcher = Pattern.compile("[Nn]ot +[Ff]ound").matcher(s5);
				if (matcher.find())
					break;
				s2 = s2 + s5;

				Matcher hasnextpage = null;
				if(s3.equals("eddiarchive.com")) hasnextpage = Pattern.compile("class=\"inactive\" name=\\d+>次へ").matcher(s5);
				if(s3.equals("ff5ch.syoboi.jp")) hasnextpage = Pattern.compile("&amp;page=\\d+\"?>次へ").matcher(s5);
				if(hasnextpage != null){
					if(!hasnextpage.find()){
						break;
					}
				}
			}
		}
		if (s3.equals("dig.2ch.net") || s3.equals("dig.5ch.net")) {
			String ss = s2.replaceAll("[\\n\\r]", "");
			s2 = "";
			Matcher matcher = Pattern.compile("<span id=\"title\"><a.+?>(.+?)\\(\\d{1,4}\\)</a>.+?<span class=\"motoT\">([^>]+)>").matcher(ss);
			do {
				if (!matcher.find())
					break;
				s2 += matcher.group(2) + ">" + matcher.group(1) + "</a>";
			} while (true);
		}
		if(s3.equals("www.logsoku.com")){
			// 2ページ目取得
			String p2_s = s + "&p=2";
			try {
				url = new URL(p2_s);
			}
			catch (MalformedURLException malformedurlexception) {
				V2CMain.setErrorMessage(sMessageHeader + malformedurlexception.getMessage());
				return null;
			}
			V2CHttpUtil.CAndC p2_candc = null;
			byte p2_abyte0[] = null;
			String p2_s1 = "";
			p2_candc = V2CHttpUtil.getRawHTTPFile(p2_s, "text/html", 0L, 2);
			if (Thread.currentThread().isInterrupted()) {
				return null;
			}
			if (p2_candc == null) {
				return null;
			}
			p2_abyte0 = p2_candc.getRawContents();
			if (p2_abyte0 != null && p2_abyte0.length != 0) {
				// 検索がスレ一覧に出ないのはgetCharsetFromCAndC で文字コード変換例外によるnullが原因
				if(V2CApp.isMacintosh() && V2CApp.javaVersionEqualTo(1, 5)){
					p2_s1 = "UTF-8";
				}else{
					p2_s1 = V2CHttpUtil.getCharsetFromCAndC(p2_candc);
				}
				if (p2_s1 == null) {
//					return null;
					p2_s1 = "UTF-8";
				}
				String p2_s2 = null;
				try {
					p2_s2 = new String(p2_abyte0, p2_s1);
				}
				catch (UnsupportedEncodingException unsupportedencodingexception) {
				}
				if (p2_s2 != null) {
					s2 = s2 + ("" + p2_s2);
				}
			}

			String ss = s2.replaceAll("[\\n\\r]", "");
			Pattern patternRemove = Pattern
					.compile("ad_area ad_bottom_space.+?</html>");
			Matcher m = patternRemove.matcher(ss);
			while (m.find()) {
				ss = ss.replace(m.group(0), "");
			}
			Pattern patternlogsokuKekkaUrl = Pattern
					.compile("href=\"/([^/]+)/([^/]+)/([^/]+)/([0-9]*)/?\"");
			m = patternlogsokuKekkaUrl.matcher(ss);
			while (m.find()) {
				ss = ss.replace(m.group(0), "href=\"http://logsoku." + m.group(2) + "/test/read.cgi/" + m.group(3) + "_" +  m.group(1) + "/" + m.group(4) + "/\"");
			}
			ss = ss.replaceAll(".5ch.net", ".2ch.net");
			s2 = ss;
		}
		if (s3.equals("ff5ch.syoboi.jp")) {
			s2 = s2.replaceAll(" </a><span.*?[\\n\\r]*?.*?>", "").replaceAll("]</a><span.*?[\\n\\r]*?.*?>", "]").replaceAll("</span>", "</a>");
		}
		if (s3.equals("refind2ch.org")) {
			s2 = s2.replaceAll("<p[^>]+?thread_title.+?>", "")
					.replaceAll("<p[^>]+?(board_title|date|rate_cnt).+?</p>", "")
					.replaceAll("</?div.*?>|<p.*?>| ?</p>", "")
					.replaceAll("<span.+?>", " (").replaceAll(" res</span>", ")");

			String sW = s.replaceAll("http.+?\\?", "");
			String[] asW = sW.split("&");
			String postdata = "";
			for(int ia=0; ia<asW.length; ia++){
				if(asW[ia].startsWith("q=")){
					postdata += asW[ia];
					break;
				}
			}
			postdata += "&p=$nn$";
			if(sW.indexOf("nopink") != -1){
				postdata += "&pink=1";
			}else if(sW.indexOf("ispink") != -1){
				postdata += "&pink=2";
			}else{
				postdata += "&pink=0";
			}
			if(sW.indexOf("sort=rate") != -1){
				postdata += "&sort=rate";
			}else{
				postdata += "&sort=false";
			}
			if(sW.indexOf("alive") != -1){
				postdata += "&alive=true";
			}else{
				postdata += "&alive=false";
			}
			for(int ia=0; ia<asW.length; ia++){
				if(asW[ia].startsWith("pl=")){
					postdata += "&" + asW[ia];
					break;
				}
			}
			postdata += "&b=" + "false";
			
			String addresults = "";
			HashMap hm = new HashMap();
			hm.put("User-Agent", V2CHttpUtil.UAPostCGI);
			for(int i=1; i<refind2chMaxPage; i++){
				try {
					Thread.sleep(refind2chSleep);
				} catch (InterruptedException e) {
					// TODO 自動生成された catch ブロック
					e.printStackTrace();
				}
				String w = postdata.replace("&p=$nn$", "&p=" + String.valueOf(i*20));
				System.out.println("re.Find2ch : " + w);
				V2CHttpUtil.CAndC candc1 = V2CHttpUtil.postForm("https://refind2ch.org/module/get_search", s, w, null, hm);
				Object localObject16 = V2CJSONUtil.parse(candc1.getRawContents());
				if ((localObject16 instanceof Map)){
					Object finished = ((Map) localObject16).get("finished");
					if(!finished.equals(false)){
						break;
					}
					List results = (List) ((Map) localObject16).get("results");
					for(int j=0; j<results.size(); j++){
						Map m = (Map) results.get(j);
						addresults += "<a href=\"" + (String) m.get("url") + "\">"
								   +   (String) m.get("thread_title") + " "
								   +  "(" +  (String) m.get("res_num") + ")</a>";
					}
				}else{
					V2CSwingUtil.showErrorMessage("re.Find2ch 検索異常終了");
					break;
				}
					
			}
			s2 += addresults;
		}
		boolean flag = s3.equals("ranking.sitepedia.jp");
		Pattern pattern = Pattern.compile("<a ([^>]+)>(.*?)</a>", 2);
		Pattern pattern1 = Pattern.compile("https?://[-_.!~*a-zA-Z0-9/@+$,%]+/\\d{9,10}/?", 2);
		Pattern pattern2 = Pattern.compile("\\?thread=([-_.!~*a-zA-Z0-9/@+$,%]+/\\d{9,10}/?)", 2);
		Pattern pattern3 = Pattern.compile("(https?://\\w+\\.machi\\.to/bbs/read\\.pl\\?BBS=\\w+&(?:amp;)?KEY=\\d{9,10})(?:\\D|$)",
				2);
		Pattern pattern4 = Pattern.compile("(?:^| )href=\"?(\\w+/)(\\d{9,10}/?)", 2);
		Pattern pattern5 = Pattern.compile("(.+) +\\((\\d+)\\)$", 2);
		Pattern pattern6 = Pattern.compile("https?://[-_.!~*a-zA-Z0-9/@+$,%]+/(\\d{10})/?", 2);
		s2 = s2.replaceAll("[\\n\\r]", "");
		Matcher matcher1 = pattern.matcher(s2);
		ArrayList arraylist1 = new ArrayList();
		ArrayList arraylist2 = new ArrayList();
		long TLast = System.currentTimeMillis();
		do {
			if (!matcher1.find())
				break;
			String s6 = matcher1.group(1);
			String s7 = null;
			Matcher matcher2 = pattern1.matcher(s6);
			if (matcher2.find())
				s7 = matcher2.group();
			if (s7 == null) {
				if (flag) {
					Matcher matcher3 = pattern2.matcher(s6);
					if (matcher3.find())
						s7 = "http://" + matcher3.group(1);
				}
				if (s7 == null) {
					Matcher matcher4 = pattern3.matcher(s6);
					if (matcher4.find())
						s7 = V2CMiscUtil.replaceAll(matcher4.group(1), "&amp;", "&");
					if (s7 == null) {
						Matcher matcher5 = pattern4.matcher(s6);
						if (matcher5.find()) {
							V2CBoardItem v2cboarditem = V2C2chTreeModel.getActiveBoardFromDir('/' + matcher5.group(1));
							if (v2cboarditem != null)
								s7 = v2cboarditem.getURLString() + matcher5.group(2);
						}
					}
				}
			}
			if (s7 != null) {
				s7 = s7.replace("https://", "http://");
				if(V2CHttpUtil.Use5chNet){
					s7 = V2CHttpUtil.Rep5chTo2ch(s7);
				}
				String m1g2 = matcher1.group(2);
				if(s3.equals("www.google.co.jp")){
					m1g2 = m1g2.replaceAll("</div>.+?</div></div></div>", "</div>");
				}
				String s8 = V2CResItem.replaceEscapes(V2CMiscUtil.removeHTMLTags(m1g2)).replaceAll(" - [25]ちゃんねる掲示板$", "");
				s8 = s8.replaceAll("^ +", "").replaceAll(" +$", "");
				Matcher matcher6 = pattern5.matcher(s8);
				int NRes = -1;
				if (matcher6.find()){
					s8 = matcher6.group(1);
					s8 = s8.replaceAll("^ +", "").replaceAll(" +$", "");
					if(matcher6.group(2) != null){
						NRes = Integer.valueOf(matcher6.group(2));
					}
				}
				int l = arraylist1.indexOf(s7);
				if (l >= 0) {
					V2CThreadItem v2cthreaditem = (V2CThreadItem) arraylist2.get(l);
					if (v2cthreaditem.getNRes() <= 0) {
						String s9 = v2cthreaditem.getTitle();
						if (s9 == null || s9.length() < s8.length())
							v2cthreaditem.setTitle(s8);
					}
				}
				else {
					V2CParseLinkResult v2cparselinkresult = new V2CParseLinkResult(s7);
					if (v2cparselinkresult.parse(false)) {
						V2CThreadItem v2cthreaditem1 = v2cparselinkresult.getThreadItem();
						if (v2cthreaditem1 != null) {
							if (v2cthreaditem1.getNRes() <= 0)
							{
								v2cthreaditem1.setTitle(s8);
								if(NRes != -1){
									v2cthreaditem1.nRes = NRes;
									v2cthreaditem1.nNum = 0;
									Matcher matcher7 = pattern6.matcher(s7);
									if (matcher7.find()){
										v2cthreaditem1.tBirthday = Long.valueOf(matcher7.group(1)) * 1000L;
										v2cthreaditem1.setTLast(TLast);
									}
								}
							}
							arraylist1.add(s7);
							arraylist2.add(v2cthreaditem1);
						}
					}
				}
			}
		} while (true);

		bSearchDone = true;
		saveResult(arraylist2, arraylist);
		for (int j = 0; j < arraylist2.size(); j++)
			arraylist2.set(j, ((Object) (createThreadListRowArray((V2CThreadItem) arraylist2.get(j)))));

		StringBuffer stringbuffer = new StringBuffer();
		stringbuffer.append(sMessageHeader);
		int k = arraylist2.size();
		stringbuffer.append(k);
		if (hsNewThread != null) {
			stringbuffer.append(" （新着：");
			stringbuffer.append(hsNewThread.size());
			stringbuffer.append('）');
			if (V2CSoundUtil.isCompSoundEnabled())
				V2CSoundUtil.playSound('t');
		}
		else {
			stringbuffer.append(" （新着スレ無し）");
		}
		ltLastCheckTime = System.currentTimeMillis();
		V2CMain.setMessage(stringbuffer.toString());
		return arraylist2;

	}

	boolean isNewThread(V2CThreadItem v2cthreaditem)
	{
		HashSet hashset = hsNewThread;
		return hashset != null && hashset.contains(v2cthreaditem);
	}

	ArrayList restorePrevResult()
	{
		File file = fLocalCache;
		BufferedReader bufferedreader = V2CLocalFileHandler.getSaveFileReader(file);
		if (bufferedreader == null)
			return null;
		ArrayList arraylist = new ArrayList();
		try {
			do {
				String s;
				if ((s = bufferedreader.readLine()) == null)
					break;
				int i = s.indexOf(',');
				if (i > 0) {
					String s1 = s.substring(0, i);
					V2CParseLinkResult v2cparselinkresult = new V2CParseLinkResult(s1);
					if (v2cparselinkresult.parse(false)) {
						V2CThreadItem v2cthreaditem = v2cparselinkresult.getThreadItem();
						if (v2cthreaditem != null) {
							if (v2cthreaditem.getNRes() <= 0)
								v2cthreaditem.setTitle(s.substring(i + 1));
							arraylist.add(v2cthreaditem);
						}
					}
				}
			} while (true);
		}
		catch (IOException ioexception) {
			ioexception.printStackTrace();
		}
		finally {
			V2CLocalFileHandler.closeReader(bufferedreader);
		}
		return arraylist;
	}

	void saveResult(ArrayList arraylist, ArrayList arraylist1)
	{
		File file = fLocalCache;
		if (file == null)
			return;
		hsNewThread = null;
		int i = arraylist.size();
		if (i == 0)
			return;
		V2CSaveFile v2csavefile = new V2CSaveFile(file);
		BufferedWriter bufferedwriter = v2csavefile.getWriter();
		if (bufferedwriter == null)
			return;
		HashSet hashset = new HashSet();
		long l = 0L;
		boolean flag = arraylist1 == null;
		HashSet hashset1;
		if (flag) {
			hashset1 = null;
		}
		else {
			int j = arraylist1.size();
			hashset1 = new HashSet(j);
			for (int i1 = 0; i1 < j; i1++) {
				V2CThreadItem v2cthreaditem1 = (V2CThreadItem) arraylist1.get(i1);
				hashset1.add(v2cthreaditem1.getFormalURLString());
				long l2 = v2cthreaditem1.getBirthday();
				if (l2 > 0L && l2 < 0x1d1a94a2000L && l2 > l)
					l = l2;
			}

			l -= 0x337f9800L;
		}
		try {
			for (int k = 0; k < i; k++) {
				V2CThreadItem v2cthreaditem = (V2CThreadItem) arraylist.get(k);
				long l1 = v2cthreaditem.getBirthday();
				String s = v2cthreaditem.getFormalURLString();
				if (flag || !hashset1.contains(s) && l1 > l && l1 < 0x1d1a94a2000L)
					hashset.add(v2cthreaditem);
				bufferedwriter.write(s);
				bufferedwriter.write(44);
				String s1 = v2cthreaditem.getTitle();
				if (s1 != null)
					bufferedwriter.write(s1);
				bufferedwriter.newLine();
			}

			v2csavefile.setOK();
		}
		catch (IOException ioexception) {
			ioexception.printStackTrace();
		}
		finally {
			V2CLocalFileHandler.closeWriter(bufferedwriter);
		}
		v2csavefile.replaceTmpFile();
		if (hashset.size() > 0)
			hsNewThread = hashset;
	}

	private static final int MAXCHECKCOUNT = 400;
	private static final int MAXERRORCOUNT = 3;
	private static final int MINREPEATINTERVAL = 15;
	private static final String sURL2NumFileName = "url2num.txt";
	private static ArrayList alNum2URL;
	static final V2CThreadListDefaultSort vThreadListDefaultSort = new V2CThreadListDefaultSort("WebSearchList.", "Web検索のスレ一覧");
	static final Icon icDefault = V2CSwingUtil.getItemIcon("Find");
	final V2CWebSearchItem vWebSearchItem;
	final boolean bURLButton;
	final File fLocalCache;
	HashSet hsNewThread;
	boolean bSearchDone;
	String sMessageHeader;
	Timer tWebSearchTimer;
	int nRepeatInterval;
	int nTotalCount;
	int nErrorCount;
	long ltLastCheckTime;
	// V2CMOD-twZ by MCZ, Date:2017/06/06, Googleサイト検索強化
	static V2CPanel pv2cpanel;
	// ---- END of V2CMOD-twZ ----

}
