package org.monazilla.v2c;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.DimensionUIResource;

public class V2CToolBar extends JPanel
{
	private static class SingleToolBar extends JToolBar
	{

		public void updateUI()
		{
			super.updateUI();
			if (V2CSwingUtil.isSynthLaF())
				setLayout(new BoxLayout(this, 2));
		}

		SingleToolBar(int i)
		{
			super(i);

			if(V2CDarkMode.using){
				this.setBorderPainted(false);
			}
		}
	}

	private static class ToolBarButton extends JButton
	{

		public void setSelected(boolean flag)
		{
			if (!((V2CAbstractAction) getAction()).getName().equals("ToggleTreePane"))
				super.setSelected(flag);
		}

		public void updateUI()
		{
			if (!bUIUpdated || !bMacSegmented) {
				bUIUpdated = true;
				super.updateUI();
			}
		}

		boolean bUIUpdated;
		boolean bDefaultIcon;
		boolean bMacSegmented;

		ToolBarButton()
		{
		}

		ToolBarButton(V2CAbstractAction v2cabstractaction)
		{
			super(v2cabstractaction);
		}
	}

	private static class ToolBarGlue extends JPanel
	{

		public Dimension getPreferredSize()
		{
			return dPref;
		}

		public Dimension getMaximumSize()
		{
			return dMax;
		}

		public Dimension getMinimumSize()
		{
			return dPref;
		}

		static Dimension dPref;
		static Dimension dMax = new Dimension(0x5f5e100, 10);

		static {
			Dimension dimension = UIManager.getDimension("ToolBar.separatorSize");
			dPref = new Dimension(dimension == null ? 5 : dimension.width, 10);
		}

		ToolBarGlue()
		{
			setOpaque(false);
		}
	}

	private static class ToolBarSpacer extends JPanel
	{

		public Dimension getPreferredSize()
		{
			return dSize;
		}

		public Dimension getMaximumSize()
		{
			return dSize;
		}

		public Dimension getMinimumSize()
		{
			return dSize;
		}

		Dimension dSize;

		ToolBarSpacer(int i)
		{
			dSize = new Dimension(i, 10);
			setOpaque(false);
		}
	}

	static boolean canMacUseSegmentedButton()
	{
		return V2CApp.isMacintosh(5) && !V2CMacQuaquaSupport.isQuaquaInstalled();
	}

	static boolean getMacUseSegmentedButtonSetting()
	{
		String s = V2CApp.getUserProperty().get("ToolBar.MacConf");
		return s == null || !s.equals("n");
	}

	static void setMacUseSegmentedButtonSetting(boolean flag)
	{
		V2CProperty v2cproperty = V2CApp.getUserProperty();
		if (flag)
			v2cproperty.remove("ToolBar.MacConf");
		else
			v2cproperty.put("ToolBar.MacConf", "n");
	}

	static void updateAllUI(Container container)
	{
		Iterator iterator = hmToolBars.values().iterator();
		do {
			if (!iterator.hasNext())
				break;
			V2CToolBar v2ctoolbar = (V2CToolBar) iterator.next();
			if (container == null || container == v2ctoolbar.getParent())
				V2CMain.fontForUIChanged0(v2ctoolbar);
		} while (true);
	}

	static ArrayList getButtonPanels()
	{
		return alButtonPanels;
	}

	static void setToolBar()
	{
		checkSetting();
		if (vlClonedSetting == null)
			vlClonedSetting = V2CToolBarSetting.cloneArray(vlToolBarSetting);
		V2CToolBarSetting av2ctoolbarsetting[] = V2CToolBarSetting.cloneArray(vlClonedSetting);
		V2CToolBarSetting av2ctoolbarsetting1[] = restoreSetting("tbcmps.txt", false);
		if (av2ctoolbarsetting1 == null || av2ctoolbarsetting1.length != vlToolBarSetting.length)
			return;
		V2CToolBarSP v2ctoolbarsp = new V2CToolBarSP(av2ctoolbarsetting1, av2ctoolbarsetting, !bNoCustomBottonBorder,
				nDefaultIconSize);
		if (!v2ctoolbarsp.showDialog())
			return;
		vlClonedSetting = av2ctoolbarsetting;
		saveSetting();
		boolean flag = !v2ctoolbarsp.getDrawCustomBottonBorder();
		int i = v2ctoolbarsp.getIconWidth();
		bNoCustomBottonBorder = flag;
		nDefaultIconSize = i;
		V2CProperty v2cproperty = V2CApp.getUserProperty();
		if (flag || i > 0) {
			V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue();
			v2cpackedpropvalue.setBoolean('e', flag);
			if (i > 0)
				v2cpackedpropvalue.setInt('W', i);
			v2cproperty.putPackedValue("ToolBar.Conf", v2cpackedpropvalue);
		}
		else {
			v2cproperty.remove("ToolBar.Conf");
		}
		V2CSearchHistoryItem.setHistoryNum(v2ctoolbarsp);
	}

	static void restoreToolBar()
	{
		vlToolBarSetting = restoreSetting("toolbar.txt", true);
		for (int i = 0; i < vlToolBarSetting.length; i++)
			createToolBar(vlToolBarSetting[i], ((Container) (null)));

	}

	private static V2CToolBarSetting[] restoreSetting(String s, boolean flag)
	{
		BufferedReader bufferedreader = flag ? V2CLocalFileHandler.getUserSaveFileReader(s) : null;
		if (bufferedreader == null)
			bufferedreader = V2CLocalFileHandler.getConfigReader(s);
		if (bufferedreader == null) {
			System.out.println("cannot read " + s + " !");
			V2CApp.immediateExit(1);
			return null;
		}
		ArrayList arraylist = new ArrayList();
		try {
			V2CToolBarSetting v2ctoolbarsetting = null;
			do {
				String s1;
				if ((s1 = bufferedreader.readLine()) == null)
					break;
				if (s1.length() != 0 && s1.charAt(0) != '#') {
					String as[] = V2CMiscUtil.split(s1);
					int i = as.length;
					String s2 = as[0];
					if (s2.equals("ToolBar")) {
						v2ctoolbarsetting = new V2CToolBarSetting(as);
						arraylist.add(v2ctoolbarsetting);
					}
					else if (v2ctoolbarsetting != null)
						v2ctoolbarsetting.add(as);
				}
			} while (true);
		}
		catch (IOException ioexception) {
			System.out.println(ioexception.getMessage());
			V2CApp.errorExit("\u30C4\u30FC\u30EB\u30D0\u30FC\u8A2D\u5B9A\u30D5\u30A1\u30A4\u30EB\u306E\u8AAD\u8FBC\u30A8\u30E9\u30FC");
		}
		finally {
			V2CLocalFileHandler.closeReader(bufferedreader);
		}
		return (V2CToolBarSetting[]) (V2CToolBarSetting[]) arraylist.toArray(new V2CToolBarSetting[arraylist.size()]);
	}

	static void checkSetting()
	{
		if (bSettingChecked)
			return;
		bSettingChecked = true;
		V2CToolBarSetting av2ctoolbarsetting[] = vlToolBarSetting;
		int i = av2ctoolbarsetting.length;
		for (int j = 0; j < i; j++) {
			V2CToolBarSetting v2ctoolbarsetting1 = av2ctoolbarsetting[j];
			if (v2ctoolbarsetting1.getIndex() == 3 && v2ctoolbarsetting1.getIDString().equals("Write"))
				return;
		}

		if (av2ctoolbarsetting[i - 2].getIDString().equals("Write")) {
			V2CToolBarSetting v2ctoolbarsetting = av2ctoolbarsetting[i - 1];
			av2ctoolbarsetting[i - 1] = av2ctoolbarsetting[i - 2];
			av2ctoolbarsetting[i - 2] = v2ctoolbarsetting;
		}
		V2CToolBarSetting av2ctoolbarsetting1[] = restoreSetting("toolbar2.txt", false);
		if (av2ctoolbarsetting1 != null) {
			int k = av2ctoolbarsetting1.length;
			if (k > 0) {
				V2CToolBarSetting av2ctoolbarsetting2[] = new V2CToolBarSetting[i + k];
				System.arraycopy(av2ctoolbarsetting, 0, av2ctoolbarsetting2, 0, i);
				System.arraycopy(av2ctoolbarsetting1, 0, av2ctoolbarsetting2, i, k);
				vlToolBarSetting = av2ctoolbarsetting2;
			}
		}
	}

	static void saveSetting()
	{
		if (vlClonedSetting == null)
			return;
		BufferedWriter bufferedwriter = V2CLocalFileHandler.getUserConfigWriter("toolbar.txt");
		if (bufferedwriter == null) {
			System.out.println("cannot write to toolbar.txt !");
			return;
		}
		try {
			for (int i = 0; i < vlClonedSetting.length; i++) {
				V2CToolBarSetting v2ctoolbarsetting = vlClonedSetting[i];
				bufferedwriter.write("ToolBar,");
				bufferedwriter.write(v2ctoolbarsetting.getIDString());
				bufferedwriter.write(44);
				bufferedwriter.write(v2ctoolbarsetting.getPositionString());
				bufferedwriter.newLine();
				for (int j = 0; j < v2ctoolbarsetting.size(); j++) {
					V2CToolBarComponent v2ctoolbarcomponent = v2ctoolbarsetting.get(j);
					String s = v2ctoolbarcomponent.getSaveString();
					if (s != null) {
						bufferedwriter.write(s);
						bufferedwriter.newLine();
					}
				}

				bufferedwriter.newLine();
			}

		}
		catch (IOException ioexception) {
			System.out.println(ioexception.getMessage());
		}
		finally {
			try {
				bufferedwriter.close();
			}
			catch (IOException ioexception1) {
			}
		}
	}

	static V2CToolBar getToolBar(String s, String s1)
	{
		return (V2CToolBar) hmToolBars.get(s + ':' + s1);
	}

	static boolean isToolBarVisible(String s, String s1)
	{
		V2CToolBar v2ctoolbar = getToolBar(s, s1);
		if (v2ctoolbar == null)
			return true;
		else
			return v2ctoolbar.isVisible();
	}

	static boolean setToolBarVisible(String s, String s1, boolean flag)
	{
		V2CToolBar v2ctoolbar = getToolBar(s, s1);
		if (v2ctoolbar == null)
			return true;
		v2ctoolbar.setVisible(flag);
		String s2 = s + ".ShowToolBar";
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		String s3 = v2cproperty.get(s2);
		if (s3 == null || s3.length() != 4)
			s3 = "SSSS";
		char ac[] = s3.toCharArray();
		int i = V2CToolBarSetting.getToolBarPositionIndex(s1);
		if (flag != (ac[i] == 'S')) {
			ac[i] = flag ? 'S' : 'H';
			v2cproperty.put(s2, new String(ac));
		}
		return flag;
	}

	static void createToolBar(Container container, String s)
	{
		checkSetting();
		if (vlToolBarSetting == null)
			return;
		for (int i = 0; i < vlToolBarSetting.length; i++) {
			V2CToolBarSetting v2ctoolbarsetting = vlToolBarSetting[i];
			if (s.equals(v2ctoolbarsetting.getIDString()))
				createToolBar(v2ctoolbarsetting, container);
		}

	}

	static void createToolBar(V2CToolBarSetting v2ctoolbarsetting, Container container)
	{
		String s = v2ctoolbarsetting.getIDString();
		if (container == null)
			container = v2ctoolbarsetting.getContainer();
		if (container == null)
			return;
		boolean flag = s.startsWith("Write");
		if (flag && v2ctoolbarsetting.size() == 0)
			return;
		V2CToolBar v2ctoolbar = new V2CToolBar(s, v2ctoolbarsetting, container);
		container.add(v2ctoolbar, v2ctoolbarsetting.getBorderPosition());
		if (!flag) {
			String s1 = V2CMain.getUserProperty().get(s + ".ShowToolBar");
			if (s1 != null && s1.length() == 4 && s1.charAt(v2ctoolbarsetting.getIndex()) != 'S')
				v2ctoolbar.setVisible(false);
		}
	}

	static Component createToolBarButton(V2CAbstractAction v2cabstractaction, boolean flag)
	{
		ToolBarButton toolbarbutton = null;
		switch (v2cabstractaction.getType()) {
			case 0: // '\0'
				toolbarbutton = new ToolBarButton(v2cabstractaction);
				break;

			case 2: // '\002'
				toolbarbutton = new ToolBarButton(v2cabstractaction);
				if (v2cabstractaction.isSelected())
					toolbarbutton.setSelected(true);
				break;
		}
		if (toolbarbutton == null)
			return null;
		if (V2CApp.isMacintosh() && V2CMacQuaquaSupport.needsGeometryTweak()) {
			V2CMacQuaquaSupport.resetVisualMargin(toolbarbutton);
			V2CMacQuaquaSupport.setSquareButtonStyle(toolbarbutton);
			toolbarbutton.setMargin(new Insets(2, 2, 2, 2));
		}
		toolbarbutton.setFocusable(false);
		if (flag)
			v2cabstractaction.add(toolbarbutton);
		String s = v2cabstractaction.getName();
		if (!setCustomIcon(toolbarbutton, s)) {
			ImageIcon imageicon = null;
			if (bMacUseSegmentedButton) {
				checkSpecialIcon(s);
				toolbarbutton.putClientProperty("JComponent.sizeVariant", "small");
				byte byte0 = 26;
				byte byte1 = 18;
				toolbarbutton.putClientProperty("JButton.buttonType", "segmentedTextured");
				String s1 = null;
				if (v2cabstractaction instanceof V2CAction.DisplayPaneHistoryBack) {
					s1 = "first";
					byte0 = 20;
				}
				else if (v2cabstractaction instanceof V2CAction.DisplayPaneHistoryForward) {
					s1 = "last";
					byte0 = 20;
				}
				else {
					s1 = "only";
				}
				toolbarbutton.putClientProperty("JButton.segmentPosition", s1);
				Dimension dimension = new Dimension(byte0, byte1);
				toolbarbutton.setPreferredSize(dimension);
				toolbarbutton.setMinimumSize(dimension);
				toolbarbutton.bMacSegmented = true;
				String s2 = v2cabstractaction.getIconName();
				imageicon = V2CMonochromeIconFactory.createIcon(s2, false);
				if (imageicon != null) {
					toolbarbutton.setIcon(imageicon);
					imageicon = V2CMonochromeIconFactory.createIcon(s2, true);
					if (imageicon != null)
						toolbarbutton.setSelectedIcon(imageicon);
				}
			}
			if (imageicon == null && !setDefaultIcon(toolbarbutton, v2cabstractaction.getName())) {
				Icon icon = v2cabstractaction.getIcon();
				if (icon != null) {
					toolbarbutton.setIcon(icon);
					icon = v2cabstractaction.getDisabledIcon();
					if (icon != null)
						toolbarbutton.setDisabledIcon(icon);
				}
				else {
					toolbarbutton.setText(v2cabstractaction.getToolBarLabel());
				}
			}
		}
		toolbarbutton.setToolTipText(v2cabstractaction.getToolTipText());
		return toolbarbutton;
	}

	static boolean setDefaultIcon(ToolBarButton toolbarbutton, String s)
	{
		byte abyte0[] = V2CLocalFileHandler.getIconBytesFromResource(s);
		if (abyte0 == null)
			return false;
		Toolkit toolkit = Toolkit.getDefaultToolkit();
		int i = abyte0.length;
		byte byte0 = abyte0[0];
		byte byte1 = abyte0[1];
		int j = abyte0[2] << 1;
		int ai[] = new int[byte0 * byte1];
		int k = nDefaultIconSize;
		boolean flag = k > 0 && k < byte0;
		boolean flag1 = V2CApp.isMacintosh();
		int l;
		int i1;
		int ai1[];
		int j1;
		if (flag) {
			if (2 * k < byte0)
				k = (byte0 + 1) / 2;
			l = k;
			i1 = k;
			ai1 = new int[l * i1];
			j1 = (l << 15) / byte0;
		}
		else {
			l = byte0;
			i1 = byte1;
			ai1 = ai;
			j1 = 0;
		}
		int k1 = 3;
		for (int l1 = 0; l1 < 7; l1++) {
			j >>>= 1;
			if ((j & 1) == 0)
				continue;
			if (flag1 && (j == 2 || j == 4)) {
				k1 += 4 * byte0 * byte1;
				continue;
			}
			int i2 = 0;
			for (int l2 = 0; l2 < byte1; l2++) {
				for (int j3 = 0; j3 < byte0; j3++)
					ai[i2++] = (abyte0[k1++] & 0xff) << 24 | (abyte0[k1++] & 0xff) << 16 | (abyte0[k1++] & 0xff) << 8
							| abyte0[k1++] & 0xff;

			}

			if (flag) {
				int j2 = 0;
				int i3 = ai.length;
				for (int k3 = 0; k3 < byte1; k3++) {
					int i4 = k3 * byte0;
					int k4 = 32768;
					int i5 = 0;
					int k5 = 0;
					int i6 = 0;
					int k6 = 0;
					for (int i7 = 0; i7 < byte0; i7++) {
						int k7 = ai[i4 + i7];
						if (i7 == byte0 - 1)
							k4 = j1;
						boolean flag3 = k4 <= j1;
						int i8;
						if (flag3) {
							i8 = k4;
						}
						else {
							i8 = j1;
							k4 -= j1;
						}
						int k8 = k7 >>> 24;
						int i9 = i8 * k8;
						k6 += i9;
						i5 += (k7 >>> 16 & 0xff) * i9;
						k5 += (k7 >>> 8 & 0xff) * i9;
						i6 += (k7 & 0xff) * i9;
						if (!flag3)
							continue;
						if (j2 >= i3)
							break;
						if (k6 != 0)
							ai[j2++] = (k6 & 0x7f8000) << 9 | i5 / k6 << 16 | k5 / k6 << 8 | i6 / k6;
						else
							ai[j2++] = 0;
						i8 = j1 - i8;
						k8 = k7 >>> 24;
						i9 = i8 * k8;
						k6 = i9;
						i5 = (k7 >>> 16 & 0xff) * i9;
						k5 = (k7 >>> 8 & 0xff) * i9;
						i6 = (k7 & 0xff) * i9;
						k4 = 32768 - i8;
					}

				}

				i3 = ai1.length;
				for (int l3 = 0; l3 < l; l3++) {
					int k2 = l3;
					int j4 = 32768;
					int l4 = 0;
					int j5 = 0;
					int l5 = 0;
					int j6 = 0;
					for (int l6 = 0; l6 < byte1; l6++) {
						int j7 = ai[l6 * l + l3];
						if (l6 == byte1 - 1)
							j4 = j1;
						boolean flag2 = j4 <= j1;
						int l7;
						if (flag2) {
							l7 = j4;
						}
						else {
							l7 = j1;
							j4 -= j1;
						}
						int j8 = j7 >>> 24;
						int l8 = l7 * j8;
						j6 += l8;
						l4 += (j7 >>> 16 & 0xff) * l8;
						j5 += (j7 >>> 8 & 0xff) * l8;
						l5 += (j7 & 0xff) * l8;
						if (!flag2)
							continue;
						if (k2 >= i3)
							break;
						if (j6 != 0)
							ai1[k2] = (j6 & 0x7f8000) << 9 | l4 / j6 << 16 | j5 / j6 << 8 | l5 / j6;
						else
							ai1[k2] = 0;
						k2 += i1;
						l7 = j1 - l7;
						j8 = j7 >>> 24;
						l8 = l7 * j8;
						j6 = l8;
						l4 = (j7 >>> 16 & 0xff) * l8;
						j5 = (j7 >>> 8 & 0xff) * l8;
						l5 = (j7 & 0xff) * l8;
						j4 = 32768 - l7;
					}

				}

			}
			BufferedImage bufferedimage = new BufferedImage(l, i1, 2);
			bufferedimage.setRGB(0, 0, l, i1, ai1, 0, l);
			ImageIcon imageicon = new ImageIcon(bufferedimage);
			switch (l1) {
				case 0: // '\0'
					toolbarbutton.setIcon(imageicon);
					break;

				case 1: // '\001'
					toolbarbutton.setPressedIcon(imageicon);
					break;

				case 2: // '\002'
					toolbarbutton.setRolloverIcon(imageicon);
					break;

				case 3: // '\003'
					toolbarbutton.setSelectedIcon(imageicon);
					break;

				case 4: // '\004'
					toolbarbutton.setRolloverSelectedIcon(imageicon);
					break;

				case 5: // '\005'
					toolbarbutton.setDisabledIcon(imageicon);
					break;

				case 6: // '\006'
					toolbarbutton.setDisabledSelectedIcon(imageicon);
					break;

				default:
					return false;
			}
		}

		toolbarbutton.setBorderPainted(false);
		toolbarbutton.setContentAreaFilled(false);
		toolbarbutton.setRolloverEnabled(true);
		Dimension dimension = new Dimension(l + 2, i1 + 2);
		toolbarbutton.setPreferredSize(dimension);
		toolbarbutton.setMinimumSize(dimension);
		checkSpecialIcon(s);
		toolbarbutton.bDefaultIcon = true;
		return true;
	}

	static JButton createButtonForToolBar(String s)
	{
		ToolBarButton toolbarbutton = new ToolBarButton();
		if (bMacUseSegmentedButton) {
			toolbarbutton.putClientProperty("JComponent.sizeVariant", "small");
			toolbarbutton.putClientProperty("JButton.buttonType", "segmentedTextured");
			toolbarbutton.putClientProperty("JButton.segmentPosition", "only");
		}
		else if (V2CApp.isMacintosh()) {
			toolbarbutton.setContentAreaFilled(false);
			toolbarbutton.setBorderPainted(false);
		}
		toolbarbutton.setMargin(bMacUseSegmentedButton ? new Insets(5, -7, 5, -7) : new Insets(1, 2, 1, 2));
		String s1 = "AddressBarOpen";
		if (!setCustomIcon(toolbarbutton, s1)) {
			ImageIcon imageicon = null;
			if (bMacUseSegmentedButton)
				imageicon = V2CMonochromeIconFactory.createIcon(s, false);
			if (imageicon == null && !setDefaultIcon(toolbarbutton, s1))
				imageicon = V2CSwingUtil.getSystemIcon(s);
			if (imageicon != null)
				toolbarbutton.setIcon(imageicon);
		}
		return toolbarbutton;
	}

	static boolean setCustomIcon(AbstractButton abstractbutton, String s)
	{
		Icon icon = getCustomIcon(s);
		if (icon == null)
			return false;
		checkSpecialIcon(s);
		if (bNoCustomBottonBorder) {
			abstractbutton.setContentAreaFilled(false);
			abstractbutton.setBorderPainted(false);
		}
		abstractbutton.setIcon(icon);
		icon = getCustomIcon(s + "_P");
		if (icon != null)
			abstractbutton.setPressedIcon(icon);
		icon = getCustomIcon(s + "_S");
		if (icon != null)
			abstractbutton.setSelectedIcon(icon);
		icon = getCustomIcon(s + "_R");
		if (icon != null)
			abstractbutton.setRolloverIcon(icon);
		icon = getCustomIcon(s + "_RS");
		if (icon != null)
			abstractbutton.setRolloverSelectedIcon(icon);
		icon = getCustomIcon(s + "_D");
		if (icon != null)
			abstractbutton.setDisabledIcon(icon);
		icon = getCustomIcon(s + "_DS");
		if (icon != null)
			abstractbutton.setDisabledSelectedIcon(icon);
		return true;
	}

	static Icon getCustomIcon(String s)
	{
		java.io.File file = V2CLocalFileHandler.getToolBarIconFile(s);
		if (file == null)
			return null;
		BufferedImage bufferedimage = null;
		try {
			bufferedimage = ImageIO.read(file);
		}
		catch (IOException ioexception) {
			System.out.println(ioexception.getMessage());
			return null;
		}
		if (bufferedimage == null)
			return null;
		else
			return new ImageIcon(bufferedimage);
	}

	static void checkSpecialIcon(String s)
	{
		V2CThreadListPane.checkSpecialIcon(s);
		V2CThreadViewPane.checkSpecialIcon(s);
	}

	static Component createToolBarComponent(JToolBar jtoolbar, V2CToolBarComponent v2ctoolbarcomponent, String s,
			Container container)
	{
		Object obj = null;
		switch (v2ctoolbarcomponent.getType()) {
			default:
				break;

			case 2: // '\002'
				String s1 = v2ctoolbarcomponent.getComponentName();
				if (s1.equals("AddressBar")) {
					obj = V2CAddressBar.getInstance();
					break;
				}
				if (s1.equals("FindField"))
					break;
				if (s1.equals("BoardTreeMiniSearch")) {
					obj = V2CAbstractMiniSearch.getInstance(0, true);
					break;
				}
				if (s1.equals("ThreadListMiniSearch")) {
					obj = V2CAbstractMiniSearch.getInstance(1, true);
					break;
				}
				if (s1.equals("ThreadViewMiniSearch")) {
					obj = V2CAbstractMiniSearch.getInstance(2, true);
					break;
				}
				if (s1.equals("MessageField")) {
					obj = V2CMessageField.getInstance();
					break;
				}
				if (s1.equals("ImgDLStatus")) {
					obj = V2CImgDLStatus.getInstance();
					break;
				}
				if (s1.equals("ProgressBar")) {
					obj = V2CProgressBar.getInstance();
					break;
				}
				if (s1.equals("MemoryGauge")) {
					obj = V2CMemoryGauge.getInstance();
					break;
				}
				if (s1.equals("NameAndMail")) {
					obj = ((V2CWritePanel) container).createNameAndMail();
					break;
				}
				if (s1.equals("WritePanelWarning")) {
					obj = ((V2CWriteWindow) container).createWarning();
					break;
				}
				if (s1.equals("WritePanelCounter")) {
					obj = ((V2CWritePanel) container).createCounter();
					break;
				}
				if (s1.equals("WriteMessageStatus")) {
					obj = ((V2CWritePanel) container).createWriteMessageStatus();
					break;
				}
				if (s1.equals("MemoSelector")) {
					obj = ((V2CWritePanel) container).createMemoSelector();
					break;
				}
				if (s1.equals("ThreadViewHistory")) {
					obj = V2CThreadViewHistory.createThreadViewHistory();
					break;
				}
				if (s1.equals("ThreadListHistory")) {
					obj = V2CThreadListHistory.createThreadListHistory();
					break;
				}
				if (s1.equals("ButtonPanel")) {
					obj = V2CToolBarButtonPanel.getButtonPanel(s);
					alButtonPanels.add(obj);
				}
				break;

			case 3: // '\003'
				jtoolbar.addSeparator();
				break;

			case 4: // '\004'
				obj = new ToolBarSpacer(v2ctoolbarcomponent.getWidth());
				break;

			case 5: // '\005'
				obj = new ToolBarGlue();
				break;
		}
		return ((Component) (obj));
	}

	public V2CToolBar(String s, V2CToolBarSetting v2ctoolbarsetting, Container container)
	{
		super(new GridBagLayout());
		sID = s;
		JToolBar jtoolbar = createNewToolBar(v2ctoolbarsetting.getToolBarOrientation());
		GridBagConstraints gridbagconstraints = new GridBagConstraints();
		gridbagconstraints.gridx = 0;
		gridbagconstraints.gridy = 0;
		gridbagconstraints.fill = 2;
		gridbagconstraints.weightx = 1.0D;
		add(jtoolbar, gridbagconstraints);
		gridbagconstraints.weightx = 0.0D;
		String s1 = v2ctoolbarsetting.getPositionString();
		if (!s.startsWith("Write"))
			hmToolBars.put(s + ':' + s1, this);
		for (int i = 0; i < v2ctoolbarsetting.size(); i++) {
			V2CToolBarComponent v2ctoolbarcomponent = v2ctoolbarsetting.get(i);
			Component component = null;
			int j = v2ctoolbarcomponent.getType();
			if (j == 6) {
				jtoolbar = createNewToolBar(v2ctoolbarsetting.getToolBarOrientation());
				gridbagconstraints.gridy++;
				add(jtoolbar, gridbagconstraints);
				continue;
			}
			if (j == 1)
				component = createToolBarButton(v2ctoolbarcomponent.getAction(), true);
			else
				component = createToolBarComponent(jtoolbar, v2ctoolbarcomponent, sID, container);
			if (component != null)
				jtoolbar.add(component);
		}

		if (V2CApp.isMacintosh() && s.equals("Main") && s1.equals("Bottom")) {
			JPanel jpanel = new JPanel();
			jpanel.setOpaque(false);
			byte byte0 = V2CApp.getOSXVersion() < 5 ? ((byte) (V2CApp.isBrushMetalLook() ? 20 : 13)) : 8;
			Dimension dimension = new Dimension(byte0, 10);
			jpanel.setPreferredSize(dimension);
			jpanel.setMaximumSize(dimension);
			jtoolbar.add(jpanel);
		}
	}

	JToolBar createNewToolBar(int i)
	{
		SingleToolBar singletoolbar = new SingleToolBar(i);
		singletoolbar.setFloatable(false);
		return singletoolbar;
	}

	private static final String sSaveFileName = "toolbar.txt";
	private static final String sSaveFileName2 = "toolbar2.txt";
	static final String sComponentsFileName = "tbcmps.txt";
	static final String sConfKey = "ToolBar.Conf";
	static final String sMacConfKey = "ToolBar.MacConf";
	static final HashMap hmToolBars = new HashMap();
	static V2CToolBarSetting vlToolBarSetting[];
	static V2CToolBarSetting vlClonedSetting[];
	static boolean bSettingChecked;
	static final ArrayList alButtonPanels = new ArrayList();
	static final boolean bMacUseSegmentedButton;
	static boolean bNoCustomBottonBorder;
	static int nDefaultIconSize;
	static final boolean bUseMonochromeIcon = false;
	String sID;

	static {
		V2CProperty v2cproperty = V2CApp.getUserProperty();
		if (V2CApp.isMacintosh()) {
			boolean flag = V2CApp.isMacintosh(5);
			boolean flag1 = V2CMacQuaquaSupport.isQuaquaInstalled();
			String s = v2cproperty.get("ToolBar.MacConf");
			boolean flag2 = s == null || !s.equals("n");
			bMacUseSegmentedButton = flag && !flag1 && flag2;
			if (flag && !flag1 && !flag2)
				UIManager.put("ToolBar.separatorSize", new DimensionUIResource(28, 2));
		}
		else {
			bMacUseSegmentedButton = false;
		}
		V2CPackedPropValue v2cpackedpropvalue = v2cproperty.getPackedValue("ToolBar.Conf");
		if (v2cpackedpropvalue != null) {
			bNoCustomBottonBorder = v2cpackedpropvalue.getBoolean('e');
			nDefaultIconSize = v2cpackedpropvalue.getIntInRangeIfExists('W', 12, 23);
		}
	}

/*      */   public static V2CToolBarSP getToolBarConfPanel() {
/*  190 */     checkSetting();
/*  191 */     if (vlClonedSetting == null)
/*  192 */       vlClonedSetting = V2CToolBarSetting.cloneArray(vlToolBarSetting); 
/*  194 */     V2CToolBarSetting[] av2ctoolbarsetting = 
/*  195 */       V2CToolBarSetting.cloneArray(vlClonedSetting);
/*  196 */     V2CToolBarSetting[] av2ctoolbarsetting1 = restoreSetting("tbcmps.txt", 
/*  197 */         false);
/*  198 */     if (av2ctoolbarsetting1 == null || 
/*  199 */       av2ctoolbarsetting1.length != vlToolBarSetting.length)
/*  200 */       return null; 
/*  202 */     V2CToolBarSP v2ctoolbarsp = new V2CToolBarSP(av2ctoolbarsetting1, 
/*  203 */         av2ctoolbarsetting, !bNoCustomBottonBorder, 
/*  204 */         nDefaultIconSize);
/*  205 */     return v2ctoolbarsp;
/*      */   }

/*      */   static void applyToolbarSPChanges(V2CToolBarSP v2ctoolbarsp) {
/*  220 */     vlClonedSetting = v2ctoolbarsp.vlToolBarSetting;
/*  221 */     saveSetting();
/*  222 */     boolean flag = !v2ctoolbarsp.getDrawCustomBottonBorder();
/*  223 */     int i = v2ctoolbarsp.getIconWidth();
/*  224 */     bNoCustomBottonBorder = flag;
/*  225 */     nDefaultIconSize = i;
/*  226 */     V2CProperty v2cproperty = V2CApp.getUserProperty();
/*  227 */     if (flag || i > 0) {
/*  228 */       V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue();
/*  229 */       v2cpackedpropvalue.setBoolean('e', flag);
/*  230 */       if (i > 0)
/*  231 */         v2cpackedpropvalue.setInt('W', i); 
/*  233 */       v2cproperty.putPackedValue("ToolBar.Conf", v2cpackedpropvalue);
/*      */     } else {
/*  235 */       v2cproperty.remove("ToolBar.Conf");
/*      */     } 
/*  237 */     V2CSearchHistoryItem.setHistoryNum(v2ctoolbarsp);
/*      */   }
}
