package org.monazilla.v2c;

import java.security.AccessControlContext;
import java.security.PrivilegedExceptionAction;
import javax.swing.SwingUtilities;

public class V2CThreadUpdateScript extends V2CSystemScript
{

	private static V2CThreadUpdateScript getInstance()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return null;
		if (!bLoadTried) {
			bLoadTried = true;
			vThreadUpdateScript = (V2CThreadUpdateScript) V2CScriptUtil.createSystemScript("threadld.js");
		}
		return vThreadUpdateScript;
	}

	static void reload()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return;
		V2CThreadUpdateScript v2cthreadupdatescript = vThreadUpdateScript;
		if (v2cthreadupdatescript != null) {
			v2cthreadupdatescript.stop();
			vThreadUpdateScript = null;
		}
		V2CScriptUtil.printMessage("threadld.jsを読み込んでいます…");
		bLoadTried = false;
		v2cthreadupdatescript = getInstance();
		V2CScriptUtil.printMessage("threadld.jsを読み込" + (v2cthreadupdatescript == null ? "めませんでした。" : "みました。"));
	}

	static V2CThreadUpdateScript createThreadUpdateScript(String s, V2CScriptClassLoader v2cscriptclassloader,
			AccessControlContext accesscontrolcontext)
	{
		s = s + createDefCheckScript(new String[] { "panelCreated", "threadUpdated" });
		V2CScriptApp v2cscriptapp = new V2CScriptApp("threadld.js");
		String s1 = null;
		PrivilegedExceptionAction privilegedexceptionaction = null;
		try {
			privilegedexceptionaction = V2CJSE6Util.createScriptAction("JavaScript", s, v2cscriptapp, v2cscriptclassloader,
					accesscontrolcontext, false);
		}
		catch (Exception exception) {
			s1 = exception.getMessage();
		}
		if (privilegedexceptionaction == null) {
			V2CScriptUtil.setErrorMessage(s1 == null ? "アクションの作成に失敗しました。" : s1);
			return null;
		}
		V2CThreadUpdateScript v2cthreadupdatescript = new V2CThreadUpdateScript(privilegedexceptionaction, v2cscriptapp,
				v2cscriptclassloader, accesscontrolcontext);
		Object obj = v2cthreadupdatescript.exec();
		if (obj instanceof boolean[]) {
			boolean aflag[] = (boolean[]) (boolean[]) obj;
			bPanelCreated = aflag[0];
			bThreadUpdated = aflag[1];
		}
		else {
			bPanelCreated = false;
			bThreadUpdated = false;
		}
		return v2cthreadupdatescript;
	}

	static void panelCreated(final V2CThreadPanel tp)
	{
		if (tp == null) {
			return;
		}
		else {
			SwingUtilities.invokeLater(new Runnable() {

				public void run()
				{
					V2CThreadUpdateScript tus = V2CThreadUpdateScript.getInstance();
					if (tus != null && V2CThreadUpdateScript.bPanelCreated) {
						tus.panelCreated(V2CScriptThread.createScriptThread(tp));
					}
					return;
				}
			});
			return;
		}
	}

	static V2CScriptThreadUpdateContext threadUpdated(V2CThreadPanel v2cthreadpanel, String s, boolean flag, int i, boolean flag1)
	{
		if (v2cthreadpanel == null)
			return null;
		V2CThreadUpdateScript v2cthreadupdatescript = getInstance();
		if (v2cthreadupdatescript == null || !bThreadUpdated) {
			return null;
		}
		else {
			V2CScriptThreadUpdateContext v2cscriptthreadupdatecontext = new V2CScriptThreadUpdateContext(s, flag, i, flag1);
			v2cthreadupdatescript.threadUpdated(V2CScriptThread.createScriptThread(v2cthreadpanel), v2cscriptthreadupdatecontext);
			return v2cscriptthreadupdatecontext;
		}
	}

	private V2CThreadUpdateScript(PrivilegedExceptionAction privilegedexceptionaction, V2CScriptApp v2cscriptapp,
			V2CScriptClassLoader v2cscriptclassloader, AccessControlContext accesscontrolcontext)
	{
		super(privilegedexceptionaction, v2cscriptapp, v2cscriptclassloader, accesscontrolcontext);
	}

	synchronized void panelCreated(V2CScriptThread v2cscriptthread)
	{
		if (bReloading) {
			return;
		}
		else {
			V2CJSE6Util.setInvokeFunction(vPrivilegedExceptionAction, "panelCreated", new Object[] { v2cscriptthread });
			exec();
			return;
		}
	}

	synchronized void threadUpdated(V2CScriptThread v2cscriptthread, V2CScriptThreadUpdateContext v2cscriptthreadupdatecontext)
	{
		if (bReloading) {
			return;
		}
		else {
			V2CJSE6Util.setInvokeFunction(vPrivilegedExceptionAction, "threadUpdated", new Object[] { v2cscriptthread,
					v2cscriptthreadupdatecontext });
			exec();
			return;
		}
	}

	private static final String sScriptFileName = "threadld.js";
	private static boolean bLoadTried;
	private static V2CThreadUpdateScript vThreadUpdateScript;
	private static boolean bPanelCreated;
	private static boolean bThreadUpdated;

}
