package org.monazilla.v2c;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.MouseEvent;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class V2CThreadPopup extends V2CAbstractThreadPanel implements V2CPopupPanel
{
	private class GlassPaneMouseListener extends V2CMouseExitListener
	{

		public void mouseEntered(MouseEvent mouseevent)
		{
			bPointerInside = true;
		}

		void doExitAction(MouseEvent mouseevent)
		{
			vtpParent.checkPopupTree(V2CSwingUtil.getMouseLocationOnScreen(mouseevent));
		}

		public void mouseExited(MouseEvent mouseevent)
		{
			if (bButtonDown)
				return;
			bPointerInside = false;
			if (V2CThreadPopup.bFixPopup)
				return;
			if (isOutside(mouseevent) && vtpParent != null)
				doExitAction(mouseevent);
		}

		GlassPaneMouseListener()
		{
			super(V2CThreadPopup.this);
		}
	}

	class PopupPopupListener extends V2CAbstractThreadPanel.PopupListener
	{

		public void mouseDragged(MouseEvent mouseevent)
		{
			if (bDragWindow) {
				Point point = V2CSwingUtil.getMouseLocationOnScreen(mouseevent);
				int i = point.x - nLastX;
				int j = point.y - nLastY;
				nLastX = point.x;
				nLastY = point.y;
				Rectangle rectangle = jwPopupWindow.getBounds();
				int k = rectangle.x + i;
				int l = rectangle.y + j;
				Rectangle rectangle1 = rScreenBounds;
				if (rectangle1 == null)
					return;
				if (!rectangle1.contains(point)) {
					Rectangle rectangle2 = V2CSwingUtil.getScreenBoundsAt(point);
					if (rectangle2 != null) {
						rScreenBounds = rectangle2;
						rectangle1 = rectangle2;
					}
				}
				if (k < rectangle1.x + 1)
					k = rectangle1.x + 1;
				else if (k + rectangle.width > (rectangle1.x + rectangle1.width) - 1)
					k = (rectangle1.x + rectangle1.width) - rectangle.width - 1;
				if (l < rectangle1.y + 1)
					l = rectangle1.y + 1;
				else if (l + rectangle.height > (rectangle1.y + rectangle1.height) - 1)
					l = (rectangle1.y + rectangle1.height) - rectangle.height - 1;
				if (k == rectangle.x && l == rectangle.y)
					return;
				jwPopupWindow.setLocation(k, l);
				if (!bCursorSet) {
					bCursorSet = true;
					setCursor(Cursor.getPredefinedCursor(12));
				}
			}
			else {
				super.mouseDragged(mouseevent);
			}
		}

		public void mousePressed(MouseEvent mouseevent)
		{
			super.mousePressed(mouseevent);
			boolean flag = V2CSwingUtil.isSimpleClick(mouseevent) && mouseevent.getPoint().x < 20;
			if (flag) {
				Point point = mouseevent.getPoint();
				int i = 0;
				do {
					if (i >= alShapes.size())
						break;
					V2CAbstractThreadPanel.ActiveShape activeshape = (V2CAbstractThreadPanel.ActiveShape) alShapes.get(i);
					Shape shape = activeshape.getShape();
					if (shape != null && shape.contains(point)) {
						flag = false;
						break;
					}
					i++;
				} while (true);
				if (flag) {
					closeChildPopups(false);
					Point point1 = mouseevent.getPoint();
					SwingUtilities.convertPointToScreen(point1, V2CThreadPopup.this);
					point1 = V2CSwingUtil.tweakMouseLocationOnScreen(point1, V2CThreadPopup.this);
					nLastX = point1.x;
					nLastY = point1.y;
				}
			}
			bDragWindow = flag;
		}

		public void mouseReleased(MouseEvent mouseevent)
		{
			if (bDragWindow) {
				if (bCursorSet) {
					bCursorSet = false;
					setCursor(Cursor.getDefaultCursor());
				}
			}
			else {
				super.mouseReleased(mouseevent);
			}
		}

		boolean bDragWindow;
		int nLastX;
		int nLastY;
		boolean bCursorSet;

		PopupPopupListener()
		{
			V2CThreadPopup.this.super();
			//super(V2CThreadPopup.this);
		}
	}

	static void updatePopupBGs(Color color, Color color1)
	{
		if (!cPopupBG.equals(color)) {
			cPopupBG = color;
			V2CMain.getUserProperty().putColor("ThreadView.PopupBG", color);
		}
		if (!cPopupAltBG.equals(color1)) {
			cPopupAltBG = color1;
			V2CMain.getUserProperty().putColor("ThreadView.PopupAltBG", color1);
		}
	}

	static void toggleFixPopup()
	{
		bFixPopup = !bFixPopup;
	}

	static void configThreadViewGeneral()
	{
		V2CResPopupSP v2crespopupsp = createResPopupSP();
		if (v2crespopupsp.showDialog())
			postConfigResPopup(v2crespopupsp, true);
	}

	static V2CResPopupSP createResPopupSP()
	{
		if (nMaxPopupWidth == 0 || nMaxPopupHeight == 0)
			calcMaxPopupSize();
		return new V2CResPopupSP(nMinResNumColumns, bRNZeroPadding, nMaxConsNL, fVWheelScrollFactor, bPopupWhenInactive,
				bPopupLineWrap, bOmitOriginalRes, nMaxPopupWidth, nMaxPopupHeight, nDefaultScale, bExpandGetDelPMItems);
	}

	static int postConfigResPopup(V2CResPopupSP v2crespopupsp, boolean flag)
	{
		int i = 0;
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		int j = Math.max(v2crespopupsp.getMaxConsNL(), 0);
		if (j != nMaxConsNL) {
			if (j > 0) {
				V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue();
				v2cpackedpropvalue.setInt('N', j);
				v2cproperty.putPackedValue("ThreadView.DispConvConf", v2cpackedpropvalue);
			}
			else {
				v2cproperty.remove("ThreadView.DispConvConf");
			}
			V2CThreadPanel.TPIterator tpiterator = V2CThreadPanel.getTPIterator();
			do {
				if (!tpiterator.hasNext())
					break;
				V2CThreadPanel v2cthreadpanel = tpiterator.next();
				if (!v2cthreadpanel.bAutoLoad)
					v2cthreadpanel.vtrThreadRes.clearDisplayConversion();
			} while (true);
			nMaxConsNL = j;
			i |= 8;
		}
		float f = Math.min(Math.max(0.1F, v2crespopupsp.getWheelScrollFactor()), 10F);
		if (f != fVWheelScrollFactor) {
			fVWheelScrollFactor = f;
			int k = (int) (f * 10F);
			if (k != 10) {
				V2CPackedPropValue v2cpackedpropvalue1 = new V2CPackedPropValue();
				v2cpackedpropvalue1.setInt('W', k);
				v2cproperty.putPackedValue("ThreadView.ScrollConf", v2cpackedpropvalue1);
			}
			else {
				v2cproperty.remove("ThreadView.ScrollConf");
			}
		}
		boolean flag1 = v2crespopupsp.getLineWrap();
		if (V2CApp.setBooleanUserProperty("ThreadView.PopupLineWrap", bPopupLineWrap, flag1, true))
			bPopupLineWrap = flag1;
		boolean flag2 = v2crespopupsp.getPopupWhenInactive();
		boolean flag3 = v2crespopupsp.getOmitOriginalRes();
		boolean flag4 = v2crespopupsp.getNoTextPUForEmptyResPU();
		if (flag3 != bOmitOriginalRes || flag2 != bPopupWhenInactive || flag4 != bNoTextPUForEmptyResPU) {
			bPopupWhenInactive = flag2;
			bOmitOriginalRes = flag3;
			bNoTextPUForEmptyResPU = flag4;
			if (flag2 || flag3 || flag4) {
				V2CPackedPropValue v2cpackedpropvalue2 = new V2CPackedPropValue();
				v2cpackedpropvalue2.setBoolean('I', flag2);
				v2cpackedpropvalue2.setBoolean('O', flag3);
				v2cpackedpropvalue2.setBoolean('N', flag4);
				v2cproperty.putPackedValue("ThreadView.PopupConf", v2cpackedpropvalue2);
			}
			else {
				v2cproperty.remove("ThreadView.PopupConf");
			}
		}
		int l = v2crespopupsp.getMaxWidth();
		int i1 = v2crespopupsp.getMaxHeight();
		if (l > 0 && i1 > 0 && (l != nMaxPopupWidth || i1 != nMaxPopupHeight)) {
			nMaxPopupWidth = l;
			nMaxPopupHeight = i1;
			v2cproperty.putDimension("ThreadView.MaxPopupSize", new Dimension(l, i1));
		}
		nDefaultScale = Math.min(Math.max(v2crespopupsp.getScale(), -3), 3);
		if (nDefaultScale != 0)
			v2cproperty.putInt("ThreadView.PopupScale", nDefaultScale);
		else
			v2cproperty.remove("ThreadView.PopupScale");
		int j1 = v2crespopupsp.getMinResNumColumns();
		if (j1 <= 1)
			j1 = 0;
		boolean flag5 = v2crespopupsp.getRNZeroPadding();
		boolean flag6 = v2crespopupsp.getShowSelRes();
		boolean flag7 = v2crespopupsp.getJumpByNumKey();
		boolean flag8 = v2crespopupsp.getDisableCtrlWheel();
		boolean flag9 = v2crespopupsp.getOmitSingleGTResRef();
		boolean flag10 = v2crespopupsp.getAlwaysShowResCheckBox();
		boolean flag11 = v2crespopupsp.getCopyWhenSelect();
		boolean flag12 = v2crespopupsp.jcbParseJPDomain.isSelected();
		boolean flag13 = v2crespopupsp.getResetUnreadWhenShown();
		boolean flag14 = v2crespopupsp.getExpandGetDelPMItems();
		int k1 = v2crespopupsp.getSmoothScrollStep();
		boolean flag15 = flag14 != bExpandGetDelPMItems;
		int l1 = v2crespopupsp.getDefRCFThreshold();
		if (flag6 != bShowSelRes || j1 != nMinResNumColumns || flag5 != bRNZeroPadding || flag7 != bJumpByNumKey
				|| flag8 != bDisableCtrlWheel || flag9 != bOmitSingleGTResRef || flag11 != bCopyWhenSelect
				|| flag12 != bParseJPDomain || flag13 != bResetUnreadWhenShown || flag15 || flag10 != bAlwaysShowResCheckBox
				|| k1 != nSmoothScrollStep || l1 != nDefRCFThreshold) {
			if (j1 != nMinResNumColumns || flag5 != bRNZeroPadding) {
				i |= 8;
				nMinResNumColumns = j1;
				bRNZeroPadding = flag5;
			}
			if (flag13 != bResetUnreadWhenShown)
				i |= 2;
			if (flag6 != bShowSelRes || flag10 != bAlwaysShowResCheckBox) {
				i |= 1;
				bShowSelRes = flag6;
				bAlwaysShowResCheckBox = flag10;
			}
			bJumpByNumKey = flag7;
			bDisableCtrlWheel = flag8;
			bOmitSingleGTResRef = flag9;
			bCopyWhenSelect = flag11;
			bParseJPDomain = flag12;
			bResetUnreadWhenShown = flag13;
			bExpandGetDelPMItems = flag14;
			nSmoothScrollStep = k1;
			nDefRCFThreshold = l1;
			saveMiscConf();
			if (flag15)
				V2CMain.clearMenus();
		}
		boolean flag16 = v2crespopupsp.getResAnchorExpand();
		boolean flag17 = v2crespopupsp.getExpandResAnchorBeforeMessage();
		boolean flag18 = v2crespopupsp.getUseCurrentStyleForInnerRes();
		boolean flag19 = v2crespopupsp.getNoThumbnailInInnerRes();
		int i2 = v2crespopupsp.getMaxResAnchorExpandNum();
		int j2 = v2crespopupsp.getMaxInnerResMsgLines();
		int k2 = v2crespopupsp.getMinInnerResIndex();
		if (flag16 != bDefExpandResAnchor || flag18 != bUseCurrentStyleForInnerRes || flag17 != bExpandResAnchorBeforeMessage
				|| flag19 != bNoThumbnailInInnerRes || i2 != nMaxResAnchorExpand || nMaxInnerResMsgLines != j2
				|| nMinInnerResIndex != k2) {
			bDefExpandResAnchor = flag16;
			if (i2 != nMaxResAnchorExpand) {
				nMaxResAnchorExpand = i2;
				ilInnerResDrawn = new int[i2];
				i |= 8;
			}
			if (j2 != nMaxInnerResMsgLines) {
				nMaxInnerResMsgLines = j2;
				i |= 8;
			}
			if (k2 != nMinInnerResIndex) {
				nMinInnerResIndex = k2;
				i |= 8;
			}
			if (flag19 != bNoThumbnailInInnerRes) {
				bNoThumbnailInInnerRes = flag19;
				i |= 8;
			}
			if (flag17 != bExpandResAnchorBeforeMessage) {
				bExpandResAnchorBeforeMessage = flag17;
				i |= 0x10;
			}
			if (flag18 != bUseCurrentStyleForInnerRes) {
				bUseCurrentStyleForInnerRes = flag18;
				V2CThreadPanel.notifyUseCurrentStyleForInnerResChanged();
				i &= -9;
			}
			saveResRefConf();
		}
		i |= v2crespopupsp.postConfig();
		if (flag)
			V2CThreadPanel.requestChange(i);
		return i;
	}

	static Dimension getMaxPopupSize()
	{
		if (nMaxPopupWidth == 0 || nMaxPopupHeight == 0)
			calcMaxPopupSize();
		return new Dimension(nMaxPopupWidth, nMaxPopupHeight);
	}

	static void calcMaxPopupSize()
	{
		V2CThreadViewPane v2cthreadviewpane = V2CMain.getDisplayPane();
		nMaxPopupWidth = v2cthreadviewpane.getWidth();
		nMaxPopupHeight = v2cthreadviewpane.getHeight();
		if (nMaxPopupWidth <= 0)
			nMaxPopupWidth = 400;
		if (nMaxPopupHeight <= 0)
			nMaxPopupHeight = 300;
	}

	public V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, int i, V2CPopupPos v2cpopuppos, int ai[])
	{
		this(v2cabstractthreadpanel, v2cabstractthreadpanel, i, v2cpopuppos, ai, -1, false, null);
	}

	public V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, int i, V2CPopupPos v2cpopuppos, int ai[], int j)
	{
		this(v2cabstractthreadpanel, v2cabstractthreadpanel, i, v2cpopuppos, ai, j, false, null);
	}

	public V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, int i, V2CPopupPos v2cpopuppos, int ai[], int j,
			V2CThreadPopupRequest v2cthreadpopuprequest)
	{
		this(v2cabstractthreadpanel, v2cabstractthreadpanel, i, v2cpopuppos, ai, j, false, v2cthreadpopuprequest);
	}

	public V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, int i, V2CPopupPos v2cpopuppos, int ai[], int j,
			boolean flag)
	{
		this(v2cabstractthreadpanel, v2cabstractthreadpanel, i, v2cpopuppos, ai, j, flag, null);
	}

	public V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, V2CAbstractThreadPanel v2cabstractthreadpanel1, int i,
			V2CPopupPos v2cpopuppos, int ai[])
	{
		this(v2cabstractthreadpanel, v2cabstractthreadpanel1, i, v2cpopuppos, ai, -1, false, null);
	}

	private V2CThreadPopup(V2CAbstractThreadPanel v2cabstractthreadpanel, V2CAbstractThreadPanel v2cabstractthreadpanel1, int i,
			V2CPopupPos v2cpopuppos, int ai[], int j, boolean flag, V2CThreadPopupRequest v2cthreadpopuprequest)
	{
		super(true, false, v2cabstractthreadpanel1.isTwitter());
		vPopupPos = v2cpopuppos;
		long l = System.currentTimeMillis();
		if (v2cthreadpopuprequest == null)
			v2cthreadpopuprequest = new V2CThreadPopupRequest();
		boolean flag1 = v2cthreadpopuprequest.getNoOwner();
		bInNotification = flag1;
		nPopupType = i;
		vtpParent = v2cabstractthreadpanel;
		vtpThreadParent = v2cabstractthreadpanel1;
		V2CThreadItem v2cthreaditem = v2cabstractthreadpanel1.vtiThreadItem;
		vtiThreadItem = v2cthreaditem;
		vtrThreadRes = v2cabstractthreadpanel1.vtrThreadRes;
		cTLType = v2cabstractthreadpanel1.cTLType;
		lTLOwnerID = v2cabstractthreadpanel1.lTLOwnerID;
		vTLOwner = v2cabstractthreadpanel1.vTLOwner;
		bShowNGRes = flag || v2cabstractthreadpanel.bShowNGRes;
		bLineWrap = bPopupLineWrap;
		nlDisplayIndex = ai;
		int k = ai.length;
		nDisplayIndex = k;
		if (k > 1 && getShowFromNewest() && ai[0] < ai[k - 1])
			V2CMiscUtil.revertIntArray(ai, k);
		if (bTwitter && V2CTwitterBBS.isHiddenThread(v2cthreaditem)) {
			V2CTwitterThreadRes v2ctwitterthreadres = (V2CTwitterThreadRes) vtrThreadRes;
			long al[] = new long[k];
			for (int i1 = k - 1; i1 >= 0; i1--) {
				V2CTweetItem v2ctweetitem = v2ctwitterthreadres.getTweetItem(ai[i1]);
				if (v2ctweetitem != null)
					al[i1] = v2ctweetitem.getTweetID();
			}

			ilTwID = al;
		}
		nlNLines = new int[k];
		nlWidths = new int[k];
		nllLayoutInfo = new int[k][];
		iResToMark = j;
		vNGWordMatrix = v2cabstractthreadpanel1.vNGWordMatrix;
		vNameKWHighlightSet = v2cabstractthreadpanel1.vNameKWHighlightSet;
		vKeywordHighlightSet = v2cabstractthreadpanel1.vKeywordHighlightSet;
		vSpecialKeywordHighlight = v2cabstractthreadpanel1.vSpecialKeywordHighlight;
		vTextMarker = v2cabstractthreadpanel1.vTextMarker;
		vResNote = v2cabstractthreadpanel1.vResNote;
		iBookMark = v2cabstractthreadpanel1.iBookMark;
		vNGTwitterUserSet = v2cabstractthreadpanel1.vNGTwitterUserSet;
		vNormalThreadStyle = vThreadStyle = V2CThreadStyle.getStyle(v2cthreaditem);
		getDefaultResStyle(true);
		setFocusable(false);
		createComponents();
		bStyleChanged = true;
		nScale = flag1 ? 0 : nDefaultScale;
		dScale = Math.pow(1.2D, nScale);
		fBoldOffset = (float) (1.0D / dScale);
		if (nScale != 0)
			fBoldOffset += 0.001F;
		Object obj = null;
		Object obj1 = v2cthreadpopuprequest.getOwnerFrame();
		bAltMode = V2CThreadPanel.getActivePanel().bAltMode;
		if (obj1 == null && !flag1) {
			if (v2cabstractthreadpanel != null) {
				Window window = SwingUtilities.getWindowAncestor(v2cabstractthreadpanel);
				if (window != null) {
					Window window1 = window.getOwner();
					if (window1 instanceof JFrame)
						obj1 = (JFrame) window1;
				}
			}
			if (obj1 == null)
				obj1 = V2CMain.v2cMain;
		}
		if (obj1 != null) {
			Component component;
			Object obj2;
			if (V2CMain.getUseJDialogForPopup()) {
				JDialog jdialog = new JDialog(((java.awt.Frame) (obj1)), false);
				obj2 = jdialog;
				jdialog.setUndecorated(true);
				jdialog.setContentPane(this);
				component = jdialog.getGlassPane();
				if (component instanceof JComponent)
					V2CInputMap.setKeyBind((JComponent) component, 0, "ThreadView");
			}
			else {
				JWindow jwindow = new JWindow(((java.awt.Frame) (obj1)));
				obj2 = jwindow;
				jwindow.setContentPane(this);
				component = jwindow.getGlassPane();
			}
			jwPopupWindow = ((Window) (obj2));
			GlassPaneMouseListener glasspanemouselistener = new GlassPaneMouseListener();
			component.addMouseListener(glasspanemouselistener);
			component.addMouseMotionListener(glasspanemouselistener);
			component.addMouseWheelListener(glasspanemouselistener);
			component.setVisible(true);
			((Window) (obj2)).setVisible(true);
			((Window) (obj2)).toFront();
			setPopupGeometry(0);
		}
		setSelTextIM(false);
		if (j >= 0 && k > 1) {
			int j1 = j;
			int k1 = 0;
			if (i == 0) {
				int l1 = ai[0];
				if (l1 < j)
					k1 = -lineHeight;
				else if (l1 == j)
					j1++;
				else
					j1 = -1;
			}
			if (j1 >= 0)
				goToResNumber(j1, k1);
		}
	}

	void createComponents()
	{
		createComponents(((javax.swing.event.MouseInputAdapter) (new PopupPopupListener())));
		setBackground(vtpThreadParent != vtpParent ? cPopupAltBG : cPopupBG);
		setBorder(BorderFactory.createLineBorder(vThreadStyle.getFrameColor()));
		Insets insets = getInsets();
		iInsLeft = insets.left;
		iInsTop = insets.top;
	}

	public void setCursor(Cursor cursor)
	{
		Component component = V2CSwingUtil.getGlassPane(jwPopupWindow);
		if (component != null)
			component.setCursor(cursor);
	}

	public V2CProgressState getProgressState()
	{
		return null;
	}

	public String getSaveTabString()
	{
		return null;
	}

	public void detouch()
	{
	}

	public boolean close()
	{
		bClosed = true;
		return true;
	}

	public boolean canLock()
	{
		return false;
	}

	public boolean isLocked()
	{
		return false;
	}

	public void setLocked(boolean flag)
	{
	}

	public void saveState()
	{
	}

	void toggleFloating(boolean flag)
	{
		if (flag && (vppChild instanceof V2CThreadPopup)) {
			((V2CThreadPopup) vppChild).toggleFloating(true);
			return;
		}
		boolean flag1 = !bFloating;
		bFloating = flag1;
		if (flag1) {
			setFocusable(true);
			V2CInputMap.setKeyBind(this, 0, "ThreadView");
			java.awt.Container container = V2CSwingUtil.getContentPane(jwPopupWindow);
			if (container instanceof JComponent)
				V2CInputMap.setKeyBind((JComponent) container, 1, "Global");
			jwPopupWindow.setVisible(false);
			SwingUtilities.invokeLater(new Runnable() {

				public void run()
				{
					jwPopupWindow.setVisible(true);
					jwPopupWindow.toFront();
				}
			});
			vtpParent = null;
			V2CAbstractThreadPanel v2cabstractthreadpanel = vtpThreadParent;
			if (!(v2cabstractthreadpanel instanceof V2CThreadPanel))
				vtpThreadParent = V2CThreadPanel.loadThreadIfNotLoaded(vtiThreadItem);
		}
		else {
			closePopupWindow();
		}
		V2CThreadPanel.floatingStateChanged(this);
	}

	void doLayoutWorks()
	{
		if (bClosed)
			return;
		nThreadDisplayHeight = getHeight();
		rDrawingArea = null;
		if (getWidth() > 1 && getHeight() > 1)
			resizeScrollBar();
	}

	boolean getShowFromNewest()
	{
		return bInNotification ? true : super.getShowFromNewest();
	}

	void filterNextThread(boolean flag)
	{
		filterNextThread(false, false, flag);
	}

	void resToThisRes(int ai[], boolean flag)
	{
		V2CAbstractThreadPanel v2cabstractthreadpanel = getRootPanel();
		V2CThreadPanel v2cthreadpanel;
		if ((v2cabstractthreadpanel instanceof V2CThreadPanel) && v2cabstractthreadpanel.vtiThreadItem == vtiThreadItem) {
			v2cthreadpanel = (V2CThreadPanel) v2cabstractthreadpanel;
		}
		else {
			v2cthreadpanel = V2CThreadPanel.getOpenPanel(vtiThreadItem);
			if (v2cthreadpanel == null)
				return;
		}
		v2cthreadpanel.resToThisRes(ai, flag);
	}

	void resNumClicked(int i)
	{
		resNumClicked(i, true);
	}

	private void resNumClicked(int i, boolean flag)
	{
		V2CAbstractThreadPanel v2cabstractthreadpanel = getRootPanel();
		if ((v2cabstractthreadpanel instanceof V2CThreadPanel) && ((V2CThreadPanel) v2cabstractthreadpanel).isAttached()
				&& v2cabstractthreadpanel.getThreadItem() == vtiThreadItem) {
			if (flag)
				((V2CThreadPanel) v2cabstractthreadpanel).resNumClicked(i, true);
			else
				((V2CThreadPanel) v2cabstractthreadpanel).resLinkClicked(i, true);
		}
		else {
			V2CThreadOpenRequest v2cthreadopenrequest = new V2CThreadOpenRequest();
			v2cthreadopenrequest.setResNumToGo(i);
			V2CThreadPanel.open(vtiThreadItem, false, true, v2cthreadopenrequest);
		}
	}

	void resLinkClicked(int i)
	{
		resNumClicked(i, false);
	}

	void applyNGWord()
	{
		if (vtpParent != null)
			vtpParent.applyNGWord();
	}

	void setHideThisRes(int ai[], boolean flag, boolean flag1)
	{
		V2CThreadPanel v2cthreadpanel = V2CThreadPanel.getOpenPanel(vtiThreadItem);
		if (v2cthreadpanel != null)
			v2cthreadpanel.setHideThisRes(ai, flag, flag1);
		else if (setHideThisRes0(ai, flag, flag1)) {
			V2CThreadPanel v2cthreadpanel1 = V2CThreadPanel.getActivePanel();
			if (v2cthreadpanel1 != null)
				v2cthreadpanel1.closeChildPopups(true);
		}
	}

	public void paintComponent(Graphics g)
	{
		if (!bGeometrySet || bClosed)
			return;
		if (bTwitter && ilTwID != null) {
			V2CTwitterThreadRes v2ctwitterthreadres = (V2CTwitterThreadRes) vtrThreadRes;
			long al[] = ilTwID;
			int i = al.length;
			label0: for (int j = i - 1; j >= 0; j--) {
				long l = al[j];
				if (l <= 0L)
					continue;
				V2CTweetItem v2ctweetitem = v2ctwitterthreadres.getTweetItem(nlDisplayIndex[j]);
				long l1 = v2ctweetitem.getTweetID();
				if (v2ctweetitem == null || l1 == l)
					continue;
				int k = v2ctwitterthreadres.getNRes();
				int i1 = k - 1;
				do {
					if (i1 < 0)
						continue label0;
					V2CTweetItem v2ctweetitem1 = v2ctwitterthreadres.getTweetItem(i1);
					if (v2ctweetitem1 != null && v2ctweetitem1.getTweetID() == l) {
						nlDisplayIndex[j] = i1;
						continue label0;
					}
					i1--;
				} while (true);
			}

		}
		Graphics2D graphics2d = (Graphics2D) g.create();
		draw(graphics2d);
		graphics2d.dispose();
	}

	boolean checkContentHeight()
	{
		return true;
	}

	void toggleAltFont()
	{
		if (vppChild instanceof V2CThreadPopup)
			((V2CThreadPopup) vppChild).toggleAltFont();
		else
			EventQueue.invokeLater(new Runnable() {

				public void run()
				{
					bAltMode = !bAltMode;
					rememberViewPosition();
					setPopupGeometry(0);
					repaint();
//					V2CThreadPanel v2cthreadpanel = V2CThreadPanel.getActivePanel();
//					v2cthreadpanel.bAltMode = bAltMode;
//					v2cthreadpanel.repaint();
				}
			});
	}

	void toggleTempShowNGRes()
	{
		if (vppChild instanceof V2CThreadPopup)
			((V2CThreadPopup) vppChild).toggleTempShowNGRes();
		else
			EventQueue.invokeLater(new Runnable() {

				public void run()
				{
					bShowNGRes = !bShowNGRes;
					rememberViewPosition();
					setPopupGeometry(0);
					repaint();
				}
			});
	}

	void imageInserted(int i, boolean flag)
	{
		int j = nDisplayIndex;
		boolean flag1 = false;
		if (i >= 0) {
			boolean flag2 = getShowFromNewest();
			int ai1[] = nlDisplayIndex;
			int l = 0;
			do {
				if (l >= j)
					break;
				int i1 = ai1[l];
				if (i1 == i) {
					flag1 = true;
					int j1 = nlNLines[l];
					if (j1 > 0)
						nlNLines[l] = -j1;
					break;
				}
				if (flag2 ? i1 < i : i1 > i)
					break;
				l++;
			} while (true);
		}
		else {
			int ai[] = nlNLines;
			int k = 0;
			do {
				if (k >= j)
					break;
				if (ai[k] < 0) {
					flag1 = true;
					break;
				}
				k++;
			} while (true);
		}
		if (flag && flag1 && !bSetPopupGeometryArmed) {
			bSetPopupGeometryArmed = true;
			EventQueue.invokeLater(new Runnable() {

				public void run()
				{
					bSetPopupGeometryArmed = false;
					rememberViewPosition();
					setPopupGeometry(vtrThreadRes.getNRes());
					repaint();
				}
			});
		}
		if (vppChild instanceof V2CThreadPopup)
			((V2CThreadPopup) vppChild).imageInserted(i, flag);
	}

	int getMinContentWidth()
	{
		return nDrawingWidth;
	}

	int getDrawingWidth()
	{
		return nDrawingWidth0;
	}

	Dimension calcGeometry(int i)
	{
		Insets insets = getInsets();
		if (nMaxPopupHeight == 0)
			calcMaxPopupSize();
		int j = nMaxPopupHeight;
		Graphics2D graphics2d = (Graphics2D) getGraphics();
		if (graphics2d == null)
			graphics2d = getBufferGraphics();
		boolean flag = nScale == 0;
		int k = i - insets.left - nScrollBarWidth;
		int l = flag ? k : (int) Math.ceil((double) k / dScale);
		Dimension dimension = calcSize(graphics2d, insets.left, i, 0);
		if (dimension == null)
			return null;
		graphics2d.dispose();
		bContentHeightCalculated = true;
		int i1 = dimension.width;
		int j1 = dimension.height;
		nDrawingWidth = i1;
		boolean flag1 = i1 > i;
		int k1 = j - insets.top - (flag1 ? nScrollBarWidth : insets.bottom);
		int l1 = flag ? k1 : (int) Math.ceil((double) k1 / dScale);
		boolean flag2 = j1 > l1;
		if (!flag) {
			i1 = (int) ((double) i1 * dScale);
			j1 = (int) ((double) j1 * dScale);
		}
		i1 += insets.left + (flag2 ? nScrollBarWidth : insets.right);
		j1 += insets.top + (flag1 ? nScrollBarWidth : insets.bottom);
		i = Math.min(i, flag1 ? flag2 ? i : i - nScrollBarWidth : i1);
		j = Math.min(j, j1);
		dimension.setSize(i, j);
		setPreferredSize(dimension);
		bGeometrySet = true;
		return dimension;
	}

	void setPopupGeometry(int i)
	{
		V2CPopupPos v2cpopuppos = vPopupPos;
		Point point = null;
		if (v2cpopuppos != null)
			point = v2cpopuppos.vNormalPopupPoint;
		if (point == null)
			point = jwPopupWindow.getLocation();
		Rectangle rectangle = V2CSwingUtil.getScreenBoundsAt(point);
		rScreenBounds = rectangle;
		Insets insets = getInsets();
		if (nMaxPopupWidth == 0 || nMaxPopupHeight == 0)
			calcMaxPopupSize();
		int j = Math.min(nMaxPopupWidth, rectangle.width - 2);
		int k = Math.min(nMaxPopupHeight, rectangle.height - 2);
		Graphics2D graphics2d = (Graphics2D) getGraphics();
		if (graphics2d == null)
			graphics2d = getBufferGraphics();
		boolean flag = nScale == 0;
		int l = j - insets.left - nScrollBarWidth;
		int i1 = flag ? l : (int) Math.ceil((double) l / dScale);
		Dimension dimension = calcSize(graphics2d, insets.left, bLineWrap ? i1 : 0x186a0, i);
		graphics2d.dispose();
		if (dimension == null)
			return;
		bContentHeightCalculated = true;
		int j1 = dimension.width;
		int k1 = dimension.height;
		nDrawingWidth = j1;
		boolean flag1 = j1 > i1;
		int l1 = k - insets.top - (flag1 ? nScrollBarWidth : insets.bottom);
		int i2 = flag ? l1 : (int) Math.ceil((double) l1 / dScale);
		boolean flag2 = k1 > i2;
		if (!flag) {
			j1 = (int) ((double) j1 * dScale);
			k1 = (int) ((double) k1 * dScale);
		}
		j1 += insets.left + (flag2 ? nScrollBarWidth : insets.right);
		k1 += insets.top + (flag1 ? nScrollBarWidth : insets.bottom);
		j = Math.min(j, flag1 ? flag2 ? j : j - nScrollBarWidth : j1);
		k = Math.min(k, k1);
		dimension.setSize(j, k);
		setPreferredSize(dimension);
		invalidate();
		bGeometrySet = true;
		int j2 = (int) point.getX();
		int k2 = (int) point.getY();
		if (j2 + j + 2 > rectangle.x + rectangle.width) {
			j2 = (rectangle.x + rectangle.width) - j - 1;
			if (v2cpopuppos != null) {
				Point point1 = v2cpopuppos.vMousePoint;
				Rectangle rectangle1 = v2cpopuppos.vPopupRegion;
				if (point1 != null && rectangle1 != null && j2 <= point1.x) {
					k2 = point1.y + 3;
					if (k2 >= rectangle1.y + rectangle1.height)
						k2 = (rectangle1.y + rectangle1.height) - 1;
				}
			}
		}
		if (k2 + k + 2 > rectangle.y + rectangle.height)
			k2 = (rectangle.y + rectangle.height) - k - 1;
		jwPopupWindow.setLocation(j2, k2);
		jwPopupWindow.pack();
		setVerticalScrollBar(V2CMiscUtil.divideCeil(dimension.height - insets.top - (flag1 ? nScrollBarWidth : insets.bottom),
				dScale));
		nDrawingWidth0 = dimension.width - insets.left - (bVSBShown ? jsbVertical.getWidth() : insets.right);
		if (nScale != 0)
			nDrawingWidth0 = V2CMiscUtil.divideCeil(nDrawingWidth0, dScale);
		setHorizontalScrollBar();
		vPopupPos = null;
	}

	public boolean isCloseOnExit()
	{
		return !bFixPopup;
	}

	public void closePopupWindow()
	{
		V2CThreadPanel v2cthreadpanel = V2CThreadPanel.getActivePanel();
		v2cthreadpanel.bAltMode = bAltMode;
		stopTimer(true);
		closeChildPopups(false);
		if (!bFloating) {
			bClosed = true;
			jwPopupWindow.dispose();
		}
	}

	boolean checkMousePressInOtherMode(MouseEvent mouseevent, boolean flag)
	{
		return false;
	}

	static final String sPopupLineWrapKey = "ThreadView.PopupLineWrap";
	static final String sPopupBGKey = "ThreadView.PopupBG";
	static final String sPopupAltBGKey = "ThreadView.PopupAltBG";
	static final String sMaxPopupSizeKey = "ThreadView.MaxPopupSize";
	static final String sPopupScaleKey = "ThreadView.PopupScale";
	static boolean bPopupLineWrap;
	static Color cPopupBG;
	static Color cPopupAltBG;
	static int nMaxPopupWidth;
	static int nMaxPopupHeight;
	static int nDefaultScale;
	static boolean bFixPopup;
	final boolean bInNotification;
	Window jwPopupWindow;
	Rectangle rScreenBounds;
	V2CPopupPos vPopupPos;
	long ilTwID[];
	boolean bGeometrySet;
	int nDrawingWidth0;
	int nDrawingWidth;
	volatile boolean bSetPopupGeometryArmed;

	static {
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		bPopupLineWrap = v2cproperty.getBoolean("ThreadView.PopupLineWrap", true);
		cPopupBG = v2cproperty.getColor("ThreadView.PopupBG", null);
		if (cPopupBG == null)
			cPopupBG = new Color(1.0F, 1.0F, 0.9F);
		cPopupAltBG = v2cproperty.getColor("ThreadView.PopupAltBG", null);
		if (cPopupAltBG == null)
			cPopupAltBG = new Color(0.975F, 0.975F, 1.0F);
		Dimension dimension = v2cproperty.getDimension("ThreadView.MaxPopupSize");
		if (dimension != null) {
			nMaxPopupWidth = dimension.width;
			nMaxPopupHeight = dimension.height;
		}
		nDefaultScale = Math.min(Math.max(v2cproperty.getInt("ThreadView.PopupScale"), -3), 3);
	}
}
