package org.monazilla.v2c;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import javax.imageio.ImageIO;
import javax.swing.CellRendererPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class V2CThreadGraph
{
	private class GraphSaver extends Thread
	{

		public void run()
        {
            boolean flag = false;
            try
            {
                SwingUtilities.invokeAndWait(new Runnable() {

                    public void run()
                    {
                        biImage = (BufferedImage)vThreadPanel.createImage(nWidth, nHeight);
                        Graphics2D graphics2d = biImage.createGraphics();
                        boolean flag1 = V2CThreadGraph.bHighRenderingQuality;
                        V2CThreadGraph.bHighRenderingQuality = true;
                        try
                        {
                            drawGraph(graphics2d, new Rectangle(nWidth, nHeight), true);
                        }
                        finally
                        {
                            V2CThreadGraph.bHighRenderingQuality = flag1;
                            graphics2d.dispose();
                        }
                    }
                });
            }
            catch(InvocationTargetException invocationtargetexception)
            {
                return;
            }
            catch(InterruptedException interruptedexception)
            {
                return;
            }
            vProgressPanel.setMessage("保存中…");
            try
            {
                flag = ImageIO.write(biImage, "png", fSaveFile);
            }
            catch(IOException ioexception)
            {
                ioexception.printStackTrace();
            }
            finally {
            	vProgressPanel.hidePanel();
	        }
        	if(!flag && !Thread.currentThread().isInterrupted())
                V2CSwingUtil.showMessageLater("グラフの保存に失敗しました。", "error", 0);
        }

		File fSaveFile;
		int nWidth;
		int nHeight;
		V2CProgressPanel vProgressPanel;
		BufferedImage biImage;

		GraphSaver(File file, int i, int j, V2CProgressPanel v2cprogresspanel)
		{
			super();
			fSaveFile = file;
			nWidth = i;
			nHeight = j;
			vProgressPanel = v2cprogresspanel;
		}
	}

	static void setHighRenderingQuality(boolean flag)
	{
		bHighRenderingQuality = flag;
	}

	static void setDrawCapMarkers(boolean flag, boolean flag1)
	{
		bDrawCapMarkers = flag;
		bDrawCapNames = flag1;
	}

	static void setDrawThreadInfo(boolean flag)
	{
		bDrawThreadInfo = flag;
	}

	static void setDrawResLabel(boolean flag)
	{
		bDrawResLabel = flag;
	}

	static void setDrawSpeed(boolean flag)
	{
		bDrawSpeed = flag;
	}

	static void saveColor()
	{
		V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue();
		v2cpackedpropvalue.setColor('B', cBGOut);
		v2cpackedpropvalue.setColor('C', cCursor);
		v2cpackedpropvalue.setColor('F', cFrame);
		v2cpackedpropvalue.setColor('G', cGrid);
		v2cpackedpropvalue.setColor('I', cBGIn);
		v2cpackedpropvalue.setColor('L', cLine);
		v2cpackedpropvalue.setColor('N', cNewMark);
		v2cpackedpropvalue.setColor('R', cReference);
		v2cpackedpropvalue.setColor('S', cSpeed);
		v2cpackedpropvalue.setColor('T', cCursorLetter);
		if (bDrawResLabel)
			v2cpackedpropvalue.setBoolean('L', true);
		V2CApp.getUserProperty().putPackedValue("ThreadGraph.Cond", v2cpackedpropvalue);
	}

	static void saveStates()
	{
		V2CProperty v2cproperty = V2CApp.getUserProperty();
		if (nRefResMarkers != 10)
			v2cproperty.putInt("ThreadGraph.NumRefResMarkers", nRefResMarkers);
		else
			v2cproperty.remove("ThreadGraph.NumRefResMarkers");
		if (nRefResNumbers > 0)
			v2cproperty.putInt("ThreadGraph.NumRefResNumbers", nRefResNumbers);
		else
			v2cproperty.remove("ThreadGraph.NumRefResNumbers");
		if (bHighRenderingQuality)
			v2cproperty.putBoolean("ThreadGraph.HighRenderingQuality", true);
		else
			v2cproperty.remove("ThreadGraph.HighRenderingQuality");
		if (bDrawCapMarkers)
			v2cproperty.put("ThreadGraph.DrawCapMarkers", bDrawCapNames ? "F" : "M");
		else
			v2cproperty.remove("ThreadGraph.DrawCapMarkers");
		if (bDrawThreadInfo)
			v2cproperty.putBoolean("ThreadGraph.DrawThreadInfo", true);
		else
			v2cproperty.remove("ThreadGraph.DrawThreadInfo");
		if (bDrawSpeed)
			v2cproperty.putBoolean("ThreadGraph.DrawSpeed", true);
		else
			v2cproperty.remove("ThreadGraph.DrawSpeed");
		saveColor();
	}

	private static Rectangle2D getStringBounds(Graphics2D graphics2d, Font font, String s)
	{
		return font.getStringBounds(s, graphics2d.getFontRenderContext());
	}

	private static Rectangle2D drawString(Graphics2D graphics2d, Font font, Color color, boolean flag, String s, int i, int j,
			int k)
	{
		Rectangle2D rectangle2d = getStringBounds(graphics2d, font, s);
		switch (k) {
			case 13: // '\r'
				i -= (int) rectangle2d.getWidth();
				j -= (int) rectangle2d.getY() / 2;
				break;

			case 17: // '\021'
				j -= (int) rectangle2d.getY() / 2;
				break;

			case 11: // '\013'
				i -= (int) rectangle2d.getWidth() / 2;
				j += (int) rectangle2d.getHeight();
				break;

			case 18: // '\022'
				j += (int) rectangle2d.getHeight();
				break;

			case 14: // '\016'
				i -= (int) rectangle2d.getWidth();
				break;
		}
		graphics2d.setFont(font);
		graphics2d.setColor(color);
		graphics2d.drawString(s, i, j);
		if (!bHighRenderingQuality && flag)
			graphics2d.drawString(s, i + 1, j);
		rectangle2d.setFrame(i, (double) j + rectangle2d.getY(), rectangle2d.getWidth(), rectangle2d.getHeight());
		return rectangle2d;
	}

	private static GeneralPath createStar(int i)
	{
		float f = (float) Math.cos(0.62831853071795862D);
		float f1 = (float) Math.cos(1.2566370614359172D);
		float f2 = (float) Math.sin(1.2566370614359172D);
		float f3 = (float) Math.cos(2.5132741228718345D);
		float f4 = (float) Math.sin(2.5132741228718345D);
		float f5 = -i;
		float f6 = f2 * f5;
		float f7 = f1 * f5;
		float f8 = f4 * f5;
		float f9 = f3 * f5;
		float f10 = ((float) i / f / 2.0F) * 0.7F;
		float f11 = -f2 * f10;
		float f12 = f1 * f10;
		float f13 = -f4 * f10;
		float f14 = f3 * f10;
		GeneralPath generalpath = new GeneralPath();
		generalpath.moveTo(0.0F, f5);
		generalpath.lineTo(-f13, f14);
		generalpath.lineTo(-f6, f7);
		generalpath.lineTo(-f11, f12);
		generalpath.lineTo(-f8, f9);
		generalpath.lineTo(0.0F, f10);
		generalpath.lineTo(f8, f9);
		generalpath.lineTo(f11, f12);
		generalpath.lineTo(f6, f7);
		generalpath.lineTo(f13, f14);
		generalpath.closePath();
		return generalpath;
	}

	public V2CThreadGraph(V2CThreadPanel v2cthreadpanel)
	{
		nXCursor = -1;
		nYCursor = -1;
		vThreadPanel = v2cthreadpanel;
		Font font = v2cthreadpanel.vDefResStyle.getMessageFont()[0].getAwtFont();
		fGraphCursorFont = font;
		fGraphFont = font.deriveFont((float) font.getSize() * 0.9F);
		fMarkerLabelFont = fGraphFont;
		nGResNum = -1;
	}

	void clear()
	{
		llTime = null;
		nlXGArray = null;
	}

	private static boolean selectedStringChanged(String s, String s1)
	{
		return s == null ? s1 != null : !s.equals(s1);
	}

	void requestRedraw(V2CGraphController v2cgraphcontroller, V2CNameRankingPanel v2cnamerankingpanel, boolean flag)
	{
		boolean flag1 = flag;
		String s = v2cnamerankingpanel.getSelectedName();
		if (!flag1)
			flag1 = selectedStringChanged(s, sSelectedName);
		sSelectedName = s;
		String s1 = v2cnamerankingpanel.getSelectedCap();
		if (!flag1)
			flag1 = selectedStringChanged(s1, sSelectedCap);
		sSelectedCap = s1;
		String s2 = v2cnamerankingpanel.getSelectedTrip();
		if (!flag1)
			flag1 = selectedStringChanged(s2, sSelectedTrip);
		sSelectedTrip = s2;
		String s3 = v2cnamerankingpanel.getSelectedID();
		if (!flag1)
			flag1 = selectedStringChanged(s3, sSelectedID);
		sSelectedID = s3;
		char c = v2cnamerankingpanel.getSelectedPostDevice();
		if (!flag1)
			flag1 = c != cSelectedPostDevice;
		cSelectedPostDevice = c;
		int i = v2cnamerankingpanel.getSelectedBE();
		if (!flag1)
			flag1 = i > 0;
		iSelectedBE = i;
		String s4 = v2cnamerankingpanel.getSelectedAux();
		if (!flag1)
			flag1 = selectedStringChanged(s4, sSelectedAux);
		sSelectedAux = s4;
		int j = v2cgraphcontroller.getReferredNums();
		if (j != nRefResMarkers) {
			nRefResMarkers = j;
			flag1 = true;
		}
		int k = v2cgraphcontroller.getReferredNumNums();
		if (k != nRefResNumbers) {
			nRefResNumbers = k;
			flag1 = true;
		}
		if (flag1)
			vThreadPanel.repaint();
	}

	static V2CGraphSP createGraphSP()
	{
		return new V2CGraphSP(nRefResMarkers, nRefResNumbers, bDrawCapMarkers, bDrawCapNames, bDrawThreadInfo, bDrawResLabel,
				bDrawSpeed, bHighRenderingQuality);
	}

	static int postConfig(V2CGraphSP v2cgraphsp)
	{
		boolean flag = false;
		boolean flag1 = v2cgraphsp.jcbDrawCapMarkers.isSelected();
		if (flag1 != bDrawCapMarkers) {
			bDrawCapMarkers = flag1;
			flag = true;
		}
		flag1 = v2cgraphsp.jcbDrawCapNames.isSelected();
		if (flag1 != bDrawCapNames) {
			bDrawCapNames = flag1;
			flag = true;
		}
		flag1 = v2cgraphsp.jcbDrawThreadInfo.isSelected();
		if (flag1 != bDrawThreadInfo) {
			bDrawThreadInfo = flag1;
			flag = true;
		}
		flag1 = v2cgraphsp.jcbDrawResLabel.isSelected();
		if (flag1 != bDrawResLabel) {
			bDrawResLabel = flag1;
			flag = true;
		}
		flag1 = v2cgraphsp.jcbDrawSpeed.isSelected();
		if (flag1 != bDrawSpeed) {
			bDrawSpeed = flag1;
			flag = true;
		}
		flag1 = v2cgraphsp.jcbHighRenderingQuality.isSelected();
		if (flag1 != bHighRenderingQuality) {
			bHighRenderingQuality = flag1;
			flag = true;
		}
		int i = v2cgraphsp.getReferredNums();
		if (i != nRefResMarkers) {
			nRefResMarkers = i;
			flag = true;
		}
		int j = v2cgraphsp.getReferredNumNums();
		if (j != nRefResNumbers) {
			nRefResNumbers = j;
			flag = true;
		}
		if (flag)
			saveStates();
		return flag ? 1 : 0;
	}

	void showController()
	{
		V2CGraphController v2cgraphcontroller = new V2CGraphController(this, vThreadPanel.getThreadRes(), nRefResMarkers,
				nRefResNumbers, bDrawCapMarkers, bDrawCapNames, bDrawThreadInfo, bDrawResLabel, bDrawSpeed, bHighRenderingQuality);
		V2CNameRankingPanel v2cnamerankingpanel = v2cgraphcontroller.getRankingPanel();
		if (sSelectedName != null)
			v2cnamerankingpanel.setSelectedName(sSelectedName, false);
		else if (sSelectedCap != null)
			v2cnamerankingpanel.setSelectedCap(sSelectedCap);
		else if (sSelectedTrip != null)
			v2cnamerankingpanel.setSelectedTrip(sSelectedTrip);
		else if (sSelectedID != null)
			v2cnamerankingpanel.setSelectedID(sSelectedID);
		else if (cSelectedPostDevice > 0)
			v2cnamerankingpanel.setSelectedPostDevice(cSelectedPostDevice);
		else if (iSelectedBE > 0)
			v2cnamerankingpanel.setSelectedBE(iSelectedBE);
		else if (sSelectedAux != null)
			v2cnamerankingpanel.setSelectedAux(sSelectedAux);
		v2cgraphcontroller.showDialog();
	}

	String createSaveFileName()
	{
		V2CThreadItem v2cthreaditem = vThreadPanel.getThreadItem();
		StringBuffer stringbuffer = new StringBuffer(20);
		stringbuffer.append("graph");
		String s = v2cthreaditem.getBoardString();
		if (s != null && s.length() > 0) {
			stringbuffer.append('_');
			stringbuffer.append(s);
		}
		String s1 = v2cthreaditem.getThreadKey();
		if (s1 != null && s1.length() > 0) {
			stringbuffer.append('_');
			stringbuffer.append(s1);
		}
		stringbuffer.append(".png");
		return stringbuffer.toString();
	}

	void saveGraph()
	{
		File file = V2CLink.getImageSaveDir(vThreadPanel.getThreadItem());
		V2CGraphSavePanel v2cgraphsavepanel = new V2CGraphSavePanel();
		JFileChooser jfilechooser = V2CSwingUtil.createFileChooser(file);
		jfilechooser.setAccessory(v2cgraphsavepanel);
		jfilechooser.setSelectedFile(new File(file, createSaveFileName()));
		int i = jfilechooser.showSaveDialog(V2CMain.v2cMain);
		if (i != 0)
			return;
		File file1 = jfilechooser.getSelectedFile();
		V2CLink.saveLastImageSaveDir(file1, true);
		v2cgraphsavepanel.saveCondition();
		if (file1.exists()) {
			if (!file1.canWrite()) {
				V2CSwingUtil
						.showErrorMessage("対象ファイルに書き込めません");
				return;
			}
			int j = JOptionPane.showConfirmDialog(V2CMain.v2cMain, V2CJStr.getFileExistsMessage(file1), "Warning", 2, 2);
			if (j != 0)
				return;
		}
		int k;
		int l;
		if (v2cgraphsavepanel.useCustomeSize()) {
			k = v2cgraphsavepanel.getGraphWidth();
			l = v2cgraphsavepanel.getGraphHeight();
		}
		else {
			Rectangle rectangle = vThreadPanel.getRealDrawingRect();
			k = rectangle.width;
			l = rectangle.height;
		}
		V2CProgressPanel v2cprogresspanel = new V2CProgressPanel("描画中…", "グラフ描画");
		GraphSaver graphsaver = new GraphSaver(file1, k, l, v2cprogresspanel);
		graphsaver.start();
		if (!v2cprogresspanel.showPanel()) {
			graphsaver.interrupt();
			return;
		}
		else {
			return;
		}
	}

	int getResNumToPopup(Point point)
	{
		setInFrame(point);
		if (bInFrame) {
			int ai[] = nlRefMarkers;
			if (ai != null) {
				int i = point.x;
				int j = point.y;
				short aword0[] = nlRefMarkerRadius;
				int ai1[] = nlXGArray;
				float f = 3.402823E+038F;
				int k = -1;
				for (int l = 0; l < ai.length; l++) {
					int i1 = ai[l];
					int j1 = nlXGArray[i1];
					int k1 = nYGBottom - (int) (dYScale * (double) i1);
					float f1 = (float) Math.sqrt(Math.pow(j1 - i, 2D) + Math.pow(k1 - j, 2D));
					if ((int) f1 <= aword0[l] && f1 < f) {
						k = i1;
						f = f1;
					}
				}

				if (k >= 0)
					return k;
			}
		}
		return nGResNum;
	}

	void setResNumToGo(int i)
	{
		nGResNum = i;
		bWheel = true;
	}

	int getResNumToGo(boolean flag)
	{
		return (!flag || !bInFrame) && !bWheel ? -1 : nGResNum;
	}

	void setRenderingQuality(Graphics2D graphics2d, boolean flag)
	{
		boolean flag1 = bHighRenderingQuality;
		if (flag) {
			graphics2d.setRenderingHint(RenderingHints.KEY_RENDERING, flag1 ? RenderingHints.VALUE_RENDER_QUALITY
					: RenderingHints.VALUE_RENDER_SPEED);
			graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, flag1 ? RenderingHints.VALUE_ANTIALIAS_ON
					: RenderingHints.VALUE_ANTIALIAS_OFF);
		}
		graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, flag1 ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON
				: RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
	}

	void clearGraphCursor(Graphics2D graphics2d)
	{
		java.awt.Image image = vThreadPanel.getImageBuffer();
		if (nXCursor >= 0)
			graphics2d.drawImage(image, nXCursor, nYGBottom + 1, nXCursor + 1, nYGTop, nXCursor, nYGBottom + 1, nXCursor + 1,
					nYGTop, null);
		if (nYCursor >= 0)
			graphics2d.drawImage(image, nXGLeft, nYCursor, nXGRight + 1, nYCursor + 1, nXGLeft, nYCursor, nXGRight + 1,
					nYCursor + 1, null);
		if (nXCursor >= 0 && nYCursor >= 0)
			graphics2d.drawImage(image, nXCursor - 10, nYCursor - 10, nXCursor + 10 + 1, nYCursor + 10 + 1, nXCursor - 10,
					nYCursor - 10, nXCursor + 10 + 1, nYCursor + 10 + 1, null);
		if (r2dNRes != null) {
			int i = (int) r2dNRes.getMinX();
			int k = (int) r2dNRes.getMaxX() + 1;
			int i1 = (int) r2dNRes.getMinY();
			int k1 = (int) r2dNRes.getMaxY() + 1;
			graphics2d.drawImage(image, i, i1, k, k1, i, i1, k, k1, null);
			r2dNRes = null;
		}
		if (r2dTRes != null) {
			int j = (int) r2dTRes.getMinX();
			int l = (int) r2dTRes.getMaxX() + 1;
			int j1 = (int) r2dTRes.getMinY();
			int l1 = (int) r2dTRes.getMaxY() + 1;
			graphics2d.drawImage(image, j, j1, l, l1, j, j1, l, l1, null);
			r2dTRes = null;
		}
	}

	void drawGraphCursor(Graphics2D graphics2d, int i)
	{
		nGResNum = i;
		nXCursor = nlXGArray[i];
		nYCursor = nYGBottom - (int) (dYScale * (double) i);
		graphics2d.setColor(cCursor);
		if (nXCursor > nXGLeft + 10) {
			int j = nXCursor - 10;
			graphics2d.drawLine(nXGLeft, nYCursor, j, nYCursor);
			graphics2d.drawLine(j, nYCursor - 2, j, nYCursor + 2);
		}
		if (nXCursor < nXGRight - 10) {
			int k = nXCursor + 10;
			graphics2d.drawLine(k, nYCursor, nXGRight, nYCursor);
			graphics2d.drawLine(k, nYCursor - 2, k, nYCursor + 2);
		}
		if (nYCursor > nYGTop + 10) {
			int l = nYCursor - 10;
			graphics2d.drawLine(nXCursor, nYGTop, nXCursor, l);
			graphics2d.drawLine(nXCursor - 2, l, nXCursor + 2, l);
		}
		if (nYCursor < nYGBottom - 10) {
			int i1 = nYCursor + 10;
			graphics2d.drawLine(nXCursor, i1, nXCursor, nYGBottom);
			graphics2d.drawLine(nXCursor - 2, i1, nXCursor + 2, i1);
		}
		r2dNRes = drawString(graphics2d, fGraphCursorFont, cCursorLetter, true, String.valueOf(i + 1), nXCursor - 5,
				nYCursor - 5, 14);
		V2CThreadRes v2cthreadres = vThreadPanel.getThreadRes();
		V2CResItem v2cresitem = null;
		for (int j1 = i; j1 < v2cthreadres.getNRes() && (v2cresitem = v2cthreadres.getResItem(j1)) == null; j1++)
			;
		long l1 = v2cresitem == null ? 0L : v2cresitem.getTime();
		if (l1 > 0L) {
			Date date = new Date(l1);
			int k1 = nYCursor + 5;
			graphics2d.setColor(cCursorLetter);
			Rectangle2D rectangle2d = drawString(graphics2d, fGraphCursorFont, cCursorLetter, true,
					(v2cresitem.hasSecond() ? dfTRes1sw : dfTRes1p).format(date), nXCursor + 5, k1, 18);
			k1 += (int) rectangle2d.getHeight() + 1;
			Rectangle2D rectangle2d1 = drawString(graphics2d, fGraphCursorFont, cCursorLetter, true, dfTRes2.format(date),
					nXCursor + 5, k1, 18);
			r2dTRes = rectangle2d.createUnion(rectangle2d1);
		}
	}

	void updateGraphCursor(Point point)
	{
		if (!bGraphDrawn)
			return;
		Graphics2D graphics2d = (Graphics2D) vThreadPanel.getGraphics();
		graphics2d.setClip(vThreadPanel.getRealDrawingRect());
		setRenderingQuality(graphics2d, false);
		if (point == null) {
			clearGraphCursor(graphics2d);
			return;
		}
		int i = vThreadPanel.getWidth();
		int j = vThreadPanel.getDrawingHeight(true);
		int k = (int) point.getX();
		int l = (int) point.getY();
		setInFrame(point);
		if (bInFrame || !bWheel)
			clearGraphCursor(graphics2d);
		if (bInFrame) {
			bWheel = false;
			int i1 = (int) ((double) (nYGBottom - l) / dYScale);
			if (l < nYGBottom - (int) ((dYScale * (double) (2 * i1 + 1)) / 2D))
				i1++;
			if (i1 > llTime.length - 1)
				i1 = llTime.length - 1;
			else if (i1 < 0)
				i1 = 0;
			if (k >= nlXGArray[i1]) {
				int j1;
				for (j1 = 0; j1 < nlXGArray.length && k > nlXGArray[j1]; j1++)
					;
				if (j1 == nlXGArray.length || j1 > 0 && k < (nlXGArray[j1 - 1] + nlXGArray[j1]) / 2)
					j1--;
				i1 = j1;
			}
			drawGraphCursor(graphics2d, i1);
		}
		else if (!bWheel)
			nXCursor = nYCursor = -1;
	}

	void unitMove(boolean flag)
	{
		if (bInFrame)
			return;
		Graphics2D graphics2d = (Graphics2D) vThreadPanel.getGraphics();
		graphics2d.setClip(vThreadPanel.getRealDrawingRect());
		setRenderingQuality(graphics2d, false);
		clearGraphCursor(graphics2d);
		int ai[] = nlRefMarkers;
		if (ai == null || ai.length == 0)
			return;
		bWheel = true;
		int i = -1;
		if (nGResNum >= 0)
			if (flag) {
				int j = 0;
				do {
					if (j >= ai.length)
						break;
					if (ai[j] > nGResNum) {
						i = ai[j];
						break;
					}
					j++;
				} while (true);
			}
			else {
				int k = ai.length - 1;
				do {
					if (k < 0)
						break;
					if (ai[k] < nGResNum) {
						i = ai[k];
						break;
					}
					k--;
				} while (true);
			}
		if (i < 0)
			i = ai[flag ? 0 : ai.length - 1];
		drawGraphCursor(graphics2d, i);
	}

	void mouseWheelMoved(MouseWheelEvent mousewheelevent)
	{
		unitMove(mousewheelevent.getUnitsToScroll() < 0);
	}

	void drawGraph(Graphics2D graphics2d, Rectangle rectangle, boolean flag)
	{
		bInFrame = false;
		bWheel = false;
		V2CThreadRes v2cthreadres = vThreadPanel.getThreadRes();
		int i = rectangle.height;
		int j = rectangle.width;
		setRenderingQuality(graphics2d, true);
		graphics2d.setColor(cBGOut);
		graphics2d.fillRect(rectangle.x, rectangle.y, j, i);
		nXGLeft = rectangle.x + (int) ((double) j * 0.10000000000000001D);
		nXGRight = rectangle.x + (int) ((double) j * 0.92000000000000004D);
		nYGTop = rectangle.y + (int) ((double) i * 0.080000000000000002D);
		nYGBottom = rectangle.y + (int) ((double) i * 0.90000000000000002D);
		int k = nXGRight - nXGLeft;
		int l = nYGBottom - nYGTop;
		int i1 = v2cthreadres.getNRes();
		if (i1 < 2)
			return;
		long l1 = v2cthreadres.getResItem(0).getTime();
		long al[] = new long[i1];
		llTime = al;
		for (int j1 = 0; j1 < i1; j1++) {
			V2CResItem v2cresitem = v2cthreadres.getResItem(j1);
			long l3 = v2cresitem == null ? 0L : v2cresitem.getTime();
			if (l3 == 0L && j1 > 0)
				l3 = al[j1 - 1];
			al[j1] = l3;
		}

		long l2 = 0L;
		for (int i4 = i1 - 1; i4 >= 0; i4--) {
			long l5 = al[i4];
			if (l5 > 0L) {
				l2 = l5;
				break;
			}
		}
		long l4 = l2 - l1;
		if (l1 == 0L || l2 == 0L || l4 == 0L)
			return;
		graphics2d.setColor(cBGIn);
		graphics2d.fillRect(nXGLeft - 1, nYGTop - 1, (nXGRight - nXGLeft) + 2, (nYGBottom - nYGTop) + 2);
		dXScale = (double) k / (double) l4;
		dYScale = (double) l / (double) (i1 - 1);
		nlXGArray = new int[i1];
		int ai[] = new int[i1];
		for (int k1 = i1 - 1; k1 >= 0; k1--) {
			long l6 = al[k1];
			nlXGArray[k1] = nXGLeft + (int) (dXScale * (double) (l6 - l1));
			ai[k1] = nYGBottom - (int) (dYScale * (double) k1);
		}

		drawSpeed(graphics2d);
		if (bDrawThreadInfo) {
			V2CThreadItem v2cthreaditem = vThreadPanel.getThreadItem();
			int j2 = nXGRight - 10;
			int i4 = nYGBottom - 10;
			String FormalURLString = v2cthreaditem.getFormalURLString();
			String host = FormalURLString.split("/")[2];
			String containsKey = V2CHttpUtil.getSSLSrever(host);
			if(containsKey.equals("true")){
				FormalURLString = FormalURLString.replace("http://", "https://");
			}else if(containsKey.equals("NotContainsKey")){
				if(V2CHttpUtil.checkSSL(FormalURLString)){
					V2CHttpUtil.putSSLSrever(host, "true");
					FormalURLString = FormalURLString.replace("http://", "https://");
				}else{
					V2CHttpUtil.putSSLSrever(host, "true");
				}
			}
			FormalURLString	= FormalURLString.replace(".2ch.", ".5ch.");			
			Rectangle2D rectangle2d = drawString(graphics2d, fGraphFont, cFrame, true, FormalURLString, j2,
					i4, 14);
			drawString(graphics2d, fGraphFont, cFrame, true, v2cthreaditem.getTitle(), j2, i4 - (int) rectangle2d.getHeight(), 14);
		}
		drawNumLabels(graphics2d, v2cthreadres);
		drawTimeLabels(graphics2d, l1, l2);
		int i2 = v2cthreadres.getNewMarkPos();
		if (!flag && i2 > 0 && i2 < i1) {
			int k2 = nYGBottom - (int) (dYScale * (double) i2);
			graphics2d.setColor(cNewMark);
			graphics2d.drawLine(nXGLeft, k2, nXGRight, k2);
		}
		graphics2d.setColor(cLine);
		graphics2d.drawPolyline(nlXGArray, ai, i1);
		for (int i3 = 0; i3 < i1; i3++)
			nlXGArray[i3]++;

		graphics2d.drawPolyline(nlXGArray, ai, i1);
		for (int j3 = 0; j3 < i1; j3++) {
			nlXGArray[j3]--;
			ai[j3]--;
		}

		graphics2d.drawPolyline(nlXGArray, ai, i1);
		for (int k3 = 0; k3 < i1; k3++)
			ai[k3]++;

		graphics2d.setColor(cFrame);
		graphics2d.drawRect(nXGLeft - 1, nYGTop - 1, (nXGRight - nXGLeft) + 2, (nYGBottom - nYGTop) + 2);
		graphics2d.drawRect(nXGLeft - 2, nYGTop - 2, (nXGRight - nXGLeft) + 4, (nYGBottom - nYGTop) + 4);
		drawResLabels(graphics2d, nlXGArray, ai, i1);
		drawMarkers(graphics2d, nlXGArray, ai, i1);
		bGraphDrawn = true;
		if (!flag)
			setInFrame(V2CSwingUtil.getMouseLocation(vThreadPanel));
	}

	void setInFrame(Point point)
	{
		bInFrame = point != null && point.x >= nXGLeft && point.x <= nXGRight && point.y >= nYGTop && point.y <= nYGBottom;
	}

	void drawNumLabels(Graphics2D graphics2d, V2CThreadRes v2cthreadres)
	{
		int i = v2cthreadres.getNRes();
		int j = (int) Math.pow(10D, (int) (Math.log(i) / Math.log(10D)));
		int k;
		int l;
		do {
			if (i / (j * 5) >= 3) {
				k = j * 5;
				l = j;
				break;
			}
			if (i / (j * 2) >= 3) {
				k = j * 2;
				l = j / 2;
				break;
			}
			if (i / j >= 3) {
				k = j;
				l = j / 5;
				break;
			}
			j /= 10;
			if (j == 0)
				return;
		} while (true);
		if (l == 0)
			l = k;
		int i1 = l - 1;
		drawString(graphics2d, fGraphFont, cFrame, true, "1", nXGLeft - 5, nYGBottom, 13);
		java.awt.Stroke stroke = graphics2d.getStroke();
		for (; i1 < i; i1 += l) {
			int j1 = nYGBottom - (int) (dYScale * (double) i1);
			byte byte0 = 5;
			if ((i1 + 1) % k == 0) {
				graphics2d.setColor(cGrid);
				graphics2d.setStroke(bsGraphGrid);
				graphics2d.drawLine(nXGLeft, j1, nXGRight, j1);
				drawString(graphics2d, fGraphFont, cFrame, true, String.valueOf(i1 + 1), nXGLeft - 5, j1, 13);
				byte0 = 8;
			}
			graphics2d.setColor(cFrame);
			graphics2d.setStroke(stroke);
			graphics2d.drawLine(nXGLeft, j1, nXGLeft + byte0, j1);
			graphics2d.drawLine(nXGRight - byte0, j1, nXGRight, j1);
		}

		graphics2d.setStroke(stroke);
	}

	void drawTimeLabels(Graphics2D graphics2d, long l, long l1)
	{
		int i = (int) ((l1 - l) / 1000L);
		int j = 0;
		label0: for (int k = 0; k < ilTimeTicks.length; k++) {
			int ai[] = ilTimeTicks[k];
			int j1 = 0;
			do {
				if (j1 >= ai.length)
					continue label0;
				if (i / ai[j1] >= 3) {
					j = ai[j1];
					continue label0;
				}
				j1++;
			} while (true);
		}

		if (j == 0)
			return;
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis(l);
		calendar.set(11, 0);
		calendar.set(12, 0);
		calendar.set(13, 0);
		int i1 = 1;
		if (j > 0x15180) {
			calendar.set(5, 1);
			if (j > 0x2820a8) {
				calendar.set(2, 0);
				if (j > 0x1e187e0)
					i1 = (int) Math.round((double) j / 31557600D);
				else
					i1 = (int) Math.round((double) j / 2629800D);
			}
			else {
				i1 = (int) Math.round((double) j / 86400D);
			}
		}
		long l2 = calendar.getTimeInMillis();
		long l3 = (long) j * 1000L;
		long l4;
		if (j > 0x15180)
			l4 = l2;
		else
			l4 = l2 + ((l - l2) / l3 + 1L) * l3;
		java.awt.Stroke stroke = graphics2d.getStroke();
		String s = null;
		while (l4 < l1) {
			if (l4 >= l) {
				int k1 = nXGLeft + (int) (dXScale * (double) (l4 - l));
				graphics2d.setColor(cGrid);
				graphics2d.setStroke(bsGraphGrid);
				graphics2d.drawLine(k1, nYGBottom, k1, nYGTop);
				Date date = new Date(l4);
				int i2 = nYGBottom + 5;
				if (j < 0x15180) {
					Rectangle2D rectangle2d = drawString(graphics2d, fGraphFont, cFrame, true,
							(j >= 60 ? dfTRes1 : dfTRes1s).format(date), k1, i2, 11);
					i2 += (int) rectangle2d.getHeight();
				}
				SimpleDateFormat simpledateformat = j <= 0x2820a8 ? dfTRes2 : dfTRes3;
				String s1 = simpledateformat.format(date);
				if (!s1.equals(s))
					drawString(graphics2d, fGraphFont, cFrame, true, s1, k1, i2, 11);
				s = s1;
				graphics2d.setColor(cFrame);
				graphics2d.setStroke(stroke);
				graphics2d.drawLine(k1, nYGBottom, k1, nYGBottom - 8);
				graphics2d.drawLine(k1, nYGTop + 8, k1, nYGTop);
			}
			if (j > 0x15180) {
				if (j > 0x1e187e0)
					calendar.add(1, i1);
				else if (j > 0x2820a8)
					calendar.add(2, i1);
				else
					calendar.add(5, i1);
				l4 = calendar.getTimeInMillis();
			}
			else {
				l4 += l3;
			}
		}
		graphics2d.setStroke(stroke);
	}

	void drawResLabels(Graphics2D graphics2d, int ai[], int ai1[], int i)
	{
		if (!bDrawResLabel || i == 0)
			return;
		V2CThreadRes v2cthreadres = vThreadPanel.getThreadRes();
		V2CHighlightTableCellRenderer v2chighlighttablecellrenderer = null;
		CellRendererPane cellrendererpane = null;
		int ai2[] = null;
		int ai3[] = null;
		for (int j = 0; j < i; j++) {
			V2CResLabel v2creslabel = v2cthreadres.getResLabel(j);
			if (v2creslabel == null)
				continue;
			if (v2chighlighttablecellrenderer == null) {
				v2chighlighttablecellrenderer = new V2CHighlightTableCellRenderer(V2CThreadStyle.getDefaultColor(1));
				cellrendererpane = new CellRendererPane();
				ai2 = new int[3];
				ai3 = new int[3];
			}
			v2chighlighttablecellrenderer.setText(V2CMiscUtil.stringValueOf(j + 1));
			Dimension dimension = v2chighlighttablecellrenderer.getPreferredSize();
			v2chighlighttablecellrenderer.setHighlightStyle(v2creslabel.getStyle());
			int k = ai[j] + 3;
			int l = ai1[j] + 3;
			cellrendererpane.paintComponent(graphics2d, v2chighlighttablecellrenderer, vThreadPanel, k, l, dimension.width,
					dimension.height);
			graphics2d.setColor(cReference);
			k--;
			l--;
			ai2[0] = ai2[2] = k;
			ai2[1] = k + 5;
			ai3[0] = ai3[1] = l;
			ai3[2] = l + 5;
			graphics2d.fillPolygon(ai2, ai3, 3);
		}

	}

	void drawMarkers(Graphics2D graphics2d, int ai[], int ai1[], int i)
	{
		if (i == 0)
			return;
		V2CThreadRes v2cthreadres = vThreadPanel.getThreadRes();
		java.awt.Stroke stroke = graphics2d.getStroke();
		java.awt.geom.AffineTransform affinetransform = graphics2d.getTransform();
		nlRefMarkers = null;
		if (nRefResMarkers > 0) {
			int ai2[] = v2cthreadres.createRefCountArray();
			int ai3[] = sortMostReferredRes(ai2);
			short aword0[] = new short[ai3.length];
			if (ai3.length > 0) {
				int k = 0;
				int l = 0;
				boolean flag1 = nRefResNumbers > 0;
				for (int j1 = ai3.length - 1; j1 >= 0; j1--) {
					int k1 = ai2[j1];
					if (k1 >= ai.length)
						break;
					int l1 = ai3[j1];
					if (k >= nRefResMarkers && l1 < l)
						break;
					if (flag1 && k >= nRefResNumbers && l1 < l)
						flag1 = false;
					k++;
					l = l1;
					int i2 = ai[k1];
					int l2 = ai1[k1];
					int j3 = (int) (Math.log(l1) * 10D);
					aword0[j1] = (short) j3;
					graphics2d.setColor(cReference);
					graphics2d.setStroke(new BasicStroke((float) j3 * 0.2F));
					graphics2d.drawOval(i2 - j3, l2 - j3, j3 * 2 + 1, j3 * 2 + 1);
					if (j3 > 5) {
						graphics2d.setStroke(stroke);
						int k3 = Math.max(5, j3 - 5);
						graphics2d.drawLine(i2 - j3, l2, i2 - k3, l2);
						graphics2d.drawLine(i2 + k3, l2, i2 + j3, l2);
						graphics2d.drawLine(i2, l2 - j3, i2, l2 - k3);
						graphics2d.drawLine(i2, l2 + k3, i2, l2 + j3);
					}
					if (flag1) {
						int l3 = ai[k1] - 8;
						int i4 = ai1[k1] - 8;
						String s2 = String.valueOf(k1 + 1);
						drawString(graphics2d, fMarkerLabelFont, cBGIn, false, s2, l3 + 1, i4 + 1, 14);
						drawString(graphics2d, fMarkerLabelFont, cReference, false, s2, l3, i4, 14);
					}
				}

				int ai4[] = new int[k];
				short aword1[] = new short[k];
				nlRefMarkers = ai4;
				nlRefMarkerRadius = aword1;
				if (k > 0) {
					long al[] = new long[k];
					for (int j2 = 0; j2 < k; j2++) {
						int i3 = ai3.length - j2 - 1;
						al[j2] = ((long) ai2[i3] << 32) + (long) aword0[i3];
					}

					Arrays.sort(al);
					for (int k2 = 0; k2 < k; k2++) {
						ai4[k2] = (int) (al[k2] >>> 32);
						aword1[k2] = (short) (int) (al[k2] & 65535L);
					}

				}
			}
		}
		boolean flag = false;
		for (int j = 0; j < i; j++) {
			V2CResItem v2cresitem = v2cthreadres.getResItem(j);
			if (v2cresitem == null)
				continue;
			String s = v2cresitem.getNameString();
			if (s != null && s.length() > 0) {
				if (sSelectedCap != null && s.indexOf(sSelectedCap) >= 0)
					drawNormalMarker(graphics2d, ai[j], ai1[j]);
				else if (sSelectedTrip != null && s.indexOf(sSelectedTrip) >= 0)
					drawNormalMarker(graphics2d, ai[j], ai1[j]);
				else if (s.equals(sSelectedName))
					drawNormalMarker(graphics2d, ai[j], ai1[j]);
				int i1;
				if (bDrawCapMarkers && (i1 = s.indexOf('★')) > 0
						&& !s.equals("トラックバック ★")
						&& (i1 < 4 || !s.regionMatches(i1 - 4, "＠株主 ★", 0, 5))) {
					Color color;
					if (s.indexOf("root▲▲ ★") >= 0 || s.indexOf("root▲ ★") >= 0
							|| s.indexOf("root ★") >= 0)
						color = cRootCap;
					else if (s.indexOf("FOX ★") >= 0 || s.indexOf("FAX ★") >= 0
							|| s.indexOf("たにし ★") >= 0 || s.indexOf("ちょろ ★") >= 0
							|| s.indexOf("ぶたさん ★") >= 0 || s.indexOf("番犬 ★") >= 0
							|| s.indexOf("ざる ★") >= 0 || s.indexOf("鷲鴨 ★") >= 0
							|| s.indexOf("つるっぴ ★") >= 0
							|| s.indexOf("せしりあ ★") >= 0
							|| s.indexOf("軽快うねっこ ★") >= 0
							|| s.indexOf("ちきちーた ★") >= 0)
						color = cFOXCap;
					else if (s.indexOf("ひろゆき＠どうやら管理人 ★") >= 0
							|| s.indexOf("どうやら管理人 ★") >= 0)
						color = cHiroyukiCap;
					else
						color = cDefaultCap;
					graphics2d.setColor(color);
					graphics2d.setStroke(bsCapStar);
					try {
						graphics2d.translate(ai[j], ai1[j]);
						graphics2d.draw(gpStar);
					}
					finally {
						graphics2d.setTransform(affinetransform);
					}
					if (bDrawCapNames) {
						String s1 = omitHTMLTags(s);
						if (!flag && ai[j] > (nXGLeft + nXGRight) / 2) {
							Rectangle2D rectangle2d = getStringBounds(graphics2d, fMarkerLabelFont, s1);
							if ((double) (ai[j] + 8) + rectangle2d.getWidth() > (double) nXGRight)
								flag = true;
						}
						drawString(graphics2d, fMarkerLabelFont, color, false, s1, ai[j] + (flag ? -8 : 8), ai1[j], flag ? 13
								: 17);
					}
				}
			}
			if (sSelectedID != null && sSelectedID.equals(v2cresitem.getID()))
				drawNormalMarker(graphics2d, ai[j], ai1[j]);
			if (cSelectedPostDevice > 0 && cSelectedPostDevice == v2cresitem.getPostDevice())
				drawNormalMarker(graphics2d, ai[j], ai1[j]);
			if (iSelectedBE > 0 && iSelectedBE == v2cresitem.getBeID0())
				drawNormalMarker(graphics2d, ai[j], ai1[j]);
			if (sSelectedAux != null && sSelectedAux.equals(v2cresitem.getAuxString()))
				drawNormalMarker(graphics2d, ai[j], ai1[j]);
		}

		graphics2d.setStroke(stroke);
	}

	private static String omitHTMLTags(String s)
	{
		if (s.indexOf('<') < 0)
			return s;
		int i = 0;
		do {
			if ((i = s.indexOf('<', i)) < 0)
				break;
			boolean flag = false;
			int j = 0;
			do {
				if (j >= slOmitHTMLTags.length)
					break;
				String s1 = slOmitHTMLTags[j];
				if (s.regionMatches(true, i + 1, s1, 0, s1.length())) {
					flag = true;
					break;
				}
				j++;
			} while (true);
			if (!flag) {
				i++;
				continue;
			}
			j = s.indexOf('>', i + 1);
			if (j < 0)
				break;
			s = s.substring(0, i) + s.substring(j + 1);
		} while (true);
		return s;
	}

	private static void drawNormalMarker(Graphics2D graphics2d, int i, int j)
	{
		graphics2d.setColor(cMarker);
		graphics2d.fillOval(i - 4, j - 4, 9, 9);
	}

	private static int[] sortMostReferredRes(int ai[])
	{
		int i = 0;
		for (int j = 0; j < ai.length; j++)
			if (ai[j] > 1)
				ai[i++] = ai[j] << 16 | j;

		if (i == 0)
			return new int[0];
		int ai1[] = new int[i];
		System.arraycopy(ai, 0, ai1, 0, i);
		Arrays.sort(ai1);
		for (int k = 0; k < ai1.length; k++) {
			int l = ai1[k];
			ai[k] = l & 0xffff;
			ai1[k] = l >> 16;
		}

		return ai1;
	}

	private void drawSpeed(Graphics2D graphics2d)
	{
		if (!bDrawSpeed)
			return;
		long al[] = llTime;
		int i = al.length;
		if (i < 20)
			return;
		int ai[] = new int[i];
		float af[] = new float[i];
		int j = 0;
		float f = (-1.0F / 0.0F);
		float f1 = (1.0F / 0.0F);
		for (int k = 5; k < i - 5; k++) {
			long l = al[k];
			if (l == 0L)
				continue;
			int j1 = k - 5;
			int j2 = k + 5;
			int k2 = 0;
			int l2 = 0;
			for (int i3 = j1; i3 < j2; i3++) {
				if (i3 == k)
					continue;
				long l3 = al[i3];
				if (l3 == 0L)
					continue;
				int j3 = (int) (l3 - l);
				if (j3 < 0)
					j3 = -j3;
				k2 += j3;
				l2++;
			}

			if (l2 == 0)
				continue;
			double d = (double) k2 / (double) l2;
			d *= d;
			float f3 = 0.0F;
			float f4 = 0.0F;
			float f5 = 0.0F;
			float f6 = 0.0F;
			float f7 = 0.0F;
			l2 = 0;
			for (int k3 = j1; k3 < j2; k3++) {
				long l4 = al[k3];
				int i4 = (int) (l4 - l);
				float f10 = (float) i4 * (float) i4;
				float f11 = (float) Math.exp((double) (-f10) / d);
				if (l4 != 0L) {
					f3 += f11 * f10;
					f4 += f11 * (float) i4;
					f5 += f11;
					int j4 = k3 - k;
					f6 += f11 * (float) i4 * (float) j4;
					f7 += f11 * (float) j4;
					l2++;
				}
			}

			float f8 = f3 * f5 - f4 * f4;
			if (f8 == 0.0F)
				continue;
			float f9 = (f5 * f6 - f4 * f7) / f8;
			if (f9 <= 0.0F)
				continue;
			f9 = (float) Math.log(f9);
			if (f9 > f)
				f = f9;
			if (f9 < f1)
				f1 = f9;
			af[j] = f9;
			ai[j] = nlXGArray[k];
			j++;
		}

		if (j <= 1 || f <= f1)
			return;
		float f2 = ((float) (nYGBottom - nYGTop) / (f - f1)) * 0.7F;
		int i1 = nYGBottom;
		int ai1[] = new int[j];
		for (int k1 = 0; k1 < j; k1++)
			ai1[k1] = i1 - Math.max((int) (f2 * (af[k1] - f1)), 0);

		graphics2d.setColor(cSpeed);
		graphics2d.drawPolyline(ai, ai1, j);
		for (int l1 = 0; l1 < j; l1++)
			ai[l1]++;

		graphics2d.drawPolyline(ai, ai1, j);
		for (int i2 = 0; i2 < j; i2++) {
			ai[i2]--;
			ai1[i2]--;
		}

		graphics2d.drawPolyline(ai, ai1, j);
	}

	static final int ANCHOR_NORTH = 11;
	static final int ANCHOR_NORTHEAST = 12;
	static final int ANCHOR_EAST = 13;
	static final int ANCHOR_SOUTHEAST = 14;
	static final int ANCHOR_SOUTH = 15;
	static final int ANCHOR_SOUTHWEST = 16;
	static final int ANCHOR_WEST = 17;
	static final int ANCHOR_NORTHWEST = 18;
	static final String sKeyPrefix = "ThreadGraph.";
	private static final String sCondKey = "ThreadGraph.Cond";
	private static final String sGraphNewMarkColorKey0 = "ThreadView.GraphNewMarkColor";
	private static final String sGraphCursorColorKey0 = "ThreadView.GraphCursorColor";
	private static final String sNumRefResMarkersKey = "ThreadGraph.NumRefResMarkers";
	private static final String sNumRefResNumbersKey = "ThreadGraph.NumRefResNumbers";
	private static final String sDrawCapMarkersKey = "ThreadGraph.DrawCapMarkers";
	private static final String sDrawThreadInfoKey = "ThreadGraph.DrawThreadInfo";
	private static final String sDrawSpeedKey = "ThreadGraph.DrawSpeed";
	private static final String sHighRenderingQualityKey = "ThreadGraph.HighRenderingQuality";
	private static final String sNoSelection = "選択なし";
	static BasicStroke bsGraphGrid = new BasicStroke(1.0F, 0, 0, 10F, new float[] { 4F }, 0.0F);
	static SimpleDateFormat dfTRes1;
	static SimpleDateFormat dfTRes1s;
	static SimpleDateFormat dfTRes1sw;
	static SimpleDateFormat dfTRes1p;
	static SimpleDateFormat dfTRes2;
	static SimpleDateFormat dfTRes3;
	static int ilTimeTicks[][] = { { 30, 15, 10, 5, 3, 2, 1 }, { 1800, 900, 600, 300, 180, 120, 60 },
			{ 43200, 21600, 10800, 7200, 3600 }, { 0x13c680, 0xd2f00, 0x69780, 0x3f480, 0x2a300, 0x15180 },
			{ 0xf0c3f0, 0x7861f8, 0x504150, 0x2820a8 }, { 0x967a760, 0x5a497a0, 0x3c30fc0, 0x1e187e0 } };
	private static Color cDefaultCap = new Color(0x38b0de);
	private static Color cHiroyukiCap = new Color(0xff6347);
	private static Color cFOXCap = new Color(0x2e8b57);
	private static Color cRootCap = new Color(0x40e0d0);
	private static int nRefResMarkers;
	private static int nRefResNumbers;
	static final int nCapMarkSize = 8;
	private static final int nRefResInTickSize = 5;
	private static boolean bHighRenderingQuality;
	private static boolean bDrawCapMarkers;
	private static boolean bDrawCapNames;
	private static boolean bDrawThreadInfo;
	private static boolean bDrawSpeed;
	private static boolean bDrawResLabel;
	static final BasicStroke bsCapStar = new BasicStroke(2.0F, 1, 1);
	static GeneralPath gpStar = createStar(8);
	private static final int nCursorTickLength = 10;
	private static final BasicStroke bsMarker = new BasicStroke(2.0F);
	static Color cBGIn;
	static Color cBGOut;
	static Color cFrame;
	static Color cGrid;
	static Color cCursor;
	static Color cCursorLetter;
	static Color cLine;
	static Color cNewMark;
	static Color cReference;
	static Color cSpeed;
	private static final Color cMarker = new Color(0x90ee90);
	V2CThreadPanel vThreadPanel;
	int nXGRight;
	int nXGLeft;
	int nYGBottom;
	int nYGTop;
	int nXCursor;
	int nYCursor;
	double dXScale;
	double dYScale;
	long llTime[];
	int nlXGArray[];
	int nlRefMarkers[];
	short nlRefMarkerRadius[];
	boolean bGraphDrawn;
	Rectangle2D r2dNRes;
	Rectangle2D r2dTRes;
	int nGResNum;
	boolean bInFrame;
	boolean bWheel;
	String sSelectedCap;
	String sSelectedTrip;
	String sSelectedName;
	String sSelectedID;
	char cSelectedPostDevice;
	int iSelectedBE;
	String sSelectedAux;
	Font fGraphFont;
	Font fGraphCursorFont;
	Font fMarkerLabelFont;
	private static String slOmitHTMLTags[] = { "b>", "/b>", "font ", "/font>" };
	private static final int NP = 5;

	static {
		dfTRes1 = new SimpleDateFormat("HH:mm");
		dfTRes1s = new SimpleDateFormat("HH:mm:ss");
		dfTRes1sw = new SimpleDateFormat("HH:mm:ss (E)", Locale.JAPANESE);
		dfTRes1p = new SimpleDateFormat("HH:mm (E)", Locale.JAPANESE);
		dfTRes2 = new SimpleDateFormat("yy/MM/dd");
		dfTRes3 = new SimpleDateFormat("yyyy/MM");
		java.util.TimeZone timezone = V2CBBS.tzWritePreview;
		dfTRes1.setTimeZone(timezone);
		dfTRes1s.setTimeZone(timezone);
		dfTRes1sw.setTimeZone(timezone);
		dfTRes1p.setTimeZone(timezone);
		dfTRes2.setTimeZone(timezone);
		dfTRes3.setTimeZone(timezone);
		V2CProperty v2cproperty = V2CMain.getUserProperty();
		if (v2cproperty.containsKey("ThreadView.GraphNewMarkColor"))
			v2cproperty.remove("ThreadView.GraphNewMarkColor");
		if (v2cproperty.containsKey("ThreadView.GraphCursorColor"))
			v2cproperty.remove("ThreadView.GraphCursorColor");
		nRefResMarkers = v2cproperty.getInt("ThreadGraph.NumRefResMarkers", 10);
		nRefResNumbers = v2cproperty.getInt("ThreadGraph.NumRefResNumbers");
		bHighRenderingQuality = v2cproperty.getBoolean("ThreadGraph.HighRenderingQuality");
		String s = v2cproperty.get("ThreadGraph.DrawCapMarkers");
		if (s != null) {
			bDrawCapMarkers = true;
			bDrawCapNames = s.equals("F");
		}
		bDrawThreadInfo = v2cproperty.getBoolean("ThreadGraph.DrawThreadInfo");
		bDrawSpeed = v2cproperty.getBoolean("ThreadGraph.DrawSpeed");
		V2CPackedPropValue v2cpackedpropvalue = v2cproperty.getPackedValue("ThreadGraph.Cond");
		if (v2cpackedpropvalue != null) {
			cBGOut = v2cpackedpropvalue.getColor('B');
			cCursor = v2cpackedpropvalue.getColor('C');
			cFrame = v2cpackedpropvalue.getColor('F');
			cGrid = v2cpackedpropvalue.getColor('G');
			cBGIn = v2cpackedpropvalue.getColor('I');
			cLine = v2cpackedpropvalue.getColor('L');
			cNewMark = v2cpackedpropvalue.getColor('N');
			cReference = v2cpackedpropvalue.getColor('R');
			cSpeed = v2cpackedpropvalue.getColor('S');
			cCursorLetter = v2cpackedpropvalue.getColor('T');
			bDrawResLabel = v2cpackedpropvalue.getBoolean('L');
		}
		if (cBGOut == null)
			cBGOut = Color.WHITE;
		if (cCursor == null)
			cCursor = new Color(0x2222aa);
		if (cFrame == null)
			cFrame = Color.BLACK;
		if (cGrid == null)
			cGrid = Color.GRAY;
		if (cBGIn == null)
			cBGIn = new Color(0.97F, 0.97F, 0.97F);
		if (cLine == null)
			cLine = Color.RED;
		if (cNewMark == null)
			cNewMark = new Color(0x66dd00);
		if (cReference == null)
			cReference = Color.GRAY;
		if (cCursorLetter == null)
			cCursorLetter = Color.BLUE;
		if (cSpeed == null)
			cSpeed = new Color(192, 192, 255);
		V2CMain.threadGraphLoaded();
	}

}
