package org.monazilla.v2c;

import java.util.ArrayList;
import java.util.HashMap;

// twemoji v15.0.3 (https://github.com/toine512/twemoji-bitmaps/releases/tag/v15.0.3) is Ready.
// twemoji v15.0.2 (https://github.com/toine512/twemoji-bitmaps/releases/tag/v15.0.2) is Ready.
// twemoji v14.1.2 (https://github.com/toine512/twemoji-bitmaps/releases/tag/v14.1.2) is Ready.

public class V2CTextSegmentRedit {

	private static boolean dp = false;

	static private final HashMap NFHMmap = new HashMap(){{
		System.out.println("V2CTextSegmentRedit Initialize NFHMmap");
		put('\udde6', new char[]{'\udde8', '\udde9', '\uddea', '\uddeb', '\uddec', '\uddee', '\uddf1', '\uddf2', '\uddf4', '\uddf6', '\uddf7', '\uddf8', '\uddf9', '\uddfa', '\uddfc', '\uddfd', '\uddff'});
		put('\udde7', new char[]{'\udde6', '\udde7', '\udde9', '\uddea', '\uddeb', '\uddec', '\udded', '\uddee', '\uddef', '\uddf1', '\uddf2', '\uddf3', '\uddf4', '\uddf6', '\uddf7', '\uddf8', '\uddf9', '\uddfb', '\uddfc', '\uddfe', '\uddff'});
		put('\udde8', new char[]{'\udde6', '\udde8', '\udde9', '\uddeb', '\uddec', '\udded', '\uddee', '\uddf0', '\uddf1', '\uddf2', '\uddf3', '\uddf4', '\uddf5', '\uddf7', '\uddfa', '\uddfb', '\uddfc', '\uddfd', '\uddfe', '\uddff'});
		put('\udde9', new char[]{'\uddea', '\uddec', '\uddef', '\uddf0', '\uddf2', '\uddf4', '\uddff'});
		put('\uddea', new char[]{'\udde6', '\udde8', '\uddea', '\uddec', '\udded', '\uddf7', '\uddf8', '\uddf9', '\uddfa'});
		put('\uddeb', new char[]{'\uddee', '\uddef', '\uddf0', '\uddf2', '\uddf4', '\uddf7'});
		put('\uddec', new char[]{'\udde6', '\udde7', '\udde9', '\uddea', '\uddeb', '\uddec', '\udded', '\uddee', '\uddf1', '\uddf2', '\uddf3', '\uddf5', '\uddf6', '\uddf7', '\uddf8', '\uddf9', '\uddfa', '\uddfc', '\uddfe'});
		put('\udded', new char[]{'\uddf0', '\uddf2', '\uddf3', '\uddf7', '\uddf9', '\uddfa'});
		put('\uddee', new char[]{'\udde8', '\udde9', '\uddea', '\uddf1', '\uddf2', '\uddf3', '\uddf4', '\uddf6', '\uddf7', '\uddf8', '\uddf9'});
		put('\uddef', new char[]{'\uddea', '\uddf2', '\uddf4', '\uddf5'});
		put('\uddf0', new char[]{'\uddea', '\uddec', '\udded', '\uddee', '\uddf2', '\uddf3', '\uddf5', '\uddf7', '\uddfc', '\uddfe', '\uddff'});
		put('\uddf1', new char[]{'\udde6', '\udde7', '\udde8', '\uddee', '\uddf0', '\uddf7', '\uddf8', '\uddf9', '\uddfa', '\uddfb', '\uddfe'});
		put('\uddf2', new char[]{'\udde6', '\udde8', '\udde9', '\uddea', '\uddeb', '\uddec', '\udded', '\uddf0', '\uddf1', '\uddf2', '\uddf3', '\uddf4', '\uddf5', '\uddf6', '\uddf7', '\uddf8', '\uddf9', '\uddfa', '\uddfb', '\uddfc', '\uddfd', '\uddfe', '\uddff'});
		put('\uddf3', new char[]{'\udde6', '\udde8', '\uddea', '\uddeb', '\uddec', '\uddee', '\uddf1', '\uddf4', '\uddf5', '\uddf7', '\uddfa', '\uddff'});
		put('\uddf4', new char[]{'\uddf2'});
		put('\uddf5', new char[]{'\udde6', '\uddea', '\uddeb', '\uddec', '\udded', '\uddf0', '\uddf1', '\uddf2', '\uddf3', '\uddf7', '\uddf8', '\uddf9', '\uddfc', '\uddfe'});
		put('\uddf6', new char[]{'\udde6'});
		put('\uddf7', new char[]{'\uddea', '\uddf4', '\uddf8', '\uddfa', '\uddfc'});
		put('\uddf8', new char[]{'\udde6', '\udde7', '\udde8', '\udde9', '\uddea', '\uddec', '\udded', '\uddee', '\uddef', '\uddf0', '\uddf1', '\uddf2', '\uddf3', '\uddf4', '\uddf7', '\uddf8', '\uddf9', '\uddfb', '\uddfd', '\uddfe', '\uddff'});
		put('\uddf9', new char[]{'\udde6', '\udde8', '\udde9', '\uddeb', '\uddec', '\udded', '\uddef', '\uddf0', '\uddf1', '\uddf2', '\uddf3', '\uddf4', '\uddf7', '\uddf9', '\uddfb', '\uddfc', '\uddff'});
		put('\uddfa', new char[]{'\udde6', '\uddec', '\uddf2', '\uddf3', '\uddf8', '\uddfe', '\uddff'});
		put('\uddfb', new char[]{'\udde6', '\udde8', '\uddea', '\uddec', '\uddee', '\uddf3', '\uddfa'});
		put('\uddfc', new char[]{'\uddeb', '\uddf8'});
		put('\uddfd', new char[]{'\uddf0'});
		put('\uddfe', new char[]{'\uddea', '\uddf9'});
		put('\uddff', new char[]{'\udde6', '\uddf2', '\uddfc'});
	}};
	
	static final char c_ZERO_WIDTH_SPACE      = '\u200C'; // '\u200b';
	static final char c_ZERO_WIDTH_NON_JOINER = '\u200C';
	static final char c_ZERO_WIDTH_JOINER     = '\u200d';
	
	static final char c_HighSurrogates_From   = '\ud800';
	static final char c_HighSurrogates_To     = '\udbff';
	static final char c_LowSurrogates_From    = '\udc00';
	static final char c_LowSurrogates_To      = '\udfff';
	
	static final char c_Skin_HighSurrogates     = '\ud83c';
	static final char c_Skin_LowSurrogates_From = '\udffb';
	static final char c_Skin_LowSurrogates_To   = '\udfff';
	
	static final char c_NF_HighSurrogates     = '\ud83c';
	static final char c_NF_LowSurrogates_From = '\udde6';
	static final char c_NF_LowSurrogates_To   = '\uddff';
	
	static final char c_MWBG_HighSurrogates     = '\ud83d';
	static final char[] c_MWBG_LowSurrogates    = {'\udC66', '\udC67', '\udC68', '\udC69'};

	static final char[] c_Sex                 = {'\u2642', '\u2640'};
	static final char[] c_Fe0x                = {'\ufe0e', '\ufe0f'};
	
	static final char c_U20e3                 = '\u20e3';
	static final char c_U26f9                 = '\u26f9';
	static final char c_U2764                 = '\u2764';
	static final char c_U26a7                 = '\u26a7';
	static final char c_U26d3                 = '\u26d3';
	static final char c_U27a1                 = '\u27a1';

	static private boolean isHighSurrogates(char c){
		if(!(c >= c_HighSurrogates_From && c <= c_HighSurrogates_To)){
			return false;
		}
		return true;
	}

	static private boolean isLowSurrogates(char c){
		if(!(c >= c_LowSurrogates_From && c <= c_LowSurrogates_To)){
			return false;
		}
		return true;
	}

	static private boolean isSkinHighSurrogates(char c){
		if(!(c >= c_Skin_HighSurrogates)){
			return false;
		}
		return true;
	}

	static private boolean isSkinLowSurrogates(char c){
		if(!(c >= c_Skin_LowSurrogates_From && c <= c_Skin_LowSurrogates_To)){
			return false;
		}
		return true;
	}

	static private boolean isNFHighSurrogates(char c){
		if(!(c == c_NF_HighSurrogates)){
			return false;
		}
		return true;
	}

	static private boolean isNFLowSurrogates(char c){
		if(!(c >= c_NF_LowSurrogates_From && c <= c_NF_LowSurrogates_To)){
			return false;
		}
		return true;
	}

	static private boolean isU200x(char c){
		if(!(c == c_ZERO_WIDTH_NON_JOINER || c == c_ZERO_WIDTH_JOINER)){
			return false;
		}
		return true;
	}

	static private boolean isSex(char c){
		if(!(c == c_Sex[0] || c == c_Sex[1])){
			return false;
		}
		return true;
	}

	static private boolean isMWBGHighSurrogates(char c){
		if(!(c == c_MWBG_HighSurrogates)){
			return false;
		}
		return true;
	}

	static private boolean isMWBGLowSurrogates(char c){
		if(!(c == c_MWBG_LowSurrogates[0] || c == c_MWBG_LowSurrogates[1] ||
			 c == c_MWBG_LowSurrogates[2] || c == c_MWBG_LowSurrogates[3])){
			return false;
		}
		return true;
	}

	static private boolean is1f48bHighSurrogates(char c){
		if(!(c == '\ud83d')){
			return false;
		}
		return true;
	}

	static private boolean is1f48bLowSurrogates(char c){
		if(!(c == '\udc8b')){
			return false;
		}
		return true;
	}

	static private boolean isFe0x(char c){
		if(!(c == c_Fe0x[0] || c == c_Fe0x[1])){
			return false;
		}
		return true;
	}

	static private boolean isU20e3(char c){
		if(!(c == c_U20e3)){
			return false;
		}
		return true;
	}

	static private boolean isU26f9(char c){
		if(!(c == c_U26f9)){
			return false;
		}
		return true;
	}

	static private boolean isU2764(char c){
		if(!(c == c_U2764)){
			return false;
		}
		return true;
	}

	static private boolean isU26a7(char c){
		if(!(c == c_U26a7)){
			return false;
		}
		return true;
	}

	static private boolean isU26d3(char c){
		if(!(c == c_U26d3)){
			return false;
		}
		return true;
	}

	static private boolean isU27a1(char c){
		if(!(c == c_U27a1)){
			return false;
		}
		return true;
	}

	static private boolean inU2xxx(char c){
		if(!(c >= '\u20d0' && c <= '\u2bff' || c == '\u203c' || c == '\u2049')){
			return false;
		}
		return true;
	}

	static private boolean inU3xxx(char c){
		if(!(c == '\u3030' || c == '\u303d' || c >= '\u3280' && c <= '\u32b0')){
			return false;
		}
		return true;
	}

	static private boolean iniMode(char c){
		if(!(c >= '\uf89f' && c <= '\uf9fc')){
			return false;
		}
		return true;
	}

	static private boolean inOther(char c){
		if(!(c == '\u00a9' || c == '\u00ae' || c == '\ue50a')){
			return false;
		}
		return true;
	}

	static private boolean isNumSharpAsta(char c){
		if(!(c == '\u0023' || c == '\u002a' || c >= '\u0030' && c <= '\u0039')){
			return false;
		}
		return true;
	}
	
	static private boolean inAlphabet(char c){
		if(!(c >= '\udde6' && c <= '\uddff')){
			return false;
		}
		return true;
	}
	
	static private int idxIncrememnt(int idx, int j2e, V2CTextSegment v2ctextsegment){
//		System.out.println("idxIncrememnt:"+Integer.toHexString(v2ctextsegment.clMsg[idx])+";j2e="+j2e);
		int ret = idx + 1;
		if(idx >= j2e) ret = -1;
		return ret;
	}
	
	static private void ZERO_WIDTH_SPACE_PADDING(V2CTextSegment[] vlTextSegment, int j11, int j2, int idx){
//		System.out.println(">>>>>>>>>>>>>>>>>>>>>>");
		for(int i=j2; i<=idx; i++){
//			System.out.println(Integer.toHexString(vlTextSegment[j11].clMsg[i]));
			vlTextSegment[j11].clMsg[i]   = c_ZERO_WIDTH_SPACE;
		}
//		System.out.println("<<<<<<<<<<<<<<<<<<<<<<");
	}
	
	static private String toCodePointStrings(V2CTextSegment[] vlTextSegment, int j11, int j2, int idx, int a) {
		String s = "";
		for (int i = j2, cp; i < idx + a; i += Character.charCount(cp)) {
			cp = Character.codePointAt(vlTextSegment[j11].clMsg, i);
			if(!(isU200x(vlTextSegment[j11].clMsg[i]) || isFe0x(vlTextSegment[j11].clMsg[i]))){
				s += (s==""?"":"-") + Integer.toHexString(cp);
			}
		}
		return s;
	}

	static private boolean Other_Remove(V2CTextSegment[] vlTextSegment, int j11, int j2, int idx, int m){
		return Other_RemoveO(vlTextSegment, j11, j2, idx, m, 0, 0);
	}
	static private boolean Other_RemoveO(V2CTextSegment[] vlTextSegment, int j11, int j2, int idx, int m, int a, int b){
		String target = toCodePointStrings(vlTextSegment, j11, j2, idx, a);
		printEmojiCode("target", target);
		if((target == null || target == "") && j2 == idx){
			target = Integer.toHexString(vlTextSegment[j11].clMsg[idx]);
		}
		printEmojiCode("target", target);
		
		int InlineMsgImgTextSegment_start = j11;
		for(int i=j11-m; i>=0; i--){
			InlineMsgImgTextSegment_start = i;
			if(!(vlTextSegment[i] == null || vlTextSegment[i] instanceof V2CInlineMsgImgTextSegment)){
				break;
			}
		}

		boolean flg = false;
		ArrayList<Integer> ai = new ArrayList<Integer>();
		for(int i=InlineMsgImgTextSegment_start-b; i<vlTextSegment.length; i++){
			if(vlTextSegment[i] != null){
				if(vlTextSegment[i].getSegmentStartIndex() > idx){
					break;
				}
				if(	vlTextSegment[i] instanceof V2CInlineMsgImgTextSegment){
					if(((V2CInlineMsgImgTextSegment) vlTextSegment[i]).getImageSet().fOriginalFile != null){
						String name = ((V2CInlineMsgImgTextSegment) vlTextSegment[i]).getImageSet().fOriginalFile.getName();
						name = name.replaceAll("-200d", "").replaceAll("-fe0f", "");
						printEmojiCode("name", name);
						if(flg || !target.equals(name)){
//							vlTextSegment[i] = new V2CTextSegment();
							ai.add(i);
						}else{
							flg = true;
						}
					}
				}
			}
		}
		
		if(flg){
			for(int i=0; i<ai.size(); i++){
				vlTextSegment[ai.get(i)] = new V2CTextSegment();
			}
		}
		else{
			for(int i=j11-m; i>=0; i--){
				if(vlTextSegment[i] instanceof V2CInlineMsgImgTextSegment){
					vlTextSegment[i] = new V2CTextSegment();
				}else{
					vlTextSegment[i].forceSetLength(vlTextSegment[i].length()+1);
					if(vlTextSegment[j11-m+1].length() == 1){
						vlTextSegment[j11-m+1] = new V2CTextSegment();
					}else{
						vlTextSegment[j11-m+1].iSegmentStart++;
						vlTextSegment[j11-m+1].forceSetLength(vlTextSegment[j11-m+1].length()-1);
					}
					break;
				}
			}
		}
		
		return flg;
	}

	static private boolean Other_Remove_EX1f3fb(V2CTextSegment[] vlTextSegment, int j11, int j2, int idx, int m){
		boolean exists = false;
		String target = Integer.toHexString(vlTextSegment[j11].clMsg[j2]) + "-1f3fb";
		
		int InlineMsgImgTextSegment_start = j11;
		for(int i=j11-m; i>=0; i--){
			InlineMsgImgTextSegment_start = i;
			if(!(vlTextSegment[i] == null || vlTextSegment[i] instanceof V2CInlineMsgImgTextSegment)){
				break;
			}
		}

		ArrayList<Integer> ai = new ArrayList<Integer>();
		for(int i=InlineMsgImgTextSegment_start; i<vlTextSegment.length; i++){
			if(vlTextSegment[i] != null){
				if(vlTextSegment[i].getSegmentStartIndex() > idx){
					break;
				}
				if(	vlTextSegment[i] instanceof V2CInlineMsgImgTextSegment){
					if(((V2CInlineMsgImgTextSegment) vlTextSegment[i]).getImageSet().fOriginalFile != null){
						String name = ((V2CInlineMsgImgTextSegment) vlTextSegment[i]).getImageSet().fOriginalFile.getName();
						name = name.replaceAll("-200d", "").replaceAll("-fe0f", "");
						if(!target.equals(name)){
//							vlTextSegment[i] = new V2CTextSegment();
							ai.add(i);
						}else{
							exists = true;
						}
					}
				}
			}
		}
		
		if(exists){
			for(int i=0; i<ai.size(); i++){
				vlTextSegment[ai.get(i)] = new V2CTextSegment();
			}
		}

		return exists;
	}

	static private boolean check_MWBG_200d_Group(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		// MWBG
		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isMWBGLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isMWBGHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 2764-fe0f or MWBG
		boolean decrememnt = false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!(isFe0x(vlTextSegment[j11].clMsg[idx])    || isMWBGLowSurrogates(vlTextSegment[j11].clMsg[idx]))){
			if(!isFe0x(vlTextSegment[j11].clMsg[idx])){
				decrememnt = true;
			}else{
				return false;
			}
		}
		if(!((isU2764(vlTextSegment[j11].clMsg[idx-1])) || (isMWBGHighSurrogates(vlTextSegment[j11].clMsg[idx-1])))){
			return false;
		}
		if(decrememnt) idx--;

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 1f48b or MWBG
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!(is1f48bLowSurrogates(vlTextSegment[j11].clMsg[idx])    || isMWBGLowSurrogates(vlTextSegment[j11].clMsg[idx]))){
			return false;
		}
		if(!((is1f48bHighSurrogates(vlTextSegment[j11].clMsg[idx-1])) || (isMWBGHighSurrogates(vlTextSegment[j11].clMsg[idx-1])))){
			return false;
		}
		
		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(isU200x(           vlTextSegment[j11].clMsg[idx])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isMWBGLowSurrogates( vlTextSegment[j11].clMsg[idx])){
				return false;
			}
			if(!isMWBGHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
				return false;
			}
		}else{
			idx--;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);
		
		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}
	
	static private boolean check_1fxxx_fe0x_Group(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int magica = 0;

		// 1fxxx
		int idx = j2;
		if(!inU2xxx(vlTextSegment[j11].clMsg[j2])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
				return false;
			}
			if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
				return false;
			}
		}

		// fe0x
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(isU200x(vlTextSegment[j11].clMsg[idx])){
			// sex
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(isU26a7(vlTextSegment[j11].clMsg[idx])){
			}else 
			if(!isSex(vlTextSegment[j11].clMsg[idx])){
				return false;
			}

			// fe0x
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
				idx--;
				magica = 1;
			}
		}else{
			idx--;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, magica, 0);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}
	
	static private boolean check_26f9_skin_Group(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		if(j2 < 0) return false;

		int magica = 0;
		
		int idx = j2;
		if(!isU26f9(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		boolean noSkin = false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
				noSkin = true;
			}
			if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
				noSkin = true;
			}
			if(noSkin){
				idx = idx -2;
			}
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(         vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSex(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			idx--;
			magica = 1;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, magica, 0);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}
	
	static private boolean check_MWBG_skin_200x_1fxxx(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isMWBGLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isMWBGHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(         vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}
	
	static private boolean check_1f3f3_fe0f_200d_1f308(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx] != '\udff3'){
			return false;
		}
		if(vlTextSegment[j11].clMsg[j2] != '\ud83c'){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(         vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx] != '\ud83c'){
			return false;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx] != '\udf08'){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}
	
	static private boolean check_subdivision_flag(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx] != '\udff4'){
			return false;
		}
		if(vlTextSegment[j11].clMsg[j2]  != '\ud83c'){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx]    != '\udc67'){
			return false;
		}
		if(vlTextSegment[j11].clMsg[idx-1]  != '\udb40'){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx]    != '\udc62'){
			return false;
		}
		if(vlTextSegment[j11].clMsg[idx-1]  != '\udb40'){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!(vlTextSegment[j11].clMsg[idx] == '\udc65' || vlTextSegment[j11].clMsg[idx] == '\udc73' || vlTextSegment[j11].clMsg[idx] == '\udc77')){
			return false;
		}
		if(vlTextSegment[j11].clMsg[idx-1]  != '\udb40'){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!(vlTextSegment[j11].clMsg[idx] == '\udc6e' || vlTextSegment[j11].clMsg[idx] == '\udc63' || vlTextSegment[j11].clMsg[idx] == '\udc6c')){
			return false;
		}
		if(vlTextSegment[j11].clMsg[idx-1]  != '\udb40'){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!(vlTextSegment[j11].clMsg[idx] == '\udc67' || vlTextSegment[j11].clMsg[idx] == '\udc74' || vlTextSegment[j11].clMsg[idx] == '\udc73')){
			return false;
		}
		if(vlTextSegment[j11].clMsg[idx-1]  != '\udb40'){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx]    != '\udc7f'){
			return false;
		}
		if(vlTextSegment[j11].clMsg[idx-1]  != '\udb40'){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}

	static private boolean check_1fxxx_200x_Group(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int magica = 0;

		int idx = j2;
		if(!inU2xxx(vlTextSegment[j11].clMsg[j2])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
				return false;
			}
			if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
				return false;
			}
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(         vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(isSex(            vlTextSegment[j11].clMsg[idx])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
				idx--;
				magica = 1;
			}
		}else if(inU2xxx(vlTextSegment[j11].clMsg[idx]) || inU3xxx(vlTextSegment[j11].clMsg[idx])){
			magica = 1;
		}else if(isHighSurrogates(vlTextSegment[j11].clMsg[idx])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
				return false;
			}
		}else{
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
				return false;
			}
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, magica, 0);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}
	
	static private boolean check_keyCap(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, int Java){
		if(j2 < 0) return false;

		int idx = j2;
		if(!isNumSharpAsta(vlTextSegment[j11].clMsg[idx])){
			return false;
		}		

		boolean U20e3 = false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			if(!isU20e3(vlTextSegment[j11].clMsg[idx])){
				if(Java == 7){
					return false;
				}else{
					int InlineMsgImgTextSegment_index = -1;
					for(int i=j11-1; i>=0; i--){
						if(vlTextSegment[i] instanceof V2CInlineMsgImgTextSegment){
							InlineMsgImgTextSegment_index = i;
							break;
						}
					}
					if(InlineMsgImgTextSegment_index != -1){
						String target = Integer.toHexString(vlTextSegment[j11].clMsg[j2]);
						String name = ((V2CInlineMsgImgTextSegment) vlTextSegment[InlineMsgImgTextSegment_index]).getImageSet().fOriginalFile.getName();
						if(name.indexOf(target) == 0){
							vlTextSegment[InlineMsgImgTextSegment_index] = new V2CTextSegment(); 
							return true;
						}else{
							return false;
						}
					}else{
						return false;
					}
				}
			}else{
				U20e3 = true;
			}
		}

		if(!U20e3){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isU20e3(vlTextSegment[j11].clMsg[idx])){
				return false;
			}
		}

		ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}
	
	static private boolean check_keyCap(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		if(j2 < 0) return false;

		int idx = j2;
		if(!isNumSharpAsta(vlTextSegment[j11].clMsg[idx])){
			return false;
		}		

		boolean fe0x = true;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(vlTextSegment[j11].clMsg[idx])){
			idx--;
			fe0x = false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU20e3(vlTextSegment[j11].clMsg[idx])){
			if(Java == 7) return false;
			if(!fe0x){
				// fe0x無し
				int InlineMsgImgTextSegment_index = -1;
				for(int i=j11-1; i>=0; i--){
					if(vlTextSegment[i] instanceof V2CInlineMsgImgTextSegment){
						InlineMsgImgTextSegment_index = i;
						break;
					}
				}
				if(InlineMsgImgTextSegment_index != -1){
					String target = Integer.toHexString(vlTextSegment[j11].clMsg[j2]);
					String name = ((V2CInlineMsgImgTextSegment) vlTextSegment[InlineMsgImgTextSegment_index]).getImageSet().fOriginalFile.getName();
					if(name.indexOf(target) == 0){
						vlTextSegment[InlineMsgImgTextSegment_index] = new V2CTextSegment(); 
						return true;
					}else{
						return false;
					}
				}else{
					return false;
				}
			}else{
				// fe0x有り
				return false;
			}
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, 1, 0);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}
	
	static private boolean check_1fxxx_skin_Group(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int magica = 0;

		// 1fxxx
		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		// skin
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// fe0x or 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(isFe0x(vlTextSegment[j11].clMsg[idx])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(isU200x(vlTextSegment[j11].clMsg[idx])){
				if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
				if(!(isSex(vlTextSegment[j11].clMsg[idx]) || inU2xxx(vlTextSegment[j11].clMsg[idx]) || inU3xxx(vlTextSegment[j11].clMsg[idx]))){
					return false;
				}

				if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
				if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
					idx--;
				}
			}else{
				idx--;
			}

		}else
		if(isU200x(vlTextSegment[j11].clMsg[idx])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!(isSex(vlTextSegment[j11].clMsg[idx]) || inU2xxx(vlTextSegment[j11].clMsg[idx]) || inU3xxx(vlTextSegment[j11].clMsg[idx]))){
				return false;
			}

			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
				idx--;
				magica = 1;
			}
		}else{
			idx--;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, magica, 0);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}
	
	static private boolean check_1fxxx_1fxxx(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}
	
	static private boolean check_any_skin_Group(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		int magica = 0;

		int idx = j2;

		// skin
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// fe0x or 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(isFe0x(vlTextSegment[j11].clMsg[idx])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(isU200x(vlTextSegment[j11].clMsg[idx])){
				if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
				if(!(isSex(vlTextSegment[j11].clMsg[idx]) || inU2xxx(vlTextSegment[j11].clMsg[idx]) || inU3xxx(vlTextSegment[j11].clMsg[idx]))){
					return false;
				}

				if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
				if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
					idx--;
					magica = 1;
				}
			}else{
				idx--;
			}

		}else
		if(isU200x(vlTextSegment[j11].clMsg[idx])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!(isSex(vlTextSegment[j11].clMsg[idx]) || inU2xxx(vlTextSegment[j11].clMsg[idx]) || inU3xxx(vlTextSegment[j11].clMsg[idx]))){
				return false;
			}

			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
				idx--;
				magica = 1;
			}
		}else{
			idx--;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, magica, 0);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}
	
	static private boolean check_any_fe0x(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		if(Java != 6) return false;
		if(isU2764(vlTextSegment[j11].clMsg[j2])) return false;
		int idx = j2;

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}
	
	static private boolean check_SingleFlag(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		int idx = j2;

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!(
			(vlTextSegment[j11].clMsg[idx] == '\udfc1' && vlTextSegment[j11].clMsg[idx-1] == '\ud83c') ||
			(vlTextSegment[j11].clMsg[idx] == '\udea9' && vlTextSegment[j11].clMsg[idx-1] == '\ud83d') ||
			(vlTextSegment[j11].clMsg[idx] == '\udf8c' && vlTextSegment[j11].clMsg[idx-1] == '\ud83c') ||
			(vlTextSegment[j11].clMsg[idx] == '\udff4' && vlTextSegment[j11].clMsg[idx-1] == '\ud83c') ||
			(vlTextSegment[j11].clMsg[idx] == '\udff3' && vlTextSegment[j11].clMsg[idx-1] == '\ud83c')
			)
		){
			return false;
			
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}

	static private boolean check_1fxxx(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		int wk_idx = idx;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(isNFHighSurrogates(vlTextSegment[j11].clMsg[idx])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(isNFLowSurrogates( vlTextSegment[j11].clMsg[idx])){
				return false;
			}
		}

		idx = wk_idx;
		
		boolean doZWZPPadding = true;
		if(remove) if(Java == 6) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);
		
		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}
	
	static private boolean check_inU2xxx(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		if(j2 < j2e){
			if(isU2764(vlTextSegment[j11].clMsg[j2]) && isFe0x(vlTextSegment[j11].clMsg[j2+1])) return false;
			if(isU2764(vlTextSegment[j11].clMsg[j2]) && isU200x(vlTextSegment[j11].clMsg[j2+1])) return false;
		}
		int idx = j2;

		if(!inU2xxx(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) if(Java == 6){
			if(Other_Remove_EX1f3fb(vlTextSegment, j11, j2, idx, 0) == false){
				doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);
			}
		}

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		idx++;
		if(idx < j2e){
			if(isFe0x(vlTextSegment[j11].clMsg[idx])){
				vlTextSegment[j11].clMsg[idx]   = c_ZERO_WIDTH_SPACE;
			}			
		}

		return true;
	}
	
	static private boolean check_inU3xxx(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment){
		int idx = j2;

		if(!inU3xxx(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		idx++;
		if(idx < j2e){
			if(isFe0x(vlTextSegment[j11].clMsg[idx])){
				vlTextSegment[j11].clMsg[idx]   = c_ZERO_WIDTH_SPACE;
			}			
		}

		return true;
	}
	
	static private boolean check_iniMode(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean isBakusai){
		int idx = j2;

		if(!iniMode(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if(isBakusai){
			ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

			return true;
		}else{
			vlTextSegment[j11-1] = new V2CTextSegment();

			return true;
		}
	}
	
	static private boolean check_inOther(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment){
		int idx = j2;
		
		if(!inOther(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}
	

	static void OverJava7(V2CTextSegment[] vlTextSegment, boolean isBakusai){
		for(int j1=0; j1<vlTextSegment.length-1; j1++){
			if(vlTextSegment[j1] != null){
				int j11 = j1 + 1;
				if(vlTextSegment[j1] instanceof V2CInlineMsgImgTextSegment && vlTextSegment[j11] instanceof V2CTextSegment){
					if(vlTextSegment[j11].clMsg != null){
						int j2=vlTextSegment[j11].getSegmentStartIndex();
						int j2e=vlTextSegment[j11].clMsg.length;
						check_sequence(j11, j2, j2e, vlTextSegment, 0, 7, isBakusai);
					}
				}
			}
		}
	}
	
	static void UnderJava6(V2CTextSegment[] vlTextSegment, boolean isBakusai){
		for(int j1=0; j1<vlTextSegment.length-1; j1++){
			if(vlTextSegment[j1] != null){
				int j11 = j1 + 1;
				if(vlTextSegment[j1] instanceof V2CInlineMsgImgTextSegment && vlTextSegment[j11] instanceof V2CTextSegment){
					if(vlTextSegment[j11].clMsg != null){
						int j2=vlTextSegment[j11].getSegmentStartIndex();
						int j2e=vlTextSegment[j11].clMsg.length;
						check_sequence(j11, j2, j2e, vlTextSegment, 1, 6, isBakusai);
					}
				}
			}
		}
	}
	
	static private void check_sequence(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, int rb, int Java, boolean isBakusai){
		if(check_1fxxx_skin_200d_27a1_fe0f(j11, j2, j2e, vlTextSegment, true, Java)){	// twemoji v15.1
			printFunction("check_1fxxx_skin_200d_27a1_fe0f");
		}else

		if(check_1fxxx_skin_200d_1fxxx_sex_fe0f_200d_27a1_fe0f(j11, j2, j2e, vlTextSegment, true, Java)){	// twemoji v15.1
			printFunction("check_1fxxx_skin_200d_1fxxx_sex_fe0f_200d_27a1_fe0f");
		}else

		if(check_MWBG_200d_Group(j11, j2-rb, j2e, vlTextSegment, true)){
			printFunction("check_MWBG_200d_Group");
		}else

		if(check_NextisNF(j11, j2-rb, j2e, vlTextSegment, true)){	// twemoji v14.1.2
			printFunction("check_NextisNF");
		}else
		if(check_1faf8_skin(j11, j2-rb, j2e, vlTextSegment, true)){	// twemoji v14.1.2 (Unicode Emoji v15.0)
			printFunction("check_1faf8_skin");
		}else
		if(check_1fxxx_skin_200d_1fxxx_200d_1fxxx_skin(j11, j2-rb, j2e, vlTextSegment, true)){	// twemoji v14.1.2
			printFunction("check_1fxxx_skin_200d_1fxxx_200d_1fxxx_skin");
		}else
		if(check_1fxxx_skin_200d_1fxxx_skin(j11, j2-rb, j2e, vlTextSegment, true)){	// twemoji v14.1.2
			printFunction("check_1fxxx_skin_200d_1fxxx_skin");
		}else
		if(check_1fxxx_skin_200d_2764_fe0f_200d_1fxxx_200d_1fxxx_skin(j11, j2-rb, j2e, vlTextSegment, true)){	// twemoji v14.1.2
			printFunction("check_1fxxx_skin_200d_2764_fe0f_200d_1fxxx_200d_1fxxx_skin");
		}else
		if(check_1fxxx_skin_200d_2764_fe0f_200d_1fxxx_skin(j11, j2-rb, j2e, vlTextSegment, true)){	// twemoji v14.1.2
			printFunction("check_1fxxx_skin_200d_2764_fe0f_200d_1fxxx_skin");
		}else
		if(check_1fxxx_200d_2b1x(j11, j2-rb, j2e, vlTextSegment, true)){	// twemoji v14.1.2
			printFunction("check_1fxxx_200d_2b1x");
		}else
		if(check_1fxxx_200d_1fxxx_200d_1fxxx(j11, j2-rb, j2e, vlTextSegment, true)){	// twemoji v14.1.2
			printFunction("check_1fxxx_200d_1fxxx_200d_1fxxx");
		}else
		if(check_1fxxx_skin_200d_1fxxx(j11, j2-rb, j2e, vlTextSegment, true)){	// twemoji v14.1.2
			printFunction("check_1fxxx_skin_200d_1fxxx");
		}else
		if(check_2764_fe0f_200d_1fxxx(j11, j2-rb, j2e, vlTextSegment, true, Java)){	// twemoji v14.1.2
			printFunction("check_2764_fe0f_200d_1fxxx");
		}else
		if(check_2764_fe0f(j11, j2-rb, j2e, vlTextSegment, true, Java)){	// twemoji v15.1
			printFunction("check_2764_fe0f");
		}else
		if(check_26d3_fe0f_200d_1fxxx(j11, j2-rb, j2e, vlTextSegment, true, Java)){	// twemoji v15.1
			printFunction("check_26d3_fe0f_200d_1fxxx");
		}else
		if(check_1fxxx_fe0f_200d_1fxxx_fe0f(j11, j2-rb, j2e, vlTextSegment, true)){	// twemoji v14.1.2
			printFunction("check_1fxxx_fe0f_200d_1fxxx_fe0f");
		}else
		if(check_NationalFlag(j11, j2-rb, j2e, vlTextSegment, true, Java)){	// twemoji v14.1.2
			printFunction("check_NationalFlag");
		}else
		if(check_Alphabet(j11, j2-rb, j2e, vlTextSegment, true)){	// twemoji v14.1.2
			printFunction("check_Alphabet");
		}else

		if(check_MWBG_skin_200x_1fxxx(j11, j2-rb, j2e, vlTextSegment, true)){
			printFunction("check_MWBG_skin_200x_1fxxx");
		}else

		if(check_1f3f3_fe0f_200d_1f308(j11, j2-rb, j2e, vlTextSegment, true)){
			printFunction("check_1f3f3_fe0f_200d_1f308");
		}else
		if(check_subdivision_flag(j11, j2-rb, j2e, vlTextSegment, true)){
			printFunction("check_subdivision_flag");
		}else
		if(check_1f3f3_fe0f_200d_26a7_fe0f(j11, j2-rb, j2e, vlTextSegment, true)){
			printFunction("check_1f3f3_fe0f_200d_26a7_fe0f");
		}else
			
		if(check_1fxxx_skin_Group(j11, j2-rb, j2e, vlTextSegment, true)){
			printFunction("check_1fxxx_skin_Group");
		}else

		if(check_1fxxx_fe0x_Group(j11, j2-rb, j2e, vlTextSegment, true)){
			printFunction("check_1fxxx_fe0x_Group");
		}else

		if(check_1fxxx_200x_Group(j11, j2-rb, j2e, vlTextSegment, true)){
			printFunction("check_1fxxx_200x_Group");
		}else
		if(check_1f415_200d_1f9ba(j11, j2-rb, j2e, vlTextSegment, true)){
			printFunction("check_1f415_200d_1f9ba");
		}else

		if(check_SingleFlag(j11, j2-rb, j2e, vlTextSegment, true, Java)){
			printFunction("check_SingleFlag");
		}else
		if(check_1fxxx(j11, j2-rb, j2e, vlTextSegment, true, Java)){
			printFunction("check_1fxxx");
		}else
		if(check_1fxxx_1fxxx(j11, j2-rb, j2e, vlTextSegment, true)){
			printFunction("check_1fxxx_1fxxx");
		}else

		if(check_26f9_skin_Group(j11, j2, j2e, vlTextSegment, true, Java)){
			printFunction("check_26f9_skin_Group");
		}else

		if(check_any_skin_Group(j11, j2, j2e, vlTextSegment, true)){
			printFunction("check_any_skin_Group");
		}else
		if(check_keyCap(j11, j2, j2e, vlTextSegment, true, Java)){
			printFunction("check_keyCap");
		}else
		if(check_any_fe0x(j11, j2, j2e, vlTextSegment, true, Java)){
			printFunction("check_any_fe0x");
		}else

		if(check_inU2xxx(j11, j2, j2e, vlTextSegment, true, Java)){
			printFunction("check_inU2xxx");
		}else
		if(check_inU3xxx(j11, j2, j2e, vlTextSegment)){
			printFunction("check_inU3xxx");
		}else
		if(check_iniMode(j11, j2, j2e, vlTextSegment, isBakusai)){
			printFunction("check_iniMode");
		}else
		if(check_inOther(j11, j2, j2e, vlTextSegment)){
			printFunction("check_inOther");
		}
	}

	static private boolean check_1f415_200d_1f9ba(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(         vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx] != '\u2b1b'){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, 1, 0);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}

	static private boolean check_1f3f3_fe0f_200d_26a7_fe0f(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx] != '\udff3'){
			return false;
		}
		if(vlTextSegment[j11].clMsg[j2] != '\ud83c'){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(         vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx] != '\u26a7'){
			return false;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}

	// twemoji v14.1.2
	static private boolean check_1fxxx_skin_200d_1fxxx_skin(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}

	static private boolean check_1fxxx_skin_200d_1fxxx(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}

	static private boolean check_1fxxx_skin_200d_1fxxx_200d_1fxxx_skin(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		// 1fxxx
		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		// skin
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 1fxxx
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 1fxxx
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// skin
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}

	static private boolean check_1fxxx_skin_200d_2764_fe0f_200d_1fxxx_skin(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		// 1fxxx
		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		// skin
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 2764
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU2764(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// fe0f
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
			idx--;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 1fxxx
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// skin
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}

	static private boolean check_1fxxx_200d_1fxxx_200d_1fxxx(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		// 1fxxx
		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 1fxxx
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 1fxxx
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(isU200x(           vlTextSegment[j11].clMsg[idx])){
			// 1fxxx
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
			if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
				return false;
			}
			if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
				return false;
			}
		}else{
			idx--;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}

	static private boolean check_1fxxx_skin_200d_2764_fe0f_200d_1fxxx_200d_1fxxx_skin(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		// 1fxxx
		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		// skin
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 2764
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU2764(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// fe0f
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
			idx--;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 1fxxx
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 1fxxx
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		// skin
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}

	static private boolean check_2764_fe0f_200d_1fxxx(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		if(Java != 6 && j2 < 0) return false;

		int MagicMumber = 0;
		if(Java == 6){
			j2++;
		}

		int idx = j2;
		if(!isU2764(vlTextSegment[j11].clMsg[j2])){
			return false;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			idx--;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, 0, MagicMumber);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}

	static private boolean check_2764_fe0f(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		if(Java != 6) return false;

		j2++;

		int idx = j2;
		if(!isU2764(vlTextSegment[j11].clMsg[j2])){
			return false;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}

	static private boolean check_26d3_fe0f_200d_1fxxx(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		if(Java != 6 && j2 < 0) return false;

		int MagicMumber = 0;
		if(Java == 6){
			j2++;
		}

		int idx = j2;
		if(!isU26d3(vlTextSegment[j11].clMsg[j2])){
			return false;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			idx--;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, 0, MagicMumber);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}

	static private boolean check_1fxxx_fe0f_200d_1fxxx_fe0f(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			idx--;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(           vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			idx--;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}

	static private boolean check_1faf8_skin(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx] != '\udef7'){
			return false;
		}
		if(vlTextSegment[j11].clMsg[j2] != '\ud83e'){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}

	static private boolean check_1fxxx_200d_2b1x(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(         vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(vlTextSegment[j11].clMsg[idx] != '\u2b1b' && vlTextSegment[j11].clMsg[idx] != '\u2b1c'){
			return false;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, 1, 0);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}

	static private boolean check_Alphabet(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!inAlphabet( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(vlTextSegment[j11].clMsg[j2] != '\ud83c'){
			return false;
		}
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(          vlTextSegment[j11].clMsg[idx])){
			idx--;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, 1, 0);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}

	static private boolean check_NationalFlag(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		if(j2 < 0) return false;

		char mae;
		char ato;

		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isNFLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		mae = vlTextSegment[j11].clMsg[idx];
		if(!isNFHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isNFLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		ato = vlTextSegment[j11].clMsg[idx];
		if(!isNFHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(isFe0x(         vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		idx--;

		char[] arr = (char[]) NFHMmap.get(mae); 
		if(arr != null){
			boolean exists = false;
			for(int i=0; i<arr.length; i++){
				if(ato == arr[i]){
					exists = true;
					break;
				}
			}
			if(!exists){
				return false;
			}
		}else{
			return false;
		}
		
		
		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx, 1);
		
		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);

		return true;
	}
	
	static private boolean check_NextisNF(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove){
		if(j2 < 0) return false;

		int idx = j2;
		if(isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		}
		if(inAlphabet( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		int idx2 = idx;

		char mae;
		char ato;

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isNFLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		mae = vlTextSegment[j11].clMsg[idx];
		if(!isNFHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isNFLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		ato = vlTextSegment[j11].clMsg[idx];
		if(!isNFHighSurrogates(vlTextSegment[j11].clMsg[idx-1])){
			return false;
		}

		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(isFe0x(         vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		idx--;

		char[] arr = (char[]) NFHMmap.get(mae); 
		if(arr != null){
			boolean exists = false;
			for(int i=0; i<arr.length; i++){
				if(ato == arr[i]){
					exists = true;
					break;
				}
			}
			if(!exists){
				return false;
			}
		}else{
			return false;
		}
		
		
		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_Remove(vlTextSegment, j11, j2, idx2, 1);
		
		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx2);

		return true;
	}

	static private boolean check_1fxxx_skin_200d_27a1_fe0f(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		if(j2 < 0) return false;

		// 1fxxx
		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		// skin
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!(isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx]) && !isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1]))){
			idx = idx -2;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 27a1
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU27a1(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// fe0x
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
			idx--;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, 1, 0);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}

	static private boolean check_1fxxx_skin_200d_1fxxx_sex_fe0f_200d_27a1_fe0f(int j11, int j2, int j2e, V2CTextSegment[] vlTextSegment, boolean remove, int Java){
		if(j2 < 0) return false;

		int magica = 0;
		if(Java == 6){
			if(j2 != 0) j2--;
		}

		// 1fxxx
		int idx = j2;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isLowSurrogates( vlTextSegment[j11].clMsg[idx])){
			return false;
		}
		if(!isHighSurrogates(vlTextSegment[j11].clMsg[j2])){
			return false;
		}

		// skin
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!(isSkinLowSurrogates( vlTextSegment[j11].clMsg[idx]) && isSkinHighSurrogates(vlTextSegment[j11].clMsg[idx-1]))){
			idx = idx - 2;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 1fxxx
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!(isLowSurrogates( vlTextSegment[j11].clMsg[idx]) && isHighSurrogates(vlTextSegment[j11].clMsg[idx-1]))){
			idx = idx - 2;
		}

		// sex
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isSex(vlTextSegment[j11].clMsg[idx])){
			idx--;
		}

		// fe0x
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
			idx--;
			magica = 1;
		}

		// 200d
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU200x(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// 27a1
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isU27a1(vlTextSegment[j11].clMsg[idx])){
			return false;
		}

		// fe0x
		if((idx = idxIncrememnt(idx, j2e, vlTextSegment[j11])) == -1) return false;
		if(!isFe0x(         vlTextSegment[j11].clMsg[idx])){
			idx--;
			magica = 1;
		}

		boolean doZWZPPadding = true;
		if(remove) doZWZPPadding = Other_RemoveO(vlTextSegment, j11, j2, idx, 1, magica, 0);

		if(doZWZPPadding) ZERO_WIDTH_SPACE_PADDING(vlTextSegment, j11, j2, idx);
		
		return true;
	}

	private static void printFunction(String name){
		if(dp) System.out.println(name);
	}

	private static void printEmojiCode(String name, String value){
		if(dp) System.out.println(name + "=" + value);
	}
}
