package org.monazilla.v2c;

import java.security.AccessControlContext;
import java.security.PrivilegedExceptionAction;

public class V2CSubjectScript extends V2CSystemScript
{

	static boolean checkSubjectDefined()
	{
		return getInstance() != null;
	}

	private static V2CSubjectScript getInstance()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return null;
		if (!bLoadTried) {
			bLoadTried = true;
			vSubjectScript = (V2CSubjectScript) V2CScriptUtil.createSystemScript("subject.js");
		}
		return vSubjectScript;
	}

	static void reload()
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return;
		V2CSubjectScript v2csubjectscript = vSubjectScript;
		if (v2csubjectscript != null) {
			v2csubjectscript.stop();
			vSubjectScript = null;
		}
		V2CScriptUtil.printMessage("subject.js\u3092\u8AAD\u307F\u8FBC\u3093\u3067\u3044\u307E\u3059\u2026");
		bLoadTried = false;
		v2csubjectscript = getInstance();
		V2CScriptUtil.printMessage("subject.js\u3092\u8AAD\u307F\u8FBC"
				+ (v2csubjectscript == null ? "\u3081\u307E\u305B\u3093\u3067\u3057\u305F\u3002"
						: "\u307F\u307E\u3057\u305F\u3002"));
	}

	static V2CSubjectScript createSubjectScript(String s, V2CScriptClassLoader v2cscriptclassloader,
			AccessControlContext accesscontrolcontext)
	{
		V2CScriptApp v2cscriptapp = new V2CScriptApp("subject.js");
		String s1 = null;
		PrivilegedExceptionAction privilegedexceptionaction = null;
		try {
			privilegedexceptionaction = V2CJSE6Util.createScriptAction("JavaScript", s, v2cscriptapp, v2cscriptclassloader,
					accesscontrolcontext, false);
		}
		catch (Exception exception) {
			s1 = exception.getMessage();
		}
		if (privilegedexceptionaction == null) {
			V2CScriptUtil
					.setErrorMessage(s1 == null ? "\u30A2\u30AF\u30B7\u30E7\u30F3\u306E\u4F5C\u6210\u306B\u5931\u6557\u3057\u307E\u3057\u305F\u3002"
							: s1);
			return null;
		}
		else {
			V2CSubjectScript v2csubjectscript = new V2CSubjectScript(privilegedexceptionaction, v2cscriptapp,
					v2cscriptclassloader, accesscontrolcontext);
			v2csubjectscript.exec();
			return v2csubjectscript;
		}
	}

	static String checkSubject(String s, V2CBoardItem v2cboarditem)
	{
		if (v2cboarditem == null)
			return s;
		V2CSubjectScript v2csubjectscript = getInstance();
		if (v2csubjectscript == null)
			return s;
		else
			return v2csubjectscript.checkSubject(s, V2CScriptBoard.createInstance(v2cboarditem));
	}

	private V2CSubjectScript(PrivilegedExceptionAction privilegedexceptionaction, V2CScriptApp v2cscriptapp,
			V2CScriptClassLoader v2cscriptclassloader, AccessControlContext accesscontrolcontext)
	{
		super(privilegedexceptionaction, v2cscriptapp, v2cscriptclassloader, accesscontrolcontext);
	}

	synchronized String checkSubject(String s, V2CScriptBoard v2cscriptboard)
	{
		if (bReloading) {
			return null;
		}
		else {
			V2CJSE6Util.setInvokeFunction(vPrivilegedExceptionAction, "checkSubject", new Object[] { s, v2cscriptboard,
					new Object() });
			return (String) exec();
		}
	}

	static final String sScriptFileName = "subject.js";
	private static boolean bLoadTried;
	private static V2CSubjectScript vSubjectScript;
}
