package org.monazilla.v2c;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;

import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class V2CSplitPane extends JSplitPane
{

	public V2CSplitPane()
	{
		setFocusable(false);
		disableRightDrag();

		if(V2CDarkMode.using){
			BasicSplitPaneUI ui = (BasicSplitPaneUI) this.getUI();
			BasicSplitPaneDivider divider = ui.getDivider();
			divider.setDividerSize(UIManager.getInt("SplitPane.dividersize"));
			setBackground(UIManager.getColor("SplitPane.background"));
		}
	}

	public V2CSplitPane(int i)
	{
		super(i);
		setFocusable(false);
		disableRightDrag();

		if(V2CDarkMode.using){
			BasicSplitPaneUI ui = (BasicSplitPaneUI) this.getUI();
			BasicSplitPaneDivider divider = ui.getDivider();
			divider.setDividerSize(UIManager.getInt("SplitPane.dividersize"));
			setBackground(UIManager.getColor("SplitPane.background"));
		}
	}

	private void disableRightDrag()
	{
		for (int i = getComponentCount() - 1; i >= 0; i--) {
			final Component ci = getComponent(i);
			if (ci instanceof BasicSplitPaneDivider) {
				MouseInputAdapter mouseinputadapter = new MouseInputAdapter() {

					public void mousePressed(final MouseEvent e)
					{
						if (e.getClickCount() == 1 && V2CSwingUtil.isSimpleClick(e, 3))
							SwingUtilities.invokeLater(new Runnable() {

								public void run()
								{
									ci.dispatchEvent(new MouseEvent(ci, 502, e.getWhen(), 256, e.getX(), e.getY(), 1, false, e
											.getButton()));
								}
							});
					}
				};
				ci.addMouseListener(mouseinputadapter);
			}
		}

	}

	boolean requestDividerLocation(int i)
	{
		nDividerLocationRequest = i;
		int j = getOrientation() != 1 ? getHeight() : getWidth();
		boolean flag;
		if (getResizeWeight() < 0.5D) {
			flag = true;
		}
		else {
			i = j - getDividerSize() - i;
			flag = i > 0;
		}
		if (flag)
			setDividerLocation(i);
		else
			invalidate();
		return flag;
	}

	public void doLayout()
	{
		super.doLayout();
		final int nvr = nDividerLocationRequest;
		if (nvr <= 0)
			return;
		int i = getDividerLocation();
		int j = getOrientation() != 1 ? getHeight() : getWidth();
		int k;
		if (getResizeWeight() < 0.5D) {
			k = nvr;
			if (nvr >= j)
				return;
		}
		else {
			k = j - getDividerSize() - nvr;
			if (k <= 0)
				return;
		}
		if (i != k)
			EventQueue.invokeLater(new Runnable() {

				public void run()
				{
					int l;
					if (getResizeWeight() < 0.5D)
						l = nvr;
					else
						l = (getOrientation() != 1 ? getHeight() : getWidth()) - getDividerSize() - nvr;
					setDividerLocation(l);
				}
			});
		else
			nDividerLocationRequest = -1;
	}

	int nDividerLocationRequest;
}
