package org.monazilla.v2c;

import java.awt.*;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.*;
import java.io.*;

import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.swing.SwingUtilities;

import org.w3c.dom.*;

public class V2CSingleImage
{

	public V2CSingleImage(V2CSingleImage v2csingleimage, double d, AffineTransformOp affinetransformop, boolean flag, String s)
	{
		nDelayTime = 500;
		Image image = v2csingleimage.iImage;
		nX = (int) (d * (double) v2csingleimage.nX);
		nY = (int) (d * (double) v2csingleimage.nY);
		bInterlace = v2csingleimage.bInterlace;
		bTransparent = v2csingleimage.bTransparent;
		iDisposalMethod = v2csingleimage.iDisposalMethod;
		nDelayTime = v2csingleimage.nDelayTime;
		if (flag) {
			v2csingleimage.setScaledImageCreated(s);
			int i = image.getWidth(null);
			int k = image.getHeight(null);
			if (i <= 0 || k <= 0)
				return;
			int i1 = Math.max((int) Math.round(d * (double) i), 1);
			int k1 = Math.max((int) Math.round(d * (double) k), 1);
			nWidth = i1;
			nHeight = k1;
			int i2 = i * k;
			int ai[] = new int[i2];
			PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, i, k, ai, 0, i);
			try {
				pixelgrabber.grabPixels();
			}
			catch (InterruptedException interruptedexception) {
				interruptedexception.printStackTrace();
			}
			if ((pixelgrabber.getStatus() & 0x80) != 0)
				System.out.println("image fetch aborted or errored");
			int k2;
			int l2;
			int i3;
			int j3;
			if (d < 0.10000000000000001D) {
				int k3 = (int) (1.0D - (2D * Math.log(d * 10D)) / Math.log(2D));
				if (k3 > 14)
					k3 = 14;
				int l3 = k3 / 2;
				k2 = 255 >>> 7 - l3;
				j3 = 8 - (k3 - l3);
				l2 = 256 >>> 8 - j3;
				i3 = l2 - 1;
			}
			else {
				k2 = 1;
				j3 = 8;
				l2 = 256;
				i3 = 255;
			}
			int ai1[] = new int[i1 * k1];
			int i4 = 0;
			for (int j4 = 0; j4 < k1; j4++) {
				int k4 = (j4 * k) / k1;
				int l4 = l2 - ((j4 * k << j3) / k1 & i3);
				int i5 = ((j4 + 1) * k) / k1;
				int j5 = ((j4 + 1) * k << j3) / k1 & i3;
				for (int k5 = 0; k5 < i1; k5++) {
					int l5 = (k5 * i) / i1;
					int i6 = l2 - ((k5 * i << j3) / i1 & i3);
					int j6 = ((k5 + 1) * i) / i1;
					int k6 = ((k5 + 1) * i << j3) / i1 & i3;
					int l6 = 0;
					int i7 = 0;
					int j7 = 0;
					int k7 = 0;
					int l7 = 0;
					for (int i8 = k4; i8 <= i5 && i8 < k; i8++) {
						int k8 = i8 * i;
						int l8;
						if (i8 == k4)
							l8 = l4;
						else if (i8 == i5) {
							if (j5 == 0)
								continue;
							l8 = j5;
						}
						else {
							l8 = l2;
						}
						for (int i9 = l5; i9 <= j6 && i9 < i; i9++) {
							int j9 = ai[k8 + i9];
							int k9 = j9 >>> 24;
							int l9 = j9 >>> 16 & 0xff;
							int i10 = j9 >>> 8 & 0xff;
							int j10 = j9 & 0xff;
							int k10;
							if (i9 == l5)
								k10 = i6;
							else if (i9 == j6) {
								if (k6 == 0)
									continue;
								k10 = k6;
							}
							else {
								k10 = l2;
							}
							if (l8 != l2)
								k10 = k10 * l8 >>> 8;
							int l10 = k9 * k10;
							l7 += k10;
							l6 += l10;
							i7 += (l9 * l10) / k2;
							j7 += (i10 * l10) / k2;
							k7 += (j10 * l10) / k2;
						}

					}

					int j8 = l6 / k2;
					if (j8 > 0)
						ai1[i4] = l6 / l7 << 24 | (i7 / j8 & 0xff) << 16 | (j7 / j8 & 0xff) << 8 | k7 / j8 & 0xff;
					i4++;
				}

			}

			BufferedImage bufferedimage2 = new BufferedImage(i1, k1, 2);
			bufferedimage2.setRGB(0, 0, i1, k1, ai1, 0, i1);
			iImage = bufferedimage2;
			pixelgrabber = null;
			bufferedimage2 = null;
			ai = null;
			ai1 = null;
		}
		else if (image instanceof BufferedImage) {
			BufferedImage bufferedimage = (BufferedImage) image;
			ColorModel colormodel = bufferedimage.getColorModel();
			int j1 = bufferedimage.getType();
			int l1 = Math.max((int) Math.round(d * (double) bufferedimage.getWidth()), 1);
			int j2 = Math.max((int) Math.round(d * (double) bufferedimage.getHeight()), 1);
			nWidth = l1;
			nHeight = j2;
			BufferedImage bufferedimage1 = new BufferedImage(colormodel, colormodel.createCompatibleWritableRaster(l1, j2),
					colormodel.isAlphaPremultiplied(), null);
			iImage = bufferedimage1;
			boolean flag1 = false;
			if (affinetransformop != null) {
				v2csingleimage.setScaledImageCreated(s);
				try {
					affinetransformop.filter(bufferedimage, bufferedimage1);
					flag1 = true;
				}
				catch (ImagingOpException imagingopexception) {
				}
			}
			if (!flag1) {
				Graphics2D graphics2d1 = (Graphics2D) iImage.getGraphics();
				graphics2d1.drawImage(image, 0, 0, l1, j2, null);
				graphics2d1.dispose();
				graphics2d1 = null;
			}
			bufferedimage = null;
			colormodel = null;
			bufferedimage1 = null;
		}
		else {
			int j = Math.max((int) Math.round(d * (double) image.getWidth(null)), 1);
			int l = Math.max((int) Math.round(d * (double) image.getHeight(null)), 1);
			nWidth = j;
			nHeight = l;
			iImage = V2CMain.v2cMain.createImage(j, l);
			Graphics2D graphics2d = (Graphics2D) iImage.getGraphics();
			graphics2d.drawImage(image, 0, 0, j, l, null);
			graphics2d.dispose();
			graphics2d = null;
		}
	}


	public V2CSingleImage(ImageReader imagereader, Object obj, int i, boolean use_jfif, int jpeg_color_model) throws IOException
	{
		nDelayTime = 500;
		boolean flag2 = true;
		if (obj instanceof File) {
			File file = (File) obj;
			if (use_jfif) {
				BufferedImage bufferedimage = null;
				try {
					bufferedimage = imagereader.read(0);
				}
				catch (IIOException iioexception) {
					WritableRaster raster = (WritableRaster)imagereader.readRaster(0, null);
					if (raster == null || raster.getNumBands() != 4) {
						throw iioexception;
					}
					if (jpeg_color_model == V2CImageInfo.COLORMODEL_YCCK) {
						convertYcckToCmyk(raster);
						jpeg_color_model = V2CImageInfo.COLORMODEL_CMYK;
					}
					// V2CMOD-twZ by MCZ, Date:2017/12/29, createImage failed !対応
					if (jpeg_color_model != V2CImageInfo.COLORMODEL_YCCK && jpeg_color_model != V2CImageInfo.COLORMODEL_CMYK) {
						try{
							convertYcckToCmyk(raster);
							jpeg_color_model = V2CImageInfo.COLORMODEL_CMYK;
						}catch(Exception e){
						}
					}
					// ---- END of V2CMOD-twZ ----
					if (jpeg_color_model == V2CImageInfo.COLORMODEL_CMYK) {

						// V2CMOD-twZ by MCZ, Date:2017/12/29, createImage failed !対応
						try{
						// ---- END of V2CMOD-twZ ----
							convertInvertedColors(raster);
							if (iccProfileCMYK == null) {
								iccProfileCMYK = ICC_Profile.getInstance(V2CSingleImage.class.getClassLoader().getResourceAsStream("org/monazilla/v2c/Generic CMYK Profile.icc"));
							}

							bufferedimage = convertCmykToRgb(raster, iccProfileCMYK);
						// V2CMOD-twZ by MCZ, Date:2017/12/29, createImage failed !対応
						}catch(Exception e){
							bufferedimage = null;
						}
						// ---- END of V2CMOD-twZ ----
					}
					/*
					StackTraceElement astacktraceelement[] = iioexception.getStackTrace();
					Raster raster = imagereader.readRaster(0, null);
					if (raster == null || raster.getNumBands() != 4)
						throw iioexception;
					int j = raster.getWidth();
					int k = raster.getHeight();
					bufferedimage = new BufferedImage(j, k, 2);
					float af[] = new float[5];
					float af1[] = new float[15];
					for (int l = 0; l < k; l++) {
						for (int i1 = 0; i1 < j; i1++) {
							raster.getPixel(i1, l, af);
							af[0] /= 256F;
							af[1] /= 256F;
							af[2] /= 256F;
							af[3] /= 256F;
							af[4] = 1.0F;
							int j1 = 0;
							for (int k1 = 0; k1 < 5; k1++) {
								float f1 = af[k1];
								for (int l1 = k1; l1 < 5; l1++)
									af1[j1++] = f1 * af[l1];

							}

							float f = 0.0F;
							float f2 = 0.0F;
							float f3 = 0.0F;
							for (int i2 = 0; i2 < 15; i2++) {
								f += af1[i2] * flcr[i2];
								f2 += af1[i2] * flcg[i2];
								f3 += af1[i2] * flcb[i2];
							}

							int j2 = Math.max(0, Math.min((int) (f * 255F), 255));
							int k2 = Math.max(0, Math.min((int) (f2 * 255F), 255));
							int l2 = Math.max(0, Math.min((int) (f3 * 255F), 255));
							bufferedimage.setRGB(i1, l, 0xff000000 | j2 << 16 | k2 << 8 | l2);
						}

					}
					*/
					raster = null;
				}
				iImage = bufferedimage;
				flag2 = false;				
				bufferedimage = null;
			}
			else {
				iImage = Toolkit.getDefaultToolkit().createImage(file.getPath());
			}
		}
		else if (obj instanceof byte[]) {
			iImage = Toolkit.getDefaultToolkit().createImage((byte[]) (byte[]) obj);
		}
		if (iImage == null)
			throw new IOException("createImage failed !");
		if (flag2) {
			MediaTracker mediatracker = new MediaTracker(V2CMain.v2cMain);
			mediatracker.addImage(iImage, 0);
			try {
				mediatracker.waitForAll();
			}
			catch (InterruptedException interruptedexception) {
				throw new IOException("image loading interrupted !");
			}
			if (mediatracker.isErrorAny())
				throw new IOException("image loading error !");
			mediatracker = null;
		}
		nWidth = iImage.getWidth(null);
		nHeight = iImage.getHeight(null);
		if (nWidth < 0 || nHeight < 0) {
			throw new IOException("unknown image geometry !");
		}
		else {
			nBlockSize = i;
			return;
		}
	}

	public V2CSingleImage(ImageReader imagereader, int i, int j) throws IOException
	{
		this(imagereader.read(i), j);
	}

	public V2CSingleImage(BufferedImage bufferedimage, int i) throws IOException
	{
		nDelayTime = 500;
		iImage = bufferedimage;
		nWidth = bufferedimage.getWidth();
		nHeight = bufferedimage.getHeight();
		if (nWidth < 0 || nHeight < 0) {
			throw new IOException("(nWidth<0)||(nHeight<0)");
		}
		else {
			nBlockSize = i;
			return;
		}
	}

	void clear()
	{
		Image image = iImage;
		if (image != null) {
			iImage = null;
			image.flush();
		}
	}

	void setBlockSize(int i)
	{
		if (i != nBlockSize) {
			nBlockSize = i;
			iScaledImage = null;
		}
	}

	void createScaledImage()
	{
		if (nBlockSize < 4 || iScaledImage != null)
			return;
		if (nWidth <= 1 && nHeight <= 1) {
			iScaledImage = iImage;
			return;
		}
		int i = Math.max(nWidth / nBlockSize, 1);
		int j = Math.max(nHeight / nBlockSize, 1);
		Image image = iImage;
		if (image instanceof BufferedImage) {
			BufferedImage bufferedimage = (BufferedImage) image;
			ColorModel colormodel = bufferedimage.getColorModel();
			int k = bufferedimage.getType();
			BufferedImage bufferedimage1 = new BufferedImage(colormodel, colormodel.createCompatibleWritableRaster(i, j),
					colormodel.isAlphaPremultiplied(), null);
			iScaledImage = bufferedimage1;
		}
		else {
			iScaledImage = V2CMain.v2cMain.createImage(i, j);
		}
		Graphics g = iScaledImage.getGraphics();
		g.drawImage(image, 0, 0, i, j, null);
		g.dispose();
		g = null;
	}

	void computeUnion(Rectangle rectangle)
	{
		if (rectangle.width <= 0 || rectangle.height <= 0)
			rectangle.setBounds(nX, nY, nWidth, nHeight);
		else
			SwingUtilities.computeUnion(nX, nY, nWidth, nHeight, rectangle);
	}

	int getWidth()
	{
		return nWidth;
	}

	int getHeight()
	{
		return nHeight;
	}

	boolean needsBuffer(int i, int j)
	{
		return iDisposalMethod == 1 || isBGVisible(i, j);
	}

	Image getImage()
	{
		return iImage;
	}

	void setImage(Image image)
	{
		iImage = image;
	}

	int getDelayTime()
	{
		return nDelayTime;
	}

	int getDisposalMethod()
	{
		return iDisposalMethod;
	}

	void setDisposalMethod(int i)
	{
		iDisposalMethod = i;
	}

	boolean shouldClear()
	{
		return iDisposalMethod == 2;
	}

	boolean isBGVisible(int i, int j)
	{
		return bTransparent || nX > 0 || nY > 0 || nWidth < i || nHeight < j;
	}

	boolean restoreToPrev()
	{
		return iDisposalMethod == 3;
	}

	void clearRect(Graphics2D graphics2d, int i, int j, double d, Color color)
	{
		graphics2d.setColor(color);
		int k;
		int l;
		if (d > 0.0D && d != 1.0D) {
			i += (int) (d * (double) nX);
			j += (int) (d * (double) nY);
			k = (int) (d * (double) nWidth);
			l = (int) (d * (double) nHeight);
		}
		else {
			i += nX;
			j += nY;
			k = nWidth;
			l = nHeight;
		}
		graphics2d.fillRect(i, j, k, l);
	}

	void setScaledImageCreated(String s)
	{
		bThumbnailImageCreated = s != null && s.equalsIgnoreCase("PNG");
	}

	void draw(Graphics2D graphics2d, int i, int j, double d)
	{
		if (bThumbnailImageCreated) {
			bThumbnailImageCreated = false;
			if (nWidth * nHeight > 0x7a120) {
				BufferedImage bufferedimage = new BufferedImage(nWidth, nHeight, 2);
				Graphics2D graphics2d1 = (Graphics2D) bufferedimage.getGraphics();
				graphics2d1.drawImage(iImage, 0, 0, nWidth, nHeight, null);
				graphics2d1.dispose();
				iImage = bufferedimage;
			}
		}
		if (d > 0.0D && d != 1.0D) {
			i += (int) (d * (double) nX);
			j += (int) (d * (double) nY);
			int k = (int) (d * (double) nWidth);
			int l = (int) (d * (double) nHeight);
			if (nBlockSize >= 4) {
				createScaledImage();
				graphics2d.drawImage(iScaledImage, i, j, k, l, null);
			}
			else {
				graphics2d.drawImage(iImage, i, j, k, l, null);
			}
		}
		else {
			i += nX;
			j += nY;
			if (nBlockSize >= 4) {
				createScaledImage();
				graphics2d.drawImage(iScaledImage, i, j, nWidth, nHeight, null);
			}
			else {
				graphics2d.drawImage(iImage, i, j, null);
			}
		}
	}

	void extractInfo(ImageReader imagereader, int i)
	{
		IIOMetadata iiometadata = null;
		try {
			iiometadata = imagereader.getImageMetadata(i);
		}
		catch (IOException ioexception) {
			System.out.println(ioexception.getMessage());
		}
		if (iiometadata == null)
			return;
		String s = iiometadata.getNativeMetadataFormatName();
		if (s == null || s.length() == 0)
			return;
		Node node = iiometadata.getAsTree(s);
		if (s.indexOf("_gif_") > 0)
			extractGIFInfo(node);
	}

	void extractGIFInfo(Node node)
	{
		NodeList nodelist = node.getChildNodes();
		if (nodelist == null)
			return;
		int i = nodelist.getLength();
		for (int j = 0; j < i; j++) {
			Node node1 = nodelist.item(j);
			String s = node1.getNodeName();
			if (s == null)
				continue;
			NamedNodeMap namednodemap = node1.getAttributes();
			if (s.equals("ImageDescriptor")) {
				Node node2 = namednodemap.getNamedItem("imageLeftPosition");
				if (node2 != null)
					try {
						nX = Integer.parseInt(node2.getNodeValue());
					}
					catch (NumberFormatException numberformatexception) {
					}
				node2 = namednodemap.getNamedItem("imageTopPosition");
				if (node2 != null)
					try {
						nY = Integer.parseInt(node2.getNodeValue());
					}
					catch (NumberFormatException numberformatexception1) {
					}
				node2 = namednodemap.getNamedItem("interlaceFlag");
				if (node2 == null)
					continue;
				String s1 = node2.getNodeValue();
				if (s1 != null && s1.equalsIgnoreCase("TRUE"))
					bInterlace = true;
				node2 = null;
				continue;
			}
			if (!s.equals("GraphicControlExtension"))
				continue;
			Node node3 = namednodemap.getNamedItem("disposalMethod");
			if (node3 != null) {
				String s2 = node3.getNodeValue();
				if (s2 != null)
					if (s2.equals("none"))
						iDisposalMethod = 0;
					else if (s2.equals("doNotDispose"))
						iDisposalMethod = 1;
					else if (s2.equals("restoreToBackgroundColor"))
						iDisposalMethod = 2;
					else if (s2.equals("restoreToPrevious"))
						iDisposalMethod = 3;
			}
			node3 = namednodemap.getNamedItem("transparentColorFlag");
			if (node3 != null) {
				String s3 = node3.getNodeValue();
				if (s3 != null && s3.equalsIgnoreCase("TRUE"))
					bTransparent = true;
			}
			node3 = namednodemap.getNamedItem("delayTime");
			if (node3 == null)
				continue;
			int k = 0;
			try {
				k = Integer.parseInt(node3.getNodeValue()) * 10;
			}
			catch (NumberFormatException numberformatexception2) {
			}
			if (k == 0)
				nDelayTime = 100;
			else
				nDelayTime = Math.max(k, 30);
			node1 = null;
			node3 = null;
			namednodemap = null;
		}
		nodelist = null;
	}

	public static void convertYcckToCmyk(WritableRaster raster)
	{
		int height = raster.getHeight();
		int width = raster.getWidth();
		int stride = width * 4;
		int[] pixelRow = new int[stride];
		for (int h = 0; h < height; h++) {
			raster.getPixels(0, h, width, 1, pixelRow);
			for (int x = 0; x < stride; x += 4) {
				int y = pixelRow[x];
				int cb = pixelRow[x + 1];
				int cr = pixelRow[x + 2];
                int c = (int) (y + 1.402 * cr - 178.956);
                int m = (int) (y - 0.34414 * cb - 0.71414 * cr + 135.95984);
                y = (int) (y + 1.772 * cb - 226.316);
                if (c < 0) c = 0; else if (c > 255) c = 255;
                if (m < 0) m = 0; else if (m > 255) m = 255;
                if (y < 0) y = 0; else if (y > 255) y = 255;
                pixelRow[x] = 255 - c;
                pixelRow[x + 1] = 255 - m;
                pixelRow[x + 2] = 255 - y;
			}
			raster.setPixels(0, h, width, 1, pixelRow);
		}
		pixelRow = null;
	}

	public static void convertInvertedColors(WritableRaster raster)
	{
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = width * 4;
        int[] pixelRow = new int[stride];
        for (int h = 0; h < height; h++) {
            raster.getPixels(0, h, width, 1, pixelRow);
            for (int x = 0; x < stride; x++)
                pixelRow[x] = 255 - pixelRow[x];
            raster.setPixels(0, h, width, 1, pixelRow);
        }
        pixelRow = null;
	}

    public static BufferedImage convertCmykToRgb(Raster cmykRaster, ICC_Profile cmykProfile) throws IOException
    {
        if (cmykProfile == null) {
            cmykProfile = ICC_Profile.getInstance(V2CSingleImage.class.getClassLoader().getResourceAsStream("org/monazilla/v2c/Generic CMYK Profile.icc"));
        }

        if (cmykProfile.getProfileClass() != ICC_Profile.CLASS_DISPLAY) {
            byte[] profileData = cmykProfile.getData();

            if (profileData[ICC_Profile.icHdrRenderingIntent] == ICC_Profile.icPerceptual) {
                intToBigEndian(ICC_Profile.icSigDisplayClass, profileData, ICC_Profile.icHdrDeviceClass); // Header is first

                cmykProfile = ICC_Profile.getInstance(profileData);
            }
            profileData = null;
        }

        ICC_ColorSpace cmykCS = new ICC_ColorSpace(cmykProfile);
        BufferedImage rgbImage = new BufferedImage(cmykRaster.getWidth(), cmykRaster.getHeight(), BufferedImage.TYPE_INT_RGB);
        WritableRaster rgbRaster = rgbImage.getRaster();
        ColorSpace rgbCS = rgbImage.getColorModel().getColorSpace();
        ColorConvertOp cmykToRgb = new ColorConvertOp(cmykCS, rgbCS, null);
        cmykToRgb.filter(cmykRaster, rgbRaster);
        cmykCS = null;
        rgbRaster = null;
        rgbCS = null;
        cmykToRgb = null;
        return rgbImage;
    }

    static void intToBigEndian(int value, byte[] array, int index)
    {
        array[index]   = (byte) (value >> 24);
        array[index+1] = (byte) (value >> 16);
        array[index+2] = (byte) (value >>  8);
        array[index+3] = (byte) (value);
    }

    static ICC_Profile iccProfileCMYK = null;
	private static final boolean bPrintNodeInfo = false;
	static final int NONE = 0;
	static final int DO_NOT_DISPOSE = 1;
	static final int RESTORE_TO_BG = 2;
	static final int RESTORE_TO_PREV = 3;
	private static final int nMinDelayTime = 30;
	Image iImage;
	Image iScaledImage;
	int nX;
	int nY;
	int nWidth;
	int nHeight;
	boolean bInterlace;
	boolean bTransparent;
	int iDisposalMethod;
	int nDelayTime;
	boolean bThumbnailImageCreated;
	private static float flcr[] = { -0.05930647F, -0.2515778F, -0.2355781F, -1.10902F, 0.3569998F, -0.1684346F, -0.3115422F,
			-0.2028333F, 0.5522593F, -0.1587408F, -1.577459F, 0.5184523F, -0.04045399F, 1.983578F, -0.4294166F };
	private static float flcg[] = { -0.08279894F, -0.3008856F, -0.2810283F, -1.130134F, 0.439294F, -0.2631223F, -0.3974407F,
			0.1177769F, 0.718766F, -0.1713256F, 0.5373592F, 0.5986116F, -0.04320273F, 0.7796825F, -0.5170328F };
	private static float flcb[] = { 0.005186297F, 0.05627564F, -0.00546149F, -1.01511F, -0.01877278F, 0.1251009F, 0.1477184F,
			-1.760302F, -0.2235212F, 0.0558004F, 0.01157604F, -0.1184474F, -0.0007781947F, 1.884478F, 0.07955397F };
	int nBlockSize;

}
