package org.monazilla.v2c;

import java.awt.AWTPermission;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilePermission;
import java.lang.reflect.Method;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.PropertyPermission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class V2CScriptUtil
{
	private static class AllPermissionPolicy extends Policy
	{

		public PermissionCollection getPermissions(CodeSource codesource)
		{
			return vPermissions;
		}

		public PermissionCollection getPermissions(ProtectionDomain protectiondomain)
		{
			return vPermissions;
		}

		public void refresh()
		{
		}

		final Permissions vPermissions;

		AllPermissionPolicy()
		{
			Permissions permissions = new Permissions();
			permissions.add(new AllPermission());
			vPermissions = permissions;
		}
	}

	public V2CScriptUtil()
	{
	}

	static void printMessage(String s)
	{
		V2CScriptConsole.appendText(s + '\n');
		V2CMain.setMessage(V2CMiscUtil.replaceChar(s, '\n', ' '));
	}

	private static void checkSOMJ(Permissions permissions)
	{
		if (!bSOMJChecked) {
			try {
//				Class.forName("sun.org.mozilla.javascript.DefiningClassLoader");
				bSOMJ = true;
			}
//			catch (ClassNotFoundException classnotfoundexception) {
//			}
			catch (Exception exception) {
				exception.printStackTrace();
			}
			bSOMJChecked = true;
		}
		if (bSOMJ) {
			permissions.add(new RuntimePermission("createClassLoader"));
			permissions.add(new RuntimePermission("accessClassInPackage.sun.org.mozilla.*"));
			permissions.add(new RuntimePermission("loadLibrary.keychain"));
		}
	}

	private static synchronized boolean checkSecurityManager()
	{
		if (bSecurityManagerInstallFailed)
			return false;
		if (bSecurityManagerInstalled)
			return true;
		boolean flag = false;
		bSecurityManagerInstallFailed = true;
		try {
			Policy.setPolicy(new AllPermissionPolicy());
			Method method = (java.lang.System.class).getMethod("setSecurityManager",
					new Class[] { java.lang.SecurityManager.class });
			method.invoke(null, new Object[] { new SecurityManager() });
			flag = true;
			bSecurityManagerInstallFailed = false;
		}
		catch (Exception exception) {
			exception.printStackTrace();
		}
		bSecurityManagerInstalled = flag;
		if (!flag)
			V2CSwingUtil
					.showErrorMessage("SecurityManagerのインストールに失敗しました。\nスクリプトを実行することはできません。");
		return flag;
	}

	private static void addAccessEventQueuePermission(Permissions permissions)
	{
		if (V2CApp.javaVersionEqualOrGreaterThan(1, 7))
			permissions.add(new AWTPermission("accessEventQueue"));
		if (V2CApp.javaVersionEqualOrGreaterThan(1, 8)){
			permissions.add(new RuntimePermission("accessClassInPackage.jdk.nashorn.internal.objects"));
			permissions.add(new RuntimePermission("nashorn.JavaReflection"));
			permissions.add(new RuntimePermission("setContextClassLoader"));
		}
		if (V2CApp.javaVersionEqualOrGreaterThan(9, 0)){
			permissions.add(new RuntimePermission("accessClassInPackage.com.sun.java.swing.plaf.windows"));
			permissions.add(new RuntimePermission("accessClassInPackage.com.apple.laf"));
		}
	}

	private static void addDefaultPropertyPermissions(Permissions permissions)
	{
		String as[] = { "java.version", "java.vendor", "java.vendor.url", "java.class.version", "os.name", "os.version",
				"os.arch", "file.encoding", "file.separator", "path.separator", "line.separator", "java.specification.version",
				"java.specification.vendor", "java.specification.name", "java.vm.specification.version",
				"java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name" };
		for (int i = 0; i < as.length; i++)
			permissions.add(new PropertyPermission(as[i], "read"));

	}

	private static void addPermission(Permissions permissions, Permission permission, SecurityManager securitymanager)
	{
		if (securitymanager != null)
			try {
				securitymanager.checkPermission(permission);
			}
			catch (SecurityException securityexception) {
				return;
			}
		permissions.add(permission);
	}

	static AccessControlContext createAccessControlContext(String s)
	{
		return createAccessControlContext(s, null);
	}

	static AccessControlContext createAccessControlContext(String s, SecurityManager securitymanager)
	{
		int i;
		if (s == null || (i = s.length()) == 0) {
			AccessControlContext accesscontrolcontext = vDefaultAccessControlContext;
			if (accesscontrolcontext != null) {
				return accesscontrolcontext;
			}
			else {
				Permissions permissions1 = new Permissions();
				checkSOMJ(permissions1);
				addAccessEventQueuePermission(permissions1);
				addDefaultPropertyPermissions(permissions1);
				AccessControlContext accesscontrolcontext1 = new AccessControlContext(
						new ProtectionDomain[] { new ProtectionDomain(null, permissions1) });
				vDefaultAccessControlContext = accesscontrolcontext1;
				return accesscontrolcontext1;
			}
		}
		if (i == 1 && s.charAt(0) == 'A') {
			AccessControlContext accesscontrolcontext2 = vAllAccessControlContext;
			if (accesscontrolcontext2 != null && securitymanager == null)
				return accesscontrolcontext2;
			Permissions permissions2 = new Permissions();
			checkSOMJ(permissions2);
			addAccessEventQueuePermission(permissions2);
			addPermission(permissions2, new PropertyPermission("*", "read"), securitymanager);
			addPermission(permissions2, new FilePermission("<<ALL FILES>>", "read,write,execute,delete"), securitymanager);
			addPermission(permissions2, new V2CRuntimePermission("changeFavorite"), securitymanager);
			addPermission(permissions2, new V2CRuntimePermission("changeProperty"), securitymanager);
			addPermission(permissions2, new RuntimePermission("exitVM"), securitymanager);
			addPermission(permissions2, new SocketPermission("*", "connect"), securitymanager);
			addPermission(permissions2, new AWTPermission("accessClipboard"), securitymanager);
			addPermission(permissions2, new AWTPermission("showWindowWithoutWarningBanner"), securitymanager);
			addPermission(permissions2, new AWTPermission("setWindowAlwaysOnTop"), securitymanager);
			String sv = System.getProperty("java.version");
			if(V2CApp.javaVersionEqualOrGreaterThan(1, 8)){
				addPermission(permissions2, new RuntimePermission("accessDeclaredMembers"), securitymanager);
				addPermission(permissions2, new RuntimePermission("getClassLoader"), securitymanager);
			}
			accesscontrolcontext2 = new AccessControlContext(new ProtectionDomain[] { new ProtectionDomain(null, permissions2) });
			if (securitymanager == null)
				vAllAccessControlContext = accesscontrolcontext2;
			return accesscontrolcontext2;
		}
		Permissions permissions = new Permissions();
		checkSOMJ(permissions);
		addAccessEventQueuePermission(permissions);
		boolean flag = false;
		boolean flag1 = false;
		for (int j = 0; j < i; j++) {
			char c = s.charAt(j);
			if (c == 'A')
				return null;
			if (c > 'A' && c <= 'Z') {
				if (c == 'F') {
					StringBuffer stringbuffer = new StringBuffer();
					int j1;
					for (j1 = j + 1; j1 < i; j1++) {
						char c4 = s.charAt(j1);
						if (c4 >= 'A' && c4 <= 'Z')
							break;
						if (c4 == 'r') {
							stringbuffer.append("read,");
							continue;
						}
						if (c4 == 'w') {
							stringbuffer.append("write,");
							continue;
						}
						if (c4 == 'x') {
							stringbuffer.append("execute,");
							continue;
						}
						if (c4 == 'd')
							stringbuffer.append("delete,");
						else
							return null;
					}

					j = j1 - 1;
					j1 = stringbuffer.length();
					String s1;
					if (j1 > 0)
						s1 = stringbuffer.substring(0, j1 - 1);
					else
						s1 = "read,write,execute,delete";
					addPermission(permissions, new FilePermission("<<ALL FILES>>", s1), securitymanager);
					continue;
				}
				if (c == 'P') {
					addPermission(permissions, new PropertyPermission("*", "read"), securitymanager);
					flag = true;
					continue;
				}
				if (c == 'R') {
					int k = j + 1;
					do {
						if (k >= i)
							break;
						char c1 = s.charAt(k);
						if (c1 >= 'A' && c1 <= 'Z')
							break;
						if (c1 == 'x')
							addPermission(permissions, new RuntimePermission("exitVM"), securitymanager);
						else
						if (c1 == 'm'){
							String sv = System.getProperty("java.version");
							if(V2CApp.javaVersionEqualOrGreaterThan(1, 8)){
								addPermission(permissions, new RuntimePermission("accessDeclaredMembers"), securitymanager);
							}
						}
						else
						if (c1 == 'c'){
							String sv = System.getProperty("java.version");
							if(V2CApp.javaVersionEqualOrGreaterThan(1, 8)){
								addPermission(permissions, new RuntimePermission("getClassLoader"), securitymanager);
							}
						}
						else
							return null;
						k++;
					} while (true);
					if (j == k - 1){
						addPermission(permissions, new RuntimePermission("exitVM"), securitymanager);
						String sv = System.getProperty("java.version");
						if(V2CApp.javaVersionEqualOrGreaterThan(1, 8)){
							addPermission(permissions, new RuntimePermission("accessDeclaredMembers"), securitymanager);
							addPermission(permissions, new RuntimePermission("getClassLoader"), securitymanager);
						}
					}
					else
						j = k - 1;
					continue;
				}
				if (c == 'S') {
					addPermission(permissions, new SocketPermission("*", "connect"), securitymanager);
					continue;
				}
				if (c == 'T') {
					int l;
					for (l = j + 1; l < i; l++) {
						char c2 = s.charAt(l);
						if (c2 >= 'A' && c2 <= 'Z')
							break;
						if (c2 == 'c') {
							addPermission(permissions, new AWTPermission("accessClipboard"), securitymanager);
							if (V2CApp.javaVersionEqualOrGreaterThan(9, 0)){
								addPermission(permissions, new AllPermission("<all permissions>", "<all actions>"), securitymanager);
							}
							continue;
						}
						if (c2 == 't') {
							addPermission(permissions, new AWTPermission("setWindowAlwaysOnTop"), securitymanager);
							continue;
						}
						if (c2 == 'r') {
							addPermission(permissions, new AWTPermission("createRobot"), securitymanager);
							continue;
						}
						if (c2 == 'd') {
							addPermission(permissions, new AWTPermission("readDisplayPixels"), securitymanager);
							continue;
						}
						if (c2 == 'w')
							addPermission(permissions, new AWTPermission("showWindowWithoutWarningBanner"), securitymanager);
						else
							return null;
					}

					if (j == l - 1) {
						addPermission(permissions, new AWTPermission("accessClipboard"), securitymanager);
						addPermission(permissions, new AWTPermission("showWindowWithoutWarningBanner"), securitymanager);
						addPermission(permissions, new AWTPermission("setWindowAlwaysOnTop"), securitymanager);
					}
					else {
						j = l - 1;
					}
					continue;
				}
				if (c == 'V') {
					int i1;
					for (i1 = j + 1; i1 < i; i1++) {
						char c3 = s.charAt(i1);
						if (c3 >= 'A' && c3 <= 'Z')
							break;
						if (c3 == 'f') {
							addPermission(permissions, new V2CRuntimePermission("changeFavorite"), securitymanager);
							continue;
						}
						if (c3 == 'p')
							addPermission(permissions, new V2CRuntimePermission("changeProperty"), securitymanager);
						else
							return null;
					}

					if (j == i1 - 1) {
						addPermission(permissions, new V2CRuntimePermission("changeFavorite"), securitymanager);
						addPermission(permissions, new V2CRuntimePermission("changeProperty"), securitymanager);
					}
					else {
						j = i1 - 1;
					}
				}
				else {
					return null;
				}
			}
			else {
				return null;
			}
		}

		if (!flag)
			addDefaultPropertyPermissions(permissions);
		return new AccessControlContext(new ProtectionDomain[] { new ProtectionDomain(null, permissions) });
	}

	private static V2CEvalScript createEvalScript(V2CExtCommand v2cextcommand, String s, ActionEvent actionevent, boolean flag,
			boolean flag1, boolean flag2)
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5)) {
			V2CSwingUtil
					.showErrorMessage("スクリプトの実行にはJRE5以上が必要です。");
			return null;
		}
		if (!checkSecurityManager())
			return null;
		String s1 = v2cextcommand.getCommand();
		String sCmd = "\n\n" + v2cextcommand.getCommand();
		Matcher matcher = Pattern.compile("\\$(?:SCRIPT|\\{SCRIPT(?:\\[([-/\\w]+)\\])?(?::(\\p{Alpha}*))?\\})\\s+").matcher(s1);
		if (!matcher.lookingAt()) {
			V2CSwingUtil
					.showErrorMessage("スクリプトの指定が正しくありません。" + sCmd);
			return null;
		}
		String s2 = null;
		if (matcher.groupCount() >= 1)
			s2 = matcher.group(1);
		if (s2 == null)
			s2 = "JavaScript";
		s1 = s1.substring(matcher.end());
		String s3 = s2;
		Matcher matcher1 = Pattern.compile("(<?[-\\w.\\\\/]+>?)\\s*").matcher(s1);
		if (!matcher1.lookingAt()) {
			V2CSwingUtil
					.showErrorMessage("スクリプトファイル名を取得できませんでした。" + sCmd);
			return null;
		}
		String s4 = matcher1.group(1);
		int i = s4.length();
		File file;
		String s5;
		if (i > 2 && s4.charAt(0) == '<' && s4.charAt(i - 1) == '>') {
			file = null;
			s5 = V2CLocalFileHandler.restoreTextResource("org/monazilla/v2c/script/" + s4.substring(1, i - 1));
		}
		else {
			file = V2CLocalFileHandler.getScriptFile(s4);
			if (file == null) {
				V2CSwingUtil
						.showErrorMessage("スクリプトファイル名を取得できませんでした。" + sCmd);
				return null;
			}
			if (!file.isFile()) {
				V2CSwingUtil
						.showErrorMessage("スクリプトファイルが存在しません。" + sCmd);
				return null;
			}
			s5 = V2CLocalFileHandler.restoreFromFile(file, "UTF-8");
		}
		if (s5 == null || s5.length() <= 1) {
			V2CSwingUtil
					.showErrorMessage("スクリプトファイルの内容が空です。" + sCmd);
			return null;
		}
		if (s5.charAt(0) == '﻿') {
			if (s5.length() == 1) {
				V2CSwingUtil
						.showErrorMessage("スクリプトファイルの内容が空です。" + sCmd);
				return null;
			}
			s5 = s5.substring(1);
		}
		if (s != null)
			s5 = s5 + s;
		V2CScriptClassLoader v2cscriptclassloader = V2CScriptClassLoader.getInstance();
		if (v2cscriptclassloader == null) {
			V2CSwingUtil
					.showErrorMessage("クラスローダを作成できませんでした。" + sCmd);
			return null;
		}
		AccessControlContext accesscontrolcontext = createAccessControlContext(matcher.group(2));
		if (accesscontrolcontext == null) {
			V2CSwingUtil
					.showErrorMessage("パーミッションの指定が正しくありません。" + sCmd + "\n\n"
							+ matcher.group(2));
			return null;
		}
		else {
			V2CScriptApp v2cscriptapp = new V2CScriptApp(file, s1.substring(matcher1.end()), v2cextcommand, actionevent, flag,
					flag1, flag2);
			return new V2CEvalScript(s3, s5, v2cscriptapp, v2cscriptclassloader, accesscontrolcontext);
		}
	}

	static void execScript(V2CExtCommand v2cextcommand, ActionEvent actionevent, boolean flag, boolean flag1, boolean flag2)
	{
		V2CEvalScript v2cevalscript = createEvalScript(v2cextcommand, null, actionevent, flag, flag1, flag2);
		if (v2cevalscript == null) {
			return;
		}
		else {
			Thread thread = new Thread(v2cevalscript);
			thread.start();
			return;
		}
	}

	static Object evalScriptFunction(V2CExtCommand v2cextcommand, ActionEvent actionevent, String s, Object aobj[])
	{
		V2CEvalScript v2cevalscript = createEvalScript(v2cextcommand, null, actionevent, false, false, false);
		if (v2cevalscript == null) {
			return null;
		}
		else {
			v2cevalscript.setInvokeFunction(s, aobj);
			v2cevalscript.run();
			return v2cevalscript.getResult();
		}
	}

	static void redirectURL(V2CEvalScript v2cevalscript, URL url)
	{
		v2cevalscript.redirectURL(url);
		Thread thread = new Thread(v2cevalscript);
		thread.start();
	}

	static void formSubmitted(V2CEvalScript v2cevalscript, URL url, String s, String s1)
	{
		v2cevalscript.formSubmitted(url, s, s1);
		Thread thread = new Thread(v2cevalscript);
		thread.start();
	}

	static boolean startResCheckScript()
	{
		if (V2CResCheckScript.bPrintDebugInfo)
			System.out.println("V2CScriptUtil.startResCheckScript");
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return false;
		if (!checkSecurityManager())
			return false;
		if (V2CResCheckScript.bPrintDebugInfo)
			System.out.println("SecurityManager OK");
		File file = V2CLocalFileHandler.getSystemScriptFile("rescheck.js");
		if (!file.isFile())
			return false;
		if (V2CResCheckScript.bPrintDebugInfo)
			System.out.println("ResCheckScriptFile OK");
		String s = V2CLocalFileHandler.restoreFromFile(file, "UTF-8");
		if (s == null || s.length() <= 1)
			return false;
		if (V2CResCheckScript.bPrintDebugInfo)
			System.out.println("Read OK");
		if (s.charAt(0) == '﻿') {
			if (s.length() == 1)
				return false;
			s = s.substring(1);
		}
		if (V2CResCheckScript.bPrintDebugInfo)
			System.out.println("Read2 OK");
		V2CScriptClassLoader v2cscriptclassloader = V2CScriptClassLoader.getInstance();
		if (v2cscriptclassloader == null)
			return false;
		if (V2CResCheckScript.bPrintDebugInfo)
			System.out.println("ClassLoader OK");
		AccessControlContext accesscontrolcontext = createAccessControlContext(V2CSystemScript.getPermissionString("rescheck.js"));
		if (accesscontrolcontext == null)
			return false;
		if (V2CResCheckScript.bPrintDebugInfo)
			System.out.println("AccessControlContext OK");
		return V2CResCheckScript.startScript(s, v2cscriptclassloader, accesscontrolcontext);
	}

	static V2CSystemScript createSystemScript(String s)
	{
		if (!V2CApp.javaVersionEqualOrGreaterThan(1, 5))
			return null;
		if (!checkSecurityManager())
			return null;
		File file = V2CLocalFileHandler.getSystemScriptFile(s);
		if (!file.isFile())
			return null;
		String s1 = V2CLocalFileHandler.restoreFromFile(file, "UTF-8");
		if (s1 == null || s1.length() <= 1)
			return null;
		if (s1.charAt(0) == '﻿') {
			if (s1.length() == 1)
				return null;
			s1 = s1.substring(1);
		}
		V2CScriptClassLoader v2cscriptclassloader = V2CScriptClassLoader.getInstance();
		if (v2cscriptclassloader == null)
			return null;
		AccessControlContext accesscontrolcontext = createAccessControlContext(V2CSystemScript.getPermissionString(s));
		if (accesscontrolcontext == null)
			return null;
		if (s.equals("subject.js"))
			return V2CSubjectScript.createSubjectScript(s1, v2cscriptclassloader, accesscontrolcontext);
		if (s.equals("imgcache.js"))
			return V2CImageCacheScript.createImageCacheScript(s1, v2cscriptclassloader, accesscontrolcontext);
		if (s.equals("menu.js"))
			return V2CMenuScript.createMenuScript(s1, v2cscriptclassloader, accesscontrolcontext);
		if (s.equals("getdat.js"))
			return V2CGetDatScript.createGetDatScript(s1, v2cscriptclassloader, accesscontrolcontext);
		if (s.equals("threadld.js"))
			return V2CThreadUpdateScript.createThreadUpdateScript(s1, v2cscriptclassloader, accesscontrolcontext);
		if (s.equals("post.js"))
			return V2CPostScript.createPostScript(s1, v2cscriptclassloader, accesscontrolcontext);
		if (s.equals("proxy.js"))
			return V2CProxyScript.createProxyScript(s1, v2cscriptclassloader, accesscontrolcontext);
		else
			return null;
	}

	static V2CScriptSP createScriptSP()
	{
		return new V2CScriptSP(new String[] { "subject.js", "rescheck.js", "imgcache.js", "menu.js", "getdat.js", "threadld.js",
				"post.js", "proxy.js" });
	}

	static boolean getThreadsForTLBS(V2CExtCommand v2cextcommand, ArrayList arraylist, V2CScriptTLBSContext v2cscripttlbscontext)
	{
		String s = V2CLocalFileHandler.restoreTextResource("org/monazilla/v2c/script/tlbsft.js");
		if (s == null)
			return false;
		V2CEvalScript v2cevalscript = createEvalScript(v2cextcommand, s, null, false, false, false);
		if (v2cevalscript == null)
			return false;
		v2cevalscript.run();
		PrivilegedExceptionAction privilegedexceptionaction = v2cevalscript.vPrivilegedExceptionAction;
		if (privilegedexceptionaction == null)
			return false;
		V2CJSE6Util.setInvokeFunction(privilegedexceptionaction, "_v2c_getThreads", new Object[] { v2cscripttlbscontext });
		Object obj = execPEA(privilegedexceptionaction, v2cevalscript.vScriptApp, v2cevalscript.vScriptClassLoader,
				v2cevalscript.vAccessControlContext);
		if (v2cscripttlbscontext.getSkip())
			return true;
		if (!(obj instanceof java.util.List))
			return false;
		java.util.List list = (java.util.List) obj;
		int i = list.size();
		for (int j = 0; j < i; j++) {
			Object obj1 = list.get(j);
			if (!(obj1 instanceof V2CScriptThread))
				return false;
			arraylist.add(((V2CScriptThread) obj1).getThreadItem());
		}

		return true;
	}

	static Object execPEA(PrivilegedExceptionAction privilegedexceptionaction, V2CScriptApp v2cscriptapp,
			V2CScriptClassLoader v2cscriptclassloader, AccessControlContext accesscontrolcontext)
	{
		String s = null;
		Thread thread = Thread.currentThread();
		ClassLoader classloader = thread.getContextClassLoader();
		thread.setContextClassLoader(v2cscriptclassloader);
		Object obj = null;
		try {
			obj = AccessController.doPrivileged(privilegedexceptionaction, accesscontrolcontext);
		}
		catch (PrivilegedActionException privilegedactionexception) {
			s = "スクリプト実行エラー： "
					+ privilegedactionexception.getException().getMessage();
		}
		finally {
			thread.setContextClassLoader(classloader);
			V2CMain.endTempMessage(v2cscriptapp);
		}
		if (s != null)
			setErrorMessage(s);
		return obj;
	}

	static void setErrorMessage(String s)
	{
		if (s == null) {
			return;
		}
		else {
			V2CScriptConsole.appendText(s + '\n');
			V2CMain.setErrorMessage(s);
			System.out.println(s);
			return;
		}
	}

	private static final String sJavaScript = "JavaScript";
	private static AccessControlContext vDefaultAccessControlContext;
	private static AccessControlContext vAllAccessControlContext;
	private static boolean bSecurityManagerInstalled;
	private static boolean bSecurityManagerInstallFailed;
	private static boolean bSOMJ;
	private static boolean bSOMJChecked;
}
