package org.monazilla.v2c;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class V2CScriptHttpRequest
{

	private static final Pattern privatepatternSecretCookie = Pattern
			.compile("https?://([^/]+)/.+");

	V2CScriptHttpRequest(URL url, String s)
	{
		sPostData = s;
		if (url == null)
			throw new IllegalArgumentException("empty URL");
		String s1 = url.getProtocol();
		if (s1 == null || !s1.equalsIgnoreCase("http") && !s1.equalsIgnoreCase("https")) {
			throw new IllegalArgumentException("HTTP(S)以外のプロトコル： " + s1);
		}
		else {
			vURL = url;
			HashMap hashmap = new HashMap();
			hmRequestProperty = hashmap;
			hashmap.put("Host", url.getHost());
			hashmap.put("Accept", "*/*");
			return;
		}
	}

	public void setRequestProperty(String s, String s1)
	{
		HashMap hashmap = hmRequestProperty;
		if (hashmap == null) {
			hashmap = new HashMap();
			hmRequestProperty = hashmap;
		}
		hashmap.put(s, s1);
	}

	public boolean getHead()
	{
		if (sPostData != null)
			return false;
		Character character = new Character('M');
		HashMap hashmap = hmRequestProperty;
		byte abyte0[] = null;
		bCompleted = false;
		blData = null;
		vHttpURLConnection = null;
		try {
			hashmap.put(character, "HEAD");
			abyte0 = getContentsAsBytes();
		}
		finally {
			hashmap.remove(character);
			bCompleted = false;
		}
		return abyte0 != null;
	}

	public byte[] getContentsAsBytes()
	{
		return getContentsAsBytes(true);
	}

	byte[] getContentsAsBytes(boolean flag)
	{
		if (bCompleted)
			return blData;
		bCompleted = true;
		URL url = vURL;
		if (flag) {
			SecurityManager securitymanager = System.getSecurityManager();
			if (securitymanager != null) {
				int i = url.getPort();
				if (i < 0)
					i = url.getDefaultPort();
				securitymanager.checkConnect(url.getHost(), i);
			}
		}
		return (byte[]) (byte[]) AccessController.doPrivileged(new PrivilegedAction() {

			public Object run()
			{
				V2CHttpUtil.CAndC candc;
				if (sPostData != null)
					candc = V2CHttpUtil.postForm(vURL.toString(), sPostData, hmRequestProperty);
				else
					candc = V2CHttpUtil.getRawHTTPFile(vURL.toString(), 10, hmRequestProperty);
				if (candc == null)
					return null;
				HttpURLConnection httpurlconnection = candc.getConnection();
				if (httpurlconnection == null) {
					return null;
				}
				else {
					vHttpURLConnection = httpurlconnection;
					byte abyte0[] = candc.getRawContents();
					blData = abyte0;
					return abyte0;
				}
			}
		});
	}

	public String getContentsAsString()
	{
		return getContentsAsString(null, true);
	}

	String getContentsAsString(String s, boolean flag)
	{
		return V2CMiscUtil.byteArrayToString(getContentsAsBytes(flag), s, getContentType());
	}

	public String getResponseHeader(String s)
	{
		HttpURLConnection httpurlconnection = vHttpURLConnection;

		Matcher ma = privatepatternSecretCookie.matcher(""+httpurlconnection.getURL().toString());
		while (ma.find()) {
			String cookieName = V2CHttpUtil.getSecretCookie(ma.group(1));
			if(cookieName.length() != 0){
				if (httpurlconnection != null) {
					String org = httpurlconnection.getHeaderField(s);
					Pattern patternSessionId = Pattern.compile(cookieName+"=([^;]+);");
					ma = patternSessionId.matcher(org);
					if(ma.find()){
						return httpurlconnection == null ? null : org.replace(ma.group(1), V2CHttpUtil.SecretCookie);
					}
				}
			}
		}
		
		return httpurlconnection == null ? null : httpurlconnection.getHeaderField(s);
	}

	public Map getAllResponseHeaders()
	{
		HttpURLConnection httpurlconnection = vHttpURLConnection;

		Matcher ma = privatepatternSecretCookie.matcher(""+httpurlconnection.getURL().toString());
		while (ma.find()) {
			String cookieName = V2CHttpUtil.getSecretCookie(ma.group(1));
			if(cookieName.length() != 0){
				Iterator localIterator;
				if (httpurlconnection != null) {
					Map filteredMap = new HashMap();
					localIterator = httpurlconnection.getHeaderFields().keySet().iterator();
					Pattern patternSessionId = Pattern.compile(cookieName+"=([^;]+);");
					while (localIterator.hasNext()) {
						String localObject2 = (String) localIterator.next();
						List<String> localObject3 = httpurlconnection.getHeaderFields().get(localObject2);
						List<String> newlocalObject3 = new ArrayList<String>();
						for(int i=0; i<localObject3.size(); i++){
							ma = patternSessionId.matcher(localObject3.get(i));
							if(ma.find()){
								newlocalObject3.add(localObject3.get(i).replace(ma.group(1), V2CHttpUtil.SecretCookie));
							}else{
								newlocalObject3.add(localObject3.get(i));
							}
						}
						filteredMap.put(localObject2, (List<String>) newlocalObject3);
					}
					return httpurlconnection == null ? null : filteredMap;
				}
			}
		}

		return httpurlconnection == null ? null : httpurlconnection.getHeaderFields();
	}

	public int getResponseCode()
	{
		HttpURLConnection httpurlconnection = vHttpURLConnection;
		try {
			return httpurlconnection == null ? -1 : httpurlconnection.getResponseCode();
		}
		catch (IOException ioexception) {
			return -1;
		}
	}

	public String getResponseMessage()
	{
		HttpURLConnection httpurlconnection = vHttpURLConnection;
		try {
			return httpurlconnection == null ? null : httpurlconnection.getResponseMessage();
		}
		catch (IOException ioexception) {
			return null;
		}
	}

	public String getContentType()
	{
		HttpURLConnection httpurlconnection = vHttpURLConnection;
		return httpurlconnection == null ? null : httpurlconnection.getContentType();
	}

	public long getDate()
	{
		HttpURLConnection httpurlconnection = vHttpURLConnection;
		return httpurlconnection == null ? 0L : httpurlconnection.getDate();
	}

	public long getLastModified()
	{
		HttpURLConnection httpurlconnection = vHttpURLConnection;
		return httpurlconnection == null ? 0L : httpurlconnection.getLastModified();
	}

	public void createCookieForScript(String s, String c)
	{
		V2CSecretCookieLS a = new V2CSecretCookieLS();
		String SecretCookie = a.loadSecretCookie(s);
		a = null;

		if(SecretCookie.length() != 0){
			Pattern p = Pattern
					.compile("^([^#]*)#" + s + ":([^#]+)#:=(.+)");
			Matcher ma = p.matcher(SecretCookie);
			while (ma.find()) {
				String remove = ma.group(1) + "#" + s + ":" + ma.group(2) + "#:=";
				SecretCookie = ma.group(2) + "=" + V2CHttpUtil.SecretCookie + ";";
				V2CScriptApp.putProperty(s + ":" + ma.group(2) , SecretCookie + " " + c);
				V2CHttpUtil.hmSecretCookies.put(s + ":" + ma.group(2), ma.group(3));

			}
			ma = null;
		}
	}
	
	private final URL vURL;
	private final String sPostData;
	private HashMap hmRequestProperty;
	private HttpURLConnection vHttpURLConnection;
	private byte blData[];
	private boolean bCompleted;

}
