package org.monazilla.v2c;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.*;
import javax.swing.*;

public class V2CScriptConsole implements ActionListener, WindowListener
{

	static synchronized void showConsole()
	{
		if (V2CApp.javaVersionLessThan(1, 5))
			return;
		V2CScriptConsole v2cscriptconsole = vScriptConsole;
		if (v2cscriptconsole == null) {
			v2cscriptconsole = new V2CScriptConsole();
			vScriptConsole = v2cscriptconsole;
		}
		v2cscriptconsole.showDialog();
	}

	static synchronized void appendText(String s)
	{
		V2CScriptConsole v2cscriptconsole = vScriptConsole;
		if (v2cscriptconsole != null)
			v2cscriptconsole.append(s);
	}

	public V2CScriptConsole()
	{
		JDialog jdialog = new JDialog(V2CMain.v2cMain, "スクリプトコンソール", false);
		jDialog = jdialog;
		jdialog.setDefaultCloseOperation(2);
		jdialog.addWindowListener(this);
		V2CTextArea v2ctextarea = new V2CTextArea("UnfocusableTextComponent");
		jTextArea = v2ctextarea;
		v2ctextarea.setEditable(false);
		JScrollPane jscrollpane = new JScrollPane(v2ctextarea);
		jscrollpane.setPreferredSize(new Dimension(400, 300));
		jdialog.add(jscrollpane);
		JButton jbutton = new JButton("クリア");
		jbutton.setFocusable(false);
		jbutton.addActionListener(this);
		jdialog.add(jbutton, "South");
	}

	void showDialog()
	{
		JDialog jdialog = jDialog;
		if (jdialog.isVisible()) {
			jdialog.toFront();
		}
		else {
			V2CPackedPropValue v2cpackedpropvalue = V2CApp.getUserProperty().getPackedValue("ScriptConsole.Conf");
			java.awt.Rectangle rectangle = v2cpackedpropvalue == null ? null : v2cpackedpropvalue.getRectangle('B');
			if (rectangle != null) {
				V2CSwingUtil.checkWindowPosition(rectangle);
				jdialog.setBounds(rectangle);
			}
			else {
				jdialog.pack();
			}
			jdialog.setVisible(true);
		}
	}

	void append(String s)
	{
		if (s == null || s.length() == 0)
			return;
		final StringBuffer sb = vStringBuffer;
		synchronized (sb) {
			boolean flag = sb.length() == 0;
			sb.append(s);
			if (SwingUtilities.isEventDispatchThread()) {
				jTextArea.append(sb.toString());
				sb.setLength(0);
			}
			else if (flag)
				EventQueue.invokeLater(new Runnable() {

					public void run()
					{
						synchronized (sb) {
							jTextArea.append(sb.toString());
							sb.setLength(0);
						}
					}
				});
		}
	}

	public void actionPerformed(ActionEvent actionevent)
	{
		jTextArea.setText("");
	}

	public void windowOpened(WindowEvent windowevent)
	{
	}

	public void windowClosing(WindowEvent windowevent)
	{
	}

	public void windowClosed(WindowEvent windowevent)
	{
		synchronized (org.monazilla.v2c.V2CScriptConsole.class) {
			vScriptConsole = null;
		}
		V2CPackedPropValue v2cpackedpropvalue = new V2CPackedPropValue();
		v2cpackedpropvalue.setRectangle('B', jDialog.getBounds());
		V2CApp.getUserProperty().putPackedValue("ScriptConsole.Conf", v2cpackedpropvalue);
	}

	public void windowIconified(WindowEvent windowevent)
	{
	}

	public void windowDeiconified(WindowEvent windowevent)
	{
	}

	public void windowActivated(WindowEvent windowevent)
	{
	}

	public void windowDeactivated(WindowEvent windowevent)
	{
	}

	private static final String sConfKey = "ScriptConsole.Conf";
	static V2CScriptConsole vScriptConsole;
	final JDialog jDialog;
	final JTextArea jTextArea;
	final StringBuffer vStringBuffer = new StringBuffer();
}
